% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{cadir-class}
\alias{cadir-class}
\title{An S4 class for the CA directional clustering.}
\description{
Class to store biclustering by directions results.
}
\section{Slots}{

\describe{
\item{\code{SNN}}{sparse shared nearest neighbours matrix. Values indicate the
jaccard similarity.}

\item{\code{eigen}}{matrix, Slot for storing eigenvectors from spectral clustering}

\item{\code{cell_prob}}{matrix. Matrix that stores the probabilities that
a cell belongs to a cluster. Only filled when running spectral clustering
with GMM.}

\item{\code{gene_prob}}{matrix. Matrix that stores the probabilities that
a gene belongs
to a cluster. Only filled when running spectral clustering with GMM.}

\item{\code{cell_idxs}}{integer. Indices of the cells in the SNN adjacency matrix.}

\item{\code{gene_idxs}}{integer. Indices of the genes in the SNN adjacency matrix.}

\item{\code{bimap}}{data.frame. Data frame storing the biMAP coordinates (x, y) and
the type (cell or gene) as well as the assigned clusters.}

\item{\code{cell_clusters}}{factors. The assigned cell clusters with cell names in
the names attribute.}

\item{\code{gene_clusters}}{factors. The assigned gene clusters with gene names in
the names attribute.}

\item{\code{directions}}{Matrix of directions by which the data was clustered.}

\item{\code{distances}}{Matrix of distances of points to the respective directions.}

\item{\code{parameters}}{List of used parameters and function name with which results}

\item{\code{log}}{This slot saves information during the clustering process,
such as the clusters at each iteration.}

\item{\code{plots}}{This slot saves the plots generated during
the clustering process.
were generated.}

\item{\code{gene_ranks}}{Ranks for all co-clustered genes.}

\item{\code{dict}}{A list that maps cluster names to the row of the corresponding
direction in @directions.}
}}

