% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celltype_anno.R
\name{annotate_biclustering,cadir-method}
\alias{annotate_biclustering,cadir-method}
\title{Annotate the biclustering}
\usage{
\S4method{annotate_biclustering}{cadir}(
  obj,
  universe,
  org,
  set = "CellMarker",
  alpha = 0.05,
  min_size = 10,
  max_size = 500,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{obj}{A cadir object, or,
alternatively a \code{caclust} or \code{SingleCellExperiment} object with biclustering
information.}

\item{universe}{All genes in data set.}

\item{org}{Short name of the organism. "mm" for mouse, "hs" for human.}

\item{set}{Name of the gene set. Currently only supports "CellMarker"}

\item{alpha}{Adjusted p-value cutoff.
Only results with padj < alpha will be used.}

\item{min_size}{Min. number of genes in the gene set.}

\item{max_size}{Max number of genes in the gene set.
Set to Inf if you want to keep all genes.}

\item{verbose}{Toggles verbosity of warnings.}

\item{...}{Further arguments.}
}
\description{
Annotate the biclustering
}
