// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by gnark DO NOT EDIT

package gkr

import (
	"fmt"
	"hash"
	"strings"

	"github.com/consensys/gnark-crypto/ecc/bn254/fr"
	"github.com/consensys/gnark-crypto/ecc/bn254/fr/polynomial"
	"github.com/consensys/gnark/internal/gkr/gkrtesting"
)

func toElement(i int64) *fr.Element {
	var res fr.Element
	res.SetInt64(i)
	return &res
}

func hashFromDescription(d gkrtesting.HashDescription) (hash.Hash, error) {
	if _type, ok := d["type"]; ok {
		switch _type {
		case "const":
			startState := int64(d["val"].(float64))
			return &messageCounter{startState: startState, step: 0, state: startState}, nil
		default:
			return nil, fmt.Errorf("unknown fake hash type \"%s\"", _type)
		}
	}
	return nil, fmt.Errorf("hash description missing type")
}

type messageCounter struct {
	startState int64
	state      int64
	step       int64
}

func (m *messageCounter) Write(p []byte) (n int, err error) {
	inputBlockSize := (len(p)-1)/fr.Bytes + 1
	m.state += int64(inputBlockSize) * m.step
	return len(p), nil
}

func (m *messageCounter) Sum(b []byte) []byte {
	inputBlockSize := (len(b)-1)/fr.Bytes + 1
	resI := m.state + int64(inputBlockSize)*m.step
	var res fr.Element
	res.SetInt64(int64(resI))
	resBytes := res.Bytes()
	return resBytes[:]
}

func (m *messageCounter) Reset() {
	m.state = m.startState
}

func (m *messageCounter) Size() int {
	return fr.Bytes
}

func (m *messageCounter) BlockSize() int {
	return fr.Bytes
}

func newMessageCounter(startState, step int) hash.Hash {
	transcript := &messageCounter{startState: int64(startState), state: int64(startState), step: int64(step)}
	return transcript
}

func newMessageCounterGenerator(startState, step int) func() hash.Hash {
	return func() hash.Hash {
		return newMessageCounter(startState, step)
	}
}

func setElement(z *fr.Element, value interface{}) (*fr.Element, error) {

	// TODO: Put this in element.SetString?
	switch v := value.(type) {
	case string:

		if sep := strings.Split(v, "/"); len(sep) == 2 {
			var denom fr.Element
			if _, err := z.SetString(sep[0]); err != nil {
				return nil, err
			}
			if _, err := denom.SetString(sep[1]); err != nil {
				return nil, err
			}
			denom.Inverse(&denom)
			z.Mul(z, &denom)
			return z, nil
		}

	case float64:
		asInt := int64(v)
		if float64(asInt) != v {
			return nil, fmt.Errorf("cannot currently parse float")
		}
		z.SetInt64(asInt)
		return z, nil
	}

	return z.SetInterface(value)
}

func sliceToElementSlice[T any](slice []T) ([]fr.Element, error) {
	elementSlice := make([]fr.Element, len(slice))
	for i, v := range slice {
		if _, err := setElement(&elementSlice[i], v); err != nil {
			return nil, err
		}
	}
	return elementSlice, nil
}

func sliceEquals(a []fr.Element, b []fr.Element) error {
	if len(a) != len(b) {
		return fmt.Errorf("length mismatch %d≠%d", len(a), len(b))
	}
	for i := range a {
		if !a[i].Equal(&b[i]) {
			return fmt.Errorf("at index %d: %s ≠ %s", i, a[i].String(), b[i].String())
		}
	}
	return nil
}

func polynomialSliceEquals(a []polynomial.Polynomial, b []polynomial.Polynomial) error {
	if len(a) != len(b) {
		return fmt.Errorf("length mismatch %d≠%d", len(a), len(b))
	}
	for i := range a {
		if err := sliceEquals(a[i], b[i]); err != nil {
			return fmt.Errorf("at index %d: %w", i, err)
		}
	}
	return nil
}
