// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by gnark DO NOT EDIT

package plonk

import (
	curve "github.com/consensys/gnark-crypto/ecc/bls12-377"

	"math/big"
	"math/rand"
	"testing"

	"github.com/consensys/gnark-crypto/ecc/bls12-377/fr"
	"github.com/consensys/gnark/io"

	"github.com/stretchr/testify/assert"
)

func TestProofSerialization(t *testing.T) {
	// create a  proof
	var proof Proof
	proof.randomize()

	assert.NoError(t, io.RoundTripCheck(&proof, func() interface{} { return new(Proof) }))
}

func TestProvingKeySerialization(t *testing.T) {
	// random pk
	var pk ProvingKey
	pk.randomize()

	assert.NoError(t, io.RoundTripCheck(&pk, func() interface{} { return new(ProvingKey) }))
}

func TestVerifyingKeySerialization(t *testing.T) {
	// create a random vk
	var vk VerifyingKey
	vk.randomize()

	assert.NoError(t, io.RoundTripCheck(&vk, func() interface{} { return new(VerifyingKey) }))
}

func (pk *ProvingKey) randomize() {

	var vk VerifyingKey
	vk.randomize()
	pk.Vk = &vk

	pk.Kzg.G1 = make([]curve.G1Affine, 32)
	pk.KzgLagrange.G1 = make([]curve.G1Affine, 32)
	for i := range pk.Kzg.G1 {
		pk.Kzg.G1[i] = randomG1Point()
		pk.KzgLagrange.G1[i] = randomG1Point()
	}

}

func (vk *VerifyingKey) randomize() {
	vk.Size = rand.Uint64() //#nosec G404 weak rng is fine here
	vk.SizeInv.SetRandom()
	vk.Generator.SetRandom()
	vk.NbPublicVariables = rand.Uint64()                     //#nosec G404 weak rng is fine here
	vk.CommitmentConstraintIndexes = []uint64{rand.Uint64()} //#nosec G404 weak rng is fine here
	vk.CosetShift.SetRandom()

	vk.S[0] = randomG1Point()
	vk.S[1] = randomG1Point()
	vk.S[2] = randomG1Point()

	vk.Kzg.G1 = randomG1Point()
	vk.Kzg.G2[0] = randomG2Point()
	vk.Kzg.G2[1] = randomG2Point()

	vk.Ql = randomG1Point()
	vk.Qr = randomG1Point()
	vk.Qm = randomG1Point()
	vk.Qo = randomG1Point()
	vk.Qk = randomG1Point()
	vk.Qcp = randomG1Points(rand.Intn(4)) //#nosec G404 weak rng is fine here
}

func (proof *Proof) randomize() {
	proof.LRO[0] = randomG1Point()
	proof.LRO[1] = randomG1Point()
	proof.LRO[2] = randomG1Point()
	proof.Z = randomG1Point()
	proof.H[0] = randomG1Point()
	proof.H[1] = randomG1Point()
	proof.H[2] = randomG1Point()
	proof.BatchedProof.H = randomG1Point()
	proof.BatchedProof.ClaimedValues = randomScalars(2)
	proof.ZShiftedOpening.H = randomG1Point()
	proof.ZShiftedOpening.ClaimedValue.SetRandom()
	proof.Bsb22Commitments = randomG1Points(rand.Intn(4)) //#nosec G404 weak rng is fine here
}

func randomG2Point() curve.G2Affine {
	_, _, _, r := curve.Generators()
	r.ScalarMultiplication(&r, big.NewInt(int64(rand.Uint64()))) //#nosec G404 weak rng is fine here
	return r
}

func randomG1Point() curve.G1Affine {
	_, _, r, _ := curve.Generators()
	r.ScalarMultiplication(&r, big.NewInt(int64(rand.Uint64()))) //#nosec G404 weak rng is fine here
	return r
}

func randomG1Points(n int) []curve.G1Affine {
	res := make([]curve.G1Affine, n)
	for i := range res {
		res[i] = randomG1Point()
	}
	return res
}

func randomScalars(n int) []fr.Element {
	v := make([]fr.Element, n)
	one := fr.One()
	for i := 0; i < len(v); i++ {
		if i == 0 {
			v[i].SetRandom()
		} else {
			v[i].Add(&v[i-1], &one)
		}
	}
	return v
}
