# Commonly used terms

```{glossary}
Actor
    A person, organization, or system that has one or more {ref}`roles <satre_roles>` that initiates or interacts with activities.
    Example: _The SATRE architecture needs actors such as {ref}`data analysts <project_roles>` and internal auditors._

Application component
    An encapsulation of application functionality which is modular and replaceable.
    Example: _To perform work within a TRE a {ref}`data analyst <project_roles>` might need access to a Desktop or command line interface application component._

Architectural principle
    Fundamental guidelines that inform the design, decision making and implementation of a TRE.
    These principles provide a framework to ensure that the design of the underlying components of a TRE are aligned to consistent goals, values and best practices.

Business process
    A set of actions which produce a specific desired outcome.
    Example: _to access the TRE a {ref}`data consumer <project_roles>` needs to complete an onboarding business process._

Capability
    An ability that a system possesses.
    Capabilities are typically expressed in general and high-level terms.
    Achieving a capability typically requires a combination of organisation, people, processes, and technology.

Capability decomposition
    A set of {term}`components <component>` that realise a capability.
    These components will vary depending on the nature of the capability.
    Business-focused capabilities will be realised by {term}`business processes <business process>`, {term}`roles <role>` and services.
    Technology-focused capabilities will be realised by {term}`applications <application component>`, services and interfaces.
    In addition to the components realising the capability, a catalogue of standards, frameworks and controls linked to the capabilities will provide guidance on how to implement the capabilities safely.

Component
    The statements concerning processes, controls, practices and applications that make up a {term}`capability <capability>`, together with an importance label.

Data Object
    A store of data or information.
    For example: to know what data is stored within the TRE a study database data object is needed.
    This contains information on the data assets within the TRE, who owns them and other compliance information.

Role
    A role is a set of connected behaviors, rights, obligations and norms within a TRE system.
    {ref}`Roles <satre_roles>` are occupied by individuals, who are called {term}`actors <actor>`.

Specification pillar
    A specification pillar is a group of related capabilities.
    SATRE has four specification pillars: Information governance, Computing technology, Data management and Supporting Capabilities.

Trusted Research Environment (TRE)
    A Trusted Research Environment.
    See our {ref}`FAQs page <what_tre>`.

TRE organisation
    A TRE organisation is the set of people, processes and technology that operate and use a particular TRE.
```
