# SATRE Specification Repository: Technical Document for the Standard Architecture for Trusted Research Environments Project

<!-- prettier-ignore-start -->
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-41-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
<!-- prettier-ignore-end -->

[![Slack](https://img.shields.io/badge/Slack-Join%20Our%20Channel-blue?logo=slack&style=flat-square)](https://ukrse.slack.com/archives/rse-tre-wg)
[![Licence](https://img.shields.io/github/license/sa-tre/satre-specification?style=flat-square)](https://github.com/sa-tre/satre-specification/blob/main/LICENSE.md)
[![CoC](https://img.shields.io/badge/Code%20of%20Conduct-Contributor%20Covenant-blue?style=flat-square)](https://github.com/sa-tre/satre-specification/blob/main/CODE_OF_CONDUCT.md)
[![Docs](https://img.shields.io/readthedocs/satre-specification?label=build&style=flat-square)](https://satre-specification.readthedocs.io/en/latest/)

**[The specification is a living document hosted here on our Read the Docs site](https://satre-specification.readthedocs.io/en/latest/)**.
To contribute to SATRE see https://satre-specification.readthedocs.io/en/latest/contributing/

Welcome to the SATRE Specification Repository!
This repository stores the technical documents that outlines a reference architecture for Trusted Research Environments.
**By October 2023** we will aim to have drafted the document with input from members of the Systems Architecture, Research Software Engineering and Cyber Security community, with core support from DARE UK funded project members as part of a collaborative effort between the University of Dundee, Ulster University, UCL, Health Data Research UK, The Alan Turing Institute and Research Data Scotland.

If you have experience designing or using Trusted/Secure Research Environments and want to get involved in developing a reference architecture for UK TREs then please read on to find out how you can contribute.

## Overview of the SATRE Project

The need for trusted research environments (TREs) is clear.
Personal or sensitive data which have been collected for operational, commercial or governmental reasons need to be managed securely and safely for research use in an environment that encourages best practice.
TREs are designed to enable access to sensitive data only for authorised projects and data consumers, whilst minimising risk of data release or exposure.
Influential reports from DARE UK and Health Data Research UK, together with the UK Government Goldacre review and ‘Data Saves Lives’ policy paper, have all highlighted the need for change in how sensitive data are handled.

SATRE will compare openly available UK TREs hosting health, manufacturing, commercial, science and humanities data and bring them into alignment with a standardised TRE reference architecture (or structural template).
The development teams at the University of Dundee’s Health Informatics Centre and the Alan Turing Institute, fully supported by their infrastructure partners, will lead the reference alignment in collaboration with a consortium of higher education, charity and industry organisations.

The reference architecture and its implementation will be informed and strengthened by a programme of community building and engagement with DARE UK and partner working groups, other stakeholders and inclusive public representation.
SATRE outputs will include an informed TRE reference technical specification and a collection of educational media and detailed reports – all supporting DARE UK’s aim of a coordinated national data research infrastructure.

## Community-Driven Approach

[![Slack](https://img.shields.io/badge/Slack-Join%20Our%20Channel-blue?logo=slack&style=flat-square)](https://ukrse.slack.com/archives/rse-tre-wg)

The SATRE project values the importance of equity, diversity, and inclusion (EDI) in fostering a kind and supportive environment for all participants.
We are committed to making the project as inclusive as possible and appreciate the unique perspectives and input that each community member brings.

While there are core members funded by DARE to contribute to this project, our primary goal is to involve as many members of the community as possible.
We strongly believe that the best results come from collaboration, diverse perspectives, and fostering a culture of kindness and mutual respect.

## Getting Started

There are a number of ways you can get involved with the SATRE project!

1. **Collaborate with us**: We are running collaborative sessions for the duration of the project you can get involved with!

| Meeting                      | Description                                                                                                                                   | Time                                            | Link                                              |
| ---------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------- | ------------------------------------------------- |
| Bi-weekly Collaboration Cafe | An open meeting for anyone interested in discussing & contributing to the project to work collaboratively with the team, community and others | Every 1st Tuesday and 3rd Thursday of the month | [Calendar](https://hackmd.io/@harisood/SyKjKcKZn) |

2. **Contribute**: Review open issues, join SATRE meetings, and provide your input on the design, implementation, and best practices for TREs. To contribute to the project, please join discussions on open issues to help guide content for the documentation.
   If you have a specific idea or proposal, feel free to open a new issue or start a GitHub Discussions thread.
   Currently we are writing documentation in `.md` files and will decide on a more refined documentation format with the Community.
3. **Sign up to our contact list**: You can sign up by filling in [this short form](https://forms.office.com/e/FuFyNGx3hw).
   Sign up for updates about the project, further invitations to workshops & roundtables, and opportunities for feedback & knowledge sharing :sparkles:

4. **Join the RSE TRE community**: The RSE TRE community was established at RSE Con in September 2022, and brings together those building, using, operating and generally affected by and interested in TREs together to solve common challenges and share knowledge. You can register for the JISC mailing list [by following this link](https://www.jiscmail.ac.uk/cgi-bin/wa-jisc.exe?SUBED1=RSE-TRE-COMM&A=1)

## Code of Conduct and Inclusivity

The SATRE project is committed to fostering an inclusive, equitable, and respectful environment for all participants.
Please review our [Code of Conduct](CODE_OF_CONDUCT.md) to ensure that your interactions with the community align with our values and expectations.
We encourage everyone to contribute to creating a kind and supportive atmosphere, appreciating each community member's input.

## License

The content of this repository is licensed under the [Creative Commons License](LICENSE.md).

## Contact

For any questions or concerns, please reach out to SATRE project team member [Hari Sood](mailto:hsood@turing.ac.uk).

We look forward to your participation and contributions to the SATRE project, as we work together to build a standard architecture for Trusted Research Environments in an inclusive and supportive environment!

## Building the Specification Document

Instructions for building the specification document locally can be found [here](docs/README.md#building-the-specification-document).

## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/verdurin"><img src="https://avatars.githubusercontent.com/u/12435?v=4?s=100" width="100px;" alt="Adam Huffman"/><br /><sub><b>Adam Huffman</b></sub></a><br /><a href="#ideas-verdurin" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://cls.ucl.ac.uk/"><img src="https://avatars.githubusercontent.com/u/105370564?v=4?s=100" width="100px;" alt="Aida Sanchez"/><br /><sub><b>Aida Sanchez</b></sub></a><br /><a href="#ideas-rmjdasp" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nercdsp"><img src="https://avatars.githubusercontent.com/u/106550288?v=4?s=100" width="100px;" alt="Andy Shepherd"/><br /><sub><b>Andy Shepherd</b></sub></a><br /><a href="#ideas-nercdsp" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/antonychuter"><img src="https://avatars.githubusercontent.com/u/130052215?v=4?s=100" width="100px;" alt="Antony Chuter"/><br /><sub><b>Antony Chuter</b></sub></a><br /><a href="#ideas-antonychuter" title="Ideas, Planning, & Feedback">🤔</a> <a href="#content-antonychuter" title="Content">🖋</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/arronlacey"><img src="https://avatars.githubusercontent.com/u/4941299?v=4?s=100" width="100px;" alt="Arron Lacey"/><br /><sub><b>Arron Lacey</b></sub></a><br /><a href="#content-arronlacey" title="Content">🖋</a> <a href="#ideas-arronlacey" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/sa-tre/satre-specification/pulls?q=is%3Apr+reviewed-by%3Aarronlacey" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/CaroleGoble"><img src="https://avatars.githubusercontent.com/u/7300655?v=4?s=100" width="100px;" alt="Carole Goble"/><br /><sub><b>Carole Goble</b></sub></a><br /><a href="#ideas-CaroleGoble" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/CLStables"><img src="https://avatars.githubusercontent.com/u/41384929?v=4?s=100" width="100px;" alt="Catherine Stables"/><br /><sub><b>Catherine Stables</b></sub></a><br /><a href="#ideas-CLStables" title="Ideas, Planning, & Feedback">🤔</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://www.dundee.ac.uk/people/christian-cole"><img src="https://avatars.githubusercontent.com/u/6098785?v=4?s=100" width="100px;" alt="Chris Cole"/><br /><sub><b>Chris Cole</b></sub></a><br /><a href="#ideas-drchriscole" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://keepfaking.it"><img src="https://avatars.githubusercontent.com/u/68136?v=4?s=100" width="100px;" alt="Cian O'Donovan"/><br /><sub><b>Cian O'Donovan</b></sub></a><br /><a href="#ideas-cianodonovan" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/claire-merida"><img src="https://avatars.githubusercontent.com/u/143812887?v=4?s=100" width="100px;" alt="Claire MacDonald"/><br /><sub><b>Claire MacDonald</b></sub></a><br /><a href="#ideas-claire-merida" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/dbretherton"><img src="https://avatars.githubusercontent.com/u/77013358?v=4?s=100" width="100px;" alt="Dan Bretherton"/><br /><sub><b>Dan Bretherton</b></sub></a><br /><a href="#ideas-dbretherton" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://edchalstrey.com/"><img src="https://avatars.githubusercontent.com/u/5486164?v=4?s=100" width="100px;" alt="Ed Chalstrey"/><br /><sub><b>Ed Chalstrey</b></sub></a><br /><a href="https://github.com/sa-tre/satre-specification/commits?author=edwardchalstrey1" title="Code">💻</a> <a href="#content-edwardchalstrey1" title="Content">🖋</a> <a href="#ideas-edwardchalstrey1" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-edwardchalstrey1" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/sa-tre/satre-specification/pulls?q=is%3Apr+reviewed-by%3Aedwardchalstrey1" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/EmilyJefferson"><img src="https://avatars.githubusercontent.com/u/52530506?v=4?s=100" width="100px;" alt="EmilyJefferson"/><br /><sub><b>EmilyJefferson</b></sub></a><br /><a href="#ideas-EmilyJefferson" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/EmmaJaneLoveridge"><img src="https://avatars.githubusercontent.com/u/142997763?v=4?s=100" width="100px;" alt="EmmaJaneLoveridge"/><br /><sub><b>EmmaJaneLoveridge</b></sub></a><br /><a href="#ideas-EmmaJaneLoveridge" title="Ideas, Planning, & Feedback">🤔</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/FatemehTorabi"><img src="https://avatars.githubusercontent.com/u/42776946?v=4?s=100" width="100px;" alt="Fatemeh Torabi"/><br /><sub><b>Fatemeh Torabi</b></sub></a><br /><a href="#ideas-FatemehTorabi" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://about.me/jsutherland"><img src="https://avatars.githubusercontent.com/u/9466?v=4?s=100" width="100px;" alt="James A Sutherland"/><br /><sub><b>James A Sutherland</b></sub></a><br /><a href="#ideas-jas88" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jemrobinson"><img src="https://avatars.githubusercontent.com/u/3502751?v=4?s=100" width="100px;" alt="James Robinson"/><br /><sub><b>James Robinson</b></sub></a><br /><a href="#content-jemrobinson" title="Content">🖋</a> <a href="#design-jemrobinson" title="Design">🎨</a> <a href="#ideas-jemrobinson" title="Ideas, Planning, & Feedback">🤔</a> <a href="#projectManagement-jemrobinson" title="Project Management">📆</a> <a href="https://github.com/sa-tre/satre-specification/pulls?q=is%3Apr+reviewed-by%3Ajemrobinson" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/JenDaub"><img src="https://avatars.githubusercontent.com/u/42603409?v=4?s=100" width="100px;" alt="JenDaub"/><br /><sub><b>JenDaub</b></sub></a><br /><a href="#ideas-JenDaub" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/JillB19"><img src="https://avatars.githubusercontent.com/u/129426057?v=4?s=100" width="100px;" alt="Jillian Beggs"/><br /><sub><b>Jillian Beggs</b></sub></a><br /><a href="#ideas-JillB19" title="Ideas, Planning, & Feedback">🤔</a> <a href="#content-JillB19" title="Content">🖋</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/JimMadge"><img src="https://avatars.githubusercontent.com/u/23616154?v=4?s=100" width="100px;" alt="Jim Madge"/><br /><sub><b>Jim Madge</b></sub></a><br /><a href="#ideas-JimMadge" title="Ideas, Planning, & Feedback">🤔</a> <a href="#content-JimMadge" title="Content">🖋</a> <a href="#infra-JimMadge" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/sa-tre/satre-specification/commits?author=JimMadge" title="Code">💻</a> <a href="https://github.com/sa-tre/satre-specification/pulls?q=is%3Apr+reviewed-by%3AJimMadge" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/sa-tre/satre-specification/issues?q=author%3AJimMadge" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Latham-Mollart"><img src="https://avatars.githubusercontent.com/u/142893449?v=4?s=100" width="100px;" alt="John Latham-Mollart"/><br /><sub><b>John Latham-Mollart</b></sub></a><br /><a href="#ideas-Latham-Mollart" title="Ideas, Planning, & Feedback">🤔</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/KatherineOSullivan-DaSH"><img src="https://avatars.githubusercontent.com/u/143399611?v=4?s=100" width="100px;" alt="KatherineOSullivan-DaSH"/><br /><sub><b>KatherineOSullivan-DaSH</b></sub></a><br /><a href="#ideas-KatherineOSullivan-DaSH" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Katie-RDS"><img src="https://avatars.githubusercontent.com/u/129854538?v=4?s=100" width="100px;" alt="Katie-RDS"/><br /><sub><b>Katie-RDS</b></sub></a><br /><a href="#ideas-Katie-RDS" title="Ideas, Planning, & Feedback">🤔</a> <a href="#content-Katie-RDS" title="Content">🖋</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://keiranmraine.github.io/"><img src="https://avatars.githubusercontent.com/u/3740323?v=4?s=100" width="100px;" alt="Keiran Raine"/><br /><sub><b>Keiran Raine</b></sub></a><br /><a href="#ideas-keiranmraine" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lucycheesman"><img src="https://avatars.githubusercontent.com/u/66006335?v=4?s=100" width="100px;" alt="Lucy"/><br /><sub><b>Lucy</b></sub></a><br /><a href="#ideas-lucycheesman" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MKDonnees"><img src="https://avatars.githubusercontent.com/u/2377239?v=4?s=100" width="100px;" alt="Martin Donnelly"/><br /><sub><b>Martin Donnelly</b></sub></a><br /><a href="#ideas-MKDonnees" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/craddm"><img src="https://avatars.githubusercontent.com/u/5796417?v=4?s=100" width="100px;" alt="Matt Craddock"/><br /><sub><b>Matt Craddock</b></sub></a><br /><a href="#ideas-craddm" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/sa-tre/satre-specification/pulls?q=is%3Apr+reviewed-by%3Acraddm" title="Reviewed Pull Requests">👀</a> <a href="#content-craddm" title="Content">🖋</a> <a href="https://github.com/sa-tre/satre-specification/issues?q=author%3Acraddm" title="Bug reports">🐛</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mikelayuk"><img src="https://avatars.githubusercontent.com/u/81355102?v=4?s=100" width="100px;" alt="Michael Lay"/><br /><sub><b>Michael Lay</b></sub></a><br /><a href="#ideas-mikelayuk" title="Ideas, Planning, & Feedback">🤔</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nels"><img src="https://avatars.githubusercontent.com/u/513507?v=4?s=100" width="100px;" alt="Nel Swanepoel"/><br /><sub><b>Nel Swanepoel</b></sub></a><br /><a href="#ideas-nels" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rmbaxter67"><img src="https://avatars.githubusercontent.com/u/125452191?v=4?s=100" width="100px;" alt="Rob Baxter"/><br /><sub><b>Rob Baxter</b></sub></a><br /><a href="#ideas-rmbaxter67" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.flickr.com/photos/manicstreetpreacher/"><img src="https://avatars.githubusercontent.com/u/1644105?v=4?s=100" width="100px;" alt="Simon Li"/><br /><sub><b>Simon Li</b></sub></a><br /><a href="#content-manics" title="Content">🖋</a> <a href="#ideas-manics" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/sa-tre/satre-specification/pulls?q=is%3Apr+reviewed-by%3Amanics" title="Reviewed Pull Requests">👀</a> <a href="#infra-manics" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/sa-tre/satre-specification/commits?author=manics" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/snewho"><img src="https://avatars.githubusercontent.com/u/53340893?v=4?s=100" width="100px;" alt="Steven Newhouse"/><br /><sub><b>Steven Newhouse</b></sub></a><br /><a href="#ideas-snewho" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/briancrogers"><img src="https://avatars.githubusercontent.com/u/15003276?v=4?s=100" width="100px;" alt="briancrogers"/><br /><sub><b>briancrogers</b></sub></a><br /><a href="#ideas-briancrogers" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/crickpetebarnsley"><img src="https://avatars.githubusercontent.com/u/56251897?v=4?s=100" width="100px;" alt="crickpetebarnsley"/><br /><sub><b>crickpetebarnsley</b></sub></a><br /><a href="#ideas-crickpetebarnsley" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Davsarper"><img src="https://avatars.githubusercontent.com/u/118986872?v=4?s=100" width="100px;" alt="davsarper"/><br /><sub><b>davsarper</b></sub></a><br /><a href="#content-davsarper" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/fadeniyi123"><img src="https://avatars.githubusercontent.com/u/91486205?v=4?s=100" width="100px;" alt="fadeniyi123"/><br /><sub><b>fadeniyi123</b></sub></a><br /><a href="#ideas-fadeniyi123" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/harisood"><img src="https://avatars.githubusercontent.com/u/67151373?v=4?s=100" width="100px;" alt="harisood"/><br /><sub><b>harisood</b></sub></a><br /><a href="#content-harisood" title="Content">🖋</a> <a href="#ideas-harisood" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/sa-tre/satre-specification/pulls?q=is%3Apr+reviewed-by%3Aharisood" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jawsgrant"><img src="https://avatars.githubusercontent.com/u/105919569?v=4?s=100" width="100px;" alt="jawsgrant"/><br /><sub><b>jawsgrant</b></sub></a><br /><a href="#ideas-jawsgrant" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/machintim"><img src="https://avatars.githubusercontent.com/u/86052684?v=4?s=100" width="100px;" alt="machintim"/><br /><sub><b>machintim</b></sub></a><br /><a href="#ideas-machintim" title="Ideas, Planning, & Feedback">🤔</a> <a href="#content-machintim" title="Content">🖋</a> <a href="https://github.com/sa-tre/satre-specification/pulls?q=is%3Apr+reviewed-by%3Amachintim" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/willc-RISG"><img src="https://avatars.githubusercontent.com/u/100122086?v=4?s=100" width="100px;" alt="willc-RISG"/><br /><sub><b>willc-RISG</b></sub></a><br /><a href="#ideas-willc-RISG" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ywharton"><img src="https://avatars.githubusercontent.com/u/12757716?v=4?s=100" width="100px;" alt="ywharton"/><br /><sub><b>ywharton</b></sub></a><br /><a href="https://github.com/sa-tre/satre-specification/issues?q=author%3Aywharton" title="Bug reports">🐛</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

And to the following contributors:

- Allison Noble, Information Governance Officer, Research Data Scotland
- Jackie Caldwell, Scottish Medical Imaging Strategic Lead, Pubic Health Scotland
- Laura McKernan Ward, Project Manager (Trusted Research Environment), University of Dundee, Health Informatics Centre
