%Program to compute pairwise adaptation / adapting to composite (two-dimensional)
clear all

%% Specify the variance covariance matris

YR = [793.587 1361.759]; VR = [616.7395^2 740.5698^2];
% estimates based on subsamples of etpteacher==0 and etpteacher==1
YU = [1794.342  1794.342]; VU = [667.8492^2 667.8492^2];
VUR = [sqrt(VU(1)*VR(1))*0.7694 sqrt(VU(2)*VR(2))*0.5668];
VR1R2=sqrt(VR(1)*VR(2))*0.7502;
disp("The relative risk at b=0 is")
VR./VU
YO = YR - YU;
VO = VR - 2*VUR + VU;
VUO = (VUR - VU);
disp('The over-id test statistic is')
tO = YO./sqrt(VO);
disp(tO)
disp('The efficient estimator and their standard error is; and the rel. risk is')
GMM = YU - VUO./VO .* YO;   V_GMM = VU - VUO.^2./VO;  
disp(GMM)
disp(V_GMM.^(0.5))
disp(V_GMM./VU)
disp('The correlation coefficient is')
corr = VUO./sqrt(VO)./sqrt(VU);
disp(corr)

VR1 = 616.7395^2; VR2=740.5698^2;
VO1 = VR(1) - 2*VUR(1) + VU(1); VUO1 = (VUR(1) - VU(1));
VO2 = VR(2) - 2*VUR(2) + VU(1); VUO2 = (VUR(2) - VU(1));
VO1O2 = VR1R2-VUR(1) - VUR(2) +VU(1);

Sigma = [VU(1) VUO1 VUO2; VUO1 VO1 VO1O2; VUO2 VO1O2 VO2];
% Sigma = Sigma./VU;  
 
det(Sigma)
Sigma_U = Sigma(1,1);
Sigma_UO = Sigma(1,2:end);
Sigma_O = Sigma(2:end,2:end);
 
%% Read in the lookup function that computes the adaptive estimates
% will write to tables/ a formatted table for each parameter
addpath('../Matlab/')

%% For YR1

[results_scale_minimax,results_scale_bickel] = adaptive_estimate(YR(1),YU(1),VR(1),VU(1),VUR(1),9,corr(1))
% plot risk functions
% adaptive_plot(YR(1),YU(1),VR(1),VU(1),VUR(1),9,corr(1))

% plot minimax locus
% minimax_locus_plot(YR(1),YU(1),VR(1),VU(1),VUR(1),9,corr(1))

% plot priors
% minimax_prior_plot(YR(1),YU(1),VR(1),VU(1),VUR(1),9,corr(1))

%% adaptation penalty relative to the trivariate case
Sigma_UO_grid = abs(tanh((-3:0.05:-0.05))); 
load('../Matlab/sim_results/risk.mat');
load('../Matlab/sim_results/risk_thresholds.mat');
Kb = length(b_grid);  risk_function_adaptive = zeros(Kb,1);
risk_function_bimodal = zeros(Kb,1);
risk_function_adaptive_st_bimodal = zeros(Kb,1);

for i = 1:Kb
   risk_function_adaptive(i) = VUO(1)^2/VO(1)*interp1(Sigma_UO_grid,risk_mat(i,:),abs(corr(1)),'spline');
   risk_function_bimodal(i) = VUO(1)^2/VO(1)*interp1(Sigma_UO_grid,risk_bimodal_mat(i,:),abs(corr(1)),'spline');
   risk_function_adaptive_st_bimodal(i) = ...
                   VUO(1)^2/VO(1)*interp1(Sigma_UO_grid,risk_st_bimodal_mat(i,:),abs(corr(1)),'spline');

end
sims = 100000;
rng(1,'twister');
x = normrnd(0,1,[sims,1]);
x_b = x*ones(1,Kb) + ones(sims,1)*b_grid';
Ebsims_ht = @(l) sum(((x_b > l).*x_b + (x_b < l & x_b > -l)*(1+ VO(1)/VUO(1)).*x_b + (x_b < -l).*x_b...
-ones(sims,1)*b_grid').^2,1)/sims;
risk_function_ht_ttest =  VUO(1)^2/VO(1)*(Ebsims_ht(1.96) + 1/corr(1)^2- 1)';

risk_trivariate = ones(Kb,1)*Sigma_U-Sigma_UO(2)*(Sigma_O(2,2)\Sigma_UO(2)); % for (B_1 0) can adapt to GMM2
risk_trivariate(b_grid == 0) = Sigma_U-Sigma_UO*(Sigma_O\Sigma_UO'); % for (0 0) can adapt to GMM3

max(risk_function_bimodal./risk_trivariate)
max(risk_function_adaptive_st_bimodal./risk_trivariate)
max(risk_function_ht_ttest./risk_trivariate)
%% Export the results for Table A2 panel a

fid = fopen(strcat('../../tables/tableA2a.tex'),'w'); 
fprintf(fid, '%s\n',' & $Y_{U}$ & $Y_{R}$ &  $GMM $ & Adaptive & Soft-threshold & Pre-test');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Estimate & %4.2f  & %4.2f & %4.2f  & %4.2f& %4.2f& %4.2f   \n',...
    YU(1),YR(1),YU(1) - VUO(1)/VO(1)* YO(1), results_scale_bickel(1),  results_scale_bickel(4), results_scale_bickel(10) );
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Std error & %4.2f  & %4.2f  & %4.2f  &   &   & & \n',...
    sqrt(VU(1)),sqrt(VR(1)), sqrt(VU(1) - VUO(1)^2/VO(1)) );

fprintf(fid, '%s\n', '\hline');
fprintf(fid, '%s\n', 'Risk rel. to $Y_U$ &&&&&&');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'when $b_{1}=0$  & 1 &  %4.3f  &  %4.3f  &  %4.3f &  %4.3f  &  %4.3f \n', ...
    VR(1)/VU(1),(VU(1) - VUO(1)^2/VO(1))/VU(1),risk_function_bimodal(b_grid==0)/VU(1),...
    risk_function_adaptive_st_bimodal(b_grid==0)/VU(1), risk_function_ht_ttest(b_grid==0)/VU(1));
fprintf(fid, '%s\n', '\hline');

fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'when $b_{1}!=0$  & 1 &  %s   &  %s  &  %4.3f &  %4.3f  &  %4.3f \n', ...
     '$\infty$', '$\infty$',max(risk_function_bimodal)/VU(1),...
    max(risk_function_adaptive_st_bimodal)/VU(1), max(risk_function_ht_ttest)/VU(1));
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Max Regret & %4.3f  &  %s  & %s&   %4.4f & %4.4f& %4.4f\n',...
    VU(1)/(VU(1) - VUO(1)^2/VO(1))-1, '$\infty$', '$\infty$',  results_scale_bickel(2)-1,...
    results_scale_bickel(5)-1, results_scale_bickel(11)-1 );

fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Max Regret rel. to multivariate & %4.3f  &  %s  & %s&   %4.4f & %4.4f& %4.4f\n',...
    VU(1)/risk_trivariate(b_grid == 0)-1, '$\infty$', '$\infty$',  max(risk_function_bimodal./risk_trivariate)-1,...
    max(risk_function_adaptive_st_bimodal./risk_trivariate)-1, max(risk_function_ht_ttest./risk_trivariate)-1);

fprintf(fid, '%s\n', '\hline');

 fprintf(fid, 'Threshold &  &    &  &   & %4.4f& %4.4f\n',...
   results_scale_bickel(6), 1.96);
fclose(fid);
%% For YR2
[results_scale_minimax,results_scale_bickel] = adaptive_estimate(YR(2),YU(2),VR(2),VU(2),VUR(2),9,corr(2))
% adaptive_plot(YR(2),YU(2),VR(2),VU(2),VUR(2),9,corr(2))

% adaptation penalty relative to the trivariate case
Sigma_UO_grid = abs(tanh((-3:0.05:-0.05))); 
load('../Matlab/sim_results/risk.mat');
Kb = length(b_grid);  risk_function_adaptive = zeros(Kb,1);
risk_function_bimodal = zeros(Kb,1);             
risk_function_adaptive_st_bimodal = zeros(Kb,1);

for i = 1:Kb
   risk_function_adaptive(i) = VUO(2)^2/VO(2)*interp1(Sigma_UO_grid,risk_mat(i,:),abs(corr(2)),'spline');
   risk_function_bimodal(i) = VUO(2)^2/VO(2)*interp1(Sigma_UO_grid,risk_bimodal_mat(i,:),abs(corr(2)),'spline');
   risk_function_adaptive_st_bimodal(i) = ...
                   VUO(2)^2/VO(2)*interp1(Sigma_UO_grid,risk_st_bimodal_mat(i,:),abs(corr(2)),'spline');

end
sims = 100000;
rng(1,'twister');
x = normrnd(0,1,[sims,1]);
x_b = x*ones(1,Kb) + ones(sims,1)*b_grid';
Ebsims_ht = @(l) sum(((x_b > l).*x_b + (x_b < l & x_b > -l)*(1+ VO(2)/VUO(2)).*x_b + (x_b < -l).*x_b...
-ones(sims,1)*b_grid').^2,1)/sims;
risk_function_ht_ttest =  VUO(2)^2/VO(2)*(Ebsims_ht(1.96) + 1/corr(2)^2- 1)';

risk_trivariate = ones(Kb,1)*Sigma_U; % for (B_1 0) can adapt to GMM2
risk_trivariate(b_grid == 0) = Sigma_U-Sigma_UO*(Sigma_O\Sigma_UO'); % for (0 0) can adapt to GMM3

max(risk_function_bimodal./risk_trivariate)
max(risk_function_adaptive_st_bimodal./risk_trivariate)
max(risk_function_ht_ttest./risk_trivariate)
%% Export the results for Table A2 panel b

fid = fopen(strcat('../../tables/tableA2b.tex'),'w'); 
fprintf(fid, '%s\n',' & $Y_{U}$ & $Y_{R}$ &  $GMM $ & Adaptive & Soft-threshold & Pre-test');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Estimate & %4.2f  & %4.2f & %4.2f  & %4.2f& %4.2f& %4.2f   \n',...
    YU(2),YR(2),YU(2) - VUO(2)/VO(2)* YO(2), results_scale_bickel(1),  results_scale_bickel(4), results_scale_bickel(10) );
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Std error & %4.2f  & %4.2f  & %4.2f  &   &   & & \n',...
    sqrt(VU(2)),sqrt(VR(2)), sqrt(VU(2) - VUO(2)^2/VO(2)) );

fprintf(fid, '%s\n', '\hline');
fprintf(fid, '%s\n', 'Risk rel. to $Y_U$ &&&&&&');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'when $b_{1}=0$  & 1 &  %4.3f  &  %4.3f  &  %4.3f &  %4.3f  &  %4.3f \n', ...
    VR(2)/VU(2),(VU(2) - VUO(2)^2/VO(2))/VU(2),risk_function_bimodal(b_grid==0)/VU(2),...
    risk_function_adaptive_st_bimodal(b_grid==0)/VU(2), risk_function_ht_ttest(b_grid==0)/VU(2));
fprintf(fid, '%s\n', '\hline');

fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'when $b_{1}!=0$  & 1 &  %s   &  %s  &  %4.3f &  %4.3f  &  %4.3f \n', ...
     '$\infty$', '$\infty$',max(risk_function_bimodal)/VU(2),...
    max(risk_function_adaptive_st_bimodal)/VU(1), max(risk_function_ht_ttest)/VU(2));
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Max Regret & %4.3f  &  %s  & %s&   %4.4f & %4.4f& %4.4f\n',...
    VU(2)/(VU(2) - VUO(2)^2/VO(2))-1, '$\infty$', '$\infty$',  results_scale_bickel(2)-1,...
    results_scale_bickel(5)-1, results_scale_bickel(11)-1 );

fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Max Regret rel. to multivariate & %4.3f  &  %s  & %s&   %4.4f & %4.4f& %4.4f\n',...
    VU(1)/risk_trivariate(b_grid == 0)-1, '$\infty$', '$\infty$',  max(risk_function_bimodal./risk_trivariate)-1,...
    max(risk_function_adaptive_st_bimodal./risk_trivariate)-1, max(risk_function_ht_ttest./risk_trivariate)-1);

fprintf(fid, '%s\n', '\hline');

 fprintf(fid, 'Threshold &  &    &  &   & %4.4f& %4.4f\n',...
   results_scale_bickel(6), 1.96);
  fprintf(fid,'The correlation coefficient is %4.4f', corr); 
fclose(fid);
 

%% Composite Y_R
Sigma_R = [VR1 VR1R2; VR1R2 VR2];
VU = VU(1);
rho = inv(Sigma_R)*[1/sum(sum(inv(Sigma_R))) 1/sum(sum(inv(Sigma_R)))]' % optimal
Y_comp = YR*rho; V_comp = rho'*Sigma_R*rho;
V_comp_U = [VUR(1) VUR(2)]*rho;
VUO_comp = (V_comp_U - Sigma_U ); % VUR = VR in this case
VO_comp = V_comp - 2*V_comp_U+ Sigma_U ;
corr = VUO_comp/sqrt(VO_comp)/sqrt(VU);
[results_scale_minimax, results_scale_bickel] = adaptive_estimate(Y_comp,YU(1),V_comp,VU,V_comp_U,9,corr)

%% create the risk function (convert from  
Sigma_UO_grid = abs(tanh((-3:0.05:-0.05))); 
load('../Matlab/sim_results/risk.mat');
Kb = length(b_grid);  risk_function_adaptive = zeros(Kb,1);
 
risk_function_bimodal = zeros(Kb,1);
risk_function_adaptive_st_bimodal = zeros(Kb,1);

for i = 1:Kb
   risk_function_adaptive(i) = VUO_comp^2/VO_comp*interp1(Sigma_UO_grid,risk_mat(i,:),abs(corr),'spline');
   risk_function_bimodal(i) = VUO_comp^2/VO_comp*interp1(Sigma_UO_grid,risk_bimodal_mat(i,:),abs(corr),'spline');
   risk_function_adaptive_st_bimodal(i) = ...
                   VUO_comp^2/VO_comp*interp1(Sigma_UO_grid,risk_st_bimodal_mat(i,:),abs(corr),'spline');

end
sims = 100000;
rng(1,'twister');
x = normrnd(0,1,[sims,1]);
x_b = x*ones(1,Kb) + ones(sims,1)*b_grid';
Ebsims_ht = @(l) sum(((x_b > l).*x_b + (x_b < l & x_b > -l)*(1+ VO_comp/VUO_comp).*x_b + (x_b < -l).*x_b...
-ones(sims,1)*b_grid').^2,1)/sims;
risk_function_ht_ttest =  VUO_comp^2/VO_comp*(Ebsims_ht(1.96) + 1/corr^2- 1)';




risk_trivariate = ones(Kb,1)*Sigma_U-Sigma_UO(2)*(Sigma_O(2,2)\Sigma_UO(2)); % for (B_1 0) can adapt to GMM2
risk_trivariate(b_grid == 0) = Sigma_U-Sigma_UO*(Sigma_O\Sigma_UO'); % for (0 0) can adapt to GMM3


risk_composite = ones(Kb,1)*Sigma_U;
risk_composite(b_grid == 0) = Sigma_U-VUO_comp^2/VO_comp;  


max(risk_function_bimodal./risk_trivariate)
max(risk_function_adaptive_st_bimodal./risk_trivariate)
max(risk_function_ht_ttest./risk_trivariate)

%% Export the results for Table A3

fid = fopen(strcat('../../tables/tableA3.tex'),'w'); 
fprintf(fid, '%s\n',' & $Y_{U}$ & $Y_{comp}$ &  $GMM $ & Adaptive & Soft-threshold & Pre-test');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Estimate & %4.2f  & %4.2f & %4.2f  & %4.2f& %4.2f& %4.2f   \n',...
    YU(2),Y_comp,YU(2) - VUO_comp /VO_comp* (Y_comp-YU(2)), results_scale_bickel(1),  results_scale_bickel(4), results_scale_bickel(10) );
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Std error & %4.2f  & %4.2f  & %4.2f  &   &   & & \n',...
    sqrt(VU ),sqrt(V_comp), sqrt(VU  - VUO_comp^2/VO_comp) );

 
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Max Regret & %4.3f  &  %s  & %s&   %4.4f & %4.4f& %4.4f\n',...
    VU /(VU  - VUO_comp^2/VO_comp)-1, '$\infty$', '$\infty$',  results_scale_bickel(2)-1,...
    results_scale_bickel(5)-1, results_scale_bickel(11)-1 );

fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Max Regret rel. to multivariate & %4.3f  &  %s  & %s&   %4.4f & %4.4f& %4.4f\n',...
    VU /risk_trivariate(b_grid == 0)-1, '$\infty$', '$\infty$',  max(risk_function_bimodal./risk_trivariate)-1,...
    max(risk_function_adaptive_st_bimodal./risk_trivariate)-1, max(risk_function_ht_ttest./risk_trivariate)-1);

fprintf(fid, '%s\n', '\hline');

 fprintf(fid, 'Threshold &  &    &  &   & %4.4f& %4.4f\n',...
   results_scale_bickel(6), 1.96);
  fprintf(fid,'The correlation coefficient is %4.4f', corr);
fclose(fid);
 
