function Pi = pmf2(Sigma)
    global y1_grid y2_grid b_grid Ky Kb
    %% Read in the variance covariance matrix
    Sigma_U = Sigma(1,1);
    Sigma_UO = Sigma(1,2:end);
    Sigma_O = Sigma(2:end,2:end);
    %% Marginal probability of falling into y_grid given b_grid
    % Find the intermediate points for y_grid
    y1_grid_lb = [-Inf; y1_grid(1:(Ky-1))]; 
    y1_grid_mid = [(y1_grid_lb+y1_grid)/2;Inf];
    y2_grid_lb = [-Inf; y2_grid(1:(Ky-1))]; 
    y2_grid_mid = [(y2_grid_lb+y2_grid)/2;Inf];
    % Create a grid of  points in two-dimensional space.
    [X1,X2] = meshgrid(y1_grid_mid',y2_grid_mid');
    X = [X1(:) X2(:)];
    Pi = NaN(Ky^2,Kb);
    for b = 1:Kb
        mu = b_grid(b,:);
        % Evaluate the cdf of the normal distribution at the grid points.
        p = mvncdf(X,mu,Sigma_O);
        % Convert to two-dimensional for discrete approximation
        Z = reshape(p,Ky+1,Ky+1);
        Pi2 = Z(2:end,:) - Z(1:(end-1),:);
        Pi1 = Pi2(:,2:end) - Pi2(:,1:(end-1)); % Ky x Ky 
        Pi(:,b) = Pi1(:); % Ky^2 x 1
    end
    Pi(Pi<0) = 0; % if there is numerical inaccuracy, lower bound to zero
    %%
    assert(abs(max(sum(Pi,1))-1)<1e-5)
end


