%Program to compute minimax risk / scaled regret (two-dimensional)
clear all

%% Global variables for functions
global b_grid y1_grid y2_grid Sigma Ky Ky2 Kb Pi omega_grid options rho_tbl  
% policy = "non-linear";
% 
% %% fmincon options
% options = optimoptions(@fmincon,'Algorithm','sqp','Display','iter-detailed');
% options = optimoptions(options,'MaxFunctionEvaluations',2000000,...
%     'MaxIterations',40000,'ConstraintTolerance',1e-7,'OptimalityTolerance',1e-9);
% options = optimoptions(options,'SpecifyObjectiveGradient',true);


%% Specify the variance covariance matris
VU = 667.8492^2; VR1 = 616.7395^2; VR2=740.5698^2;
VUR1=sqrt(VU*VR1)*0.7694;
VUR2=sqrt(VU*VR2)*0.5668;
VR1R2=sqrt(VR1*VR2)*0.7502;
YU=1794.342; YR1=793.587; YR2=1361.759;
YO1 = YR1-YU; YO2 = YR2-YU; 
YO = [YO1 YO2]/sqrt(VU); % scaled Y_O

%%
VO1 = VR1 - 2*VUR1 + VU; VUO1 = (VUR1 - VU);
VO2 = VR2 - 2*VUR2 + VU; VUO2 = (VUR2 - VU);
VO1O2 = VR1R2-VUR1 - VUR2 +VU;

Sigma = [VU VUO1 VUO2; VUO1 VO1 VO1O2; VUO2 VO1O2 VO2];
Sigma = Sigma./VU;  
%Sigma = [1 -0.5 -0.9;-0.5 0.5 0.5;-0.9 0.5 0.9];
% Sigma = [1 -0.45 -0.45;-0.45 0.5 0;-0.45 0 0.5];
det(Sigma)
Sigma_U = Sigma(1,1);
Sigma_UO = Sigma(1,2:end);
Sigma_O = Sigma(2:end,2:end);
CUE = YU - sqrt(VU)*YO*(Sigma_O\Sigma_UO')
V_CUE = VU *(1 - Sigma_UO*(Sigma_O\Sigma_UO'))
Sigma_UO*(Sigma_O\Sigma_UO')
GMM2 = YU - sqrt(VU)*YO(2)* Sigma_UO(1,2)/(Sigma_O(2,2));
V_GMM2 =  (Sigma_U-Sigma_UO(2)*(Sigma_O(2,2)\Sigma_UO(2)))*VU ;

%% Create a grid of bias in two-dimensional space.
b = [-logspace(0.95,-2,20) 0 logspace(-2,0.95,20)]
[b1,b2] = meshgrid(b',b');
% [b1,b2] = meshgrid((-9:0.5:9)',(-9:0.5:9)');
b_grid = [b1(:) b2(:)];
% make the b_grid nested
% b_grid = b_grid(abs(b1(:)) >= abs(b2(:)),:); % y2 is less biased
% convert to standard deviation away from zero
b_grid = [b1(:).*sqrt(Sigma_O(1,1)) b2(:).*sqrt(Sigma_O(2,2))];
Kb = length(b_grid);
%% Create a grid of data in one-dimensional space.
y1_grid = (-12:0.25:12)'.*sqrt(Sigma_O(1,1)); % standard deviation
y2_grid = (-12:0.25:12)'.*sqrt(Sigma_O(2,2)); % standard deviation
Ky = length(y1_grid); % need to be same grid size
[Y1,Y2] = meshgrid(y1_grid',y2_grid');
Y_mesh = [Y1(:),Y2(:)];
size(Y_mesh)
%% pmf function calculates the marginal probability mass of falling into y_grid given b_grid
Pi_orig = pmf2(Sigma); % Ky^2 x Kb matrix
size(Pi_orig)
[min(max(Pi_orig')) max(max(Pi_orig')) quantile(max(Pi_orig'),0.05)]
%%
large_pi = (max(Pi_orig')>10^-6)'; Ky2 = sum(large_pi)
%% remove the grid points where Pi is very small for all values of bias

Pi = Pi_orig(large_pi,:);
size(Pi)
Y_mesh = Y_mesh(large_pi,:);
size(Y_mesh)
%% scaling for minimax against b=0 and b\neq 0
omega_grid = ones(Kb,1)*Sigma_U^(-1);
omega_grid(b_grid(:,2) == 0) = (Sigma_U-Sigma_UO(2)*(Sigma_O(2,2)\Sigma_UO(2))).^(-1);
omega_grid(sum(b_grid == [0 0],2)==2) = (Sigma_U-Sigma_UO*(Sigma_O\Sigma_UO')).^(-1);

%% form constants
bias_grid = b_grid*(Sigma_O\Sigma_UO'); % rotated b_grid
cons = bias_grid.^2 +Sigma_U - Sigma_UO*(Sigma_O\Sigma_UO');
%% cvx
cvx_begin
variables x(Kb)  
temp = quad_over_lin(Pi(1,:)*((x.*omega_grid).*bias_grid),Pi(1,:)*(x.*omega_grid));
for k=2:Ky2
    temp = temp + quad_over_lin(Pi(k,:)*((x.*omega_grid).*bias_grid),Pi(k,:)*(x.*omega_grid));
    if mod(k,100) == 0
        disp(k)
    end
end
minimize(temp-sum(cons.* (x.*omega_grid)))
%minimize(-sum((cons.^2).* x) + sum(quad_over_lin(Psi_num(n),Psi_denom(n))))
x >= 0
sum(x) == 1
 
cvx_end
%% Penalty
% outer2_loop_minimax(x)
writetable(table([b_grid x]),strcat( 'sim_results/dim2_adaptive_mu_minmax_nsw_diff_means','_B9','b_095_y_025','_log','_cvx','.csv'));

%% Calculate the risk function
% calculate the policy
Tbl = readtable('sim_results/dim2_adaptive_mu_minmax_nsw_diff_means_B9b_095_y_025_log_cvx');
x_cvx = Tbl.Var1_3; 
Psi = @(mu_grid) (Pi*(mu_grid.*bias_grid)) ./ (Pi*mu_grid);
% check if getting extreme values
Psi_likelihood = Pi*(x_cvx.*omega_grid);
psi_grid = Psi(x_cvx.*omega_grid); % adaptive minimax grid
% interpolate by finding the closest in L2 distance
diff = Y_mesh - YO;
distsq = sum(diff.^2, 2);
[~, idx] = min(distsq);
% YO./[sqrt(Sigma_O(1,1)) sqrt(Sigma_O(2,2))] 
% adaptive = psi_grid(sum(Y_mesh./[sqrt(Sigma_O(1,1)) sqrt(Sigma_O(2,2))] == [-2.25 -0.5],2)==2);
adaptive = psi_grid(idx);
risk_function_adaptive = Pi'*(psi_grid.^2) - 2 * (bias_grid.*(Pi'*psi_grid)) + cons;

%% confirm the minimax theorem held for calculating the worst-case prior
adapt_regret = max(risk_function_adaptive.*omega_grid) % should be equal to the penalty
% maximal relative risk
max(risk_function_adaptive);
max(risk_function_adaptive(b_grid(:,2) == 0))
risk_function_adaptive(sum(b_grid == [0 0],2)==2)

%% pre-test
sims = 100000;
rng(1,'twister');
x = mvnrnd([0 0],Sigma_O,sims);%simulated[Y_O1,Y_O2]
risk_function_ht_twotest = zeros(Kb,1);
%%
for bb = 1:Kb
    x_b = x +  ones(sims,1)*b_grid(bb,:); % add bias
    J2_b = sum((x_b*inv(Sigma_O)).*x_b,2);
    J1_b = x_b(:,2).^2/Sigma_O(2,2);
    GMM3_risk = Sigma_U-Sigma_UO*(Sigma_O\Sigma_UO') + (Sigma_UO*(Sigma_O\b_grid(bb,:)'))^2;
    GMM2_risk = Sigma_U-Sigma_UO(2)*(Sigma_O(2,2)\Sigma_UO(2)) + (Sigma_UO(2)*(Sigma_O(2,2)\b_grid(bb,2)'))^2;
    risk_function_ht_twotest(bb) = ...
        sum((J2_b < 5.99).*GMM3_risk + (J2_b > 5.99 & J1_b < 3.84).*GMM2_risk+ (J2_b > 5.99 & J1_b > 3.84).*Sigma_U)/sims;
end
max(risk_function_ht_twotest)
max(risk_function_ht_twotest(b_grid(:,2) == 0))
max(risk_function_ht_twotest(sum(b_grid == [0 0],2)==2))

pretest_regret = max(risk_function_ht_twotest.*omega_grid)


%% Export the results for Table A1

fid = fopen(strcat('../../tables/tableA1.tex'),'w'); 
fprintf(fid, '%s\n',' & $Y_{U}$ & $Y_{R1}$ & $Y_{R2}$ & $GMM_{2}$ & $GMM_{3}$ & Adaptive & Pre-test');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Estimate & %4.0f  & %4.0f & %4.0f  & %4.0f& %4.0f& %4.0f& %4.0f  \n',...
    YU,YR1, YR2, GMM2, CUE,  CUE+sqrt(VU)*adaptive, GMM2 );
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Std error & %4.0f  & %4.0f  & %4.0f  & %4.0f  & %4.0f  & & \n',...
    sqrt(VU),sqrt(VR1), sqrt(VR2), sqrt(V_GMM2), sqrt(V_CUE) );

fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'Max Regret & %4.3f  &  %s  & %s&  %s  & %s & %4.3f & %4.3f\n',...
    VU/V_CUE-1, '$\infty$', '$\infty$', '$\infty$', '$\infty$',adapt_regret-1, pretest_regret-1);

fprintf(fid, '%s\n', '\hline');
fprintf(fid, '%s\n', 'Risk rel. to $Y_U$ &&&&&&');
fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'when $b_{1}=0$ and $b_{2}=0$ & 1 &  %4.3f  &  %4.3f  &  %4.3f &  %4.3f  &  %4.3f &  %4.3f \n', ...
    VR1/VU,VR2/VU,V_GMM2/VU,V_CUE/VU,...
    risk_function_adaptive(sum(b_grid == [0 0],2)==2),max(risk_function_ht_twotest(sum(b_grid == [0 0],2)==2)));
fprintf(fid, '%s\n', '\hline');

fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'when $b_{1}!=0$ and $b_{2}=0$ & 1 & %s &  %4.3f  &  %4.3f &  %s  &  %4.3f  & %4.3f\n', ...
     '$\infty$',VR2/VU,V_GMM2/VU,'$\infty$',...
    max(risk_function_adaptive(b_grid(:,2) == 0)),max(risk_function_ht_twotest(b_grid(:,2) == 0)));
fprintf(fid, '%s\n', '\hline');


fprintf(fid, '%s\n', '\hline');
fprintf(fid, 'when $b_{1}!=0$ and $b_{2}!=0$ & 1 & %s  & %s & %s & %s & %4.3f  & %4.3f\n', ...
      '$\infty$','$\infty$','$\infty$','$\infty$',...
      max(risk_function_adaptive),max(risk_function_ht_twotest));
fprintf(fid, '%s\n', '\hline');


fprintf(fid, '%s\n','p-value for test the joint hypothesis whether YO = 0 jointly: sqrt(Sigma_O)^(-1/2)Y_O');
% is N(0,eye(2)).  So the p-value is 
fprintf(fid, '%s\n',1-chi2cdf(YO*(Sigma_O\YO'),2));
%YO./[sqrt(Sigma_O(1,1)) sqrt(Sigma_O(2,2))] % t-test
fprintf(fid, '%s\n','p-value for test the  hypothesis whether b2 = 0');
fprintf(fid, '%s\n',1-chi2cdf(YO(2)^2/Sigma_O(2,2),1));
fclose(fid);
    