% Compute the adaptive soft and hard threshold and their risk functions
clear all
%% fmincon options
options = optimoptions(@fmincon,'Algorithm','sqp','Display','iter');
options = optimoptions(options,'MaxFunctionEvaluations',2000000,...
    'MaxIterations',40000,'ConstraintTolerance',1e-7,'OptimalityTolerance',1e-9);

%% Form scaling - lookup the minimax risk for bounded normal mean
rho_tbl = readmatrix('sim_results/minimax_rho_B9.csv');
 
%% Loop over the grid for correlation coefficient
Sigma_UO_grid = tanh((-3:0.05:-0.05)); 
Kcorr = length(Sigma_UO_grid);
% exclude zero correlation coeff
%% Loop over upper bounds

B_grid = [9];

for i = 1:length(B_grid)
    B = B_grid(i);
    B
    %% Specify grid 
    b_grid = (-B:0.025:B)';
    y_grid = (-(B+3):0.05:(B+3))';
    bias_grid = b_grid; % if reparameterize the b_grid with /sqrt(Sigma_b)

    %% Grid sizes
    Ky = length(y_grid);
    Kb = length(b_grid);
    
    %% Define risk function for soft threshold at l
    Eb = @(l) 1+l^2+...
     (bias_grid.^2-1-l^2).*(normcdf(l-bias_grid)-normcdf(-l-bias_grid))+...
     (-bias_grid-l).*normpdf(l-bias_grid) - (l-bias_grid).*normpdf(-l-bias_grid);
    Eb0 = @(l) 1+l^2+...
     (-1-l^2) *(normcdf(l)-normcdf(-l))+...
     (-l) *normpdf(l) - (l) *normpdf(-l);
    % risk function for minimax estimator
    rho_grid = interp1(rho_tbl(:,1),rho_tbl(:,2),abs(bias_grid),'spline');

    %% Initialize the results matrix
    % save scalar thresholds
    st_mat = zeros(Kcorr,1); ht_mat = zeros(Kcorr,1);
    risk_st_mat = zeros(Kb,Kcorr);  
    risk_ht_mat = zeros(Kb,Kcorr);  
    st_bimodal_mat = zeros(Kcorr,1); ht_bimodal_mat = zeros(Kcorr,1); 
    risk_st_bimodal_mat = zeros(Kb,Kcorr); risk_ht_bimodal_mat = zeros(Kb,Kcorr);
    for idx = 1:length(Sigma_UO_grid)
        idx
        Sigma_UO = Sigma_UO_grid(idx);
        Sigma = [1 Sigma_UO;Sigma_UO 1];
        Sigma_t = Sigma(1,1);
        Sigma_tb = Sigma(1,2); % correlation coefficient
        Sigma_b = Sigma(2,2);
        corr2 = Sigma_tb^2/(Sigma_t*Sigma_b); % squared corr. coef. 
        cons = 1/corr2 - 1; 

        % oracle risk funcion (minimax over |b|<=B with B set to true value of |b|)
        risk_oracle = corr2*rho_grid+ 1-corr2;
%         [min(risk_oracle),max(risk_oracle)]  % range of the oracle risk fcn
 
        omega_grid = (risk_oracle).^(-1); 
        %% Scaling

        Eb_scaled = @(l) (corr2*Eb(l)+1-corr2).*omega_grid;
          
        [st,f_fun,f_max]  = fminimax(Eb_scaled,0,[],[],[],[],0,[],[]);
        st_mat(idx) = st; 
        risk_st_mat(:,idx) = (Eb(st) + 1/corr2 - 1);


        %% hard threshold
        Eb_ht = @(l) 1+(b_grid.^2-1).*(normcdf(l-b_grid)-normcdf(-l-b_grid))+...
                 (l-b_grid).*normpdf(l-b_grid) - (-l-b_grid).*normpdf(-l-b_grid); % hard threshold
        Eb_ht_scaled = @(l) (corr2*Eb_ht(l)+1-corr2).*omega_grid;
         [ht,f_fun,f_max]  =fminimax(Eb_ht_scaled,st,[],[],[],[],0,[],[]);
        ht_mat(idx) = ht;
        risk_ht_mat(:,idx) = (Eb_ht(ht) + 1/corr2 - 1);
        %% update to minimax against b=0 and b\neq 0
        omega_grid = ones(Kb,1)*(1/corr2).^(-1);
        omega_grid(b_grid == 0) = (1/corr2 - 1).^(-1);
        Eb_scaled = @(l) (Eb(l)+cons).*omega_grid;
          
        st_bimodal = fminimax(Eb_scaled,st,[],[],[],[],0,[],[]);
        st_bimodal_mat(idx) = st_bimodal; 
        risk_st_bimodal_mat(:,idx) = (Eb(st_bimodal) + 1/corr2 - 1);
        Eb_ht_scaled = @(l) (Eb_ht(l)+cons).*omega_grid;
        ht_bimodal = fminimax(Eb_ht_scaled,ht,[],[],[],[],0,[],[]);
        ht_bimodal_mat(idx) = ht_bimodal; 
        risk_ht_bimodal_mat(:,idx) = (Eb_ht(ht_bimodal) + 1/corr2 - 1);
    end
end
%% 

save('sim_results/risk_thresholds.mat','b_grid',...
    'risk_st_mat','risk_st_bimodal_mat','risk_ht_mat','risk_ht_bimodal_mat');
save('sim_results/thresholds.mat','st_mat','ht_mat','st_bimodal_mat','ht_bimodal_mat');

