% Compute the adaptive estimator and risk function for adaptive estimator
clear all

% Global variables for functions
global b_grid y_grid Ky Kb Pi omega_grid options rho_tbl
global mu0 x0 x0_bimodal % starting values for functions
load('sim_results/init_priors.mat'); % starting value for tanh(-3)
% fmincon options
options = optimoptions(@fmincon,'Algorithm','sqp','Display','off');
options = optimoptions(options,'MaxFunctionEvaluations',2000000,...
    'MaxIterations',40000,'ConstraintTolerance',1e-7,'OptimalityTolerance',1e-9);

%% Form scaling - lookup the minimax risk for bounded normal mean
rho_tbl = readmatrix('sim_results/minimax_rho_B9.csv');

%% Loop over correlation coefficient
Sigma_UO_grid = tanh((-3:0.05:-0.05)); corr_idx = 1:length(Sigma_UO_grid);
% exclude zero correlation coeff
%% Loop over upper bounds

B_grid = [9];

for i = 1:length(B_grid)
    B = B_grid(i);
    B
    %% Specify grid
    b_grid = (-B:0.025:B)';
    y_grid = (-(B+3):0.05:(B+3))';
    
    %% Grid sizes
    Ky = length(y_grid);
    Kb = length(b_grid);

    %% Initialize the results matrix
    prior_mat = zeros(Kb,length(Sigma_UO_grid));
    x_mat = zeros(Kb,length(Sigma_UO_grid)); 
    x_bimodal_mat = zeros(Kb,length(Sigma_UO_grid));

    bayes_mat = zeros(Ky,length(Sigma_UO_grid)); 
    psi_mat = zeros(Ky,length(Sigma_UO_grid));
    psi_bimodal_mat = zeros(Ky,length(Sigma_UO_grid));

    risk_mat = zeros(Kb,length(Sigma_UO_grid)); 
    risk_bimodal_mat = zeros(Kb,length(Sigma_UO_grid));
    %% Solve for policies for a given correlation coefficient
        % for the first one in the grid, need to manually initialize the
        % optimization 
    for idx = 1:length(Sigma_UO_grid)
        idx

        Sigma_UO = Sigma_UO_grid(idx);
        Sigma = [1 Sigma_UO;Sigma_UO 1];
        Sigma_t = Sigma(1,1);
        Sigma_tb = Sigma(1,2); % correlation coefficient
        Sigma_b = Sigma(2,2);
        tic
        [x,x_bimodal,prior,psi, bayes, psi_bimodal_grid,risk_function_adaptive, risk_function_bimodal] = risk_calc(Sigma);
        toc

        
        %% Save results
    
        %% if the correlation coeff index is just one, then don't need to loop 
        % over anything, just directly write to file. Otherwise, append
        if length(Sigma_UO_grid) == 1
        
            %% Adaptation penalty relative to the oracle risk funcion (minimax over |b|<=B with B set to true value of |b|, b = b/sqrt(Sigma_O))
    
        rho_b_over_sigma = interp1(rho_tbl(:,1),rho_tbl(:,2),abs(b_grid/sqrt(Sigma_b)),'spline');
        risk_oracle = rho_b_over_sigma + 1/Sigma_tb^2 -1;
        risk_bimodal = ones(Kb,1)*(1/Sigma_tb^2);
	      risk_bimodal(b_grid == 0) = (1/Sigma_tb^2-1);
	    
        disp([max(risk_function_adaptive./risk_oracle)])
        disp([max(risk_function_bimodal./risk_bimodal)])
            writetable(table(y_grid,psi,bayes,psi_bimodal_grid),strcat( 'sim_results/minimax_adaptive_psi_sigmatb_',corr_str,'_B',string(B),'.csv'));
            writetable(table(b_grid,risk_function_adaptive,risk_oracle,...
                risk_function_bimodal,risk_bimodal),...
                strcat( 'sim_results/risk_and_oracle_risk_sigmatb_',corr_str,'_B',string(B),'.csv'));
            writetable(table(b_grid,x,x_bimodal,prior),strcat( 'sim_results/minimax_mu_sigmatb_',corr_str,'_B',string(B),'.csv'));
        else
            prior_mat(:,idx) = prior; mu0 = prior;
            x_mat(:,idx) = x; x0 = x;
            x_bimodal_mat(:,idx) = x_bimodal; x0_bimodal = x_bimodal;
        
            bayes_mat(:,idx) = bayes; 
            psi_mat(:,idx) = psi; psi_bimodal_mat(:,idx) = psi_bimodal_grid;
        
            risk_mat(:,idx) = risk_function_adaptive; 
            risk_bimodal_mat(:,idx) = risk_function_bimodal;
            %tanh(-3) save('sim_results/init_priors.mat','mu0','x0','x0_bimodal'); 
        end
    end
end
%% 
save('sim_results/priors.mat','b_grid','prior_mat','x_mat','x_bimodal_mat');
save('sim_results/risk.mat','b_grid','risk_mat','risk_bimodal_mat');
save('sim_results/policy.mat','y_grid','bayes_mat','psi_mat','psi_bimodal_mat');


