% Compute risk function for empirical MSE estimator, along with adaptation
clear all
%% Loop over correlation coefficient
Sigma_UO_grid = tanh((-3:0.05:-0.05));
Kcorr = length(Sigma_UO_grid);
MSE_lambda_mat = zeros(Kcorr,1); MSE_penalty_mat = zeros(Kcorr,1);

%% Form scaling - lookup the minimax risk for bounded normal mean
rho_tbl = readmatrix('sim_results/minimax_rho_B9.csv');

%% Specify grid
B = 9;
b_grid = (-B:0.025:B)';
y_grid = (-(B+3):0.05:(B+3))';
bias_grid = b_grid; % if reparameterize the b_grid with /sqrt(Sigma_b)
rho_grid = interp1(rho_tbl(:,1),rho_tbl(:,2),abs(bias_grid),'spline'); %Rmax
    
%% Grid sizes
Ky = length(y_grid);
Kb = length(b_grid);

%% Use simulation to calculate the risk function for the empirical MSE minimizing estimator (dCDH)
rng(1,'twister');
sims = 100000;
x = normrnd(0,1,[sims,1]);
x_b = x*ones(1,Kb) + ones(sims,1)*b_grid';
Ebsims_MSE = @(l) sum((x_b.^3./(x_b.^2+l)...
    -ones(sims,1)*b_grid').^2,1)/sims;
%% Loop
for idx = 1:length(Sigma_UO_grid)
    idx
    if idx == 1
        lambda_0 = 1;
    end
    Sigma_UO = Sigma_UO_grid(idx); % correlation coefficient
    corr2 = Sigma_UO^2; % squared corr. coef.
    cons = 1/corr2 - 1;
   
    %% find adaptive lambda, using the lambda from previous corr as starting value
    omega_grid = (rho_grid + 1/corr2 - 1).^(-1);
    Ebsims_MSE_scaled = @(l) (Ebsims_MSE(l)'+cons).*omega_grid;
    tic
    [lambda,~,penalty] = fminimax(Ebsims_MSE_scaled,lambda_0,[],[],[],[],0,[],[]);
    toc
    MSE_lambda_mat(idx) = lambda; MSE_penalty_mat(idx) = penalty;
    lambda_0 = lambda; %update initial value
end
 
save('sim_results/emse_corr.mat','Sigma_UO_grid','B','MSE_lambda_mat','MSE_penalty_mat');