function [x1,x1_grid,risk_function_x1] = risk_calc_const_tuning(Sigma,t)

    global b_grid Kb   Pi omega_grid options rho_tbl    
    global x1_init  cons

    %% Read in the variance covariance matrix 
    Sigma_t = Sigma(1,1);
    Sigma_tb = Sigma(1,2);
    Sigma_b = Sigma(2,2);
    
    %% Form constants
    % without normalization of b
    %bias_grid = b_grid*Sigma_tb/Sigma_b;
    %cons = bias_grid.^2 +Sigma_t - Sigma_tb^2/Sigma_b;
    % with normalization of b/sqrt(Sigma_b)
    bias_grid = b_grid/sqrt(Sigma_b);
	cons = bias_grid.^2 + 1/Sigma_tb^2 - 1;
       
    %% Find the adaptive estimator subject to the constraint via scaling
     
    %% Set up the minimization problem over posteriors
    lb = zeros(Kb,1);
    ub = [];
    A = [];
    b = [];
    Aeq = ones(Kb,1)';
    beq = 1;
    nonlcon = [];
    Pi = pmf(Sigma);
    Psi = @(mu_grid) (Pi*(mu_grid.*(bias_grid))) ./ (Pi*mu_grid);
    %% Form scaling 
    rho_grid = interp1(rho_tbl(:,1),rho_tbl(:,2),abs(b_grid/sqrt(Sigma_b)),'spline');
    % without normalization of b
%     omega_grid = (Sigma_tb^2/Sigma_b*rho_grid + Sigma_t - Sigma_tb^2/Sigma_b).^(-1);
    % with normalization of b/sqrt(Sigma_b)
%     omega_grid = (rho_grid + 1/Sigma_tb^2 -1).^(-1);
    omega_grid = (min(rho_grid + 1/Sigma_tb^2 -1,t(1))).^(-1);
    %% Initiate with the adaptive estimator
    
%     x1 = fmincon(@outer_loop_minimax,x,A,b,Aeq,beq,lb,ub,@const1_risk,options);
    x1 = fmincon(@outer_loop_minimax,x1_init,A,b,Aeq,beq,lb,ub,nonlcon,options);
    x1_grid = Psi(x1.*omega_grid);  
    risk_function_x1 = Pi'*(x1_grid.^2) - 2 * (bias_grid.*(Pi'*x1_grid)) + cons;
     
 
end
