function [x,x_bimodal,prior,psi_grid,bayes_grid,psi_bimodal_grid,risk_function_adaptive,risk_function_bimodal] = risk_calc(Sigma)

    global b_grid y_grid Kb Ky Pi omega_grid options rho_tbl    
    global mu0 x0 x0_bimodal cons

    %% Read in the variance covariance matrix
    Sigma_t = Sigma(1,1);
    Sigma_tb = Sigma(1,2);
    Sigma_b = Sigma(2,2);
    
    %% Form constants
    bias_grid = b_grid/sqrt(Sigma_b);
	cons = bias_grid.^2 + 1/Sigma_tb^2 - 1;
       
    %% Find the minimax adaptive estimator

    %% Solve for the least favorable prior (omega = 1)
    lb = zeros(Kb,1);
    ub = [];
    A = [];
    b = [];
    Aeq = ones(Kb,1)';
    beq = 1;
    nonlcon = [];
    Pi = pmf(Sigma);
    Psi = @(mu_grid) (Pi*(mu_grid.*(bias_grid))) ./ (Pi*mu_grid);

    %% Initiate with uniform prior
    % comment out if use prior from neighboring correlation coefficient
%     mu0 = ones(Kb,1)*1/Kb;
    omega_grid = ones(Kb,1);

    prior = fmincon(@outer_loop_minimax,mu0,A,b,Aeq,beq,lb,ub,nonlcon,options);
    bayes_grid = Psi(prior); % minimax
    %% Form scaling 
    rho_grid = interp1(rho_tbl(:,1),rho_tbl(:,2),abs(b_grid/sqrt(Sigma_b)),'spline');
    omega_grid = (rho_grid + 1/Sigma_tb^2 -1).^(-1);
    %% Solve for adaptive minimax
    %x  = fmincon(@outer_loop_minimax,prior,A,b,Aeq,beq,lb,ub,nonlcon,options);
    % if use previous result to initialize
    x  = fmincon(@outer_loop_minimax,x0,A,b,Aeq,beq,lb,ub,nonlcon,options);

    psi_grid = Psi(x.*omega_grid); % adaptive minimax
	risk_function_adaptive = Pi'*(psi_grid.^2) - 2 * (bias_grid.*(Pi'*psi_grid)) + cons;

	%% Find the adaptive estimator adapted to a binary risk

	omega_grid = ones(Kb,1)*(1/Sigma_tb^2)^(-1);
	omega_grid(b_grid == 0) = (1/Sigma_tb^2-1).^(-1);
	
	%x_bimodal  = fmincon(@outer_loop_minimax,x,A,b,Aeq,beq,lb,ub,nonlcon,options);
    % if use previous result to initialize
    x_bimodal  = fmincon(@outer_loop_minimax,x0_bimodal,A,b,Aeq,beq,lb,ub,nonlcon,options);

    psi_bimodal_grid = Psi(x_bimodal.*omega_grid); % binary minimax
    risk_function_bimodal = Pi'*(psi_bimodal_grid.^2) - 2 * (bias_grid.*(Pi'*psi_bimodal_grid)) + cons;

end
