function Pi = pmf(Sigma)
    global y_grid b_grid Ky Kb
    %% Read in the variance covariance matrix
    Sigma_t = Sigma(1,1);
    Sigma_tb = Sigma(1,2);
    Sigma_b = Sigma(2,2);
    %% Marginal probability of falling into y_grid given b_grid
    Pi = NaN(Ky,Kb);
    y_grid_lb = [-Inf; y_grid(1:(Ky-1))];
    y_grid_ub = [y_grid(2:Ky); Inf];
    Pi = normcdf((y_grid_ub+y_grid)/2*ones(1,Kb),ones(Ky,1)*b_grid',sqrt(Sigma_b)) - ...
             normcdf((y_grid_lb+y_grid)/2*ones(1,Kb),ones(Ky,1)*b_grid',sqrt(Sigma_b)); 
    
    assert(abs(max(sum(Pi,1))-1)<1e-5)
end