function val = outer_loop_minimax(mu_grid)
    global b_grid Kb Pi omega_grid cons
    %% Read in the variance covariance matrix - do not need to because Sigma(2,2) = 1 already normalized
%     Sigma_t = Sigma(1,1);
%     Sigma_tb = Sigma(1,2);
%     Sigma_b = Sigma(2,2);
% 
% 	bias_grid = b_grid/sqrt(Sigma_b);
	bias_grid = b_grid;
    %% Apply scaling
    mu_grid = mu_grid.*omega_grid;

    %% Policy function for observed y_grid given prior \mu
    Psi = (Pi*(mu_grid.*bias_grid)) ./ (Pi*mu_grid);

    %% Collect results
    num = Pi'*(Psi.^2) - 2 * (bias_grid.*(Pi'*Psi)) + cons;

    val = - mu_grid'*num; % take the negative for fmincon
end

