%Program to compute minimax risk for use in re-scaling risk (regret)
clear all
% fmincon options
options = optimoptions(@fmincon,'Algorithm','sqp','Display','off');
options = optimoptions(options,'MaxFunctionEvaluations',2000000,...
    'MaxIterations',40000,'ConstraintTolerance',1e-7,'OptimalityTolerance',1e-7);
% Global variables for functions
global b_grid y_grid Sigma Ky Kb Pi omega_grid cons

Sigma = [1 1;1 1]; % removes the scaling of Cov/Var_O

B_grid = 0.1:0.1:9;
b_max_grid = (-9:0.05:9)';
prior_bounded_normal_mean_mat = zeros(length(b_max_grid),length(B_grid));

rho = NaN(length(B_grid),1);
exit_status = NaN(length(B_grid),1);

%%
for i = 1:length(B_grid)
    B = B_grid(i);
    B
    %% Specify grid
    b_grid = (-B:0.05:B)';
    y_grid = (-(B+3):0.1:(B+3))'; % adjust y_grid based on bounds

    %% Grid sizes
    Ky = length(y_grid);
    Kb = length(b_grid);

    %% Initiate with uniform prior
    mu0 = ones(Kb,1)*1/Kb;
    %% Initiate with a prior from previous bound
    if i>1
        mu0 = zeros(Kb,1); 
        % need to allow for some numerical inaccuracy
        mu0(b_grid<=(B_grid(i-1)+0.0001)&b_grid>=-(B_grid(i-1)+0.0001)) = x;
    end
    %% pmf function calculates the marginal probability mass of falling into y_grid given b_grid
    Pi = pmf(Sigma);
    %% Solve for the least favorable prior (omega = 1)
    lb = zeros(Kb,1);
    ub = [];
    A = [];
    b = [];
    Aeq = ones(Kb,1)';
    beq = 1;
    nonlcon = [];
%     Psi = @(mu_grid) (Pi*(mu_grid.*(b_grid*Sigma(1,2)/Sigma(2,2)))) ./ (Pi*mu_grid);
    omega_grid = ones(Kb,1); % no scaling
    cons = b_grid.^2 + 1/Sigma(1,2)^2 - 1;
    [x, rho_neg,exit_status(i),~] = fmincon(@outer_loop_minimax,mu0,A,b,Aeq,beq,lb,ub,nonlcon,options);
    rho(i) = - rho_neg;
    prior_bounded_normal_mean_mat(b_max_grid<=(B+0.0001)&b_max_grid>=-(B+0.0001),i) = x;
    
end
save('sim_results/priors_bounded_normal_mean.mat','B_grid','b_max_grid','prior_bounded_normal_mean_mat');

%% Save results for B_grid = 0.1:0.1:9;  b_grid = (-B:0.05:B)'; and y_grid = (-(B+3):0.1:(B+3))'; 
writematrix([B_grid' rho],'sim_results/minimax_rho_B9.csv');

%% Risk at each b for the minimax estimator (derived under bounds in B_grid above)
B=9;
b_grid = (-B:0.05:B)';
y_grid = (-(B+3):0.1:(B+3))';
Ky = length(y_grid);
Kb = length(b_grid);
Pi = pmf(Sigma);
Psi = @(mu_grid) (Pi*(mu_grid.*(b_grid))) ./ (Pi*mu_grid);
load('sim_results/priors_bounded_normal_mean.mat');
risk_function_minimax = zeros(length(b_max_grid),length(B_grid));
psi_function_minimax = zeros(length(y_grid),length(B_grid));

%% calculate the minimax estimate at each y
for i = 1:length(B_grid)
    psi_grid = Psi(prior_bounded_normal_mean_mat(:,i)); % minimax estimator
    psi_grid(isnan(psi_grid)) = 0;
    risk_function_minimax(:,i) = Pi'*(psi_grid.^2) - 2 * (b_grid.*(Pi'*psi_grid)) + b_grid.^2;
    psi_function_minimax(:,i) = psi_grid;

end
save('sim_results/minimax_bounded_normal_mean.mat','B_grid','y_grid',...
    'psi_function_minimax');
%% calculate minimax risk at each b
minimax_risk_function_minimax = risk_function_minimax;
for i = 1:Kb
    for j = 1:length(B_grid)
    minimax_risk_function_minimax(i,j) = max( risk_function_minimax(abs(b_max_grid)<=abs(b_grid(i)),j));
    end
end
save('sim_results/risk_bounded_normal_mean.mat','b_max_grid','risk_function_minimax',...
    'minimax_risk_function_minimax');
