%% Script to construct the adaptive estimators for a grid of \rho (Sigma_UO_grid)
% Make sure the home directory is the current directory
%% 1.1 compute B-minimax estimators and oracle risk
run("opt_minimax_bounded_normal_mean.m")
%% 1.2 compute the adaptive estimator for a grid Sigma_UO_grid 
% make sure /sim_results/init_priors.mat is available, initial guess for faster optimization
run("risk_functions_hausman.m")
%% Load the solutions calculated above and rescale to be priors
load('sim_results/priors.mat');   
Sigma_UO_grid = tanh((-3:0.05:-0.05));
% calculate the oracle risk function
Kb = length(b_grid); 
rho_tbl = readmatrix('sim_results/minimax_rho_B9.csv');
rho_b_over_sigma = interp1(rho_tbl(:,1),rho_tbl(:,2),abs(b_grid),'spline');
omega_grid_mat = zeros(Kb,length(Sigma_UO_grid));
for i = 1:length(Sigma_UO_grid)
     corr2 = Sigma_UO_grid(i)^2;
     risk_oracle = rho_b_over_sigma + 1/corr2 -1;
     omega_grid_mat(:,i) = risk_oracle.^(-1);
end
adaptive_prior_w = (x_mat.*omega_grid_mat)./sum(x_mat.*omega_grid_mat);
flat_prior_w = (omega_grid_mat)./sum(omega_grid_mat);
save('sim_results/priors_wtd.mat','b_grid','adaptive_prior_w','flat_prior_w');
%% 1.3 compute the adaptive soft-thresholding and hard-thresholding estimator 
% for a grid Sigma_UO_grid 
run("risk_functions_soft_minimax.m")
%% 1.4 Compute risk function for empirical MSE estimator, along with adaptation
% for a grid Sigma_UO_grid 
rng(1,'twister'); % uses simulation to form the objective function
run("risk_calc_empirical_MSE.m")
%% 1.5 Compute 95% FLCI critical values for adaptive estimator 
% and soft-threshold estimator under varying B
rng(1,'twister'); % uses simulation to calculate rejection probabilities
run("FLCI.m")
