%% Fixed-length confidence interval (FLCI) based on estimators
clear all
Sigma_UO_grid = tanh((-3:0.05:-0.05));
%% Load the adaptive estimators
load('sim_results/risk.mat');
load('sim_results/policy.mat');  
Ky = length(y_grid);
Kb = length(b_grid);
%% Use simulation to calculate the critical value of the adaptive estimator
rng(1,'twister');
sims = 100000;
x = normrnd(0,1,[sims,1]);
t = normrnd(0,1,[sims,1]);

addpath("../")
Ky = length(y_grid);
Kb = length(b_grid);
%%
c_grid = 0:0.01:6;% grid to search for critical value
Kc = length(c_grid);
B_grid = [0.01 0.1:0.1:9]; % Upper bound on the bias for uniformity to hold
%% Calculate the coverage probability for each c in the grid of critical values
min_c_vec = zeros(length(B_grid),length(Sigma_UO_grid));
for i = 1:length(Sigma_UO_grid)
       i
     corr2 = Sigma_UO_grid(i)^2; corr = Sigma_UO_grid(i);
     psi_mat_rho = psi_mat(:,i);
     %% 
     stat = zeros(sims,Kb);

     for j = 1:Kb
        t_b = t + ones(sims,1)*b_grid(j);
        t_tilde = interp1(y_grid,psi_mat_rho,t_b,'spline');%lookup table to fill in the estimate 
        %t_tilde = t_b; % if just using Y_U
        stat(:,j) = abs(sqrt(1-corr2)*x+corr*(t_tilde-b_grid(j)));
     end
     coverage = zeros(Kc,Kb);
     for k = 1:Kc
        coverage(k,:) = mean(stat<c_grid(k)); % manual cdf
     end
     %%
     min_c = zeros(Kb,1);
     for j = 1:Kb
         min_c(j) = min(c_grid(coverage(:,j) > 0.95));
     end
     %% Find the critical value associated with diff't intervals
     for k = 1:length(B_grid)
         min_c_vec(k,i) = max(min_c(abs(b_grid)<=B_grid(k)));
     end

end
%% Save the FLCI critical values for adaptive estimator
save('sim_results/flci_adaptive_cv.mat','B_grid','Sigma_UO_grid','min_c_vec');

 
%% Calculate the coverage probability for each c in the grid of critical values for the soft-thresholding estimator
min_st_c_vec = zeros(length(B_grid),length(Sigma_UO_grid));
load('sim_results/thresholds.mat');
for i = 1:length(Sigma_UO_grid)
       i
     corr2 = Sigma_UO_grid(i)^2; corr = Sigma_UO_grid(i);
     st = interp1(Sigma_UO_grid,st_mat,abs(corr),'spline');
     %% 
     stat = zeros(sims,Kb);
     for j = 1:Kb
        t_b = t + ones(sims,1)*b_grid(j);
        t_tilde = ((t_b > st).*(t_b - st) + (t_b < -st).*(t_b + st)); % soft-thresholded estimate
        stat(:,j) = abs(sqrt(1-corr2)*x+corr*(t_tilde-b_grid(j)));
     end
     coverage = zeros(Kc,Kb);
     for k = 1:Kc
        coverage(k,:) = mean(stat<c_grid(k)); % manual cdf
     end
     %%
     min_c = zeros(Kb,1);
     for j = 1:Kb
         min_c(j) = min(c_grid(coverage(:,j) > 0.95));
     end
     %% Find the critical value associated with diff't intervals
     for k = 1:length(B_grid)
         min_st_c_vec(k,i) = max(min_c(abs(b_grid)<=B_grid(k)));
     end

end
%% Save the FLCI critical values for soft-threshold estimator
save('sim_results/flci_adaptive_st_cv.mat','B_grid','Sigma_UO_grid','min_st_c_vec');