# m8n8k4

CUDA provides an experimental PTX instruction `mma.sync.aligned.m8n8k4` which computes `(m, n, k) = (8, 8, 4)` matrix FMA.
This library provides its C++ interface.

## Sample
```cpp
constexpr unsigned M = 8;
constexpr unsigned M = 8;
constexpr unsigned M = 4;

__global__ void m8n8k4_test_kernel(float* const d, const half* const a, const half* const b, const float* const c) {
	mtk::wmma::fragment<nvcuda::wmma::matrix_a, M, N, K, half, nvcuda::wmma::col_major> frag_a;
	mtk::wmma::fragment<nvcuda::wmma::matrix_b, M, N, K, half, nvcuda::wmma::col_major> frag_b;
	mtk::wmma::fragment<nvcuda::wmma::accumulator, M, N, K, float> frag_c;
	mtk::wmma::fragment<nvcuda::wmma::accumulator, M, N, K, float> frag_d;

	mtk::wmma::load_matrix_sync(frag_a, a, M);
	mtk::wmma::load_matrix_sync(frag_b, b, K);
	mtk::wmma::load_matrix_sync(frag_c, c, M, nvcuda::wmma::mem_col_major);

	mtk::wmma::mma_sync(frag_d, frag_a, frag_b, frag_c);

	mtk::wmma::store_matrix_sync(d, frag_d, M, nvcuda::wmma::mem_col_major);
}
```
