#pragma once
#include "common.hpp"

//--------------------
// constants for 2 <= low <= 20
//--------------------
namespace oz2_table {

template <class T> struct tab_t {
    T x;
};
template <> struct tab_t<double> {
    double x;
    double y;
    float z;
    float w;
};
template <> struct tab_t<float> {
    float x;
    float y;
};

__constant__ tab_t<double> moduli_dev[20];
__constant__ tab_t<float> modulif_dev[20];
__constant__ double NMi_dev[40];

// -moduli & 1/moduli
constexpr tab_t<double> moduli[20] = {
    {-256.0, 0x1.0000000000000p-8, -256.0F, 0x1.0000000000000p-8F},
    {-255.0, 0x1.0101010101010p-8, -255.0F, 0x1.0101020000000p-8F},
    {-253.0, 0x1.03091b51f5e1ap-8, -253.0F, 0x1.03091c0000000p-8F},
    {-251.0, 0x1.05197f7d73404p-8, -251.0F, 0x1.0519800000000p-8F},
    {-247.0, 0x1.0953f39010954p-8, -247.0F, 0x1.0953f40000000p-8F},
    {-241.0, 0x1.0fef010fef011p-8, -241.0F, 0x1.0fef020000000p-8F},
    {-239.0, 0x1.12358e75d3033p-8, -239.0F, 0x1.12358e0000000p-8F},
    {-233.0, 0x1.19453808ca29cp-8, -233.0F, 0x1.1945380000000p-8F},
    {-229.0, 0x1.1e2ef3b3fb874p-8, -229.0F, 0x1.1e2ef40000000p-8F},
    {-227.0, 0x1.20b470c67c0d9p-8, -227.0F, 0x1.20b4700000000p-8F},
    {-223.0, 0x1.25e22708092f1p-8, -223.0F, 0x1.25e2280000000p-8F},
    {-217.0, 0x1.2e025c04b8097p-8, -217.0F, 0x1.2e025c0000000p-8F},
    {-211.0, 0x1.3698df3de0748p-8, -211.0F, 0x1.3698e00000000p-8F},
    {-199.0, 0x1.49539e3b2d067p-8, -199.0F, 0x1.49539e0000000p-8F},
    {-197.0, 0x1.4cab88725af6ep-8, -197.0F, 0x1.4cab880000000p-8F},
    {-193.0, 0x1.5390948f40febp-8, -193.0F, 0x1.5390940000000p-8F},
    {-191.0, 0x1.571ed3c506b3ap-8, -191.0F, 0x1.571ed40000000p-8F},
    {-181.0, 0x1.6a13cd1537290p-8, -181.0F, 0x1.6a13ce0000000p-8F},
    {-179.0, 0x1.6e1f76b4337c7p-8, -179.0F, 0x1.6e1f760000000p-8F},
    {-173.0, 0x1.7ad2208e0ecc3p-8, -173.0F, 0x1.7ad2200000000p-8F}
};

// -moduli & 1/moduli
constexpr tab_t<float> modulif[20] = {
    {-256.0F, 0x1.0000000000000p-8F},
    {-255.0F, 0x1.0101020000000p-8F},
    {-253.0F, 0x1.03091c0000000p-8F},
    {-251.0F, 0x1.0519800000000p-8F},
    {-247.0F, 0x1.0953f40000000p-8F},
    {-241.0F, 0x1.0fef020000000p-8F},
    {-239.0F, 0x1.12358e0000000p-8F},
    {-233.0F, 0x1.1945380000000p-8F},
    {-229.0F, 0x1.1e2ef40000000p-8F},
    {-227.0F, 0x1.20b4700000000p-8F},
    {-223.0F, 0x1.25e2280000000p-8F},
    {-217.0F, 0x1.2e025c0000000p-8F},
    {-211.0F, 0x1.3698e00000000p-8F},
    {-199.0F, 0x1.49539e0000000p-8F},
    {-197.0F, 0x1.4cab880000000p-8F},
    {-193.0F, 0x1.5390940000000p-8F},
    {-191.0F, 0x1.571ed40000000p-8F},
    {-181.0F, 0x1.6a13ce0000000p-8F},
    {-179.0F, 0x1.6e1f760000000p-8F},
    {-173.0F, 0x1.7ad2200000000p-8F}
};

// floor(2^32/p(i) - 1)
constexpr int32_t invm_32i[19] = {
    16843008,
    16976154,
    17111422,
    17388530,
    17821440,
    17970573,
    18433335,
    18755314,
    18920559,
    19259942,
    19792475,
    20355294,
    21582749,
    21801863,
    22253715,
    22486738,
    23729100,
    23994229,
    24826399,
};

constexpr int numM[19] = {1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};

// prod(p)
constexpr double M[19][2] = {
    {6.5280000000000000e+04,  0.0000000000000000e+00},
    {1.6515840000000000e+07,  0.0000000000000000e+00},
    {4.1454758400000000e+09,  0.0000000000000000e+00},
    {1.0239325324800000e+12,  0.0000000000000000e+00},
    {2.4676774032768000e+14,  0.0000000000000000e+00},
    {5.8977489938315520e+16,  0.0000000000000000e+00},
    {1.3741755155627516e+19,  2.5600000000000000e+02},
    {3.1468619306387012e+21, -3.1488000000000000e+04},
    {7.1433765825498518e+23, -4.5263360000000000e+06},
    {1.5929729779086169e+26,  2.6145057280000000e+09},
    {3.4567513620616985e+28,  2.0448164928000000e+12},
    {7.2937453739501847e+30, -3.3380381295129600e+14},
    {1.4514553294160867e+33, -1.0131963435176704e+16},
    {2.8593669989496909e+35, -1.7272206732770533e+19},
    {5.5185783079729035e+37, -3.2597489231298749e+21},
    {1.0540484568228245e+40,  2.5574812149594794e+23},
    {1.9078277068493124e+42, -4.6796878119559867e+25},
    {3.4150115952602691e+44, -6.3951593786758970e+26},
    {5.9079700598002656e+46, -4.2754890730815036e+29}
};

// 1/prod(p)
constexpr double invM[19] = {
    1.5318627450980392e-05,
    6.0547934588855299e-08,
    2.4122683103129606e-10,
    9.7662684628055072e-13,
    4.0523935530313311e-15,
    1.6955621560800549e-17,
    7.2770907986268441e-20,
    3.1777689076973120e-22,
    1.3998981972234855e-24,
    6.2775703911367061e-27,
    2.8928895811689891e-29,
    1.3710377161938337e-31,
    6.8896367647931339e-34,
    3.4972775455802713e-36,
    1.8120609044457363e-38,
    9.4872298662080431e-41,
    5.2415634619933945e-43,
    2.9282477441303881e-45,
    1.6926287538325940e-47,
};

namespace int8tc {

// fld(log2(M-1)/2 - 0.5)
constexpr float log2M[19] = {
    7.49716566e+00F,
    1.14886734e+01F,
    1.54744452e+01F,
    1.94486288e+01F,
    2.34050735e+01F,
    2.73555069e+01F,
    3.12876000e+01F,
    3.52072019e+01F,
    3.91204761e+01F,
    4.30209261e+01F,
    4.69017017e+01F,
    5.07622513e+01F,
    5.45805636e+01F,
    5.83915895e+01F,
    6.21878180e+01F,
    6.59765324e+01F,
    6.97264554e+01F,
    7.34683633e+01F,
    7.71856774e+01F,
};

} // namespace int8tc

namespace vecnorm {

// fld(log2(M-1)/2 - 1.5)
constexpr float log2M[19] = {
    6.49716520e+00F,
    1.04886732e+01F,
    1.44744443e+01F,
    1.84486274e+01F,
    2.24050731e+01F,
    2.63555068e+01F,
    3.02875995e+01F,
    3.42071990e+01F,
    3.81204757e+01F,
    4.20209236e+01F,
    4.59016990e+01F,
    4.97622489e+01F,
    5.35805625e+01F,
    5.73915863e+01F,
    6.11878166e+01F,
    6.49765319e+01F,
    6.87264480e+01F,
    7.24683609e+01F,
    7.61856765e+01F,
};

} // namespace vecnorm

// [~, x, ~] = gcd(prod(p)/p(i),p(i));
// N(i) = mod(x, p(i));
// NMi(i) = N(i).*prod(p)/p(i);
constexpr double NMi_1[19][20] = {
    {
     6.5025000000000000e+04,
     2.5600000000000000e+02,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     1.1032065000000000e+07,
     8.2255360000000000e+06,
     1.3774080000000000e+07,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     2.7528550500000000e+08,
     5.2021657600000000e+08,
     3.4409088000000000e+08,
     3.0058828800000000e+09,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     2.1998550502500000e+11,
     1.0078708456960000e+12,
     4.9780119168000000e+11,
     3.2635299840000000e+11,
     1.0197870566400000e+12,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     1.6097739310438500e+14,
     1.4128662779545600e+14,
     5.1694427815680000e+13,
     2.3890263306624000e+14,
     2.0580629355264000e+14,
     1.8840358597632000e+14,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     4.6306544834380544e+16,
     4.9494834693331456e+16,
     4.5456958648108800e+16,
     3.9474973345167360e+16,
     8.5959094646937600e+15,
     3.6463261414145280e+16,
     1.0117477353434880e+16,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     1.2077714492250745e+19,
     4.4728065800669942e+18,
     9.7767427984701686e+18,
     8.6501885043392328e+18,
     3.7831552655168860e+18,
     7.5266044835802153e+18,
     1.8973971553795297e+18,
     6.7824113429062840e+18,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     9.4651706507492170e+20,
     2.9864336753512379e+21,
     1.4801445444506144e+21,
     2.7707429747854698e+21,
     1.3504751605170134e+21,
     3.0032292284103786e+21,
     2.1593529565888994e+21,
     1.9718533985976409e+21,
     2.2124225800560297e+21,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     4.1855722163378032e+22,
     1.2886091090089923e+23,
     2.3434792741171440e+23,
     1.8214187302119136e+23,
     6.2757599935761847e+23,
     5.3353020118629555e+22,
     1.9726479265618835e+23,
     4.0162331858971264e+23,
     1.0605886629113311e+23,
     1.6993054425448985e+23,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     1.3005130952457067e+26,
     8.8706730534519045e+25,
     5.6667022929555517e+25,
     1.1233315421905383e+26,
     4.0630484861636773e+25,
     1.5863631315272533e+26,
     1.3663575751935833e+26,
     1.0255190844905258e+26,
     1.0225634399675401e+26,
     7.0175021053243018e+25,
     1.1643703829556255e+26,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     2.4980429764898991e+28,
     2.8602923035098762e+28,
     1.6942180588760891e+28,
     1.0466657510625062e+28,
     1.0076360245685923e+28,
     3.3133176955861094e+28,
     6.5085276691538230e+27,
     1.1571957349391092e+28,
     6.7927428512129410e+27,
     3.3044715663761610e+28,
     1.5501127184133139e+27,
     2.3735297370838389e+28,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     5.5557826090636170e+30,
     2.8602923035098393e+28,
     6.8613098774709238e+30,
     6.5091592181866180e+30,
     7.2346867069546353e+30,
     4.8725850838422390e+30,
     7.3242631370210973e+29,
     1.8782176928627078e+30,
     3.5672466457747625e+30,
     9.3180006979980253e+29,
     6.0508649963263853e+30,
     5.2434298540840030e+30,
     1.5901056265483804e+30,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     2.0978065307966866e+32,
     1.2180840803727158e+33,
     1.0498668983523472e+33,
     8.6740358331638362e+31,
     1.0283590390599802e+33,
     1.1864593356637721e+33,
     5.7693831085576655e+32,
     9.2818388018453598e+32,
     1.3310289047047081e+33,
     9.7829368017912439e+32,
     1.3408062684292100e+33,
     9.0966785622390680e+32,
     1.1831768562064781e+33,
     1.0357118431009261e+33,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     2.5131155264206263e+35,
     1.5362089366906180e+35,
     2.1586525565193317e+35,
     2.0619339713541591e+35,
     1.3891661533358822e+35,
     1.1864593356637628e+33,
     1.6749430119370572e+35,
     9.8175690951062314e+34,
     8.1161072022589473e+34,
     7.9356881468647788e+34,
     1.2181159860996439e+35,
     1.0541445157418214e+35,
     6.5047211350514257e+34,
     1.8391908334952783e+35,
     1.3208243497686388e+35,
     0.0000000000000000e+00,
     0.0000000000000000e+00,
     },
    {
     7.1137923501213138e+36,
     4.8476923175918830e+37,
     4.2534496840107353e+37,
     3.4518597384531703e+37,
     3.0162270104305339e+37,
     1.1449332589155343e+36,
     4.2486125885649126e+37,
     5.4712085370890153e+37,
     7.2295785693968144e+36,
     3.0388647070335361e+37,
     8.4139758955640660e+36,
     1.7547553145167293e+37,
     3.6093071398116616e+37,
     1.2479197178833196e+37,
     3.5016359822163083e+37,
     3.3168657187816406e+37,
     0.0000000000000000e+00,
     },
    {
     1.2763868031838889e+39,
     5.1255689665109892e+39,
     6.4992711171684041e+39,
     8.1468287101046987e+39,
     8.5348053184033241e+37,
     1.0496748117737663e+39,
     1.5876880521180610e+39,
     5.0214325625465020e+39,
     8.2850970405287510e+39,
     8.9152997229067085e+39,
     9.8314833640873314e+39,
     1.0006174290576121e+40,
     9.1417472795534064e+39,
     3.6547408804409492e+39,
     6.4205997369918175e+38,
     7.3728778067917766e+39,
     8.2226816788796247e+39,
     },
    {
     2.2357355939640369e+40,
     1.4215186835347813e+41,
     3.0163283902755917e+41,
     1.1781406157834396e+42,
     1.7919677246519857e+42,
     7.5996456372420718e+41,
     9.8185275289734474e+41,
     6.7961244492915416e+41,
     1.3996290600466571e+42,
     1.1262066639551005e+42,
     6.8442249573069480e+41,
     1.3275667453191067e+42,
     1.3562756209829227e+41,
     1.5531059724099930e+42,
     1.4236074766845120e+42,
     3.6574935312655208e+41,
     1.5682143977766598e+42,
     1.7286394691894320e+42,
     },
    {
     1.5074074619703530e+44,
     2.5579106458616130e+44,
     8.2338224233547983e+43,
     1.1564780302674217e+44,
     2.7651915751095293e+44,
     1.9838241632217329e+43,
     3.2149690750358179e+44,
     2.6968331911068220e+44,
     2.8185030196689555e+44,
     2.3769684231326981e+44,
     9.0352324717648347e+43,
     5.6654570243949149e+43,
     2.2335146926346782e+44,
     2.9345074512035476e+44,
     2.7042731414243752e+44,
     2.6364597289833165e+44,
     2.8965019813202281e+44,
     1.8678792703357271e+44,
     7.0589625153424525e+43,
     },
    {
     1.9616306839180563e+46,
     1.6217957026902683e+45,
     1.2376379967170514e+46,
     3.5306593982870055e+45,
     5.7405377099273761e+45,
     4.3390485501437634e+46,
     5.0180666198303510e+46,
     7.0997065096312170e+45,
     5.0824021911818874e+46,
     3.6436819752072121e+46,
     3.8679983351158682e+46,
     4.2744299510997312e+46,
     1.7639910605090832e+46,
     1.3953497126161424e+46,
     2.7590520076224583e+46,
     3.6121267723131156e+46,
     5.6295840360400432e+46,
     4.7655449101151305e+46,
     4.7197749639745136e+46,
     3.2101108995446527e+46,
     },
};

constexpr double NMi_2[13][20][2] = {
    {{1.2077714492247507e+19, 3.2396810000000000e+06},
     {4.4728065800598979e+18, 7.0976000000000000e+06},
     {9.7767427984672686e+18, 2.9009920000000000e+06},
     {8.6501885043340739e+18, 5.1594240000000000e+06},
     {3.7831552655121449e+18, 4.7421440000000000e+06},
     {7.5266044835775119e+18, 2.7043840000000000e+06},
     {1.8973971553756119e+18, 3.9196160000000000e+06},
     {6.7824113429061304e+18, 1.5436800000000000e+05},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{9.4651706507163337e+20, 3.2884784650000000e+09},
     {2.9864336753485739e+21, 2.6640563200000000e+09},
     {1.4801445444497546e+21, 8.5983616000000000e+08},
     {2.7707429747822984e+21, 3.1715909120000000e+09},
     {1.3504751605138388e+21, 3.1746288640000000e+09},
     {3.0032292284065015e+21, 3.8771993600000000e+09},
     {2.1593529565868385e+21, 2.0611102720000000e+09},
     {1.9718533985952397e+21, 2.4014218240000000e+09},
     {2.2124225800525924e+21, 3.4376747520000000e+09},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{4.1855722162859012e+22, 5.1902545612900000e+11},
     {1.2886091090089789e+23, 1.4003112960000000e+09},
     {2.3434792741125148e+23, 4.6302262092800000e+11},
     {1.8214187302034364e+23, 8.4780143411200000e+11},
     {6.2757599935695369e+23, 6.6486228608000000e+11},
     {5.3353020118103958e+22, 5.2563972454400000e+11},
     {1.9726479265603602e+23, 1.5235889612800000e+11},
     {4.0162331858882815e+23, 8.8454815872000000e+11},
     {1.0605886629022164e+23, 9.1153228748800000e+11},
     {1.6993054425355677e+23, 9.3309357619200000e+11},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{1.3005130952432858e+26, 2.4210340117657700e+14},
     {8.8706730534334430e+25, 1.8463020881152000e+14},
     {5.6667022929349049e+25, 2.0649372262451200e+14},
     {1.1233315421881774e+26, 2.3611909104102400e+14},
     {4.0630484861571009e+25, 6.5779534244096000e+13},
     {1.5863631315267830e+26, 4.7042083483648000e+13},
     {1.3663575751927593e+26, 8.2425216799488000e+13},
     {1.0255190844903970e+26, 1.2894105847296000e+13},
     {1.0225634399664214e+26, 1.1187713647590400e+14},
     {7.0175021052970098e+25, 2.7293856599552000e+14},
     {1.1643703829537598e+26, 1.8660471958246400e+14},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{2.4980429764878774e+28, 2.0221324735527424e+16},
     {2.8602923035073623e+28, 2.5139373591172352e+16},
     {1.6942180588725104e+28, 3.5791296462097408e+16},
     {1.0466657510623470e+28, 1.5942889734318080e+15},
     {1.0076360245669610e+28, 1.6313324492535808e+16},
     {3.3133176955846105e+28, 1.4990392984243968e+16},
     {6.5085276691317756e+27, 2.2050497242086144e+16},
     {1.1571957349360209e+28, 3.0885994468675072e+16},
     {6.7927428511998436e+27, 1.3101548596785408e+16},
     {3.3044715663743864e+28, 1.7749564257151744e+16},
     {1.5501127183892170e+27, 2.4100834355570176e+16},
     {2.3735297370811618e+28, 2.6774562849588480e+16},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{5.5557826090599668e+30, 3.6501683200582840e+18},
     {2.8602923031326628e+28, 3.7721342635634248e+18},
     {6.8613098774707155e+30, 2.0889866052570317e+17},
     {6.5091592181847929e+30, 1.8258310104428626e+18},
     {7.2346867069525918e+30, 2.0445128116421632e+18},
     {4.8725850838401921e+30, 2.0472797085395497e+18},
     {7.3242631370083971e+29, 1.2708483764722381e+18},
     {1.8782176928604391e+30, 2.2693030215484672e+18},
     {3.5672466457741849e+30, 5.7771347346552013e+17},
     {9.3180006979141796e+29, 8.3853325074659461e+18},
     {6.0508649963231011e+30, 3.2850384191789824e+18},
     {5.2434298540810261e+30, 2.9774072789978532e+18},
     {1.5901056265436043e+30, 4.7770938522454333e+18},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{2.0978065307848374e+32, 1.1850340832643787e+21},
     {1.2180840803707731e+33, 1.9427704819887453e+21},
     {1.0498668983522060e+33, 1.4128821443836903e+20},
     {8.6740358329818188e+31, 1.8204590052938128e+21},
     {1.0283590390593011e+33, 6.7931214263658716e+20},
     {1.1864593356629881e+33, 7.8402976798484595e+20},
     {5.7693831085567489e+32, 9.1787096583719092e+19},
     {9.2818388018378053e+32, 7.5559130740365381e+20},
     {1.3310289047038909e+33, 8.1738436519159608e+20},
     {9.7829368017867620e+32, 4.4831076119323633e+20},
     {1.3408062684284612e+33, 7.4896825921824804e+20},
     {9.0966785622173816e+32, 2.1687080692094085e+21},
     {1.1831768562045293e+33, 1.9489044587722535e+21},
     {1.0357118430986110e+33, 2.3151315710997939e+21},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{2.5131155264192502e+35, 1.3764393522998495e+23},
     {1.5362089366891906e+35, 1.4275694512512295e+23},
     {2.1586525565183404e+35, 9.9137699519926085e+22},
     {2.0619339713527926e+35, 1.3668835433614726e+23},
     {1.3891661533336962e+35, 2.1859463726523574e+23},
     {1.1864593356110420e+33, 5.2730061079550932e+22},
     {1.6749430119364429e+35, 6.1443628018818179e+22},
     {9.8175690950800629e+34, 2.6171552449947561e+23},
     {8.1161072022461379e+34, 1.2809734360316550e+23},
     {7.9356881468606578e+34, 4.1227173713864208e+22},
     {1.2181159860995970e+35, 4.7040892189353454e+21},
     {1.0541445157409334e+35, 8.8810029639046609e+22},
     {6.5047211350472383e+34, 4.1909870923559027e+22},
     {1.8391908334952326e+35, 4.5926042975623793e+21},
     {1.3208243497667322e+35, 1.9067067757508848e+23},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{7.1137923500966630e+36, 2.4657527068758668e+25},
     {4.8476923175862492e+37, 5.6343746720847020e+25},
     {4.2534496840045915e+37, 6.1441597764926059e+25},
     {3.4518597384473344e+37, 5.8360804127500574e+25},
     {3.0162270104299096e+37, 6.2455459537280459e+24},
     {1.1449332589033412e+36, 1.2198882714098526e+25},
     {4.2486125885619762e+37, 2.9367369473637278e+25},
     {5.4712085370877506e+37, 1.2649832397087169e+25},
     {7.2295785693606694e+36, 3.6146999377688997e+25},
     {3.0388647070265517e+37, 6.9853239089066539e+25},
     {8.4139758955603259e+36, 3.7417349054861184e+24},
     {1.7547553145164526e+37, 2.7698392263694184e+24},
     {3.6093071398060685e+37, 5.5933515690167754e+25},
     {1.2479197178797825e+37, 3.5372825329599497e+25},
     {3.5016359822121875e+37, 4.1216040749667391e+25},
     {3.3168657187812345e+37, 4.0677908885370947e+24},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{1.2763868031800276e+39, 3.8614580965102841e+27},
     {5.1255689665020080e+39, 8.9817320706940410e+27},
     {6.4992711171676195e+39, 7.8459286544730954e+26},
     {8.1468287100896826e+39, 1.5016761368361557e+28},
     {8.5348053172329630e+37, 1.1704743545359565e+28},
     {1.0496748117732295e+39, 5.3765133443125811e+26},
     {1.5876880521149697e+39, 3.0922785551567657e+27},
     {5.0214325625269186e+39, 1.9584393237906563e+28},
     {8.2850970405274055e+39, 1.3461525149674079e+27},
     {8.9152997228939410e+39, 1.2768518025853210e+28},
     {9.8314833640756048e+39, 1.1726927419435281e+28},
     {1.0006174290567445e+40, 8.6774220614928942e+27},
     {9.1417472795531247e+39, 2.8221091929007865e+26},
     {3.6547408804262003e+39, 1.4749050500828119e+28},
     {6.4205997368442560e+38, 1.4756839167503550e+28},
     {7.3728778067723891e+39, 1.9388599201341922e+28},
     {8.2226816788619285e+39, 1.7697272157470948e+28},
     {0.0, 0.0},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{2.2357355938508273e+40, 1.1321064978579413e+30},
     {1.4215186835324633e+41, 2.3184690486477147e+29},
     {3.0163283902291442e+41, 4.6448512756427759e+30},
     {1.1781406157827241e+42, 7.1580746323020446e+29},
     {1.7919677246471657e+42, 4.8199532724915759e+30},
     {7.5996456371993597e+41, 4.2714395293271840e+30},
     {9.8185275289691147e+41, 4.3339089621859648e+29},
     {6.7961244492626698e+41, 2.8872114908698101e+30},
     {1.3996290600440713e+42, 2.5857683357030958e+30},
     {1.1262066639531275e+42, 1.9731969899687317e+30},
     {6.8442249572595380e+41, 4.7412158441365509e+30},
     {1.3275667453168973e+42, 2.2095092792265079e+30},
     {1.3562756209603860e+41, 2.2537471861748087e+30},
     {1.5531059724055475e+42, 4.4454574619586170e+30},
     {1.4236074766835681e+42, 9.4415671577011044e+29},
     {3.6574935312222764e+41, 4.3244667630925400e+30},
     {1.5682143977732121e+42, 3.4477719938392551e+30},
     {1.7286394691874739e+42, 1.9583035066332076e+30},
     {0.0, 0.0},
     {0.0, 0.0}                                      },
    {{1.5074074619695917e+44, 7.6151599230308207e+31},
     {2.5579106458580953e+44, 3.5180611801042147e+32},
     {8.2338224233386595e+43, 1.6139606802936542e+32},
     {1.1564780302645683e+44, 2.8535626670354837e+32},
     {2.7651915751052462e+44, 4.2834221252251373e+32},
     {1.9838241631710110e+43, 5.0722063175139061e+32},
     {3.2149690750343039e+44, 1.5143193089280373e+32},
     {2.6968331911029208e+44, 3.9012032733490489e+32},
     {2.8185030196682868e+44, 6.6890183720504831e+31},
     {2.3769684231266372e+44, 6.0611803360948673e+32},
     {9.0352324717015948e+43, 6.3242815721525181e+32},
     {5.6654570243709404e+43, 2.3976110858337992e+32},
     {2.2335146926287175e+44, 5.9609275107177903e+32},
     {2.9345074512033515e+44, 1.9633702036824506e+31},
     {2.7042731414197839e+44, 4.5916570617258605e+32},
     {2.6364597289794090e+44, 3.9076265600753098e+32},
     {2.8965019813194049e+44, 8.2333695913871006e+31},
     {1.8678792703345549e+44, 1.1724157264305395e+32},
     {7.0589625152878960e+43, 5.4559774842482395e+32},
     {0.0, 0.0}                                      },
    {{1.9616306839167075e+46, 1.3493879837587598e+34},
     {1.6217957025398337e+45, 1.5043529637396788e+35},
     {1.2376379967104048e+46, 6.6468372991593592e+34},
     {3.5306593982697857e+45, 1.7225598667694106e+34},
     {5.7405377098685673e+45, 5.8816318626779745e+34},
     {4.3390485501396643e+46, 4.0992413545366299e+34},
     {5.0180666198234388e+46, 6.9123573894683711e+34},
     {7.0997065096001950e+45, 3.1025419592731752e+34},
     {5.0824021911774750e+46, 4.4129062748694719e+34},
     {3.6436819752053430e+46, 1.8692255183676322e+34},
     {3.8679983351119091e+46, 3.9598350779679756e+34},
     {4.2744299510869371e+46, 1.2794248572343291e+35},
     {1.7639910605039741e+46, 5.1099576961501650e+34},
     {1.3953497126059901e+46, 1.0153053288647545e+35},
     {2.7590520076132095e+46, 9.2495618723867920e+34},
     {3.6121267723003195e+46, 1.2796293204935231e+35},
     {5.6295840360328409e+46, 7.2027738631253206e+34},
     {4.7655449101146590e+46, 4.7241118738071323e+33},
     {4.7197749639580524e+46, 1.6461435755626455e+35},
     {3.2101108995296508e+46, 1.5002195164541198e+35}}
};

} // namespace oz2_table
