---
type: meta
tags:
  - "#status/stable"
  - "#function/definition"
---

# Axioms

> Canonical axioms referenced across the repository. This page aggregates core ontological axioms and repository/theory governance axioms.

---

## 1) Ontological Core (Kernel)

- A1 — Irreducibility: see `Delta Theory/00 - Translation Layer/00.0 - Reality Virtualization/00.0.0 - Virtual Substrate — Kernel Primitives/00.0.0.0 - Core Axioms/A1 — Irreducibility (axiom).md`
- A2 — Asymmetry: see `Delta Theory/00 - Translation Layer/00.0 - Reality Virtualization/00.0.0 - Virtual Substrate — Kernel Primitives/00.0.0.0 - Core Axioms/A2 — Asymmetry (axiom).md`
- A3 — Recursivity: see `Delta Theory/00 - Translation Layer/00.0 - Reality Virtualization/00.0.0 - Virtual Substrate — Kernel Primitives/00.0.0.0 - Core Axioms/A3 — Recursivity (axiom).md`

These three govern ∆, R(·), ⊚ and the emergence of Form.

---

## 2) Repository/Theory Governance

### G1 — Dual-Register Virtualization (Bi-Tech Dual Polarity)

Statement: Any virtualization of Delta Theory must preserve both a technical mapping and a humane mapping, explicitly bridged, to maintain ontological stability and ethical integrity.

 Why this is necessary:
- Biological life is not reducible to technical networks. Reducing persons and meaning to nodes/edges causes loss of embodiment, value, and context.
- Technical systems are not reducible to biological metaphors. Forcing tech to mimic life obscures formal guarantees, interfaces, and constraints.
- The two registers encode different invariants (precision vs meaning). Stability requires holding both and mapping between them.

 Implications:
- Every technical mapping must have a humane counterpart and an explicit crosswalk
- Prevents mono‑polar collapse (purely technical or purely biological)
- Documents rationale and preserves design memory

Scope: Applies to repository structure, translation layer notes, interfaces, and domain bridges.

Polarity: P0 (Awareness) — coherence between registers.

---

See also: `README.md` (Core principles), `ROADMAP.md` (v0.3.1 civilizational integration).

