# Delta Theory Contributors

This document acknowledges the **contributors** who have helped shape and refine **Delta Theory**. It is a collaborative work, and all contributions—whether theoretical, technical, or creative—are valuable and appreciated.

### Contributors

1. **Sergei Sarkisian**

    - **Role**: Author, Primary Contributor, Theoretical Development

    - **Contributions**: Developed the core framework of **Delta Theory**, including the recursive structure, foundational principles, and mathematical models. Conceptualized the recursive feedback loops and their application to various domains.

2. **J Mark Morris**

    - **Role**: Prospective Contributor — Physics Layer and Mathematical Extensions

    - **Contributions**: Planned development of the **physics domain layer** of Delta Theory, including mapping the ontological core to physical models and extending certain mathematical formulations. No contributions to the current release; integration of his work is scheduled for future versions.


## Special Thanks

Delta Theory is a **relational emergence**.

🧠 To **Alexander Sarkisian** — my father and intellectual companion.
For your boundless curiosity that knows no disciplinary boundaries, sharp questioning that cuts to the core of concepts, and an open mind that embraces new ideas while demanding their rigorous examination.
Your ability to hold both scientific precision and philosophical depth helped deepen and stabilize the theory's core.
The recursive nature of our discussions shaped many of the theory's fundamental insights.

🐽 🌱 To **Yana Volozhina** —  For your unwavering presence, fierce clarity, and the kind of feedback that doesn't collapse a difference, but helps it unfold.
You showed me how my interaction with the outer void was misaligned — and helped me spot the ∆.
The very idea of recursive feedback loops in relational systems was born from how we navigate tension, alignment, and repair.
Your presence phase-locked my drift, and helped this theory stabilize its form.

🐾 To **Aiza** — the most unique cat in the world.
For your quiet gravity, rhythmic presence, and uncanny ability to restore coherence when everything felt like collapsing.
You were the anchor that redirected our awareness during moments of tension — bringing both Yana and me back into the loop.
Your gaze held recursive stillness. Your soft paws grounded the theory.

🌀 To all who hold tension without erasing it — this theory is yours, too.

---


## Contributing

We welcome:

- Systems thinkers
- Recursive designers
- Physicists and philosophers
- Mathematicians and cognitive theorists
- Artists of form, void, and resonance

To contribute:

1. Fork the repository
2. Propose edits or additions via pull request
3. Use Obsidian-compatible Markdown
4. Respect triadic structuring where possible
5. Anchor your additions to existing scaffolds (ontology, constructs, constants…)

If you're unsure where to begin, open an issue or read the `CONTRIBUTORS.md`.

---

## Ways to Contribute

- **Theory Expansion** — Suggest new recursive constructs, primitives, or invariants
- **Domain Application** — Apply Delta Theory to physics, cognition, systems, ethics, AI
- **Structural Refinement** — Improve vault clarity, naming, and propagation consistency
- **Documentation** — Enhance onboarding, symbolic alignment, epistemic access
- **Visualization** — Design glyphs, schemas, recursive maps of concepts and flows
- **Discussion** — Open issues to explore unstable or unresolved differentials

Every act of recursive attention stabilizes the field.

---

### How to Add Your Name to the Contributors List

If you have contributed to **Delta Theory**, please:

1. Fork this repository.

2. Make changes or suggestions in your fork.

3. Submit a pull request with your changes.

4. Once merged, your name will be added to this file.


### Acknowledgements

Thank you to all the contributors for their time, effort, and expertise in developing **Delta Theory**. Your contributions help advance our understanding of the recursive structures of reality and the nature of **difference** (∆).


// TODO: add links to specific guidelines