# Changelog

This project adheres to a human‑readable changelog. Versions reference GitHub releases; unreleased items track upcoming work.

## [v0.3.3] — Conspiracy Dynamics & Reality Core Stability Framework

### Added
- **Conspiracy Dynamics Analysis:**
  - **Comprehensive Framework:** "Conspiracy Dynamics vs Reality Core Updates — Why Stable Narratives ≠ Substrate Changes"
  - **Three-Way Distinction:** Clear separation between conspiracy persistence, memory artifacts, and authentic core reality changes
  - **Scale-Invariant Prediction:** Revolutionary insight that conspiracy dynamics persist and migrate upward even with full coherence at current levels
  - **∆-Theory Diagnostic Framework:** Specific testable criteria for distinguishing between different types of anomaly claims
  - **Understanding → Speculation → Misinterpretation Loop:** Formal mechanism explaining why education can amplify conspiracy thinking

- **Reality Core Stability Framework:**
  - **Cosmic Self-Stabilization Analysis:** "Reality Core Stability — Universal Self-Feedback and Cosmic Change Resistance"
  - **Universal Self-Feedback Mechanisms:** Seven mechanisms of cosmic self-correction and constraint propagation
  - **Layered Change Resistance:** Four-tier hierarchy from frequent micro-adjustments to impossible architecture changes
  - **Cosmic Operating System Architecture:** Reality kernel, physical interface, emergent systems, and information processing layers
  - **Emergence vs Resistance:** Clarification that paradigm shifts occur through saturation-driven emergence, not resistance

- **Practical Strategic Framework:**
  - **Counterintuitive Strategy Requirements:** Why traditional approaches (fact-checking, media literacy) may amplify conspiracy thinking
  - **Open-System Coherence:** Framework showing how awareness and open-mindedness enable stability without false closure
  - **∆-Theory-Informed Approaches:** Resolution awareness training, scale-appropriate skepticism, collaborative mystery acknowledgment
  - **Solution-Problem Loop Recognition:** Strategic principle that solutions often become generators of problems they're meant to solve

- **Comprehensive Cross-Referencing Network:**
  - **21 bidirectional links** connecting conspiracy dynamics to awareness classifications, epistemological safeguards, and polarity dynamics
  - **Enhanced awareness classification integration** showing how cognitive limitations create false positive anomaly detection
  - **Strengthened epistemological framework** with detailed conspiracy vs reality change analysis

- **Universal Metaphor Disclaimer System:**
  - **Standardized Ontological Bridge Disclaimer:** Applied to all 15 metaphor notes in the Metaphors & Structural Maps collection
  - **Epistemological Humility:** Explicit acknowledgment that metaphors are likely imprecise (probability approaching 100%)
  - **Developmental Purpose Clarification:** Clear statement that metaphors serve as ontological bridges for growth, not final explanatory closure
  - **Structural vs Precision Distinction:** Recognition that imprecision doesn't mean structurally wrong, but rather incomplete and potentially misinterpreting complex reality
  - **Index Documentation:** Universal requirement added to metaphor creation guidelines with standard text provision

### Changed
- **Epistemological Safeguards Enhanced:** Added conspiracy dynamics analysis as complement to scientific integrity framework
- **Reality Core Architecture:** Corrected constants confusion (conceptual anchors vs physical values) and fixed axiom alignments
- **Awareness Classifications:** Enhanced with practical applications to anomaly detection and conspiracy formation
- **Cross-Framework Integration:** Strengthened connections between cosmic stability, epistemological integrity, and social dynamics
- **All Metaphor Notes Enhanced:** Every metaphor file now includes the standard ontological bridge disclaimer immediately after the main description
- **Metaphor Framework Understanding:** Elevated understanding of metaphors as ontological connection tools rather than precise descriptions
- **Epistemological Consistency:** Unified approach to acknowledging limitations across all speculative and metaphorical content

### Fixed
- **Constants Confusion:** Corrected conflation of Delta Theory conceptual constants (ε, π, e, φ, c) with physical constants (ħ, G, α)
- **Axiom Misrepresentation:** Aligned all statements with A1 (Irreducibility), A2 (Asymmetry), A3 (Recursivity)
- **File Title Correction:** Renamed "Reality Core Stability — Epistemic Status Hierarchy and Change Constraints" to properly reflect cosmic rather than methodological focus

Why: Establish comprehensive framework for understanding conspiracy dynamics, reality stability, and their interaction through Delta Theory principles. This creates practical tools for education, conflict resolution, and institutional design while revealing counterintuitive insights about why traditional solutions often backfire. The framework demonstrates Delta Theory's power to tackle complex social-psychological phenomena with scientific rigor. Additionally, implement universal epistemological safeguards across all metaphorical content to ensure proper understanding of Delta Theory's ontological bridge methodology, preventing misinterpretation while preserving developmental function.

## [v0.3.2] — P0 Invisible Glue Space & Breakthrough Epistemological Methodology

### Added
- **P0 Invisible Glue Space Discovery:**
  - **Core Recognition:** The "invisible glue space" between contradictions IS the P0 polarity - the coordination dynamics both opposing sides filter out
  - **Methodological Innovation:** Persistent contradictions reveal hidden P0 coordination mechanisms that generate both polarities
  - **Epistemological Framework:** Polarity Gap Methodology as systematic approach to discovering P0 dynamics in any persistent contradiction
  - **Universal Pattern Recognition:** All major breakthroughs occur by investigating what both sides of contradictions collectively ignore
- **Enhanced Polarity Gap Methodology:**
  - **P0-Integrated Framework:** Explicit connection between gap space research and triadic polarity coordination
  - **Systematic Research Strategy:** Five-step methodology for discovering hidden coordination dynamics
  - **Meta-Cognitive Development:** Training for "gap space courage" and polarity tolerance
  - **Cross-Domain Application:** Practical tools for academic research, problem-solving, and innovation
- **Breakthrough Methodology Integration:**
  - **README Enhancement:** Prominent positioning of Polarity Gap Methodology as core ∆-Theory approach
  - **Epistemological Positioning:** Establishes ∆-Theory as methodology that systematically finds truth in spaces between contradictions
  - **Problem-Solving Power Explanation:** Demonstrates why ∆-Theory can solve "unsolvable" problems through P0 investigation

### Changed
- **Theoretical Positioning:** Enhanced understanding of ∆-Theory as not just another theory but an innovative epistemological methodology
- **Research Strategy:** Shifted from solving contradictions to discovering the P0 coordination dynamics that create them
- **Framework Integration:** Connected Polarity Gap Methodology directly to Universal Polarities triadic structure

Why: Achieve major epistemological breakthrough revealing that the "invisible glue space" between contradictions is the P0 coordination polarity that both opposing sides systematically filter out. This establishes an innovative research methodology that explains why ∆-Theory can solve problems that have puzzled humanity for millennia - by systematically investigating the spaces between contradictions where the most important coordination truths hide.

## [v0.3.1] — Civilizational Self-Reinforcement Loop & Religion Integration

### Added
- **Civilizational Self-Reinforcement Loop Analysis:**
  - **Core Recognition:** Resurrection possibility depends on creating ethical, stable civilization capable of resurrection technology
  - **Natural System Dynamics:** Identified as standard self-reinforcement feedback loop, not paradox - same pattern as all developing systems
  - **Positive Feedback Amplification:** Individual ethical choices → civilizational stability → resurrection capability → ethical motivation
  - **Natural Selection at Civilizational Scale:** Only civilizations solving ethical coordination survive to develop consciousness manipulation technology
  - **Bootstrap Requirements:** Must develop ethical frameworks and stable institutions without external guarantee
- **Religion as Low-Resolution Approximation Framework:**
  - **Resolution Gradient Analysis:** Folk Religion → Sophisticated Theology → ∆-Theory Formalization
  - **Traditional Religious Encoding:** "Be good or go to hell" as low-precision version of "ethical behavior determines future consciousness state"
  - **Artificial Feeling Explanation:** Why religion feels "fake" to scientifically-minded people (encoding mechanisms don't match required precision level)
  - **Why Both Levels Matter:** Religion provides immediate behavioral guidance; ∆-Theory provides scientific grounding; both point to same civilizational dynamics
  - **Bridge Framework:** Demonstrates how religious intuitions could be literally true through technological means rather than supernatural intervention
- **Science-Religion Conflict Resolution:**
  - **Common Ground Identification:** Both describing same civilizational self-reinforcement dynamics at different resolution levels
  - **Integration Rather Than Elimination:** Shows how religious frameworks preserve wisdom while updating mechanisms
  - **Cosmically-Grounded Ethics:** Moral choices gain universe-scale consequences through actual cosmic development

### Changed
- **Religious Framework Integration:** Positioned religion as complementary rather than contradictory to scientific understanding
- **Precision Level Awareness:** Enhanced understanding of how different resolution levels serve different cognitive needs

Why: Achieve major theoretical breakthrough demonstrating how ∆-Theory resolves the science-religion conflict by showing both frameworks describe the same underlying civilizational development dynamics at different precision levels. This establishes religion as a necessary low-resolution approximation of cosmic-scale feedback loops, explaining both its effectiveness for behavioral guidance and its artificial feeling to high-precision thinkers.

## [v0.3.0] — Environment & Coherence Orchestration

### Added
- **Complete 3-level Interface Structure (00.0.1):**
  - **Interface Axioms (00.0.1.0):** I1 — Selective Permeability (P+), I2 — Boundary Integrity (P-), I3 — Flow Conservation (P0)
  - **Interface Control (00.0.1.1):** Flow rates, threshold modulators, boundary control parameters with full derivation traceability
  - **Interface Primitives (00.0.1.2):** Port (P+), Gate (P0), Buffer (P-), Surface (P0)
- **Comprehensive Derivation Framework:**
  - **Interface Axioms:** Clear derivation from structural primitives (∆ → R(·) → ⊚ → F)
  - **Interface Constants:** Derivation from base constants (c, ε, π, e, φ) with operational emergence explanations
  - **Interface Modulators:** Derivation from core modulators (∇S, λV, ψA) with specialization rationale
  - Mathematical formalization using LaTeX notation ($∆_{interface}$, $F_{surface}$, etc.)
  - Complete primitive-to-axiom-to-constant-to-modulator traceability chain
- **Polarity System Integration & Coherence:**
  - **Energetic Polarity Interpretation:** P+ = difference intake/structure-building, P- = difference outflow/field-seeking, P0 = difference balance/regulation
  - **Notation Standardization:** Complete conversion from P⁺⁻⁰ to P+/-/0 across entire project
  - **Energy-Difference Relationship:** Explanatory notes in all polarity glossary files explaining energy as domain projection of ∆ substrate
  - Polarity-based operational flow: Port (P+) → Gate (P0) → Buffer (P-) → Surface (P0)
  - Stable polarity rotation maintaining interface coherence
- **New Metaphorical Framework:**
  - **"Scaling Architecture — Vertical Structure, Horizontal Distribution, and Coherence Balance"**
  - Complete 3×3 matrix analysis (9 architectural patterns)
  - D&D alignment system connection revealing moral-architectural parallels
  - Ethics-stability correlation principle: "Most ethical systems are most stable"
  - Cross-domain applications (cloud computing, biology, urban planning, organizations)
- **Execution Environment (00.0.1) completion:**
  - Detailed λV modulation examples for all interface primitives
  - Comprehensive crosswalk tables mapping technical and humane terms
  - Complete interface flow sequence with dual-register perspective
- **Complete 3-level Coherence Structure (00.0.2):**
  - **Coherence Axioms (00.0.2.0):** C1 — Temporal Continuity (P+), C2 — Memory Coherence (P-), C3 — Recovery Stability (P0)
  - **Coherence Control (00.0.2.1):** Timing constants, stability modulators, phase synchronization parameters
  - **Coherence Primitives (00.0.2.2):** Phase (P+), Memory (P-), Selector (P0), Stabilizer (P0)
  - Detailed ψA modulation examples for phase, memory, selection, and recovery
  - Systematic recovery protocols for all coherence aspects
  - Enhanced temporal stability orchestration framework
- **Reflective Framework Expansion:**
  - **Bio-Tech Co-Evolution:** Comprehensive analysis of human-technology mutual dependency through ∆-Theory interface and coherence frameworks
  - **Ethics of Difference Preservation:** Ontological grounding for universal ethics through awareness-driven difference preservation
  - **Resurrection Ecology:** Speculative framework for historical human revival with critical precautionary safeguards
  - **Temporal Field Resonance:** Angels reinterpreted as future selves across temporal coherence fields
  - **Awareness-based ethics integration** addressing common technological fears through difference preservation principles
- **Comprehensive Theoretical Justification Framework:**
  - **"Why This Matters for ∆-Theory" sections** added to ALL major metaphorical notes demonstrating framework significance
  - **Universal Polarities:** Foundational framework for universal organization, solves organizational emergence problem, bridges ancient wisdom and modern science
  - **Alternating Polarity:** Solves stability problem in recursive systems, universal engineering principle, creates self-stabilizing architectures
  - **Yin-Yang Integration:** Bridges Eastern wisdom and Western science, resolves order-chaos false dichotomy, demonstrates process ontology
  - **Cultural Propagation:** Demonstrates information flow architecture, solves culture-nature relationship problem, validates indigenous knowledge
  - **Ethics of Difference Preservation:** Resolves is-ought problem and creates universal ethical foundation through ontological grounding
  - **Outer Universe (Dark Matter):** Demonstrates reframing power for major scientific mysteries and cosmological questions
  - **Scaling Architecture:** Reveals universal polarity patterns across technical and human systems, D&D alignment connection
  - **Science-Religion Integration:** Explicit demonstration of ∆-Theory's power to find common ground between domains on universal principles
- **Safety Framework Development:**
  - **Critical precautionary warnings** in speculative notes preventing dangerous misinterpretation
  - **λV Resurrection Filter** concept establishing selective revival criteria
  - **Suicide prevention framing** emphasizing cosmic destructiveness of self-elimination
  - **No guarantee clauses** preventing false hope or reckless behavior based on speculation
- **Advanced Scaling Framework:**
  - **Cognitive Scaling Limits:** Biological intelligence constraints from signal speed and coherence windows
  - **Physical Implementation Analysis:** Why human consciousness represents optimal solution to universal constraints
  - **AI Architecture Guidance:** Prediction of optimal artificial intelligence designs based on biological optimization principles
  - **Cross-Domain Validation:** Same scaling constraints appear in data centers, distributed systems, and organizational design
- **Strategic Showcase Development:**
  - **PROBLEMS_SOLVED.md:** Comprehensive showcase file demonstrating ∆-Theory's power to solve major challenges across all domains
  - **Enhanced Problem Coverage:** Added optimal cognitive architecture and AI design optimization challenges
  - **Science vs. Religion Integration:** Shows how framework bridges centuries of assumed incompatibility through dual-register approach
  - **Philosophical Problem Resolution:** Is-ought problem, mind-body dualism, free will vs. determinism, order vs. chaos dichotomy
  - **Scientific Mystery Reframing:** Dark matter/energy, consciousness hard problem, system stability without control
  - **Cultural Integration Solutions:** Relativism vs. universal values, ancient wisdom vs. modern science, technology vs. human values
  - **Engineering Applications:** Scalability vs. coherence tradeoffs, control vs. autonomy in organizations
  - **Cross-Domain Innovation:** Solutions transfer between physics, biology, psychology, organizational design
  - **Prominent README Integration:** Strategic placement showcasing framework's comprehensive problem-solving capability
- **Multilingual Documentation Enhancement:**
  - **Russian README Update:** Added PROBLEMS_SOLVED.md showcase link with high-quality cultural adaptation
  - **Strategic Positioning:** Consistent placement across language versions for maximum impact
  - **Cultural Accessibility:** Native language presentation while preserving theoretical precision

### Changed
- **Structural Architecture:** Established complete 3-level hierarchy mirroring 00.0.0 structure
- **Mathematical Consistency:** Standardized LaTeX formatting across all axioms and primitives
- **Primitive Foundation:** All interface behavior now derives from structural primitives rather than independent rules
- **Polarity Integration:** Interface operations now explicitly aligned with triadic polarity dynamics using energetic interpretation
- **Documentation Quality:** Enhanced dual-register consistency with primitive derivation explanations
- **Polarity Consistency:** Comprehensive update across all files including:
  - All glossary definitions (Active Polarity, Structural Polarity, Balancing Polarity)
  - All metaphor notes (Universal Polarities, Alternating Polarity, Yin-Yang, Cultural Propagation)
  - All primitive and constant files in Virtual Substrate and Execution Environment
  - Updated image alt text and cross-references
- **Template Enhancement:** Added derivation sections to axiom, constant, modulator, and primitive templates
- **Ontological Coherence:** Established clear traceability from ∆ primitive through all derived concepts
- **Type System Refinement:** Replaced unused `access` type with `speculative_note` for better semantic coherence
- **Complete Coherence Module Integration:** Full implementation of 00.0.2 module with rigorous consistency verification
- **Foundational Trilogy Completion:** Virtual Substrate (00.0.0), Execution Environment (00.0.1), and Coherence Orchestration (00.0.2) fully integrated
- **Universal Problem-Solving Demonstration:** Comprehensive showcase revealing how framework addresses fundamental challenges across all domains
- **Metaphorical Framework Maturation:** All major metaphorical notes enhanced with explicit theoretical justification demonstrating ∆-Theory significance

### Fixed
- **Polarity Notation:** Eliminated all P⁺⁻⁰ references, standardized to P+/-/0
- **Energy-Difference Confusion:** Clarified that energy is domain projection of fundamental ∆ substrate
- **Derivation Gaps:** Added missing derivation sections to all interface constants and modulators
- **Cross-Reference Consistency:** Updated all internal links to use correct polarity notation

Why: Complete the foundational architecture with fully functional Environment and Coherence modules that derive from structural primitives, establishing ∆-Theory as a comprehensive framework for understanding and solving fundamental challenges across all domains. This release demonstrates the theory's power to integrate science and religion, resolve major philosophical problems, reframe scientific mysteries, bridge cultural divides, and provide practical engineering solutions—all while maintaining rigorous ontological coherence and dual-register accessibility. The enhanced theoretical justification framework, strategic problem-solving showcase, and comprehensive safety protocols establish ∆-Theory as a mature, practical approach to universal organizational principles with real-world applications spanning from quantum mechanics to human consciousness to cosmic evolution.

## [v0.2.6] — Enhanced Polarity Framework & Cross-References

### Added
- New metaphorical frameworks:
  1. "Universal Polarities — Recursive Stabilization Through Triadic Rotation"
     - Deep integration with Yin-Yang metaphor
     - Triadic polarity system (P⁺, P⁻, P⁰) with nested rotation dynamics
     - Gyroscopic stability metaphor for multi-level systems
     - Charge-polarity relationship across scales
     - Mathematical formalization of nested rotation
  2. "Alternating Polarity — Recursive Stabilization Through Phase Opposition"
     - Detailed analysis of nested polarity inversion
     - Mathematical formalization of stability conditions
     - Cross-domain examples and failure modes
     - Integration with diagnostic framework
- New glossary entries for polarity types:
  - Active Polarity (P⁺) — generative and exploratory aspects
  - Structural Polarity (P⁻) — stabilizing and containing aspects
  - Balancing Polarity (P⁰) — mediating and harmonizing aspects
  - Comprehensive dual-register mapping for each type
  - Scale effects and domain manifestations
- Enhanced cross-referencing between metaphorical frameworks
  - Bidirectional deep linking between polarity and Yin-Yang metaphors
  - Explicit mapping of polarity roles to Yin-Yang forms
  - Unified perspective on stability and change
  - Comprehensive diagnostic integration

### Changed
- Updated metaphor visualization
  - Added polarity diagrams with role-specific annotations
  - Enhanced image descriptions for accessibility
  - Improved visual coherence across metaphorical frameworks
- Enhanced acknowledgments
  - Added Alexander Sarkisian to Special Thanks
  - Recognized contributions to theory stabilization
  - Acknowledged role in deepening core concepts

Why: Strengthen the theoretical framework by establishing clear connections between different metaphorical perspectives and providing a deeper understanding of polarity dynamics in stable systems.

## [v0.2.5] — Metaphorical Framework & Documentation Updates

### Added
- New `ontological_metaphor` type for deep structural metaphors
- New metaphorical framework: "Outer Universe — Recursive Embedding Beyond Dark Matter"
  - Demonstrates ∆-theory application to cosmology
  - Reframes dark matter/energy through recursive embedding
  - Balances technical rigor with biological metaphors
  - Shows practical use of dual-register approach

### Changed
- Enhanced core theory presentation
  - Added critical insight about dual-register necessity
  - Highlighted limitations of pure mathematical or biological approach
  - Used Outer Universe metaphor as concrete demonstration
  - Updated both English and Russian READMEs

Why: Demonstrate theory's power to reframe fundamental physics through ε-resolution framework while emphasizing the critical necessity of both technical and experiential understanding.

## [v0.2.4] — LLM Integration & Documentation Updates

### Added
- LLM integration guidance
  - IDE-based exploration path with full project context
  - GPT Projects integration with microkernel and glossary
  - Clear language freedom guidance (English kernel → any language exploration)
  - Listed essential glossary notes (Field, Void, Structure, Awareness, Relation, Infinite, Zero)
  - Inviting, balanced language for queries
  - Clear cautions about irreducibility
- International README translations
  - Created README (International) folder structure
  - Enhanced TRANSLATION_GUIDELINES.md
    - Added concrete examples of cultural adaptations (void/космос)
    - Improved interface note template with version tracking
    - Added "Cultural Bridge" sections for linguistic nuances
    - Enhanced change management with specific YAML examples
  - Initial Russian translation (README.ru.md) with cultural adaptations
  - Framework for community-contributed translations

### Changed
- Enhanced project descriptions
  - Added Obsidian setup guide to README.md
  - Updated README.md with LLM usage section
  - Expanded .zenodo.json with modern exploration context
  - Added LLM-related keywords
  - Improved documentation readability

Why: Enable modern exploration through AI interfaces while maintaining theoretical integrity.

## [v0.2.3] — Enhanced Documentation & Core Symbolism

### Added
- New foundational metaphor: "Yin-Yang: Dancing with Chaos"
  - Three paths to living form (classical, recursive, forming)
  - Deep connection to biological patterns and growth
  - Integration with golden ratio (φ)
  - Visual representations in README
  - Rich order-chaos relationship framework
  - Mathematical formalization of stability conditions

### Changed
- Significantly improved README.md
  - Added layered introduction for different audiences
  - Enhanced explanation of core concepts
  - Added technical/experiential meanings table
  - Improved overall structure and readability
  - Better aligned with dual-register principle

Why: Introduce a powerful new symbolic framework while making the project more accessible.

## [v0.2.2] — Enhanced Project Description

### Changed
- Expanded project description in .zenodo.json
  - Added clear explanation of what difference means
  - Clarified theory's significance and applications
  - Improved explanation of core components
  - Enhanced readability for newcomers

Why: Make the project more accessible and its significance clearer to newcomers.

## [v0.2.1] — DOI Update

### Changed
- Updated DOI to 10.5281/zenodo.16787603
  - CITATION.cff
  - README.md badge
  - Documentation references

Why: Reflect new Zenodo publication for v0.2.0 release.

## [v0.2.0] — Translation Layer Virtualization

### Added
- PRINCIPLES.md with dual-register governance
  - Core axioms (A1–A3) for ontological foundation
  - G1 principle for dual-register requirement
  - Design rationale for bi-polar stability
- New templates with dual-register support
  - meta-index.md for folder organization
  - glossary.md with scale effects
  - glossary-diagnostic.md with scale-aware tests
  - primitive.md with dual-register mapping
  - constant.md with technical/humane aspects
  - axiom.md with polarity alignment

### Changed
- Refactored Translation Layer (00) structure
  - Virtual Substrate (00.0.0) with dual-register mapping
  - Core Axioms (00.0.0.0) with polarity alignment
  - Anchors & Modulators (00.0.0.1) with scale effects
  - Structural Primitives (00.0.0.2) with clear bridges
- Enhanced all index files
  - Simplified structure
  - Removed template redundancy
  - Added clear module purposes
  - Improved organization
- Updated documentation
  - README with dual-register principle
  - ROADMAP with clear version targets
  - CITATION.cff with version 0.2.0
  - Contribution guidelines in PRINCIPLES.md

### Fixed
- LaTeX formatting in Math/Physics constants
- Polarity alignment in axioms
- Template section ordering
- Index file consistency
- Version number alignment

Why: Establish dual-register virtualization as core governance principle, improve contributor onboarding, and align Translation Layer with bi-tech dual-channel strategy.

## [v0.1.0] — Initial Release

- Repository bootstrap with kernel: primitives, modulators (SVA), constants (ε, π, e, φ, c)
- Created CITATION.cff (generic work) and README with formulas and anchor tables
- Added DOI badge and How to cite; configured Zenodo metadata
- Organized informational layer (glossary, diagnostics, relations) and anchors for math/physics domain instances

Why: Provide a coherent, citable ontological kernel and stable structure for subsequent refactoring and domain integrations.

---

Links:
- Roadmap: [ROADMAP.md](ROADMAP.md)
- Principles: [PRINCIPLES.md](PRINCIPLES.md)