# DOVE

## A socio-demographic Dataset fOr Varieties of English

### About

This dataset comprises extensive socio-demographic information for spontaneous spoken varieties of English around the world. The extra-linguistic triggers (aka socio-demographic information) 
can be broadly assigned to the categories geography, language contact/isolation, and demography. 

DOVE was compiled as part of the project [Extra-linguistic triggers of Morphosyntactic Variation in Englishes](https://sites.google.com/site/katlehret/research/MoVE) (MoVE). 
It was specifically designed for studying the relationship between extra-linguistic triggers and morphosyntactic variation in spontaneous spoken English varieties, with a focus on language 
complexity. DOVE builds on and complements the information contained in the [electronic World Atlas of Varieties of English ](https://ewave-atlas.org/) (eWAVE), the currently largest database 
of non-standard morphosyntactic features for English varieties (Kortmann et al. 2020). Yet, the varieties sampled in DOVE are not restricted to eWAVE varieties.

### Sources

All information contained in DOVE was estimated, extrapolated or derived from open-access sources including governmental census data, non-governmental surveys, and language projects, as well as published scientific work. Detailed information and acknowledgement of all sources is provided as part of the dataset together with individual licensing information and URLs (where applicable). All errors remain solely my own.

### Copyright and terms of use

> [!IMPORTANT]  
> All data in DOVE is subject to copyright and the terms and conditions indicated on the respective websites of the individual sources where applicable.
> By using DOVE or individual data in DOVE, users impliedly agree to comply with the terms of the specific licence applicable to individual data sources,
> as described on the respective data source pages. This includes attributing the original data source and complying with the relevant copyright terms, as applicable.
> In addition users agree to make reference to the respective released version of DOVE. Data which was indirectly extrapolated or generated within this project is only
> subject to the licence specified here. 

[![CC BY-NC-SA 4.0][cc-by-nc-sa-shield]][cc-by-nc-sa]

This work is licensed under
[Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License][cc-by-nc-sa].

[![CC BY-NC-SA 4.0][cc-by-nc-sa-image]][cc-by-nc-sa]

[cc-by-nc-sa]: http://creativecommons.org/licenses/by-nc-sa/4.0/
[cc-by-nc-sa-image]: https://licensebuttons.net/l/by-nc-sa/4.0/88x31.png
[cc-by-nc-sa-shield]: https://img.shields.io/badge/License-CC%20BY--NC--SA%204.0-lightgrey.svg

### Types of data

  * languages -- a spreadsheet containing socio-demographic information for English varieties and additional descriptive information such as variety name or abbreviation.

 * sources -- a spreadsheet containing the sources, including ULRs for all socio-demographic information and descriptive information.

 * copyright -- a spreadsheet containing the licensing and copyright information, or statements on terms of use for each data source. Scientific references are also listed but no copyright information is provided.

 * documentation -- a pdf document with definitions and descriptions of individual triggers.

#### Citation

Beyond attribution of the original sources, reference to the respective released version of DOVE should be made. Releases are archived with and available from ZENODO at 

### Acknowledgements

As part of project MoVE, DOVE was generously funded by the [Fritz Thyssen Foundation](https://www.fritz-thyssen-stiftung.de/en/), Cologne, Germany, through Support of projects 
(grant no. 20.23.0.009SL).

Many thanks also go to my colleagues, all experts in one or more of the varieties comprised in this dataset for providing missing information on socio-demographic variables, 
helpful feedback and references to other sources (in alphabetical order):

Robert Bailey, Laurie Bauer, Tobias Bernaisch, Ariane Macalinga Borlongan, Alfred Buregeya, David Britain, Sandra Clarke, Dagmar Deuber, Michael Ellis, 
Sabine Erhart, Sandra Evans, Nick Faraclas, Markku Filppula, Hans Fonka, Stephanie Hackert, Raymond Hickey, Magnus Huber, Bernd Kortmann, Jakob Leimgruber, 
Robert Mailhammer, Christian Mair, Miriam Meyerhoff, Michael Meyler, Bettina Migge, Salikoko Mufwene, Peter Mühlhäusler, Daniel Nkemleke, Stefanie Pillai, 
Raymond Oenbring, Heidi Quinn, Anna Rosen, Jeffrey Reaser, Mark Sebba, Jeff Siegel, Kingsley Ugwuanyi
