import dpdata
import numpy as np
import os

np.random.seed(10)
sys_list = ['../ice_pimd', '../ice_triple_I', '../ice_triple_II', '../lw_pimd']
num = [20, 10, 10, 93]
os.makedirs('data', exist_ok=True)

for ii, sys in enumerate(sys_list):
    ss_data = dpdata.LabeledSystem(sys, fmt='deepmd/npy')
    index = np.random.choice(range(len(ss_data)), size=num[ii], replace=False)
    print(index)
    slim_data = ss_data[index]
    slim_data.to_deepmd_npy(os.path.join('data', sys.split('/')[-1]))

