import dpdata
import numpy as np
import os

seed_list = [10]
sys_data = '../C1O2H1Cu48'
num_trn = 2500
num_val = 250

for i, seed in enumerate(seed_list):
    np.random.seed(seed)
    ss_data = dpdata.LabeledSystem(sys_data, fmt='deepmd/npy')
    index = np.array(range(len(ss_data)))
    np.random.shuffle(index)
    print(index)
    data_i = i
    trn_data = ss_data[index[:num_trn]]
    val_data = ss_data[index[num_trn:num_trn+num_val]]
    test_data = ss_data[index[num_trn + num_val:]]
    os.makedirs(f'fold_{data_i}', exist_ok=True)
    os.makedirs(f'fold_{data_i}/data', exist_ok=True)
    trn_data.to_deepmd_npy(os.path.join(f'fold_{data_i}', 'data', 'train'))
    val_data.to_deepmd_npy(os.path.join(f'fold_{data_i}', 'data', 'valid_250'))
    test_data.to_deepmd_npy(os.path.join(f'fold_{data_i}', 'data', 'valid'))

