var documenterSearchIndex = {"docs":
[{"location":"functions/#Helpful-Functions","page":"Helpful Functions","title":"Helpful Functions","text":"","category":"section"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"The following documentation describes helpful utility functions included with this package.","category":"page"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"Once you're familiar with them, get involved!","category":"page"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"Make a discussion post introducing yourself and sharing how you're using Epistemic Network Analysis\nFile an issue anytime you encounter a bug or are unable to make the package do what you need","category":"page"},{"location":"functions/#statistics","page":"Helpful Functions","title":"statistics","text":"","category":"section"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"EpistemicNetworkAnalysis.statistics","category":"page"},{"location":"functions/#Main.EpistemicNetworkAnalysis.statistics","page":"Helpful Functions","title":"Main.EpistemicNetworkAnalysis.statistics","text":"statistics(model::AbstractENAModel)\n\nProduce a dataframe containing descriptive statistics for each dimension of the model embedding\n\nExample\n\nmodel = ENAModel(data, codes, conversations, units)\nstats = statistics(model)\n\n\n\n\n\n","category":"function"},{"location":"functions/#show","page":"Helpful Functions","title":"show","text":"","category":"section"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"EpistemicNetworkAnalysis.show(::EpistemicNetworkAnalysis.AbstractENAModel)","category":"page"},{"location":"functions/#Base.show-Tuple{Main.EpistemicNetworkAnalysis.AbstractENAModel}","page":"Helpful Functions","title":"Base.show","text":"show(model::AbstractENAModel)\n\nDisplay text summarizing a model's configuration and summary statistics.\n\nExample\n\nmodel = ENAModel(data, codes, conversations, units)\nshow(model)\n\n\n\n\n\n","category":"method"},{"location":"functions/#loadExample","page":"Helpful Functions","title":"loadExample","text":"","category":"section"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"EpistemicNetworkAnalysis.loadExample","category":"page"},{"location":"functions/#Main.EpistemicNetworkAnalysis.loadExample","page":"Helpful Functions","title":"Main.EpistemicNetworkAnalysis.loadExample","text":"loadExample(name::AbstractString)\n\nLoad an example dataset as a DataFrame\n\nDatasets\n\nloadExample(\"shakespeare\"): Loads the Shakespeare dataset, containing data on two plays, \"Hamlet\" and \"Romeo and Juliet\"\nloadExample(\"transition\"): Loads the Telling Stories of Transitions dataset, containing metadata and codes only, due to the sensitive nature of the underlying text\nloadExample(\"efm\"): Loads the Doing Evil for Money dataset\nloadExample(\"toy\"): Loads a minimal toy example, reproduced below\n\nGroup,Convo,Unit,Line,A,B,C\nRed,1,X,1,0,0,1\nRed,1,Y,2,1,0,0\nBlue,1,Z,3,0,1,1\nBlue,1,W,4,0,0,0\nRed,1,X,5,0,0,1\nRed,2,X,1,1,0,0\nRed,2,Y,2,1,0,0\nBlue,2,Z,3,0,1,1\nBlue,2,W,4,0,0,0\nRed,2,X,5,1,0,0\n\nLoading Your Own Data\n\nTo load your own datasets, use DataFrame and CSV.File, which requires the DataFrames and CSV packages\n\nusing Pkg\nPkg.add(\"DataFrames\")\nusing DataFrames\n\nPkg.add(\"CSV\")\nusing CSV\n\ndata = DataFrame(CSV.File(\"filename_here.csv\"))\n\n\n\n\n\n","category":"function"},{"location":"functions/#deriveAnyCode!","page":"Helpful Functions","title":"deriveAnyCode!","text":"","category":"section"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"EpistemicNetworkAnalysis.deriveAnyCode!","category":"page"},{"location":"functions/#Main.EpistemicNetworkAnalysis.deriveAnyCode!","page":"Helpful Functions","title":"Main.EpistemicNetworkAnalysis.deriveAnyCode!","text":"deriveAnyCode!(\n    data::DataFrame,\n    newColumnName::Symbol,\n    oldColumnNames...\n)\n\nAdd a new code column to data, derived from existing codes. The new code will be marked present where any of the old codes are present\n\nExample\n\nderiveAnyCode!(data, :Food, :Hamburgers, :Salads, :Cereal)\n\n\n\n\n\n","category":"function"},{"location":"functions/#deriveAllCode!","page":"Helpful Functions","title":"deriveAllCode!","text":"","category":"section"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"EpistemicNetworkAnalysis.deriveAllCode!","category":"page"},{"location":"functions/#Main.EpistemicNetworkAnalysis.deriveAllCode!","page":"Helpful Functions","title":"Main.EpistemicNetworkAnalysis.deriveAllCode!","text":"deriveAllCode!(\n    data::DataFrame,\n    newColumnName::Symbol,\n    oldColumnNames...\n)\n\nAdd a new code column to data, derived from existing codes. The new code will be marked present only where all of the old codes are present on the same line\n\nExample\n\nderiveAllCode!(data, :ObservingStudentsLearning, :Observing, :Students, :Learning)\n\n\n\n\n\n","category":"function"},{"location":"functions/#to_xlsx","page":"Helpful Functions","title":"to_xlsx","text":"","category":"section"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"EpistemicNetworkAnalysis.to_xlsx","category":"page"},{"location":"functions/#Main.EpistemicNetworkAnalysis.to_xlsx","page":"Helpful Functions","title":"Main.EpistemicNetworkAnalysis.to_xlsx","text":"to_xlsx(filename::AbstractString, model::AbstractENAModel)\n\nSave a model to the disk as an Excel spreadsheet, useful for sharing results with others\n\nSee also serialize for saving models in a more efficient format that can be reloaded into Julia using deserialize\n\nNote: a from_xlsx function does not exist, but is planned. The difficulty is that Excel data is at root a human-readable string format, and some components of some models are difficult to represent reliably as human-readable strings\n\n\n\n\n\n","category":"function"},{"location":"functions/#pointcloud","page":"Helpful Functions","title":"pointcloud","text":"","category":"section"},{"location":"functions/","page":"Helpful Functions","title":"Helpful Functions","text":"EpistemicNetworkAnalysis.pointcloud","category":"page"},{"location":"functions/#Main.EpistemicNetworkAnalysis.pointcloud","page":"Helpful Functions","title":"Main.EpistemicNetworkAnalysis.pointcloud","text":"pointcloud(\n    model::AbstractENAModel;\n    ndims::Int=nrow(model.points),\n    mode::Symbol=:wide,\n    z_norm::Bool=false,\n    metadata::Vector{Symbol}=Symbol[]\n)\n\nProduce a point cloud matrix from a model's plotted points and optional additional metadata columns, for preparing data to pass to other packages, e.g., for machine learning.\n\nArguments\n\nRequired:\n\nmodel: The ENA model to produce a point cloud from\n\nOptional:\n\nndims: The number of dimensions from the ENA model's embedding to include in the point cloud. The first ndim dimensions will be included. By default, all dimensions will be included\nmode: The orientation of the point cloud, either in :wide format (default) or :tall format. In wide format, the point cloud's X matrix's rows will correspond to features. In tall format, they will correspond to units.\nz_norm: Whether to normalize the point cloud's features (default: false)\nmetadata: A list of additional names of metadata columns from the model to include in the point cloud. Note, when including additional metadata, it is advised to also set z_norm to true\n\nFields\n\nOnce the point cloud is constructed, it will have the following fields:\n\nX: A matrix containing the point cloud data, in either wide or tall format\nfeature_names: A vector of the names of the features included in the point cloud. When mode is :wide, feature_names corresponds to the rows of X. When mode is :tall, it corresponds to the columns of X instead.\nunit_names: A vector of the IDs of the units included in the point cloud. When mode is :wide, unit_names corresponds to the columns of X. When mode is :tall, it corresponds to the rows of X instead.\nz_normed: A boolean representing whether the point cloud was normalized\nz_means and z_stds: When z_normed is true, these are vectors of the original means and standard deviations of the features of the point cloud\n\nExample\n\n# Wide format DataFrame\npc = pointcloud(model)\ndf = DataFrame(pc.X, pc.unit_names)\n\n# Tall format DataFrame\npc = pointcloud(model, mode=:tall)\ndf = DataFrame(pc.X, pc.feature_names)\n\n# ndims, metadata, and z_norm\npc = pointcloud(model, ndims=4, mode=:tall, metadata=[:Act], z_norm=true)\ndf = DataFrame(pc.X, pc.feature_names)\n\n\n\n\n\n","category":"function"},{"location":"rotations/#Rotations","page":"Rotations","title":"Rotations","text":"","category":"section"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"The following documentation describes available dimension reduction, or \"rotations,\" available in this package.","category":"page"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"Which rotation you choose should be informed by your sense of your research story:","category":"page"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"Want to get a high level view of your data? SVDRotation will capture the most variance and is good for getting an initial sense of your data's major features\nWant to compare groups? Use MeanRotation when you have exactly two groups. Otherwise, consider LDARotation or MulticlassRotation. The distinction between these is spelled out in \"Multiclass Rotations in Epistemic Network Analysis\"\nWant to see how your qualitative data relates to continuous or hierarchical variables? Use FormulaRotation, a rotation based on a regression framework described in \"Hierarchical Epistemic Network Analysis\"\nWant to model a theoretical topic directly? Use TopicRotation to force certain connections to the left and others to the right. This is useful when you have suspicions that certain codes account for group differences and want to test those suspicions directly instead of inferring them by other means.\nWant to test the generlizability or cross-validation of your model? Use TrainedRotation to create a new model that uses the same embedding and runs the same tests as an existing model.","category":"page"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"Once you're familiar with them, continue to learn more about plotting.","category":"page"},{"location":"rotations/#SVDRotation","page":"Rotations","title":"SVDRotation","text":"","category":"section"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"EpistemicNetworkAnalysis.SVDRotation","category":"page"},{"location":"rotations/#Main.EpistemicNetworkAnalysis.SVDRotation","page":"Rotations","title":"Main.EpistemicNetworkAnalysis.SVDRotation","text":"SVDRotation()\n\nThe default rotation for linear ENA models. Reduces dimensions usings singular value decomposition\n\n\n\n\n\n","category":"type"},{"location":"rotations/#MeansRotation","page":"Rotations","title":"MeansRotation","text":"","category":"section"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"EpistemicNetworkAnalysis.MeansRotation","category":"page"},{"location":"rotations/#Main.EpistemicNetworkAnalysis.MeansRotation","page":"Rotations","title":"Main.EpistemicNetworkAnalysis.MeansRotation","text":"MeansRotation(\n    # Required, groups to compare along the x-axis\n    groupVar1::Symbol,\n    controlGroup1::Any,\n    treatmentGroup1::Any,\n\n    # Optional, groups to compare along subsequent axes\n    args...;\n\n    # Optional, whether to moderate the interactions between group dimensions\n    moderated=false\n)\n\nDefine a rotation for comparing pairs of groups, by maximizing the variance between pairs\n\nSee also: LDARotation and MulticlassRotation\n\nExample\n\nrotation = MeansRotation(\n    :Play, \"Romeo and Juliet\", \"Hamlet\",\n    :Act, 1, 5\n)\n\nStatistical Tests\n\nModels using a MeansRotation will run the following statistical tests:\n\nKruskalWallisTest for each dimension with a group pair\n\n\n\n\n\n","category":"type"},{"location":"rotations/#LDARotation","page":"Rotations","title":"LDARotation","text":"","category":"section"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"EpistemicNetworkAnalysis.LDARotation","category":"page"},{"location":"rotations/#Main.EpistemicNetworkAnalysis.LDARotation","page":"Rotations","title":"Main.EpistemicNetworkAnalysis.LDARotation","text":"LDARotation(\n    groupVar::Symbol\n)\n\nDefine a rotation for comparing multiple groups, via linear discriminant analysis\n\nSee also: MeansRotation and MulticlassRotation\n\nExample\n\nrotation = LDARotation(:Act)\n\nStatistical Tests\n\nModels using an LDARotation will run the following statistical tests:\n\nKruskalWallisTest for each dimension\n\n\n\n\n\n","category":"type"},{"location":"rotations/#MulticlassRotation","page":"Rotations","title":"MulticlassRotation","text":"","category":"section"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"EpistemicNetworkAnalysis.MulticlassRotation","category":"page"},{"location":"rotations/#Main.EpistemicNetworkAnalysis.MulticlassRotation","page":"Rotations","title":"Main.EpistemicNetworkAnalysis.MulticlassRotation","text":"MulticlassRotation(\n    groupVar::Symbol\n)\n\nDefine a rotation for comparing multiple groups, by maximizing between-group variance\n\nSee also: MeansRotation and LDARotation\n\nExample\n\nrotation = MulticlassRotation(:Act)\n\nStatistical Tests\n\nModels using an MulticlassRotation will run the following statistical tests:\n\nKruskalWallisTest for each dimension\n\n\n\n\n\n","category":"type"},{"location":"rotations/#FormulaRotation","page":"Rotations","title":"FormulaRotation","text":"","category":"section"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"EpistemicNetworkAnalysis.FormulaRotation","category":"page"},{"location":"rotations/#Main.EpistemicNetworkAnalysis.FormulaRotation","page":"Rotations","title":"Main.EpistemicNetworkAnalysis.FormulaRotation","text":"FormulaRotation(\n    regression_model1::Type{T},\n    formula1::FormulaTerm,\n    coef_index1::Int,\n    contrast1::Union{Nothing,Dict},\n    args...\n) where {T <: RegressionModel}\n\nDefine a rotation that uses regression models to determine axes most closely associated with some linear trend\n\nNote: RegressionModels must be imported from other stats packages\n\nNote: contrasts are used to model categorical data\n\nExample\n\nusing GLM\n\nrotation = EpistemicNetworkAnalysis.FormulaRotation(\n    LinearModel, @formula(edge ~ 1 + FinalGrade), 2, nothing\n)\n\nThis will fit the x-axis to the FinalGrade metadata, because:\n\nWe use LinearModel from the GLM package\nWe use the formula edge ~ 1 + FinalGrade\nAnd we use the 2nd coefficient of the LinearModel (in this case FinalGrade) to determine the values of the embedding\nWe have no categorical data in the LinearModel, so we leave the contrasts as nothing\n\nAdditional formulae may be used to define subsequent axes:\n\nrotation = EpistemicNetworkAnalysis.FormulaRotation(\n    LinearModel, @formula(edge ~ 1 + PretestGrade + PosttestGrade), 2, nothing,\n    LinearModel, @formula(edge ~ 1 + PretestGrade + PosttestGrade), 3, nothing\n)\n\nNote: When multiple formulae are given, FormulaRotation finds the plane of the effects in the accum space, rotating it such that the first formula aligns with the x-axis, and the second formula aligns approximately with the y-axis. Unless this approximation is strong, a warning will be raised describing possible issues.\n\nStatistical Tests\n\nModels using a MeansRotation will run the following statistical tests:\n\nR^2 and adjusted-R^2 for each dimension with a formula\n\n\n\n\n\n","category":"type"},{"location":"rotations/#TopicRotation","page":"Rotations","title":"TopicRotation","text":"","category":"section"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"EpistemicNetworkAnalysis.TopicRotation","category":"page"},{"location":"rotations/#Main.EpistemicNetworkAnalysis.TopicRotation","page":"Rotations","title":"Main.EpistemicNetworkAnalysis.TopicRotation","text":"TopicRotation(\n    topicName::AbstractString,\n    controlNodes::Array{Symbol},\n    treatmentNodes::Array{Symbol}\n)\n\nDefine a rotation that places its x-axis through the mean of controlNodes on the left and the mean of treatmentNodes on the right, ie., through an a priori defined topic\n\nExample\n\nrotation = TopicRotation(\n    \"Gendered Language\",\n    [:Women, :Love],\n    [:Men, :Honor]\n)\n\n\n\n\n\n","category":"type"},{"location":"rotations/#TrainedRotation","page":"Rotations","title":"TrainedRotation","text":"","category":"section"},{"location":"rotations/","page":"Rotations","title":"Rotations","text":"EpistemicNetworkAnalysis.TrainedRotation","category":"page"},{"location":"rotations/#Main.EpistemicNetworkAnalysis.TrainedRotation","page":"Rotations","title":"Main.EpistemicNetworkAnalysis.TrainedRotation","text":"TrainedRotation(\n    trainmodel::AbstractLinearENAModel\n)\n\nDefine a rotation that copies the embedding of an existing \"training\" model for use in a second \"testing\" model\n\nExample\n\n# Randomly assign units to train or test sets\ndata[!, :rand] = rand(1:100, nrow(data))\ntrainFilter(unit) = unit.rand < 80\ntestFilter(unit) = !trainFilter(unit)\n\n# Run model on the training set\ntrainmodel = ENAModel(\n    data, codes, conversations, units,\n    unitFilter=trainFilter,\n    rotation=LDARotation(:Act)\n)\n\n# Run new model on the test set, but using the embedding of the trained model\ntestmodel = ENAModel(\n    data, codes, conversations, units,\n    unitFilter=testFilter,\n    rotation=TrainedRotation(trainmodel)\n)\n\nStatistical Tests\n\nModels using a TrainedRotation will run the same statistical tests as the trainmodel.\n\n\n\n\n\n","category":"type"},{"location":"models/#Models","page":"Models","title":"Models","text":"","category":"section"},{"location":"models/","page":"Models","title":"Models","text":"The following documentation describes the available model options in EpistemicNetworkAnalysis.jl.","category":"page"},{"location":"models/","page":"Models","title":"Models","text":"Once you're familiar with them, continue to learn more about available rotations.","category":"page"},{"location":"models/#ENAModel","page":"Models","title":"ENAModel","text":"","category":"section"},{"location":"models/","page":"Models","title":"Models","text":"EpistemicNetworkAnalysis.ENAModel","category":"page"},{"location":"models/#Main.EpistemicNetworkAnalysis.ENAModel","page":"Models","title":"Main.EpistemicNetworkAnalysis.ENAModel","text":"ENAModel(\n    # Required\n    data::DataFrame,\n    codes::Array{Symbol,1},\n    conversations::Array{Symbol,1},\n    units::Array{Symbol,1};\n\n    # Optional\n    rotation::AbstractLinearENARotation=SVDRotation(),\n    unitFilter::Function=unit->true,\n    edgeFilter::Function=edge->edge.kind == :undirected,\n    windowSize::Real=Inf,\n    sphereNormalize::Bool=true,\n    lineNormalize::Bool=false,\n    dropEmpty::Bool=false,\n    recenterEmpty::Bool=false\n)\n\nConstruct an undirected ENA model. Nodes are positioned to maximize goodness of fit between plotted points and units' weighted average of edge midpoints.\n\nArguments\n\nThe minimum required arguments are:\n\ndata: DataFrame containing your qualitative data. Each row should represent one \"line\" or the smallest codable unit. Columns should include metadata information, the \"text\" or the qualitative unit itself, and binary-coded qualitative codes.\ncodes: Array listing names of columns to use as the qualitative codes in the model\nconversation: As above, but for columns to use to distinguish \"conversations,\" segments the model should not count connections between\nunits: As above, but for columns to use to distinguish \"speakers\" or your units of analysis\n\nThe common optional arguments are:\n\nrotateBy: \"Rotation\" or dimension reduction the model should use for determining axes for downstream plotting and analysis\nwindowSize: Size of the sliding window for counting connections, where a window size of 1 counts only connections occuring on the same line\ndropEmpty: Whether the model should drop units of analysis that accumulated no connections\n\nFinally, the less common but occassionally useful optional arguments are:\n\nunitFilter: Function for deciding which units of analysis to include in the model, such as based on its metadata\nedgeFilter: As above, but for which edges to include in the model, such as based on which codes it connects. Ensure that only :undirected edges are included\nsphereNormalize and lineNormalize: Whether the model should normalize units of analysis so that, for example, speakers who talk more are still considered similar to those who talk less but about the same subjects\nrecenterEmpty: Whether the model should move empty units of analysis to the mean of all units, instead of leaving them at the zero origin\n\nFields\n\nOnce the model is constructed, it will have the following fields:\n\ndata, codes, conversations, units, and rotation: Copies of the argument values given above\nmetadata: DataFrame of original non-code columns, each row corresponding to one unit of analysis. A unitID column is added to represent each unit's unique identifier\npoints: DataFrame, where rows correspond to plotted point dimensions and columns correspond to units of analysis\npointsHat: As above, but for approximate dimensions used for measuring model goodness of fit\npointsNodes: As above, but for the optimized node positions along each plotted dimension\naccum: DataFrame, where rows correspond to units of analysis and columns correspond to edges, counting the (normalized) number of connections that unit accumulated for that edge\naccumHat: As above, but for the approximated counts, used for measuring model goodness of fit\nedges: DataFrame, where rows correspond to edges, with the following columns: edgeID, kind, ground, and response\nnodes: DataFrame, where rows correspond to nodes and columns correspond to approximated counts for each edge, used for computing pointsNodes\nembedding: DataFrame, where rows correspond to plotted point dimensions and columns correspond edges. Used for computing points, pointsHat, and pointsNodes. Additional columns may be added depending on the model's rotation, corresponding to statistical tests for each dimension\nconfig: NamedTuple, storing additional configuration options, such as unitFilter, sphereNormalize, and so on\n\nExample\n\nusing EpistemicNetworkAnalysis\n\n# Load example dataset\ndata = loadExample(\"shakespeare\")\n\n# Base settings\ncodes = [:Love, :Death, :Honor, :Men, :Women]\nconversations = [:Play, :Act, :Scene]\nunits = [:Play, :Speaker]\n\n# Rotation settings\nrotation = TopicRotation(\n    \"Women-Death vs. Honor\",\n    [:Women, :Death],\n    [:Honor]\n)\n\n# Construct model\nmodel = ENAModel(\n    data, codes, conversations, units,\n    windowSize=4,\n    rotateBy=rotation,\n    dropEmpty=false\n)\n\n# Display model overview\nshow(model)\n\n# Display summary statistics\nshow(statistics(model))\n\n# Display and save plot\np = plot(model)\ndisplay(p)\nsavefig(p, \"example.svg\")\n\n# Save model for later use in Julia\nserialize(\"example.ena\", model)\n\n# Save model for easy sharing with collaborators\nto_xlsx(\"example.xlsx\", model)\n\n\n\n\n\n","category":"type"},{"location":"models/#DigraphENAModel","page":"Models","title":"DigraphENAModel","text":"","category":"section"},{"location":"models/","page":"Models","title":"Models","text":"EpistemicNetworkAnalysis.DigraphENAModel","category":"page"},{"location":"models/#Main.EpistemicNetworkAnalysis.DigraphENAModel","page":"Models","title":"Main.EpistemicNetworkAnalysis.DigraphENAModel","text":"DigraphENAModel(\n    # Required\n    data::DataFrame,\n    codes::Array{Symbol,1},\n    conversations::Array{Symbol,1},\n    units::Array{Symbol,1};\n\n    # Optional\n    rotation::AbstractLinearENARotation=SVDRotation(),\n    unitFilter::Function=unit->true,\n    edgeFilter::Function=edge->edge.kind == :directed,\n    windowSize::Real=Inf,\n    sphereNormalize::Bool=true,\n    lineNormalize::Bool=false,\n    dropEmpty::Bool=false,\n    recenterEmpty::Bool=false\n)\n\nConstruct a directed ENA model. Nodes are positioned to maximize goodness of fit between plotted points and units' weighted average of edge vectors.\n\nDigraphENAModel follows the same argument and field structure as ENAModel.\n\nEnsure that edgeFilter only includes :directed edges.\n\n\n\n\n\n","category":"type"},{"location":"models/#BiplotENAModel","page":"Models","title":"BiplotENAModel","text":"","category":"section"},{"location":"models/","page":"Models","title":"Models","text":"EpistemicNetworkAnalysis.BiplotENAModel","category":"page"},{"location":"models/#Main.EpistemicNetworkAnalysis.BiplotENAModel","page":"Models","title":"Main.EpistemicNetworkAnalysis.BiplotENAModel","text":"BiplotENAModel(\n    # Required\n    data::DataFrame,\n    codes::Array{Symbol,1},\n    conversations::Array{Symbol,1},\n    units::Array{Symbol,1};\n\n    # Optional\n    rotation::AbstractLinearENARotation=SVDRotation(),\n    unitFilter::Function=unit->true,\n    edgeFilter::Function=edge->edge.kind == :count, # fixed, cannot change\n    windowSize::Real=1, # fixed, cannot change\n    sphereNormalize::Bool=true,\n    lineNormalize::Bool=false,\n    dropEmpty::Bool=false,\n    recenterEmpty::Bool=false\n)\n\nConstruct a biplot model of unit-wise counts of code occurences, without measuring connections between codes. Model will have perfect goodness of fit between points and pointsHat, will be much simpler than other model types, but will lose most information compared to other model types.\n\nBiplotENAModel follows the same argument and field structure as ENAModel, except edgeFilter and windowSize are in effect ignored.\n\n\n\n\n\n","category":"type"},{"location":"models/#CodewiseENAModel","page":"Models","title":"CodewiseENAModel","text":"","category":"section"},{"location":"models/","page":"Models","title":"Models","text":"EpistemicNetworkAnalysis.CodewiseENAModel","category":"page"},{"location":"models/#Main.EpistemicNetworkAnalysis.CodewiseENAModel","page":"Models","title":"Main.EpistemicNetworkAnalysis.CodewiseENAModel","text":"CodewiseENAModel(\n    # Required\n    data::DataFrame,\n    codes::Array{Symbol,1},\n    conversations::Array{Symbol,1},\n    units::Array{Symbol,1};\n\n    # Optional\n    rotation::AbstractLinearENARotation=SVDRotation(),\n    unitFilter::Function=unit->row[:CodewiseCode] != \"__prefix__\", # fixed, cannot change\n    edgeFilter::Function=edge->edge.kind == :count, # fixed, cannot change\n    windowSize::Real=1,\n    sphereNormalize::Bool=true,\n    lineNormalize::Bool=false,\n    dropEmpty::Bool=false,\n    recenterEmpty::Bool=false\n)\n\nConstruct a biplot model of code-wise counts of code co-occurences. Model will have perfect goodness of fit between points and pointsHat, will be much simpler than other model types, but unlike BiplotENAModel will not lose most information.\n\nCodewiseENAModel follows the same argument and field structure as ENAModel, except unitFilter and edgeFilter are in effect ignored. Note also that the default windowSize is 1 instead of Inf, to prevent accidentally overloading RAM.\n\nTwo columns, :CodewiseChorus and :CodewiseCode will be added to data, and at least one of these should be included in the units parameter.\n\n\n\n\n\n","category":"type"},{"location":"plots/#Plots","page":"Plots","title":"Plots","text":"","category":"section"},{"location":"plots/","page":"Plots","title":"Plots","text":"The following documentation describes arguments and helpful tips for plotting ENA models.","category":"page"},{"location":"plots/","page":"Plots","title":"Plots","text":"Once you're familiar with them, continue to learn more about additional helpful functions.","category":"page"},{"location":"plots/","page":"Plots","title":"Plots","text":"EpistemicNetworkAnalysis.plot(model::EpistemicNetworkAnalysis.AbstractLinearENAModel)","category":"page"},{"location":"plots/#RecipesBase.plot-Tuple{Main.EpistemicNetworkAnalysis.AbstractLinearENAModel}","page":"Plots","title":"RecipesBase.plot","text":"plot(\n    model::AbstractLinearENAModel,\n    x::Int=1,\n    y::Int=2,\n    margin::PlotMeasures.AbsoluteLength=10mm,\n    size::Real=600,\n    meanCenter::Bool=model.config.sphereNormalize,\n    origin::Array{<:Real}=(meanCenter ?  [mean(model.points[x, :]), mean(model.points[y, :])] : [0,0]),\n    zoom::Real=1,\n    lims::Real=1/zoom,\n    flipX::Bool=false,\n    flipY::Bool=false,\n    xticks::Array{<:Real}=(\n        round.([origin[1]-lims, origin[1], origin[1]+lims], digits=4) |>\n        (xticks) -> (flipX ? -reverse(xticks) : xticks)\n    ),\n    yticks::Array{<:Real}=(\n        round.([origin[2]-lims, origin[2], origin[2]+lims], digits=4) |>\n        (yticks) -> (flipY ? -reverse(yticks) : yticks)\n    ),\n    xlims::Array{<:Real}=xticks[[1, end]],\n    ylims::Array{<:Real}=yticks[[1, end]],\n    titles::Array{<:AbstractString}=String[],\n    xlabel::AbstractString=model.embedding[x, :label],\n    ylabel::AbstractString=model.embedding[y, :label],\n    unitLabel::AbstractString=\"Unit\",\n    leg::Union{Symbol,Bool}=:topleft,\n    negColor::Colorant=DEFAULT_NEG_COLOR,\n    posColor::Colorant=DEFAULT_POS_COLOR,\n    groupColors::Array{<:Colorant,1}=DEFAULT_GROUP_COLORS,\n    alphabet::String=DEFAULT_ALPHABET,\n    groupBy::Union{Symbol,Nothing}=nothing,\n    innerGroupBy::Union{Symbol,Nothing}=nothing,\n    spectralColorBy::Union{Symbol,Nothing}=nothing,\n    trajectoryBy::Union{Symbol,Nothing}=nothing,\n    trajectoryBins::Int=5,\n    spectoryBy::Union{Symbol,Nothing}=nothing,\n    spectoryBinPercent::Real=1/3,\n    spectoryBinStep::Real=1/2 * spectoryBinPercent,\n    showExtras::Bool=true,\n    showNetworks::Bool=true,\n    showUnits::Bool=true,\n    showMeans::Bool=true,\n    showWarps::Bool=false,\n    confidenceShape::Symbol=:rect,\n    fitNodesToCircle::Bool=false,\n    showWeakEdges::Bool=true,\n    colorbar::Bool=false\n)\n\nPlot an ENA model using the GR backend\n\nSee also savefig\n\nArguments\n\nAt minimum, the only required argument is the ENA model itself.\n\nSeveral optional arguments are available:\n\nx and y control which dimension to show on the x- and y-axis respectively\nmargin, size, meanCenter, origin, zoom, lims, flipX, flipY, xticks, yticks, xlims, and ylims together control aspects of the plot size and axes\ntitles, xlabel, ylabel, unitLabel, leg, and alphabet together control the text that labels the plot\nnegColor, posColor, and groupColors together control the colors used in the plot\ngroupBy and innerGroupBy define which metadata columns to use as grouping variables for the sake of color coding and confidence intervals\nspectralColorBy defines which metadata column to use to color-code units as a spectrum, to show how networks relate to the variable of interest\ntrajectoryBy and trajectoryBins together define and control how a trajectory path should be overlaid on the plot, to show how the mean network changes along the variable of interest. Similarly, spectoryBy, spectoryBinPercent, and spectoryBinStep define how a sequence of 1-level densities should be overlaid on the plot, to show how the distribution of networks changes along the variable of interest\nshowExtras, showNetworks, showUnits, and showMeans control which plot elements to show or hide. Additionally, confidenceShape can be set to :rect (default) or :density to choose which shape to use around the means\nshowWarps controls if edges should be drawn straight (false) or \"warped\" to show their true location in the space (true)\nfitNodesToCircle controls if nodes should be shown in their optimized positions for goodness of fit, or at a circular position around the origin\nshowWeakEdges controls if edges with weak correlations to trends should be shown\ncolorbar controls if subplots that use gradient color-coding for their edges should have an explicit colorbar added\n\nExample\n\nmodel = ENAModel(data, codes, conversations, units)\np = plot(model)\n\n# Move the legends to an outer position\np = plot(model, leg=:outertopright)\n\n# Grab one subplot\nsp = plot(p.subplots[1], size=(700,700))\n\n# Save\nsavefig(p, \"example.png\")\n\nInterpretation\n\nplot(model) produces a plot with the following subplots:\n\n(a) an overall mean, which tells us the baseline everything compares against\n(b) and (c) rates of change for each connection across the x- and y-axes, which helps identify what is being modeled by each axis\nSubsequent subplots show each subgroup on its own. It's good to compare these to the overall mean\nAnd the last subplots show how each pair of subgroups compare. Similar to the trend plots, these show you what is being modeled by the difference of the two groups\n\nSome differences from WebENA and rENA:\n\nSaturation shows correlation strength. In WebENA and rENA saturation and line thickness both show magnitude of an effect\nPlots are mean centered by moving the origin of the plot, not by changing the underlying data. This preserves information that may or may not be useful for downstream analyses\nPlots are opinionated. Based on the model config, the plot's default settings to change to what I believed was the best way to plot that kind of model. This gives you the \"right\" plot without having to specify what \"right\" means each time\nA known issue is that the y-axis label can get cutoff when there are a lot of subplots\n\n\n\n\n\n","category":"method"},{"location":"examples/cross-validation/#Cross-Validation","page":"Cross Validation","title":"Cross Validation","text":"","category":"section"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"Using a TrainedRotation, we can perform k-fold cross-validation on an ENA model","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"First, we'll load a few libraries:","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"using EpistemicNetworkAnalysis\nusing DataFrames\nusing Statistics\nusing GLM\nnothing # hide","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"Second, we'll load our data and prepare our model config. We'll be using the FormulaRotation example from the ICQE23 workshop:","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"data = loadExample(\"transitions\")\n\nderiveAnyCode!(data, :BODY, :Changes, :Mood, :Oily, :Dysphoria, :Cry)\nderiveAnyCode!(data, :REFLECT, :Identity, :Longing, :Dream, :Childhood, :Family, :Name, :Letter, :Doubt, :Religion)\nderiveAnyCode!(data, :LEARN, :WWW, :Experiment, :Recipe)\nderiveAnyCode!(data, :PROGRESS, :Strangers, :Passed, :Out, :Affirmation)\n\ndata[!, :All] .= \"All\"\ncodes = [:DoseTracking, :SkippedDose, :Happy, :NonHappy, :Sweets, :BODY, :REFLECT, :LEARN, :PROGRESS]\nconversations = [:All]\nunits = [:Date]\nrotation = FormulaRotation(\n    LinearModel, @formula(y ~ 1 + Day), 2, nothing\n)\nnothing # hide","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"Now we can start setting up our cross-validation. We'll give each row a random number from 1 to 5, setting us up for a 5-fold cross-validation.","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"k_folds = 5\ndata[!, :Fold] .= rand(1:k_folds, nrow(data))\nnothing # hide","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"Then, we'll iterate. We'll create a trainmodel with a unitFilter, using the logic row.Fold != i to select all units except our hold out set. After that, we'll create a testmodel with the opposite unitFilter and rotate it using TrainedRotation(trainmodel). That will project our hold out units into our trained embedding. The last thing we'll do in this loop is grab a statistic to add to a results list:","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"results = Real[]\nfor i in 1:k_folds\n    trainmodel = ENAModel(\n        data, codes, conversations, units,\n        windowSize=4,\n        recenterEmpty=true,\n        rotateBy=rotation,\n        unitFilter=(row)->(row.Fold != i)\n    )\n\n    testmodel = ENAModel(\n        data, codes, conversations, units,\n        windowSize=4,\n        recenterEmpty=true,\n        rotateBy=TrainedRotation(trainmodel),\n        unitFilter=(row)->(row.Fold == i)\n    )\n\n    result = testmodel.embedding[1, :Formula_AdjR2]\n    push!(results, result)\nend\nnothing # hide","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"Finally, we'll display the results and their mean:","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"println(results)\nprintln(mean(results))","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"Putting it all together, here is a helper function you should be able to drop-in and apply to your own data:","category":"page"},{"location":"examples/cross-validation/","page":"Cross Validation","title":"Cross Validation","text":"# Helper\nfunction kfoldcv(wholemodel, k_folds, statistic)\n    results = Real[]\n    wholemodel.data[!, :Fold] .= rand(1:k_folds, nrow(data))\n    for i in 1:k_folds\n        trainmodel = ENAModel(\n            wholemodel,\n            unitFilter=(row)->(row.Fold != i)\n        )\n\n        testmodel = ENAModel(\n            wholemodel,\n            rotateBy=TrainedRotation(trainmodel),\n            unitFilter=(row)->(row.Fold == i)\n        )\n\n        result = testmodel.embedding[1, statistic]\n        push!(results, result)\n    end\n    \n    return results\nend\n\n# Example usage\nwholemodel = ENAModel(\n    data, codes, conversations, units,\n    windowSize=4,\n    recenterEmpty=true,\n    rotateBy=rotation\n)\n\nresults = kfoldcv(wholemodel, 5, :Formula_AdjR2)\nprintln(results)\nprintln(mean(results))","category":"page"},{"location":"#EpistemicNetworkAnalysis.jl","page":"Home","title":"EpistemicNetworkAnalysis.jl","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"(Image: \"Buy Me A Coffee\")","category":"page"},{"location":"","page":"Home","title":"Home","text":"(Image: ColPrac: Contributor's Guide on Collaborative Practices for Community Packages)","category":"page"},{"location":"","page":"Home","title":"Home","text":"(Image: DOI)","category":"page"},{"location":"","page":"Home","title":"Home","text":"Author: Mariah A. Knowles (@snotskie)","category":"page"},{"location":"","page":"Home","title":"Home","text":"A port of rENA version 0.2.0.1 into native Julia, with substantial API changes to fit Julia style, and with addition of new rotation methods.","category":"page"},{"location":"","page":"Home","title":"Home","text":"Original R package by http://www.epistemicnetwork.org/.","category":"page"},{"location":"","page":"Home","title":"Home","text":"This package is in BETA – It is stable enough for exploratory work and ready for user feedback","category":"page"},{"location":"#Recommended-Citation","page":"Home","title":"Recommended Citation","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"If you use this Julia implementation of ENA in your research, please cite it, the Julia language, and the R version it is based on, as shown below; describe it as \"...a port of ENA from the original R to Julia (Bezanson et al, 2017; Knowles, 2023; Marquart et al 2019)\"; and justify your choice of Julia over R. For example, your research team may be more familiar with Julia, you may need interoperability with other existing Julia libraries, or you may need access to dimension reductions (\"rotations\") not defined in rENA.","category":"page"},{"location":"","page":"Home","title":"Home","text":"Bezanson, J., Edelman, A., Karpinski S., & Shah V. B. (2017). Julia: A Fresh Approach to Numerical Computing. SIAM Review, 59: 65-98.Knowles, M. A. (2023). EpistemicNetworkAnalysis.jl (Version 0.7.0) [Software] Available from https://github.com/snotskie/EpistemicNetworkAnalysis.jlMarquart, C. L., Swiecki, Z., Collier, W., Eagan, B., Woodward, R., & Shaffer, D. W. (2019). rENA: Epistemic Network Analysis (Version 0.2.0.1) [Software] Available from https://cran.r-project.org/web/packages/rENA/index.html","category":"page"},{"location":"","page":"Home","title":"Home","text":"You may copy the recommended citation in the format of your choice from https://zenodo.org/doi/10.5281/zenodo.8401214","category":"page"},{"location":"#Getting-Started","page":"Home","title":"Getting Started","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"I recommend installing Julia for Visual Code first. If you are in a country where downloading resources from GitHub is difficult, you may install Julia using the Python jill package and following the advice linked in the Julia forums for users in China","category":"page"},{"location":"","page":"Home","title":"Home","text":"Then to install this package, run the following in Julia:","category":"page"},{"location":"","page":"Home","title":"Home","text":"using Pkg\nPkg.add(url=\"https://github.com/snotskie/EpistemicNetworkAnalysis.jl\")\nusing EpistemicNetworkAnalysis","category":"page"},{"location":"","page":"Home","title":"Home","text":"Once you've done that, test that everything works by running the following:","category":"page"},{"location":"","page":"Home","title":"Home","text":"using EpistemicNetworkAnalysis\n\ndata = loadExample(\"shakespeare\")\ncodes = [:Love, :Death, :Honor, :Men, :Women]\nconversations = [:Play, :Act, :Scene]\nunits = [:Play, :Speaker]\nrotation = MeansRotation(:Play, \"Romeo and Juliet\", \"Hamlet\")\n\nmodel = ENAModel(\n    data, codes, conversations, units,\n    windowSize=4,\n    rotateBy=rotation\n)\n\nshow(model)\ndisplay(plot(model))","category":"page"},{"location":"","page":"Home","title":"Home","text":"If you run into any issues, don't hesitate to file an issue or ask for help.","category":"page"},{"location":"","page":"Home","title":"Home","text":"Then once you're ready, continue to learn more about available models.","category":"page"},{"location":"icqe23/#ICQE23-ENA-Rotations-Workshop","page":"ICQE23 Workshop","title":"ICQE23 ENA Rotations Workshop","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"<style type=\"text/css\">\n.admonition.is-category-discussion {\n    background-color: #f2e9ff;\n    border-color: #9b59b6;\n}\n.admonition.is-category-discussion>.admonition-header {\n    background: #9b59b6;\n}\n\n.admonition.is-category-activity {\n    background-color: #d9eafc;\n    border-color: #45aaf2;\n}\n.admonition.is-category-activity>.admonition-header {\n    background: #45aaf2;\n}\n\n.admonition.is-category-challenge {\n    background-color: #ffccc7;\n    border-color: #e74c3c;\n}\n.admonition.is-category-challenge>.admonition-header {\n    background: #e74c3c;\n}\n\n.admonition.is-category-checkin {\n    background-color: #e9f7ef;\n    border-color: #27ae60;\n}\n.admonition.is-category-checkin>.admonition-header {\n    background: #27ae60;\n}\n</style>","category":"page"},{"location":"icqe23/#What-to-Bring","page":"ICQE23 Workshop","title":"What to Bring","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"For this workshop you'll need:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"💻 Your laptop, setup as described below so we can hit the ground running\n🔌 Laptop charger\n🎉 A can-do attitude and an unshakeable curiousity\n🗂️ Any data you would like to work on, help thinking about, etc.","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Prerequisites:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"All learners welcome!\nYou should already be familiar with ENA. If you aren't, the morning \"Introduction to Epistemic Network Analysis\" workshop before ours is a great place to start!\nYou should have at least a beginner's understanding of one programming language. If you don't, Kaggle's Intro to Programming is a great place to start!\nYou do not need experience with Julia or VS Code. We will introduce them as necessary during the workshop","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"You will learn:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"All about rotations in ENA\nHow to make lots of models\nHow to choose the right model\nHow to get help and contribute long after the conference ends","category":"page"},{"location":"icqe23/#Before-the-Conference:-Setup-and-Survey","page":"ICQE23 Workshop","title":"Before the Conference: Setup and Survey","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Before the conference begins:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Install Julia\nInstall VS Code\nInstall Julia VS Code extension\nClose and restart VS Code\nInstall EpistemicNetworkAnalysis.jl by:\nCreate a new file in VS Code (ctrl+n, or cmd+n on Mac)\nSave it with the name setup.jl (ctrl+s, or cmd+s on Mac). Save it in a location that will be easy for you to find later, such as in a folder on your Desktop or in your Downloads folder\nCopy the following code into that file and save the changes:\n# Install ENA package\nusing Pkg\nPkg.add(url=\"https://github.com/snotskie/EpistemicNetworkAnalysis.jl\")\nRun the file by pressing the Run icon (looks like a \"play button\" or triangle pointing to the right, located toward the top-right of the VS Code window). Note, the first time you run this code may take some time to complete. If your VS Code window says Julia:Evaluating in the bottom left, then your code is still running\nOnce everything is installed, test that it works by:\nCreate a new file in VS Code\nSave it with the name main.jl\nCopy the following code into that file and save the changes:\n# Load ENA package\nusing EpistemicNetworkAnalysis\n\n# Load sample dataset, codes from my first year on hormone replacement therapy\ndata = loadExample(\"transitions\") # NOTE: To load your own data, see DataFrame(CSV.File(...))\n\n# Derive some new codes based on old ones\nderiveAnyCode!(data, :BODY, :Changes, :Mood, :Oily, :Dysphoria, :Cry)\nderiveAnyCode!(data, :REFLECT, :Identity, :Longing, :Dream, :Childhood, :Family, :Name, :Letter, :Doubt, :Religion)\nderiveAnyCode!(data, :LEARN, :WWW, :Experiment, :Recipe)\nderiveAnyCode!(data, :PROGRESS, :Strangers, :Passed, :Out, :Affirmation)\n\n# Add new columns for splitting the year's data in half, third, ...\ndata[!, :All] .= \"All\"\ndata[!, :Half] .= \"First\"\ndata[183:end, :Half] .= \"Second\"\ndata[!, :Third] .= \"First\"\ndata[122:243, :Third] .= \"Second\"\ndata[244:end, :Third] .= \"Third\"\ndata[!, :Fourth] .= \"First\"\ndata[92:183, :Fourth] .= \"Second\"\ndata[184:275, :Fourth] .= \"Third\"\ndata[276:end, :Fourth] .= \"Fourth\"\n\n# List columns to use as codes, convos, and units\ncodes = [:DoseTracking, :SkippedDose, :Happy, :NonHappy, :Sweets, :BODY, :REFLECT, :LEARN, :PROGRESS]\nconversations = [:Date]\nunits = [:Date]\n\n# Run the model and plot it\nmodel = ENAModel(data, codes, conversations, units)\np = plot(model)\ndisplay(p)\nRun the file by pressing the Run icon. Note, the first time you run this code may take some time to complete\nIf an ENA plot appears, congrats! Everything is setup and ready to go for the workshop!\nComplete the prior knowledge survey to help us plan and tell us a little about yourself","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"If you have any problems and questions during setup at all, please let me know and we'll get you squared away!","category":"page"},{"location":"icqe23/#Intro","page":"ICQE23 Workshop","title":"Intro","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"This is a 2-hour tutorial workshop","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Workshop Goals:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Give QE researchers the power to choose and develop custom rotations to fit their research aims, by introducing them to open-source ENA-based tools\nLearners will be able to (a) create and interpret ENA models that have rotations beyond SVD and means rotation\n(b) understand the steps of the ENA algorithm and the connections between rotation choice and research aims\n(c) use Github issues to get assistance, troubleshoot problems, and contribute to ENA API development","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Workshop Audience:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"QE researchers\nalready familiar with ENA\na beginner's understanding of at least one programming language\nwho want to use rotations beyond SVD and means rotation in their own research (or understand more about rotations in the first place)","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Workshop structure:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Live-coding / code-along model\nThree phases:\nDemo how to make several different models with different rotations with one running example\nDiscussion on choosing the right rotation for the job, based on your gut sense of your research story\nLooking ahead discussion, sharing pathways for contributing and getting help after the workshop","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Code of Conduct:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Use welcoming and inclusive language\nBe respectful of different viewpoints and experiences\nGracefully accept constructive criticism\nFocus on what is best for the community\nShow courtesy and respect towards other community members","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Full CoC","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"If you would like to report any misconduct, contact a Data Science Hub Facilitator: <facilitator@datascience.wisc.edu>","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Collaborative Notes","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"We use Etherpad to write notes collaboratively, link to be given during the event","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Notes and code will be added as the instructor presents the material","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Have conceptual questions?","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Get the instructor’s attention by raising your hand","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Encounter a bug?","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Get a helper’s attention by raising your hand or putting your name card on its side with the red facing up","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Setup check: green side up if they completed setup before the workshop","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"discussion: Discussion\nGreen card up if you want to participate in introductions\nName, (pronouns), where are you coming from?\nWhat are you excited to learn from this workshop?\nOr, what is one question you have? (Keep running questions on the board)","category":"page"},{"location":"icqe23/#Demo-and-Worked-Example","page":"ICQE23 Workshop","title":"Demo and Worked Example","text":"","category":"section"},{"location":"icqe23/#Dataset","page":"ICQE23 Workshop","title":"Dataset","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"The dataset we'll be using are codes and metadata from my first year on hormone replacement therapy. I'm a transgender woman, Valentines Day 2020 I started my medical transition, and I kept a daily record in various ways on my phone that first year. Also that year I learned QE and started developing tools for ENA. As a test case, I coded my own data, modeled it, and more recently made it available. (Though, just the codes and metadata, not the text of the daily entries, given their private nature)","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"This dataset is packaged with EpistemicNetworkAnalysis.jl, so you can preview it on GitHub","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"activity: Activity\nPreview the data with your partner\nWhat stands out to you about what the data contains?\nWhat metadata columns do we have and how might we use them?\nAt a skim, are their codes that have way more 1s than others?","category":"page"},{"location":"icqe23/#Getting-Started","page":"ICQE23 Workshop","title":"Getting Started","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"We'll start where the setup instructions left off:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"# Load ENA package\nusing EpistemicNetworkAnalysis\n\n# Load sample dataset, codes from my first year on hormone replacement therapy\ndata = loadExample(\"transitions\")\n\n# Derive some new codes based on old ones\nderiveAnyCode!(data, :BODY, :Changes, :Mood, :Oily, :Dysphoria, :Cry)\nderiveAnyCode!(data, :REFLECT, :Identity, :Longing, :Dream, :Childhood, :Family, :Name, :Letter, :Doubt, :Religion)\nderiveAnyCode!(data, :LEARN, :WWW, :Experiment, :Recipe)\nderiveAnyCode!(data, :PROGRESS, :Strangers, :Passed, :Out, :Affirmation)\n\n# Add new columns for splitting the year's data in half, third, ...\ndata[!, :All] .= \"All\"\ndata[!, :Half] .= \"First\"\ndata[183:end, :Half] .= \"Second\"\ndata[!, :Third] .= \"First\"\ndata[122:243, :Third] .= \"Second\"\ndata[244:end, :Third] .= \"Third\"\ndata[!, :Fourth] .= \"First\"\ndata[92:183, :Fourth] .= \"Second\"\ndata[184:275, :Fourth] .= \"Third\"\ndata[276:end, :Fourth] .= \"Fourth\"\n\n# List columns to use as codes, convos, and units\ncodes = [:DoseTracking, :SkippedDose, :Happy, :NonHappy, :Sweets, :BODY, :REFLECT, :LEARN, :PROGRESS]\nconversations = [:Date]\nunits = [:Date]\n\n# Run the model and plot it\nmodel = ENAModel(data, codes, conversations, units)\np = plot(model)\ndisplay(p)\nusing Plots # hide\nmkdir(\"icqe23\") # hide\nsavefig(p, \"icqe23/opening-example.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"checkin: Checkin\nGreen cards up if you would like me to speed up?\nGreen cards up if you would like me to slow down?","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"activity: Activity\nTry removing different combinations of codes from the model\nWhat impact does that have?\nDo some codes have more impact than others? In what ways?","category":"page"},{"location":"icqe23/#Plot-Interpretation","page":"ICQE23 Workshop","title":"Plot Interpretation","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"plot(model) produces a plot with the following subplots:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(a) an overall mean, which tells us the baseline everything compares against\n(b) and (c) rates of change for each connection across the x- and y-axes, which gives us a clue about what is being modeled by each axis. If you are coming up with a name for the x-axis, it's good to check your assumptions against these trends and make sure they lign up\nSubsequent subplots show each subgroup on its own. It's good to compare these to the overall mean\nAnd the last subplots show how each pair of subgroups compare. Similar to the trend plots, these show you what is being modeled by the difference of the two groups. If everything looks grey, then it's hard to give a succinct description of that difference: there's just a lot of noise","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Some differences from WebENA and rENA:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Saturation shows correlation strength so we can tell at a glance when a model might be weak. In WebENA and rENA saturation is redundant (not a bad thing) with line thickness, which shows magnitude of an effect\nPlots are mean centered by moving the origin of the plot, not by changing the underlying data. This preserves information that may or may not be useful for downstream analyses\nPlots are opinionated. Based on the model config, the plot's default settings change to what I believed was the best way to plot that kind of model. This gives you the \"right\" plot without having to specify what \"right\" means each time\nA known issue is that the y-axis label can get cutoff when there are a lot of subplots","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"discussion: Discussion\nWhat does the story of the plot seem to be so far?\nWhat information seems to be missing?","category":"page"},{"location":"icqe23/#Conversation,-Window-Size,-and-Empty-Units","page":"ICQE23 Workshop","title":"Conversation, Window Size, and Empty Units","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"As is, each day is its own \"conversation,\" meaning no connections are made from day to day. Instead, lets change the conversation to the whole year:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"conversations = [:All] # :All is a column we made that just contains the word \"All\"\nmodel = ENAModel(data, codes, conversations, units) # hide\np = plot(model) # hide\nsavefig(p, \"icqe23/all-convo.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"That's better, I guess. But let's inspect the model to see what's going on:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"display(model)","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Notice this part of the output:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":" ModelConfig =\n     (codes = [:DoseTracking,\n               :SkippedDose,\n               :Happy,\n               :NonHappy,\n               :Sweets,\n               :BODY,\n               :REFLECT,\n               :LEARN,\n               :PROGRESS],\n      conversations = [:All],\n      units = [:Date],\n      unitFilter = ...,\n      edgeFilter = ...,\n      windowSize = Inf, <--- This part right here\n      sphereNormalize = true,\n      dropEmpty = false,\n      recenterEmpty = false),","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"By default, the window size in this package is infinite, meaning any connection between any codes in the whole conversation are counted. Let's pick a more sensible window:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"model = ENAModel(\n    data, codes, conversations, units,\n    windowSize=4\n)\np = plot(model) # hide\nsavefig(p, \"icqe23/window-4.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Getting better. But one more tweak. Let's tell the model what to do with empty units. David's convinced me that the best place to put them is in the mean or center of the plot. This has advantages for proper stats tests later","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"model = ENAModel(\n    data, codes, conversations, units,\n    windowSize=4,\n    recenterEmpty=true\n)\np = plot(model) # hide\nsavefig(p, \"icqe23/recenter-empty.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Significantly better!","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"activity: Activity\nTry changing the value of windowSize a few times\nWhat kind of impact does that have on the model?\nWhat does changing the windowSize mean when qualitatively when thinking about data that moves over a year?","category":"page"},{"location":"icqe23/#Plot-Tweaks","page":"ICQE23 Workshop","title":"Plot Tweaks","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"This is data that moves over time. And other projects I know have data that moves over different continuous variables, like grades or so on. Let's color code our plot to make that pop:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"p = plot(\n    model,\n    spectralColorBy=:Day\n)\nsavefig(p, \"icqe23/spectral-day.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Alternatively, we could split the year's data in half and color code by that instead:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"p = plot(\n    model,\n    groupBy=:Half # :Half is a column we added that says \"First\" then \"Second\"\n)\nsavefig(p, \"icqe23/group-half.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"activity: Activity\nTry splitting it in thirds (groupBy=:Third) or in fourths (groupBy=:Fourth)","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"discussion: Discussion\nWhich version of the plot shows the most information?\nWhat story are you starting to see emerge from the data?\nOr how is your sense of the story changing as we show it in different ways?","category":"page"},{"location":"icqe23/#Rotations","page":"ICQE23 Workshop","title":"Rotations","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"The first and second halves seem different. Let's rotate the model to make that focus explicit:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"rotation = MeansRotation(:Half, \"First\", \"Second\")\nmodel = ENAModel(\n    data, codes, conversations, units,\n    windowSize=4,\n    recenterEmpty=true,\n    rotateBy=rotation\n)\np = plot(model) # hide\nsavefig(p, \"icqe23/mr-half.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Turns out, in this data, the default SVD rotation was nearly identical to that means rotation","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"But, a person's experience over a year can't be summed up as just a before and an after, right? Let's split the year in thirds and make that three-way difference the focus:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"rotation = MulticlassRotation(:Third)\nmodel = ENAModel( # hide\n    data, codes, conversations, units, # hide\n    windowSize=4, # hide\n    recenterEmpty=true, # hide\n    rotateBy=rotation # hide\n) # hide\np = plot(model) # hide\nsavefig(p, \"icqe23/mcmr-third.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"That's starting to feel better","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Let's try splitting the year in fourth next:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"rotation = MulticlassRotation(:Fourth)\nmodel = ENAModel( # hide\n    data, codes, conversations, units, # hide\n    windowSize=4, # hide\n    recenterEmpty=true, # hide\n    rotateBy=rotation # hide\n) # hide\np = plot(model) # hide\nsavefig(p, \"icqe23/mcmr-fourth.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"The \"arc\" of the year is starting to take shape","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"But wow! That's a lot of subplots. Let's pull out just one for now:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"sp = plot(p.subplots[1], size=(700,700))\ndisplay(sp)\nsavefig(sp, \"icqe23/mcmr-fourth-sp1.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"activity: Activity\nTry running a multiclass rotation using :Half as the grouping variable\nHow does this compare to the means rotation? Why do you think that is?","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"challenge: Challenge\nRun a model that compares thirds of the year. Plot just the subplot that compares the first and second third. Make sure the plot is zoomed enough for a legible plot","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"discussion: Discussion\nWe've seen this data modeled a lot of different ways now. Which codes seem to really be driving the story the most?","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Let's model that assumption directly:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"rotation = TopicRotation(\"HRT?\", [:SkippedDose], [:Happy])\n# ...\nmodel = ENAModel( # hide\n    data, codes, conversations, units, # hide\n    windowSize=4, # hide\n    recenterEmpty=true, # hide\n    rotateBy=rotation # hide\n) # hide\np = plot(\n    model,\n    spectralColorBy=:Day\n)\nsavefig(plot(p.subplots[1], size=(700,700)), \"icqe23/topic-spectral.svg\"); nothing # hide\n# or\np = plot(\n    model,\n    groupBy=:Fourth\n)\nsavefig(plot(p.subplots[1], size=(700,700)), \"icqe23/topic-fourth.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"That seems to be pretty close. The spectral plot still has a lot of red in the middle though. I'd like it to make clear \"stripes\" of color if possible. And being familiar with this data (having lived it), I know that there's a little more to the story than just those two codes","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"rotation = TopicRotation(\"HRT\", [:SkippedDose, :DoseTracking], [:Happy, :PROGRESS])\nmodel = ENAModel( # hide\n    data, codes, conversations, units, # hide\n    windowSize=4, # hide\n    recenterEmpty=true, # hide\n    rotateBy=rotation # hide\n) # hide\np = plot( # hide\n    model, # hide\n    spectralColorBy=:Day # hide\n) # hide\nsavefig(plot(p.subplots[1], size=(700,700)), \"icqe23/topic-redo-spectral.svg\"); nothing # hide\np = plot( # hide\n    model, # hide\n    groupBy=:Fourth # hide\n) # hide\nsavefig(plot(p.subplots[1], size=(700,700)), \"icqe23/topic-redo-fourth.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Much better","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"challenge: Challenge\nSeveral codes are getting \"clumped\" together near the middle. Create a model that forces two of those codes to the left and two of those codes to the right, then plot it.","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Coming up with that HRT model was a lot of work, especially since I had to tell you the answer I came up with from a lot of qualitative work","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"But what if we just wanted to ask, show me the model that captures time, linearly, and with early on the left and late on the right?","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"To do that, we first need to add a linear modeling library:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"using Pkg\nPkg.add(\"GLM\")","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Then we can use it as part of a rotation:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"using GLM\n# ...\nrotation = FormulaRotation(\n    LinearModel, @formula(y ~ 1 + Day), 2, nothing\n)\nmodel = ENAModel( # hide\n    data, codes, conversations, units, # hide\n    windowSize=4, # hide\n    recenterEmpty=true, # hide\n    rotateBy=rotation # hide\n) # hide\np = plot( # hide\n    model, # hide\n    spectralColorBy=:Day # hide\n) # hide\nsavefig(plot(p.subplots[1], size=(700,700)), \"icqe23/formula-spectral.svg\"); nothing # hide\np = plot( # hide\n    model, # hide\n    groupBy=:Fourth # hide\n) # hide\nsavefig(plot(p.subplots[1], size=(700,700)), \"icqe23/formula-fourth.svg\"); nothing # hide","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"discussion: Discussion\nWhich rotations are you most likely to use in your own work? Why?","category":"page"},{"location":"icqe23/#Exporting-Results-and-Importing-your-own-Data","page":"ICQE23 Workshop","title":"Exporting Results and Importing your own Data","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Two useful functions for exporting your results are to_xlsx and savefig:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"to_xlsx(\"example.xlsx\", model)\n\nusing Plots\np = plot(model)\nsavefig(p, \"example.png\")","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"We use loadExample to load one of the pre-baked example datasets. To load your own data, you use the DataFrames and CSV packages:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"using DataFrames\nusing CSV\ndata = DataFrame(CSV.File(\"example.csv\"))","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Remember, you may first have to add these packages with Pkg.add(\"Plots\") etc.","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"tip: Tip\nWhen preparing your data for ENA, it is a good idea to remove any spaces or punctuation from your column names. Choose short, proper case nouns. You can always spell things out further in your codebook","category":"page"},{"location":"icqe23/#Choosing-Models","page":"ICQE23 Workshop","title":"Choosing Models","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"A big part of choosing the right model is telling stories","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"discussion: Discussion\nPair up. Pick your favorite version of the model we've run so far and use it to write a summary of the year's data, in less than 80 words. As needed, you can check your understanding against the codebook\nWhose story is the right version of the story to tell? Is yours the right version of the story to tell? How would you even judge that?\nThis data is about me. If I told you your telling of the story felt weird to me, would that affect your answer?\nDid your model affect the way you structured your story? How so?","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Here we made the model first and told the story second. Let's try it the other way","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"activity: Activity\nPut the image below on the board\nSplit the group in half: ethnographers and ethnographers-of-ethnographers\nEthnographers: How would you describe this image? Discuss and put sticky note labels right on the TV. Label everything you see\nE-o-Es: Watch their discussion and take notes\nWhen done, take the image away, leaving just the stickies\nE-o-Es: What did you observe and what do you see going on up here?\nEthnographers: Watch their discussion and take notes\nWhen done, Ethnographers: What did you observe?(Image: )","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Stories have structure, and these structures have a geometry to them:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"We talk about some set of events because they share some sense of similarity\nWe move onto the next paragraph where we talk about a different set of events sharing a different similarity\nAnd we hang those paragraphs together into a larger narrative structure\nThese narratives have a geometry to them: over here is this, and over here is this, and here's how the qualities change as we move around from point to point, from paragraph to paragraph","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"ENA helps us capture that geometry. The ENA process as a whole has five steps:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Accumulate connection counts between qualitative codes over a sliding window. This gives a high dimensional matrix representation of one's discourse\nEmbed a network into that space as a way to approximately understand how the model weights change as one moves through the space\nReduce the dimensionality of that space to highlight one's features of interest. This is called dimension reduction, multidimensional scaling, or rigid body rotation in QE-land\nVisualize that reduced space\nInterpret the results","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"All these steps are agnostic to your sense of your narrative structure, except for the third, the dimension reduction step. It's in that step that the algorithm chooses which information to show and which to hide. Ideally, your dimension reduction lets you think on the plot the same way you think on the page—over here is this, and over here is this—, letting you (a) move through the story as feels natural while (b) retaining exactly the information you need to tell and test that kind of story","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Our sense of our story should drive our ENA models. And when the two conflict, we should figure out why and extend ENA to fit","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"To get us started, I've tried to build into EpistemicNetworkAnalysis.jl enough rotations that I believe are flexible enough to handle the bulk of cases","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"SVDRotation: The default. Use this to get a high level view of your data. A really good place to start. Rarely the best place to stop\nMeansRotation: Use this to compare exactly two groups. Use this to compare exactly two groups that are each divisible into exactly two sub-groups\nMulticlassRotation and LDARotation: Use these to compare multiple groups. When you have a continuous variable, it's likely that your story still moves over discrete touchpoints, eg., low-scoring students, early days in the year, etc. Let your sense of your story guide how you split up your data into groups, then compare those groups\nTopicRotation: Use this to check prior theory, or your own inferences, about how codes will affect a model. We do a lot of thinking from our inferences about what a model is capturing. This rotation lets you make that thinking explicit\nFormulaRotation: My feelings on this are similar to SVD. It's probably a good place to start, to see how your data compares to some variable. Pair it with a spectralColorBy. But it also probably isn't a good place to end, since linear regressions likely don't fit how we structure our tellings of the story. Even so, this rotation is incredibly flexible, so it can be a good starting point for creating other rotations\nTrainedRotation: Use this when you need to test a different rotation against a holdout test or validation set. It isn't a rotation in itself, but instead a useful piece of ENA machinery for perform certain kinds of model validity checks","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"checkin: Checkin\nIs there anything you would like me to review again or cover before we move on to getting help after the conference?","category":"page"},{"location":"icqe23/#Getting-Help-and-Contributing","page":"ICQE23 Workshop","title":"Getting Help and Contributing","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"EpistemicNetworkAnalysis.jl lives on GitHub","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"But not just that package. All of Julia lives on GitHub. Every Julia package, and even the language itself, by design are hosted on GitHub. This can make things difficult for people living in some countries where GitHub is occasionally blocked or slowed. By and far though, this allows you to:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"See and report issues for all Julia packages, as well as propose your own fixes\nSee the entire history of development and discussion for all Julia packages\nEasily find documentation for most Julia packages\nEngage in discussion with other users of some of your favorite packages\nDirectly ask developers for help","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Julia also has a very active and welcoming discussion board","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Julia has from the very beginning made open source development a part of how the language itself works. I really appreciate this because it builds community right into everything I do with it. You never code alone, and you never learn to code alone","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"While Julia takes this to the limit, other QE resources are also open to varying extents:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"rENA lets you see issues and development history on gitlab\nSeveral workshops shared on qesoc via Google Drive:\nROCK workshop\nIntro to ENA workshop\nAdvanced ENA workshop\nrENA workshop\nIntro to Automated Coding workshop","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"discussion: Discussion\nSummarize with your neighbor in 15 words or less: What does EpistemicNetworkAnalysis.jl being open source mean to you?\nWhat other QE open resources am I missing? Other not-specifically-QE-but-still-useful open resources?\nWhat are you planning to do with ENA and ENA tools like EpistemicNetworkAnalysis.jl in the future? What kind of support or community would best help you on that?","category":"page"},{"location":"icqe23/#Closeout","page":"ICQE23 Workshop","title":"Closeout","text":"","category":"section"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Before we leave, let's plan some future activities:","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Users: If you are primarily planning on using EpistemicNetworkAnalysis.jl or tools like it, not developing new tools or extensions to them, schedule a post-conference check-in with me (TODO) to see how you're doing and help you along with your projects\nDevelopers: If you are planning on developing extensions to EpistemicNetworkAnalysis.jl or writing other tools like it, vote on a meetup time (TODO) for developers to get together and share what we're thinking and working on","category":"page"},{"location":"icqe23/","page":"ICQE23 Workshop","title":"ICQE23 Workshop","text":"Finally, thank you so so much! Whether you attended this workshop in person or you found these notes useful after the fact, pop in and say hi!","category":"page"}]
}
