-- Sections 3 to 7

-- Conditional expressions:

data Expr = Val Value | Add Expr Expr | If Expr Expr Expr
            deriving Show

data Value = I Int | B Bool | Error
             deriving Show

eval :: Expr -> Value
eval (Val v)    = v
eval (Add x y)  = add (eval x) (eval y)
eval (If x y z) = cond (eval x) (eval y) (eval z)

add :: Value -> Value -> Value
add (I n) (I m) = I (n+m)
add _     _     = Error

cond :: Value -> Value -> Value -> Value
cond (B b) v w  = if b then v else w
cond _     _ _  = Error

-- Type checking:

data Type = INT | BOOL | ERROR
            deriving (Show, Eq)

tval :: Value -> Type
tval (I _) = INT
tval (B _) = BOOL
tval Error = ERROR

instance Ord Type where
   -- (<=) :: Type -> Type -> Bool
   t <= t' = t == ERROR || t == t'

(/\) :: Type -> Type -> Type
t /\ t' = if t == t' then t else ERROR

-- Calculating the type checker:

texp :: Expr -> Type
texp (Val v)    = tval v
texp (Add x y)  = add' (texp x) (texp y)
texp (If x y z) = cond' (texp x) (texp y) (texp z)

add' :: Type -> Type -> Type
add' INT INT = INT
add' _    _  = ERROR

cond' :: Type -> Type -> Type -> Type
cond' BOOL t t' = t /\ t'
cond' _    _ _  = ERROR

-- Algebraic approach:

folde :: (Value -> a) -> (a -> a -> a) -> (a -> a -> a -> a) -> Expr -> a
folde val add cond = f
   where
      f (Val v)    = val v
      f (Add x y)  = add (f x) (f y)
      f (If x y z) = cond (f x) (f y) (f z)

eval' :: Expr -> Value
eval' = folde id add cond

texp' :: Expr -> Type
texp' = folde tval add' cond'
