-- Section 8

-- Conditional expressions:

data Expr = Val Value | Add Expr Expr | If Expr Expr Expr
            deriving Show

data Value = I Int | B Bool | Error
             deriving Show

folde :: (Value -> a) -> (a -> a -> a) -> (a -> a -> a -> a) -> Expr -> a
folde val add cond = f
   where
      f (Val v)    = val v
      f (Add x y)  = add (f x) (f y)
      f (If x y z) = cond (f x) (f y) (f z)

-- Types:

data Type = INT | BOOL | ERROR | TOP
            deriving (Show, Eq)

instance Ord Type where
   -- (<=) :: Type -> Type -> Bool
   ERROR <= _   = True
   _     <= TOP = True
   t     <= t'  = t == t'

(/\) :: Type -> Type -> Type
BOOL /\ INT = ERROR
INT  /\ BOOL = ERROR
t    /\ t'   | t  <= t'  = t
             | t' <= t   = t'
             | t  == t'  = t
             | otherwise = ERROR

(~>) :: Bool -> Type -> Type
b ~> t = if b then t else TOP

-- Type checking:

tval :: Value -> Type
tval (I _) = INT
tval (B _) = BOOL
tval Error = ERROR

texp :: Expr -> Type
texp = folde tval add' cond'

add' :: Type -> Type -> Type
add' t t' =  ((t <= INT  && t' <= INT)  ~> INT)
          /\ ((t <= BOOL || t' <= BOOL) ~> ERROR)

cond' :: Type -> Type -> Type -> Type
cond' s t t' =  ((s <= BOOL) ~> (t /\ t'))
             /\ ((s <= INT)  ~> ERROR)
