module Reasoning.Syntax where

open import Relation.Binary.Bundles using (Poset; Preorder)

module ≥-syntax {p₁ p₂ p₃} (P : Poset p₁ p₂ p₃) where
  open import Relation.Binary.Reasoning.PartialOrder (P)
  infixr 2 step-≥
  step-≥ = step-≤
  syntax step-≥ x y≥z x≥y = x ≥⟨ x≥y ⟩ y≥z

module ⇐-syntax {p₁ p₂ p₃} (P : Preorder p₁ p₂ p₃) where
  open import Relation.Binary.Reasoning.Preorder (P)
  infixr 2 step-⇐
  step-⇐ = step-≲
  syntax step-⇐ x y⇐z x⇐y = x ⇐⟨ x⇐y ⟩ y⇐z

module ⇒-syntax {p₁ p₂ p₃} (P : Preorder p₁ p₂ p₃) where
  open import Relation.Binary.Reasoning.Preorder (P)
  infixr 2 step-⇒
  step-⇒ = step-≲
  syntax step-⇒ x y⇒z x⇒y = x ⇒⟨ x⇒y ⟩ y⇒z

module ⇔-syntax {p₁ p₂ p₃} (P : Preorder p₁ p₂ p₃) where
  open import Relation.Binary.Reasoning.Preorder (P)
  infixr 2 step-⇔ step-⇔-|
  step-⇔ = step-≈
  step-⇔-| = step-≡-∣
  
  syntax step-⇔ x y⇐z x⇔y = x ⇔⟨ x⇔y ⟩ y⇐z
  syntax step-⇔-| x x⇔y = x ⇔⟨⟩ x⇔y

module use-≥ {p₁ p₂ p₃} (P : Poset p₁ p₂ p₃) where
  open import Relation.Binary.Reasoning.PartialOrder (P) public
  open ≥-syntax (P) public

module use-⇐ {p₁ p₂ p₃} (P : Preorder p₁ p₂ p₃) where
  open import Relation.Binary.Reasoning.Preorder (P) public
  open ⇐-syntax (P) public
  open ⇔-syntax (P) public

module use-⇒ {p₁ p₂ p₃} (P : Preorder p₁ p₂ p₃) where
  open import Relation.Binary.Reasoning.Preorder (P) public
  open ⇒-syntax (P) public
  open ⇔-syntax (P) public
