module Positivity.Definitions where

open import Data.Integer
open import Data.Product renaming (_×_ to _∧_)

data Expr : Set where
  val : ℤ → Expr
  add : Expr → Expr → Expr

eval : Expr → ℤ
eval (val n) = n
eval (add x y) = eval x + eval y

isPos : Expr → Set
isPos (val n) = n > +0
isPos (add x y) = isPos x ∧ isPos y
