# Formalisation of The Calculated Typer

In this Agda library, we formalise the calculations and proofs shown
in the paper.

## Contents

 - Meta/generally useful definitions and proofs
   - [X] Implication reasoning [src](src/Reasoning/Syntax.agda)
   - [X] Greater-than poset reasoning [src](src/Reasoning/Syntax.agda)
   - [X] Implication properties [src](src/Reasoning/Implication.agda)
 - Positivity Checking (Section 2)
   - [X] Definitions [src](src/Positivity/Definitions.agda)
   - [X] Calculations [src](src/Positivity/Calculations.agda)
 - Composition of constraints (Section 8)
   - [X] Definition of ⇛ [src](src/Monotonicity/Definitions.agda)
   - Properties of ⇛ [src](src/Monotonicity/Properties.agda)
     - [X] collect, subsume, and disjunct (from paper)
 - Monotonicity stuff, defined for any bounded meet semilattice
   - [X] Definition of monotonicity for 1/2/3-argument functions
   - Properties of monotonicity
	 - [X] Conversions between 1/2/3-argument functions
	 - [X] Monotonicity of greatest lower bound
	 - [X] Monotonicity of ⇛
	 - [X] Monotonicity of constant function
	 - [X] Monotonicity of ∧? and ∨?
 - Conditionals (Sections 3-8)
   - Definitions [src](src/Conditionals/Definitions.agda)
	 - [X] Values, expressions, types (with TOP)
	 - [X] Evaluation algebras
	 - [X] Decidable quality
	 - [X] Decidable ordering
	 - [X] Greatest lower bound
   - Properties, proofs [src](src/Conditionals/Properties.agda)
	 - [X] ≤ is a poset
	 - [X] ⊓ is a bounded meet semilattice
   - Calculations with fusion (Section 6-8)
	 - Definition and proof of fusion [src](src/Conditionals/Fusion.agda)
	   - [X] Definition of fold operator
	   - [X] Proof of the fold fusion law
	 - Using fusion [src](src/Conditionals/Calculations/Fusion.agda)
	   - [X] Definitions of texp algebras from their constraints/⇛/⊓
	   - [X] Proofs that the homomorphism properties follow from the
	         calculated constraints defining the algebras
	   - [X] (Trivial) proofs of monotonicity
	   - [X] Applying the fusion law to show correctness
 - Exceptions (Sections 9 and 10)
   - Definitions [src](src/Exceptions/Definitions.agda)
	 - [X] Values, expressions, types (with TOP, INT?, and BOOL?)
	 - [X] Evaluation algebras
	 - [X] Decidable quality
	 - [X] Decidable ordering
	 - [X] Greatest lower bound
   - Properties, proofs [src](src/Exceptions/Properties.agda)
	 - [X] ≤ is a poset
	 - [X] ⊓ is a bounded meet semilattice
   - Calculations with fusion
     - Definition and proof of fusion [src](src/Exceptions/Fusion.agda)
	   - [X] Definition of fold operator
	   - [X] Proof of the fold fusion law
	 - Using fusion [src](src/Exceptions/Calculations/Fusion.agda)
	   - [X] Definitions of texp algebras in terms of ⇛/⊓
	   - [X] Proofs that the homomorphism properties follow from the
	         constraints calculated.
	   - [X] (Trivial) proofs of monotonicity
	   - [X] Applying the fusion law to show correctness
