# Modification Instructions

- Crazyflie git hash "7a0ed44bb28440770702d95cd2ac4862e1ef5071"
- Copy `Makefile` into crazyflie main folder `crazyflie-firmware/`
- Copy `tasks.c` into `crazyflie-firmware/vendor/FreeRTOS/tasks.c`
- Copy `hp_config.h` into `crazyflie-firmware/src/config/hp_config.h`
- Copy 'HOTPATCH.ld` into `crazyflie-firmware/tools/make/linker/HOTPATCH.ld`

building has been tested with the following command:
```
make PLATFORM=cf2 DEBUG=1
```

(without DEBUG=1 warnings will be turned into errors and the vanilla version of crazyflie won't even compile)

# Creating a hotpatch

Hotpatch files themselves are located in `hotpatches` where the `hp_helper.h` in the include folder has a few helper functions to easily create hotpatches. For reference, take a look at the existing hotpatches. Please do not modify them as they have already been verified.

You then have to add the hotpatch to your Makefile, for instance:
```
PATCH_DIR := ../../../hotpatches

...

# Hotpatches
SRC_FILES += \
  $(PATCH_DIR)/freertos/cve_2020_17443.c \

# Hotpatch
INC_FOLDERS += \
  $(PATCH_DIR)/include \

```

After compiling, you can generate a hotpatch using the generator in `hotpatching_2024/hotpatch_generator`. An example generation command:
```
python3 hotpatch_generator.py ../cve/zephyr/cve_2020_10021 zephyr arm cve_2020_10021
```

You get an output that could look something like this:

```
Symbol Sections:
.bss.hotpatch_address_curr_lba
.bss.hotpatch_address_curr_offset
.bss.hotpatch_address_block_count
infoTransfer
Orig Code: 0x4a174916
=> infoTransfer <=
redirect
[Address Relocation]: curr_lba -> 0x2000567c 0x4c
[Address Relocation]: curr_offset -> 0x200074b4 0x50
[Address Relocation]: block_count -> 0x20005680 0x54
External Call Offsets
[external call offset]: 0x38
[external call offset]: 0x40
Grouping call relocations
===== fail 0x2975 0xe
===== sendCSW 0x2931 0x12
===== fail 0x2975 0x3c
===== sendCSW 0x2931 0x44
Encoded Branch: F813F000, Call: 00002975
Call Addr: 0x2975
Patched Call: fail
Encoded Branch: F815F000, Call: 00002931
Call Addr: 0x2931
Patched Call: sendCSW
88
Call Relocations:
['fail', 'sendCSW', 'fail', 'sendCSW']
[Resolved-Call]: fail -> 0xe 0x2975
[Resolved-Call]: sendCSW -> 0x12 0x2931
[Resolved-Call]: fail -> 0x3c 0x2975
[Resolved-Call]: sendCSW -> 0x44 0x2931
Branch to original code:
hotpatch_branch_to_orig_ -> 0x2c
0x0 0xf000f8df
Code Offset: 00000030
Target Address: 20004008
08
Code [88] = { 
0x7C,0xB4,0x12,0x4E,0x12,0x4D,0x13,0x4A,0x23,0x46,0x9A,0x42,0x07,0xD8,0x00,0xF0,0x13,0xF8,0x00,0xF0,0x15,0xF8,0x00,0x23,0x18,0x46,0x7C,0xBC,0x10,0xBD,0x00,0x22,0x23,0x46,0x33,0x60,0x13,0x46,0x2B,0x60,0x7C,0xBC,0x00,0x22,0xDF,0xF8,0x00,0xF0,0x11,0x40,0x00,0x20,0x00,0xBF,0x00,0xBF,0xDF,0xF8,0x00,0xF0,0x75,0x29,0x00,0x00,0xDF,0xF8,0x00,0xF0,0x31,0x29,0x00,0x00,0x00,0xBF,0x00,0xBF,0x7C,0x56,0x00,0x20,0xB4,0x74,0x00,0x20,0x80,0x56,0x00,0x20
 };
[112] = { 
0x70,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x08,0x40,0x00,0x20,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0xB4,0x12,0x4E,0x12,0x4D,0x13,0x4A,0x23,0x46,0x9A,0x42,0x07,0xD8,0x00,0xF0,0x13,0xF8,0x00,0xF0,0x15,0xF8,0x00,0x23,0x18,0x46,0x7C,0xBC,0x10,0xBD,0x00,0x22,0x23,0x46,0x33,0x60,0x13,0x46,0x2B,0x60,0x7C,0xBC,0x00,0x22,0xDF,0xF8,0x00,0xF0,0x11,0x40,0x00,0x20,0x00,0xBF,0x00,0xBF,0xDF,0xF8,0x00,0xF0,0x75,0x29,0x00,0x00,0xDF,0xF8,0x00,0xF0,0x31,0x29,0x00,0x00,0x00,0xBF,0x00,0xBF,0x7C,0x56,0x00,0x20,0xB4,0x74,0x00,0x20,0x80,0x56,0x00,0x20
 };
```

The last 112 byte array is important. This is the actual hotpatch binary. To add it to the framework for testing, you can go to the `hotpatching_2024/framework/hotpatch_runtime/src/hp_manager.c` file and adapt the `static const uint8_t SAMPLE_HOTPATCH_CODE`.

IMPORTANT: please comment out the current one and add a new one at the end. These have already been verified!

# Targeting a function

As for now, if you have a function you want to modify add the `__ramfunc` attribute to it such that it is placed in RAM for modifications.