INSERT INTO `user`(`id`, `user_id`, `password`, `user_role`, `name`, `email`, `created`, `active`) 
VALUES (99, 'ahmustm1', '', 'user', 'Max Mustermann', '', '2016-07-05', 1);

INSERT INTO `device` (`id`, `type`, `name`) 
VALUES (1, 'MiSeq', 'Neo');

INSERT INTO `sender` (`id`, `name`) 
VALUES (1, 'Coriell');

INSERT INTO `project` (`id`, `name`, `type`, `internal_coordinator_id`, `analysis`) 
VALUES (1, 'KontrollDNACoriell', 'test', 1, 'variants');

INSERT INTO `sequencing_run` (`id`, `name`, `fcid`, `device_id`, `recipe`, `status`) 
VALUES (1, '#00372', 'AB2J9', 1, '158+8+158', 'analysis_finished');

INSERT INTO `sample` (`id`, `name`, `sample_type`, `species_id`, `gender`, `quality`, `tumor`, `ffpe`, `sender_id`) 
VALUES (1, 'RX123456', 'RNA', 1, 'n/a', 'good', 0 ,0, 1);

INSERT INTO `processing_system` (`id`, `name_short`, `name_manufacturer`, `adapter1_p5`, `adapter2_p7`, `type`, `shotgun`, `target_file`, `genome_id`) 
VALUES (1, 'hpHBOCv5', 'HaloPlex HBOC v5', 'AGATCGGAAGAGCACACGTCTGAACTCCAGTCAC ', 'AGATCGGAAGAGCGTCGTGTAGGGAAAGAGTGT', 'Panel HaloPlex', 0, '/mnt/share/data/enrichment/hpHBOCv5_2014_10_27.bed', 1);

INSERT INTO `processed_sample`(`id`, `sample_id`, `process_id`, `sequencing_run_id`, `lane`, `processing_system_id`, `project_id`) 
VALUES (3999, 1, 3, 1, '1', 1, 1);

INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(1, 5, 'A1BG', 'alpha-1-B glycoprotein', 'protein-coding gene', 'ENSG00000121410'),
(2, 41022, 'A2ML1-AS1', 'A2ML1 antisense RNA 1', 'non-coding RNA', 'ENSG00000256661'),
(3, 17968, 'A4GNT', 'alpha-1,4-N-acetylglucosaminyltransferase', 'protein-coding gene', 'ENSG00000118017'),
(4, 13666, 'AAAS', 'aladin WD repeat nucleoporin', 'protein-coding gene', 'ENSG00000094914'),
(5, 18226, 'AACSP1', 'acetoacetyl-CoA synthetase pseudogene 1', 'pseudogene', 'ENSG00000250420'),
(6, 17, 'AADAC', 'arylacetamide deacetylase', 'protein-coding gene', 'ENSG00000114771'),
(7, 24427, 'AADACL2', 'arylacetamide deacetylase like 2', 'protein-coding gene', 'ENSG00000197953'),
(8, 32038, 'AADACL4', 'arylacetamide deacetylase like 4', 'protein-coding gene', 'ENSG00000204518'),
(9, 19, 'AANAT', 'aralkylamine N-acetyltransferase', 'protein-coding gene', 'ENSG00000129673'),
(10, 20, 'AARS1', 'alanyl-tRNA synthetase 1', 'protein-coding gene', 'ENSG00000090861'),
(11, 54994, 'AARSD1P1', 'AARSD1 pseudogene 1', 'pseudogene', 'ENSG00000234969'),
(12, 14235, 'AASDHPPT', 'aminoadipate-semialdehyde dehydrogenase-phosphopantetheinyl transferase', 'protein-coding gene', 'ENSG00000149313'),
(13, 21, 'AATK', 'apoptosis associated tyrosine kinase', 'protein-coding gene', 'ENSG00000181409'),
(14, 49667, 'ABALON', 'apoptotic BCL2L1-antisense long non-coding RNA', 'non-coding RNA', 'ENSG00000281376'),
(15, 23, 'ABAT', '4-aminobutyrate aminotransferase', 'protein-coding gene', 'ENSG00000183044'),
(16, 55707, 'ABCA3P1', 'ABCA3 pseudogene 1', 'pseudogene', 'ENSG00000257408'),
(17, 31, 'ABCA11P', 'ATP binding cassette subfamily A member 11, pseudogene', 'pseudogene', 'ENSG00000251595'),
(18, 41, 'ABCB10', 'ATP binding cassette subfamily B member 10', 'protein-coding gene', 'ENSG00000135776'),
(19, 14114, 'ABCB10P1', 'ABCB10 pseudogene 1', 'pseudogene', 'ENSG00000274099'),
(20, 60, 'ABCC9', 'ATP binding cassette subfamily C member 9', 'protein-coding gene', 'ENSG00000069431'),
(21, 52, 'ABCC10', 'ATP binding cassette subfamily C member 10', 'protein-coding gene', 'ENSG00000124574'),
(22, 61, 'ABCD1', 'ATP binding cassette subfamily D member 1', 'protein-coding gene', 'ENSG00000101986'),
(23, 48841, 'ABCF2P1', 'ATP binding cassette subfamily F member 2 pseudogene 1', 'pseudogene', 'ENSG00000242159'),
(24, 13884, 'ABCG4', 'ATP binding cassette subfamily G member 4', 'protein-coding gene', 'ENSG00000172350'),
(25, 21398, 'ABHD6', 'abhydrolase domain containing 6, acylglycerol lipase', 'protein-coding gene', 'ENSG00000163686'),
(26, 20293, 'ABHD13', 'abhydrolase domain containing 13', 'protein-coding gene', 'ENSG00000139826'),
(27, 24538, 'ABHD14A', 'abhydrolase domain containing 14A', 'protein-coding gene', 'ENSG00000248487'),
(28, 16128, 'ABHD16B', 'abhydrolase domain containing 16B', 'protein-coding gene', 'ENSG00000183260'),
(29, 38509, 'ABHD17AP8', 'ABHD17A pseudogene 8', 'pseudogene', 'ENSG00000260540'),
(30, 24011, 'ABI2', 'abl interactor 2', 'protein-coding gene', 'ENSG00000138443'),
(31, 1364, 'ABITRAM', 'actin binding transcription modulator', 'protein-coding gene', 'ENSG00000119328'),
(32, 29132, 'ABLIM3', 'actin binding LIM protein family member 3', 'protein-coding gene', 'ENSG00000173210'),
(33, 55674, 'ABR-AS1', 'ABR antisense RNA 1', 'non-coding RNA', 'ENSG00000235361'),
(34, 25829, 'ABRAXAS1', 'abraxas 1, BRCA1 A complex subunit', 'protein-coding gene', 'ENSG00000163322'),
(35, 17369, 'ABT1', 'activator of basal transcription 1', 'protein-coding gene', 'ENSG00000146109'),
(36, 55880, 'ACAA2P1', 'ACAA2 pseudogene 1', 'pseudogene', 'ENSG00000233585'),
(37, 21597, 'ACAD10', 'acyl-CoA dehydrogenase family member 10', 'protein-coding gene', 'ENSG00000111271'),
(38, 91, 'ACADSB', 'acyl-CoA dehydrogenase short/branched chain', 'protein-coding gene', 'ENSG00000196177'),
(39, 319, 'ACAN', 'aggrecan', 'protein-coding gene', 'ENSG00000157766'),
(40, 16469, 'ACAP2', 'ArfGAP with coiled-coil, ankyrin repeat and PH domains 2', 'protein-coding gene', 'ENSG00000114331'),
(41, 16754, 'ACAP3', 'ArfGAP with coiled-coil, ankyrin repeat and PH domains 3', 'protein-coding gene', 'ENSG00000131584'),
(42, 94, 'ACAT2', 'acetyl-CoA acetyltransferase 2', 'protein-coding gene', 'ENSG00000120437'),
(43, 15453, 'ACBD3', 'acyl-CoA binding domain containing 3', 'protein-coding gene', 'ENSG00000182827'),
(44, 23675, 'ACER2', 'alkaline ceramidase 2', 'protein-coding gene', 'ENSG00000177076'),
(45, 108, 'ACHE', 'acetylcholinesterase (Cartwright blood group)', 'protein-coding gene', 'ENSG00000087085'),
(46, 34504, 'ACNATP', 'acyl-CoA:amino acid N-acyltransferase pseudogene', 'pseudogene', 'ENSG00000227411'),
(47, 33904, 'ACOD1', 'aconitate decarboxylase 1', 'protein-coding gene', 'ENSG00000102794'),
(48, 33128, 'ACOT1', 'acyl-CoA thioesterase 1', 'protein-coding gene', 'ENSG00000184227'),
(49, 24157, 'ACOT7', 'acyl-CoA thioesterase 7', 'protein-coding gene', 'ENSG00000097021'),
(50, 120, 'ACOX2', 'acyl-CoA oxidase 2', 'protein-coding gene', 'ENSG00000168306'),
(51, 29609, 'ACP6', 'acid phosphatase 6, lysophosphatidic', 'protein-coding gene', 'ENSG00000162836'),
(52, 54745, 'ACRP1', 'ACR pseudogene 1', 'pseudogene', 'ENSG00000175509'),
(53, 3569, 'ACSL1', 'acyl-CoA synthetase long chain family member 1', 'protein-coding gene', 'ENSG00000151726'),
(54, 16526, 'ACSL5', 'acyl-CoA synthetase long chain family member 5', 'protein-coding gene', 'ENSG00000197142'),
(55, 130, 'ACTA2', 'actin alpha 2, smooth muscle', 'protein-coding gene', 'ENSG00000107796'),
(56, 141, 'ACTBP8', 'ACTB pseudogene 8', 'pseudogene', 'ENSG00000220267'),
(57, 55065, 'ACTBP15', 'ACTB pseudogene 15', 'pseudogene', 'ENSG00000213857'),
(58, 51491, 'ACTE1P', 'actin epsilon 1, pseudogene', 'pseudogene', 'ENSG00000172900'),
(59, 37651, 'ACTG1P11', 'actin gamma 1 pseudogene 11', 'pseudogene', 'ENSG00000229465'),
(60, 51501, 'ACTG1P21', 'actin gamma 1 pseudogene 21', 'pseudogene', 'ENSG00000232672'),
(61, 145, 'ACTG2', 'actin gamma 2, smooth muscle', 'protein-coding gene', 'ENSG00000163017'),
(62, 163, 'ACTN1', 'actinin alpha 1', 'protein-coding gene', 'ENSG00000072110'),
(63, 165, 'ACTN3', 'actinin alpha 3', 'protein-coding gene', 'ENSG00000248746'),
(64, 51621, 'ACTP1', 'actin family pseudogene 1', 'pseudogene', 'ENSG00000229890'),
(65, 167, 'ACTR1A', 'actin related protein 1A', 'protein-coding gene', 'ENSG00000138107'),
(66, 37724, 'ACTR3BP1', 'ACTR3B pseudogene 1', 'pseudogene', 'ENSG00000270242'),
(67, 38681, 'ACTR3BP4', 'ACTR3B pseudogene 4', 'pseudogene', 'ENSG00000249283'),
(68, 38682, 'ACTR3BP5', 'ACTR3B pseudogene 5', 'pseudogene', 'ENSG00000227264'),
(69, 173, 'ACVR2A', 'activin A receptor type 2A', 'protein-coding gene', 'ENSG00000121989'),
(70, 186, 'ADA', 'adenosine deaminase', 'protein-coding gene', 'ENSG00000196839'),
(71, 1839, 'ADA2', 'adenosine deaminase 2', 'protein-coding gene', 'ENSG00000093072'),
(72, 210, 'ADAM3B', 'ADAM metallopeptidase domain 3B (pseudogene)', 'pseudogene', 'ENSG00000260089'),
(73, 56153, 'ADAM7-AS2', 'ADAM7 antisense RNA 2', 'non-coding RNA', 'ENSG00000253643'),
(74, 190, 'ADAM12', 'ADAM metallopeptidase domain 12', 'protein-coding gene', 'ENSG00000148848'),
(75, 20102, 'ADAM20P1', 'ADAM metallopeptidase domain 20 pseudogene 1', 'pseudogene', 'ENSG00000259158'),
(76, 43901, 'ADAM20P2', 'ADAM metallopeptidase domain 20 pseudogene 2', 'pseudogene', 'ENSG00000248574'),
(77, 43902, 'ADAM20P3', 'ADAM metallopeptidase domain 20 pseudogene 3', 'pseudogene', 'ENSG00000249162'),
(78, 15479, 'ADAM32', 'ADAM metallopeptidase domain 32', 'protein-coding gene', 'ENSG00000197140'),
(79, 217, 'ADAMTS1', 'ADAM metallopeptidase with thrombospondin type 1 motif 1', 'protein-coding gene', 'ENSG00000154734'),
(80, 222, 'ADAMTS6', 'ADAM metallopeptidase with thrombospondin type 1 motif 6', 'protein-coding gene', 'ENSG00000049192'),
(81, 49409, 'ADAMTS7P3', 'ADAMTS7 pseudogene 3', 'pseudogene', 'ENSG00000261143'),
(82, 224, 'ADAMTS8', 'ADAM metallopeptidase with thrombospondin type 1 motif 8', 'protein-coding gene', 'ENSG00000134917'),
(83, 40625, 'ADAMTS9-AS1', 'ADAMTS9 antisense RNA 1', 'non-coding RNA', 'ENSG00000241158'),
(84, 17109, 'ADAMTS17', 'ADAM metallopeptidase with thrombospondin type 1 motif 17', 'protein-coding gene', 'ENSG00000140470'),
(85, 17110, 'ADAMTS18', 'ADAM metallopeptidase with thrombospondin type 1 motif 18', 'protein-coding gene', 'ENSG00000140873'),
(86, 17111, 'ADAMTS19', 'ADAM metallopeptidase with thrombospondin type 1 motif 19', 'protein-coding gene', 'ENSG00000145808'),
(87, 16487, 'ADAP2', 'ArfGAP with dual PH domains 2', 'protein-coding gene', 'ENSG00000184060'),
(88, 227, 'ADARB2', 'adenosine deaminase RNA specific B2 (inactive)', 'protein-coding gene', 'ENSG00000185736'),
(89, 228, 'ADAT1', 'adenosine deaminase tRNA specific 1', 'protein-coding gene', 'ENSG00000065457'),
(90, 19038, 'ADCK1', 'aarF domain containing kinase 1', 'protein-coding gene', 'ENSG00000063761'),
(91, 233, 'ADCY2', 'adenylate cyclase 2', 'protein-coding gene', 'ENSG00000078295'),
(92, 236, 'ADCY5', 'adenylate cyclase 5', 'protein-coding gene', 'ENSG00000173175'),
(93, 13839, 'ADGRA3', 'adhesion G protein-coupled receptor A3', 'protein-coding gene', 'ENSG00000152990'),
(94, 55918, 'ADGRA3P1', 'ADGRA3 pseudogene 1', 'pseudogene', 'ENSG00000256616'),
(95, 944, 'ADGRB2', 'adhesion G protein-coupled receptor B2', 'protein-coding gene', 'ENSG00000121753'),
(96, 55774, 'ADGRB3-DT', 'ADGRB3 divergent transcript', 'non-coding RNA', 'ENSG00000230910'),
(97, 18992, 'ADGRG4', 'adhesion G protein-coupled receptor G4', 'protein-coding gene', 'ENSG00000156920'),
(98, 19010, 'ADGRG5', 'adhesion G protein-coupled receptor G5', 'protein-coding gene', 'ENSG00000159618'),
(99, 20973, 'ADGRL1', 'adhesion G protein-coupled receptor L1', 'protein-coding gene', 'ENSG00000072071'),
(100, 22991, 'ADH5P3', 'ADH5 pseudogene 3', 'pseudogene', 'ENSG00000223694'),
(101, 255, 'ADH6', 'alcohol dehydrogenase 6 (class V)', 'protein-coding gene', 'ENSG00000172955'),
(102, 52340, 'ADI1P2', 'acireductone dioxygenase 1 pseudogene 2', 'pseudogene', 'ENSG00000250684'),
(103, 44910, 'ADIPOR1P1', 'adiponectin receptor 1 pseudogene 1', 'pseudogene', 'ENSG00000232497'),
(104, 23803, 'ADNP2', 'ADNP homeobox 2', 'protein-coding gene', 'ENSG00000101544'),
(105, 37122, 'ADORA2A-AS1', 'ADORA2A antisense RNA 1', 'non-coding RNA', 'ENSG00000178803'),
(106, 291, 'ADSL', 'adenylosuccinate lyase', 'protein-coding gene', 'ENSG00000239900'),
(107, 21214, 'ADTRP', 'androgen dependent TFPI regulating protein', 'protein-coding gene', 'ENSG00000111863'),
(108, 28141, 'AFAP1-AS1', 'AFAP1 antisense RNA 1', 'non-coding RNA', 'ENSG00000272620'),
(109, 7135, 'AFF1', 'AF4/FMR2 family member 1', 'protein-coding gene', 'ENSG00000172493'),
(110, 3776, 'AFF2', 'AF4/FMR2 family member 2', 'protein-coding gene', 'ENSG00000155966'),
(111, 314, 'AFG3L1P', 'AFG3 like matrix AAA peptidase subunit 1, pseudogene', 'pseudogene', 'ENSG00000223959'),
(112, 316, 'AFM', 'afamin', 'protein-coding gene', 'ENSG00000079557'),
(113, 41427, 'AGAP1-IT1', 'AGAP1 intronic transcript 1', 'non-coding RNA', 'ENSG00000235529'),
(114, 23466, 'AGAP6', 'ArfGAP with GTPase domain, ankyrin repeat and PH domain 6', 'protein-coding gene', 'ENSG00000204149'),
(115, 23661, 'AGAP12P', 'ArfGAP with GTPase domain, ankyrin repeat and PH domain 12, pseudogene', 'pseudogene', 'ENSG00000265018'),
(116, 48617, 'AGBL1-AS1', 'AGBL1 antisense RNA 1', 'non-coding RNA', 'ENSG00000260125'),
(117, 27981, 'AGBL3', 'AGBL carboxypeptidase 3', 'protein-coding gene', 'ENSG00000146856'),
(118, 41482, 'AGBL4-IT1', 'AGBL4 intronic transcript 1', 'non-coding RNA', 'ENSG00000225623'),
(119, 41133, 'AGBL5-AS1', 'AGBL5 antisense RNA 1', 'non-coding RNA', 'ENSG00000231636'),
(120, 38052, 'AGGF1P2', 'angiogenic factor with G-patch and FHA domains 1 pseudogene 2', 'pseudogene', 'ENSG00000233435'),
(121, 21869, 'AGK', 'acylglycerol kinase', 'protein-coding gene', 'ENSG00000006530'),
(122, 37661, 'AGKP1', 'AGK pseudogene 1', 'pseudogene', 'ENSG00000226555'),
(123, 55132, 'AGKP2', 'AGK pseudogene 2', 'pseudogene', 'ENSG00000228819'),
(124, 3262, 'AGO1', 'argonaute RISC component 1', 'protein-coding gene', 'ENSG00000092847'),
(125, 326, 'AGPAT3', '1-acylglycerol-3-phosphate O-acyltransferase 3', 'protein-coding gene', 'ENSG00000160216'),
(126, 328, 'AGR2', 'anterior gradient 2, protein disulphide isomerase family member', 'protein-coding gene', 'ENSG00000106541'),
(127, 338, 'AGTR2', 'angiotensin II receptor type 2', 'protein-coding gene', 'ENSG00000180772'),
(128, 344, 'AHCYL1', 'adenosylhomocysteinase like 1', 'protein-coding gene', 'ENSG00000168710'),
(129, 44995, 'AHCYP3', 'adenosylhomocysteinase pseudogene 3', 'pseudogene', 'ENSG00000233955'),
(130, 348, 'AHR', 'aryl hydrocarbon receptor', 'protein-coding gene', 'ENSG00000106546'),
(131, 20437, 'AHSA2P', 'activator of HSP90 ATPase homolog 2, pseudogene', 'pseudogene', 'ENSG00000173209'),
(132, 18075, 'AHSP', 'alpha hemoglobin stabilizing protein', 'protein-coding gene', 'ENSG00000169877'),
(133, 25761, 'AIDA', 'axin interactor, dorsalization associated', 'protein-coding gene', 'ENSG00000186063'),
(134, 54663, 'AIDAP1', 'AIDA pseudogene 1', 'pseudogene', 'ENSG00000230154'),
(135, 37284, 'AJM1', 'apical junction component 1 homolog', 'protein-coding gene', 'ENSG00000232434'),
(136, 55449, 'AJUBA-DT', 'AJUBA divergent transcript', 'non-coding RNA', 'ENSG00000258457'),
(137, 364, 'AK4P1', 'adenylate kinase 4 pseudogene 1', 'pseudogene', 'ENSG00000263535'),
(138, 39067, 'AK4P4', 'adenylate kinase 4 pseudogene 4', 'pseudogene', 'ENSG00000223621'),
(139, 33814, 'AK9', 'adenylate kinase 9', 'protein-coding gene', 'ENSG00000155085'),
(140, 367, 'AKAP1', 'A-kinase anchoring protein 1', 'protein-coding gene', 'ENSG00000121057'),
(141, 374, 'AKAP4', 'A-kinase anchoring protein 4', 'protein-coding gene', 'ENSG00000147081'),
(142, 1170, 'AKIP1', 'A-kinase interacting protein 1', 'protein-coding gene', 'ENSG00000166452'),
(143, 28398, 'AKNAD1', 'AKNA domain containing 1', 'protein-coding gene', 'ENSG00000162641'),
(144, 425, 'AKR1B1P2', 'aldo-keto reductase family 1 member B1 pseudogene 2', 'pseudogene', 'ENSG00000213452'),
(145, 385, 'AKR1C2', 'aldo-keto reductase family 1 member C2', 'protein-coding gene', 'ENSG00000151632'),
(146, 44679, 'AKR1C5P', 'aldo-keto reductase family 1 member C5, pseudogene', 'pseudogene', 'ENSG00000225418'),
(147, 388, 'AKR1D1', 'aldo-keto reductase family 1 member D1', 'protein-coding gene', 'ENSG00000122787'),
(148, 11288, 'AKR1D1P1', 'aldo-keto reductase family 1 member D1 pseudogene 1', 'pseudogene', 'ENSG00000227776'),
(149, 24062, 'AKR7A2P1', 'AKR7A2 pseudogene 1', 'pseudogene', 'ENSG00000229020'),
(150, 28426, 'AKT1S1', 'AKT1 substrate 1', 'protein-coding gene', 'ENSG00000204673'),
(151, 397, 'ALAS2', '5\'-aminolevulinate synthase 2', 'protein-coding gene', 'ENSG00000158578'),
(152, 27515, 'ALDH1A2-AS1', 'ALDH1A2 antisense RNA 1', 'non-coding RNA', 'ENSG00000259285'),
(153, 55416, 'ALDH1A3-AS1', 'ALDH1A3 antisense RNA 1', 'non-coding RNA', 'ENSG00000259583'),
(154, 3978, 'ALDH1L1', 'aldehyde dehydrogenase 1 family member L1', 'protein-coding gene', 'ENSG00000144908'),
(155, 879, 'ALDH7A1P2', 'aldehyde dehydrogenase 7 family member A1 pseudogene 2', 'pseudogene', 'ENSG00000232292'),
(156, 880, 'ALDH7A1P3', 'aldehyde dehydrogenase 7 family member A1 pseudogene 3', 'pseudogene', 'ENSG00000243853'),
(157, 37258, 'ALG1L2', 'ALG1 chitobiosyldiphosphodolichol beta-mannosyltransferase like 2', 'protein-coding gene', 'ENSG00000251287'),
(158, 44372, 'ALG1L3P', 'ALG1 like 3, pseudogene', 'pseudogene', 'ENSG00000251087'),
(159, 44383, 'ALG1L14P', 'ALG1 like 14, pseudogene', 'pseudogene', 'ENSG00000250268'),
(160, 23056, 'ALG3', 'ALG3 alpha-1,3- mannosyltransferase', 'protein-coding gene', 'ENSG00000214160'),
(161, 45159, 'ALG3P1', 'ALG3 pseudogene 1', 'pseudogene', 'ENSG00000251568'),
(162, 20266, 'ALG5', 'ALG5 dolichyl-phosphate beta-glucosyltransferase', 'protein-coding gene', 'ENSG00000120697'),
(163, 23161, 'ALG8', 'ALG8 alpha-1,3-glucosyltransferase', 'protein-coding gene', 'ENSG00000159063'),
(164, 19358, 'ALG12', 'ALG12 alpha-1,6-mannosyltransferase', 'protein-coding gene', 'ENSG00000182858'),
(165, 32487, 'ALKBH2', 'alkB homolog 2, alpha-ketoglutarate dependent dioxygenase', 'protein-coding gene', 'ENSG00000189046'),
(166, 28243, 'ALKBH6', 'alkB homolog 6', 'protein-coding gene', 'ENSG00000239382'),
(167, 25189, 'ALKBH8', 'alkB homolog 8, tRNA methyltransferase', 'protein-coding gene', 'ENSG00000137760'),
(168, 428, 'ALMS1', 'ALMS1 centrosome and basal body associated protein', 'protein-coding gene', 'ENSG00000116127'),
(169, 429, 'ALOX12', 'arachidonate 12-lipoxygenase, 12S type', 'protein-coding gene', 'ENSG00000108839'),
(170, 51342, 'ALOX12-AS1', 'ALOX12 antisense RNA 1', 'non-coding RNA', 'ENSG00000215067'),
(171, 431, 'ALOX12P1', 'arachidonate 12-lipoxygenase pseudogene 1', 'pseudogene', 'ENSG00000264958'),
(172, 433, 'ALOX15', 'arachidonate 15-lipoxygenase', 'protein-coding gene', 'ENSG00000161905'),
(173, 434, 'ALOX15B', 'arachidonate 15-lipoxygenase type B', 'protein-coding gene', 'ENSG00000179593'),
(174, 441, 'ALPG', 'alkaline phosphatase, germ cell', 'protein-coding gene', 'ENSG00000163286'),
(175, 17574, 'ALPK3', 'alpha kinase 3', 'protein-coding gene', 'ENSG00000136383'),
(176, 443, 'ALS2', 'alsin Rho guanine nucleotide exchange factor ALS2', 'protein-coding gene', 'ENSG00000003393'),
(177, 44898, 'AMD1P1', 'adenosylmethionine decarboxylase 1 pseudogene 1', 'pseudogene', 'ENSG00000228339'),
(178, 28577, 'AMDHD1', 'amidohydrolase domain containing 1', 'protein-coding gene', 'ENSG00000139344'),
(179, 26771, 'AMER3', 'APC membrane recruitment protein 3', 'protein-coding gene', 'ENSG00000178171'),
(180, 27281, 'AMN1', 'antagonist of mitotic exit network 1 homolog', 'protein-coding gene', 'ENSG00000151743'),
(181, 470, 'AMPD3', 'adenosine monophosphate deaminase 3', 'protein-coding gene', 'ENSG00000133805'),
(182, 473, 'AMT', 'aminomethyltransferase', 'protein-coding gene', 'ENSG00000145020'),
(183, 33188, 'AMTN', 'amelotin', 'protein-coding gene', 'ENSG00000187689'),
(184, 474, 'AMY1A', 'amylase alpha 1A', 'protein-coding gene', 'ENSG00000237763'),
(185, 38072, 'AMZ2P2', 'AMZ2 pseudogene 2', 'pseudogene', 'ENSG00000219249'),
(186, 54708, 'ANAPC1P2', 'ANAPC1 pseudogene 2', 'pseudogene', 'ENSG00000231259'),
(187, 54711, 'ANAPC1P5', 'ANAPC1 pseudogene 5', 'pseudogene', 'ENSG00000275597'),
(188, 15713, 'ANAPC5', 'anaphase promoting complex subunit 5', 'protein-coding gene', 'ENSG00000089053'),
(189, 487, 'ANGPT4', 'angiopoietin 4', 'protein-coding gene', 'ENSG00000101280'),
(190, 490, 'ANGPTL2', 'angiopoietin like 2', 'protein-coding gene', 'ENSG00000136859'),
(191, 491, 'ANGPTL3', 'angiopoietin like 3', 'protein-coding gene', 'ENSG00000132855'),
(192, 24078, 'ANGPTL7', 'angiopoietin like 7', 'protein-coding gene', 'ENSG00000171819'),
(193, 493, 'ANK2', 'ankyrin 2', 'protein-coding gene', 'ENSG00000145362'),
(194, 26350, 'ANKAR', 'ankyrin and armadillo repeat containing', 'protein-coding gene', 'ENSG00000151687'),
(195, 28002, 'ANKDD1A', 'ankyrin repeat and death domain containing 1A', 'protein-coding gene', 'ENSG00000166839'),
(196, 32525, 'ANKDD1B', 'ankyrin repeat and death domain containing 1B', 'protein-coding gene', 'ENSG00000189045'),
(197, 15803, 'ANKEF1', 'ankyrin repeat and EF-hand domain containing 1', 'protein-coding gene', 'ENSG00000132623'),
(198, 55234, 'ANKH-DT', 'ANKH divergent transcript', 'non-coding RNA', 'ENSG00000272057'),
(199, 26812, 'ANKLE1', 'ankyrin repeat and LEM domain containing 1', 'protein-coding gene', 'ENSG00000160117'),
(200, 29101, 'ANKLE2', 'ankyrin repeat and LEM domain containing 2', 'protein-coding gene', 'ENSG00000176915'),
(201, 20987, 'ANKMY1', 'ankyrin repeat and MYND domain containing 1', 'protein-coding gene', 'ENSG00000144504'),
(202, 25370, 'ANKMY2', 'ankyrin repeat and MYND domain containing 2', 'protein-coding gene', 'ENSG00000106524'),
(203, 17280, 'ANKRD6', 'ankyrin repeat domain 6', 'protein-coding gene', 'ENSG00000135299'),
(204, 20265, 'ANKRD10', 'ankyrin repeat domain 10', 'protein-coding gene', 'ENSG00000088448'),
(205, 54737, 'ANKRD11P1', 'ANKRD11 pseudogene 1', 'pseudogene', 'ENSG00000234429'),
(206, 23471, 'ANKRD16', 'ankyrin repeat domain 16', 'protein-coding gene', 'ENSG00000134461'),
(207, 55556, 'ANKRD17-DT', 'ANKRD17 divergent transcript', 'non-coding RNA', 'ENSG00000250220'),
(208, 23643, 'ANKRD18A', 'ankyrin repeat domain 18A', 'protein-coding gene', 'ENSG00000180071'),
(209, 43601, 'ANKRD18CP', 'ankyrin repeat domain 18C, pseudogene', 'pseudogene', 'ENSG00000159712'),
(210, 22567, 'ANKRD19P', 'ankyrin repeat domain 19, pseudogene', 'pseudogene', 'ENSG00000187984'),
(211, 23665, 'ANKRD20A1', 'ankyrin repeat domain 20 family member A1', 'protein-coding gene', 'ENSG00000260691'),
(212, 31980, 'ANKRD20A7P', 'ankyrin repeat domain 20 family member A7, pseudogene', 'pseudogene', 'ENSG00000236816'),
(213, 23666, 'ANKRD20A8P', 'ankyrin repeat domain 20 family member A8, pseudogene', 'pseudogene', 'ENSG00000229089'),
(214, 42023, 'ANKRD20A9P', 'ankyrin repeat domain 20 family member A9, pseudogene', 'pseudogene', 'ENSG00000206192'),
(215, 43608, 'ANKRD20A17P', 'ankyrin repeat domain 20 family member A17, pseudogene', 'pseudogene', 'ENSG00000251056'),
(216, 29424, 'ANKRD24', 'ankyrin repeat domain 24', 'protein-coding gene', 'ENSG00000089847'),
(217, 39690, 'ANKRD26P4', 'ankyrin repeat domain 26 pseudogene 4', 'pseudogene', 'ENSG00000229427'),
(218, 24165, 'ANKRD30B', 'ankyrin repeat domain 30B', 'protein-coding gene', 'ENSG00000180777'),
(219, 27873, 'ANKRD30BP3', 'ankyrin repeat domain 30B pseudogene 3', 'pseudogene', 'ENSG00000230501'),
(220, 13788, 'ANKRD33', 'ankyrin repeat domain 33', 'protein-coding gene', 'ENSG00000167612'),
(221, 35240, 'ANKRD33B', 'ankyrin repeat domain 33B', 'protein-coding gene', 'ENSG00000164236'),
(222, 27639, 'ANKRD34A', 'ankyrin repeat domain 34A', 'protein-coding gene', 'ENSG00000272031'),
(223, 33736, 'ANKRD34B', 'ankyrin repeat domain 34B', 'protein-coding gene', 'ENSG00000189127'),
(224, 33888, 'ANKRD34C', 'ankyrin repeat domain 34C', 'protein-coding gene', 'ENSG00000235711'),
(225, 32946, 'ANKRD36C', 'ankyrin repeat domain 36C', 'protein-coding gene', 'ENSG00000174501'),
(226, 29593, 'ANKRD37', 'ankyrin repeat domain 37', 'protein-coding gene', 'ENSG00000186352'),
(227, 41477, 'ANKRD44-IT1', 'ANKRD44 intronic transcript 1', 'non-coding RNA', 'ENSG00000236977'),
(228, 27229, 'ANKRD46', 'ankyrin repeat domain 46', 'protein-coding gene', 'ENSG00000186106'),
(229, 29223, 'ANKRD50', 'ankyrin repeat domain containing 50', 'protein-coding gene', 'ENSG00000151458'),
(230, 25691, 'ANKRD53', 'ankyrin repeat domain 53', 'protein-coding gene', 'ENSG00000144031'),
(231, 22467, 'ANKRD61', 'ankyrin repeat domain 61', 'protein-coding gene', 'ENSG00000157999'),
(232, 29642, 'ANKUB1', 'ankyrin repeat and ubiquitin domain containing 1', 'protein-coding gene', 'ENSG00000206199'),
(233, 54190, 'ANO3-AS1', 'ANO3 antisense RNA 1', 'non-coding RNA', 'ENSG00000254819'),
(234, 31677, 'ANO7', 'anoctamin 7', 'protein-coding gene', 'ENSG00000146205'),
(235, 29329, 'ANO8', 'anoctamin 8', 'protein-coding gene', 'ENSG00000074855'),
(236, 25519, 'ANO10', 'anoctamin 10', 'protein-coding gene', 'ENSG00000160746'),
(237, 27277, 'ANTXRL', 'ANTXR like', 'protein-coding gene', 'ENSG00000274209'),
(238, 533, 'ANXA1', 'annexin A1', 'protein-coding gene', 'ENSG00000135046'),
(239, 537, 'ANXA2', 'annexin A2', 'protein-coding gene', 'ENSG00000182718'),
(240, 543, 'ANXA5', 'annexin A5', 'protein-coding gene', 'ENSG00000164111'),
(241, 545, 'ANXA7', 'annexin A7', 'protein-coding gene', 'ENSG00000138279'),
(242, 546, 'ANXA8', 'annexin A8', 'protein-coding gene', 'ENSG00000265190'),
(243, 534, 'ANXA10', 'annexin A10', 'protein-coding gene', 'ENSG00000109511'),
(244, 548, 'AOAH', 'acyloxyacyl hydrolase', 'protein-coding gene', 'ENSG00000136250'),
(245, 550, 'AOC3', 'amine oxidase copper containing 3', 'protein-coding gene', 'ENSG00000131471'),
(246, 19049, 'AOX3P', 'aldehyde oxidase 3, pseudogene', 'pseudogene', 'ENSG00000244301'),
(247, 28808, 'AP1AR', 'adaptor related protein complex 1 associated regulatory protein', 'protein-coding gene', 'ENSG00000138660'),
(248, 54978, 'AP1M2P1', 'AP1M2 pseudogene 1', 'pseudogene', 'ENSG00000227534'),
(249, 18971, 'AP1S3', 'adaptor related protein complex 1 subunit sigma 3', 'protein-coding gene', 'ENSG00000152056'),
(250, 55017, 'AP2B1P1', 'AP2B1 pseudogene 1', 'pseudogene', 'ENSG00000234130'),
(251, 566, 'AP3B1', 'adaptor related protein complex 3 subunit beta 1', 'protein-coding gene', 'ENSG00000132842'),
(252, 568, 'AP3D1', 'adaptor related protein complex 3 subunit delta 1', 'protein-coding gene', 'ENSG00000065000'),
(253, 569, 'AP3M1', 'adaptor related protein complex 3 subunit mu 1', 'protein-coding gene', 'ENSG00000185009'),
(254, 570, 'AP3M2', 'adaptor related protein complex 3 subunit mu 2', 'protein-coding gene', 'ENSG00000070718'),
(255, 574, 'AP4M1', 'adaptor related protein complex 4 subunit mu 1', 'protein-coding gene', 'ENSG00000221838'),
(256, 575, 'AP4S1', 'adaptor related protein complex 4 subunit sigma 1', 'protein-coding gene', 'ENSG00000100478'),
(257, 25104, 'AP5B1', 'adaptor related protein complex 5 subunit beta 1', 'protein-coding gene', 'ENSG00000254470'),
(258, 15875, 'AP5S1', 'adaptor related protein complex 5 subunit sigma 1', 'protein-coding gene', 'ENSG00000125843'),
(259, 22197, 'AP5Z1', 'adaptor related protein complex 5 subunit zeta 1', 'protein-coding gene', 'ENSG00000242802'),
(260, 48925, 'APELA', 'apelin receptor early endogenous ligand', 'protein-coding gene', 'ENSG00000248329'),
(261, 594, 'API5', 'apoptosis inhibitor 5', 'protein-coding gene', 'ENSG00000166181'),
(262, 605, 'APOBEC2', 'apolipoprotein B mRNA editing enzyme catalytic subunit 2', 'protein-coding gene', 'ENSG00000124701'),
(263, 43836, 'APOBEC3B-AS1', 'APOBEC3B antisense RNA 1', 'non-coding RNA', 'ENSG00000249310'),
(264, 44426, 'APOC4-APOC2', 'APOC4-APOC2 readthrough (NMD candidate)', 'other', 'ENSG00000224916'),
(265, 612, 'APOD', 'apolipoprotein D', 'protein-coding gene', 'ENSG00000189058'),
(266, 613, 'APOE', 'apolipoprotein E', 'protein-coding gene', 'ENSG00000130203'),
(267, 616, 'APOH', 'apolipoprotein H', 'protein-coding gene', 'ENSG00000091583'),
(268, 14867, 'APOL4', 'apolipoprotein L4', 'protein-coding gene', 'ENSG00000100336'),
(269, 14869, 'APOL5', 'apolipoprotein L5', 'protein-coding gene', 'ENSG00000128313'),
(270, 53942, 'APONP', 'apolipoprotein N, pseudogene', 'pseudogene', 'ENSG00000274823'),
(271, 48740, 'APOOP2', 'apolipoprotein O pseudogene 2', 'pseudogene', 'ENSG00000240902'),
(272, 55423, 'APPBP2-DT', 'APPBP2 divergent transcript', 'non-coding RNA', 'ENSG00000259349'),
(273, 18242, 'APPL2', 'adaptor protein, phosphotyrosine interacting with PH domain and leucine zipper 2', 'protein-coding gene', 'ENSG00000136044'),
(274, 634, 'AQP2', 'aquaporin 2', 'protein-coding gene', 'ENSG00000167580'),
(275, 636, 'AQP3', 'aquaporin 3 (Gill blood group)', 'protein-coding gene', 'ENSG00000165272'),
(276, 637, 'AQP4', 'aquaporin 4', 'protein-coding gene', 'ENSG00000171885'),
(277, 32048, 'AQP7P1', 'aquaporin 7 pseudogene 1', 'pseudogene', 'ENSG00000186466'),
(278, 19940, 'AQP11', 'aquaporin 11', 'protein-coding gene', 'ENSG00000178301'),
(279, 19941, 'AQP12A', 'aquaporin 12A', 'protein-coding gene', 'ENSG00000184945'),
(280, 29513, 'AQR', 'aquarius intron-binding spliceosomal factor', 'protein-coding gene', 'ENSG00000021776'),
(281, 39993, 'ARAP1-AS1', 'ARAP1 antisense RNA 1', 'non-coding RNA', 'ENSG00000256007'),
(282, 15852, 'ARFGAP1', 'ADP ribosylation factor GTPase activating protein 1', 'protein-coding gene', 'ENSG00000101199'),
(283, 15853, 'ARFGEF2', 'ADP ribosylation factor guanine nucleotide exchange factor 2', 'protein-coding gene', 'ENSG00000124198'),
(284, 21496, 'ARFIP1', 'ADP ribosylation factor interacting protein 1', 'protein-coding gene', 'ENSG00000164144'),
(285, 23977, 'ARGFXP2', 'arginine-fifty homeobox pseudogene 2', 'pseudogene', 'ENSG00000265293'),
(286, 676, 'ARHGAP6', 'Rho GTPase activating protein 6', 'protein-coding gene', 'ENSG00000047648'),
(287, 15782, 'ARHGAP11B', 'Rho GTPase activating protein 11B', 'protein-coding gene', 'ENSG00000285077'),
(288, 21030, 'ARHGAP15', 'Rho GTPase activating protein 15', 'protein-coding gene', 'ENSG00000075884'),
(289, 18357, 'ARHGAP20', 'Rho GTPase activating protein 20', 'protein-coding gene', 'ENSG00000137727'),
(290, 42944, 'ARHGAP22-IT1', 'ARHGAP22 intronic transcript 1', 'non-coding RNA', 'ENSG00000248682'),
(291, 31813, 'ARHGAP27', 'Rho GTPase activating protein 27', 'protein-coding gene', 'ENSG00000159314'),
(292, 30207, 'ARHGAP29', 'Rho GTPase activating protein 29', 'protein-coding gene', 'ENSG00000137962'),
(293, 26388, 'ARHGAP36', 'Rho GTPase activating protein 36', 'protein-coding gene', 'ENSG00000147256'),
(294, 29351, 'ARHGAP39', 'Rho GTPase activating protein 39', 'protein-coding gene', 'ENSG00000147799'),
(295, 43941, 'ARHGAP42P4', 'ARHGAP42 pseudogene 4', 'pseudogene', 'ENSG00000258080'),
(296, 13209, 'ARHGEF5', 'Rho guanine nucleotide exchange factor 5', 'protein-coding gene', 'ENSG00000050327'),
(297, 41408, 'ARHGEF7-IT1', 'ARHGEF7 intronic transcript 1', 'non-coding RNA', 'ENSG00000233644'),
(298, 14561, 'ARHGEF9', 'Cdc42 guanine nucleotide exchange factor 9', 'protein-coding gene', 'ENSG00000131089'),
(299, 14193, 'ARHGEF12', 'Rho guanine nucleotide exchange factor 12', 'protein-coding gene', 'ENSG00000196914'),
(300, 26604, 'ARHGEF19', 'Rho guanine nucleotide exchange factor 19', 'protein-coding gene', 'ENSG00000142632'),
(301, 41292, 'ARHGEF35-AS1', 'ARHGEF35 antisense RNA 1', 'non-coding RNA', 'ENSG00000244198'),
(302, 3031, 'ARID3A', 'AT-rich interaction domain 3A', 'protein-coding gene', 'ENSG00000116017'),
(303, 54553, 'ARID3BP1', 'ARID3B pseudogene 1', 'pseudogene', 'ENSG00000227288'),
(304, 15550, 'ARID4B', 'AT-rich interaction domain 4B', 'protein-coding gene', 'ENSG00000054267'),
(305, 34425, 'ARIH2OS', 'ARIH2 opposite strand lncRNA', 'non-coding RNA', 'ENSG00000221883'),
(306, 692, 'ARL1', 'ADP ribosylation factor like GTPase 1', 'protein-coding gene', 'ENSG00000120805'),
(307, 17146, 'ARL2BP', 'ADP ribosylation factor like GTPase 2 binding protein', 'protein-coding gene', 'ENSG00000102931'),
(308, 39449, 'ARL2BPP5', 'ADP ribosylation factor like GTPase 2 binding protein pseudogene 5', 'pseudogene', 'ENSG00000254351'),
(309, 39450, 'ARL2BPP6', 'ADP ribosylation factor like GTPase 2 binding protein pseudogene 6', 'pseudogene', 'ENSG00000248355'),
(310, 39454, 'ARL2BPP10', 'ADP ribosylation factor like GTPase 2 binding protein pseudogene 10', 'pseudogene', 'ENSG00000225225'),
(311, 32379, 'ARL4AP2', 'ADP ribosylation factor like GTPase 4A pseudogene 2', 'pseudogene', 'ENSG00000248780'),
(312, 31111, 'ARL5C', 'ADP ribosylation factor like GTPase 5C', 'protein-coding gene', 'ENSG00000141748'),
(313, 44971, 'ARL6IP1P2', 'ADP ribosylation factor like GTPase 6 interacting protein 1 pseudogene 2', 'pseudogene', 'ENSG00000225355'),
(314, 44972, 'ARL6IP1P3', 'ADP ribosylation factor like GTPase 6 interacting protein 1 pseudogene 3', 'pseudogene', 'ENSG00000255014'),
(315, 22042, 'ARL10', 'ADP ribosylation factor like GTPase 10', 'protein-coding gene', 'ENSG00000175414'),
(316, 25419, 'ARL13B', 'ADP ribosylation factor like GTPase 13B', 'protein-coding gene', 'ENSG00000169379'),
(317, 54676, 'ARL14EPP1', 'ARL14EP pseudogene 1', 'pseudogene', 'ENSG00000224891'),
(318, 23045, 'ARMC2', 'armadillo repeat containing 2', 'protein-coding gene', 'ENSG00000118690'),
(319, 26168, 'ARMC7', 'armadillo repeat containing 7', 'protein-coding gene', 'ENSG00000125449'),
(320, 41038, 'ARMCX3-AS1', 'ARMCX3 antisense RNA 1', 'non-coding RNA', 'ENSG00000228275'),
(321, 25788, 'ARMH3', 'armadillo like helical domain containing 3', 'protein-coding gene', 'ENSG00000120029'),
(322, 32685, 'ARMS2', 'age-related maculopathy susceptibility 2', 'protein-coding gene', 'ENSG00000254636'),
(323, 17872, 'ARMT1', 'acidic residue methyltransferase 1', 'protein-coding gene', 'ENSG00000146476'),
(324, 700, 'ARNT', 'aryl hydrocarbon receptor nuclear translocator', 'protein-coding gene', 'ENSG00000143437'),
(325, 56077, 'ARNT2-DT', 'ARNT2 divergent transcript', 'non-coding RNA', 'ENSG00000259495'),
(326, 16092, 'ARPC3P1', 'actin related protein 2/3 complex subunit 3 pseudogene 1', 'pseudogene', 'ENSG00000226284'),
(327, 39432, 'ARPC3P3', 'actin related protein 2/3 complex subunit 3 pseudogene 3', 'pseudogene', 'ENSG00000256745'),
(328, 38830, 'ARPC4-TTLL3', 'ARPC4-TTLL3 readthrough', 'other', 'ENSG00000250151'),
(329, 28782, 'ARPIN', 'actin related protein 2/3 complex inhibitor', 'protein-coding gene', 'ENSG00000242498'),
(330, 38824, 'ARPIN-AP3S2', 'ARPIN-AP3S2 readthrough', 'other', 'ENSG00000250021'),
(331, 710, 'ARR3', 'arrestin 3', 'protein-coding gene', 'ENSG00000120500'),
(332, 712, 'ARRB2', 'arrestin beta 2', 'protein-coding gene', 'ENSG00000141480'),
(333, 721, 'ARSF', 'arylsulfatase F', 'protein-coding gene', 'ENSG00000062096'),
(334, 722, 'ARSFP1', 'arylsulfatase F pseudogene 1', 'pseudogene', 'ENSG00000232226'),
(335, 24102, 'ARSG', 'arylsulfatase G', 'protein-coding gene', 'ENSG00000141337'),
(336, 724, 'ART2P', 'ADP-ribosyltransferase 2, pseudogene', 'pseudogene', 'ENSG00000238048'),
(337, 24049, 'ART5', 'ADP-ribosyltransferase 5', 'protein-coding gene', 'ENSG00000167311'),
(338, 29561, 'ARV1', 'ARV1 homolog, fatty acid homeostasis modulator', 'protein-coding gene', 'ENSG00000173409'),
(339, 735, 'ASAH1', 'N-acylsphingosine amidohydrolase 1', 'protein-coding gene', 'ENSG00000104763'),
(340, 18860, 'ASAH2', 'N-acylsphingosine amidohydrolase 2', 'protein-coding gene', 'ENSG00000188611'),
(341, 23456, 'ASAH2B', 'N-acylsphingosine amidohydrolase 2B', 'protein-coding gene', 'ENSG00000204147'),
(342, 17184, 'ASB9', 'ankyrin repeat and SOCS box containing 9', 'protein-coding gene', 'ENSG00000102048'),
(343, 20972, 'ASB9P1', 'ankyrin repeat and SOCS box containing 9 pseudogene 1', 'pseudogene', 'ENSG00000258527'),
(344, 19766, 'ASB14', 'ankyrin repeat and SOCS box containing 14', 'protein-coding gene', 'ENSG00000239388'),
(345, 19767, 'ASB15', 'ankyrin repeat and SOCS box containing 15', 'protein-coding gene', 'ENSG00000146809'),
(346, 24103, 'ASCC2', 'activating signal cointegrator 1 complex subunit 2', 'protein-coding gene', 'ENSG00000100325'),
(347, 739, 'ASCL2', 'achaete-scute family bHLH transcription factor 2', 'protein-coding gene', 'ENSG00000183734'),
(348, 33169, 'ASCL5', 'achaete-scute family bHLH transcription factor 5', 'protein-coding gene', 'ENSG00000232237'),
(349, 744, 'ASH2L', 'ASH2 like, histone lysine methyltransferase complex subunit', 'protein-coding gene', 'ENSG00000129691'),
(350, 19332, 'ASH2LP1', 'ASH2L pseudogene 1', 'pseudogene', 'ENSG00000224144'),
(351, 53059, 'ASH2LP2', 'ASH2L pseudogene 2', 'pseudogene', 'ENSG00000237428'),
(352, 53060, 'ASH2LP3', 'ASH2L pseudogene 3', 'pseudogene', 'ENSG00000225724'),
(353, 101, 'ASIC3', 'acid sensing ion channel subunit 3', 'protein-coding gene', 'ENSG00000213199'),
(354, 21263, 'ASIC4', 'acid sensing ion channel subunit family member 4', 'protein-coding gene', 'ENSG00000072182'),
(355, 40960, 'ASIC4-AS1', 'ASIC4 antisense RNA 1', 'non-coding RNA', 'ENSG00000227432'),
(356, 751, 'ASMTL', 'acetylserotonin O-methyltransferase like', 'protein-coding gene', 'ENSG00000169093'),
(357, 39399, 'ASNSP3', 'ASNS pseudogene 3', 'pseudogene', 'ENSG00000236554'),
(358, 39400, 'ASNSP4', 'ASNS pseudogene 4', 'pseudogene', 'ENSG00000251470'),
(359, 14872, 'ASPN', 'asporin', 'protein-coding gene', 'ENSG00000106819'),
(360, 26321, 'ASPRV1', 'aspartic peptidase retroviral like 1', 'protein-coding gene', 'ENSG00000244617'),
(361, 13825, 'ASPSCR1', 'ASPSCR1 tether for SLC2A4, UBX domain containing', 'protein-coding gene', 'ENSG00000169696'),
(362, 759, 'ASS1P1', 'argininosuccinate synthetase 1 pseudogene 1', 'pseudogene', 'ENSG00000220517'),
(363, 765, 'ASS1P2', 'argininosuccinate synthetase 1 pseudogene 2', 'pseudogene', 'ENSG00000223922'),
(364, 766, 'ASS1P3', 'argininosuccinate synthetase 1 pseudogene 3', 'pseudogene', 'ENSG00000233947'),
(365, 767, 'ASS1P4', 'argininosuccinate synthetase 1 pseudogene 4', 'pseudogene', 'ENSG00000213487'),
(366, 762, 'ASS1P12', 'argininosuccinate synthetase 1 pseudogene 12', 'pseudogene', 'ENSG00000237437'),
(367, 764, 'ASS1P14', 'argininosuccinate synthetase 1 pseudogene 14', 'pseudogene', 'ENSG00000257316'),
(368, 31704, 'ASTL', 'astacin like metalloendopeptidase', 'protein-coding gene', 'ENSG00000188886'),
(369, 29357, 'ASXL3', 'ASXL transcriptional regulator 3', 'protein-coding gene', 'ENSG00000141431'),
(370, 25903, 'ATAD1', 'ATPase family AAA domain containing 1', 'protein-coding gene', 'ENSG00000138138'),
(371, 29230, 'ATAD2B', 'ATPase family AAA domain containing 2B', 'protein-coding gene', 'ENSG00000119778'),
(372, 782, 'ATE1', 'arginyltransferase 1', 'protein-coding gene', 'ENSG00000107669'),
(373, 788, 'ATF4P3', 'activating transcription factor 4 pseudogene 3', 'pseudogene', 'ENSG00000228218'),
(374, 787, 'ATF4P4', 'activating transcription factor 4 pseudogene 4', 'pseudogene', 'ENSG00000256167'),
(375, 20790, 'ATG4B', 'autophagy related 4B cysteine peptidase', 'protein-coding gene', 'ENSG00000168397'),
(376, 38605, 'ATG12P2', 'autophagy related 12 pseudogene 2', 'pseudogene', 'ENSG00000224121'),
(377, 29091, 'ATG13', 'autophagy related 13', 'protein-coding gene', 'ENSG00000175224'),
(378, 24047, 'ATL2', 'atlastin GTPase 2', 'protein-coding gene', 'ENSG00000119787'),
(379, 24526, 'ATL3', 'atlastin GTPase 3', 'protein-coding gene', 'ENSG00000184743'),
(380, 3033, 'ATN1', 'atrophin 1', 'protein-coding gene', 'ENSG00000111676'),
(381, 24126, 'ATOH8', 'atonal bHLH transcription factor 8', 'protein-coding gene', 'ENSG00000168874'),
(382, 799, 'ATP1A1', 'ATPase Na+/K+ transporting subunit alpha 1', 'protein-coding gene', 'ENSG00000163399'),
(383, 800, 'ATP1A2', 'ATPase Na+/K+ transporting subunit alpha 2', 'protein-coding gene', 'ENSG00000018625'),
(384, 801, 'ATP1A3', 'ATPase Na+/K+ transporting subunit alpha 3', 'protein-coding gene', 'ENSG00000105409'),
(385, 814, 'ATP2B1', 'ATPase plasma membrane Ca2+ transporting 1', 'protein-coding gene', 'ENSG00000070961'),
(386, 816, 'ATP2B3', 'ATPase plasma membrane Ca2+ transporting 3', 'protein-coding gene', 'ENSG00000067842'),
(387, 817, 'ATP2B4', 'ATPase plasma membrane Ca2+ transporting 4', 'protein-coding gene', 'ENSG00000058668'),
(388, 13211, 'ATP2C1', 'ATPase secretory pathway Ca2+ transporting 1', 'protein-coding gene', 'ENSG00000017260'),
(389, 29103, 'ATP2C2', 'ATPase secretory pathway Ca2+ transporting 2', 'protein-coding gene', 'ENSG00000064270'),
(390, 37665, 'ATP5F1AP7', 'ATP synthase F1 subunit alpha pseudogene 7', 'pseudogene', 'ENSG00000241571'),
(391, 37668, 'ATP5F1AP10', 'ATP synthase F1 subunit alpha pseudogene 10', 'pseudogene', 'ENSG00000277297'),
(392, 833, 'ATP5F1C', 'ATP synthase F1 subunit gamma', 'protein-coding gene', 'ENSG00000165629'),
(393, 837, 'ATP5F1D', 'ATP synthase F1 subunit delta', 'protein-coding gene', 'ENSG00000099624'),
(394, 39506, 'ATP5MC1P3', 'ATP synthase membrane subunit c locus 1 pseudogene 3', 'pseudogene', 'ENSG00000242244'),
(395, 39508, 'ATP5MC1P5', 'ATP synthase membrane subunit c locus 1 pseudogene 5', 'pseudogene', 'ENSG00000227590'),
(396, 39509, 'ATP5MC1P6', 'ATP synthase membrane subunit c locus 1 pseudogene 6', 'pseudogene', 'ENSG00000214318'),
(397, 844, 'ATP5MC2P1', 'ATP synthase membrane subunit c locus 2 pseudogene 1', 'pseudogene', 'ENSG00000225712'),
(398, 19672, 'ATP5MC2P2', 'ATP synthase membrane subunit c locus 2 pseudogene 2', 'pseudogene', 'ENSG00000258401'),
(399, 13216, 'ATP5MGP3', 'ATP synthase membrane subunit g pseudogene 3', 'pseudogene', 'ENSG00000249256'),
(400, 38167, 'ATP5MGP5', 'ATP synthase membrane subunit g pseudogene 5', 'pseudogene', 'ENSG00000242561'),
(401, 38170, 'ATP5MGP8', 'ATP synthase membrane subunit g pseudogene 8', 'pseudogene', 'ENSG00000271332'),
(402, 1188, 'ATP5MJ', 'ATP synthase membrane subunit j', 'protein-coding gene', 'ENSG00000156411'),
(403, 840, 'ATP5PB', 'ATP synthase peripheral stalk-membrane subunit b', 'protein-coding gene', 'ENSG00000116459'),
(404, 39743, 'ATP5PBP2', 'ATP synthase peripheral stalk-membrane subunit b pseudogene 2', 'pseudogene', 'ENSG00000214342'),
(405, 847, 'ATP5PF', 'ATP synthase peripheral stalk subunit F6', 'protein-coding gene', 'ENSG00000154723'),
(406, 850, 'ATP5PO', 'ATP synthase peripheral stalk subunit OSCP', 'protein-coding gene', 'ENSG00000241837'),
(407, 28091, 'ATP6AP1L', 'ATPase H+ transporting accessory protein 1 like (pseudogene)', 'pseudogene', 'ENSG00000205464'),
(408, 851, 'ATP6V1A', 'ATPase H+ transporting V1 subunit A', 'protein-coding gene', 'ENSG00000114573'),
(409, 853, 'ATP6V1B1', 'ATPase H+ transporting V1 subunit B1', 'protein-coding gene', 'ENSG00000116039'),
(410, 856, 'ATP6V1C1', 'ATPase H+ transporting V1 subunit C1', 'protein-coding gene', 'ENSG00000155097'),
(411, 18264, 'ATP6V1C2', 'ATPase H+ transporting V1 subunit C2', 'protein-coding gene', 'ENSG00000143882'),
(412, 37670, 'ATP6V1G1P3', 'ATPase H+ transporting V1 subunit G1 pseudogene 3', 'pseudogene', 'ENSG00000224662'),
(413, 37671, 'ATP6V1G1P4', 'ATPase H+ transporting V1 subunit G1 pseudogene 4', 'pseudogene', 'ENSG00000233343'),
(414, 18265, 'ATP6V1G3', 'ATPase H+ transporting V1 subunit G3', 'protein-coding gene', 'ENSG00000151418'),
(415, 18303, 'ATP6V1H', 'ATPase H+ transporting V1 subunit H', 'protein-coding gene', 'ENSG00000047249'),
(416, 866, 'ATP6V0A4', 'ATPase H+ transporting V0 subunit a4', 'protein-coding gene', 'ENSG00000105929'),
(417, 41935, 'ATP6V0E1P1', 'ATPase H+ transporting V0 subunit e1 pseudogene 1', 'pseudogene', 'ENSG00000225364'),
(418, 41937, 'ATP6V0E1P3', 'ATPase H+ transporting V0 subunit e1 pseudogene 3', 'pseudogene', 'ENSG00000238038'),
(419, 21723, 'ATP6V0E2', 'ATPase H+ transporting V0 subunit e2', 'protein-coding gene', 'ENSG00000171130'),
(420, 870, 'ATP7B', 'ATPase copper transporting beta', 'protein-coding gene', 'ENSG00000123191'),
(421, 55392, 'ATP8A1-DT', 'ATP8A1 divergent transcript', 'non-coding RNA', 'ENSG00000260519'),
(422, 27245, 'ATP8B5P', 'ATPase phospholipid transporting 8B5, pseudogene', 'pseudogene', 'ENSG00000179766'),
(423, 55434, 'ATP10A-DT', 'ATP10A divergent transcript', 'non-coding RNA', 'ENSG00000259011'),
(424, 13554, 'ATP11C', 'ATPase phospholipid transporting 11C', 'protein-coding gene', 'ENSG00000101974'),
(425, 24215, 'ATP13A1', 'ATPase 13A1', 'protein-coding gene', 'ENSG00000105726'),
(426, 24113, 'ATP13A3', 'ATPase 13A3', 'protein-coding gene', 'ENSG00000133657'),
(427, 31789, 'ATP13A5', 'ATPase 13A5', 'protein-coding gene', 'ENSG00000187527'),
(428, 882, 'ATR', 'ATR serine/threonine kinase', 'protein-coding gene', 'ENSG00000175054'),
(429, 33279, 'ATXN1L', 'ataxin 1 like', 'protein-coding gene', 'ENSG00000224470'),
(430, 10561, 'ATXN8OS', 'ATXN8 opposite strand lncRNA', 'non-coding RNA', 'ENSG00000230223'),
(431, 10549, 'ATXN10', 'ataxin 10', 'protein-coding gene', 'ENSG00000130638'),
(432, 890, 'AUH', 'AU RNA binding methylglutaconyl-CoA hydratase', 'protein-coding gene', 'ENSG00000148090'),
(433, 18613, 'AURKBP1', 'aurora kinase B pseudogene 1', 'pseudogene', 'ENSG00000230948'),
(434, 13509, 'AVEN', 'apoptosis and caspase activation inhibitor', 'protein-coding gene', 'ENSG00000169857'),
(435, 905, 'AXL', 'AXL receptor tyrosine kinase', 'protein-coding gene', 'ENSG00000167601'),
(436, 29957, 'AZIN2', 'antizyme inhibitor 2', 'protein-coding gene', 'ENSG00000142920'),
(437, 28596, 'B3GALNT2', 'beta-1,3-N-acetylgalactosaminyltransferase 2', 'protein-coding gene', 'ENSG00000162885'),
(438, 16424, 'B3GALT5-AS1', 'B3GALT5 antisense RNA 1', 'non-coding RNA', 'ENSG00000184809'),
(439, 24141, 'B3GNT6', 'UDP-GlcNAc:betaGal beta-1,3-N-acetylglucosaminyltransferase 6', 'protein-coding gene', 'ENSG00000198488'),
(440, 24139, 'B3GNT8', 'UDP-GlcNAc:betaGal beta-1,3-N-acetylglucosaminyltransferase 8', 'protein-coding gene', 'ENSG00000177191'),
(441, 51318, 'B3GNTL1P2', 'B3GNTL1 pseudogene 2', 'pseudogene', 'ENSG00000271328'),
(442, 924, 'B4GALT1', 'beta-1,4-galactosyltransferase 1', 'protein-coding gene', 'ENSG00000086062'),
(443, 40090, 'B4GALT4-AS1', 'B4GALT4 antisense RNA 1', 'non-coding RNA', 'ENSG00000240254'),
(444, 930, 'B4GALT7', 'beta-1,4-galactosyltransferase 7', 'protein-coding gene', 'ENSG00000027847'),
(445, 28595, 'BAALC-AS2', 'BAALC antisense RNA 2', 'non-coding RNA', 'ENSG00000236939'),
(446, 37125, 'BACE1-AS', 'BACE1 antisense RNA', 'non-coding RNA', 'ENSG00000278768'),
(447, 934, 'BACE2', 'beta-secretase 2', 'protein-coding gene', 'ENSG00000182240'),
(448, 40008, 'BACH1-AS1', 'BACH1 antisense RNA 1', 'non-coding RNA', 'ENSG00000232118'),
(449, 936, 'BAD', 'BCL2 associated agonist of cell death', 'protein-coding gene', 'ENSG00000002330'),
(450, 54932, 'BAG1P1', 'BAG1 pseudogene 1', 'pseudogene', 'ENSG00000232370'),
(451, 21649, 'BAIAP2L1', 'BAR/IMD domain containing adaptor protein 2 like 1', 'protein-coding gene', 'ENSG00000006453'),
(452, 16172, 'BANF2', 'BANF family member 2', 'protein-coding gene', 'ENSG00000125888'),
(453, 952, 'BARD1', 'BRCA1 associated RING domain 1', 'protein-coding gene', 'ENSG00000138376'),
(454, 953, 'BARHL1', 'BarH like homeobox 1', 'protein-coding gene', 'ENSG00000125492'),
(455, 955, 'BARX1', 'BARX homeobox 1', 'protein-coding gene', 'ENSG00000131668'),
(456, 26609, 'BASP1-AS1', 'BASP1 antisense RNA 1', 'non-coding RNA', 'ENSG00000215196'),
(457, 39418, 'BASP1P1', 'BASP1 pseudogene 1', 'pseudogene', 'ENSG00000230535'),
(458, 961, 'BAZ1B', 'bromodomain adjacent to zinc finger domain 1B', 'protein-coding gene', 'ENSG00000009954'),
(459, 19855, 'BBOF1', 'basal body orientation factor 1', 'protein-coding gene', 'ENSG00000119636'),
(460, 964, 'BBOX1', 'gamma-butyrobetaine hydroxylase 1', 'protein-coding gene', 'ENSG00000129151'),
(461, 969, 'BBS4', 'Bardet-Biedl syndrome 4', 'protein-coding gene', 'ENSG00000140463'),
(462, 970, 'BBS5', 'Bardet-Biedl syndrome 5', 'protein-coding gene', 'ENSG00000163093'),
(463, 18758, 'BBS7', 'Bardet-Biedl syndrome 7', 'protein-coding gene', 'ENSG00000138686'),
(464, 26291, 'BBS10', 'Bardet-Biedl syndrome 10', 'protein-coding gene', 'ENSG00000179941'),
(465, 39595, 'BCAS2P2', 'BCAS2 pseudogene 2', 'pseudogene', 'ENSG00000234332'),
(466, 14367, 'BCAS4', 'breast carcinoma amplified sequence 4', 'protein-coding gene', 'ENSG00000124243'),
(467, 987, 'BCKDHB', 'branched chain keto acid dehydrogenase E1 subunit beta', 'protein-coding gene', 'ENSG00000083123'),
(468, 991, 'BCL2A1', 'BCL2 related protein A1', 'protein-coding gene', 'ENSG00000140379'),
(469, 42959, 'BCL2L2-PABPN1', 'BCL2L2-PABPN1 readthrough', 'other', 'ENSG00000258643'),
(470, 998, 'BCL3', 'BCL3 transcription coactivator', 'protein-coding gene', 'ENSG00000069399'),
(471, 13222, 'BCL11B', 'BAF chromatin remodeling complex subunit BCL11B', 'protein-coding gene', 'ENSG00000127152'),
(472, 39073, 'BCRP1', 'BCR pseudogene 1', 'pseudogene', 'ENSG00000225098'),
(473, 49113, 'BCRP9', 'BCR pseudogene 9', 'pseudogene', 'ENSG00000271287'),
(474, 1020, 'BCS1L', 'BCS1 homolog, ubiquinol-cytochrome c reductase complex chaperone', 'protein-coding gene', 'ENSG00000074582'),
(475, 1027, 'BDH1', '3-hydroxybutyrate dehydrogenase 1', 'protein-coding gene', 'ENSG00000161267'),
(476, 51114, 'BEAN1-AS1', 'BEAN1 antisense RNA 1', 'non-coding RNA', 'ENSG00000261656'),
(477, 13388, 'BEX3', 'brain expressed X-linked 3', 'protein-coding gene', 'ENSG00000166681'),
(478, 1043, 'BGLAP', 'bone gamma-carboxyglutamate protein', 'protein-coding gene', 'ENSG00000242252'),
(479, 56147, 'BHLHE22-AS1', 'BHLHE22 antisense RNA 1', 'non-coding RNA', 'ENSG00000254102'),
(480, 1048, 'BHMT2', 'betaine--homocysteine S-methyltransferase 2', 'protein-coding gene', 'ENSG00000132840'),
(481, 1049, 'BICD1', 'BICD cargo adaptor 1', 'protein-coding gene', 'ENSG00000151746'),
(482, 1050, 'BID', 'BH3 interacting domain death agonist', 'protein-coding gene', 'ENSG00000015475'),
(483, 1052, 'BIN1', 'bridging integrator 1', 'protein-coding gene', 'ENSG00000136717'),
(484, 590, 'BIRC2', 'baculoviral IAP repeat containing 2', 'protein-coding gene', 'ENSG00000110330'),
(485, 14878, 'BIRC8', 'baculoviral IAP repeat containing 8', 'protein-coding gene', 'ENSG00000163098'),
(486, 16034, 'BIVM', 'basic, immunoglobulin-like variable motif containing', 'protein-coding gene', 'ENSG00000134897'),
(487, 1057, 'BLK', 'BLK proto-oncogene, Src family tyrosine kinase', 'protein-coding gene', 'ENSG00000136573'),
(488, 18561, 'BLOC1S5', 'biogenesis of lysosomal organelles complex 1 subunit 5', 'protein-coding gene', 'ENSG00000188428'),
(489, 1062, 'BLVRA', 'biliverdin reductase A', 'protein-coding gene', 'ENSG00000106605'),
(490, 1067, 'BMP1', 'bone morphogenetic protein 1', 'protein-coding gene', 'ENSG00000168487'),
(491, 18041, 'BMP2K', 'BMP2 inducible kinase', 'protein-coding gene', 'ENSG00000138756'),
(492, 1073, 'BMP6', 'bone morphogenetic protein 6', 'protein-coding gene', 'ENSG00000153162'),
(493, 20869, 'BMP10', 'bone morphogenetic protein 10', 'protein-coding gene', 'ENSG00000163217'),
(494, 1076, 'BMPR1A', 'bone morphogenetic protein receptor type 1A', 'protein-coding gene', 'ENSG00000107779'),
(495, 21742, 'BMPR1AP1', 'bone morphogenetic protein receptor type 1A pseudogene 1', 'pseudogene', 'ENSG00000219642'),
(496, 23651, 'BMS1P3', 'BMS1 pseudogene 3', 'pseudogene', 'ENSG00000240089'),
(497, 55636, 'BMS1P4-AGAP5', 'BMS1P4-AGAP5 readthrough', 'other', 'ENSG00000242288'),
(498, 49161, 'BMS1P16', 'BMS1 pseudogene 16', 'pseudogene', 'ENSG00000258684'),
(499, 55088, 'BMS1P23', 'BMS1 pseudogene 23', 'pseudogene', 'ENSG00000286156'),
(500, 1079, 'BMX', 'BMX non-receptor tyrosine kinase', 'protein-coding gene', 'ENSG00000102010'),
(501, 30988, 'BNC2', 'basonuclin 2', 'protein-coding gene', 'ENSG00000173068'),
(502, 1082, 'BNIP1', 'BCL2 interacting protein 1', 'protein-coding gene', 'ENSG00000113734'),
(503, 19922, 'BNIP3P1', 'BCL2 interacting protein 3 pseudogene 1', 'pseudogene', 'ENSG00000197358'),
(504, 49689, 'BNIP3P9', 'BCL2 interacting protein 3 pseudogene 9', 'pseudogene', 'ENSG00000270325'),
(505, 49693, 'BNIP3P13', 'BCL2 interacting protein 3 pseudogene 13', 'pseudogene', 'ENSG00000269154'),
(506, 49717, 'BNIP3P37', 'BCL2 interacting protein 3 pseudogene 37', 'pseudogene', 'ENSG00000270479'),
(507, 49722, 'BNIP3P42', 'BCL2 interacting protein 3 pseudogene 42', 'pseudogene', 'ENSG00000223974'),
(508, 35125, 'BOK-AS1', 'BOK antisense RNA 1', 'non-coding RNA', 'ENSG00000234235'),
(509, 53563, 'BOLA2-SMG1P6', 'BOLA2-SMG1P6 readthrough', 'other', 'ENSG00000261740'),
(510, 51438, 'BOLA2P2', 'bolA family member 2 pseudogene 2', 'pseudogene', 'ENSG00000271161'),
(511, 42922, 'BOLA3-DT', 'BOLA3 divergent transcript', 'non-coding RNA', 'ENSG00000225439');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(512, 24724, 'BORA', 'BORA aurora kinase A activator', 'protein-coding gene', 'ENSG00000136122'),
(513, 23516, 'BORCS7', 'BLOC-1 related complex subunit 7', 'protein-coding gene', 'ENSG00000166275'),
(514, 39979, 'BORCS8-MEF2B', 'BORCS8-MEF2B readthrough', 'other', 'ENSG00000064489'),
(515, 1093, 'BPGM', 'bisphosphoglycerate mutase', 'protein-coding gene', 'ENSG00000172331'),
(516, 16504, 'BPIFB6', 'BPI fold containing family B member 6', 'protein-coding gene', 'ENSG00000167104'),
(517, 25449, 'BPY2B', 'basic charge Y-linked 2B', 'protein-coding gene', 'ENSG00000183795'),
(518, 28470, 'BRCA1P1', 'BRCA1 pseudogene 1', 'pseudogene', 'ENSG00000267595'),
(519, 1104, 'BRD3', 'bromodomain containing 3', 'protein-coding gene', 'ENSG00000169925'),
(520, 37632, 'BRD7P6', 'bromodomain containing 7 pseudogene 6', 'pseudogene', 'ENSG00000235289'),
(521, 11551, 'BRF1', 'BRF1 RNA polymerase III transcription initiation factor subunit', 'protein-coding gene', 'ENSG00000185024'),
(522, 51482, 'BRI3BPP1', 'BRI3 binding protein pseudogene 1', 'pseudogene', 'ENSG00000269136'),
(523, 32544, 'BRI3P3', 'brain protein I3 pseudogene 3', 'pseudogene', 'ENSG00000230273'),
(524, 13746, 'BRINP2', 'BMP/retinoic acid inducible neural specific 2', 'protein-coding gene', 'ENSG00000198797'),
(525, 51527, 'BRIX1P1', 'BRIX1 pseudogene 1', 'pseudogene', 'ENSG00000254025'),
(526, 42020, 'BRK1P1', 'BRICK1 pseudogene 1', 'pseudogene', 'ENSG00000219870'),
(527, 14255, 'BRPF1', 'bromodomain and PHD finger containing 1', 'protein-coding gene', 'ENSG00000156983'),
(528, 55591, 'BRPF3-AS1', 'BRPF3 antisense RNA 1', 'non-coding RNA', 'ENSG00000246982'),
(529, 18994, 'BRSK1', 'BR serine/threonine kinase 1', 'protein-coding gene', 'ENSG00000160469'),
(530, 51528, 'BRWD1P1', 'bromodomain and WD repeat domain containing 1 pseudogene 1', 'pseudogene', 'ENSG00000215909'),
(531, 15832, 'BSCL2', 'BSCL2 lipid droplet biogenesis associated, seipin', 'protein-coding gene', 'ENSG00000168000'),
(532, 42445, 'BSN-DT', 'BSN divergent transcript', 'non-coding RNA', 'ENSG00000226913'),
(533, 51537, 'BSNDP2', 'BSND pseudogene 2', 'pseudogene', 'ENSG00000274973'),
(534, 18232, 'BSPRY', 'B-box and SPRY domain containing', 'protein-coding gene', 'ENSG00000119411'),
(535, 1119, 'BST2', 'bone marrow stromal cell antigen 2', 'protein-coding gene', 'ENSG00000130303'),
(536, 20450, 'BSX', 'brain specific homeobox', 'protein-coding gene', 'ENSG00000188909'),
(537, 40728, 'BTBD3-AS1', 'BTBD3 antisense RNA 1', 'non-coding RNA', 'ENSG00000236526'),
(538, 18269, 'BTBD7', 'BTB domain containing 7', 'protein-coding gene', 'ENSG00000011114'),
(539, 40959, 'BTBD9-AS1', 'BTBD9 antisense RNA 1', 'non-coding RNA', 'ENSG00000226533'),
(540, 21445, 'BTBD10', 'BTB domain containing 10', 'protein-coding gene', 'ENSG00000148925'),
(541, 26340, 'BTBD16', 'BTB domain containing 16', 'protein-coding gene', 'ENSG00000138152'),
(542, 37214, 'BTBD18', 'BTB domain containing 18', 'protein-coding gene', 'ENSG00000233436'),
(543, 1121, 'BTC', 'betacellulin', 'protein-coding gene', 'ENSG00000174808'),
(544, 39645, 'BTF3L4P1', 'basic transcription factor 3 like 4 pseudogene 1', 'pseudogene', 'ENSG00000232260'),
(545, 19924, 'BTF3P2', 'BTF3 pseudogene 2', 'pseudogene', 'ENSG00000258282'),
(546, 38566, 'BTF3P4', 'basic transcription factor 3 pseudogene 4', 'pseudogene', 'ENSG00000224820'),
(547, 38570, 'BTF3P10', 'basic transcription factor 3 pseudogene 10', 'pseudogene', 'ENSG00000231120'),
(548, 38571, 'BTF3P14', 'basic transcription factor 3 pseudogene 14', 'pseudogene', 'ENSG00000262609'),
(549, 37692, 'BTG1P1', 'BTG anti-proliferation factor 1 pseudogene 1', 'pseudogene', 'ENSG00000256720'),
(550, 51543, 'BTG3P1', 'BTG anti-proliferation factor 3 pseudogene 1', 'pseudogene', 'ENSG00000235334'),
(551, 1135, 'BTN1A1', 'butyrophilin subfamily 1 member A1', 'protein-coding gene', 'ENSG00000124557'),
(552, 1138, 'BTN3A1', 'butyrophilin subfamily 3 member A1', 'protein-coding gene', 'ENSG00000026950'),
(553, 1142, 'BTNL2', 'butyrophilin like 2', 'protein-coding gene', 'ENSG00000204290'),
(554, 1144, 'BTRC', 'beta-transducin repeat containing E3 ubiquitin protein ligase', 'protein-coding gene', 'ENSG00000166167'),
(555, 49529, 'BUB1P1', 'BUB1 mitotic checkpoint serine/threonine kinase pseudogene 1', 'pseudogene', 'ENSG00000270778'),
(556, 28199, 'BUD13', 'BUD13 homolog', 'protein-coding gene', 'ENSG00000137656'),
(557, 1157, 'BYSL', 'bystin like', 'protein-coding gene', 'ENSG00000112578'),
(558, 40839, 'BZW1-AS1', 'BZW1 antisense RNA 1', 'non-coding RNA', 'ENSG00000230408'),
(559, 29911, 'C1D', 'C1D nuclear receptor corepressor', 'protein-coding gene', 'ENSG00000197223'),
(560, 31661, 'C1DP3', 'C1D nuclear receptor corepressor pseudogene 3', 'pseudogene', 'ENSG00000224760'),
(561, 51614, 'C1GALT1P1', 'C1GALT1 pseudogene 1', 'pseudogene', 'ENSG00000257818'),
(562, 51616, 'C1GALT1P3', 'C1GALT1 pseudogene 3', 'pseudogene', 'ENSG00000253544'),
(563, 29876, 'C1ORF43', 'chromosome 1 open reading frame 43', 'protein-coding gene', 'ENSG00000143612'),
(564, 30003, 'C1ORF53', 'chromosome 1 open reading frame 53', 'protein-coding gene', 'ENSG00000203724'),
(565, 29468, 'C1ORF68', 'chromosome 1 open reading frame 68', 'protein-coding gene', 'ENSG00000198854'),
(566, 26319, 'C1ORF74', 'chromosome 1 open reading frame 74', 'protein-coding gene', 'ENSG00000162757'),
(567, 28547, 'C1ORF87', 'chromosome 1 open reading frame 87', 'protein-coding gene', 'ENSG00000162598'),
(568, 30435, 'C1ORF100', 'chromosome 1 open reading frame 100', 'protein-coding gene', 'ENSG00000173728'),
(569, 25873, 'C1ORF115', 'chromosome 1 open reading frame 115', 'protein-coding gene', 'ENSG00000162817'),
(570, 27915, 'C1ORF174', 'chromosome 1 open reading frame 174', 'protein-coding gene', 'ENSG00000198912'),
(571, 1243, 'C1QBP', 'complement C1q binding protein', 'protein-coding gene', 'ENSG00000108561'),
(572, 1245, 'C1QC', 'complement C1q C chain', 'protein-coding gene', 'ENSG00000159189'),
(573, 14325, 'C1QTNF2', 'C1q and TNF related 2', 'protein-coding gene', 'ENSG00000145861'),
(574, 14326, 'C1QTNF3', 'C1q and TNF related 3', 'protein-coding gene', 'ENSG00000082196'),
(575, 40683, 'C1QTNF7-AS1', 'C1QTNF7 antisense RNA 1', 'non-coding RNA', 'ENSG00000249252'),
(576, 31374, 'C1QTNF8', 'C1q and TNF related 8', 'protein-coding gene', 'ENSG00000184471'),
(577, 39906, 'C1QTNF9-AS1', 'C1QTNF9 antisense RNA 1', 'non-coding RNA', 'ENSG00000240868'),
(578, 34072, 'C1QTNF9B', 'C1q and TNF related 9B', 'protein-coding gene', 'ENSG00000205863'),
(579, 32308, 'C1QTNF12', 'C1q and TNF related 12', 'protein-coding gene', 'ENSG00000184163'),
(580, 49464, 'C2-AS1', 'C2 antisense RNA 1', 'non-coding RNA', 'ENSG00000281756'),
(581, 24564, 'C2CD3', 'C2 domain containing 3 centriole elongation regulator', 'protein-coding gene', 'ENSG00000168014'),
(582, 37210, 'C2CD4D', 'C2 calcium dependent domain containing 4D', 'protein-coding gene', 'ENSG00000225556'),
(583, 55961, 'C2CD5-AS1', 'C2CD5 antisense RNA 1', 'non-coding RNA', 'ENSG00000250166'),
(584, 25077, 'C2ORF27A', 'chromosome 2 open reading frame 27A', 'non-coding RNA', 'ENSG00000287151'),
(585, 34353, 'C2ORF68', 'chromosome 2 open reading frame 68', 'protein-coding gene', 'ENSG00000168887'),
(586, 26799, 'C2ORF69', 'chromosome 2 open reading frame 69', 'protein-coding gene', 'ENSG00000178074'),
(587, 51801, 'C2ORF69P2', 'chromosome 2 open reading frame 69 pseudogene 2', 'pseudogene', 'ENSG00000260341'),
(588, 51803, 'C2ORF69P4', 'chromosome 2 open reading frame 69 pseudogene 4', 'pseudogene', 'ENSG00000260480'),
(589, 27017, 'C2ORF76', 'chromosome 2 open reading frame 76', 'protein-coding gene', 'ENSG00000186132'),
(590, 34349, 'C2ORF78', 'chromosome 2 open reading frame 78', 'protein-coding gene', 'ENSG00000187833'),
(591, 34350, 'C2ORF81', 'chromosome 2 open reading frame 81', 'protein-coding gene', 'ENSG00000284308'),
(592, 49272, 'C2ORF92', 'chromosome 2 open reading frame 92', 'protein-coding gene', 'ENSG00000228486'),
(593, 28534, 'C3ORF22', 'chromosome 3 open reading frame 22', 'protein-coding gene', 'ENSG00000180697'),
(594, 26434, 'C3ORF33', 'chromosome 3 open reading frame 33', 'protein-coding gene', 'ENSG00000174928'),
(595, 1328, 'C4BPB', 'complement component 4 binding protein beta', 'protein-coding gene', 'ENSG00000123843'),
(596, 28386, 'C4ORF36', 'chromosome 4 open reading frame 36', 'protein-coding gene', 'ENSG00000163633'),
(597, 55884, 'C4ORF46P3', 'C4orf46 pseudogene 3', 'pseudogene', 'ENSG00000254352'),
(598, 27741, 'C4ORF54', 'chromosome 4 open reading frame 54', 'protein-coding gene', 'ENSG00000248713'),
(599, 4527, 'C5AR2', 'complement C5a receptor 2', 'protein-coding gene', 'ENSG00000134830'),
(600, 26746, 'C5ORF24', 'chromosome 5 open reading frame 24', 'protein-coding gene', 'ENSG00000181904'),
(601, 27026, 'C5ORF47', 'chromosome 5 open reading frame 47', 'protein-coding gene', 'ENSG00000185056'),
(602, 35121, 'C5ORF52', 'chromosome 5 open reading frame 52', 'protein-coding gene', 'ENSG00000187658'),
(603, 52969, 'C5ORF64-AS1', 'C5orf64 antisense RNA 1', 'non-coding RNA', 'ENSG00000251575'),
(604, 51252, 'C5ORF67', 'chromosome 5 putative open reading frame 67', 'other', 'ENSG00000225940'),
(605, 21114, 'C6ORF89', 'chromosome 6 open reading frame 89', 'protein-coding gene', 'ENSG00000198663'),
(606, 21233, 'C6ORF118', 'chromosome 6 open reading frame 118', 'protein-coding gene', 'ENSG00000112539'),
(607, 21620, 'C6ORF201', 'chromosome 6 open reading frame 201', 'protein-coding gene', 'ENSG00000185689'),
(608, 1346, 'C7', 'complement C7', 'protein-coding gene', 'ENSG00000112936'),
(609, 21722, 'C7ORF31', 'chromosome 7 open reading frame 31', 'protein-coding gene', 'ENSG00000153790'),
(610, 22247, 'C7ORF57', 'chromosome 7 open reading frame 57', 'protein-coding gene', 'ENSG00000164746'),
(611, 51256, 'C7ORF77', 'chromosome 7 open reading frame 77', 'protein-coding gene', 'ENSG00000275356'),
(612, 27840, 'C8ORF34-AS1', 'C8orf34 antisense RNA 1', 'non-coding RNA', 'ENSG00000248801'),
(613, 25924, 'C8ORF76', 'chromosome 8 open reading frame 76', 'protein-coding gene', 'ENSG00000189376'),
(614, 28144, 'C9ORF64', 'chromosome 9 open reading frame 64', 'protein-coding gene', 'ENSG00000165118'),
(615, 24932, 'C9ORF78', 'chromosome 9 open reading frame 78', 'protein-coding gene', 'ENSG00000136819'),
(616, 31116, 'C9ORF129', 'chromosome 9 open reading frame 129', 'protein-coding gene', 'ENSG00000204352'),
(617, 27421, 'C10ORF53', 'chromosome 10 open reading frame 53', 'protein-coding gene', 'ENSG00000178645'),
(618, 23294, 'C10ORF62', 'chromosome 10 open reading frame 62', 'protein-coding gene', 'ENSG00000203942'),
(619, 28500, 'C10ORF82', 'chromosome 10 open reading frame 82', 'protein-coding gene', 'ENSG00000165863'),
(620, 44080, 'C10ORF88B', 'C10orf88B (pseudogene)', 'pseudogene', 'ENSG00000255624'),
(621, 26563, 'C10ORF90', 'chromosome 10 open reading frame 90', 'protein-coding gene', 'ENSG00000154493'),
(622, 20304, 'C10ORF105', 'chromosome 10 open reading frame 105', 'protein-coding gene', 'ENSG00000214688'),
(623, 25707, 'C10ORF120', 'chromosome 10 open reading frame 120', 'protein-coding gene', 'ENSG00000183559'),
(624, 1174, 'C11ORF24', 'chromosome 11 open reading frame 24', 'protein-coding gene', 'ENSG00000171067'),
(625, 34442, 'C11ORF86', 'chromosome 11 open reading frame 86', 'protein-coding gene', 'ENSG00000173237'),
(626, 34444, 'C11ORF91', 'chromosome 11 open reading frame 91', 'protein-coding gene', 'ENSG00000205177'),
(627, 38675, 'C11ORF96', 'chromosome 11 open reading frame 96', 'protein-coding gene', 'ENSG00000187479'),
(628, 24729, 'C12ORF42', 'chromosome 12 open reading frame 42', 'protein-coding gene', 'ENSG00000179088'),
(629, 42693, 'C13ORF42', 'chromosome 13 open reading frame 42', 'protein-coding gene', 'ENSG00000226792'),
(630, 33795, 'C14ORF180', 'chromosome 14 open reading frame 180', 'protein-coding gene', 'ENSG00000184601'),
(631, 34453, 'C15ORF61', 'chromosome 15 open reading frame 61', 'protein-coding gene', 'ENSG00000189227'),
(632, 34489, 'C15ORF62', 'chromosome 15 open reading frame 62', 'protein-coding gene', 'ENSG00000188277'),
(633, 30103, 'C16ORF72', 'chromosome 16 open reading frame 72', 'protein-coding gene', 'ENSG00000182831'),
(634, 28479, 'C16ORF78', 'chromosome 16 open reading frame 78', 'protein-coding gene', 'ENSG00000166152'),
(635, 29581, 'C17ORF50', 'chromosome 17 open reading frame 50', 'protein-coding gene', 'ENSG00000270806'),
(636, 33800, 'C17ORF97', 'chromosome 17 open reading frame 97', 'protein-coding gene', 'ENSG00000187624'),
(637, 34492, 'C17ORF98', 'chromosome 17 open reading frame 98', 'protein-coding gene', 'ENSG00000275489'),
(638, 34490, 'C17ORF99', 'chromosome 17 open reading frame 99', 'protein-coding gene', 'ENSG00000187997'),
(639, 53437, 'C17ORF113', 'chromosome 17 open reading frame 113', 'protein-coding gene', 'ENSG00000267221'),
(640, 55343, 'C17ORF114', 'chromosome 17 open reading frame 114', 'protein-coding gene', 'ENSG00000262165'),
(641, 25443, 'C19ORF12', 'chromosome 19 open reading frame 12', 'protein-coding gene', 'ENSG00000131943'),
(642, 26711, 'C19ORF25', 'chromosome 19 open reading frame 25', 'protein-coding gene', 'ENSG00000119559'),
(643, 34073, 'C19ORF38', 'chromosome 19 open reading frame 38', 'protein-coding gene', 'ENSG00000214212'),
(644, 26723, 'C19ORF47', 'chromosome 19 open reading frame 47', 'protein-coding gene', 'ENSG00000160392'),
(645, 24991, 'C19ORF53', 'chromosome 19 open reading frame 53', 'protein-coding gene', 'ENSG00000104979'),
(646, 16134, 'C20ORF141', 'chromosome 20 open reading frame 141', 'protein-coding gene', 'ENSG00000258713'),
(647, 16166, 'C20ORF173', 'chromosome 20 open reading frame 173', 'protein-coding gene', 'ENSG00000125975'),
(648, 51657, 'CA3-AS1', 'CA3 antisense RNA 1', 'non-coding RNA', 'ENSG00000253549'),
(649, 1375, 'CA4', 'carbonic anhydrase 4', 'protein-coding gene', 'ENSG00000167434'),
(650, 1377, 'CA5A', 'carbonic anhydrase 5A', 'protein-coding gene', 'ENSG00000174990'),
(651, 14914, 'CA13', 'carbonic anhydrase 13', 'protein-coding gene', 'ENSG00000185015'),
(652, 20292, 'CAB39', 'calcium binding protein 39', 'protein-coding gene', 'ENSG00000135932'),
(653, 20290, 'CAB39L', 'calcium binding protein 39 like', 'protein-coding gene', 'ENSG00000102547'),
(654, 55491, 'CABP1-DT', 'CABP1 divergent transcript', 'non-coding RNA', 'ENSG00000256008'),
(655, 13714, 'CABP5', 'calcium binding protein 5', 'protein-coding gene', 'ENSG00000105507'),
(656, 20834, 'CABP7', 'calcium binding protein 7', 'protein-coding gene', 'ENSG00000100314'),
(657, 30710, 'CABS1', 'calcium binding protein, spermatid associated 1', 'protein-coding gene', 'ENSG00000145309'),
(658, 29314, 'CACHD1', 'cache domain containing 1', 'protein-coding gene', 'ENSG00000158966'),
(659, 1389, 'CACNA1B', 'calcium voltage-gated channel subunit alpha1 B', 'protein-coding gene', 'ENSG00000148408'),
(660, 40118, 'CACNA1C-AS2', 'CACNA1C antisense RNA 2', 'non-coding RNA', 'ENSG00000256271'),
(661, 41314, 'CACNA1C-IT3', 'CACNA1C intronic transcript 3', 'non-coding RNA', 'ENSG00000256721'),
(662, 1393, 'CACNA1F', 'calcium voltage-gated channel subunit alpha1 F', 'protein-coding gene', 'ENSG00000102001'),
(663, 40120, 'CACNA2D1-AS1', 'CACNA2D1 antisense RNA 1', 'non-coding RNA', 'ENSG00000223770'),
(664, 1403, 'CACNB3', 'calcium voltage-gated channel auxiliary subunit beta 3', 'protein-coding gene', 'ENSG00000167535'),
(665, 1405, 'CACNG1', 'calcium voltage-gated channel auxiliary subunit gamma 1', 'protein-coding gene', 'ENSG00000108878'),
(666, 1407, 'CACNG3', 'calcium voltage-gated channel auxiliary subunit gamma 3', 'protein-coding gene', 'ENSG00000006116'),
(667, 1409, 'CACNG5', 'calcium voltage-gated channel auxiliary subunit gamma 5', 'protein-coding gene', 'ENSG00000075429'),
(668, 13625, 'CACNG6', 'calcium voltage-gated channel auxiliary subunit gamma 6', 'protein-coding gene', 'ENSG00000130433'),
(669, 45123, 'CACYBPP2', 'calcyclin binding protein pseudogene 2', 'pseudogene', 'ENSG00000177855'),
(670, 1424, 'CAD', 'carbamoyl-phosphate synthetase 2, aspartate transcarbamylase, and dihydroorotase', 'protein-coding gene', 'ENSG00000084774'),
(671, 41248, 'CADM2-AS1', 'CADM2 antisense RNA 1', 'non-coding RNA', 'ENSG00000239519'),
(672, 40812, 'CADM3-AS1', 'CADM3 antisense RNA 1', 'non-coding RNA', 'ENSG00000225670'),
(673, 16018, 'CADPS2', 'calcium dependent secretion activator 2', 'protein-coding gene', 'ENSG00000081803'),
(674, 29306, 'CALCOCO1', 'calcium binding and coiled-coil domain 1', 'protein-coding gene', 'ENSG00000012822'),
(675, 1439, 'CALCP', 'calcitonin pseudogene', 'pseudogene', 'ENSG00000253179'),
(676, 55863, 'CALCRL-AS1', 'CALCRL and TFPI antisense RNA 1', 'non-coding RNA', 'ENSG00000224063'),
(677, 23458, 'CALHM3', 'calcium homeostasis modulator 3', 'protein-coding gene', 'ENSG00000183128'),
(678, 21568, 'CALHM5', 'calcium homeostasis modulator family member 5', 'protein-coding gene', 'ENSG00000178033'),
(679, 1445, 'CALM2', 'calmodulin 2', 'protein-coding gene', 'ENSG00000143933'),
(680, 39661, 'CALM2P4', 'calmodulin 2 pseudogene 4', 'pseudogene', 'ENSG00000233662'),
(681, 1452, 'CALML3', 'calmodulin like 3', 'protein-coding gene', 'ENSG00000178363'),
(682, 20407, 'CALR3', 'calreticulin 3', 'protein-coding gene', 'ENSG00000269058'),
(683, 1461, 'CAMK2B', 'calcium/calmodulin dependent protein kinase II beta', 'protein-coding gene', 'ENSG00000058404'),
(684, 24190, 'CAMK2N1', 'calcium/calmodulin dependent protein kinase II inhibitor 1', 'protein-coding gene', 'ENSG00000162545'),
(685, 1472, 'CAMP', 'cathelicidin antimicrobial peptide', 'protein-coding gene', 'ENSG00000164047'),
(686, 19946, 'CAMSAP1', 'calmodulin regulated spectrin associated protein 1', 'protein-coding gene', 'ENSG00000130559'),
(687, 29188, 'CAMSAP2', 'calmodulin regulated spectrin associated protein family member 2', 'protein-coding gene', 'ENSG00000118200'),
(688, 18806, 'CAMTA1', 'calmodulin binding transcription activator 1', 'protein-coding gene', 'ENSG00000171735'),
(689, 40855, 'CAMTA1-AS2', 'CAMTA1 antisense RNA 2', 'non-coding RNA', 'ENSG00000237728'),
(690, 30689, 'CAND2', 'cullin associated and neddylation dissociated 2 (putative)', 'protein-coding gene', 'ENSG00000144712'),
(691, 19721, 'CANT1', 'calcium activated nucleotidase 1', 'protein-coding gene', 'ENSG00000171302'),
(692, 1473, 'CANX', 'calnexin', 'protein-coding gene', 'ENSG00000127022'),
(693, 31970, 'CAP1P2', 'CAP1 pseudogene 2', 'pseudogene', 'ENSG00000232004'),
(694, 1480, 'CAPN3', 'calpain 3', 'protein-coding gene', 'ENSG00000092529'),
(695, 1485, 'CAPN8', 'calpain 8', 'protein-coding gene', 'ENSG00000203697'),
(696, 1477, 'CAPN10', 'calpain 10', 'protein-coding gene', 'ENSG00000142330'),
(697, 13249, 'CAPN12', 'calpain 12', 'protein-coding gene', 'ENSG00000182472'),
(698, 1481, 'CAPNS1', 'calpain small subunit 1', 'protein-coding gene', 'ENSG00000126247'),
(699, 21259, 'CAPRIN2', 'caprin family member 2', 'protein-coding gene', 'ENSG00000110888'),
(700, 40769, 'CAPS2-AS1', 'CAPS2 antisense RNA 1', 'non-coding RNA', 'ENSG00000254451'),
(701, 1488, 'CAPZA1', 'capping actin protein of muscle Z-line subunit alpha 1', 'protein-coding gene', 'ENSG00000116489'),
(702, 1489, 'CAPZA1P1', 'CAPZA1 pseudogene 1', 'pseudogene', 'ENSG00000230956'),
(703, 51408, 'CARD8-AS1', 'CARD8 antisense RNA 1', 'non-coding RNA', 'ENSG00000268001'),
(704, 16391, 'CARD9', 'caspase recruitment domain family member 9', 'protein-coding gene', 'ENSG00000187796'),
(705, 16393, 'CARD11', 'caspase recruitment domain family member 11', 'protein-coding gene', 'ENSG00000198286'),
(706, 55361, 'CARHSP1-DT', 'CARHSP1 divergent transcript', 'non-coding RNA', 'ENSG00000261481'),
(707, 27089, 'CARMIL2', 'capping protein regulator and myosin 1 linker 2', 'protein-coding gene', 'ENSG00000159753'),
(708, 20272, 'CARMIL3', 'capping protein regulator and myosin 1 linker 3', 'protein-coding gene', 'ENSG00000186648'),
(709, 42872, 'CARMN', 'cardiac mesoderm enhancer-associated non-coding RNA', 'non-coding RNA', 'ENSG00000249669'),
(710, 50477, 'CARS1P1', 'cysteinyl-tRNA synthetase 1 pseudogene 1', 'pseudogene', 'ENSG00000271232'),
(711, 25695, 'CARS2', 'cysteinyl-tRNA synthetase 2, mitochondrial', 'protein-coding gene', 'ENSG00000134905'),
(712, 48608, 'CASC16', 'cancer susceptibility 16', 'non-coding RNA', 'ENSG00000249231'),
(713, 49463, 'CASC18', 'cancer susceptibility 18', 'non-coding RNA', 'ENSG00000257859'),
(714, 49477, 'CASC20', 'cancer susceptibility 20', 'non-coding RNA', 'ENSG00000229876'),
(715, 50865, 'CASC23', 'cancer susceptibility 23', 'non-coding RNA', 'ENSG00000255420'),
(716, 16014, 'CASD1', 'CAS1 domain containing 1', 'protein-coding gene', 'ENSG00000127995'),
(717, 1505, 'CASP4', 'caspase 4', 'protein-coding gene', 'ENSG00000196954'),
(718, 1511, 'CASP9', 'caspase 9', 'protein-coding gene', 'ENSG00000132906'),
(719, 17116, 'CATSPER1', 'cation channel sperm associated 1', 'protein-coding gene', 'ENSG00000175294'),
(720, 31054, 'CATSPER2P1', 'cation channel sperm associated 2 pseudogene 1', 'pseudogene', 'ENSG00000205771'),
(721, 19231, 'CATSPERZ', 'catsper channel auxiliary subunit zeta', 'protein-coding gene', 'ENSG00000219435'),
(722, 1549, 'CBR3', 'carbonyl reductase 3', 'protein-coding gene', 'ENSG00000159231'),
(723, 55540, 'CBR4-DT', 'CBR4 divergent transcript', 'non-coding RNA', 'ENSG00000251445'),
(724, 38658, 'CBX1P4', 'chromobox 1 pseudogene 4', 'pseudogene', 'ENSG00000214321'),
(725, 1552, 'CBX2', 'chromobox 2', 'protein-coding gene', 'ENSG00000173894'),
(726, 42875, 'CBX3P3', 'chromobox 3 pseudogene 3', 'pseudogene', 'ENSG00000250045'),
(727, 42880, 'CBX3P8', 'chromobox 3 pseudogene 8', 'pseudogene', 'ENSG00000254496'),
(728, 1556, 'CBX6', 'chromobox 6', 'protein-coding gene', 'ENSG00000183741'),
(729, 24236, 'CCAR1', 'cell division cycle and apoptosis regulator 1', 'protein-coding gene', 'ENSG00000060339'),
(730, 23360, 'CCAR2', 'cell cycle and apoptosis regulator 2', 'protein-coding gene', 'ENSG00000158941'),
(731, 23813, 'CCDC3', 'coiled-coil domain containing 3', 'protein-coding gene', 'ENSG00000151468'),
(732, 28332, 'CCDC12', 'coiled-coil domain containing 12', 'protein-coding gene', 'ENSG00000160799'),
(733, 41142, 'CCDC13-AS1', 'CCDC13 antisense RNA 1', 'non-coding RNA', 'ENSG00000173811'),
(734, 25244, 'CCDC39', 'coiled-coil domain containing 39', 'protein-coding gene', 'ENSG00000284862'),
(735, 27709, 'CCDC66', 'coiled-coil domain containing 66', 'protein-coding gene', 'ENSG00000180376'),
(736, 26282, 'CCDC82', 'coiled-coil domain containing 82', 'protein-coding gene', 'ENSG00000149231'),
(737, 24926, 'CCDC85B', 'coiled-coil domain containing 85B', 'protein-coding gene', 'ENSG00000175602'),
(738, 26757, 'CCDC88B', 'coiled-coil domain containing 88B', 'protein-coding gene', 'ENSG00000168071'),
(739, 26762, 'CCDC89', 'coiled-coil domain containing 89', 'protein-coding gene', 'ENSG00000179071'),
(740, 26295, 'CCDC102B', 'coiled-coil domain containing 102B', 'protein-coding gene', 'ENSG00000150636'),
(741, 28465, 'CCDC107', 'coiled-coil domain containing 107', 'protein-coding gene', 'ENSG00000159884'),
(742, 28178, 'CCDC115', 'coiled-coil domain containing 115', 'protein-coding gene', 'ENSG00000136710'),
(743, 25171, 'CCDC124', 'coiled-coil domain containing 124', 'protein-coding gene', 'ENSG00000007080'),
(744, 33459, 'CCDC137P', 'coiled-coil domain containing 137 pseudogene', 'pseudogene', 'ENSG00000242609'),
(745, 29072, 'CCDC144A', 'coiled-coil domain containing 144A', 'protein-coding gene', 'ENSG00000170160'),
(746, 25405, 'CCDC149', 'coiled-coil domain containing 149', 'protein-coding gene', 'ENSG00000181982'),
(747, 26834, 'CCDC150', 'coiled-coil domain containing 150', 'protein-coding gene', 'ENSG00000144395'),
(748, 33854, 'CCDC157', 'coiled-coil domain containing 157', 'protein-coding gene', 'ENSG00000187860'),
(749, 37286, 'CCDC160', 'coiled-coil domain containing 160', 'protein-coding gene', 'ENSG00000203952'),
(750, 29303, 'CCDC180', 'coiled-coil domain containing 180', 'protein-coding gene', 'ENSG00000197816'),
(751, 28051, 'CCDC181', 'coiled-coil domain containing 181', 'protein-coding gene', 'ENSG00000117477'),
(752, 28736, 'CCDC190', 'coiled-coil domain containing 190', 'protein-coding gene', 'ENSG00000185860'),
(753, 49566, 'CCDC192', 'coiled-coil domain containing 192', 'protein-coding gene', 'ENSG00000230561'),
(754, 19860, 'CCDC197', 'coiled-coil domain containing 197', 'protein-coding gene', 'ENSG00000175699'),
(755, 20189, 'CCDC198', 'coiled-coil domain containing 198', 'protein-coding gene', 'ENSG00000100557'),
(756, 54081, 'CCDC201', 'coiled-coil domain containing 201', 'protein-coding gene', 'ENSG00000283247'),
(757, 44662, 'CCER2', 'coiled-coil glutamate rich protein 2', 'protein-coding gene', 'ENSG00000262484'),
(758, 1571, 'CCKBR', 'cholecystokinin B receptor', 'protein-coding gene', 'ENSG00000110148'),
(759, 10618, 'CCL2', 'C-C motif chemokine ligand 2', 'protein-coding gene', 'ENSG00000108691'),
(760, 10630, 'CCL4', 'C-C motif chemokine ligand 4', 'protein-coding gene', 'ENSG00000275302'),
(761, 10611, 'CCL13', 'C-C motif chemokine ligand 13', 'protein-coding gene', 'ENSG00000181374'),
(762, 10612, 'CCL14', 'C-C motif chemokine ligand 14', 'protein-coding gene', 'ENSG00000276409'),
(763, 10619, 'CCL20', 'C-C motif chemokine ligand 20', 'protein-coding gene', 'ENSG00000115009'),
(764, 21708, 'CCM2', 'CCM2 scaffold protein', 'protein-coding gene', 'ENSG00000136280'),
(765, 2654, 'CCN1', 'cellular communication network factor 1', 'protein-coding gene', 'ENSG00000142871'),
(766, 2500, 'CCN2', 'cellular communication network factor 2', 'protein-coding gene', 'ENSG00000118523'),
(767, 37693, 'CCNB1IP1P1', 'cyclin B1 interacting protein 1 pseudogene 1', 'pseudogene', 'ENSG00000229815'),
(768, 1593, 'CCNG2', 'cyclin G2', 'protein-coding gene', 'ENSG00000138764'),
(769, 1596, 'CCNK', 'cyclin K', 'protein-coding gene', 'ENSG00000090061'),
(770, 18576, 'CCNO', 'cyclin O', 'protein-coding gene', 'ENSG00000152669'),
(771, 25805, 'CCNP', 'cyclin P', 'protein-coding gene', 'ENSG00000105219'),
(772, 27373, 'CCNQP1', 'CCNQ pseudogene 1', 'pseudogene', 'ENSG00000233827'),
(773, 23495, 'CCNYL2', 'cyclin Y like 2 (pseudogene)', 'pseudogene', 'ENSG00000182632'),
(774, 24342, 'CCP110', 'centriolar coiled-coil protein 110', 'protein-coding gene', 'ENSG00000103540'),
(775, 1602, 'CCR1', 'C-C motif chemokine receptor 1', 'protein-coding gene', 'ENSG00000163823'),
(776, 1608, 'CCR7', 'C-C motif chemokine receptor 7', 'protein-coding gene', 'ENSG00000126353'),
(777, 1612, 'CCRL2', 'C-C motif chemokine receptor like 2', 'protein-coding gene', 'ENSG00000121797'),
(778, 35141, 'CCT4P2', 'chaperonin containing TCP1 subunit 4 pseudogene 2', 'pseudogene', 'ENSG00000225569'),
(779, 35149, 'CCT7P1', 'chaperonin containing TCP1 subunit 7 pseudogene 1', 'pseudogene', 'ENSG00000217733'),
(780, 35144, 'CCT8P1', 'chaperonin containing TCP1 subunit 8 pseudogene 1', 'pseudogene', 'ENSG00000226015'),
(781, 1635, 'CD1B', 'CD1b molecule', 'protein-coding gene', 'ENSG00000158485'),
(782, 1674, 'CD3E', 'CD3 epsilon subunit of T-cell receptor complex', 'protein-coding gene', 'ENSG00000198851'),
(783, 1645, 'CD24', 'CD24 molecule', 'protein-coding gene', 'ENSG00000272398'),
(784, 1647, 'CD24P2', 'CD24 molecule pseudogene 2', 'pseudogene', 'ENSG00000261333'),
(785, 1653, 'CD28', 'CD28 molecule', 'protein-coding gene', 'ENSG00000178562'),
(786, 1663, 'CD36', 'CD36 molecule', 'protein-coding gene', 'ENSG00000135218'),
(787, 1681, 'CD44', 'CD44 molecule (Indian blood group)', 'protein-coding gene', 'ENSG00000026508'),
(788, 1682, 'CD47', 'CD47 molecule', 'protein-coding gene', 'ENSG00000196776'),
(789, 1804, 'CD52', 'CD52 molecule', 'protein-coding gene', 'ENSG00000169442'),
(790, 1698, 'CD79A', 'CD79a molecule', 'protein-coding gene', 'ENSG00000105369'),
(791, 15855, 'CD93', 'CD93 molecule', 'protein-coding gene', 'ENSG00000125810'),
(792, 7083, 'CD99P1', 'CD99 molecule pseudogene 1', 'pseudogene', 'ENSG00000223773'),
(793, 55765, 'CD109-AS1', 'CD109 antisense RNA 1', 'non-coding RNA', 'ENSG00000231652'),
(794, 17013, 'CD160', 'CD160 molecule', 'protein-coding gene', 'ENSG00000117281'),
(795, 1631, 'CD163', 'CD163 molecule', 'protein-coding gene', 'ENSG00000177575'),
(796, 6726, 'CD180', 'CD180 molecule', 'protein-coding gene', 'ENSG00000134061'),
(797, 24665, 'CD200R1L', 'CD200 receptor 1 like', 'protein-coding gene', 'ENSG00000206531'),
(798, 19137, 'CD276', 'CD276 molecule', 'protein-coding gene', 'ENSG00000103855'),
(799, 19319, 'CD300A', 'CD300a molecule', 'protein-coding gene', 'ENSG00000167851'),
(800, 16848, 'CD300LD', 'CD300 molecule like family member d', 'protein-coding gene', 'ENSG00000204345'),
(801, 30455, 'CD300LG', 'CD300 molecule like family member g', 'protein-coding gene', 'ENSG00000161649'),
(802, 1743, 'CDC5L', 'cell division cycle 5 like', 'protein-coding gene', 'ENSG00000096401'),
(803, 55681, 'CDC20-DT', 'CDC20 divergent transcript', 'non-coding RNA', 'ENSG00000234694'),
(804, 1725, 'CDC25A', 'cell division cycle 25A', 'protein-coding gene', 'ENSG00000164045'),
(805, 51754, 'CDC27P3', 'cell division cycle 27 pseudogene 3', 'pseudogene', 'ENSG00000283005'),
(806, 1734, 'CDC34', 'cell division cycle 34, ubiqiutin conjugating enzyme', 'protein-coding gene', 'ENSG00000099804'),
(807, 17179, 'CDC37L1', 'cell division cycle 37 like 1', 'protein-coding gene', 'ENSG00000106993'),
(808, 1736, 'CDC42', 'cell division cycle 42', 'protein-coding gene', 'ENSG00000070831'),
(809, 29829, 'CDC42BPG', 'CDC42 binding protein kinase gamma', 'protein-coding gene', 'ENSG00000171219'),
(810, 16263, 'CDC42EP2', 'CDC42 effector protein 2', 'protein-coding gene', 'ENSG00000149798'),
(811, 16943, 'CDC42EP3', 'CDC42 effector protein 3', 'protein-coding gene', 'ENSG00000163171'),
(812, 49673, 'CDC42EP3P1', 'CDC42 effector protein 3 pseudogene 1', 'pseudogene', 'ENSG00000268992'),
(813, 44428, 'CDC42P4', 'cell division cycle 42 pseudogene 4', 'pseudogene', 'ENSG00000249965'),
(814, 17719, 'CDC42SE1', 'CDC42 small effector 1', 'protein-coding gene', 'ENSG00000197622'),
(815, 1739, 'CDC45', 'cell division cycle 45', 'protein-coding gene', 'ENSG00000093009'),
(816, 49770, 'CDCA4P1', 'cell division cycle associated 4 pseudogene 1', 'pseudogene', 'ENSG00000229029'),
(817, 49772, 'CDCA4P3', 'cell division cycle associated 4 pseudogene 3', 'pseudogene', 'ENSG00000226289'),
(818, 14626, 'CDCA5', 'cell division cycle associated 5', 'protein-coding gene', 'ENSG00000146670'),
(819, 14628, 'CDCA7', 'cell division cycle associated 7', 'protein-coding gene', 'ENSG00000144354'),
(820, 53088, 'CDH18-AS1', 'CDH18 antisense RNA 1', 'non-coding RNA', 'ENSG00000249854'),
(821, 1760, 'CDH20', 'cadherin 20', 'protein-coding gene', 'ENSG00000101542'),
(822, 15902, 'CDH26', 'cadherin 26', 'protein-coding gene', 'ENSG00000124215'),
(823, 7521, 'CDHR5', 'cadherin related family member 5', 'protein-coding gene', 'ENSG00000099834'),
(824, 48609, 'CDIPTOSP', 'CDIP transferase opposite strand, pseudogene', 'pseudogene', 'ENSG00000214725'),
(825, 1773, 'CDK4', 'cyclin dependent kinase 4', 'protein-coding gene', 'ENSG00000135446'),
(826, 18614, 'CDK7P1', 'cyclin dependent kinase 7 pseudogene 1', 'pseudogene', 'ENSG00000213194'),
(827, 18995, 'CDK8P1', 'cyclin dependent kinase 8 pseudogene 1', 'pseudogene', 'ENSG00000230044'),
(828, 24224, 'CDK12', 'cyclin dependent kinase 12', 'protein-coding gene', 'ENSG00000167258'),
(829, 8751, 'CDK18', 'cyclin dependent kinase 18', 'protein-coding gene', 'ENSG00000117266'),
(830, 19338, 'CDK19', 'cyclin dependent kinase 19', 'protein-coding gene', 'ENSG00000155111'),
(831, 23831, 'CDKN2A-DT', 'CDKN2A divergent transcript', 'non-coding RNA', 'ENSG00000224854'),
(832, 1791, 'CDKN3', 'cyclin dependent kinase inhibitor 3', 'protein-coding gene', 'ENSG00000100526'),
(833, 24913, 'CDNF', 'cerebral dopamine neurotrophic factor', 'protein-coding gene', 'ENSG00000185267'),
(834, 54763, 'CDPF1P1', 'CDPF1 pseudogene 1', 'pseudogene', 'ENSG00000227799'),
(835, 1799, 'CDR2', 'cerebellar degeneration related protein 2', 'protein-coding gene', 'ENSG00000140743'),
(836, 29999, 'CDR2L', 'cerebellar degeneration related protein 2 like', 'protein-coding gene', 'ENSG00000109089'),
(837, 33824, 'CDRT15P3', 'CDRT15 pseudogene 3', 'pseudogene', 'ENSG00000186825'),
(838, 1806, 'CDX2', 'caudal type homeobox 2', 'protein-coding gene', 'ENSG00000165556'),
(839, 1808, 'CDX4', 'caudal type homeobox 4', 'protein-coding gene', 'ENSG00000131264'),
(840, 1809, 'CDY1', 'chromodomain Y-linked 1', 'protein-coding gene', 'ENSG00000172288'),
(841, 23872, 'CDY4P', 'chromodomain Y-linked 4 pseudogene', 'pseudogene', 'ENSG00000228411'),
(842, 23853, 'CDY6P', 'chromodomain Y-linked 6 pseudogene', 'pseudogene', 'ENSG00000229138'),
(843, 23848, 'CDY10P', 'chromodomain Y-linked 10 pseudogene', 'pseudogene', 'ENSG00000226042'),
(844, 23857, 'CDY13P', 'chromodomain Y-linked 13 pseudogene', 'pseudogene', 'ENSG00000224873'),
(845, 23859, 'CDY15P', 'chromodomain Y-linked 15 pseudogene', 'pseudogene', 'ENSG00000223362'),
(846, 23862, 'CDY18P', 'chromodomain Y-linked 18 pseudogene', 'pseudogene', 'ENSG00000232205'),
(847, 23030, 'CDYL2', 'chromodomain Y like 2', 'protein-coding gene', 'ENSG00000166446'),
(848, 28834, 'CEACAM21', 'CEA cell adhesion molecule 21', 'protein-coding gene', 'ENSG00000007129'),
(849, 38029, 'CEACAM22P', 'CEA cell adhesion molecule 22, pseudogene', 'pseudogene', 'ENSG00000230666'),
(850, 1827, 'CEACAMP5', 'CEA cell adhesion molecule pseudogene 5', 'pseudogene', 'ENSG00000231561'),
(851, 1829, 'CEACAMP7', 'CEA cell adhesion molecule pseudogene 7', 'pseudogene', 'ENSG00000227349'),
(852, 1831, 'CEACAMP9', 'CEA cell adhesion molecule pseudogene 9', 'pseudogene', 'ENSG00000230529'),
(853, 1836, 'CEBPE', 'CCAAT enhancer binding protein epsilon', 'protein-coding gene', 'ENSG00000092067'),
(854, 15944, 'CELA3A', 'chymotrypsin like elastase 3A', 'protein-coding gene', 'ENSG00000142789'),
(855, 1849, 'CELP', 'carboxyl ester lipase pseudogene', 'pseudogene', 'ENSG00000170827'),
(856, 28421, 'CENPBD2P', 'CENPB DNA-binding domains containing 2, pseudogene', 'pseudogene', 'ENSG00000213753'),
(857, 3968, 'CENPI', 'centromere protein I', 'protein-coding gene', 'ENSG00000102384'),
(858, 17272, 'CENPJ', 'centromere protein J', 'protein-coding gene', 'ENSG00000151849'),
(859, 29479, 'CENPK', 'centromere protein K', 'protein-coding gene', 'ENSG00000123219'),
(860, 49889, 'CENPUP1', 'centromere protein U pseudogene 1', 'pseudogene', 'ENSG00000255075'),
(861, 43879, 'CENPVL2', 'centromere protein V like 2', 'protein-coding gene', 'ENSG00000283093'),
(862, 21488, 'CENPW', 'centromere protein W', 'protein-coding gene', 'ENSG00000203760'),
(863, 26435, 'CEP20', 'centrosomal protein 20', 'protein-coding gene', 'ENSG00000133393'),
(864, 17966, 'CEP83', 'centrosomal protein 83', 'protein-coding gene', 'ENSG00000173588'),
(865, 25141, 'CEP95', 'centrosomal protein 95', 'protein-coding gene', 'ENSG00000258890'),
(866, 26244, 'CEP97', 'centrosomal protein 97', 'protein-coding gene', 'ENSG00000182504'),
(867, 55313, 'CEP192-DT', 'CEP192 divergent transcript', 'non-coding RNA', 'ENSG00000266969'),
(868, 29021, 'CEP290', 'centrosomal protein 290', 'protein-coding gene', 'ENSG00000198707'),
(869, 24289, 'CEPT1', 'choline/ethanolamine phosphotransferase 1', 'protein-coding gene', 'ENSG00000134255'),
(870, 51431, 'CERS3-AS1', 'CERS3 antisense RNA 1', 'non-coding RNA', 'ENSG00000259430'),
(871, 44485, 'CERS6-AS1', 'CERS6 antisense RNA 1', 'non-coding RNA', 'ENSG00000227617'),
(872, 48928, 'CES1P2', 'carboxylesterase 1 pseudogene 2', 'pseudogene', 'ENSG00000260765'),
(873, 1865, 'CES3', 'carboxylesterase 3', 'protein-coding gene', 'ENSG00000172828'),
(874, 17229, 'CFAP45', 'cilia and flagella associated protein 45', 'protein-coding gene', 'ENSG00000213085'),
(875, 45243, 'CFAP58-DT', 'CFAP58 divergent transcript', 'non-coding RNA', 'ENSG00000231233'),
(876, 15872, 'CFAP61', 'cilia and flagella associated protein 61', 'protein-coding gene', 'ENSG00000089101'),
(877, 29368, 'CFAP74', 'cilia and flagella associated protein 74', 'protein-coding gene', 'ENSG00000142609'),
(878, 29231, 'CFAP92', 'cilia and flagella associated protein 92 (putative)', 'protein-coding gene', 'ENSG00000114656'),
(879, 51180, 'CFAP99', 'cilia and flagella associated protein 99', 'protein-coding gene', 'ENSG00000206113'),
(880, 26842, 'CFAP100', 'cilia and flagella associated protein 100', 'protein-coding gene', 'ENSG00000163885'),
(881, 26782, 'CFAP161', 'cilia and flagella associated protein 161', 'protein-coding gene', 'ENSG00000156206'),
(882, 21405, 'CFAP206', 'cilia and flagella associated protein 206', 'protein-coding gene', 'ENSG00000272514'),
(883, 25064, 'CFAP210', 'cilia and flagella associated protein 210', 'protein-coding gene', 'ENSG00000154479'),
(884, 33720, 'CFAP221', 'cilia and flagella associated protein 221', 'protein-coding gene', 'ENSG00000163075'),
(885, 32331, 'CFAP276', 'cilia and flagella associated protein 276', 'protein-coding gene', 'ENSG00000179902'),
(886, 54636, 'CFAP298-TCP10L', 'CFAP298-TCP10L readthrough', 'other', 'ENSG00000265590'),
(887, 18292, 'CFC1', 'cripto, FRL-1, cryptic family 1', 'protein-coding gene', 'ENSG00000136698'),
(888, 33983, 'CFC1B', 'cripto, FRL-1, cryptic family 1B', 'protein-coding gene', 'ENSG00000152093'),
(889, 2771, 'CFD', 'complement factor D', 'protein-coding gene', 'ENSG00000197766'),
(890, 4888, 'CFHR1', 'complement factor H related 1', 'protein-coding gene', 'ENSG00000244414'),
(891, 24668, 'CFHR5', 'complement factor H related 5', 'protein-coding gene', 'ENSG00000134389'),
(892, 1877, 'CFL1P5', 'cofilin 1 pseudogene 5', 'pseudogene', 'ENSG00000213830'),
(893, 1875, 'CFL2', 'cofilin 2', 'protein-coding gene', 'ENSG00000165410'),
(894, 1884, 'CFTR', 'CF transmembrane conductance regulator', 'protein-coding gene', 'ENSG00000001626'),
(895, 1885, 'CGA', 'glycoprotein hormones, alpha polypeptide', 'protein-coding gene', 'ENSG00000135346'),
(896, 21367, 'CGAS', 'cyclic GMP-AMP synthase', 'protein-coding gene', 'ENSG00000164430'),
(897, 16722, 'CGB2', 'chorionic gonadotropin subunit beta 2', 'protein-coding gene', 'ENSG00000104818'),
(898, 16453, 'CGB8', 'chorionic gonadotropin subunit beta 8', 'protein-coding gene', 'ENSG00000213030'),
(899, 17429, 'CGN', 'cingulin', 'protein-coding gene', 'ENSG00000143375'),
(900, 1909, 'CHAD', 'chondroadherin', 'protein-coding gene', 'ENSG00000136457'),
(901, 1910, 'CHAF1A', 'chromatin assembly factor 1 subunit A', 'protein-coding gene', 'ENSG00000167670'),
(902, 20311, 'CHAMP1', 'chromosome alignment maintaining phosphoprotein 1', 'protein-coding gene', 'ENSG00000198824'),
(903, 39585, 'CHCHD2P1', 'coiled-coil-helix-coiled-coil-helix domain containing 2 pseudogene 1', 'pseudogene', 'ENSG00000226902'),
(904, 39587, 'CHCHD2P3', 'coiled-coil-helix-coiled-coil-helix domain containing 2 pseudogene 3', 'pseudogene', 'ENSG00000270849'),
(905, 39592, 'CHCHD2P8', 'coiled-coil-helix-coiled-coil-helix domain containing 2 pseudogene 8', 'pseudogene', 'ENSG00000235115'),
(906, 49029, 'CHCHD2P11', 'coiled-coil-helix-coiled-coil-helix domain containing 2 pseudogene 11', 'pseudogene', 'ENSG00000270809'),
(907, 44493, 'CHCHD4P5', 'coiled-coil-helix-coiled-coil-helix domain containing 4 pseudogene 5', 'pseudogene', 'ENSG00000225222'),
(908, 17840, 'CHCHD5', 'coiled-coil-helix-coiled-coil-helix domain containing 5', 'protein-coding gene', 'ENSG00000125611'),
(909, 1915, 'CHD1', 'chromodomain helicase DNA binding protein 1', 'protein-coding gene', 'ENSG00000153922'),
(910, 1917, 'CHD2', 'chromodomain helicase DNA binding protein 2', 'protein-coding gene', 'ENSG00000173575'),
(911, 1918, 'CHD3', 'chromodomain helicase DNA binding protein 3', 'protein-coding gene', 'ENSG00000170004'),
(912, 1919, 'CHD4', 'chromodomain helicase DNA binding protein 4', 'protein-coding gene', 'ENSG00000111642'),
(913, 25701, 'CHD9', 'chromodomain helicase DNA binding protein 9', 'protein-coding gene', 'ENSG00000177200'),
(914, 43578, 'CHEK2P2', 'CHEK2 pseudogene 2', 'pseudogene', 'ENSG00000259156'),
(915, 1929, 'CHGA', 'chromogranin A', 'protein-coding gene', 'ENSG00000100604'),
(916, 44462, 'CHIAP1', 'chitinase, acidic pseudogene 1', 'pseudogene', 'ENSG00000236040'),
(917, 1939, 'CHL1', 'cell adhesion molecule L1 like', 'protein-coding gene', 'ENSG00000134121'),
(918, 29865, 'CHMP3', 'charged multivesicular body protein 3', 'protein-coding gene', 'ENSG00000115561'),
(919, 20274, 'CHMP4A', 'charged multivesicular body protein 4A', 'protein-coding gene', 'ENSG00000254505'),
(920, 26942, 'CHMP5', 'charged multivesicular body protein 5', 'protein-coding gene', 'ENSG00000086065'),
(921, 28439, 'CHMP7', 'charged multivesicular body protein 7', 'protein-coding gene', 'ENSG00000147457'),
(922, 1279, 'CHODL-AS1', 'CHODL antisense RNA 1', 'non-coding RNA', 'ENSG00000231755'),
(923, 14525, 'CHORDC1', 'cysteine and histidine rich domain containing 1', 'protein-coding gene', 'ENSG00000110172'),
(924, 54690, 'CHORDC1P5', 'CHORDC1 pseudogene 5', 'pseudogene', 'ENSG00000233020'),
(925, 54896, 'CHP1P2', 'CHP1 pseudogene 2', 'pseudogene', 'ENSG00000213073'),
(926, 1952, 'CHRM3', 'cholinergic receptor muscarinic 3', 'protein-coding gene', 'ENSG00000133019'),
(927, 15963, 'CHRNA6', 'cholinergic receptor nicotinic alpha 6 subunit', 'protein-coding gene', 'ENSG00000147434'),
(928, 1960, 'CHRNA7', 'cholinergic receptor nicotinic alpha 7 subunit', 'protein-coding gene', 'ENSG00000175344'),
(929, 1966, 'CHRNE', 'cholinergic receptor nicotinic epsilon subunit', 'protein-coding gene', 'ENSG00000108556'),
(930, 1970, 'CHST2', 'carbohydrate sulfotransferase 2', 'protein-coding gene', 'ENSG00000175040'),
(931, 13817, 'CHST7', 'carbohydrate sulfotransferase 7', 'protein-coding gene', 'ENSG00000147119'),
(932, 19650, 'CHST10', 'carbohydrate sulfotransferase 10', 'protein-coding gene', 'ENSG00000115526'),
(933, 17423, 'CHST12', 'carbohydrate sulfotransferase 12', 'protein-coding gene', 'ENSG00000136213'),
(934, 24353, 'CHTF8', 'chromosome transmission fidelity factor 8', 'protein-coding gene', 'ENSG00000168802'),
(935, 18435, 'CHTF18', 'chromosome transmission fidelity factor 18', 'protein-coding gene', 'ENSG00000127586'),
(936, 24511, 'CHTOP', 'chromatin target of PRMT1', 'protein-coding gene', 'ENSG00000160679'),
(937, 25200, 'CIART', 'circadian associated repressor of transcription', 'protein-coding gene', 'ENSG00000159208'),
(938, 24579, 'CIB2', 'calcium and integrin binding family member 2', 'protein-coding gene', 'ENSG00000136425'),
(939, 30452, 'CIBAR1', 'CBY1 interacting BAR domain containing 1', 'protein-coding gene', 'ENSG00000188343'),
(940, 24781, 'CIBAR2', 'CBY1 interacting BAR domain containing 2', 'protein-coding gene', 'ENSG00000153789'),
(941, 37742, 'CICP3', 'capicua transcriptional repressor pseudogene 3', 'pseudogene', 'ENSG00000229376'),
(942, 37756, 'CICP7', 'capicua transcriptional repressor pseudogene 7', 'pseudogene', 'ENSG00000233653'),
(943, 37757, 'CICP8', 'capicua transcriptional repressor pseudogene 8', 'pseudogene', 'ENSG00000225371'),
(944, 37905, 'CICP12', 'capicua transcriptional repressor pseudogene 12', 'pseudogene', 'ENSG00000225270'),
(945, 37907, 'CICP13', 'capicua transcriptional repressor pseudogene 13', 'pseudogene', 'ENSG00000234419'),
(946, 48827, 'CICP17', 'capicua transcriptional repressor pseudogene 17', 'pseudogene', 'ENSG00000227233'),
(947, 48828, 'CICP18', 'capicua transcriptional repressor pseudogene 18', 'pseudogene', 'ENSG00000217929'),
(948, 48829, 'CICP19', 'capicua transcriptional repressor pseudogene 19', 'pseudogene', 'ENSG00000282059'),
(949, 48834, 'CICP26', 'capicua transcriptional repressor pseudogene 26', 'pseudogene', 'ENSG00000233003'),
(950, 1980, 'CILP', 'cartilage intermediate layer protein', 'protein-coding gene', 'ENSG00000138615'),
(951, 1984, 'CISH', 'cytokine inducible SH2 containing protein', 'protein-coding gene', 'ENSG00000114737'),
(952, 17395, 'CKS1BP4', 'CDC28 protein kinase regulatory subunit 1B pseudogene 4', 'pseudogene', 'ENSG00000255541'),
(953, 1999, 'CKS1BP7', 'CDC28 protein kinase regulatory subunit 1B pseudogene 7', 'pseudogene', 'ENSG00000254331'),
(954, 17088, 'CLASP1', 'cytoplasmic linker associated protein 1', 'protein-coding gene', 'ENSG00000074054'),
(955, 17731, 'CLASRP', 'CLK4 associating serine/arginine rich protein', 'protein-coding gene', 'ENSG00000104859'),
(956, 54055, 'CLCA4-AS1', 'CLCA4 antisense RNA 1', 'non-coding RNA', 'ENSG00000236915'),
(957, 2024, 'CLCN6', 'chloride voltage-gated channel 6', 'protein-coding gene', 'ENSG00000011021'),
(958, 2046, 'CLDN4', 'claudin 4', 'protein-coding gene', 'ENSG00000189143'),
(959, 55953, 'CLDN14-AS1', 'CLDN14 antisense RNA 1', 'non-coding RNA', 'ENSG00000233818'),
(960, 2036, 'CLDN15', 'claudin 15', 'protein-coding gene', 'ENSG00000106404'),
(961, 2040, 'CLDN19', 'claudin 19', 'protein-coding gene', 'ENSG00000164007'),
(962, 1322, 'CLDND1', 'claudin domain containing 1', 'protein-coding gene', 'ENSG00000080822'),
(963, 2053, 'CLEC2B', 'C-type lectin domain family 2 member B', 'protein-coding gene', 'ENSG00000110852'),
(964, 11891, 'CLEC3B', 'C-type lectin domain family 3 member B', 'protein-coding gene', 'ENSG00000163815'),
(965, 24591, 'CLEC4G', 'C-type lectin domain family 4 member G', 'protein-coding gene', 'ENSG00000182566'),
(966, 52651, 'CLEC4OP', 'C-type lectin domain family 4 member O, pseudogene', 'pseudogene', 'ENSG00000267453'),
(967, 14558, 'CLEC7A', 'C-type lectin domain containing 7A', 'protein-coding gene', 'ENSG00000172243'),
(968, 26705, 'CLEC9A', 'C-type lectin domain containing 9A', 'protein-coding gene', 'ENSG00000197992'),
(969, 53407, 'CLEC12A-AS1', 'CLEC12A antisense RNA 1', 'non-coding RNA', 'ENSG00000231560'),
(970, 2065, 'CLIC6', 'chloride intracellular channel 6', 'protein-coding gene', 'ENSG00000159212'),
(971, 23186, 'CLINT1', 'clathrin interactor 1', 'protein-coding gene', 'ENSG00000113282'),
(972, 2068, 'CLK1', 'CDC like kinase 1', 'protein-coding gene', 'ENSG00000013441'),
(973, 2069, 'CLK2', 'CDC like kinase 2', 'protein-coding gene', 'ENSG00000176444'),
(974, 49786, 'CLK3P2', 'CDC like kinase 3 pseudogene 2', 'pseudogene', 'ENSG00000226191'),
(975, 52287, 'CLMAT3', 'colorectal liver metastasis associated transcript 3', 'non-coding RNA', 'ENSG00000249035'),
(976, 24039, 'CLMP', 'CXADR like membrane protein', 'protein-coding gene', 'ENSG00000166250'),
(977, 2079, 'CLN8', 'CLN8 transmembrane ER and ERGIC protein', 'protein-coding gene', 'ENSG00000182372'),
(978, 2081, 'CLNS1AP1', 'chloride nucleotide-sensitive channel 1A pseudogene 1', 'pseudogene', 'ENSG00000213335'),
(979, 21250, 'CLPSL2', 'colipase like 2', 'protein-coding gene', 'ENSG00000196748'),
(980, 30895, 'CLRN1-AS1', 'CLRN1 antisense RNA 1', 'non-coding RNA', 'ENSG00000239265'),
(981, 17447, 'CLSTN1', 'calsyntenin 1', 'protein-coding gene', 'ENSG00000171603'),
(982, 2092, 'CLTC', 'clathrin heavy chain', 'protein-coding gene', 'ENSG00000141367'),
(983, 19009, 'CLUAP1', 'clusterin associated protein 1', 'protein-coding gene', 'ENSG00000103351'),
(984, 38416, 'CLUHP1', 'clustered mitochondria homolog pseudogene 1', 'pseudogene', 'ENSG00000238191'),
(985, 38453, 'CLUHP2', 'clustered mitochondria homolog pseudogene 2', 'pseudogene', 'ENSG00000228945'),
(986, 38470, 'CLUHP4', 'clustered mitochondria homolog pseudogene 4', 'pseudogene', 'ENSG00000249003'),
(987, 39894, 'CLYBL-AS2', 'CLYBL antisense RNA 2', 'non-coding RNA', 'ENSG00000227659'),
(988, 24447, 'CMC2', 'C-X9-C motif containing 2', 'protein-coding gene', 'ENSG00000103121'),
(989, 2121, 'CMKLR1', 'chemerin chemokine-like receptor 1', 'protein-coding gene', 'ENSG00000174600'),
(990, 48602, 'CMKLR2-AS', 'CMKLR2 antisense RNA', 'non-coding RNA', 'ENSG00000279220'),
(991, 28666, 'CMSS1', 'cms1 ribosomal small subunit homolog', 'protein-coding gene', 'ENSG00000184220'),
(992, 19173, 'CMTM2', 'CKLF like MARVEL transmembrane domain containing 2', 'protein-coding gene', 'ENSG00000140932'),
(993, 19178, 'CMTM7', 'CKLF like MARVEL transmembrane domain containing 7', 'protein-coding gene', 'ENSG00000153551'),
(994, 21077, 'CMTR1', 'cap methyltransferase 1', 'protein-coding gene', 'ENSG00000137200'),
(995, 13164, 'CNBP', 'CCHC-type zinc finger nucleic acid binding protein', 'protein-coding gene', 'ENSG00000169714'),
(996, 55037, 'CNEP1R1P1', 'CNEP1R1 pseudogene 1', 'pseudogene', 'ENSG00000180284'),
(997, 23034, 'CNKSR3', 'CNKSR family member 3', 'protein-coding gene', 'ENSG00000153721'),
(998, 2155, 'CNN1', 'calponin 1', 'protein-coding gene', 'ENSG00000130176'),
(999, 39531, 'CNN2P6', 'calponin 2 pseudogene 6', 'pseudogene', 'ENSG00000213854'),
(1000, 39532, 'CNN2P7', 'calponin 2 pseudogene 7', 'pseudogene', 'ENSG00000215562'),
(1001, 39533, 'CNN2P8', 'calponin 2 pseudogene 8', 'pseudogene', 'ENSG00000213355'),
(1002, 39834, 'CNN2P12', 'calponin 2 pseudogene 12', 'pseudogene', 'ENSG00000204718'),
(1003, 54176, 'CNN3-DT', 'CNN3 divergent transcript', 'non-coding RNA', 'ENSG00000235501'),
(1004, 104, 'CNNM3', 'cyclin and CBS domain divalent metal cation transport mediator 3', 'protein-coding gene', 'ENSG00000168763'),
(1005, 44248, 'CNOT7P1', 'CCR4-NOT transcription complex subunit 7 pseudogene 1', 'pseudogene', 'ENSG00000233229'),
(1006, 10445, 'CNOT9', 'CCR4-NOT transcription complex subunit 9', 'protein-coding gene', 'ENSG00000144580'),
(1007, 25217, 'CNOT11', 'CCR4-NOT transcription complex subunit 11', 'protein-coding gene', 'ENSG00000158435'),
(1008, 11968, 'CNPY3', 'canopy FGF signaling regulator 3', 'protein-coding gene', 'ENSG00000137161'),
(1009, 26847, 'CNTD1', 'cyclin N-terminal domain containing 1', 'protein-coding gene', 'ENSG00000176563'),
(1010, 48712, 'CNTFR-AS1', 'CNTFR antisense RNA 1', 'non-coding RNA', 'ENSG00000237159'),
(1011, 23432, 'CNTLN', 'centlein', 'protein-coding gene', 'ENSG00000044459'),
(1012, 2176, 'CNTN6', 'contactin 6', 'protein-coding gene', 'ENSG00000134115'),
(1013, 53878, 'CNTNAP3C', 'contactin associated protein family member 3C', 'protein-coding gene', 'ENSG00000283378'),
(1014, 18747, 'CNTNAP4', 'contactin associated protein family member 4', 'protein-coding gene', 'ENSG00000152910'),
(1015, 24604, 'COA4', 'cytochrome c oxidase assembly factor 4 homolog', 'protein-coding gene', 'ENSG00000181924'),
(1016, 40825, 'COA6-AS1', 'COA6 antisense RNA 1', 'non-coding RNA', 'ENSG00000231663'),
(1017, 29932, 'COASY', 'Coenzyme A synthase', 'protein-coding gene', 'ENSG00000068120'),
(1018, 6545, 'COG1', 'component of oligomeric golgi complex 1', 'protein-coding gene', 'ENSG00000166685'),
(1019, 2197, 'COL1A1', 'collagen type I alpha 1 chain', 'protein-coding gene', 'ENSG00000108821'),
(1020, 39849, 'COL4A2-AS2', 'COL4A2 antisense RNA 2', 'non-coding RNA', 'ENSG00000224821'),
(1021, 2207, 'COL4A5', 'collagen type IV alpha 5 chain', 'protein-coding gene', 'ENSG00000188153'),
(1022, 31368, 'COL5A1-AS1', 'COL5A1 antisense RNA 1', 'non-coding RNA', 'ENSG00000204011');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(1023, 14864, 'COL5A3', 'collagen type V alpha 3 chain', 'protein-coding gene', 'ENSG00000080573'),
(1024, 2211, 'COL6A1', 'collagen type VI alpha 1 chain', 'protein-coding gene', 'ENSG00000142156'),
(1025, 55814, 'COL6A2-DT', 'COL6A2 divergent transcript', 'non-coding RNA', 'ENSG00000227438'),
(1026, 27023, 'COL6A6', 'collagen type VI alpha 6 chain', 'protein-coding gene', 'ENSG00000206384'),
(1027, 2214, 'COL7A1', 'collagen type VII alpha 1 chain', 'protein-coding gene', 'ENSG00000114270'),
(1028, 2187, 'COL11A2', 'collagen type XI alpha 2 chain', 'protein-coding gene', 'ENSG00000204248'),
(1029, 2188, 'COL12A1', 'collagen type XII alpha 1 chain', 'protein-coding gene', 'ENSG00000111799'),
(1030, 2195, 'COL18A1', 'collagen type XVIII alpha 1 chain', 'protein-coding gene', 'ENSG00000182871'),
(1031, 2196, 'COL19A1', 'collagen type XIX alpha 1 chain', 'protein-coding gene', 'ENSG00000082293'),
(1032, 22989, 'COL22A1', 'collagen type XXII alpha 1 chain', 'protein-coding gene', 'ENSG00000169436'),
(1033, 22986, 'COL27A1', 'collagen type XXVII alpha 1 chain', 'protein-coding gene', 'ENSG00000196739'),
(1034, 16016, 'COLEC12', 'collectin subfamily member 12', 'protein-coding gene', 'ENSG00000158270'),
(1035, 26182, 'COLGALT1', 'collagen beta(1-O)galactosyltransferase 1', 'protein-coding gene', 'ENSG00000130309'),
(1036, 48326, 'COMMD3-BMI1', 'COMMD3-BMI1 readthrough', 'other', 'ENSG00000269897'),
(1037, 2228, 'COMT', 'catechol-O-methyltransferase', 'protein-coding gene', 'ENSG00000093010'),
(1038, 17440, 'COP1', 'COP1 E3 ubiquitin ligase', 'protein-coding gene', 'ENSG00000143207'),
(1039, 31900, 'COP1P1', 'COP1 pseudogene 1', 'pseudogene', 'ENSG00000266613'),
(1040, 2230, 'COPA', 'COPI coat complex subunit alpha', 'protein-coding gene', 'ENSG00000122218'),
(1041, 2237, 'COPG2', 'COPI coat complex subunit gamma 2', 'protein-coding gene', 'ENSG00000158623'),
(1042, 54677, 'COPRSP1', 'COPRS pseudogene 1', 'pseudogene', 'ENSG00000236440'),
(1043, 30747, 'COPS2', 'COP9 signalosome subunit 2', 'protein-coding gene', 'ENSG00000166200'),
(1044, 21749, 'COPS6', 'COP9 signalosome subunit 6', 'protein-coding gene', 'ENSG00000168090'),
(1045, 16760, 'COPS7B', 'COP9 signalosome subunit 7B', 'protein-coding gene', 'ENSG00000144524'),
(1046, 2243, 'COPZ1', 'COPI coat complex subunit zeta 1', 'protein-coding gene', 'ENSG00000111481'),
(1047, 19693, 'COQ4', 'coenzyme Q4', 'protein-coding gene', 'ENSG00000167113'),
(1048, 2244, 'COQ7', 'coenzyme Q7, hydroxylase', 'protein-coding gene', 'ENSG00000167186'),
(1049, 16812, 'COQ8A', 'coenzyme Q8A', 'protein-coding gene', 'ENSG00000163050'),
(1050, 25302, 'COQ9', 'coenzyme Q9', 'protein-coding gene', 'ENSG00000088682'),
(1051, 55367, 'CORO1A-AS1', 'CORO1A antisense RNA 1', 'non-coding RNA', 'ENSG00000261416'),
(1052, 2254, 'CORO1C', 'coronin 1C', 'protein-coding gene', 'ENSG00000110880'),
(1053, 2255, 'CORO2A', 'coronin 2A', 'protein-coding gene', 'ENSG00000106789'),
(1054, 38036, 'COX4I1P2', 'cytochrome c oxidase subunit 4I1 pseudogene 2', 'pseudogene', 'ENSG00000228869'),
(1055, 2267, 'COX5A', 'cytochrome c oxidase subunit 5A', 'protein-coding gene', 'ENSG00000178741'),
(1056, 2272, 'COX5BP3', 'cytochrome c oxidase subunit 5B pseudogene 3', 'pseudogene', 'ENSG00000235967'),
(1057, 2276, 'COX5BP7', 'cytochrome c oxidase subunit 5B pseudogene 7', 'pseudogene', 'ENSG00000226024'),
(1058, 39083, 'COX5BP8', 'cytochrome c oxidase subunit 5B pseudogene 8', 'pseudogene', 'ENSG00000223794'),
(1059, 2277, 'COX6A1', 'cytochrome c oxidase subunit 6A1', 'protein-coding gene', 'ENSG00000111775'),
(1060, 35239, 'COX6A1P2', 'cytochrome c oxidase subunit 6A1 pseudogene 2', 'pseudogene', 'ENSG00000226976'),
(1061, 2280, 'COX6B1', 'cytochrome c oxidase subunit 6B1', 'protein-coding gene', 'ENSG00000126267'),
(1062, 2281, 'COX6B1P1', 'cytochrome c oxidase subunit 6B1 pseudogene 1', 'pseudogene', 'ENSG00000234565'),
(1063, 2284, 'COX6B1P4', 'cytochrome c oxidase subunit 6B1 pseudogene 4', 'pseudogene', 'ENSG00000253813'),
(1064, 24380, 'COX6B2', 'cytochrome c oxidase subunit 6B2', 'protein-coding gene', 'ENSG00000160471'),
(1065, 49364, 'COX6CP12', 'cytochrome c oxidase subunit 6C pseudogene 12', 'pseudogene', 'ENSG00000234463'),
(1066, 49366, 'COX6CP14', 'cytochrome c oxidase subunit 6C pseudogene 14', 'pseudogene', 'ENSG00000239576'),
(1067, 49367, 'COX6CP16', 'cytochrome c oxidase subunit 6C pseudogene 16', 'pseudogene', 'ENSG00000270313'),
(1068, 2293, 'COX7CP1', 'cytochrome c oxidase subunit 7C pseudogene 1', 'pseudogene', 'ENSG00000235957'),
(1069, 2294, 'COX8A', 'cytochrome c oxidase subunit 8A', 'protein-coding gene', 'ENSG00000176340'),
(1070, 2264, 'COX17', 'cytochrome c oxidase copper chaperone COX17', 'protein-coding gene', 'ENSG00000138495'),
(1071, 2295, 'CP', 'ceruloplasmin', 'protein-coding gene', 'ENSG00000047457'),
(1072, 2296, 'CPA1', 'carboxypeptidase A1', 'protein-coding gene', 'ENSG00000091704'),
(1073, 2303, 'CPE', 'carboxypeptidase E', 'protein-coding gene', 'ENSG00000109472'),
(1074, 27523, 'CPEB1-AS1', 'CPEB1 antisense RNA 1', 'non-coding RNA', 'ENSG00000259462'),
(1075, 53937, 'CPNE8-AS1', 'CPNE8 antisense RNA 1', 'non-coding RNA', 'ENSG00000257718'),
(1076, 2322, 'CPP', 'ceruloplasmin pseudogene', 'pseudogene', 'ENSG00000253525'),
(1077, 2325, 'CPSF2', 'cleavage and polyadenylation specific factor 2', 'protein-coding gene', 'ENSG00000165934'),
(1078, 33632, 'CPSF4L', 'cleavage and polyadenylation specific factor 4 like', 'protein-coding gene', 'ENSG00000187959'),
(1079, 2329, 'CPT1B', 'carnitine palmitoyltransferase 1B', 'protein-coding gene', 'ENSG00000205560'),
(1080, 14399, 'CPVL', 'carboxypeptidase vitellogenic like', 'protein-coding gene', 'ENSG00000106066'),
(1081, 2336, 'CR2', 'complement C3d receptor 2', 'protein-coding gene', 'ENSG00000117322'),
(1082, 2345, 'CREB1', 'cAMP responsive element binding protein 1', 'protein-coding gene', 'ENSG00000118260'),
(1083, 18854, 'CREB3L4', 'cAMP responsive element binding protein 3 like 4', 'protein-coding gene', 'ENSG00000143578'),
(1084, 2348, 'CREBBP', 'CREB binding protein', 'protein-coding gene', 'ENSG00000005339'),
(1085, 2358, 'CRHR2', 'corticotropin releasing hormone receptor 2', 'protein-coding gene', 'ENSG00000106113'),
(1086, 2360, 'CRIP1', 'cysteine rich protein 1', 'protein-coding gene', 'ENSG00000213145'),
(1087, 18206, 'CRISPLD1', 'cysteine rich secretory protein LCCL domain containing 1', 'protein-coding gene', 'ENSG00000121005'),
(1088, 1230, 'CRNN', 'cornulin', 'protein-coding gene', 'ENSG00000143536'),
(1089, 51677, 'CROCC2', 'ciliary rootlet coiled-coil, rootletin family member 2', 'protein-coding gene', 'ENSG00000226321'),
(1090, 2367, 'CRP', 'C-reactive protein', 'protein-coding gene', 'ENSG00000132693'),
(1091, 2400, 'CRYBB3', 'crystallin beta B3', 'protein-coding gene', 'ENSG00000100053'),
(1092, 2414, 'CRYGGP', 'crystallin gamma G, pseudogene', 'pseudogene', 'ENSG00000223710'),
(1093, 53757, 'CRYZL2P-SEC16B', 'CRYZL2P-SEC16B readthrough', 'other', 'ENSG00000254154'),
(1094, 2422, 'CS', 'citrate synthase', 'protein-coding gene', 'ENSG00000062485'),
(1095, 2436, 'CSF2RB', 'colony stimulating factor 2 receptor subunit beta', 'protein-coding gene', 'ENSG00000100368'),
(1096, 2438, 'CSF3', 'colony stimulating factor 3', 'protein-coding gene', 'ENSG00000108342'),
(1097, 55174, 'CSGALNACT2-DT', 'CSGALNACT2 divergent transcript', 'non-coding RNA', 'ENSG00000273008'),
(1098, 55033, 'CSGALNACT2P1', 'CSGALNACT2 pseudogene 1', 'pseudogene', 'ENSG00000182574'),
(1099, 2444, 'CSK', 'C-terminal Src kinase', 'protein-coding gene', 'ENSG00000103653'),
(1100, 33113, 'CSKMT', 'citrate synthase lysine methyltransferase', 'protein-coding gene', 'ENSG00000214756'),
(1101, 14026, 'CSMD1', 'CUB and Sushi multiple domains 1', 'protein-coding gene', 'ENSG00000183117'),
(1102, 19291, 'CSMD3', 'CUB and Sushi multiple domains 3', 'protein-coding gene', 'ENSG00000164796'),
(1103, 2445, 'CSN1S1', 'casein alpha s1', 'protein-coding gene', 'ENSG00000126545'),
(1104, 20230, 'CSN1S2AP', 'casein alpha s2 like A, pseudogene', 'pseudogene', 'ENSG00000234124'),
(1105, 2453, 'CSNK1E', 'casein kinase 1 epsilon', 'protein-coding gene', 'ENSG00000213923'),
(1106, 2455, 'CSNK1G2', 'casein kinase 1 gamma 2', 'protein-coding gene', 'ENSG00000133275'),
(1107, 32424, 'CSPG4P2Y', 'CSPG4 pseudogene 2 Y-linked', 'pseudogene', 'ENSG00000244231'),
(1108, 38535, 'CSPG4P4Y', 'CSPG4 pseudogene 4 Y-linked', 'pseudogene', 'ENSG00000172294'),
(1109, 29403, 'CSPG4P5', 'chondroitin sulfate proteoglycan 4 pseudogene 5', 'pseudogene', 'ENSG00000272887'),
(1110, 48361, 'CSPG4P10', 'chondroitin sulfate proteoglycan 4 pseudogene 10', 'pseudogene', 'ENSG00000276710'),
(1111, 2470, 'CSRP2', 'cysteine and glycine rich protein 2', 'protein-coding gene', 'ENSG00000175183'),
(1112, 2472, 'CSRP3', 'cysteine and glycine rich protein 3', 'protein-coding gene', 'ENSG00000129170'),
(1113, 2474, 'CST2', 'cystatin SA', 'protein-coding gene', 'ENSG00000170369'),
(1114, 45042, 'CST2P1', 'cystatin SA pseudogene 1', 'pseudogene', 'ENSG00000232595'),
(1115, 2475, 'CST3', 'cystatin C', 'protein-coding gene', 'ENSG00000101439'),
(1116, 2479, 'CST7', 'cystatin F', 'protein-coding gene', 'ENSG00000077984'),
(1117, 44335, 'CST13P', 'cystatin 13, pseudogene', 'pseudogene', 'ENSG00000204663'),
(1118, 2482, 'CSTB', 'cystatin B', 'protein-coding gene', 'ENSG00000160213'),
(1119, 2483, 'CSTF1', 'cleavage stimulation factor subunit 1', 'protein-coding gene', 'ENSG00000101138'),
(1120, 28400, 'CT45A2', 'cancer/testis antigen family 45 member A2', 'protein-coding gene', 'ENSG00000271449'),
(1121, 33285, 'CT47A4', 'cancer/testis antigen family 47 member A4', 'protein-coding gene', 'ENSG00000230594'),
(1122, 33290, 'CT47A9', 'cancer/testis antigen family 47 member A9', 'protein-coding gene', 'ENSG00000226600'),
(1123, 37195, 'CT70', 'cancer/testis associated transcript 70', 'non-coding RNA', 'ENSG00000230013'),
(1124, 37294, 'CTAGE8', 'CTAGE family member 8', 'protein-coding gene', 'ENSG00000244693'),
(1125, 2494, 'CTBP1', 'C-terminal binding protein 1', 'protein-coding gene', 'ENSG00000159692'),
(1126, 2495, 'CTBP2', 'C-terminal binding protein 2', 'protein-coding gene', 'ENSG00000175029'),
(1127, 23940, 'CTBP2P1', 'CTBP2 pseudogene 1', 'pseudogene', 'ENSG00000235857'),
(1128, 16234, 'CTCFL', 'CCCTC-binding factor like', 'protein-coding gene', 'ENSG00000124092'),
(1129, 26936, 'CTDSPL2', 'CTD small phosphatase like 2', 'protein-coding gene', 'ENSG00000137770'),
(1130, 2514, 'CTNNB1', 'catenin beta 1', 'protein-coding gene', 'ENSG00000168036'),
(1131, 2522, 'CTRB2', 'chymotrypsinogen B2', 'protein-coding gene', 'ENSG00000168928'),
(1132, 2527, 'CTSB', 'cathepsin B', 'protein-coding gene', 'ENSG00000164733'),
(1133, 2528, 'CTSC', 'cathepsin C', 'protein-coding gene', 'ENSG00000109861'),
(1134, 2540, 'CTSLP2', 'cathepsin L pseudogene 2', 'pseudogene', 'ENSG00000266217'),
(1135, 15679, 'CTTNBP2', 'cortactin binding protein 2', 'protein-coding gene', 'ENSG00000077063'),
(1136, 25330, 'CTTNBP2NL', 'CTTNBP2 N-terminal like', 'protein-coding gene', 'ENSG00000143079'),
(1137, 29590, 'CTU1', 'cytosolic thiouridylase subunit 1', 'protein-coding gene', 'ENSG00000142544'),
(1138, 31109, 'CTXN2', 'cortexin 2', 'protein-coding gene', 'ENSG00000233932'),
(1139, 2548, 'CUBN', 'cubilin', 'protein-coding gene', 'ENSG00000107611'),
(1140, 28352, 'CUEDC2', 'CUE domain containing 2', 'protein-coding gene', 'ENSG00000107874'),
(1141, 2552, 'CUL2', 'cullin 2', 'protein-coding gene', 'ENSG00000108094'),
(1142, 2553, 'CUL3', 'cullin 3', 'protein-coding gene', 'ENSG00000036257'),
(1143, 2555, 'CUL4B', 'cullin 4B', 'protein-coding gene', 'ENSG00000158290'),
(1144, 21101, 'CUTA', 'cutA divalent cation tolerance homolog', 'protein-coding gene', 'ENSG00000112514'),
(1145, 24271, 'CUTC', 'cutC copper transporter', 'protein-coding gene', 'ENSG00000119929'),
(1146, 26133, 'CWH43', 'cell wall biogenesis 43 C-terminal homolog', 'protein-coding gene', 'ENSG00000109182'),
(1147, 2558, 'CX3CR1', 'C-X3-C motif chemokine receptor 1', 'protein-coding gene', 'ENSG00000168329'),
(1148, 4602, 'CXCL1', 'C-X-C motif chemokine ligand 1', 'protein-coding gene', 'ENSG00000163739'),
(1149, 10642, 'CXCL5', 'C-X-C motif chemokine ligand 5', 'protein-coding gene', 'ENSG00000163735'),
(1150, 6025, 'CXCL8', 'C-X-C motif chemokine ligand 8', 'protein-coding gene', 'ENSG00000169429'),
(1151, 10638, 'CXCL11', 'C-X-C motif chemokine ligand 11', 'protein-coding gene', 'ENSG00000169248'),
(1152, 10639, 'CXCL13', 'C-X-C motif chemokine ligand 13', 'protein-coding gene', 'ENSG00000156234'),
(1153, 16647, 'CXCR6', 'C-X-C motif chemokine receptor 6', 'protein-coding gene', 'ENSG00000172215'),
(1154, 26356, 'CXORF58', 'chromosome X open reading frame 58', 'protein-coding gene', 'ENSG00000165182'),
(1155, 26943, 'CXXC5', 'CXXC finger protein 5', 'protein-coding gene', 'ENSG00000171604'),
(1156, 28471, 'CYB5D2', 'cytochrome b5 domain containing 2', 'protein-coding gene', 'ENSG00000167740'),
(1157, 24376, 'CYB5R2', 'cytochrome b5 reductase 2', 'protein-coding gene', 'ENSG00000166394'),
(1158, 26804, 'CYB561D1', 'cytochrome b561 family member D1', 'protein-coding gene', 'ENSG00000174151'),
(1159, 2578, 'CYBB', 'cytochrome b-245 beta chain', 'protein-coding gene', 'ENSG00000165168'),
(1160, 24416, 'CYCSP5', 'CYCS pseudogene 5', 'pseudogene', 'ENSG00000227735'),
(1161, 24421, 'CYCSP6', 'CYCS pseudogene 6', 'pseudogene', 'ENSG00000214429'),
(1162, 24394, 'CYCSP20', 'CYCS pseudogene 20', 'pseudogene', 'ENSG00000240416'),
(1163, 24396, 'CYCSP22', 'CYCS pseudogene 22', 'pseudogene', 'ENSG00000254358'),
(1164, 24401, 'CYCSP27', 'CYCS pseudogene 27', 'pseudogene', 'ENSG00000255444'),
(1165, 24402, 'CYCSP28', 'CYCS pseudogene 28', 'pseudogene', 'ENSG00000255003'),
(1166, 24403, 'CYCSP29', 'CYCS pseudogene 29', 'pseudogene', 'ENSG00000255379'),
(1167, 24406, 'CYCSP32', 'CYCS pseudogene 32', 'pseudogene', 'ENSG00000223625'),
(1168, 2611, 'CYP2A7', 'cytochrome P450 family 2 subfamily A member 7', 'protein-coding gene', 'ENSG00000198077'),
(1169, 39975, 'CYP2AB1P', 'cytochrome P450 family 2 subfamily AB member 1, pseudogene', 'pseudogene', 'ENSG00000233441'),
(1170, 2615, 'CYP2B6', 'cytochrome P450 family 2 subfamily B member 6', 'protein-coding gene', 'ENSG00000197408'),
(1171, 2621, 'CYP2C19', 'cytochrome P450 family 2 subfamily C member 19', 'protein-coding gene', 'ENSG00000165841'),
(1172, 39972, 'CYP2C61P', 'cytochrome P450 family 2 subfamily C member 61, pseudogene', 'pseudogene', 'ENSG00000270648'),
(1173, 2624, 'CYP2D7', 'cytochrome P450 family 2 subfamily D member 7 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000205702'),
(1174, 2632, 'CYP2F1', 'cytochrome P450 family 2 subfamily F member 1', 'protein-coding gene', 'ENSG00000197446'),
(1175, 18852, 'CYP2T1P', 'cytochrome P450 family 2 subfamily T member 1, pseudogene', 'pseudogene', 'ENSG00000233622'),
(1176, 20243, 'CYP2W1', 'cytochrome P450 family 2 subfamily W member 1', 'protein-coding gene', 'ENSG00000073067'),
(1177, 2637, 'CYP3A4', 'cytochrome P450 family 3 subfamily A member 4', 'protein-coding gene', 'ENSG00000160868'),
(1178, 42412, 'CYP3A52P', 'cytochrome P450 family 3 subfamily A member 52, pseudogene', 'pseudogene', 'ENSG00000260524'),
(1179, 20575, 'CYP4A22', 'cytochrome P450 family 4 subfamily A member 22', 'protein-coding gene', 'ENSG00000162365'),
(1180, 42416, 'CYP4A44P', 'cytochrome P450 family 4 subfamily A member 44, pseudogene', 'pseudogene', 'ENSG00000261290'),
(1181, 26820, 'CYP4F22', 'cytochrome P450 family 4 subfamily F member 22', 'protein-coding gene', 'ENSG00000171954'),
(1182, 39946, 'CYP4F27P', 'cytochrome P450 family 4 subfamily F member 27, pseudogene', 'pseudogene', 'ENSG00000248313'),
(1183, 39952, 'CYP4F33P', 'cytochrome P450 family 4 subfamily F member 33, pseudogene', 'pseudogene', 'ENSG00000273036'),
(1184, 42468, 'CYP4F60P', 'cytochrome P450 family 4 subfamily F member 60, pseudogene', 'pseudogene', 'ENSG00000230635'),
(1185, 39956, 'CYP4F62P', 'cytochrome P450 family 4 subfamily F member 62, pseudogene', 'pseudogene', 'ENSG00000239402'),
(1186, 23198, 'CYP4V2', 'cytochrome P450 family 4 subfamily V member 2', 'protein-coding gene', 'ENSG00000145476'),
(1187, 2651, 'CYP7A1', 'cytochrome P450 family 7 subfamily A member 1', 'protein-coding gene', 'ENSG00000167910'),
(1188, 2590, 'CYP11A1', 'cytochrome P450 family 11 subfamily A member 1', 'protein-coding gene', 'ENSG00000140459'),
(1189, 2591, 'CYP11B1', 'cytochrome P450 family 11 subfamily B member 1', 'protein-coding gene', 'ENSG00000160882'),
(1190, 20577, 'CYP26C1', 'cytochrome P450 family 26 subfamily C member 1', 'protein-coding gene', 'ENSG00000187553'),
(1191, 2649, 'CYP51A1', 'cytochrome P450 family 51 subfamily A member 1', 'protein-coding gene', 'ENSG00000001630'),
(1192, 25373, 'CYRIA', 'CYFIP related Rac1 interactor A', 'protein-coding gene', 'ENSG00000197872'),
(1193, 17451, 'CYSLTR1', 'cysteinyl leukotriene receptor 1', 'protein-coding gene', 'ENSG00000173198'),
(1194, 30239, 'CYSTM1', 'cysteine rich transmembrane module containing 1', 'protein-coding gene', 'ENSG00000120306'),
(1195, 9504, 'CYTH3', 'cytohesin 3', 'protein-coding gene', 'ENSG00000008256'),
(1196, 9506, 'CYTIP', 'cytohesin 1 interacting protein', 'protein-coding gene', 'ENSG00000115165'),
(1197, 24435, 'CYTL1', 'cytokine like 1', 'protein-coding gene', 'ENSG00000170891'),
(1198, 26059, 'CZIB', 'CXXC motif containing zinc binding protein', 'protein-coding gene', 'ENSG00000162384'),
(1199, 17294, 'DAB2IP', 'DAB2 interacting protein', 'protein-coding gene', 'ENSG00000136848'),
(1200, 2664, 'DAD1', 'defender against cell death 1', 'protein-coding gene', 'ENSG00000129562'),
(1201, 21191, 'DAOA', 'D-amino acid oxidase activator', 'protein-coding gene', 'ENSG00000182346'),
(1202, 43591, 'DAPK1-IT1', 'DAPK1 intronic transcript 1', 'non-coding RNA', 'ENSG00000236709'),
(1203, 2675, 'DAPK2', 'death associated protein kinase 2', 'protein-coding gene', 'ENSG00000035664'),
(1204, 15965, 'DAZ3', 'deleted in azoospermia 3', 'protein-coding gene', 'ENSG00000187191'),
(1205, 2683, 'DAZAP1', 'DAZ associated protein 1', 'protein-coding gene', 'ENSG00000071626'),
(1206, 2684, 'DAZAP2', 'DAZ associated protein 2', 'protein-coding gene', 'ENSG00000183283'),
(1207, 2689, 'DBH', 'dopamine beta-hydroxylase', 'protein-coding gene', 'ENSG00000123454'),
(1208, 38519, 'DBIL5P', 'diazepam binding inhibitor-like 5, pseudogene', 'pseudogene', 'ENSG00000231784'),
(1209, 26657, 'DCAF4L2', 'DDB1 and CUL4 associated factor 4 like 2', 'protein-coding gene', 'ENSG00000176566'),
(1210, 20224, 'DCAF5', 'DDB1 and CUL4 associated factor 5', 'protein-coding gene', 'ENSG00000139990'),
(1211, 30002, 'DCAF6', 'DDB1 and CUL4 associated factor 6', 'protein-coding gene', 'ENSG00000143164'),
(1212, 24891, 'DCAF8', 'DDB1 and CUL4 associated factor 8', 'protein-coding gene', 'ENSG00000132716'),
(1213, 20625, 'DCDC1', 'doublecortin domain containing 1', 'protein-coding gene', 'ENSG00000170959'),
(1214, 32576, 'DCDC2B', 'doublecortin domain containing 2B', 'protein-coding gene', 'ENSG00000222046'),
(1215, 2700, 'DCLK1', 'doublecortin like kinase 1', 'protein-coding gene', 'ENSG00000133083'),
(1216, 17642, 'DCLRE1C', 'DNA cross-link repair 1C', 'protein-coding gene', 'ENSG00000152457'),
(1217, 44877, 'DCLRE1CP1', 'DNA cross-link repair 1C pseudogene 1', 'pseudogene', 'ENSG00000237470'),
(1218, 18714, 'DCP1A', 'decapping mRNA 1A', 'protein-coding gene', 'ENSG00000272886'),
(1219, 29812, 'DCPS', 'decapping enzyme, scavenger', 'protein-coding gene', 'ENSG00000110063'),
(1220, 26539, 'DCST1', 'DC-STAMP domain containing 1', 'protein-coding gene', 'ENSG00000163357'),
(1221, 2712, 'DCTN2', 'dynactin subunit 2', 'protein-coding gene', 'ENSG00000175203'),
(1222, 24594, 'DCTN5', 'dynactin subunit 5', 'protein-coding gene', 'ENSG00000166847'),
(1223, 16964, 'DCTN6', 'dynactin subunit 6', 'protein-coding gene', 'ENSG00000104671'),
(1224, 18184, 'DCUN1D1', 'defective in cullin neddylation 1 domain containing 1', 'protein-coding gene', 'ENSG00000043093'),
(1225, 20328, 'DCUN1D2', 'defective in cullin neddylation 1 domain containing 2', 'protein-coding gene', 'ENSG00000150401'),
(1226, 2715, 'DDAH1', 'dimethylarginine dimethylaminohydrolase 1', 'protein-coding gene', 'ENSG00000153904'),
(1227, 2716, 'DDAH2', 'dimethylarginine dimethylaminohydrolase 2', 'protein-coding gene', 'ENSG00000213722'),
(1228, 2719, 'DDC', 'dopa decarboxylase', 'protein-coding gene', 'ENSG00000132437'),
(1229, 29106, 'DDHD2', 'DDHD domain containing 2', 'protein-coding gene', 'ENSG00000085788'),
(1230, 52379, 'DDIT4-AS1', 'DDIT4 antisense RNA 1', 'non-coding RNA', 'ENSG00000269926'),
(1231, 30555, 'DDIT4L', 'DNA damage inducible transcript 4 like', 'protein-coding gene', 'ENSG00000145358'),
(1232, 33446, 'DDTL', 'D-dopachrome tautomerase like', 'protein-coding gene', 'ENSG00000099974'),
(1233, 44546, 'DDTP1', 'D-dopachrome tautomerase pseudogene 1', 'pseudogene', 'ENSG00000230683'),
(1234, 44961, 'DDX10P2', 'DEAD-box helicase 10 pseudogene 2', 'pseudogene', 'ENSG00000230360'),
(1235, 37103, 'DDX11L2', 'DEAD/H-box helicase 11 like 2 (pseudogene)', 'pseudogene', 'ENSG00000236397'),
(1236, 55080, 'DDX11L17', 'DEAD/H-box helicase 11 like 17 (pseudogene)', 'pseudogene', 'ENSG00000279928'),
(1237, 33966, 'DDX18P3', 'DEAD-box helicase 18 pseudogene 3', 'pseudogene', 'ENSG00000217414'),
(1238, 33967, 'DDX18P4', 'DEAD-box helicase 18 pseudogene 4', 'pseudogene', 'ENSG00000251553'),
(1239, 25628, 'DDX19A', 'DEAD-box helicase 19A', 'protein-coding gene', 'ENSG00000168872'),
(1240, 18698, 'DDX25', 'DEAD-box helicase 25', 'protein-coding gene', 'ENSG00000109832'),
(1241, 13917, 'DDX39B', 'DExD-box helicase 39B', 'protein-coding gene', 'ENSG00000198563'),
(1242, 50781, 'DDX43P2', 'DEAD-box helicase 43 pseudogene 2', 'pseudogene', 'ENSG00000270763'),
(1243, 18682, 'DDX47', 'DEAD-box helicase 47', 'protein-coding gene', 'ENSG00000213782'),
(1244, 20038, 'DDX52', 'DExD-box helicase 52', 'protein-coding gene', 'ENSG00000278053'),
(1245, 20084, 'DDX54', 'DEAD-box helicase 54', 'protein-coding gene', 'ENSG00000123064'),
(1246, 2761, 'DEFA1', 'defensin alpha 1', 'protein-coding gene', 'ENSG00000206047'),
(1247, 33354, 'DEFA11P', 'defensin alpha 11, pseudogene', 'pseudogene', 'ENSG00000234178'),
(1248, 31702, 'DEFB103B', 'defensin beta 103B', 'protein-coding gene', 'ENSG00000177243'),
(1249, 18115, 'DEFB104A', 'defensin beta 104A', 'protein-coding gene', 'ENSG00000176782'),
(1250, 31918, 'DEFB107B', 'defensin beta 107B', 'protein-coding gene', 'ENSG00000198129'),
(1251, 18094, 'DEFB113', 'defensin beta 113', 'protein-coding gene', 'ENSG00000214642'),
(1252, 18104, 'DEFB124', 'defensin beta 124', 'protein-coding gene', 'ENSG00000180383'),
(1253, 18105, 'DEFB125', 'defensin beta 125', 'protein-coding gene', 'ENSG00000178591'),
(1254, 43843, 'DEFB130C', 'defensin beta 130C (pseudogene)', 'pseudogene', 'ENSG00000255157'),
(1255, 18108, 'DEFB131A', 'defensin beta 131A', 'protein-coding gene', 'ENSG00000186146'),
(1256, 38060, 'DEFB131C', 'defensin beta 131C (pseudogene)', 'pseudogene', 'ENSG00000254700'),
(1257, 38061, 'DEFB131D', 'defensin beta 131D (pseudogene)', 'pseudogene', 'ENSG00000237215'),
(1258, 33806, 'DEFB132', 'defensin beta 132', 'protein-coding gene', 'ENSG00000186458'),
(1259, 28969, 'DELE1', 'DAP3 binding cell death enhancer 1', 'protein-coding gene', 'ENSG00000081791'),
(1260, 11350, 'DENND2B', 'DENN domain containing 2B', 'protein-coding gene', 'ENSG00000166444'),
(1261, 24748, 'DENND2C', 'DENN domain containing 2C', 'protein-coding gene', 'ENSG00000175984'),
(1262, 41152, 'DENND6A-AS1', 'DENND6A antisense RNA 1', 'non-coding RNA', 'ENSG00000239801'),
(1263, 50592, 'DEPDC1-AS1', 'DEPDC1 antisense RNA 1', 'non-coding RNA', 'ENSG00000234264'),
(1264, 22953, 'DEPTOR', 'DEP domain containing MTOR interacting protein', 'protein-coding gene', 'ENSG00000155792'),
(1265, 24269, 'DERA', 'deoxyribose-phosphate aldolase', 'protein-coding gene', 'ENSG00000023697'),
(1266, 28454, 'DERL1', 'derlin 1', 'protein-coding gene', 'ENSG00000136986'),
(1267, 27451, 'DGAT2-DT', 'DGAT2 divergent transcript', 'non-coding RNA', 'ENSG00000247867'),
(1268, 23250, 'DGAT2L6', 'diacylglycerol O-acyltransferase 2 like 6', 'protein-coding gene', 'ENSG00000184210'),
(1269, 16757, 'DGCR5', 'DiGeorge syndrome critical region gene 5', 'non-coding RNA', 'ENSG00000273032'),
(1270, 17226, 'DGCR11', 'DiGeorge syndrome critical region gene 11', 'non-coding RNA', 'ENSG00000273311'),
(1271, 2855, 'DGKI', 'diacylglycerol kinase iota', 'protein-coding gene', 'ENSG00000157680'),
(1272, 2857, 'DGKZ', 'diacylglycerol kinase zeta', 'protein-coding gene', 'ENSG00000149091'),
(1273, 20498, 'DGLUCY', 'D-glutamate cyclase', 'protein-coding gene', 'ENSG00000133943'),
(1274, 20603, 'DHDDS', 'dehydrodolichyl diphosphate synthase subunit', 'protein-coding gene', 'ENSG00000117682'),
(1275, 2863, 'DHFRP2', 'dihydrofolate reductase pseudogene 2', 'pseudogene', 'ENSG00000228432'),
(1276, 52356, 'DHFRP6', 'dihydrofolate reductase pseudogene 6', 'pseudogene', 'ENSG00000219095'),
(1277, 16985, 'DHRS4', 'dehydrogenase/reductase 4', 'protein-coding gene', 'ENSG00000157326'),
(1278, 24547, 'DHRS7B', 'dehydrogenase/reductase 7B', 'protein-coding gene', 'ENSG00000109016'),
(1279, 16888, 'DHRS9', 'dehydrogenase/reductase 9', 'protein-coding gene', 'ENSG00000073737'),
(1280, 28639, 'DHRS11', 'dehydrogenase/reductase 11', 'protein-coding gene', 'ENSG00000278535'),
(1281, 2739, 'DHX16', 'DEAH-box helicase 16', 'protein-coding gene', 'ENSG00000204560'),
(1282, 16972, 'DIAPH2-AS1', 'DIAPH2 antisense RNA 1', 'non-coding RNA', 'ENSG00000236256'),
(1283, 30217, 'DIMT1', 'DIM1 rRNA methyltransferase and ribosome maturation factor', 'protein-coding gene', 'ENSG00000086189'),
(1284, 2883, 'DIO1', 'iodothyronine deiodinase 1', 'protein-coding gene', 'ENSG00000211452'),
(1285, 32213, 'DIPK1A', 'divergent protein kinase domain 1A', 'protein-coding gene', 'ENSG00000154511'),
(1286, 25866, 'DIPK2B', 'divergent protein kinase domain 2B', 'protein-coding gene', 'ENSG00000147113'),
(1287, 17805, 'DIRC3', 'disrupted in renal carcinoma 3', 'non-coding RNA', 'ENSG00000231672'),
(1288, 28698, 'DIS3L', 'DIS3 like exosome 3\'-5\' exoribonuclease', 'protein-coding gene', 'ENSG00000166938'),
(1289, 2888, 'DISC1', 'DISC1 scaffold protein', 'protein-coding gene', 'ENSG00000162946'),
(1290, 40182, 'DLG3-AS1', 'DLG3 antisense RNA 1', 'non-coding RNA', 'ENSG00000231651'),
(1291, 2903, 'DLG4', 'discs large MAGUK scaffold protein 4', 'protein-coding gene', 'ENSG00000132535'),
(1292, 2905, 'DLGAP1', 'DLG associated protein 1', 'protein-coding gene', 'ENSG00000170579'),
(1293, 44333, 'DLGAP1-AS4', 'DLGAP1 antisense RNA 4', 'non-coding RNA', 'ENSG00000263878'),
(1294, 2908, 'DLL1', 'delta like canonical Notch ligand 1', 'protein-coding gene', 'ENSG00000198719'),
(1295, 2909, 'DLL3', 'delta like canonical Notch ligand 3', 'protein-coding gene', 'ENSG00000090932'),
(1296, 2912, 'DLSTP1', 'dihydrolipoamide S-succinyltransferase pseudogene 1', 'pseudogene', 'ENSG00000181227'),
(1297, 50638, 'DLX2-DT', 'DLX2 divergent transcript', 'non-coding RNA', 'ENSG00000236651'),
(1298, 2916, 'DLX3', 'distal-less homeobox 3', 'protein-coding gene', 'ENSG00000064195'),
(1299, 2919, 'DLX6', 'distal-less homeobox 6', 'protein-coding gene', 'ENSG00000006377'),
(1300, 2927, 'DMC1', 'DNA meiotic recombinase 1', 'protein-coding gene', 'ENSG00000100206'),
(1301, 14603, 'DMTF1', 'cyclin D binding myb like transcription factor 1', 'protein-coding gene', 'ENSG00000135164'),
(1302, 2937, 'DMXL1', 'Dmx like 1', 'protein-coding gene', 'ENSG00000172869'),
(1303, 30539, 'DNAAF1', 'dynein axonemal assembly factor 1', 'protein-coding gene', 'ENSG00000154099'),
(1304, 21493, 'DNAAF4', 'dynein axonemal assembly factor 4', 'protein-coding gene', 'ENSG00000256061'),
(1305, 28570, 'DNAAF6', 'dynein axonemal assembly factor 6', 'protein-coding gene', 'ENSG00000080572'),
(1306, 2952, 'DNAH8', 'dynein axonemal heavy chain 8', 'protein-coding gene', 'ENSG00000124721'),
(1307, 37121, 'DNAH10OS', 'dynein axonemal heavy chain 10 opposite strand', 'protein-coding gene', 'ENSG00000250091'),
(1308, 2945, 'DNAH14', 'dynein axonemal heavy chain 14', 'protein-coding gene', 'ENSG00000185842'),
(1309, 39338, 'DNAJA1P2', 'DnaJ heat shock protein family (Hsp40) member A1 pseudogene 2', 'pseudogene', 'ENSG00000236917'),
(1310, 39340, 'DNAJA1P4', 'DnaJ heat shock protein family (Hsp40) member A1 pseudogene 4', 'pseudogene', 'ENSG00000218089'),
(1311, 14885, 'DNAJA4', 'DnaJ heat shock protein family (Hsp40) member A4', 'protein-coding gene', 'ENSG00000140403'),
(1312, 5270, 'DNAJB1', 'DnaJ heat shock protein family (Hsp40) member B1', 'protein-coding gene', 'ENSG00000132002'),
(1313, 24988, 'DNAJB1P1', 'DnaJ heat shock protein family (Hsp40) member B1 pseudogene 1', 'pseudogene', 'ENSG00000213946'),
(1314, 32397, 'DNAJB3', 'DnaJ heat shock protein family (Hsp40) member B3', 'other', 'ENSG00000227802'),
(1315, 50449, 'DNAJB5P1', 'DnaJ heat shock protein family (Hsp40) member B5 pseudogene 1', 'pseudogene', 'ENSG00000230335'),
(1316, 54759, 'DNAJB6P6', 'DNAJB6 pseudogene 6', 'pseudogene', 'ENSG00000234247'),
(1317, 6968, 'DNAJB9', 'DnaJ heat shock protein family (Hsp40) member B9', 'protein-coding gene', 'ENSG00000128590'),
(1318, 14889, 'DNAJB11', 'DnaJ heat shock protein family (Hsp40) member B11', 'protein-coding gene', 'ENSG00000090520'),
(1319, 13192, 'DNAJC2', 'DnaJ heat shock protein family (Hsp40) member C2', 'protein-coding gene', 'ENSG00000105821'),
(1320, 15470, 'DNAJC8', 'DnaJ heat shock protein family (Hsp40) member C8', 'protein-coding gene', 'ENSG00000126698'),
(1321, 24637, 'DNAJC10', 'DnaJ heat shock protein family (Hsp40) member C10', 'protein-coding gene', 'ENSG00000077232'),
(1322, 30528, 'DNAJC19', 'DnaJ heat shock protein family (Hsp40) member C19', 'protein-coding gene', 'ENSG00000205981'),
(1323, 45066, 'DNAJC19P3', 'DnaJ heat shock protein family (Hsp40) member C19 pseudogene 3', 'pseudogene', 'ENSG00000268997'),
(1324, 45070, 'DNAJC19P7', 'DnaJ heat shock protein family (Hsp40) member C19 pseudogene 7', 'pseudogene', 'ENSG00000237663'),
(1325, 35199, 'DNM1P46', 'dynamin 1 pseudogene 46', 'pseudogene', 'ENSG00000182397'),
(1326, 47040, 'DNM1P49', 'dynamin 1 pseudogene 49', 'pseudogene', 'ENSG00000261820'),
(1327, 20431, 'DNMBP-AS1', 'DNMBP antisense RNA 1', 'non-coding RNA', 'ENSG00000227695'),
(1328, 40189, 'DNMT3L-AS1', 'DNMT3L antisense RNA 1', 'non-coding RNA', 'ENSG00000232010'),
(1329, 55789, 'DNPEP-AS1', 'DNPEP antisense RNA 1', 'non-coding RNA', 'ENSG00000229525'),
(1330, 2985, 'DOC2A', 'double C2 domain alpha', 'protein-coding gene', 'ENSG00000149927'),
(1331, 23476, 'DOCK5', 'dedicator of cytokinesis 5', 'protein-coding gene', 'ENSG00000147459'),
(1332, 23483, 'DOCK11', 'dedicator of cytokinesis 11', 'protein-coding gene', 'ENSG00000147251'),
(1333, 28662, 'DOHH', 'deoxyhypusine hydroxylase', 'protein-coding gene', 'ENSG00000129932'),
(1334, 24583, 'DOK3', 'docking protein 3', 'protein-coding gene', 'ENSG00000146094'),
(1335, 16173, 'DOK5', 'docking protein 5', 'protein-coding gene', 'ENSG00000101134'),
(1336, 3002, 'DPEP1', 'dipeptidase 1', 'protein-coding gene', 'ENSG00000015413'),
(1337, 20225, 'DPF1', 'double PHD fingers 1', 'protein-coding gene', 'ENSG00000011332'),
(1338, 3004, 'DPH2', 'diphthamide biosynthesis 2', 'protein-coding gene', 'ENSG00000132768'),
(1339, 27717, 'DPH3', 'diphthamide biosynthesis 3', 'protein-coding gene', 'ENSG00000154813'),
(1340, 3005, 'DPM1', 'dolichyl-phosphate mannosyltransferase subunit 1, catalytic', 'protein-coding gene', 'ENSG00000000419'),
(1341, 3008, 'DPP3', 'dipeptidyl peptidase 3', 'protein-coding gene', 'ENSG00000254986'),
(1342, 3009, 'DPP4', 'dipeptidyl peptidase 4', 'protein-coding gene', 'ENSG00000197635'),
(1343, 16490, 'DPP8', 'dipeptidyl peptidase 8', 'protein-coding gene', 'ENSG00000074603'),
(1344, 40940, 'DPP10-AS2', 'DPP10 antisense RNA 2', 'non-coding RNA', 'ENSG00000235717'),
(1345, 38448, 'DPPA2P1', 'developmental pluripotency associated 2 pseudogene 1', 'pseudogene', 'ENSG00000223915'),
(1346, 44628, 'DPPA2P3', 'developmental pluripotency associated 2 pseudogene 3', 'pseudogene', 'ENSG00000224403'),
(1347, 19199, 'DPPA3', 'developmental pluripotency associated 3', 'protein-coding gene', 'ENSG00000187569'),
(1348, 19200, 'DPPA4', 'developmental pluripotency associated 4', 'protein-coding gene', 'ENSG00000121570'),
(1349, 32172, 'DPRXP6', 'divergent-paired related homeobox pseudogene 6', 'pseudogene', 'ENSG00000270791'),
(1350, 3011, 'DPT', 'dermatopontin', 'protein-coding gene', 'ENSG00000143196'),
(1351, 22305, 'DPY19L2P1', 'DPY19L2 pseudogene 1', 'pseudogene', 'ENSG00000189212'),
(1352, 55307, 'DPY19L3-DT', 'DPY19L3 divergent transcript', 'non-coding RNA', 'ENSG00000267213'),
(1353, 27829, 'DPY19L4', 'dpy-19 like 4', 'protein-coding gene', 'ENSG00000156162'),
(1354, 53907, 'DPY19L4P1', 'DPY19L4 pseudogene 1', 'pseudogene', 'ENSG00000229663'),
(1355, 41326, 'DPYD-IT1', 'DPYD intronic transcript 1', 'non-coding RNA', 'ENSG00000232542'),
(1356, 3013, 'DPYS', 'dihydropyrimidinase', 'protein-coding gene', 'ENSG00000147647'),
(1357, 3015, 'DPYSL3', 'dihydropyrimidinase like 3', 'protein-coding gene', 'ENSG00000113657'),
(1358, 27082, 'DRAIC', 'downregulated RNA in cancer, inhibitor of cell invasion and migration', 'non-coding RNA', 'ENSG00000245750'),
(1359, 25054, 'DRAXIN', 'dorsal inhibitory axon guidance protein', 'protein-coding gene', 'ENSG00000162490'),
(1360, 3026, 'DRD5', 'dopamine receptor D5', 'protein-coding gene', 'ENSG00000169676'),
(1361, 3036, 'DSC2', 'desmocollin 2', 'protein-coding gene', 'ENSG00000134755'),
(1362, 3039, 'DSCAM', 'DS cell adhesion molecule', 'protein-coding gene', 'ENSG00000171587'),
(1363, 14656, 'DSCAML1', 'DS cell adhesion molecule like 1', 'protein-coding gene', 'ENSG00000177103'),
(1364, 16707, 'DSCR8', 'Down syndrome critical region 8', 'non-coding RNA', 'ENSG00000198054'),
(1365, 21144, 'DSE', 'dermatan sulfate epimerase', 'protein-coding gene', 'ENSG00000111817'),
(1366, 51115, 'DSG1-AS1', 'DSG1 antisense RNA 1', 'non-coding RNA', 'ENSG00000266729'),
(1367, 3058, 'DTNB', 'dystrobrevin beta', 'protein-coding gene', 'ENSG00000138101'),
(1368, 48569, 'DUBR', 'DPPA2 upstream binding RNA', 'non-coding RNA', 'ENSG00000243701'),
(1369, 26507, 'DUOXA1', 'dual oxidase maturation factor 1', 'protein-coding gene', 'ENSG00000140254'),
(1370, 55154, 'DUSP5-DT', 'DUSP5 divergent transcript', 'non-coding RNA', 'ENSG00000273143'),
(1371, 3073, 'DUSP7', 'dual specificity phosphatase 7', 'protein-coding gene', 'ENSG00000164086'),
(1372, 3067, 'DUSP12', 'dual specificity phosphatase 12', 'protein-coding gene', 'ENSG00000081721'),
(1373, 49059, 'DUSP12P1', 'dual specificity phosphatase 12 pseudogene 1', 'pseudogene', 'ENSG00000277000'),
(1374, 16236, 'DUSP15', 'dual specificity phosphatase 15', 'protein-coding gene', 'ENSG00000149599'),
(1375, 23481, 'DUSP29', 'dual specificity phosphatase 29', 'protein-coding gene', 'ENSG00000188716'),
(1376, 39515, 'DUTP2', 'deoxyuridine triphosphatase pseudogene 2', 'pseudogene', 'ENSG00000254388'),
(1377, 37267, 'DUX4L2', 'double homeobox 4 like 2 (pseudogene)', 'pseudogene', 'ENSG00000280457'),
(1378, 37265, 'DUX4L6', 'double homeobox 4 like 6 (pseudogene)', 'pseudogene', 'ENSG00000281058'),
(1379, 31354, 'DUX4L10', 'double homeobox 4 like 10 (pseudogene)', 'pseudogene', 'ENSG00000278664'),
(1380, 38674, 'DUX4L15', 'double homeobox 4 like 15 (pseudogene)', 'pseudogene', 'ENSG00000278641'),
(1381, 37717, 'DUX4L17', 'double homeobox 4 like 17 (pseudogene)', 'pseudogene', 'ENSG00000259154'),
(1382, 50804, 'DUX4L23', 'double homeobox 4 like 23 (pseudogene)', 'pseudogene', 'ENSG00000276964'),
(1383, 51770, 'DUX4L31', 'double homeobox 4 like 31 (pseudogene)', 'pseudogene', 'ENSG00000231411'),
(1384, 51772, 'DUX4L34', 'double homeobox 4 like 34 (pseudogene)', 'pseudogene', 'ENSG00000282935'),
(1385, 51811, 'DUX4L52', 'double homeobox 4 like 52 (pseudogene)', 'pseudogene', 'ENSG00000258336'),
(1386, 32184, 'DUXAP5', 'double homeobox A pseudogene 5', 'pseudogene', 'ENSG00000255377'),
(1387, 32185, 'DUXAP6', 'double homeobox A pseudogene 6', 'pseudogene', 'ENSG00000258726'),
(1388, 33345, 'DUXB', 'double homeobox B', 'protein-coding gene', 'ENSG00000282757'),
(1389, 3087, 'DVL3', 'dishevelled segment polarity protein 3', 'protein-coding gene', 'ENSG00000161202'),
(1390, 2992, 'DXO', 'decapping exoribonuclease', 'protein-coding gene', 'ENSG00000204348'),
(1391, 56222, 'DYNAPP2', 'DYNAP pseudogene 2', 'pseudogene', 'ENSG00000267428'),
(1392, 2961, 'DYNC1H1', 'dynein cytoplasmic 1 heavy chain 1', 'protein-coding gene', 'ENSG00000197102'),
(1393, 2963, 'DYNC1I1', 'dynein cytoplasmic 1 intermediate chain 1', 'protein-coding gene', 'ENSG00000158560'),
(1394, 2962, 'DYNC2H1', 'dynein cytoplasmic 2 heavy chain 1', 'protein-coding gene', 'ENSG00000187240'),
(1395, 20724, 'DYNLL1P2', 'dynein light chain LC8-type 1 pseudogene 2', 'pseudogene', 'ENSG00000258605'),
(1396, 49656, 'DYNLL1P5', 'dynein light chain LC8-type 1 pseudogene 5', 'pseudogene', 'ENSG00000242151'),
(1397, 49658, 'DYNLL1P7', 'dynein light chain LC8-type 1 pseudogene 7', 'pseudogene', 'ENSG00000230614'),
(1398, 55405, 'DYNLRB2-AS1', 'DYNLRB2 antisense RNA 1', 'non-coding RNA', 'ENSG00000259867'),
(1399, 11695, 'DYNLT2', 'dynein light chain Tctex-type 2', 'protein-coding gene', 'ENSG00000184786'),
(1400, 3092, 'DYRK1B', 'dual specificity tyrosine phosphorylation regulated kinase 1B', 'protein-coding gene', 'ENSG00000105204'),
(1401, 3095, 'DYRK4', 'dual specificity tyrosine phosphorylation regulated kinase 4', 'protein-coding gene', 'ENSG00000010219'),
(1402, 20908, 'DZIP1', 'DAZ interacting zinc finger protein 1', 'protein-coding gene', 'ENSG00000134874'),
(1403, 30938, 'DZIP3', 'DAZ interacting zinc finger protein 3', 'protein-coding gene', 'ENSG00000198919'),
(1404, 3116, 'E2F3P1', 'E2F transcription factor 3 pseudogene 1', 'pseudogene', 'ENSG00000267046'),
(1405, 38684, 'E2F4P1', 'E2F transcription factor 4 pseudogene 1', 'pseudogene', 'ENSG00000231276'),
(1406, 51452, 'E2F6P4', 'E2F transcription factor 6 pseudogene 4', 'pseudogene', 'ENSG00000231513'),
(1407, 20907, 'EAF1', 'ELL associated factor 1', 'protein-coding gene', 'ENSG00000144597'),
(1408, 23115, 'EAF2', 'ELL associated factor 2', 'protein-coding gene', 'ENSG00000145088'),
(1409, 3147, 'ECEL1', 'endothelin converting enzyme like 1', 'protein-coding gene', 'ENSG00000171551'),
(1410, 14018, 'ECEL1P3', 'endothelin converting enzyme like 1 pseudogene 3', 'pseudogene', 'ENSG00000230122'),
(1411, 35454, 'ECSCR', 'endothelial cell surface expressed chemotaxis and apoptosis regulator', 'protein-coding gene', 'ENSG00000249751'),
(1412, 21118, 'ECT2L', 'epithelial cell transforming 2 like', 'protein-coding gene', 'ENSG00000203734'),
(1413, 2895, 'EDAR', 'ectodysplasin A receptor', 'protein-coding gene', 'ENSG00000135960'),
(1414, 19223, 'EDDM3B', 'epididymal protein 3B', 'protein-coding gene', 'ENSG00000181552'),
(1415, 18967, 'EDEM1', 'ER degradation enhancing alpha-mannosidase like protein 1', 'protein-coding gene', 'ENSG00000134109'),
(1416, 15877, 'EDEM2', 'ER degradation enhancing alpha-mannosidase like protein 2', 'protein-coding gene', 'ENSG00000088298'),
(1417, 3177, 'EDN2', 'endothelin 2', 'protein-coding gene', 'ENSG00000127129'),
(1418, 3180, 'EDNRB', 'endothelin receptor type B', 'protein-coding gene', 'ENSG00000136160'),
(1419, 54128, 'EDRF1-DT', 'EDRF1 divergent transcript', 'non-coding RNA', 'ENSG00000224023'),
(1420, 55143, 'EEDP1', 'EED pseudogene 1', 'pseudogene', 'ENSG00000224942'),
(1421, 3189, 'EEF1A1', 'eukaryotic translation elongation factor 1 alpha 1', 'protein-coding gene', 'ENSG00000156508'),
(1422, 3191, 'EEF1A1P1', 'eukaryotic translation elongation factor 1 alpha 1 pseudogene 1', 'pseudogene', 'ENSG00000223822'),
(1423, 3205, 'EEF1A1P10', 'eukaryotic translation elongation factor 1 alpha 1 pseudogene 10', 'pseudogene', 'ENSG00000243746'),
(1424, 37890, 'EEF1A1P17', 'eukaryotic translation elongation factor 1 alpha 1 pseudogene 17', 'pseudogene', 'ENSG00000257907'),
(1425, 37895, 'EEF1A1P22', 'eukaryotic translation elongation factor 1 alpha 1 pseudogene 22', 'pseudogene', 'ENSG00000259612'),
(1426, 37899, 'EEF1A1P26', 'eukaryotic translation elongation factor 1 alpha 1 pseudogene 26', 'pseudogene', 'ENSG00000233167'),
(1427, 37908, 'EEF1A1P31', 'eukaryotic translation elongation factor 1 alpha 1 pseudogene 31', 'pseudogene', 'ENSG00000237859'),
(1428, 37918, 'EEF1A1P40', 'eukaryotic translation elongation factor 1 alpha 1 pseudogene 40', 'pseudogene', 'ENSG00000231144'),
(1429, 38799, 'EEF1A1P41', 'eukaryotic translation elongation factor 1 alpha 1 pseudogene 41', 'pseudogene', 'ENSG00000223600'),
(1430, 56201, 'EEF1A1P44', 'eukaryotic translation elongation factor 1 alpha 1 pseudogene 44', 'pseudogene', 'ENSG00000236468'),
(1431, 24936, 'EEF1AKMT3', 'EEF1A lysine methyltransferase 3', 'protein-coding gene', 'ENSG00000123427'),
(1432, 3209, 'EEF1B2P2', 'eukaryotic translation elongation factor 1 beta 2 pseudogene 2', 'pseudogene', 'ENSG00000213864'),
(1433, 51459, 'EEF1E1P1', 'eukaryotic translation elongation factor 1 epsilon 1 pseudogene 1', 'pseudogene', 'ENSG00000236307'),
(1434, 44562, 'EEF1GP7', 'eukaryotic translation elongation factor 1 gamma pseudogene 7', 'pseudogene', 'ENSG00000236290'),
(1435, 39999, 'EFCAB6-AS1', 'EFCAB6 antisense RNA 1', 'non-coding RNA', 'ENSG00000223843'),
(1436, 20357, 'EFCAB11', 'EF-hand calcium binding domain 11', 'protein-coding gene', 'ENSG00000140025'),
(1437, 44108, 'EFCAB14-AS1', 'EFCAB14 antisense RNA 1', 'non-coding RNA', 'ENSG00000228237'),
(1438, 44648, 'EFCAB14P1', 'EF-hand calcium binding domain 14 pseudogene 1', 'pseudogene', 'ENSG00000228348'),
(1439, 55801, 'EFHD2-AS1', 'EFHD2 antisense RNA 1', 'non-coding RNA', 'ENSG00000228140'),
(1440, 3222, 'EFNA2', 'ephrin A2', 'protein-coding gene', 'ENSG00000099617'),
(1441, 3223, 'EFNA3', 'ephrin A3', 'protein-coding gene', 'ENSG00000143590'),
(1442, 28970, 'EFR3A', 'EFR3 homolog A', 'protein-coding gene', 'ENSG00000132294'),
(1443, 25149, 'EGFEM1P', 'EGF like and EMI domain containing 1, pseudogene', 'pseudogene', 'ENSG00000206120'),
(1444, 41167, 'EGFLAM-AS3', 'EGFLAM antisense RNA 3', 'non-coding RNA', 'ENSG00000249071'),
(1445, 3236, 'EGFR', 'epidermal growth factor receptor', 'protein-coding gene', 'ENSG00000146648'),
(1446, 49077, 'EGLN3-AS1', 'EGLN3 antisense RNA 1', 'non-coding RNA', 'ENSG00000258897'),
(1447, 3239, 'EGR2', 'early growth response 2', 'protein-coding gene', 'ENSG00000122877'),
(1448, 3241, 'EGR4', 'early growth response 4', 'protein-coding gene', 'ENSG00000135625'),
(1449, 3245, 'EHD4', 'EH domain containing 4', 'protein-coding gene', 'ENSG00000103966'),
(1450, 44133, 'EHHADH-AS1', 'EHHADH antisense RNA 1', 'non-coding RNA', 'ENSG00000223358'),
(1451, 39751, 'EHMT2-AS1', 'EHMT2 and SLC44A4 antisense RNA 1', 'non-coding RNA', 'ENSG00000237080'),
(1452, 44587, 'EI24P2', 'EI24 pseudogene 2', 'pseudogene', 'ENSG00000236257'),
(1453, 28292, 'EID2', 'EP300 interacting inhibitor of differentiation 2', 'protein-coding gene', 'ENSG00000176396'),
(1454, 3252, 'EIF1AY', 'eukaryotic translation initiation factor 1A Y-linked', 'protein-coding gene', 'ENSG00000198692'),
(1455, 49614, 'EIF1P1', 'eukaryotic translation initiation factor 1 pseudogene 1', 'pseudogene', 'ENSG00000229875'),
(1456, 49618, 'EIF1P5', 'eukaryotic translation initiation factor 1 pseudogene 5', 'pseudogene', 'ENSG00000266563'),
(1457, 19687, 'EIF2AK4', 'eukaryotic translation initiation factor 2 alpha kinase 4', 'protein-coding gene', 'ENSG00000128829'),
(1458, 3266, 'EIF2S2', 'eukaryotic translation initiation factor 2 subunit beta', 'protein-coding gene', 'ENSG00000125977'),
(1459, 20009, 'EIF2S2P1', 'eukaryotic translation initiation factor 2 subunit 2 beta pseudogene 1', 'pseudogene', 'ENSG00000258778'),
(1460, 37626, 'EIF2S2P4', 'eukaryotic translation initiation factor 2 subunit 2 beta pseudogene 4', 'pseudogene', 'ENSG00000128692'),
(1461, 6102, 'EIF3EP1', 'eukaryotic translation initiation factor 3 subunit E pseudogene 1', 'pseudogene', 'ENSG00000234882'),
(1462, 55005, 'EIF3JP1', 'EIF3J pseudogene 1', 'pseudogene', 'ENSG00000228041'),
(1463, 18138, 'EIF3L', 'eukaryotic translation initiation factor 3 subunit L', 'protein-coding gene', 'ENSG00000100129'),
(1464, 24657, 'EIF3LP2', 'eukaryotic translation initiation factor 3 subunit L pseudogene 2', 'pseudogene', 'ENSG00000233837'),
(1465, 37934, 'EIF4A1P13', 'eukaryotic translation initiation factor 4A1 pseudogene 13', 'pseudogene', 'ENSG00000225701'),
(1466, 3284, 'EIF4A2', 'eukaryotic translation initiation factor 4A2', 'protein-coding gene', 'ENSG00000156976'),
(1467, 45101, 'EIF4A2P4', 'eukaryotic translation initiation factor 4A2 pseudogene 4', 'pseudogene', 'ENSG00000224781'),
(1468, 18683, 'EIF4A3', 'eukaryotic translation initiation factor 4A3', 'protein-coding gene', 'ENSG00000141543'),
(1469, 37941, 'EIF4BP8', 'eukaryotic translation initiation factor 4B pseudogene 8', 'pseudogene', 'ENSG00000243918'),
(1470, 3287, 'EIF4E', 'eukaryotic translation initiation factor 4E', 'protein-coding gene', 'ENSG00000151247'),
(1471, 31837, 'EIF4E3', 'eukaryotic translation initiation factor 4E family member 3', 'protein-coding gene', 'ENSG00000163412'),
(1472, 3289, 'EIF4EBP2', 'eukaryotic translation initiation factor 4E binding protein 2', 'protein-coding gene', 'ENSG00000148730'),
(1473, 51462, 'EIF4EP4', 'eukaryotic translation initiation factor 4E pseudogene 4', 'pseudogene', 'ENSG00000232968'),
(1474, 3297, 'EIF4G2', 'eukaryotic translation initiation factor 4 gamma 2', 'protein-coding gene', 'ENSG00000110321'),
(1475, 3299, 'EIF5', 'eukaryotic translation initiation factor 5', 'protein-coding gene', 'ENSG00000100664'),
(1476, 3301, 'EIF5A2', 'eukaryotic translation initiation factor 5A2', 'protein-coding gene', 'ENSG00000163577'),
(1477, 6159, 'EIF6', 'eukaryotic translation initiation factor 6', 'protein-coding gene', 'ENSG00000242372'),
(1478, 3315, 'ELAVL4', 'ELAV like RNA binding protein 4', 'protein-coding gene', 'ENSG00000162374'),
(1479, 3316, 'ELF1', 'E74 like ETS transcription factor 1', 'protein-coding gene', 'ENSG00000120690'),
(1480, 3320, 'ELF5', 'E74 like ETS transcription factor 5', 'protein-coding gene', 'ENSG00000135374'),
(1481, 3321, 'ELK1', 'ETS transcription factor ELK1', 'protein-coding gene', 'ENSG00000126767'),
(1482, 3324, 'ELK2BP', 'ETS transcription factor ELK2B, pseudogene', 'pseudogene', 'ENSG00000234402'),
(1483, 39345, 'ELL2P3', 'elongation factor for RNA polymerase II 2 pseudogene 3', 'pseudogene', 'ENSG00000234765'),
(1484, 39346, 'ELL2P4', 'elongation factor for RNA polymerase II 2 pseudogene 4', 'pseudogene', 'ENSG00000226388'),
(1485, 38008, 'ELMO2P1', 'engulfment and cell motility 2 pseudogene 1', 'pseudogene', 'ENSG00000276172'),
(1486, 17289, 'ELMO3', 'engulfment and cell motility 3', 'protein-coding gene', 'ENSG00000102890'),
(1487, 40212, 'ELN-AS1', 'ELN antisense RNA 1', 'non-coding RNA', 'ENSG00000232415'),
(1488, 50582, 'ELOA-AS1', 'ELOA antisense RNA 1', 'non-coding RNA', 'ENSG00000236810'),
(1489, 11619, 'ELOB', 'elongin B', 'protein-coding gene', 'ENSG00000103363'),
(1490, 39721, 'ELOBP3', 'elongin B pseudogene 3', 'pseudogene', 'ENSG00000232285'),
(1491, 11617, 'ELOC', 'elongin C', 'protein-coding gene', 'ENSG00000154582'),
(1492, 38146, 'ELOCP10', 'elongin C pseudogene 10', 'pseudogene', 'ENSG00000234081'),
(1493, 38152, 'ELOCP16', 'elongin C pseudogene 16', 'pseudogene', 'ENSG00000227915'),
(1494, 38154, 'ELOCP18', 'elongin C pseudogene 18', 'pseudogene', 'ENSG00000237622'),
(1495, 38159, 'ELOCP23', 'elongin C pseudogene 23', 'pseudogene', 'ENSG00000224686'),
(1496, 38160, 'ELOCP24', 'elongin C pseudogene 24', 'pseudogene', 'ENSG00000228410'),
(1497, 49172, 'ELOCP31', 'elongin C pseudogene 31', 'pseudogene', 'ENSG00000256021'),
(1498, 44156, 'ELOVL2-AS1', 'ELOVL2 antisense RNA 1', 'non-coding RNA', 'ENSG00000230314'),
(1499, 15829, 'ELOVL6', 'ELOVL fatty acid elongase 6', 'protein-coding gene', 'ENSG00000170522'),
(1500, 18248, 'ELP2', 'elongator acetyltransferase complex subunit 2', 'protein-coding gene', 'ENSG00000134759'),
(1501, 1171, 'ELP4', 'elongator acetyltransferase complex subunit 4', 'protein-coding gene', 'ENSG00000109911'),
(1502, 28957, 'EMC1', 'ER membrane protein complex subunit 1', 'protein-coding gene', 'ENSG00000127463'),
(1503, 49223, 'EMC3-AS1', 'EMC3 antisense RNA 1', 'non-coding RNA', 'ENSG00000180385'),
(1504, 24301, 'EMC7', 'ER membrane protein complex subunit 7', 'protein-coding gene', 'ENSG00000134153'),
(1505, 3331, 'EMD', 'emerin', 'protein-coding gene', 'ENSG00000102119'),
(1506, 27289, 'EME2', 'essential meiotic structure-specific endonuclease subunit 2', 'protein-coding gene', 'ENSG00000197774'),
(1507, 19880, 'EMILIN1', 'elastin microfibril interfacer 1', 'protein-coding gene', 'ENSG00000138080'),
(1508, 18071, 'EMSY', 'EMSY transcriptional repressor, BRCA2 interacting', 'protein-coding gene', 'ENSG00000158636'),
(1509, 3340, 'EMX1', 'empty spiracles homeobox 1', 'protein-coding gene', 'ENSG00000135638'),
(1510, 55659, 'EN2-DT', 'EN2 divergent transcript', 'non-coding RNA', 'ENSG00000236544'),
(1511, 3346, 'ENDOG', 'endonuclease G', 'protein-coding gene', 'ENSG00000167136'),
(1512, 14369, 'ENDOU', 'endonuclease, poly(U) specific', 'protein-coding gene', 'ENSG00000111405'),
(1513, 3349, 'ENG', 'endoglin', 'protein-coding gene', 'ENSG00000106991'),
(1514, 28388, 'ENKUR', 'enkurin, TRPC channel interacting protein', 'protein-coding gene', 'ENSG00000151023'),
(1515, 24599, 'ENOPH1', 'enolase-phosphatase 1', 'protein-coding gene', 'ENSG00000145293'),
(1516, 48688, 'ENPP7P5', 'ectonucleotide pyrophosphatase/phosphodiesterase 7 pseudogene 5', 'pseudogene', 'ENSG00000256589'),
(1517, 26352, 'ENTHD1', 'ENTH domain containing 1', 'protein-coding gene', 'ENSG00000176177'),
(1518, 3363, 'ENTPD1', 'ectonucleoside triphosphate diphosphohydrolase 1', 'protein-coding gene', 'ENSG00000138185'),
(1519, 55536, 'ENTPD4-DT', 'ENTPD4 divergent transcript', 'non-coding RNA', 'ENSG00000253390'),
(1520, 55605, 'EOGT-DT', 'EOGT divergent transcript', 'non-coding RNA', 'ENSG00000244513'),
(1521, 28089, 'EOLA1', 'endothelium and lymphocyte associated ASCH domain 1', 'protein-coding gene', 'ENSG00000197620'),
(1522, 48579, 'EOLA2-DT', 'EOLA2 divergent transcript', 'non-coding RNA', 'ENSG00000235703'),
(1523, 50504, 'EP300-AS1', 'EP300 antisense RNA 1', 'non-coding RNA', 'ENSG00000231993'),
(1524, 11958, 'EP400', 'E1A binding protein p400', 'protein-coding gene', 'ENSG00000183495'),
(1525, 3374, 'EPAS1', 'endothelial PAS domain protein 1', 'protein-coding gene', 'ENSG00000116016'),
(1526, 55728, 'EPB41L1-AS1', 'EPB41L1 antisense RNA 1', 'non-coding RNA', 'ENSG00000232406'),
(1527, 25643, 'EPB41L4A-DT', 'EPB41L4A divergent transcript', 'non-coding RNA', 'ENSG00000278921');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(1528, 19819, 'EPB41L5', 'erythrocyte membrane protein band 4.1 like 5', 'protein-coding gene', 'ENSG00000115109'),
(1529, 50717, 'EPC1-AS1', 'EPC1 antisense RNA 1', 'non-coding RNA', 'ENSG00000229327'),
(1530, 24543, 'EPC2', 'enhancer of polycomb homolog 2', 'protein-coding gene', 'ENSG00000135999'),
(1531, 17470, 'EPGN', 'epithelial mitogen', 'protein-coding gene', 'ENSG00000182585'),
(1532, 27799, 'EPHA1-AS1', 'EPHA1 antisense RNA 1', 'non-coding RNA', 'ENSG00000229153'),
(1533, 3390, 'EPHA7', 'EPH receptor A7', 'protein-coding gene', 'ENSG00000135333'),
(1534, 19987, 'EPHA10', 'EPH receptor A10', 'protein-coding gene', 'ENSG00000183317'),
(1535, 3396, 'EPHB6', 'EPH receptor B6', 'protein-coding gene', 'ENSG00000106123'),
(1536, 3401, 'EPHX1', 'epoxide hydrolase 1', 'protein-coding gene', 'ENSG00000143819'),
(1537, 27672, 'EPIC1', 'epigenetically induced MYC interacting lncRNA 1', 'non-coding RNA', 'ENSG00000224271'),
(1538, 18639, 'EPN2', 'epsin 2', 'protein-coding gene', 'ENSG00000072134'),
(1539, 3415, 'EPO', 'erythropoietin', 'protein-coding gene', 'ENSG00000130427'),
(1540, 3420, 'EPS8', 'epidermal growth factor receptor pathway substrate 8', 'protein-coding gene', 'ENSG00000151491'),
(1541, 21296, 'EPS8L2', 'EPS8 like 2', 'protein-coding gene', 'ENSG00000177106'),
(1542, 1359, 'EQTN', 'equatorin', 'protein-coding gene', 'ENSG00000120160'),
(1543, 29499, 'ERAP2', 'endoplasmic reticulum aminopeptidase 2', 'protein-coding gene', 'ENSG00000164308'),
(1544, 3430, 'ERBB2', 'erb-b2 receptor tyrosine kinase 2', 'protein-coding gene', 'ENSG00000141736'),
(1545, 3431, 'ERBB3', 'erb-b2 receptor tyrosine kinase 3', 'protein-coding gene', 'ENSG00000065361'),
(1546, 15842, 'ERBIN', 'erbb2 interacting protein', 'protein-coding gene', 'ENSG00000112851'),
(1547, 3435, 'ERCC3', 'ERCC excision repair 3, TFIIH core complex helicase subunit', 'protein-coding gene', 'ENSG00000163161'),
(1548, 20794, 'ERCC6L', 'ERCC excision repair 6 like, spindle assembly checkpoint helicase', 'protein-coding gene', 'ENSG00000186871'),
(1549, 23994, 'ERI1', 'exoribonuclease 1', 'protein-coding gene', 'ENSG00000104626'),
(1550, 41205, 'ERICH6-AS1', 'ERICH6 antisense RNA 1', 'non-coding RNA', 'ENSG00000240137'),
(1551, 25222, 'ERLEC1', 'endoplasmic reticulum lectin 1', 'protein-coding gene', 'ENSG00000068912'),
(1552, 38012, 'ERLEC1P1', 'endoplasmic reticulum lectin 1 pseudogene 1', 'pseudogene', 'ENSG00000240755'),
(1553, 16947, 'ERLIN1', 'ER lipid raft associated 1', 'protein-coding gene', 'ENSG00000107566'),
(1554, 26495, 'ERP27', 'endoplasmic reticulum protein 27', 'protein-coding gene', 'ENSG00000139055'),
(1555, 30466, 'ERVK3-1', 'endogenous retrovirus group K3 member 1', 'other', 'ENSG00000142396'),
(1556, 26501, 'ERVV-1', 'endogenous retrovirus group V member 1, envelope', 'protein-coding gene', 'ENSG00000269526'),
(1557, 17474, 'ESAM', 'endothelial cell adhesion molecule', 'protein-coding gene', 'ENSG00000149564'),
(1558, 25966, 'ESRP1', 'epithelial splicing regulatory protein 1', 'protein-coding gene', 'ENSG00000104413'),
(1559, 29534, 'ESYT1', 'extended synaptotagmin 1', 'protein-coding gene', 'ENSG00000139641'),
(1560, 23287, 'ETHE1', 'ETHE1 persulfide dioxygenase', 'protein-coding gene', 'ENSG00000105755'),
(1561, 55486, 'ETNK1-DT', 'ETNK1 divergent transcript', 'non-coding RNA', 'ENSG00000257023'),
(1562, 3493, 'ETV4', 'ETS variant transcription factor 4', 'protein-coding gene', 'ENSG00000175832'),
(1563, 40833, 'ETV7-AS1', 'ETV7 and PTX1 antisense RNA 1', 'non-coding RNA', 'ENSG00000224666'),
(1564, 25816, 'EVA1A', 'eva-1 homolog A, regulator of programmed cell death', 'protein-coding gene', 'ENSG00000115363'),
(1565, 13239, 'EVA1C', 'eva-1 homolog C', 'protein-coding gene', 'ENSG00000166979'),
(1566, 19747, 'EVC2', 'EvC ciliary complex subunit 2', 'protein-coding gene', 'ENSG00000173040'),
(1567, 40223, 'EVX1-AS', 'EVX1 antisense RNA', 'non-coding RNA', 'ENSG00000253405'),
(1568, 3507, 'EVX2', 'even-skipped homeobox 2', 'protein-coding gene', 'ENSG00000174279'),
(1569, 28507, 'EXD1', 'exonuclease 3\'-5\' domain containing 1', 'protein-coding gene', 'ENSG00000178997'),
(1570, 20217, 'EXD2', 'exonuclease 3\'-5\' domain containing 2', 'protein-coding gene', 'ENSG00000081177'),
(1571, 25175, 'EXOC3-AS1', 'EXOC3 antisense RNA 1', 'non-coding RNA', 'ENSG00000221990'),
(1572, 10696, 'EXOC5', 'exocyst complex component 5', 'protein-coding gene', 'ENSG00000070367'),
(1573, 17085, 'EXOC6B', 'exocyst complex component 6B', 'protein-coding gene', 'ENSG00000144036'),
(1574, 24659, 'EXOC8', 'exocyst complex component 8', 'protein-coding gene', 'ENSG00000116903'),
(1575, 33990, 'EXOSC3P2', 'exosome component 3 pseudogene 2', 'pseudogene', 'ENSG00000269763'),
(1576, 3513, 'EXT2', 'exostosin glycosyltransferase 2', 'protein-coding gene', 'ENSG00000151348'),
(1577, 27985, 'EXTL3-AS1', 'EXTL3 antisense RNA 1', 'non-coding RNA', 'ENSG00000246339'),
(1578, 3526, 'EZH1', 'enhancer of zeste 1 polycomb repressive complex 2 subunit', 'protein-coding gene', 'ENSG00000108799'),
(1579, 3546, 'F8', 'coagulation factor VIII', 'protein-coding gene', 'ENSG00000185010'),
(1580, 31850, 'F8A3', 'coagulation factor VIII associated 3', 'protein-coding gene', 'ENSG00000277150'),
(1581, 3528, 'F10', 'coagulation factor X', 'protein-coding gene', 'ENSG00000126218'),
(1582, 3556, 'FABP2', 'fatty acid binding protein 2', 'protein-coding gene', 'ENSG00000145384'),
(1583, 31069, 'FABP5P6', 'fatty acid binding protein 5 pseudogene 6', 'pseudogene', 'ENSG00000249919'),
(1584, 19328, 'FABP5P11', 'fatty acid binding protein 5 pseudogene 11', 'pseudogene', 'ENSG00000240122'),
(1585, 40226, 'FABP6-AS1', 'FABP6 antisense RNA 1', 'non-coding RNA', 'ENSG00000247699'),
(1586, 34524, 'FABP12', 'fatty acid binding protein 12', 'protein-coding gene', 'ENSG00000197416'),
(1587, 45176, 'FABP12P1', 'fatty acid binding protein 12 pseudogene 1', 'pseudogene', 'ENSG00000216265'),
(1588, 3574, 'FADS1', 'fatty acid desaturase 1', 'protein-coding gene', 'ENSG00000149485'),
(1589, 43618, 'FADS2B', 'fatty acid desaturase 2B, pseudogene', 'pseudogene', 'ENSG00000274150'),
(1590, 14169, 'FAHD1', 'fumarylacetoacetate hydrolase domain containing 1', 'protein-coding gene', 'ENSG00000180185'),
(1591, 18664, 'FAM3C', 'FAM3 metabolism regulating signaling molecule C', 'protein-coding gene', 'ENSG00000196937'),
(1592, 18665, 'FAM3D', 'FAM3 metabolism regulating signaling molecule D', 'protein-coding gene', 'ENSG00000198643'),
(1593, 16372, 'FAM8A1', 'family with sequence similarity 8 member A1', 'protein-coding gene', 'ENSG00000137414'),
(1594, 23017, 'FAM20B', 'FAM20B glycosaminoglycan xylosylkinase', 'protein-coding gene', 'ENSG00000116199'),
(1595, 23436, 'FAM25A', 'family with sequence similarity 25 member A', 'protein-coding gene', 'ENSG00000188100'),
(1596, 23667, 'FAM27B', 'family with sequence similarity 27 member B', 'non-coding RNA', 'ENSG00000278763'),
(1597, 34239, 'FAM32CP', 'family with sequence similarity 32 member C, pseudogene', 'pseudogene', 'ENSG00000213525'),
(1598, 27635, 'FAM41C', 'family with sequence similarity 41 member C', 'non-coding RNA', 'ENSG00000230368'),
(1599, 34343, 'FAM47E', 'family with sequence similarity 47 member E', 'protein-coding gene', 'ENSG00000189157'),
(1600, 31860, 'FAM53A', 'family with sequence similarity 53 member A', 'protein-coding gene', 'ENSG00000174137'),
(1601, 30444, 'FAM66A', 'family with sequence similarity 66 member A', 'non-coding RNA', 'ENSG00000227888'),
(1602, 24159, 'FAM66D', 'family with sequence similarity 66 member D', 'non-coding RNA', 'ENSG00000255052'),
(1603, 24805, 'FAM72B', 'family with sequence similarity 72 member B', 'protein-coding gene', 'ENSG00000188610'),
(1604, 16122, 'FAM83D', 'family with sequence similarity 83 member D', 'protein-coding gene', 'ENSG00000101447'),
(1605, 32160, 'FAM85B', 'family with sequence similarity 85 member B', 'non-coding RNA', 'ENSG00000253893'),
(1606, 25561, 'FAM86C1P', 'family with sequence similarity 86 member C1, pseudogene', 'pseudogene', 'ENSG00000158483'),
(1607, 32659, 'FAM86DP', 'family with sequence similarity 86 member D, pseudogene', 'pseudogene', 'ENSG00000244026'),
(1608, 28017, 'FAM86EP', 'family with sequence similarity 86 member E, pseudogene', 'pseudogene', 'ENSG00000251669'),
(1609, 56161, 'FAM88E', 'family with sequence similarity 88 member E', 'non-coding RNA', 'ENSG00000237357'),
(1610, 16708, 'FAM89B', 'family with sequence similarity 89 member B', 'protein-coding gene', 'ENSG00000176973'),
(1611, 25526, 'FAM90A1', 'family with sequence similarity 90 member A1', 'protein-coding gene', 'ENSG00000171847'),
(1612, 32250, 'FAM90A2P', 'family with sequence similarity 90 member A2, pseudogene', 'pseudogene', 'ENSG00000205879'),
(1613, 32255, 'FAM90A7', 'family with sequence similarity 90 member A7', 'protein-coding gene', 'ENSG00000285975'),
(1614, 32263, 'FAM90A15P', 'family with sequence similarity 90 member A15, pseudogene', 'pseudogene', 'ENSG00000230045'),
(1615, 32265, 'FAM90A17', 'family with sequence similarity 90 member A17', 'protein-coding gene', 'ENSG00000285720'),
(1616, 32268, 'FAM90A20P', 'family with sequence similarity 90 member A20, pseudogene', 'pseudogene', 'ENSG00000233295'),
(1617, 32246, 'FAM90A25P', 'family with sequence similarity 90 member A25, pseudogene', 'pseudogene', 'ENSG00000251402'),
(1618, 26306, 'FAM91A1', 'family with sequence similarity 91 member A1', 'protein-coding gene', 'ENSG00000176853'),
(1619, 27119, 'FAM98C', 'family with sequence similarity 98 member C', 'protein-coding gene', 'ENSG00000130244'),
(1620, 25682, 'FAM106A', 'family with sequence similarity 106 member A', 'non-coding RNA', 'ENSG00000273018'),
(1621, 1333, 'FAM114A2', 'family with sequence similarity 114 member A2', 'protein-coding gene', 'ENSG00000055147'),
(1622, 13247, 'FAM120A', 'family with sequence similarity 120A', 'protein-coding gene', 'ENSG00000048828'),
(1623, 55208, 'FAM131B-AS1', 'FAM131B antisense RNA 1', 'non-coding RNA', 'ENSG00000272619'),
(1624, 26717, 'FAM131C', 'family with sequence similarity 131 member C', 'protein-coding gene', 'ENSG00000185519'),
(1625, 26748, 'FAM133A', 'family with sequence similarity 133 member A', 'protein-coding gene', 'ENSG00000179083'),
(1626, 54729, 'FAM133EP', 'family with sequence similarity 133 member E, pseudogene', 'pseudogene', 'ENSG00000270528'),
(1627, 55499, 'FAM136FP', 'family with sequence similarity 136 member F, pseudogene', 'pseudogene', 'ENSG00000217178'),
(1628, 33583, 'FAM138D', 'family with sequence similarity 138 member D', 'non-coding RNA', 'ENSG00000249054'),
(1629, 24527, 'FAM149A', 'family with sequence similarity 149 member A', 'protein-coding gene', 'ENSG00000109794'),
(1630, 29162, 'FAM149B1', 'family with sequence similarity 149 member B1', 'protein-coding gene', 'ENSG00000138286'),
(1631, 25032, 'FAM151A', 'family with sequence similarity 151 member A', 'protein-coding gene', 'ENSG00000162391'),
(1632, 33936, 'FAM153CP', 'family with sequence similarity 153 member C, pseudogene', 'pseudogene', 'ENSG00000204677'),
(1633, 25808, 'FAM161A', 'FAM161 centrosomal protein A', 'protein-coding gene', 'ENSG00000170264'),
(1634, 17865, 'FAM162A', 'family with sequence similarity 162 member A', 'protein-coding gene', 'ENSG00000114023'),
(1635, 34242, 'FAM166B', 'family with sequence similarity 166 member B', 'protein-coding gene', 'ENSG00000215187'),
(1636, 15548, 'FAM167A-AS1', 'FAM167A antisense RNA 1', 'non-coding RNA', 'ENSG00000184608'),
(1637, 56226, 'FAM169A-AS1', 'FAM169A antisense RNA 1', 'non-coding RNA', 'ENSG00000271714'),
(1638, 26835, 'FAM169B', 'family with sequence similarity 169 member B', 'protein-coding gene', 'ENSG00000283597'),
(1639, 19736, 'FAM170B', 'family with sequence similarity 170 member B', 'protein-coding gene', 'ENSG00000172538'),
(1640, 24943, 'FAM174A', 'family with sequence similarity 174 member A', 'protein-coding gene', 'ENSG00000174132'),
(1641, 33773, 'FAM180A', 'family with sequence similarity 180 member A', 'protein-coding gene', 'ENSG00000189320'),
(1642, 20133, 'FAM181A-AS1', 'FAM181A antisense RNA 1', 'non-coding RNA', 'ENSG00000258584'),
(1643, 34347, 'FAM183A', 'family with sequence similarity 183 member A', 'protein-coding gene', 'ENSG00000186973'),
(1644, 34511, 'FAM183BP', 'family with sequence similarity 183 member B, pseudogene', 'pseudogene', 'ENSG00000164556'),
(1645, 29235, 'FAM184B', 'family with sequence similarity 184 member B', 'protein-coding gene', 'ENSG00000047662'),
(1646, 26366, 'FAM187B', 'family with sequence similarity 187 member B', 'protein-coding gene', 'ENSG00000177558'),
(1647, 29075, 'FAM189A1', 'family with sequence similarity 189 member A1', 'protein-coding gene', 'ENSG00000104059'),
(1648, 37464, 'FAM197Y1', 'family with sequence similarity 197 Y-linked member 1', 'pseudogene', 'ENSG00000224336'),
(1649, 37477, 'FAM197Y9', 'family with sequence similarity 197 Y-linked member 9', 'non-coding RNA', 'ENSG00000234830'),
(1650, 25401, 'FAM200A', 'family with sequence similarity 200 member A', 'protein-coding gene', 'ENSG00000221909'),
(1651, 16100, 'FAM209A', 'family with sequence similarity 209 member A', 'protein-coding gene', 'ENSG00000124103'),
(1652, 54597, 'FAM214BP1', 'FAM214B pseudogene 1', 'pseudogene', 'ENSG00000240487'),
(1653, 30180, 'FAM216A', 'family with sequence similarity 216 member A', 'protein-coding gene', 'ENSG00000204856'),
(1654, 26466, 'FAM218A', 'family with sequence similarity 218 member A', 'non-coding RNA', 'ENSG00000250486'),
(1655, 28223, 'FAM222A-AS1', 'FAM222A antisense RNA 1', 'non-coding RNA', 'ENSG00000255650'),
(1656, 30612, 'FAM223A', 'family with sequence similarity 223 member A', 'non-coding RNA', 'ENSG00000279245'),
(1657, 53977, 'FAM230H', 'family with sequence similarity 230 member H', 'non-coding RNA', 'ENSG00000206142'),
(1658, 52640, 'FAM236B', 'family with sequence similarity 236 member B', 'protein-coding gene', 'ENSG00000268994'),
(1659, 24672, 'FAM238C', 'family with sequence similarity 238 member C', 'non-coding RNA', 'ENSG00000283709'),
(1660, 53430, 'FAM240B', 'family with sequence similarity 240 member B', 'protein-coding gene', 'ENSG00000283329'),
(1661, 54200, 'FAM240C', 'family with sequence similarity 240 member C', 'protein-coding gene', 'ENSG00000216921'),
(1662, 23519, 'FAM241B', 'family with sequence similarity 241 member B', 'protein-coding gene', 'ENSG00000171224'),
(1663, 45163, 'FAM245A', 'family with sequence similarity 245 member A', 'non-coding RNA', 'ENSG00000228055'),
(1664, 29170, 'FAN1', 'FANCD2 and FANCI associated nuclease 1', 'protein-coding gene', 'ENSG00000198690'),
(1665, 3582, 'FANCA', 'FA complementation group A', 'protein-coding gene', 'ENSG00000187741'),
(1666, 3586, 'FANCE', 'FA complementation group E', 'protein-coding gene', 'ENSG00000112039'),
(1667, 16460, 'FARP2', 'FERM, ARH/RhoGEF and pleckstrin domain protein 2', 'protein-coding gene', 'ENSG00000006607'),
(1668, 50479, 'FARSA-AS1', 'FARSA antisense RNA 1', 'non-coding RNA', 'ENSG00000266975'),
(1669, 3594, 'FASN', 'fatty acid synthase', 'protein-coding gene', 'ENSG00000169710'),
(1670, 20742, 'FAXC', 'failed axon connections homolog, metaxin like GST domain containing', 'protein-coding gene', 'ENSG00000146267'),
(1671, 55107, 'FBLIM1P1', 'FBLIM1 pseudogene 1', 'pseudogene', 'ENSG00000213489'),
(1672, 55108, 'FBLIM1P2', 'FBLIM1 pseudogene 2', 'pseudogene', 'ENSG00000254871'),
(1673, 35458, 'FBLL1', 'fibrillarin like 1', 'protein-coding gene', 'ENSG00000188573'),
(1674, 3602, 'FBLN5', 'fibulin 5', 'protein-coding gene', 'ENSG00000140092'),
(1675, 55413, 'FBN1-DT', 'FBN1 divergent transcript', 'non-coding RNA', 'ENSG00000259705'),
(1676, 49924, 'FBP2P1', 'fructose-bisphosphatase 2 pseudogene 1', 'pseudogene', 'ENSG00000237743'),
(1677, 13599, 'FBXL3', 'F-box and leucine rich repeat protein 3', 'protein-coding gene', 'ENSG00000005812'),
(1678, 13603, 'FBXL6', 'F-box and leucine rich repeat protein 6', 'protein-coding gene', 'ENSG00000182325'),
(1679, 13604, 'FBXL7', 'F-box and leucine rich repeat protein 7', 'protein-coding gene', 'ENSG00000183580'),
(1680, 21658, 'FBXL13', 'F-box and leucine rich repeat protein 13', 'protein-coding gene', 'ENSG00000161040'),
(1681, 21874, 'FBXL18', 'F-box and leucine rich repeat protein 18', 'protein-coding gene', 'ENSG00000155034'),
(1682, 27537, 'FBXL22', 'F-box and leucine rich repeat protein 22', 'protein-coding gene', 'ENSG00000197361'),
(1683, 13588, 'FBXO9', 'F-box protein 9', 'protein-coding gene', 'ENSG00000112146'),
(1684, 13617, 'FBXO15', 'F-box protein 15', 'protein-coding gene', 'ENSG00000141665'),
(1685, 18754, 'FBXO17', 'F-box protein 17', 'protein-coding gene', 'ENSG00000269190'),
(1686, 16510, 'FBXO31', 'F-box protein 31', 'protein-coding gene', 'ENSG00000103264'),
(1687, 55450, 'FBXO34-AS1', 'FBXO34 antisense RNA 1', 'non-coding RNA', 'ENSG00000258413'),
(1688, 27020, 'FBXO36', 'F-box protein 36', 'protein-coding gene', 'ENSG00000153832'),
(1689, 50363, 'FBXO36P1', 'F-box protein 36 pseudogene 1', 'pseudogene', 'ENSG00000266117'),
(1690, 29249, 'FBXO42', 'F-box protein 42', 'protein-coding gene', 'ENSG00000037637'),
(1691, 31969, 'FBXO47', 'F-box protein 47', 'protein-coding gene', 'ENSG00000204952'),
(1692, 13608, 'FBXW2', 'F-box and WD repeat domain containing 2', 'protein-coding gene', 'ENSG00000119402'),
(1693, 52397, 'FBXW7-AS1', 'FBXW7 antisense RNA 1', 'non-coding RNA', 'ENSG00000270751'),
(1694, 1211, 'FBXW10', 'F-box and WD repeat domain containing 10', 'protein-coding gene', 'ENSG00000171931'),
(1695, 1145, 'FBXW11P1', 'F-box and WD repeat domain containing 11 pseudogene 1', 'pseudogene', 'ENSG00000230870'),
(1696, 44614, 'FCF1P2', 'FCF1 pseudogene 2', 'pseudogene', 'ENSG00000228638'),
(1697, 44619, 'FCF1P7', 'FCF1 pseudogene 7', 'pseudogene', 'ENSG00000224727'),
(1698, 55232, 'FCHO2-DT', 'FCHO2 divergent transcript', 'non-coding RNA', 'ENSG00000272081'),
(1699, 3624, 'FCN2', 'ficolin 2', 'protein-coding gene', 'ENSG00000160339'),
(1700, 3625, 'FCN3', 'ficolin 3', 'protein-coding gene', 'ENSG00000142748'),
(1701, 18509, 'FCRL1', 'Fc receptor like 1', 'protein-coding gene', 'ENSG00000163534'),
(1702, 18506, 'FCRL3', 'Fc receptor like 3', 'protein-coding gene', 'ENSG00000160856'),
(1703, 3634, 'FDPSP3', 'farnesyl diphosphate synthase pseudogene 3', 'pseudogene', 'ENSG00000258872'),
(1704, 25110, 'FDXACB1', 'ferredoxin-fold anticodon binding domain containing 1', 'protein-coding gene', 'ENSG00000255561'),
(1705, 17219, 'FEM1AP1', 'fem-1 homolog A pseudogene 1', 'pseudogene', 'ENSG00000229231'),
(1706, 39831, 'FEM1AP3', 'fem-1 homolog A pseudogene 3', 'pseudogene', 'ENSG00000217770'),
(1707, 39832, 'FEM1AP4', 'fem-1 homolog A pseudogene 4', 'pseudogene', 'ENSG00000235876'),
(1708, 3651, 'FEN1P1', 'flap structure-specific endonuclease 1 pseudogene 1', 'pseudogene', 'ENSG00000215873'),
(1709, 19044, 'FER1L5', 'fer-1 like family member 5', 'protein-coding gene', 'ENSG00000249715'),
(1710, 26534, 'FER1L6-AS2', 'FER1L6 antisense RNA 2', 'non-coding RNA', 'ENSG00000253868'),
(1711, 16660, 'FERD3L', 'Fer3 like bHLH transcription factor', 'protein-coding gene', 'ENSG00000146618'),
(1712, 15889, 'FERMT1', 'FERM domain containing kindlin 1', 'protein-coding gene', 'ENSG00000101311'),
(1713, 4501, 'FFAR2', 'free fatty acid receptor 2', 'protein-coding gene', 'ENSG00000126262'),
(1714, 19061, 'FFAR4', 'free fatty acid receptor 4', 'protein-coding gene', 'ENSG00000186188'),
(1715, 3661, 'FGA', 'fibrinogen alpha chain', 'protein-coding gene', 'ENSG00000171560'),
(1716, 21455, 'FGF7P1', 'fibroblast growth factor 7 pseudogene 1', 'pseudogene', 'ENSG00000264061'),
(1717, 33587, 'FGF7P4', 'fibroblast growth factor 7 pseudogene 4', 'pseudogene', 'ENSG00000216829'),
(1718, 3686, 'FGF8', 'fibroblast growth factor 8', 'protein-coding gene', 'ENSG00000107831'),
(1719, 3668, 'FGF12', 'fibroblast growth factor 12', 'protein-coding gene', 'ENSG00000114279'),
(1720, 3670, 'FGF13', 'fibroblast growth factor 13', 'protein-coding gene', 'ENSG00000129682'),
(1721, 3675, 'FGF19', 'fibroblast growth factor 19', 'protein-coding gene', 'ENSG00000162344'),
(1722, 29451, 'FGFBP2', 'fibroblast growth factor binding protein 2', 'protein-coding gene', 'ENSG00000137441'),
(1723, 39706, 'FGFR1OP2P1', 'FGFR1 oncogene partner 2 pseudogene 1', 'pseudogene', 'ENSG00000230256'),
(1724, 3703, 'FHL2', 'four and a half LIM domains 2', 'protein-coding gene', 'ENSG00000115641'),
(1725, 17905, 'FHOD1', 'formin homology 2 domain containing 1', 'protein-coding gene', 'ENSG00000135723'),
(1726, 13285, 'FIGN', 'fidgetin, microtubule severing factor', 'protein-coding gene', 'ENSG00000182263'),
(1727, 53755, 'FILNC1', 'FOXO induced long non-coding RNA 1', 'non-coding RNA', 'ENSG00000231426'),
(1728, 3711, 'FKBP1A', 'FKBP prolyl isomerase 1A', 'protein-coding gene', 'ENSG00000088832'),
(1729, 3716, 'FKBP1AP3', 'FKBP prolyl isomerase 1A pseudogene 3', 'pseudogene', 'ENSG00000230243'),
(1730, 3719, 'FKBP3', 'FKBP prolyl isomerase 3', 'protein-coding gene', 'ENSG00000100442'),
(1731, 44038, 'FKBP4P1', 'FKBP prolyl isomerase 4 pseudogene 1', 'pseudogene', 'ENSG00000251463'),
(1732, 50375, 'FKBP4P6', 'FKBP prolyl isomerase 4 pseudogene 6', 'pseudogene', 'ENSG00000268234'),
(1733, 13949, 'FKBPL', 'FKBP prolyl isomerase like', 'protein-coding gene', 'ENSG00000204315'),
(1734, 17997, 'FKRP', 'fukutin related protein', 'protein-coding gene', 'ENSG00000181027'),
(1735, 3750, 'FLII', 'FLII actin remodeling protein', 'protein-coding gene', 'ENSG00000177731'),
(1736, 3755, 'FLNB', 'filamin B', 'protein-coding gene', 'ENSG00000136068'),
(1737, 3756, 'FLNC', 'filamin C', 'protein-coding gene', 'ENSG00000128591'),
(1738, 3760, 'FLRT1', 'fibronectin leucine rich transmembrane protein 1', 'protein-coding gene', 'ENSG00000126500'),
(1739, 55912, 'FLRT2-AS1', 'FLRT2 antisense RNA 1', 'non-coding RNA', 'ENSG00000205562'),
(1740, 3763, 'FLT1', 'fms related receptor tyrosine kinase 1', 'protein-coding gene', 'ENSG00000102755'),
(1741, 55311, 'FMNL1-DT', 'FMNL1 divergent transcript', 'non-coding RNA', 'ENSG00000267121'),
(1742, 3771, 'FMO3', 'flavin containing dimethylaniline monoxygenase 3', 'protein-coding gene', 'ENSG00000007933'),
(1743, 32212, 'FMO11P', 'flavin containing dimethylaniline monoxygenase 11, pseudogene', 'pseudogene', 'ENSG00000232148'),
(1744, 3774, 'FMOD', 'fibromodulin', 'protein-coding gene', 'ENSG00000122176'),
(1745, 39081, 'FMR1-AS1', 'FMR1 antisense RNA 1', 'non-coding RNA', 'ENSG00000268066'),
(1746, 55775, 'FN1-DT', 'FN1 divergent transcript', 'non-coding RNA', 'ENSG00000230695'),
(1747, 19752, 'FNBP4', 'formin binding protein 4', 'protein-coding gene', 'ENSG00000109920'),
(1748, 55706, 'FNDC1-AS1', 'FNDC1 antisense RNA 1', 'non-coding RNA', 'ENSG00000233682'),
(1749, 25286, 'FNDC8', 'fibronectin type III domain containing 8', 'protein-coding gene', 'ENSG00000073598'),
(1750, 33547, 'FNDC9', 'fibronectin type III domain containing 9', 'protein-coding gene', 'ENSG00000172568'),
(1751, 28764, 'FNDC11', 'fibronectin type III domain containing 11', 'protein-coding gene', 'ENSG00000125531'),
(1752, 44055, 'FOSL1P1', 'FOSL1 pseudogene 1', 'pseudogene', 'ENSG00000248394'),
(1753, 3798, 'FOSL2', 'FOS like 2, AP-1 transcription factor subunit', 'protein-coding gene', 'ENSG00000075426'),
(1754, 5021, 'FOXA1', 'forkhead box A1', 'protein-coding gene', 'ENSG00000129514'),
(1755, 44256, 'FOXD2-AS1', 'FOXD2 adjacent opposite strand RNA 1', 'non-coding RNA', 'ENSG00000237424'),
(1756, 18523, 'FOXD4L3', 'forkhead box D4 like 3', 'protein-coding gene', 'ENSG00000187559'),
(1757, 50662, 'FOXF2-DT', 'FOXF2 divergent transcript', 'non-coding RNA', 'ENSG00000261730'),
(1758, 3814, 'FOXH1', 'forkhead box H1', 'protein-coding gene', 'ENSG00000160973'),
(1759, 29178, 'FOXJ3', 'forkhead box J3', 'protein-coding gene', 'ENSG00000198815'),
(1760, 3818, 'FOXM1', 'forkhead box M1', 'protein-coding gene', 'ENSG00000111206'),
(1761, 50332, 'FOXP4-AS1', 'FOXP4 antisense RNA 1', 'non-coding RNA', 'ENSG00000234753'),
(1762, 26927, 'FOXRED1', 'FAD dependent oxidoreductase domain containing 1', 'protein-coding gene', 'ENSG00000110074'),
(1763, 3828, 'FPR3', 'formyl peptide receptor 3', 'protein-coding gene', 'ENSG00000187474'),
(1764, 19185, 'FRAS1', 'Fraser extracellular matrix complex subunit 1', 'protein-coding gene', 'ENSG00000138759'),
(1765, 3944, 'FRAT1', 'FRAT regulator of WNT signaling pathway 1', 'protein-coding gene', 'ENSG00000165879'),
(1766, 3954, 'FRG1', 'FSHD region gene 1', 'protein-coding gene', 'ENSG00000109536'),
(1767, 51763, 'FRG1DP', 'FSHD region gene 1 family member D, pseudogene', 'pseudogene', 'ENSG00000282870'),
(1768, 51764, 'FRG1EP', 'FSHD region gene 1 family member E, pseudogene', 'pseudogene', 'ENSG00000282995'),
(1769, 51769, 'FRG1KP', 'FSHD region gene 1 family member K, pseudogene', 'pseudogene', 'ENSG00000280286'),
(1770, 33626, 'FRG2C', 'FSHD region gene 2 family member C', 'protein-coding gene', 'ENSG00000172969'),
(1771, 51797, 'FRG2KP', 'FSHD region gene 2 family member K, pseudogene', 'pseudogene', 'ENSG00000261741'),
(1772, 20129, 'FRMD6-AS1', 'FRMD6 antisense RNA 1', 'non-coding RNA', 'ENSG00000273888'),
(1773, 25462, 'FRMD8', 'FERM domain containing 8', 'protein-coding gene', 'ENSG00000126391'),
(1774, 29382, 'FRMPD3', 'FERM and PDZ domain containing 3', 'protein-coding gene', 'ENSG00000147234'),
(1775, 1362, 'FRRS1L', 'ferric chelate reductase 1 like', 'protein-coding gene', 'ENSG00000260230'),
(1776, 16970, 'FRS3', 'fibroblast growth factor receptor substrate 3', 'protein-coding gene', 'ENSG00000137218'),
(1777, 20367, 'FRY', 'FRY microtubule binding protein', 'protein-coding gene', 'ENSG00000073910'),
(1778, 3960, 'FSCN2', 'fascin actin-bundling protein 2, retinal', 'protein-coding gene', 'ENSG00000186765'),
(1779, 18024, 'FSD2', 'fibronectin type III and SPRY domain containing 2', 'protein-coding gene', 'ENSG00000186628'),
(1780, 21675, 'FSIP2', 'fibrous sheath interacting protein 2', 'protein-coding gene', 'ENSG00000188738'),
(1781, 3972, 'FSTL1', 'follistatin like 1', 'protein-coding gene', 'ENSG00000163430'),
(1782, 39088, 'FTH1P6', 'ferritin heavy chain 1 pseudogene 6', 'pseudogene', 'ENSG00000233083'),
(1783, 39090, 'FTH1P14', 'ferritin heavy chain 1 pseudogene 14', 'pseudogene', 'ENSG00000185638'),
(1784, 37643, 'FTH1P25', 'ferritin heavy chain 1 pseudogene 25', 'pseudogene', 'ENSG00000232792'),
(1785, 39091, 'FTH1P27', 'ferritin heavy chain 1 pseudogene 27', 'pseudogene', 'ENSG00000234355'),
(1786, 3999, 'FTL', 'ferritin light chain', 'protein-coding gene', 'ENSG00000087086'),
(1787, 37953, 'FTLP5', 'ferritin light chain pseudogene 5', 'pseudogene', 'ENSG00000266989'),
(1788, 37964, 'FTLP14', 'ferritin light chain pseudogene 14', 'pseudogene', 'ENSG00000260459'),
(1789, 37965, 'FTLP15', 'ferritin light chain pseudogene 15', 'pseudogene', 'ENSG00000233952'),
(1790, 37968, 'FTLP18', 'ferritin light chain pseudogene 18', 'pseudogene', 'ENSG00000230214'),
(1791, 17136, 'FTSJ3', 'FtsJ RNA 2\'-O-methyltransferase 3', 'protein-coding gene', 'ENSG00000108592'),
(1792, 24733, 'FUOM', 'fucose mutarotase', 'protein-coding gene', 'ENSG00000148803'),
(1793, 4012, 'FUT1', 'fucosyltransferase 1 (H blood group)', 'protein-coding gene', 'ENSG00000174951'),
(1794, 4019, 'FUT8', 'fucosyltransferase 8', 'protein-coding gene', 'ENSG00000033170'),
(1795, 26219, 'FUZ', 'fuzzy planar cell polarity protein', 'protein-coding gene', 'ENSG00000010361'),
(1796, 39978, 'FXYD6-FXYD2', 'FXYD6-FXYD2 readthrough', 'other', 'ENSG00000255245'),
(1797, 25407, 'FYTTD1', 'forty-two-three domain containing 1', 'protein-coding gene', 'ENSG00000122068'),
(1798, 4043, 'FZD5', 'frizzled class receptor 5', 'protein-coding gene', 'ENSG00000163251'),
(1799, 4044, 'FZD6', 'frizzled class receptor 6', 'protein-coding gene', 'ENSG00000164930'),
(1800, 4046, 'FZD8', 'frizzled class receptor 8', 'protein-coding gene', 'ENSG00000177283'),
(1801, 14458, 'GAB2', 'GRB2 associated binding protein 2', 'protein-coding gene', 'ENSG00000033327'),
(1802, 4070, 'GABBR1', 'gamma-aminobutyric acid type B receptor subunit 1', 'protein-coding gene', 'ENSG00000204681'),
(1803, 4075, 'GABRA1', 'gamma-aminobutyric acid type A receptor subunit alpha1', 'protein-coding gene', 'ENSG00000022355'),
(1804, 4088, 'GABRG3', 'gamma-aminobutyric acid type A receptor subunit gamma3', 'protein-coding gene', 'ENSG00000182256'),
(1805, 4091, 'GABRR2', 'gamma-aminobutyric acid type A receptor subunit rho2', 'protein-coding gene', 'ENSG00000111886'),
(1806, 29996, 'GADD45GIP1', 'GADD45G interacting protein 1', 'protein-coding gene', 'ENSG00000179271'),
(1807, 4099, 'GAGE2A', 'G antigen 2A', 'protein-coding gene', 'ENSG00000189064'),
(1808, 31906, 'GAGE12F', 'G antigen 12F', 'protein-coding gene', 'ENSG00000236362'),
(1809, 29081, 'GAGE13', 'G antigen 13', 'protein-coding gene', 'ENSG00000274274'),
(1810, 24145, 'GAL3ST4', 'galactose-3-O-sulfotransferase 4', 'protein-coding gene', 'ENSG00000197093'),
(1811, 4118, 'GALK1', 'galactokinase 1', 'protein-coding gene', 'ENSG00000108479'),
(1812, 4124, 'GALNT2', 'polypeptide N-acetylgalactosaminyltransferase 2', 'protein-coding gene', 'ENSG00000143641'),
(1813, 4129, 'GALNT7', 'polypeptide N-acetylgalactosaminyltransferase 7', 'protein-coding gene', 'ENSG00000109586'),
(1814, 19875, 'GALNT11', 'polypeptide N-acetylgalactosaminyltransferase 11', 'protein-coding gene', 'ENSG00000178234'),
(1815, 16347, 'GALNT17', 'polypeptide N-acetylgalactosaminyltransferase 17', 'protein-coding gene', 'ENSG00000185274'),
(1816, 4135, 'GALT', 'galactose-1-phosphate uridylyltransferase', 'protein-coding gene', 'ENSG00000213930'),
(1817, 4138, 'GANAB', 'glucosidase II alpha subunit', 'protein-coding gene', 'ENSG00000089597'),
(1818, 16577, 'GAPDHP2', 'glyceraldehyde-3-phosphate dehydrogenase pseudogene 2', 'pseudogene', 'ENSG00000236811'),
(1819, 37773, 'GAPDHP21', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 21', 'pseudogene', 'ENSG00000236993'),
(1820, 37779, 'GAPDHP27', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 27', 'pseudogene', 'ENSG00000239873'),
(1821, 37780, 'GAPDHP28', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 28', 'pseudogene', 'ENSG00000213449'),
(1822, 37782, 'GAPDHP30', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 30', 'pseudogene', 'ENSG00000183663'),
(1823, 37786, 'GAPDHP34', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 34', 'pseudogene', 'ENSG00000235306'),
(1824, 37791, 'GAPDHP37', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 37', 'pseudogene', 'ENSG00000231907'),
(1825, 37805, 'GAPDHP48', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 48', 'pseudogene', 'ENSG00000232718'),
(1826, 38556, 'GAPDHP50', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 50', 'pseudogene', 'ENSG00000241861'),
(1827, 38559, 'GAPDHP53', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 53', 'pseudogene', 'ENSG00000234069'),
(1828, 38560, 'GAPDHP54', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 54', 'pseudogene', 'ENSG00000226769'),
(1829, 38561, 'GAPDHP55', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 55', 'pseudogene', 'ENSG00000224055'),
(1830, 4155, 'GAPDHP61', 'glyceraldehyde 3 phosphate dehydrogenase pseudogene 61', 'pseudogene', 'ENSG00000248415'),
(1831, 50648, 'GAPDHP75', 'glyceraldehyde-3-phosphate dehydrogenase pseudogene 75', 'pseudogene', 'ENSG00000226196'),
(1832, 27998, 'GARIN1A', 'golgi associated RAB2 interactor 1A', 'protein-coding gene', 'ENSG00000205085'),
(1833, 30704, 'GARIN1B', 'golgi associated RAB2 interactor 1B', 'protein-coding gene', 'ENSG00000135248'),
(1834, 28397, 'GARIN3', 'golgi associated RAB2B interactor family member 3', 'protein-coding gene', 'ENSG00000170613'),
(1835, 52261, 'GAS1RR', 'GAS1 adjacent regulatory RNA', 'non-coding RNA', 'ENSG00000226237'),
(1836, 16955, 'GAS2L1', 'growth arrest specific 2 like 1', 'protein-coding gene', 'ENSG00000185340'),
(1837, 27475, 'GAS2L3', 'growth arrest specific 2 like 3', 'protein-coding gene', 'ENSG00000139354'),
(1838, 44119, 'GAS5-AS1', 'GAS5 antisense RNA 1', 'non-coding RNA', 'ENSG00000270084'),
(1839, 25312, 'GASK1B', 'golgi associated kinase 1B', 'protein-coding gene', 'ENSG00000164125'),
(1840, 15802, 'GATA5', 'GATA binding protein 5', 'protein-coding gene', 'ENSG00000130700'),
(1841, 4174, 'GATA6', 'GATA binding protein 6', 'protein-coding gene', 'ENSG00000141448'),
(1842, 29907, 'GATD1-DT', 'GATD1 divergent transcript', 'non-coding RNA', 'ENSG00000255284'),
(1843, 4178, 'GBAP1', 'glucosylceramidase beta pseudogene 1', 'pseudogene', 'ENSG00000160766'),
(1844, 4180, 'GBE1', '1,4-alpha-glucan branching enzyme 1', 'protein-coding gene', 'ENSG00000114480'),
(1845, 4188, 'GCAT', 'glycine C-acetyltransferase', 'protein-coding gene', 'ENSG00000100116'),
(1846, 20013, 'GCATP1', 'glycine C-acetyltransferase pseudogene 1', 'pseudogene', 'ENSG00000270878'),
(1847, 53740, 'GCAWKR', 'gastric cancer associated WDR5 and KAT2A binding lncRNA', 'non-coding RNA', 'ENSG00000272808'),
(1848, 4189, 'GCDH', 'glutaryl-CoA dehydrogenase', 'protein-coding gene', 'ENSG00000105607'),
(1849, 4191, 'GCG', 'glucagon', 'protein-coding gene', 'ENSG00000115263'),
(1850, 4196, 'GCKR', 'glucokinase regulator', 'protein-coding gene', 'ENSG00000084734'),
(1851, 4198, 'GCM2', 'glial cells missing transcription factor 2', 'protein-coding gene', 'ENSG00000124827'),
(1852, 37974, 'GCNT1P4', 'glucosaminyl (N-acetyl) transferase 1 pseudogene 4', 'pseudogene', 'ENSG00000219653'),
(1853, 4204, 'GCNT2', 'glucosaminyl (N-acetyl) transferase 2 (I blood group)', 'protein-coding gene', 'ENSG00000111846'),
(1854, 29583, 'GCSAML', 'germinal center associated signaling and motility like', 'protein-coding gene', 'ENSG00000169224'),
(1855, 54400, 'GCSIR', 'GPR55 cis regulatory suppressor of immune response RNA', 'non-coding RNA', 'ENSG00000232520'),
(1856, 18010, 'GDAP2', 'ganglioside induced differentiation associated protein 2', 'protein-coding gene', 'ENSG00000196505'),
(1857, 4220, 'GDF5', 'growth differentiation factor 5', 'protein-coding gene', 'ENSG00000125965'),
(1858, 43592, 'GDNF-AS1', 'GDNF antisense RNA 1', 'non-coding RNA', 'ENSG00000248587'),
(1859, 28638, 'GDPD3', 'glycerophosphodiester phosphodiesterase domain containing 3', 'protein-coding gene', 'ENSG00000102886'),
(1860, 28804, 'GDPD5', 'glycerophosphodiester phosphodiesterase domain containing 5', 'protein-coding gene', 'ENSG00000158555'),
(1861, 34360, 'GDPGP1', 'GDP-D-glucose phosphorylase 1', 'protein-coding gene', 'ENSG00000183208'),
(1862, 37977, 'GEMIN8P2', 'gem nuclear organelle associated protein 8 pseudogene 2', 'pseudogene', 'ENSG00000260451'),
(1863, 37978, 'GEMIN8P3', 'gem nuclear organelle associated protein 8 pseudogene 3', 'pseudogene', 'ENSG00000223772'),
(1864, 26881, 'GEN1', 'GEN1 Holliday junction 5\' flap endonuclease', 'protein-coding gene', 'ENSG00000178295'),
(1865, 44010, 'GET1P1', 'GET1 pseudogene 1', 'pseudogene', 'ENSG00000248633'),
(1866, 28159, 'GFOD2', 'glucose-fructose oxidoreductase domain containing 2', 'protein-coding gene', 'ENSG00000141098'),
(1867, 4241, 'GFPT1', 'glutamine--fructose-6-phosphate transaminase 1', 'protein-coding gene', 'ENSG00000198380'),
(1868, 4242, 'GFPT2', 'glutamine-fructose-6-phosphate transaminase 2', 'protein-coding gene', 'ENSG00000131459'),
(1869, 13821, 'GFRA4', 'GDNF family receptor alpha 4', 'protein-coding gene', 'ENSG00000125861'),
(1870, 19427, 'GGNBP1', 'gametogenetin binding protein 1 (pseudogene)', 'pseudogene', 'ENSG00000204188'),
(1871, 4251, 'GGT2P', 'gamma-glutamyltransferase 2, pseudogene', 'pseudogene', 'ENSG00000133475'),
(1872, 33438, 'GGT8P', 'gamma-glutamyltransferase 8 pseudogene', 'pseudogene', 'ENSG00000236969'),
(1873, 4254, 'GGTA2P', 'glycoprotein alpha-galactosyltransferase 2, pseudogene', 'pseudogene', 'ENSG00000237766'),
(1874, 33427, 'GGTLC5P', 'gamma-glutamyltransferase light chain 5 pseudogene', 'pseudogene', 'ENSG00000276160'),
(1875, 4261, 'GH1', 'growth hormone 1', 'protein-coding gene', 'ENSG00000259384'),
(1876, 4262, 'GH2', 'growth hormone 2', 'protein-coding gene', 'ENSG00000136487'),
(1877, 18129, 'GHRL', 'ghrelin and obestatin prepropeptide', 'protein-coding gene', 'ENSG00000157017'),
(1878, 15857, 'GID8', 'GID complex subunit 8 homolog', 'protein-coding gene', 'ENSG00000101193'),
(1879, 11960, 'GIGYF2', 'GRB10 interacting GYF protein 2', 'protein-coding gene', 'ENSG00000204120'),
(1880, 30975, 'GIMAP3P', 'GTPase, IMAP family member 3 pseudogene', 'pseudogene', 'ENSG00000177590'),
(1881, 25959, 'GIN1', 'gypsy retrotransposon integrase 1', 'protein-coding gene', 'ENSG00000145723'),
(1882, 4270, 'GIP', 'gastric inhibitory polypeptide', 'protein-coding gene', 'ENSG00000159224'),
(1883, 18177, 'GIPC2', 'GIPC PDZ domain containing family member 2', 'protein-coding gene', 'ENSG00000137960'),
(1884, 18183, 'GIPC3', 'GIPC PDZ domain containing family member 3', 'protein-coding gene', 'ENSG00000179855'),
(1885, 4272, 'GIT1', 'GIT ArfGAP 1', 'protein-coding gene', 'ENSG00000108262'),
(1886, 4274, 'GJA1', 'gap junction protein alpha 1', 'protein-coding gene', 'ENSG00000152661'),
(1887, 4278, 'GJA4', 'gap junction protein alpha 4', 'protein-coding gene', 'ENSG00000187513'),
(1888, 4284, 'GJB2', 'gap junction protein beta 2', 'protein-coding gene', 'ENSG00000165474'),
(1889, 16690, 'GJB7', 'gap junction protein beta 7', 'protein-coding gene', 'ENSG00000164411'),
(1890, 25147, 'GLB1L3', 'galactosidase beta 1 like 3', 'protein-coding gene', 'ENSG00000166105'),
(1891, 28392, 'GLIPR1L1', 'GLIPR1 like 1', 'protein-coding gene', 'ENSG00000173401'),
(1892, 18007, 'GLIPR2', 'GLI pathogenesis related 2', 'protein-coding gene', 'ENSG00000122694'),
(1893, 29450, 'GLIS2', 'GLIS family zinc finger 2', 'protein-coding gene', 'ENSG00000126603'),
(1894, 4328, 'GLRA3', 'glycine receptor alpha 3', 'protein-coding gene', 'ENSG00000145451'),
(1895, 4338, 'GLUD1P3', 'glutamate dehydrogenase 1 pseudogene 3', 'pseudogene', 'ENSG00000250959'),
(1896, 4344, 'GLULP3', 'glutamate-ammonia ligase pseudogene 3', 'pseudogene', 'ENSG00000254572'),
(1897, 30519, 'GLYATL1', 'glycine-N-acyltransferase like 1', 'protein-coding gene', 'ENSG00000166840'),
(1898, 18023, 'GLYCAM1', 'glycosylation dependent cell adhesion molecule 1 (pseudogene)', 'pseudogene', 'ENSG00000257780'),
(1899, 4367, 'GM2A', 'ganglioside GM2 activator', 'protein-coding gene', 'ENSG00000196743'),
(1900, 4368, 'GM2AP1', 'GM2A pseudogene 1', 'pseudogene', 'ENSG00000241695'),
(1901, 23843, 'GMCL1', 'germ cell-less 1, spermatogenesis associated', 'protein-coding gene', 'ENSG00000087338'),
(1902, 48993, 'GMDS-DT', 'GMDS divergent transcript', 'non-coding RNA', 'ENSG00000250903'),
(1903, 4377, 'GMPR2', 'guanosine monophosphate reductase 2', 'protein-coding gene', 'ENSG00000100938'),
(1904, 4379, 'GNA11', 'G protein subunit alpha 11', 'protein-coding gene', 'ENSG00000088256'),
(1905, 55293, 'GNA15-DT', 'GNA15 divergent transcript', 'non-coding RNA', 'ENSG00000267551'),
(1906, 4391, 'GNAQP1', 'G protein subunit alpha q pseudogene 1', 'pseudogene', 'ENSG00000214077'),
(1907, 4393, 'GNAT1', 'G protein subunit alpha transducin 1', 'protein-coding gene', 'ENSG00000114349'),
(1908, 4397, 'GNB1L', 'G protein subunit beta 1 like', 'protein-coding gene', 'ENSG00000185838'),
(1909, 4400, 'GNB3', 'G protein subunit beta 3', 'protein-coding gene', 'ENSG00000111664'),
(1910, 4409, 'GNG5P1', 'G protein subunit gamma 5 pseudogene 1', 'pseudogene', 'ENSG00000213536'),
(1911, 4410, 'GNG7', 'G protein subunit gamma 7', 'protein-coding gene', 'ENSG00000176533'),
(1912, 19664, 'GNG8', 'G protein subunit gamma 8', 'protein-coding gene', 'ENSG00000167414'),
(1913, 4403, 'GNG11', 'G protein subunit gamma 11', 'protein-coding gene', 'ENSG00000127920'),
(1914, 4412, 'GNGT2', 'G protein subunit gamma transducin 2', 'protein-coding gene', 'ENSG00000167083'),
(1915, 29925, 'GNL2', 'G protein nucleolar 2', 'protein-coding gene', 'ENSG00000134697'),
(1916, 50779, 'GNL2P1', 'G protein nucleolar 2 pseudogene 1', 'pseudogene', 'ENSG00000223893'),
(1917, 25553, 'GNL3L', 'G protein nucleolar 3 like', 'protein-coding gene', 'ENSG00000130119'),
(1918, 25733, 'GNL3LP1', 'G protein nucleolar 3 like pseudogene 1', 'pseudogene', 'ENSG00000215032'),
(1919, 34031, 'GNPATP', 'glyceronephosphate O-acyltransferase pseudogene', 'pseudogene', 'ENSG00000259844'),
(1920, 4417, 'GNPDA1', 'glucosamine-6-phosphate deaminase 1', 'protein-coding gene', 'ENSG00000113552'),
(1921, 21526, 'GNPDA2', 'glucosamine-6-phosphate deaminase 2', 'protein-coding gene', 'ENSG00000163281'),
(1922, 23026, 'GNPTG', 'N-acetylglucosamine-1-phosphate transferase subunit gamma', 'protein-coding gene', 'ENSG00000090581'),
(1923, 4420, 'GNRH2', 'gonadotropin releasing hormone 2', 'protein-coding gene', 'ENSG00000125787'),
(1924, 4421, 'GNRHR', 'gonadotropin releasing hormone receptor', 'protein-coding gene', 'ENSG00000109163'),
(1925, 39424, 'GNRHR2P1', 'GNRHR2 pseudogene 1', 'pseudogene', 'ENSG00000259169'),
(1926, 49922, 'GOLGA2P8', 'GOLGA2 pseudogene 8', 'pseudogene', 'ENSG00000214433'),
(1927, 4427, 'GOLGA4', 'golgin A4', 'protein-coding gene', 'ENSG00000144674'),
(1928, 49206, 'GOLGA6FP', 'golgin A6 family member F, pseudogene', 'pseudogene', 'ENSG00000260776'),
(1929, 55709, 'GOLGA6GP', 'golgin A6 family member G, pseudogene', 'pseudogene', 'ENSG00000261303'),
(1930, 37225, 'GOLGA6L6', 'golgin A6 family like 6', 'protein-coding gene', 'ENSG00000277322'),
(1931, 37442, 'GOLGA6L7', 'golgin A6 family like 7', 'protein-coding gene', 'ENSG00000261649'),
(1932, 31973, 'GOLGA8B', 'golgin A8 family member B', 'protein-coding gene', 'ENSG00000215252'),
(1933, 32377, 'GOLGA8EP', 'golgin A8 family member E, pseudogene', 'pseudogene', 'ENSG00000185182'),
(1934, 37443, 'GOLGA8H', 'golgin A8 family member H', 'protein-coding gene', 'ENSG00000261794'),
(1935, 44406, 'GOLGA8O', 'golgin A8 family member O', 'protein-coding gene', 'ENSG00000206127'),
(1936, 44408, 'GOLGA8Q', 'golgin A8 family member Q', 'protein-coding gene', 'ENSG00000178115'),
(1937, 49920, 'GOLGA8VP', 'golgin A8 family member V, pseudogene', 'pseudogene', 'ENSG00000259236'),
(1938, 55346, 'GOSR2-DT', 'GOSR2 divergent transcript', 'non-coding RNA', 'ENSG00000261886'),
(1939, 55848, 'GOT1-DT', 'GOT1 divergent transcript', 'non-coding RNA', 'ENSG00000224934'),
(1940, 54892, 'GOT2P7', 'GOT2 pseudogene 7', 'pseudogene', 'ENSG00000232392'),
(1941, 14388, 'GP6', 'glycoprotein VI platelet', 'protein-coding gene', 'ENSG00000088053'),
(1942, 24865, 'GPAM', 'glycerol-3-phosphate acyltransferase, mitochondrial', 'protein-coding gene', 'ENSG00000119927'),
(1943, 13920, 'GPANK1', 'G-patch domain and ankyrin repeats 1', 'protein-coding gene', 'ENSG00000204438'),
(1944, 25499, 'GPATCH2', 'G-patch domain containing 2', 'protein-coding gene', 'ENSG00000092978'),
(1945, 29066, 'GPATCH8', 'G-patch domain containing 8', 'protein-coding gene', 'ENSG00000186566'),
(1946, 28843, 'GPBP1L1', 'GC-rich promoter binding protein 1 like 1', 'protein-coding gene', 'ENSG00000159592'),
(1947, 4451, 'GPC3', 'glypican 3', 'protein-coding gene', 'ENSG00000147257'),
(1948, 39887, 'GPC5-AS2', 'GPC5 antisense RNA 2', 'non-coding RNA', 'ENSG00000232885'),
(1949, 4454, 'GPC6', 'glypican 6', 'protein-coding gene', 'ENSG00000183098'),
(1950, 39909, 'GPC6-AS1', 'GPC6 antisense RNA 1', 'non-coding RNA', 'ENSG00000236520'),
(1951, 18054, 'GPHA2', 'glycoprotein hormone subunit alpha 2', 'protein-coding gene', 'ENSG00000149735'),
(1952, 18055, 'GPHB5', 'glycoprotein hormone subunit beta 5', 'protein-coding gene', 'ENSG00000179600'),
(1953, 15465, 'GPHN', 'gephyrin', 'protein-coding gene', 'ENSG00000171723'),
(1954, 4458, 'GPI', 'glucose-6-phosphate isomerase', 'protein-coding gene', 'ENSG00000105220'),
(1955, 24945, 'GPIHBP1', 'glycosylphosphatidylinositol anchored high density lipoprotein binding protein 1', 'protein-coding gene', 'ENSG00000277494'),
(1956, 17030, 'GPN1', 'GPN-loop GTPase 1', 'protein-coding gene', 'ENSG00000198522'),
(1957, 25513, 'GPN2', 'GPN-loop GTPase 2', 'protein-coding gene', 'ENSG00000142751'),
(1958, 4472, 'GPR18', 'G protein-coupled receptor 18', 'protein-coding gene', 'ENSG00000125245'),
(1959, 4481, 'GPR26', 'G protein-coupled receptor 26', 'protein-coding gene', 'ENSG00000154478'),
(1960, 4487, 'GPR32', 'G protein-coupled receptor 32', 'protein-coding gene', 'ENSG00000142511'),
(1961, 14923, 'GPR37L1', 'G protein-coupled receptor 37 like 1', 'protein-coding gene', 'ENSG00000170075'),
(1962, 56187, 'GPR84-AS1', 'GPR84, ZNF385A, ITGA5 and GTSF1 antisense RNA 1', 'non-coding RNA', 'ENSG00000258086'),
(1963, 17482, 'GPR132', 'G protein-coupled receptor 132', 'protein-coding gene', 'ENSG00000183484'),
(1964, 19991, 'GPR135', 'G protein-coupled receptor 135', 'protein-coding gene', 'ENSG00000181619'),
(1965, 23624, 'GPR151', 'G protein-coupled receptor 151', 'protein-coding gene', 'ENSG00000173250'),
(1966, 55827, 'GPR155-DT', 'GPR155 divergent transcript', 'non-coding RNA', 'ENSG00000226853'),
(1967, 54683, 'GPR160P2', 'GPR160 pseudogene 2', 'pseudogene', 'ENSG00000265863'),
(1968, 18186, 'GPR173', 'G protein-coupled receptor 173', 'protein-coding gene', 'ENSG00000184194'),
(1969, 30245, 'GPR174', 'G protein-coupled receptor 174', 'protein-coding gene', 'ENSG00000147138'),
(1970, 13708, 'GPR182', 'G protein-coupled receptor 182', 'protein-coding gene', 'ENSG00000166856'),
(1971, 24834, 'GPRASP1', 'G protein-coupled receptor associated sorting protein 1', 'protein-coding gene', 'ENSG00000198932'),
(1972, 49622, 'GPS2P1', 'G protein pathway suppressor 2 pseudogene 1', 'pseudogene', 'ENSG00000236496'),
(1973, 18062, 'GPT2', 'glutamic--pyruvic transaminase 2', 'protein-coding gene', 'ENSG00000166123'),
(1974, 4560, 'GPX1P1', 'glutathione peroxidase pseudogene 1', 'pseudogene', 'ENSG00000197582'),
(1975, 4554, 'GPX2', 'glutathione peroxidase 2', 'protein-coding gene', 'ENSG00000176153'),
(1976, 33100, 'GPX8', 'glutathione peroxidase 8 (putative)', 'protein-coding gene', 'ENSG00000164294'),
(1977, 55275, 'GRAMD1A-AS1', 'GRAMD1A antisense RNA 1', 'non-coding RNA', 'ENSG00000269303'),
(1978, 24911, 'GRAMD2B', 'GRAM domain containing 2B', 'protein-coding gene', 'ENSG00000155324'),
(1979, 29113, 'GRAMD4', 'GRAM domain containing 4', 'protein-coding gene', 'ENSG00000075240'),
(1980, 39653, 'GRAMD4P1', 'GRAM domain containing 4 pseudogene 1', 'pseudogene', 'ENSG00000227874'),
(1981, 49139, 'GRAMD4P4', 'GRAM domain containing 4 pseudogene 4', 'pseudogene', 'ENSG00000274369'),
(1982, 27549, 'GREP1', 'glycine rich extracellular protein 1', 'protein-coding gene', 'ENSG00000262152'),
(1983, 16458, 'GRIK1-AS1', 'GRIK1 antisense RNA 1', 'non-coding RNA', 'ENSG00000174680'),
(1984, 16768, 'GRIN3B', 'glutamate ionotropic receptor NMDA type subunit 3B', 'protein-coding gene', 'ENSG00000116032'),
(1985, 4599, 'GRM7', 'glutamate metabotropic receptor 7', 'protein-coding gene', 'ENSG00000196277'),
(1986, 21060, 'GRPEL2', 'GrpE like 2, mitochondrial', 'protein-coding gene', 'ENSG00000164284'),
(1987, 4609, 'GRPR', 'gastrin releasing peptide receptor', 'protein-coding gene', 'ENSG00000126010'),
(1988, 4610, 'GRSF1', 'G-rich RNA sequence binding factor 1', 'protein-coding gene', 'ENSG00000132463'),
(1989, 4612, 'GSC', 'goosecoid homeobox', 'protein-coding gene', 'ENSG00000133937'),
(1990, 2810, 'GSDME', 'gasdermin E', 'protein-coding gene', 'ENSG00000105928'),
(1991, 19716, 'GSG1', 'germ cell associated 1', 'protein-coding gene', 'ENSG00000111305'),
(1992, 55635, 'GSK3B-DT', 'GSK3B divergent transcript', 'non-coding RNA', 'ENSG00000242622'),
(1993, 19662, 'GSTA5', 'glutathione S-transferase alpha 5', 'protein-coding gene', 'ENSG00000182793'),
(1994, 4631, 'GSTA7P', 'glutathione S-transferase alpha 7, pseudogene', 'pseudogene', 'ENSG00000237674'),
(1995, 16606, 'GSTM3P1', 'glutathione S-transferase mu 3 pseudogene 1', 'pseudogene', 'ENSG00000227693'),
(1996, 38006, 'GSTM3P2', 'glutathione S-transferase mu 3 pseudogene 2', 'pseudogene', 'ENSG00000226878'),
(1997, 23064, 'GSTO2', 'glutathione S-transferase omega 2', 'protein-coding gene', 'ENSG00000065621'),
(1998, 4638, 'GSTP1', 'glutathione S-transferase pi 1', 'protein-coding gene', 'ENSG00000084207'),
(1999, 56195, 'GTF2A1-AS1', 'GTF2A1 antisense RNA 1', 'non-coding RNA', 'ENSG00000273783'),
(2000, 4650, 'GTF2E1', 'general transcription factor IIE subunit 1', 'protein-coding gene', 'ENSG00000153767'),
(2001, 4655, 'GTF2H1', 'general transcription factor IIH subunit 1', 'protein-coding gene', 'ENSG00000110768'),
(2002, 4658, 'GTF2H4', 'general transcription factor IIH subunit 4', 'protein-coding gene', 'ENSG00000213780'),
(2003, 16082, 'GTF2IP2', 'general transcription factor IIi pseudogene 2', 'pseudogene', 'ENSG00000226930'),
(2004, 42640, 'GTF2IP3', 'general transcription factor IIi pseudogene 3', 'pseudogene', 'ENSG00000187721'),
(2005, 51717, 'GTF2IP5', 'general transcription factor IIi pseudogene 5', 'pseudogene', 'ENSG00000224316'),
(2006, 13698, 'GTSE1', 'G2 and S-phase expressed 1', 'protein-coding gene', 'ENSG00000075218'),
(2007, 26565, 'GTSF1', 'gametocyte specific factor 1', 'protein-coding gene', 'ENSG00000170627'),
(2008, 4679, 'GUCA1B', 'guanylate cyclase activator 1B', 'protein-coding gene', 'ENSG00000112599'),
(2009, 4691, 'GUCY2F', 'guanylate cyclase 2F, retinal', 'protein-coding gene', 'ENSG00000101890'),
(2010, 18649, 'GULP1', 'GULP PTB domain containing engulfment adaptor 1', 'protein-coding gene', 'ENSG00000144366'),
(2011, 4696, 'GUSB', 'glucuronidase beta', 'protein-coding gene', 'ENSG00000169919'),
(2012, 37301, 'GUSBP3', 'GUSB pseudogene 3', 'pseudogene', 'ENSG00000253203'),
(2013, 42324, 'GUSBP10', 'GUSB pseudogene 10', 'pseudogene', 'ENSG00000224723'),
(2014, 42325, 'GUSBP11', 'GUSB pseudogene 11', 'pseudogene', 'ENSG00000228315'),
(2015, 50425, 'GXYLT1P6', 'GXYLT1 pseudogene 6', 'pseudogene', 'ENSG00000235310'),
(2016, 39711, 'GYG1P3', 'glycogenin 1 pseudogene 3', 'pseudogene', 'ENSG00000231095'),
(2017, 40270, 'GYG2-AS1', 'GYG2 antisense RNA 1', 'non-coding RNA', 'ENSG00000235483'),
(2018, 4709, 'GZMB', 'granzyme B', 'protein-coding gene', 'ENSG00000100453'),
(2019, 19163, 'H1-12P', 'H1.12 linker histone, cluster member, pseudogene', 'pseudogene', 'ENSG00000216331'),
(2020, 13671, 'H2AC12', 'H2A clustered histone 12', 'protein-coding gene', 'ENSG00000274997'),
(2021, 4727, 'H2AC14', 'H2A clustered histone 14', 'protein-coding gene', 'ENSG00000276368'),
(2022, 4726, 'H2AC15', 'H2A clustered histone 15', 'protein-coding gene', 'ENSG00000275221'),
(2023, 18417, 'H2AP', 'H2A.P histone', 'protein-coding gene', 'ENSG00000187516'),
(2024, 20507, 'H2AW', 'H2A.W histone', 'protein-coding gene', 'ENSG00000181218'),
(2025, 20664, 'H2AZ2', 'H2A.Z variant histone 2', 'protein-coding gene', 'ENSG00000105968'),
(2026, 18730, 'H2BC1', 'H2B clustered histone 1', 'protein-coding gene', 'ENSG00000146047'),
(2027, 4751, 'H2BC3', 'H2B clustered histone 3', 'protein-coding gene', 'ENSG00000276410');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(2028, 4747, 'H2BC5', 'H2B clustered histone 5', 'protein-coding gene', 'ENSG00000158373'),
(2029, 20516, 'H2BC20P', 'H2B clustered histone 20, pseudogene', 'pseudogene', 'ENSG00000261716'),
(2030, 4760, 'H2BC21', 'H2B clustered histone 21', 'protein-coding gene', 'ENSG00000184678'),
(2031, 53833, 'H2BK1', 'H2B.K variant histone 1', 'protein-coding gene', 'ENSG00000285480'),
(2032, 20654, 'H2BP2', 'H2B histone pseudogene 2', 'pseudogene', 'ENSG00000234571'),
(2033, 27252, 'H2BW1', 'H2B.W histone 1', 'protein-coding gene', 'ENSG00000123569'),
(2034, 33164, 'H3-5', 'H3.5 histone', 'protein-coding gene', 'ENSG00000188375'),
(2035, 4766, 'H3C1', 'H3 clustered histone 1', 'protein-coding gene', 'ENSG00000275714'),
(2036, 4769, 'H3C6', 'H3 clustered histone 6', 'protein-coding gene', 'ENSG00000274750'),
(2037, 4773, 'H3C7', 'H3 clustered histone 7', 'protein-coding gene', 'ENSG00000277775'),
(2038, 25311, 'H3C13', 'H3 clustered histone 13', 'protein-coding gene', 'ENSG00000183598'),
(2039, 43805, 'H3P14', 'H3 histone pseudogene 14', 'pseudogene', 'ENSG00000250966'),
(2040, 42982, 'H3P16', 'H3 histone pseudogene 16', 'pseudogene', 'ENSG00000178458'),
(2041, 54457, 'H3P23', 'H3 histone pseudogene 23', 'pseudogene', 'ENSG00000250705'),
(2042, 54458, 'H3P24', 'H3 histone pseudogene 24', 'pseudogene', 'ENSG00000251118'),
(2043, 54462, 'H3P29', 'H3 histone pseudogene 29', 'pseudogene', 'ENSG00000228783'),
(2044, 54471, 'H3P42', 'H3 histone pseudogene 42', 'pseudogene', 'ENSG00000271626'),
(2045, 42981, 'H3P44', 'H3 histone pseudogene 44', 'pseudogene', 'ENSG00000226881'),
(2046, 4787, 'H4C3', 'H4 clustered histone 3', 'protein-coding gene', 'ENSG00000197061'),
(2047, 4788, 'H4C8', 'H4 clustered histone 8', 'protein-coding gene', 'ENSG00000158406'),
(2048, 4791, 'H4C13', 'H4 clustered histone 13', 'protein-coding gene', 'ENSG00000275126'),
(2049, 4796, 'HAAO', '3-hydroxyanthranilate 3,4-dioxygenase', 'protein-coding gene', 'ENSG00000162882'),
(2050, 9639, 'HACD1', '3-hydroxyacyl-CoA dehydratase 1', 'protein-coding gene', 'ENSG00000165996'),
(2051, 20920, 'HACD4', '3-hydroxyacyl-CoA dehydratase 4', 'protein-coding gene', 'ENSG00000188921'),
(2052, 4803, 'HADHB', 'hydroxyacyl-CoA dehydrogenase trifunctional multienzyme complex subunit beta', 'protein-coding gene', 'ENSG00000138029'),
(2053, 41342, 'HAO2-IT1', 'HAO2 intronic transcript 1', 'non-coding RNA', 'ENSG00000230921'),
(2054, 17410, 'HAPLN2', 'hyaluronan and proteoglycan link protein 2', 'protein-coding gene', 'ENSG00000132702'),
(2055, 28719, 'HAUS3', 'HAUS augmin like complex subunit 3', 'protein-coding gene', 'ENSG00000214367'),
(2056, 43763, 'HAUS4P1', 'HAUS augmin like complex subunit 4 pseudogene 1', 'pseudogene', 'ENSG00000226967'),
(2057, 43764, 'HAUS6P1', 'HAUS augmin like complex subunit 6 pseudogene 1', 'pseudogene', 'ENSG00000227344'),
(2058, 50772, 'HAUS6P3', 'HAUS augmin like complex subunit 6 pseudogene 3', 'pseudogene', 'ENSG00000235454'),
(2059, 17866, 'HAVCR1', 'hepatitis A virus cellular receptor 1', 'protein-coding gene', 'ENSG00000113249'),
(2060, 4825, 'HBAP1', 'hemoglobin subunit alpha pseudogene 1', 'pseudogene', 'ENSG00000225323'),
(2061, 4829, 'HBD', 'hemoglobin subunit delta', 'protein-coding gene', 'ENSG00000223609'),
(2062, 4832, 'HBG2', 'hemoglobin subunit gamma 2', 'protein-coding gene', 'ENSG00000196565'),
(2063, 4839, 'HCFC1', 'host cell factor C1', 'protein-coding gene', 'ENSG00000172534'),
(2064, 24972, 'HCFC2', 'host cell factor C2', 'protein-coding gene', 'ENSG00000111727'),
(2065, 39815, 'HCFC2P1', 'host cell factor C2 pseudogene 1', 'pseudogene', 'ENSG00000232087'),
(2066, 22919, 'HCG4B', 'HLA complex group 4B', 'non-coding RNA', 'ENSG00000227262'),
(2067, 30983, 'HCG9P5', 'HLA complex group 9 pseudogene 5', 'pseudogene', 'ENSG00000227758'),
(2068, 18361, 'HCG15', 'HLA complex group 15', 'non-coding RNA', 'ENSG00000227214'),
(2069, 27780, 'HCG22', 'HLA complex group 22 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000228789'),
(2070, 20196, 'HCG25', 'HLA complex group 25', 'non-coding RNA', 'ENSG00000232940'),
(2071, 4840, 'HCK', 'HCK proto-oncogene, Src family tyrosine kinase', 'protein-coding gene', 'ENSG00000101336'),
(2072, 4844, 'HCLS1', 'hematopoietic cell-specific Lyn substrate 1', 'protein-coding gene', 'ENSG00000180353'),
(2073, 4848, 'HCRTR1', 'hypocretin receptor 1', 'protein-coding gene', 'ENSG00000121764'),
(2074, 43590, 'HDAC2-AS2', 'HDAC2 and HS3ST5 antisense RNA 2', 'non-coding RNA', 'ENSG00000228624'),
(2075, 4854, 'HDAC3', 'histone deacetylase 3', 'protein-coding gene', 'ENSG00000171720'),
(2076, 14063, 'HDAC4', 'histone deacetylase 4', 'protein-coding gene', 'ENSG00000068024'),
(2077, 13315, 'HDAC8', 'histone deacetylase 8', 'protein-coding gene', 'ENSG00000147099'),
(2078, 14065, 'HDAC9', 'histone deacetylase 9', 'protein-coding gene', 'ENSG00000048052'),
(2079, 30522, 'HDDC3', 'HD domain containing 3', 'protein-coding gene', 'ENSG00000184508'),
(2080, 25364, 'HDHD2', 'haloacid dehalogenase like hydrolase domain containing 2', 'protein-coding gene', 'ENSG00000167220'),
(2081, 55406, 'HEATR3-AS1', 'HEATR3 antisense RNA 1', 'non-coding RNA', 'ENSG00000259843'),
(2082, 55552, 'HEATR5A-DT', 'HEATR5A divergent transcript', 'non-coding RNA', 'ENSG00000250365'),
(2083, 24076, 'HEATR6', 'HEAT repeat containing 6', 'protein-coding gene', 'ENSG00000068097'),
(2084, 17176, 'HEBP1', 'heme binding protein 1', 'protein-coding gene', 'ENSG00000013583'),
(2085, 21041, 'HECA', 'hdc homolog, cell cycle regulator', 'protein-coding gene', 'ENSG00000112406'),
(2086, 26611, 'HECTD4', 'HECT domain E3 ubiquitin protein ligase 4', 'protein-coding gene', 'ENSG00000173064'),
(2087, 22195, 'HECW1', 'HECT, C2 and WW domain containing E3 ubiquitin protein ligase 1', 'protein-coding gene', 'ENSG00000002746'),
(2088, 29227, 'HEG1', 'heart development protein with EGF like domains 1', 'protein-coding gene', 'ENSG00000173706'),
(2089, 4861, 'HELLS', 'helicase, lymphoid specific', 'protein-coding gene', 'ENSG00000119969'),
(2090, 55319, 'HELZ-AS1', 'HELZ antisense RNA 1', 'non-coding RNA', 'ENSG00000266473'),
(2091, 4866, 'HEPH', 'hephaestin', 'protein-coding gene', 'ENSG00000089472'),
(2092, 4868, 'HERC2', 'HECT and RLD domain containing E3 ubiquitin protein ligase 2', 'protein-coding gene', 'ENSG00000128731'),
(2093, 4870, 'HERC2P2', 'HERC2 pseudogene 2', 'pseudogene', 'ENSG00000276550'),
(2094, 24368, 'HERC5', 'HECT and RLD domain containing E3 ubiquitin protein ligase 5', 'protein-coding gene', 'ENSG00000138646'),
(2095, 5192, 'HES1', 'hes family bHLH transcription factor 1', 'protein-coding gene', 'ENSG00000114315'),
(2096, 13242, 'HHATL', 'hedgehog acyltransferase like', 'protein-coding gene', 'ENSG00000010282'),
(2097, 4901, 'HHEX', 'hematopoietically expressed homeobox', 'protein-coding gene', 'ENSG00000152804'),
(2098, 19710, 'HHIPL1', 'HHIP like 1', 'protein-coding gene', 'ENSG00000182218'),
(2099, 4906, 'HHLA3', 'HERV-H LTR-associating 3', 'non-coding RNA', 'ENSG00000197568'),
(2100, 4907, 'HIBADH', '3-hydroxyisobutyrate dehydrogenase', 'protein-coding gene', 'ENSG00000106049'),
(2101, 43014, 'HIF1A-AS1', 'HIF1A antisense RNA 1', 'non-coding RNA', 'ENSG00000258777'),
(2102, 43000, 'HIGD1AP4', 'HIG1 hypoxia inducible domain family member 1A pseudogene 4', 'pseudogene', 'ENSG00000233299'),
(2103, 43013, 'HIGD1AP18', 'HIG1 hypoxia inducible domain family member 1A pseudogene 18', 'pseudogene', 'ENSG00000253952'),
(2104, 54794, 'HIGD2AP2', 'HIGD2A pseudogene 2', 'pseudogene', 'ENSG00000235695'),
(2105, 26938, 'HIKESHI', 'heat shock protein nuclear import factor hikeshi', 'protein-coding gene', 'ENSG00000149196'),
(2106, 38049, 'HINT1P2', 'histidine triad nucleotide binding protein 1 pseudogene 2', 'pseudogene', 'ENSG00000271159'),
(2107, 50311, 'HINT2P1', 'histidine triad nucleotide binding protein 2 pseudogene 1', 'pseudogene', 'ENSG00000230398'),
(2108, 18468, 'HINT3', 'histidine triad nucleotide binding protein 3', 'protein-coding gene', 'ENSG00000111911'),
(2109, 4913, 'HIP1', 'huntingtin interacting protein 1', 'protein-coding gene', 'ENSG00000127946'),
(2110, 50576, 'HIPK1-AS1', 'HIPK1 antisense RNA 1', 'non-coding RNA', 'ENSG00000235527'),
(2111, 55204, 'HK2-DT', 'HK2 divergent transcript', 'non-coding RNA', 'ENSG00000272711'),
(2112, 4924, 'HK2P1', 'hexokinase 2 pseudogene 1', 'pseudogene', 'ENSG00000228612'),
(2113, 4925, 'HK3', 'hexokinase 3', 'protein-coding gene', 'ENSG00000160883'),
(2114, 4935, 'HLA-DMB', 'major histocompatibility complex, class II, DM beta', 'protein-coding gene', 'ENSG00000242574'),
(2115, 4939, 'HLA-DPA2', 'major histocompatibility complex, class II, DP alpha 2 (pseudogene)', 'pseudogene', 'ENSG00000231461'),
(2116, 4945, 'HLA-DQB2', 'major histocompatibility complex, class II, DQ beta 2', 'protein-coding gene', 'ENSG00000232629'),
(2117, 4954, 'HLA-DRB6', 'major histocompatibility complex, class II, DR beta 6 (pseudogene)', 'pseudogene', 'ENSG00000229391'),
(2118, 4963, 'HLA-F', 'major histocompatibility complex, class I, F', 'protein-coding gene', 'ENSG00000204642'),
(2119, 4970, 'HLA-L', 'major histocompatibility complex, class I, L (pseudogene)', 'pseudogene', 'ENSG00000243753'),
(2120, 19395, 'HLA-S', 'major histocompatibility complex, class I, S (pseudogene)', 'pseudogene', 'ENSG00000225851'),
(2121, 23425, 'HLA-W', 'major histocompatibility complex, class I, W (pseudogene)', 'pseudogene', 'ENSG00000235290'),
(2122, 41343, 'HLCS-IT1', 'HLCS intronic transcript 1', 'non-coding RNA', 'ENSG00000237646'),
(2123, 41922, 'HLFP1', 'HLF pseudogene 1', 'pseudogene', 'ENSG00000218194'),
(2124, 11099, 'HLTF', 'helicase like transcription factor', 'protein-coding gene', 'ENSG00000071794'),
(2125, 4982, 'HMBS', 'hydroxymethylbilane synthase', 'protein-coding gene', 'ENSG00000256269'),
(2126, 24446, 'HMCES', '5-hydroxymethylcytosine binding, ES cell specific', 'protein-coding gene', 'ENSG00000183624'),
(2127, 5001, 'HMG20A', 'high mobility group 20A', 'protein-coding gene', 'ENSG00000140382'),
(2128, 5010, 'HMGA1', 'high mobility group AT-hook 1', 'protein-coding gene', 'ENSG00000137309'),
(2129, 19120, 'HMGA1P5', 'high mobility group AT-hook 1 pseudogene 5', 'pseudogene', 'ENSG00000233313'),
(2130, 5009, 'HMGA2', 'high mobility group AT-hook 2', 'protein-coding gene', 'ENSG00000149948'),
(2131, 4997, 'HMGB1P5', 'high mobility group box 1 pseudogene 5', 'pseudogene', 'ENSG00000132967'),
(2132, 4998, 'HMGB1P6', 'high mobility group box 1 pseudogene 6', 'pseudogene', 'ENSG00000259781'),
(2133, 39096, 'HMGB1P7', 'high mobility group box 1 pseudogene 7', 'pseudogene', 'ENSG00000231148'),
(2134, 13320, 'HMGB1P9', 'high mobility group box 1 pseudogene 9', 'pseudogene', 'ENSG00000224159'),
(2135, 20014, 'HMGB1P14', 'high mobility group box 1 pseudogene 14', 'pseudogene', 'ENSG00000180189'),
(2136, 39099, 'HMGB1P17', 'high mobility group box 1 pseudogene 17', 'pseudogene', 'ENSG00000217482'),
(2137, 39176, 'HMGB1P36', 'high mobility group box 1 pseudogene 36', 'pseudogene', 'ENSG00000243873'),
(2138, 39186, 'HMGB1P39', 'high mobility group box 1 pseudogene 39', 'pseudogene', 'ENSG00000203489'),
(2139, 39189, 'HMGB1P42', 'high mobility group box 1 pseudogene 42', 'pseudogene', 'ENSG00000254735'),
(2140, 39280, 'HMGB1P47', 'high mobility group box 1 pseudogene 47', 'pseudogene', 'ENSG00000249338'),
(2141, 52369, 'HMGB1P51', 'high mobility group box 1 pseudogene 51', 'pseudogene', 'ENSG00000270986'),
(2142, 39102, 'HMGB3P3', 'high mobility group box 3 pseudogene 3', 'pseudogene', 'ENSG00000250730'),
(2143, 39299, 'HMGB3P7', 'high mobility group box 3 pseudogene 7', 'pseudogene', 'ENSG00000215399'),
(2144, 39303, 'HMGB3P11', 'high mobility group box 3 pseudogene 11', 'pseudogene', 'ENSG00000213301'),
(2145, 39304, 'HMGB3P12', 'high mobility group box 3 pseudogene 12', 'pseudogene', 'ENSG00000237603'),
(2146, 39307, 'HMGB3P15', 'high mobility group box 3 pseudogene 15', 'pseudogene', 'ENSG00000250897'),
(2147, 39311, 'HMGB3P19', 'high mobility group box 3 pseudogene 19', 'pseudogene', 'ENSG00000217085'),
(2148, 39315, 'HMGB3P23', 'high mobility group box 3 pseudogene 23', 'pseudogene', 'ENSG00000235148'),
(2149, 39316, 'HMGB3P24', 'high mobility group box 3 pseudogene 24', 'pseudogene', 'ENSG00000215283'),
(2150, 5005, 'HMGCL', '3-hydroxy-3-methylglutaryl-CoA lyase', 'protein-coding gene', 'ENSG00000117305'),
(2151, 21359, 'HMGCLL1', '3-hydroxymethyl-3-methylglutaryl-CoA lyase like 1', 'protein-coding gene', 'ENSG00000146151'),
(2152, 5007, 'HMGCS1', '3-hydroxy-3-methylglutaryl-CoA synthase 1', 'protein-coding gene', 'ENSG00000112972'),
(2153, 39351, 'HMGN1P8', 'high mobility group nucleosome binding domain 1 pseudogene 8', 'pseudogene', 'ENSG00000241120'),
(2154, 39362, 'HMGN1P18', 'high mobility group nucleosome binding domain 1 pseudogene 18', 'pseudogene', 'ENSG00000234927'),
(2155, 39422, 'HMGN1P38', 'high mobility group nucleosome binding domain 1 pseudogene 38', 'pseudogene', 'ENSG00000253954'),
(2156, 20016, 'HMGN2P2', 'high mobility group nucleosomal binding domain 2 pseudogene 2', 'pseudogene', 'ENSG00000258452'),
(2157, 33567, 'HMGN2P4', 'high mobility group nucleosomal binding domain 2 pseudogene 4', 'pseudogene', 'ENSG00000249014'),
(2158, 33574, 'HMGN2P6', 'high mobility group nucleosomal binding domain 2 pseudogene 6', 'pseudogene', 'ENSG00000257179'),
(2159, 39381, 'HMGN2P17', 'high mobility group nucleosomal binding domain 2 pseudogene 17', 'pseudogene', 'ENSG00000238249'),
(2160, 39382, 'HMGN2P18', 'high mobility group nucleosomal binding domain 2 pseudogene 18', 'pseudogene', 'ENSG00000223452'),
(2161, 39387, 'HMGN2P22', 'high mobility group nucleosomal binding domain 2 pseudogene 22', 'pseudogene', 'ENSG00000227259'),
(2162, 39407, 'HMGN2P36', 'high mobility group nucleosomal binding domain 2 pseudogene 36', 'pseudogene', 'ENSG00000228901'),
(2163, 55157, 'HMGN2P48', 'high mobility group nucleosomal binding domain 2 pseudogene 48', 'pseudogene', 'ENSG00000229979'),
(2164, 5012, 'HMMR', 'hyaluronan mediated motility receptor', 'protein-coding gene', 'ENSG00000072571'),
(2165, 5013, 'HMOX1', 'heme oxygenase 1', 'protein-coding gene', 'ENSG00000100292'),
(2166, 11630, 'HNF1B', 'HNF1 homeobox B', 'protein-coding gene', 'ENSG00000275410'),
(2167, 5032, 'HNRNPA1P6', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 6', 'pseudogene', 'ENSG00000229887'),
(2168, 39127, 'HNRNPA1P9', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 9', 'pseudogene', 'ENSG00000231956'),
(2169, 39132, 'HNRNPA1P14', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 14', 'pseudogene', 'ENSG00000227638'),
(2170, 44958, 'HNRNPA1P32', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 32', 'pseudogene', 'ENSG00000213778'),
(2171, 48766, 'HNRNPA1P37', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 37', 'pseudogene', 'ENSG00000218574'),
(2172, 48774, 'HNRNPA1P44', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 44', 'pseudogene', 'ENSG00000249271'),
(2173, 48777, 'HNRNPA1P47', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 47', 'pseudogene', 'ENSG00000236695'),
(2174, 48779, 'HNRNPA1P49', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 49', 'pseudogene', 'ENSG00000233231'),
(2175, 48780, 'HNRNPA1P50', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 50', 'pseudogene', 'ENSG00000257195'),
(2176, 48784, 'HNRNPA1P54', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 54', 'pseudogene', 'ENSG00000236539'),
(2177, 48788, 'HNRNPA1P58', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 58', 'pseudogene', 'ENSG00000219582'),
(2178, 48789, 'HNRNPA1P59', 'heterogeneous nuclear ribonucleoprotein A1 pseudogene 59', 'pseudogene', 'ENSG00000230280'),
(2179, 24941, 'HNRNPA3', 'heterogeneous nuclear ribonucleoprotein A3', 'protein-coding gene', 'ENSG00000170144'),
(2180, 39773, 'HNRNPA3P4', 'heterogeneous nuclear ribonucleoprotein A3 pseudogene 4', 'pseudogene', 'ENSG00000226068'),
(2181, 48497, 'HNRNPA3P8', 'heterogeneous nuclear ribonucleoprotein A3 pseudogene 8', 'pseudogene', 'ENSG00000239699'),
(2182, 48759, 'HNRNPA3P13', 'heterogeneous nuclear ribonucleoprotein A3 pseudogene 13', 'pseudogene', 'ENSG00000250826'),
(2183, 48816, 'HNRNPCP4', 'heterogeneous nuclear ribonucleoprotein C pseudogene 4', 'pseudogene', 'ENSG00000263179'),
(2184, 5036, 'HNRNPD', 'heterogeneous nuclear ribonucleoprotein D', 'protein-coding gene', 'ENSG00000138668'),
(2185, 42374, 'HNRNPKP1', 'heterogeneous nuclear ribonucleoprotein K pseudogene 1', 'pseudogene', 'ENSG00000250859'),
(2186, 42375, 'HNRNPKP2', 'heterogeneous nuclear ribonucleoprotein K pseudogene 2', 'pseudogene', 'ENSG00000227347'),
(2187, 5047, 'HNRNPR', 'heterogeneous nuclear ribonucleoprotein R', 'protein-coding gene', 'ENSG00000125944'),
(2188, 44908, 'HNRNPRP2', 'heterogeneous nuclear ribonucleoprotein R pseudogene 2', 'pseudogene', 'ENSG00000255047'),
(2189, 19885, 'HOOK2', 'hook microtubule tethering protein 2', 'protein-coding gene', 'ENSG00000095066'),
(2190, 24961, 'HOPX', 'HOP homeobox', 'protein-coding gene', 'ENSG00000171476'),
(2191, 50729, 'HORMAD2-AS1', 'HORMAD2 and MTMR3 antisense RNA 1', 'non-coding RNA', 'ENSG00000227117'),
(2192, 5099, 'HOXA1', 'homeobox A1', 'protein-coding gene', 'ENSG00000105991'),
(2193, 5105, 'HOXA4', 'homeobox A4', 'protein-coding gene', 'ENSG00000197576'),
(2194, 40281, 'HOXA10-AS', 'HOXA10 antisense RNA', 'non-coding RNA', 'ENSG00000253187'),
(2195, 5113, 'HOXB2', 'homeobox B2', 'protein-coding gene', 'ENSG00000173917'),
(2196, 5115, 'HOXB4', 'homeobox B4', 'protein-coding gene', 'ENSG00000182742'),
(2197, 5118, 'HOXB7', 'homeobox B7', 'protein-coding gene', 'ENSG00000260027'),
(2198, 5112, 'HOXB13', 'homeobox B13', 'protein-coding gene', 'ENSG00000159184'),
(2199, 5130, 'HOXC9', 'homeobox C9', 'protein-coding gene', 'ENSG00000180806'),
(2200, 5122, 'HOXC10', 'homeobox C10', 'protein-coding gene', 'ENSG00000180818'),
(2201, 43753, 'HOXC13-AS', 'HOXC13 antisense RNA', 'non-coding RNA', 'ENSG00000249641'),
(2202, 43756, 'HOXD-AS2', 'HOXD cluster antisense RNA 2', 'non-coding RNA', 'ENSG00000237380'),
(2203, 5138, 'HOXD4', 'homeobox D4', 'protein-coding gene', 'ENSG00000170166'),
(2204, 5144, 'HPCA', 'hippocalcin', 'protein-coding gene', 'ENSG00000121905'),
(2205, 18212, 'HPCAL4', 'hippocalcin like 4', 'protein-coding gene', 'ENSG00000116983'),
(2206, 5160, 'HPRT1P2', 'hypoxanthine phosphoribosyltransferase 1 pseudogene 2', 'pseudogene', 'ENSG00000250587'),
(2207, 5161, 'HPRT1P3', 'hypoxanthine phosphoribosyltransferase 1 pseudogene 3', 'pseudogene', 'ENSG00000256752'),
(2208, 15844, 'HPS4', 'HPS4 biogenesis of lysosomal organelles complex 3 subunit 2', 'protein-coding gene', 'ENSG00000100099'),
(2209, 5164, 'HPSE', 'heparanase', 'protein-coding gene', 'ENSG00000173083'),
(2210, 16071, 'HPYR1', 'Helicobacter pylori responsive 1', 'non-coding RNA', 'ENSG00000253521'),
(2211, 17383, 'HRH4', 'histamine receptor H4', 'protein-coding gene', 'ENSG00000134489'),
(2212, 41474, 'HS1BP3-IT1', 'HS1BP3 intronic transcript 1', 'non-coding RNA', 'ENSG00000231948'),
(2213, 5196, 'HS3ST3A1', 'heparan sulfate-glucosamine 3-sulfotransferase 3A1', 'protein-coding gene', 'ENSG00000153976'),
(2214, 14178, 'HS3ST6', 'heparan sulfate-glucosamine 3-sulfotransferase 6', 'protein-coding gene', 'ENSG00000162040'),
(2215, 19133, 'HS6ST2', 'heparan sulfate 6-O-sulfotransferase 2', 'protein-coding gene', 'ENSG00000171004'),
(2216, 20053, 'HSBP1P1', 'heat shock factor binding protein 1 pseudogene 1', 'pseudogene', 'ENSG00000258650'),
(2217, 18324, 'HSD3B7', 'hydroxy-delta-5-steroid dehydrogenase, 3 beta- and steroid delta-isomerase 7', 'protein-coding gene', 'ENSG00000099377'),
(2218, 5219, 'HSD3BP1', 'hydroxy-delta-5-steroid dehydrogenase, 3 beta, pseudogene 1', 'pseudogene', 'ENSG00000187481'),
(2219, 54053, 'HSD11B1-AS1', 'HSD11B1 antisense RNA 1', 'non-coding RNA', 'ENSG00000227591'),
(2220, 5209, 'HSD11B2', 'hydroxysteroid 11-beta dehydrogenase 2', 'protein-coding gene', 'ENSG00000176387'),
(2221, 53136, 'HSD17B3-AS1', 'HSD17B3 antisense RNA 1', 'non-coding RNA', 'ENSG00000232283'),
(2222, 23316, 'HSD17B6', 'hydroxysteroid 17-beta dehydrogenase 6', 'protein-coding gene', 'ENSG00000025423'),
(2223, 28120, 'HSD17B7P2', 'hydroxysteroid 17-beta dehydrogenase 7 pseudogene 2', 'pseudogene', 'ENSG00000099251'),
(2224, 4800, 'HSD17B10', 'hydroxysteroid 17-beta dehydrogenase 10', 'protein-coding gene', 'ENSG00000072506'),
(2225, 23238, 'HSD17B14', 'hydroxysteroid 17-beta dehydrogenase 14', 'protein-coding gene', 'ENSG00000087076'),
(2226, 5227, 'HSF4', 'heat shock transcription factor 4', 'protein-coding gene', 'ENSG00000102878'),
(2227, 23950, 'HSFY2', 'heat shock transcription factor Y-linked 2', 'protein-coding gene', 'ENSG00000169953'),
(2228, 37119, 'HSFY3P', 'heat shock transcription factor Y-linked 3, pseudogene', 'pseudogene', 'ENSG00000227289'),
(2229, 5256, 'HSP90AA2P', 'heat shock protein 90 alpha family class A member 2, pseudogene', 'pseudogene', 'ENSG00000224411'),
(2230, 32535, 'HSP90AA5P', 'heat shock protein 90 alpha family class A member 5, pseudogene', 'pseudogene', 'ENSG00000205955'),
(2231, 5235, 'HSPA2', 'heat shock protein family A (Hsp70) member 2', 'protein-coding gene', 'ENSG00000126803'),
(2232, 17041, 'HSPA4L', 'heat shock protein family A (Hsp70) member 4 like', 'protein-coding gene', 'ENSG00000164070'),
(2233, 54532, 'HSPA5P1', 'HSPA5 pseudogene 1', 'pseudogene', 'ENSG00000215895'),
(2234, 5239, 'HSPA6', 'heat shock protein family A (Hsp70) member 6', 'protein-coding gene', 'ENSG00000173110'),
(2235, 5240, 'HSPA7', 'heat shock protein family A (Hsp70) member 7 (pseudogene)', 'pseudogene', 'ENSG00000225217'),
(2236, 5241, 'HSPA8', 'heat shock protein family A (Hsp70) member 8', 'protein-coding gene', 'ENSG00000109971'),
(2237, 44918, 'HSPA8P3', 'heat shock protein family A (Hsp70) member 8 pseudogene 3', 'pseudogene', 'ENSG00000234788'),
(2238, 44924, 'HSPA8P9', 'heat shock protein family A (Hsp70) member 8 pseudogene 9', 'pseudogene', 'ENSG00000241478'),
(2239, 44935, 'HSPA8P19', 'heat shock protein family A (Hsp70) member pseudogene 19', 'pseudogene', 'ENSG00000251614'),
(2240, 5244, 'HSPA9', 'heat shock protein family A (Hsp70) member 9', 'protein-coding gene', 'ENSG00000113013'),
(2241, 41996, 'HSPB2-C11ORF52', 'HSPB2-C11orf52 readthrough (NMD candidate)', 'other', 'ENSG00000254445'),
(2242, 5267, 'HSPD1P6', 'heat shock protein family D (Hsp60) member 1 pseudogene 6', 'pseudogene', 'ENSG00000230067'),
(2243, 5268, 'HSPD1P7', 'heat shock protein family D (Hsp60) member 1 pseudogene 7', 'pseudogene', 'ENSG00000215005'),
(2244, 35132, 'HSPD1P9', 'heat shock protein family D (Hsp60) member 1 pseudogene 9', 'pseudogene', 'ENSG00000228036'),
(2245, 38592, 'HSPD1P21', 'heat shock protein family D (Hsp60) member 1 pseudogene 21', 'pseudogene', 'ENSG00000229900'),
(2246, 49184, 'HSPE1-MOB4', 'HSPE1-MOB4 readthrough', 'other', 'ENSG00000270757'),
(2247, 49325, 'HSPE1P6', 'heat shock protein family E (Hsp10) member 1 pseudogene 6', 'pseudogene', 'ENSG00000232917'),
(2248, 49326, 'HSPE1P8', 'heat shock protein family E (Hsp10) member 1 pseudogene 8', 'pseudogene', 'ENSG00000217897'),
(2249, 49328, 'HSPE1P9', 'heat shock protein family E (Hsp10) member 1 pseudogene 9', 'pseudogene', 'ENSG00000232690'),
(2250, 49332, 'HSPE1P13', 'heat shock protein family E (Hsp10) member 1 pseudogene 13', 'pseudogene', 'ENSG00000225900'),
(2251, 49344, 'HSPE1P25', 'heat shock protein family E (Hsp10) member 1 pseudogene 25', 'pseudogene', 'ENSG00000232015'),
(2252, 49347, 'HSPE1P28', 'heat shock protein family E (Hsp10) member 1 pseudogene 28', 'pseudogene', 'ENSG00000230081'),
(2253, 38586, 'HTATSF1P2', 'HIV-1 Tat specific factor 1 pseudogene 2', 'pseudogene', 'ENSG00000271361'),
(2254, 5291, 'HTR1E', '5-hydroxytryptamine receptor 1E', 'protein-coding gene', 'ENSG00000168830'),
(2255, 5292, 'HTR1F', '5-hydroxytryptamine receptor 1F', 'protein-coding gene', 'ENSG00000179097'),
(2256, 40289, 'HTR2A-AS1', 'HTR2A antisense RNA 1', 'non-coding RNA', 'ENSG00000224517'),
(2257, 5294, 'HTR2B', '5-hydroxytryptamine receptor 2B', 'protein-coding gene', 'ENSG00000135914'),
(2258, 5295, 'HTR2C', '5-hydroxytryptamine receptor 2C', 'protein-coding gene', 'ENSG00000147246'),
(2259, 24003, 'HTR3C', '5-hydroxytryptamine receptor 3C', 'protein-coding gene', 'ENSG00000178084'),
(2260, 14348, 'HTRA2', 'HtrA serine peptidase 2', 'protein-coding gene', 'ENSG00000115317'),
(2261, 30406, 'HTRA3', 'HtrA serine peptidase 3', 'protein-coding gene', 'ENSG00000170801'),
(2262, 4851, 'HTT', 'huntingtin', 'protein-coding gene', 'ENSG00000197386'),
(2263, 40631, 'HUNK-AS1', 'HUNK antisense RNA 1', 'non-coding RNA', 'ENSG00000237138'),
(2264, 41173, 'HYI-AS1', 'HYI antisense RNA 1', 'non-coding RNA', 'ENSG00000229348'),
(2265, 16931, 'HYOU1', 'hypoxia up-regulated 1', 'protein-coding gene', 'ENSG00000149428'),
(2266, 27302, 'IBA57', 'iron-sulfur cluster assembly factor IBA57', 'protein-coding gene', 'ENSG00000181873'),
(2267, 5341, 'IBSP', 'integrin binding sialoprotein', 'protein-coding gene', 'ENSG00000029559'),
(2268, 5344, 'ICAM1', 'intercellular adhesion molecule 1', 'protein-coding gene', 'ENSG00000090339'),
(2269, 5346, 'ICAM3', 'intercellular adhesion molecule 3', 'protein-coding gene', 'ENSG00000076662'),
(2270, 29154, 'ICE1', 'interactor of little elongation complex ELL subunit 1', 'protein-coding gene', 'ENSG00000164151'),
(2271, 5351, 'ICOS', 'inducible T cell costimulator', 'protein-coding gene', 'ENSG00000163600'),
(2272, 5360, 'ID1', 'inhibitor of DNA binding 1, HLH protein', 'protein-coding gene', 'ENSG00000125968'),
(2273, 30656, 'ID2B', 'inhibitor of DNA binding 2B, HLH protein (pseudogene)', 'pseudogene', 'ENSG00000237456'),
(2274, 5362, 'ID3', 'inhibitor of DNA binding 3, HLH protein', 'protein-coding gene', 'ENSG00000117318'),
(2275, 5381, 'IDE', 'insulin degrading enzyme', 'protein-coding gene', 'ENSG00000119912'),
(2276, 53154, 'IDH2-DT', 'IDH2 divergent transcript', 'non-coding RNA', 'ENSG00000259685'),
(2277, 55798, 'IDH3B-DT', 'IDH3B divergent transcript', 'non-coding RNA', 'ENSG00000228293'),
(2278, 54667, 'IDI1P2', 'IDI1 pseudogene 2', 'pseudogene', 'ENSG00000253654'),
(2279, 23487, 'IDI2', 'isopentenyl-diphosphate delta isomerase 2', 'protein-coding gene', 'ENSG00000148377'),
(2280, 6059, 'IDO1', 'indoleamine 2,3-dioxygenase 1', 'protein-coding gene', 'ENSG00000131203'),
(2281, 5389, 'IDS', 'iduronate 2-sulfatase', 'protein-coding gene', 'ENSG00000010404'),
(2282, 53629, 'IER3-AS1', 'IER3 antisense RNA 1', 'non-coding RNA', 'ENSG00000272273'),
(2283, 55825, 'IER5L-AS1', 'IER5L antisense RNA 1', 'non-coding RNA', 'ENSG00000204055'),
(2284, 5395, 'IFI16', 'interferon gamma inducible protein 16', 'protein-coding gene', 'ENSG00000163565'),
(2285, 19753, 'IFI27L2', 'interferon alpha inducible protein 27 like 2', 'protein-coding gene', 'ENSG00000119632'),
(2286, 5407, 'IFIT1', 'interferon induced protein with tetratricopeptide repeats 1', 'protein-coding gene', 'ENSG00000185745'),
(2287, 5409, 'IFIT2', 'interferon induced protein with tetratricopeptide repeats 2', 'protein-coding gene', 'ENSG00000119922'),
(2288, 5414, 'IFITM3', 'interferon induced transmembrane protein 3', 'protein-coding gene', 'ENSG00000142089'),
(2289, 54541, 'IFITM3P3', 'IFITM3 pseudogene 3', 'pseudogene', 'ENSG00000196114'),
(2290, 33972, 'IFITM9P', 'interferon induced transmembrane protein 9 pseudogene', 'pseudogene', 'ENSG00000213275'),
(2291, 5422, 'IFNA17', 'interferon alpha 17', 'protein-coding gene', 'ENSG00000234829'),
(2292, 5444, 'IFNA20P', 'interferon alpha 20, pseudogene', 'pseudogene', 'ENSG00000226393'),
(2293, 5432, 'IFNAR1', 'interferon alpha and beta receptor subunit 1', 'protein-coding gene', 'ENSG00000142166'),
(2294, 18363, 'IFNL1', 'interferon lambda 1', 'protein-coding gene', 'ENSG00000182393'),
(2295, 18365, 'IFNL3', 'interferon lambda 3', 'protein-coding gene', 'ENSG00000197110'),
(2296, 5448, 'IFNW1', 'interferon omega 1', 'protein-coding gene', 'ENSG00000177047'),
(2297, 5452, 'IFNWP2', 'interferon omega 1 pseudogene 2', 'pseudogene', 'ENSG00000237691'),
(2298, 5455, 'IFNWP9', 'interferon omega 1 pseudogene 9', 'pseudogene', 'ENSG00000226597'),
(2299, 5457, 'IFRD2', 'interferon related developmental regulator 2', 'protein-coding gene', 'ENSG00000214706'),
(2300, 29262, 'IFT80', 'intraflagellar transport 80', 'protein-coding gene', 'ENSG00000068885'),
(2301, 29077, 'IFT140', 'intraflagellar transport 140', 'protein-coding gene', 'ENSG00000187535'),
(2302, 32956, 'IGFL1P1', 'IGF like family member 1 pseudogene 1', 'pseudogene', 'ENSG00000268879'),
(2303, 32930, 'IGFL3', 'IGF like family member 3', 'protein-coding gene', 'ENSG00000188624'),
(2304, 5478, 'IGHA1', 'immunoglobulin heavy constant alpha 1', 'other', 'ENSG00000211895'),
(2305, 5480, 'IGHD', 'immunoglobulin heavy constant delta', 'other', 'ENSG00000211898'),
(2306, 5492, 'IGHD2-8', 'immunoglobulin heavy diversity 2-8', 'other', 'ENSG00000211925'),
(2307, 5493, 'IGHD2OR15-2A', 'immunoglobulin heavy diversity 2/OR15-2A (non-functional)', 'other', 'ENSG00000282599'),
(2308, 5498, 'IGHD3-3', 'immunoglobulin heavy diversity 3-3', 'other', 'ENSG00000211930'),
(2309, 5497, 'IGHD3-22', 'immunoglobulin heavy diversity 3-22', 'other', 'ENSG00000211911'),
(2310, 5507, 'IGHD4OR15-4B', 'immunoglobulin heavy diversity 4/OR15-4B (non-functional)', 'other', 'ENSG00000270451'),
(2311, 5509, 'IGHD5-18', 'immunoglobulin heavy diversity 5-18', 'other', 'ENSG00000211915'),
(2312, 5514, 'IGHD6-13', 'immunoglobulin heavy diversity 6-13', 'other', 'ENSG00000211920'),
(2313, 5526, 'IGHG2', 'immunoglobulin heavy constant gamma 2 (G2m marker)', 'other', 'ENSG00000211893'),
(2314, 5533, 'IGHJ1P', 'immunoglobulin heavy joining 1P (pseudogene)', 'pseudogene', 'ENSG00000227335'),
(2315, 5536, 'IGHJ3', 'immunoglobulin heavy joining 3', 'other', 'ENSG00000242887'),
(2316, 5552, 'IGHV1-3', 'immunoglobulin heavy variable 1-3', 'other', 'ENSG00000211935'),
(2317, 5547, 'IGHV1-14', 'immunoglobulin heavy variable 1-14 (pseudogene)', 'pseudogene', 'ENSG00000253709'),
(2318, 5548, 'IGHV1-17', 'immunoglobulin heavy variable 1-17 (pseudogene)', 'pseudogene', 'ENSG00000254046'),
(2319, 5556, 'IGHV1-67', 'immunoglobulin heavy variable 1-67 (pseudogene)', 'pseudogene', 'ENSG00000253274'),
(2320, 5562, 'IGHV1-69-2', 'immunoglobulin heavy variable 1-69-2', 'other', 'ENSG00000281990'),
(2321, 5564, 'IGHV1OR15-2', 'immunoglobulin heavy variable 1/OR15-2 (pseudogene)', 'pseudogene', 'ENSG00000259337'),
(2322, 5565, 'IGHV1OR15-3', 'immunoglobulin heavy variable 1/OR15-3 (pseudogene)', 'pseudogene', 'ENSG00000271288'),
(2323, 5570, 'IGHV1OR16-1', 'immunoglobulin heavy variable 1/OR16-1 (pseudogene)', 'pseudogene', 'ENSG00000261704'),
(2324, 5573, 'IGHV1OR16-4', 'immunoglobulin heavy variable 1/OR16-4 (pseudogene)', 'pseudogene', 'ENSG00000259997'),
(2325, 38040, 'IGHV1OR21-1', 'immunoglobulin heavy variable 1/OR21-1 (non-functional)', 'other', 'ENSG00000277282'),
(2326, 5580, 'IGHV3-11', 'immunoglobulin heavy variable 3-11', 'other', 'ENSG00000211941'),
(2327, 5585, 'IGHV3-20', 'immunoglobulin heavy variable 3-20', 'other', 'ENSG00000211946'),
(2328, 5588, 'IGHV3-23', 'immunoglobulin heavy variable 3-23', 'other', 'ENSG00000211949'),
(2329, 5592, 'IGHV3-30-2', 'immunoglobulin heavy variable 3-30-2 (pseudogene)', 'pseudogene', 'ENSG00000253587'),
(2330, 5599, 'IGHV3-36', 'immunoglobulin heavy variable 3-36 (pseudogene)', 'pseudogene', 'ENSG00000253240'),
(2331, 5603, 'IGHV3-42', 'immunoglobulin heavy variable 3-42 (pseudogene)', 'pseudogene', 'ENSG00000254228'),
(2332, 5609, 'IGHV3-52', 'immunoglobulin heavy variable 3-52 (pseudogene)', 'pseudogene', 'ENSG00000253545'),
(2333, 5616, 'IGHV3-63', 'immunoglobulin heavy variable 3-63 (pseudogene)', 'pseudogene', 'ENSG00000253936'),
(2334, 5622, 'IGHV3-72', 'immunoglobulin heavy variable 3-72', 'other', 'ENSG00000225698'),
(2335, 5626, 'IGHV3-76', 'immunoglobulin heavy variable 3-76 (pseudogene)', 'pseudogene', 'ENSG00000253247'),
(2336, 5627, 'IGHV3-79', 'immunoglobulin heavy variable 3-79 (pseudogene)', 'pseudogene', 'ENSG00000275747'),
(2337, 5642, 'IGHV3OR16-7', 'immunoglobulin heavy variable 3/OR16-7 (pseudogene)', 'pseudogene', 'ENSG00000271620'),
(2338, 5636, 'IGHV3OR16-12', 'immunoglobulin heavy variable 3/OR16-12 (non-functional)', 'other', 'ENSG00000270467'),
(2339, 5645, 'IGHV4-28', 'immunoglobulin heavy variable 4-28', 'other', 'ENSG00000211952'),
(2340, 5666, 'IGHV7-40', 'immunoglobulin heavy variable 7-40 (pseudogene)', 'pseudogene', 'ENSG00000253467'),
(2341, 5667, 'IGHV7-56', 'immunoglobulin heavy variable 7-56 (pseudogene)', 'pseudogene', 'ENSG00000253131'),
(2342, 5670, 'IGHVII-1-1', 'immunoglobulin heavy variable (II)-1-1 (pseudogene)', 'pseudogene', 'ENSG00000254279'),
(2343, 5678, 'IGHVII-33-1', 'immunoglobulin heavy variable (II)-33-1 (pseudogene)', 'pseudogene', 'ENSG00000254203'),
(2344, 5682, 'IGHVII-46-1', 'immunoglobulin heavy variable (II)-46-1 (pseudogene)', 'pseudogene', 'ENSG00000253808'),
(2345, 5683, 'IGHVII-49-1', 'immunoglobulin heavy variable (II)-49-1 (pseudogene)', 'pseudogene', 'ENSG00000253386'),
(2346, 5703, 'IGHVIII-5-2', 'immunoglobulin heavy variable (III)-5-2 (pseudogene)', 'pseudogene', 'ENSG00000254053'),
(2347, 5697, 'IGHVIII-25-1', 'immunoglobulin heavy variable (III)-25-1 (pseudogene)', 'pseudogene', 'ENSG00000253367'),
(2348, 5707, 'IGHVIII-67-4', 'immunoglobulin heavy variable (III)-67-4 (pseudogene)', 'pseudogene', 'ENSG00000254052'),
(2349, 5716, 'IGKC', 'immunoglobulin kappa constant', 'other', 'ENSG00000211592'),
(2350, 5719, 'IGKJ1', 'immunoglobulin kappa joining 1', 'other', 'ENSG00000211597'),
(2351, 5744, 'IGKV1-9', 'immunoglobulin kappa variable 1-9', 'other', 'ENSG00000241755'),
(2352, 5737, 'IGKV1-33', 'immunoglobulin kappa variable 1-33', 'other', 'ENSG00000242076'),
(2353, 5756, 'IGKV1D-39', 'immunoglobulin kappa variable 1D-39', 'other', 'ENSG00000251546'),
(2354, 49473, 'IGKV1OR9-1', 'immunoglobulin kappa variable 1/OR9-1 (pseudogene)', 'pseudogene', 'ENSG00000204780'),
(2355, 44978, 'IGKV1OR10-1', 'immunoglobulin kappa variable 1/OR10-1 (pseudogene)', 'pseudogene', 'ENSG00000237592'),
(2356, 5788, 'IGKV2-4', 'immunoglobulin kappa variable 2-4 (pseudogene)', 'pseudogene', 'ENSG00000253435'),
(2357, 5777, 'IGKV2-14', 'immunoglobulin kappa variable 2-14 (pseudogene)', 'pseudogene', 'ENSG00000253265'),
(2358, 5779, 'IGKV2-19', 'immunoglobulin kappa variable 2-19 (pseudogene)', 'pseudogene', 'ENSG00000253732'),
(2359, 5781, 'IGKV2-24', 'immunoglobulin kappa variable 2-24', 'other', 'ENSG00000241294'),
(2360, 5783, 'IGKV2-28', 'immunoglobulin kappa variable 2-28', 'other', 'ENSG00000244116'),
(2361, 5787, 'IGKV2-38', 'immunoglobulin kappa variable 2-38 (pseudogene)', 'pseudogene', 'ENSG00000253592'),
(2362, 5792, 'IGKV2D-10', 'immunoglobulin kappa variable 2D-10 (pseudogene)', 'pseudogene', 'ENSG00000253906'),
(2363, 5795, 'IGKV2D-19', 'immunoglobulin kappa variable 2D-19 (pseudogene)', 'pseudogene', 'ENSG00000253765'),
(2364, 5797, 'IGKV2D-24', 'immunoglobulin kappa variable 2D-24 (non-functional)', 'other', 'ENSG00000241566'),
(2365, 5800, 'IGKV2D-29', 'immunoglobulin kappa variable 2D-29', 'other', 'ENSG00000243264'),
(2366, 5808, 'IGKV2OR2-2', 'immunoglobulin kappa variable 2/OR2-2 (pseudogene)', 'pseudogene', 'ENSG00000271402'),
(2367, 5811, 'IGKV2OR2-8', 'immunoglobulin kappa variable 2/OR2-8 (pseudogene)', 'pseudogene', 'ENSG00000278537'),
(2368, 5806, 'IGKV2OR2-10', 'immunoglobulin kappa variable 2/OR2-10 (pseudogene)', 'pseudogene', 'ENSG00000276050'),
(2369, 5824, 'IGKV3D-15', 'immunoglobulin kappa variable 3D-15', 'other', 'ENSG00000224041'),
(2370, 5828, 'IGKV3D-34', 'immunoglobulin kappa variable 3D-34 (pseudogene)', 'pseudogene', 'ENSG00000253501'),
(2371, 5830, 'IGKV3OR2-268', 'immunoglobulin kappa variable 3/OR2-268 (non-functional)', 'other', 'ENSG00000233999'),
(2372, 5833, 'IGKV3OR22-2', 'immunoglobulin kappa variable 3/OR22-2 (pseudogene)', 'pseudogene', 'ENSG00000254264'),
(2373, 5856, 'IGLC2', 'immunoglobulin lambda constant 2', 'other', 'ENSG00000211677'),
(2374, 5861, 'IGLC7', 'immunoglobulin lambda constant 7', 'other', 'ENSG00000211685'),
(2375, 15696, 'IGLCOR22-1', 'immunoglobulin lambda constant/OR22-1 (pseudogene)', 'pseudogene', 'ENSG00000254127'),
(2376, 5867, 'IGLJ5', 'immunoglobulin lambda joining 5 (non-functional)', 'other', 'ENSG00000211681'),
(2377, 28614, 'IGLJCOR18', 'immunoglobulin lambda joining-constant/OR18 (pseudogene)', 'pseudogene', 'ENSG00000265243'),
(2378, 5894, 'IGLV2-5', 'immunoglobulin lambda variable 2-5 (pseudogene)', 'pseudogene', 'ENSG00000253234'),
(2379, 5895, 'IGLV2-8', 'immunoglobulin lambda variable 2-8', 'other', 'ENSG00000278196'),
(2380, 5887, 'IGLV2-11', 'immunoglobulin lambda variable 2-11', 'other', 'ENSG00000211668'),
(2381, 5888, 'IGLV2-14', 'immunoglobulin lambda variable 2-14', 'other', 'ENSG00000211666'),
(2382, 5908, 'IGLV3-25', 'immunoglobulin lambda variable 3-25', 'other', 'ENSG00000211659'),
(2383, 5911, 'IGLV3-29', 'immunoglobulin lambda variable 3-29 (pseudogene)', 'pseudogene', 'ENSG00000253338'),
(2384, 5912, 'IGLV3-30', 'immunoglobulin lambda variable 3-30 (pseudogene)', 'pseudogene', 'ENSG00000253329'),
(2385, 5921, 'IGLV4-69', 'immunoglobulin lambda variable 4-69', 'other', 'ENSG00000211637'),
(2386, 5927, 'IGLV6-57', 'immunoglobulin lambda variable 6-57', 'other', 'ENSG00000211640'),
(2387, 5928, 'IGLV7-35', 'immunoglobulin lambda variable 7-35 (pseudogene)', 'pseudogene', 'ENSG00000253631'),
(2388, 5929, 'IGLV7-43', 'immunoglobulin lambda variable 7-43', 'other', 'ENSG00000211652'),
(2389, 5932, 'IGLV8OR8-1', 'immunoglobulin lambda variable 8/OR8-1 (pseudogene)', 'pseudogene', 'ENSG00000215177'),
(2390, 5885, 'IGLV10-67', 'immunoglobulin lambda variable 10-67 (pseudogene)', 'pseudogene', 'ENSG00000253794'),
(2391, 5943, 'IGLVIV-64', 'immunoglobulin lambda variable (IV)-64 (pseudogene)', 'pseudogene', 'ENSG00000253242'),
(2392, 15689, 'IGLVVI-22-1', 'immunoglobulin lambda variable (VI)-22-1 (pseudogene)', 'pseudogene', 'ENSG00000253546'),
(2393, 55895, 'IGSF3P1', 'IGSF3 pseudogene 1', 'pseudogene', 'ENSG00000279124'),
(2394, 18132, 'IGSF9', 'immunoglobulin superfamily member 9', 'protein-coding gene', 'ENSG00000085552'),
(2395, 26384, 'IGSF10', 'immunoglobulin superfamily member 10', 'protein-coding gene', 'ENSG00000152580'),
(2396, 40777, 'IGSF11-AS1', 'IGSF11 antisense RNA 1', 'non-coding RNA', 'ENSG00000239877'),
(2397, 55511, 'IGSF22-AS1', 'IGSF22 antisense RNA 1', 'non-coding RNA', 'ENSG00000254966'),
(2398, 26430, 'IKBIP', 'IKBKB interacting protein', 'protein-coding gene', 'ENSG00000166130'),
(2399, 14552, 'IKBKE', 'inhibitor of nuclear factor kappa B kinase subunit epsilon', 'protein-coding gene', 'ENSG00000263528'),
(2400, 5992, 'IL1B', 'interleukin 1 beta', 'protein-coding gene', 'ENSG00000125538'),
(2401, 5996, 'IL1RAPL1', 'interleukin 1 receptor accessory protein like 1', 'protein-coding gene', 'ENSG00000169306'),
(2402, 5998, 'IL1RL1', 'interleukin 1 receptor like 1', 'protein-coding gene', 'ENSG00000115602'),
(2403, 6008, 'IL2RA', 'interleukin 2 receptor subunit alpha', 'protein-coding gene', 'ENSG00000134460'),
(2404, 6010, 'IL2RG', 'interleukin 2 receptor subunit gamma', 'protein-coding gene', 'ENSG00000147168'),
(2405, 6011, 'IL3', 'interleukin 3', 'protein-coding gene', 'ENSG00000164399'),
(2406, 6014, 'IL4', 'interleukin 4', 'protein-coding gene', 'ENSG00000113520'),
(2407, 6018, 'IL6', 'interleukin 6', 'protein-coding gene', 'ENSG00000136244'),
(2408, 6020, 'IL6RP1', 'interleukin 6 receptor pseudogene 1', 'pseudogene', 'ENSG00000234910'),
(2409, 55804, 'IL6ST-DT', 'IL6ST divergent transcript', 'non-coding RNA', 'ENSG00000227908'),
(2410, 6024, 'IL7R', 'interleukin 7 receptor', 'protein-coding gene', 'ENSG00000168685'),
(2411, 5969, 'IL12A', 'interleukin 12A', 'protein-coding gene', 'ENSG00000168811'),
(2412, 5972, 'IL12RB2', 'interleukin 12 receptor subunit beta 2', 'protein-coding gene', 'ENSG00000081985'),
(2413, 5977, 'IL15', 'interleukin 15', 'protein-coding gene', 'ENSG00000164136'),
(2414, 5984, 'IL17D', 'interleukin 17D', 'protein-coding gene', 'ENSG00000172458'),
(2415, 5986, 'IL18', 'interleukin 18', 'protein-coding gene', 'ENSG00000150782'),
(2416, 6002, 'IL20', 'interleukin 20', 'protein-coding gene', 'ENSG00000162891'),
(2417, 6003, 'IL20RA', 'interleukin 20 receptor subunit alpha', 'protein-coding gene', 'ENSG00000016402'),
(2418, 27551, 'IL21R-AS1', 'IL21R antisense RNA 1', 'non-coding RNA', 'ENSG00000259954'),
(2419, 14900, 'IL22', 'interleukin 22', 'protein-coding gene', 'ENSG00000127318'),
(2420, 13765, 'IL25', 'interleukin 25', 'protein-coding gene', 'ENSG00000166090'),
(2421, 19157, 'IL27', 'interleukin 27', 'protein-coding gene', 'ENSG00000197272'),
(2422, 19372, 'IL31', 'interleukin 31', 'protein-coding gene', 'ENSG00000204671'),
(2423, 18969, 'IL31RA', 'interleukin 31 receptor A', 'protein-coding gene', 'ENSG00000164509'),
(2424, 15741, 'IL36G', 'interleukin 36 gamma', 'protein-coding gene', 'ENSG00000136688'),
(2425, 15561, 'IL36RN', 'interleukin 36 receptor antagonist', 'protein-coding gene', 'ENSG00000136695'),
(2426, 18131, 'ILDR2', 'immunoglobulin like domain containing receptor 2', 'protein-coding gene', 'ENSG00000143195'),
(2427, 44695, 'ILF2P1', 'interleukin enhancer binding factor 2 pseudogene 1', 'pseudogene', 'ENSG00000244226'),
(2428, 15566, 'ILKAP', 'ILK associated serine/threonine phosphatase', 'protein-coding gene', 'ENSG00000132323'),
(2429, 55216, 'ILRUN-AS1', 'ILRUN antisense RNA 1', 'non-coding RNA', 'ENSG00000272288'),
(2430, 54748, 'ILRUNP1', 'ILRUN pseudogene 1', 'pseudogene', 'ENSG00000227513'),
(2431, 6041, 'ILVBL', 'ilvB acetolactate synthase like', 'protein-coding gene', 'ENSG00000105135'),
(2432, 14497, 'IMP3', 'IMP U3 small nucleolar ribonucleoprotein 3', 'protein-coding gene', 'ENSG00000177971'),
(2433, 49385, 'IMP3P1', 'IMP3 pseudogene 1', 'pseudogene', 'ENSG00000230589'),
(2434, 6050, 'IMPA1', 'inositol monophosphatase 1', 'protein-coding gene', 'ENSG00000133731'),
(2435, 33957, 'IMPDH1P2', 'inosine monophosphate dehydrogenase 1 pseudogene 2', 'pseudogene', 'ENSG00000214045'),
(2436, 18362, 'IMPG2', 'interphotoreceptor matrix proteoglycan 2', 'protein-coding gene', 'ENSG00000081148'),
(2437, 32224, 'INCA1', 'inhibitor of CDK, cyclin A1 interacting protein 1', 'protein-coding gene', 'ENSG00000196388'),
(2438, 6060, 'INE1', 'inactivation escape 1', 'non-coding RNA', 'ENSG00000224975'),
(2439, 6061, 'INE2', 'inactivation escape 2', 'non-coding RNA', 'ENSG00000281371'),
(2440, 19423, 'ING4', 'inhibitor of growth family member 4', 'protein-coding gene', 'ENSG00000111653'),
(2441, 6064, 'INGX', 'inhibitor of growth family, X-linked (pseudogene)', 'pseudogene', 'ENSG00000243468'),
(2442, 6066, 'INHBA', 'inhibin subunit beta A', 'protein-coding gene', 'ENSG00000122641'),
(2443, 24029, 'INHBE', 'inhibin subunit beta E', 'protein-coding gene', 'ENSG00000139269'),
(2444, 49446, 'INKA2-AS1', 'INKA2 antisense RNA 1', 'non-coding RNA', 'ENSG00000227811'),
(2445, 53138, 'INO80-AS1', 'INO80 antisense RNA 1', 'non-coding RNA', 'ENSG00000259521'),
(2446, 13324, 'INO80B', 'INO80 complex subunit B', 'protein-coding gene', 'ENSG00000115274'),
(2447, 55803, 'INO80D-AS2', 'INO80D antisense RNA 2', 'non-coding RNA', 'ENSG00000227946'),
(2448, 6077, 'INPP5B', 'inositol polyphosphate-5-phosphatase B', 'protein-coding gene', 'ENSG00000204084'),
(2449, 6079, 'INPP5D', 'inositol polyphosphate-5-phosphatase D', 'protein-coding gene', 'ENSG00000168918'),
(2450, 6083, 'INSIG1', 'insulin induced gene 1', 'protein-coding gene', 'ENSG00000186480'),
(2451, 20452, 'INSIG2', 'insulin induced gene 2', 'protein-coding gene', 'ENSG00000125629'),
(2452, 6087, 'INSL4', 'insulin like 4', 'protein-coding gene', 'ENSG00000120211'),
(2453, 22351, 'INTS4P2', 'integrator complex subunit 4 pseudogene 2', 'pseudogene', 'ENSG00000273024'),
(2454, 20739, 'IPMK', 'inositol polyphosphate multikinase', 'protein-coding gene', 'ENSG00000151151'),
(2455, 14645, 'IPPK', 'inositol-pentakisphosphate 2-kinase', 'protein-coding gene', 'ENSG00000127080'),
(2456, 26195, 'IQCA1', 'IQ motif containing with AAA domain 1', 'protein-coding gene', 'ENSG00000132321'),
(2457, 17727, 'IQCB2P', 'IQ motif containing B2 pseudogene', 'pseudogene', 'ENSG00000217539'),
(2458, 25168, 'IQCD', 'IQ motif containing D', 'protein-coding gene', 'ENSG00000166578'),
(2459, 29171, 'IQCE', 'IQ motif containing E', 'protein-coding gene', 'ENSG00000106012'),
(2460, 54720, 'IQCF4P', 'IQ motif containing F4, pseudogene', 'pseudogene', 'ENSG00000224792'),
(2461, 35159, 'IQCF5', 'IQ motif containing F5', 'protein-coding gene', 'ENSG00000214681'),
(2462, 25251, 'IQCG', 'IQ motif containing G', 'protein-coding gene', 'ENSG00000114473'),
(2463, 38842, 'IQCJ-SCHIP1', 'IQCJ-SCHIP1 readthrough', 'other', 'ENSG00000283154'),
(2464, 28556, 'IQCK', 'IQ motif containing K', 'protein-coding gene', 'ENSG00000174628'),
(2465, 29350, 'IQCN', 'IQ motif containing N', 'protein-coding gene', 'ENSG00000130518'),
(2466, 20669, 'IQGAP3', 'IQ motif containing GTPase activating protein 3', 'protein-coding gene', 'ENSG00000183856'),
(2467, 56002, 'IQSEC3-AS1', 'IQSEC3 antisense RNA 1', 'non-coding RNA', 'ENSG00000256540'),
(2468, 49848, 'IQSEC3P1', 'IQ motif and Sec7 domain 3 pseudogene 1', 'pseudogene', 'ENSG00000256902'),
(2469, 43434, 'IRAG1-AS1', 'IRAG1 antisense RNA 1', 'non-coding RNA', 'ENSG00000177112'),
(2470, 6112, 'IRAK1', 'interleukin 1 receptor associated kinase 1', 'protein-coding gene', 'ENSG00000184216'),
(2471, 6116, 'IRF1', 'interferon regulatory factor 1', 'protein-coding gene', 'ENSG00000125347'),
(2472, 33838, 'IRF1-AS1', 'IRF1 antisense RNA 1', 'non-coding RNA', 'ENSG00000197536'),
(2473, 6131, 'IRF9', 'interferon regulatory factor 9', 'protein-coding gene', 'ENSG00000213928'),
(2474, 28835, 'IRGC', 'immunity related GTPase cinema', 'protein-coding gene', 'ENSG00000124449'),
(2475, 6126, 'IRS2', 'insulin receptor substrate 2', 'protein-coding gene', 'ENSG00000185950'),
(2476, 6128, 'IRS4', 'insulin receptor substrate 4', 'protein-coding gene', 'ENSG00000133124'),
(2477, 14359, 'IRX2', 'iroquois homeobox 2', 'protein-coding gene', 'ENSG00000170561'),
(2478, 14360, 'IRX3', 'iroquois homeobox 3', 'protein-coding gene', 'ENSG00000177508'),
(2479, 40305, 'IRX4-AS1', 'IRX4 antisense RNA 1', 'non-coding RNA', 'ENSG00000249116'),
(2480, 14361, 'IRX5', 'iroquois homeobox 5', 'protein-coding gene', 'ENSG00000176842'),
(2481, 38025, 'ISCA1P4', 'iron-sulfur cluster assembly 1 pseudogene 4', 'pseudogene', 'ENSG00000259405'),
(2482, 38027, 'ISCA1P6', 'iron-sulfur cluster assembly 1 pseudogene 6', 'pseudogene', 'ENSG00000227653'),
(2483, 38022, 'ISCA2P1', 'iron-sulfur cluster assembly 2 pseudogene 1', 'pseudogene', 'ENSG00000226912'),
(2484, 29882, 'ISCU', 'iron-sulfur cluster assembly enzyme', 'protein-coding gene', 'ENSG00000136003'),
(2485, 25745, 'ISG20L2', 'interferon stimulated exonuclease gene 20 like 2', 'protein-coding gene', 'ENSG00000143319'),
(2486, 29286, 'ISLR2', 'immunoglobulin superfamily containing leucine rich repeat 2', 'protein-coding gene', 'ENSG00000167178'),
(2487, 16213, 'ISM1', 'isthmin 1', 'protein-coding gene', 'ENSG00000101230'),
(2488, 23176, 'ISM2', 'isthmin 2', 'protein-coding gene', 'ENSG00000100593'),
(2489, 24254, 'ISOC1', 'isochorismatase domain containing 1', 'protein-coding gene', 'ENSG00000066583'),
(2490, 13890, 'ITCH', 'itchy E3 ubiquitin protein ligase', 'protein-coding gene', 'ENSG00000078747'),
(2491, 53128, 'ITFG2-AS1', 'ITFG2 antisense RNA 1', 'non-coding RNA', 'ENSG00000258325'),
(2492, 40306, 'ITGA2-AS1', 'ITGA2 antisense RNA 1', 'non-coding RNA', 'ENSG00000249899'),
(2493, 6140, 'ITGA4', 'integrin subunit alpha 4', 'protein-coding gene', 'ENSG00000115232'),
(2494, 6142, 'ITGA6', 'integrin subunit alpha 6', 'protein-coding gene', 'ENSG00000091409'),
(2495, 6150, 'ITGAV', 'integrin subunit alpha V', 'protein-coding gene', 'ENSG00000138448'),
(2496, 23927, 'ITGB1BP1', 'integrin subunit beta 1 binding protein 1', 'protein-coding gene', 'ENSG00000119185'),
(2497, 40309, 'ITGB5-AS1', 'ITGB5 antisense RNA 1', 'non-coding RNA', 'ENSG00000244286'),
(2498, 18259, 'ITLN1', 'intelectin 1', 'protein-coding gene', 'ENSG00000179914'),
(2499, 20599, 'ITLN2', 'intelectin 2', 'protein-coding gene', 'ENSG00000158764'),
(2500, 6174, 'ITM2B', 'integral membrane protein 2B', 'protein-coding gene', 'ENSG00000136156'),
(2501, 20919, 'ITM2BP1', 'integral membrane protein 2B pseudogene 1', 'pseudogene', 'ENSG00000266853'),
(2502, 6176, 'ITPA', 'inosine triphosphatase', 'protein-coding gene', 'ENSG00000125877'),
(2503, 41349, 'ITPKB-IT1', 'ITPKB intronic transcript 1', 'non-coding RNA', 'ENSG00000228382'),
(2504, 14897, 'ITPKC', 'inositol-trisphosphate 3-kinase C', 'protein-coding gene', 'ENSG00000086544'),
(2505, 6182, 'ITPR3', 'inositol 1,4,5-trisphosphate receptor type 3', 'protein-coding gene', 'ENSG00000096433'),
(2506, 27363, 'ITPRID1', 'ITPR interacting domain containing 1', 'protein-coding gene', 'ENSG00000180347'),
(2507, 6186, 'IVD', 'isovaleryl-CoA dehydrogenase', 'protein-coding gene', 'ENSG00000128928'),
(2508, 21071, 'IYD', 'iodotyrosine deiodinase', 'protein-coding gene', 'ENSG00000009765'),
(2509, 31421, 'IZUMO3', 'IZUMO family member 3', 'protein-coding gene', 'ENSG00000205442'),
(2510, 6188, 'JAG1', 'jagged canonical Notch ligand 1', 'protein-coding gene', 'ENSG00000101384'),
(2511, 26926, 'JAGN1', 'jagunal homolog 1', 'protein-coding gene', 'ENSG00000171135'),
(2512, 6192, 'JAK2', 'Janus kinase 2', 'protein-coding gene', 'ENSG00000096968'),
(2513, 6193, 'JAK3', 'Janus kinase 3', 'protein-coding gene', 'ENSG00000105639'),
(2514, 26460, 'JAKMIP1', 'janus kinase and microtubule interacting protein 1', 'protein-coding gene', 'ENSG00000152969'),
(2515, 23523, 'JAKMIP3', 'Janus kinase and microtubule interacting protein 3', 'protein-coding gene', 'ENSG00000188385'),
(2516, 19084, 'JAML', 'junction adhesion molecule like', 'protein-coding gene', 'ENSG00000160593'),
(2517, 55240, 'JARID2-DT', 'JARID2 divergent transcript', 'non-coding RNA', 'ENSG00000271888'),
(2518, 55424, 'JDP2-AS1', 'JDP2 antisense RNA 1', 'non-coding RNA', 'ENSG00000259319'),
(2519, 14203, 'JPH3', 'junctophilin 3', 'protein-coding gene', 'ENSG00000154118'),
(2520, 4814, 'KALRN', 'kalirin RhoGEF kinase', 'protein-coding gene', 'ENSG00000160145'),
(2521, 19309, 'KANK1', 'KN motif and ankyrin repeat domains 1', 'protein-coding gene', 'ENSG00000107104'),
(2522, 24796, 'KANK3', 'KN motif and ankyrin repeat domains 3', 'protein-coding gene', 'ENSG00000186994'),
(2523, 27263, 'KANK4', 'KN motif and ankyrin repeat domains 4', 'protein-coding gene', 'ENSG00000132854'),
(2524, 39209, 'KARS1P3', 'lysyl-tRNA synthetase 1 pseudogene 3', 'pseudogene', 'ENSG00000262962'),
(2525, 17016, 'KAT7', 'lysine acetyltransferase 7', 'protein-coding gene', 'ENSG00000136504');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(2526, 49054, 'KATNBL1P4', 'katanin regulatory subunit B1 like 1 pseudogene 4', 'pseudogene', 'ENSG00000249270'),
(2527, 49055, 'KATNBL1P5', 'katanin regulatory subunit B1 like 1 pseudogene 5', 'pseudogene', 'ENSG00000271108'),
(2528, 49056, 'KATNBL1P6', 'katanin regulatory subunit B1 like 1 pseudogene 6', 'pseudogene', 'ENSG00000228283'),
(2529, 25340, 'KBTBD6', 'kelch repeat and BTB domain containing 6', 'protein-coding gene', 'ENSG00000165572'),
(2530, 30691, 'KBTBD8', 'kelch repeat and BTB domain containing 8', 'protein-coding gene', 'ENSG00000163376'),
(2531, 49147, 'KBTBD11-OT1', 'KBTBD11 overlapping transcript 1', 'non-coding RNA', 'ENSG00000253696'),
(2532, 6222, 'KCNA4', 'potassium voltage-gated channel subfamily A member 4', 'protein-coding gene', 'ENSG00000182255'),
(2533, 6219, 'KCNA10', 'potassium voltage-gated channel subfamily A member 10', 'protein-coding gene', 'ENSG00000143105'),
(2534, 6229, 'KCNAB2', 'potassium voltage-gated channel subfamily A regulatory beta subunit 2', 'protein-coding gene', 'ENSG00000069424'),
(2535, 6231, 'KCNB1', 'potassium voltage-gated channel subfamily B member 1', 'protein-coding gene', 'ENSG00000158445'),
(2536, 6236, 'KCNC4', 'potassium voltage-gated channel subfamily C member 4', 'protein-coding gene', 'ENSG00000116396'),
(2537, 40317, 'KCND3-AS1', 'KCND3 antisense RNA 1', 'non-coding RNA', 'ENSG00000237556'),
(2538, 6249, 'KCNG2', 'potassium voltage-gated channel modifier subfamily G member 2', 'protein-coding gene', 'ENSG00000178342'),
(2539, 41351, 'KCNH1-IT1', 'KCNH1 intronic transcript 1', 'non-coding RNA', 'ENSG00000234233'),
(2540, 6251, 'KCNH2', 'potassium voltage-gated channel subfamily H member 2', 'protein-coding gene', 'ENSG00000055118'),
(2541, 6254, 'KCNH5', 'potassium voltage-gated channel subfamily H member 5', 'protein-coding gene', 'ENSG00000140015'),
(2542, 18863, 'KCNH7', 'potassium voltage-gated channel subfamily H member 7', 'protein-coding gene', 'ENSG00000184611'),
(2543, 40320, 'KCNIP1-OT1', 'KCNIP1 overlapping transcript 1', 'non-coding RNA', 'ENSG00000253647'),
(2544, 15523, 'KCNIP3', 'potassium voltage-gated channel interacting protein 3', 'protein-coding gene', 'ENSG00000115041'),
(2545, 6263, 'KCNJ2', 'potassium inwardly rectifying channel subfamily J member 2', 'protein-coding gene', 'ENSG00000123700'),
(2546, 6266, 'KCNJ5', 'potassium inwardly rectifying channel subfamily J member 5', 'protein-coding gene', 'ENSG00000120457'),
(2547, 6260, 'KCNJ14', 'potassium inwardly rectifying channel subfamily J member 14', 'protein-coding gene', 'ENSG00000182324'),
(2548, 6278, 'KCNK3', 'potassium two pore domain channel subfamily K member 3', 'protein-coding gene', 'ENSG00000171303'),
(2549, 6280, 'KCNK5', 'potassium two pore domain channel subfamily K member 5', 'protein-coding gene', 'ENSG00000164626'),
(2550, 13814, 'KCNK15', 'potassium two pore domain channel subfamily K member 15', 'protein-coding gene', 'ENSG00000124249'),
(2551, 6301, 'KCNS2', 'potassium voltage-gated channel modifier subfamily S member 2', 'protein-coding gene', 'ENSG00000156486'),
(2552, 18867, 'KCNU1', 'potassium calcium-activated channel subfamily U member 1', 'protein-coding gene', 'ENSG00000215262'),
(2553, 21423, 'KCTD5', 'potassium channel tetramerization domain containing 5', 'protein-coding gene', 'ENSG00000167977'),
(2554, 22401, 'KCTD9', 'potassium channel tetramerization domain containing 9', 'protein-coding gene', 'ENSG00000104756'),
(2555, 55585, 'KCTD13-DT', 'KCTD13 divergent transcript', 'non-coding RNA', 'ENSG00000247735'),
(2556, 23295, 'KCTD14', 'potassium channel tetramerization domain containing 14', 'protein-coding gene', 'ENSG00000151364'),
(2557, 29244, 'KCTD16', 'potassium channel tetramerization domain containing 16', 'protein-coding gene', 'ENSG00000183775'),
(2558, 26624, 'KDF1', 'keratinocyte differentiation factor 1', 'protein-coding gene', 'ENSG00000175707'),
(2559, 21577, 'KDM1B', 'lysine demethylase 1B', 'protein-coding gene', 'ENSG00000165097'),
(2560, 53287, 'KDM2B-DT', 'KDM2B divergent transcript', 'non-coding RNA', 'ENSG00000256742'),
(2561, 37098, 'KDM4E', 'lysine demethylase 4E', 'protein-coding gene', 'ENSG00000235268'),
(2562, 18039, 'KDM5B', 'lysine demethylase 5B', 'protein-coding gene', 'ENSG00000117139'),
(2563, 29012, 'KDM6B', 'lysine demethylase 6B', 'protein-coding gene', 'ENSG00000132510'),
(2564, 55299, 'KDSR-DT', 'KDSR divergent transcript', 'non-coding RNA', 'ENSG00000267390'),
(2565, 23177, 'KEAP1', 'kelch like ECH associated protein 1', 'protein-coding gene', 'ENSG00000079999'),
(2566, 53911, 'KHDRBS2-OT1', 'KHDRBS2 3\'UTR overlapping transcript 1', 'non-coding RNA', 'ENSG00000250686'),
(2567, 22191, 'KIAA0087', 'KIAA0087 lncRNA', 'non-coding RNA', 'ENSG00000122548'),
(2568, 28992, 'KIAA0232', 'KIAA0232', 'protein-coding gene', 'ENSG00000170871'),
(2569, 30071, 'KIAA0319L', 'KIAA0319 like', 'protein-coding gene', 'ENSG00000142687'),
(2570, 28532, 'KIAA0825', 'KIAA0825', 'protein-coding gene', 'ENSG00000185261'),
(2571, 53865, 'KIAA0895LP1', 'KIAA00895L pseudogene 1', 'pseudogene', 'ENSG00000264714'),
(2572, 26953, 'KIAA1109', 'KIAA1109', 'protein-coding gene', 'ENSG00000138688'),
(2573, 54591, 'KIAA1143P1', 'KIAA1143 pseudogene 1', 'pseudogene', 'ENSG00000259086'),
(2574, 24836, 'KIAA1549L', 'KIAA1549 like', 'protein-coding gene', 'ENSG00000110427'),
(2575, 28513, 'KIAA2013', 'KIAA2013', 'protein-coding gene', 'ENSG00000116685'),
(2576, 26517, 'KICS2', 'KICSTOR subunit 2', 'protein-coding gene', 'ENSG00000174206'),
(2577, 29508, 'KIDINS220', 'kinase D interacting substrate 220', 'protein-coding gene', 'ENSG00000134313'),
(2578, 26822, 'KIF9-AS1', 'KIF9 antisense RNA 1', 'non-coding RNA', 'ENSG00000227398'),
(2579, 15869, 'KIF16B', 'kinesin family member 16B', 'protein-coding gene', 'ENSG00000089177'),
(2580, 51808, 'KIF18BP1', 'kinesin family member 18B pseudogene 1', 'pseudogene', 'ENSG00000260746'),
(2581, 26735, 'KIF19', 'kinesin family member 19', 'protein-coding gene', 'ENSG00000196169'),
(2582, 19349, 'KIF21A', 'kinesin family member 21A', 'protein-coding gene', 'ENSG00000139116'),
(2583, 6392, 'KIF23', 'kinesin family member 23', 'protein-coding gene', 'ENSG00000137807'),
(2584, 6390, 'KIF25', 'kinesin family member 25', 'protein-coding gene', 'ENSG00000125337'),
(2585, 23419, 'KIFBP', 'kinesin family binding protein', 'protein-coding gene', 'ENSG00000198954'),
(2586, 6329, 'KIR2DL1', 'killer cell immunoglobulin like receptor, two Ig domains and long cytoplasmic tail 1', 'protein-coding gene', 'ENSG00000125498'),
(2587, 6339, 'KIR3DL2', 'killer cell immunoglobulin like receptor, three Ig domains and long cytoplasmic tail 2', 'protein-coding gene', 'ENSG00000240403'),
(2588, 25043, 'KIR3DX1', 'killer cell immunoglobulin like receptor, three Ig domains X1 (pseudogene)', 'pseudogene', 'ENSG00000104970'),
(2589, 41412, 'KIRREL1-IT1', 'KIRREL1 intronic transcript 1', 'non-coding RNA', 'ENSG00000226520'),
(2590, 42655, 'KIRREL3-AS1', 'KIRREL3 antisense RNA 1', 'non-coding RNA', 'ENSG00000257271'),
(2591, 6343, 'KITLG', 'KIT ligand', 'protein-coding gene', 'ENSG00000049130'),
(2592, 51231, 'KIZ-AS1', 'KIZ antisense RNA 1', 'non-coding RNA', 'ENSG00000232712'),
(2593, 55515, 'KLC2-AS2', 'KLC2 antisense RNA 2', 'non-coding RNA', 'ENSG00000254762'),
(2594, 20717, 'KLC3', 'kinesin light chain 3', 'protein-coding gene', 'ENSG00000104892'),
(2595, 6348, 'KLF4', 'Kruppel like factor 4', 'protein-coding gene', 'ENSG00000136826'),
(2596, 6349, 'KLF5', 'Kruppel like factor 5', 'protein-coding gene', 'ENSG00000102554'),
(2597, 2235, 'KLF6', 'Kruppel like factor 6', 'protein-coding gene', 'ENSG00000067082'),
(2598, 41520, 'KLF8P1', 'Kruppel like factor 8 pseudogene 1', 'pseudogene', 'ENSG00000260726'),
(2599, 11811, 'KLF11', 'Kruppel like factor 11', 'protein-coding gene', 'ENSG00000172059'),
(2600, 20231, 'KLHDC2', 'kelch domain containing 2', 'protein-coding gene', 'ENSG00000165516'),
(2601, 40850, 'KLHL6-AS1', 'KLHL6 antisense RNA 1', 'non-coding RNA', 'ENSG00000242522'),
(2602, 43431, 'KLHL7-DT', 'KLHL7 divergent transcript', 'non-coding RNA', 'ENSG00000230658'),
(2603, 18829, 'KLHL10', 'kelch like family member 10', 'protein-coding gene', 'ENSG00000161594'),
(2604, 29252, 'KLHL42', 'kelch like family member 42', 'protein-coding gene', 'ENSG00000087448'),
(2605, 6357, 'KLK1', 'kallikrein 1', 'protein-coding gene', 'ENSG00000167748'),
(2606, 6367, 'KLK6', 'kallikrein related peptidase 6', 'protein-coding gene', 'ENSG00000167755'),
(2607, 6360, 'KLK12', 'kallikrein related peptidase 12', 'protein-coding gene', 'ENSG00000186474'),
(2608, 21260, 'KLKP1', 'kallikrein pseudogene 1', 'pseudogene', 'ENSG00000197588'),
(2609, 6374, 'KLRC1', 'killer cell lectin like receptor C1', 'protein-coding gene', 'ENSG00000134545'),
(2610, 48357, 'KLRC4-KLRK1', 'KLRC4-KLRK1 readthrough', 'other', 'ENSG00000255819'),
(2611, 6378, 'KLRD1', 'killer cell lectin like receptor D1', 'protein-coding gene', 'ENSG00000134539'),
(2612, 6381, 'KMO', 'kynurenine 3-monooxygenase', 'protein-coding gene', 'ENSG00000117009'),
(2613, 7132, 'KMT2A', 'lysine methyltransferase 2A', 'protein-coding gene', 'ENSG00000118058'),
(2614, 15840, 'KMT2B', 'lysine methyltransferase 2B', 'protein-coding gene', 'ENSG00000272333'),
(2615, 56181, 'KMT2CP3', 'lysine methyltransferase 2C pseudogene 3', 'pseudogene', 'ENSG00000274927'),
(2616, 56183, 'KMT2CP5', 'lysine methyltransferase 2C pseudogene 5', 'pseudogene', 'ENSG00000230572'),
(2617, 29374, 'KNDC1', 'kinase non-catalytic C-lobe domain containing 1', 'protein-coding gene', 'ENSG00000171798'),
(2618, 6383, 'KNG1', 'kininogen 1', 'protein-coding gene', 'ENSG00000113889'),
(2619, 48920, 'KNOP1P2', 'lysine rich nucleolar protein 1 pseudogene 2', 'pseudogene', 'ENSG00000270429'),
(2620, 48922, 'KNOP1P4', 'lysine rich nucleolar protein 1 pseudogene 4', 'pseudogene', 'ENSG00000232422'),
(2621, 52870, 'KPNA2P3', 'karyopherin subunit alpha 2 pseudogene 3', 'pseudogene', 'ENSG00000266820'),
(2622, 6398, 'KPNA5', 'karyopherin subunit alpha 5', 'protein-coding gene', 'ENSG00000196911'),
(2623, 6400, 'KPNB1', 'karyopherin subunit beta 1', 'protein-coding gene', 'ENSG00000108424'),
(2624, 6404, 'KPTN', 'kaptin, actin binding protein', 'protein-coding gene', 'ENSG00000118162'),
(2625, 1573, 'KRIT1', 'KRIT1 ankyrin repeat containing', 'protein-coding gene', 'ENSG00000001631'),
(2626, 6441, 'KRT4', 'keratin 4', 'protein-coding gene', 'ENSG00000170477'),
(2627, 6446, 'KRT8', 'keratin 8', 'protein-coding gene', 'ENSG00000170421'),
(2628, 20282, 'KRT8P2', 'keratin 8 pseudogene 2', 'pseudogene', 'ENSG00000258828'),
(2629, 31058, 'KRT8P11', 'keratin 8 pseudogene 11', 'pseudogene', 'ENSG00000255815'),
(2630, 28057, 'KRT8P12', 'keratin 8 pseudogene 12', 'pseudogene', 'ENSG00000229320'),
(2631, 33369, 'KRT8P17', 'keratin 8 pseudogene 17', 'pseudogene', 'ENSG00000235124'),
(2632, 33376, 'KRT8P24', 'keratin 8 pseudogene 24', 'pseudogene', 'ENSG00000259500'),
(2633, 33379, 'KRT8P27', 'keratin 8 pseudogene 27', 'pseudogene', 'ENSG00000226502'),
(2634, 33382, 'KRT8P30', 'keratin 8 pseudogene 30', 'pseudogene', 'ENSG00000224928'),
(2635, 39866, 'KRT8P32', 'keratin 8 pseudogene 32', 'pseudogene', 'ENSG00000250221'),
(2636, 39867, 'KRT8P33', 'keratin 8 pseudogene 33', 'pseudogene', 'ENSG00000250539'),
(2637, 39868, 'KRT8P34', 'keratin 8 pseudogene 34', 'pseudogene', 'ENSG00000264663'),
(2638, 39869, 'KRT8P35', 'keratin 8 pseudogene 35', 'pseudogene', 'ENSG00000242841'),
(2639, 39877, 'KRT8P43', 'keratin 8 pseudogene 43', 'pseudogene', 'ENSG00000218186'),
(2640, 39878, 'KRT8P44', 'keratin 8 pseudogene 44', 'pseudogene', 'ENSG00000227913'),
(2641, 39879, 'KRT8P45', 'keratin 8 pseudogene 45', 'pseudogene', 'ENSG00000224520'),
(2642, 39880, 'KRT8P46', 'keratin 8 pseudogene 46', 'pseudogene', 'ENSG00000248971'),
(2643, 48344, 'KRT8P48', 'keratin 8 pseudogene 48', 'pseudogene', 'ENSG00000248568'),
(2644, 6447, 'KRT9', 'keratin 9', 'protein-coding gene', 'ENSG00000171403'),
(2645, 28305, 'KRT10-AS1', 'KRT10 antisense RNA 1', 'non-coding RNA', 'ENSG00000167920'),
(2646, 37810, 'KRT16P5', 'keratin 16 pseudogene 5', 'pseudogene', 'ENSG00000230088'),
(2647, 50722, 'KRT17P4', 'keratin 17 pseudogene 4', 'pseudogene', 'ENSG00000205312'),
(2648, 50723, 'KRT17P5', 'keratin 17 pseudogene 5', 'pseudogene', 'ENSG00000205266'),
(2649, 6431, 'KRT18P11', 'keratin 18 pseudogene 11', 'pseudogene', 'ENSG00000215089'),
(2650, 33390, 'KRT18P22', 'keratin 18 pseudogene 22', 'pseudogene', 'ENSG00000218153'),
(2651, 33398, 'KRT18P29', 'keratin 18 pseudogene 29', 'pseudogene', 'ENSG00000213958'),
(2652, 33400, 'KRT18P31', 'keratin 18 pseudogene 31', 'pseudogene', 'ENSG00000249850'),
(2653, 33402, 'KRT18P33', 'keratin 18 pseudogene 33', 'pseudogene', 'ENSG00000214533'),
(2654, 33406, 'KRT18P37', 'keratin 18 pseudogene 37', 'pseudogene', 'ENSG00000253943'),
(2655, 33407, 'KRT18P38', 'keratin 18 pseudogene 38', 'pseudogene', 'ENSG00000214012'),
(2656, 43923, 'KRT18P56', 'keratin 18 pseudogene 56', 'pseudogene', 'ENSG00000249668'),
(2657, 48888, 'KRT18P61', 'keratin 18 pseudogene 61', 'pseudogene', 'ENSG00000267083'),
(2658, 48889, 'KRT18P62', 'keratin 18 pseudogene 62', 'pseudogene', 'ENSG00000233471'),
(2659, 48893, 'KRT18P66', 'keratin 18 pseudogene 66', 'pseudogene', 'ENSG00000235626'),
(2660, 48895, 'KRT18P68', 'keratin 18 pseudogene 68', 'pseudogene', 'ENSG00000213100'),
(2661, 33422, 'KRT19P1', 'keratin 19 pseudogene 1', 'pseudogene', 'ENSG00000218014'),
(2662, 6438, 'KRT23', 'keratin 23', 'protein-coding gene', 'ENSG00000108244'),
(2663, 30840, 'KRT26', 'keratin 26', 'protein-coding gene', 'ENSG00000186393'),
(2664, 6449, 'KRT32', 'keratin 32', 'protein-coding gene', 'ENSG00000108759'),
(2665, 28927, 'KRT71', 'keratin 71', 'protein-coding gene', 'ENSG00000139648'),
(2666, 24431, 'KRT75', 'keratin 75', 'protein-coding gene', 'ENSG00000170454'),
(2667, 6461, 'KRT84', 'keratin 84', 'protein-coding gene', 'ENSG00000161849'),
(2668, 30198, 'KRT87P', 'keratin 87, pseudogene', 'pseudogene', 'ENSG00000135477'),
(2669, 32970, 'KRT126P', 'keratin 126, pseudogene', 'pseudogene', 'ENSG00000257402'),
(2670, 40019, 'KRT127P', 'keratin 127, pseudogene', 'pseudogene', 'ENSG00000257125'),
(2671, 48882, 'KRT128P', 'keratin 128, pseudogene', 'pseudogene', 'ENSG00000258120'),
(2672, 28695, 'KRT222', 'keratin 222', 'protein-coding gene', 'ENSG00000213424'),
(2673, 16772, 'KRTAP1-1', 'keratin associated protein 1-1', 'protein-coding gene', 'ENSG00000188581'),
(2674, 18920, 'KRTAP2-5P', 'keratin associated protein 2-5, pseudogene', 'pseudogene', 'ENSG00000237230'),
(2675, 18919, 'KRTAP3-4P', 'keratin associated protein 3-4, pseudogene', 'pseudogene', 'ENSG00000226776'),
(2676, 16928, 'KRTAP4-4', 'keratin associated protein 4-4', 'protein-coding gene', 'ENSG00000171396'),
(2677, 18910, 'KRTAP4-9', 'keratin associated protein 4-9', 'protein-coding gene', 'ENSG00000212722'),
(2678, 23601, 'KRTAP5-5', 'keratin associated protein 5-5', 'protein-coding gene', 'ENSG00000185940'),
(2679, 23600, 'KRTAP5-6', 'keratin associated protein 5-6', 'protein-coding gene', 'ENSG00000205864'),
(2680, 23605, 'KRTAP5-10', 'keratin associated protein 5-10', 'protein-coding gene', 'ENSG00000204572'),
(2681, 27877, 'KRTAP5-AS1', 'KRTAP5-1/KRTAP5-2 antisense RNA 1', 'non-coding RNA', 'ENSG00000233930'),
(2682, 18949, 'KRTAP8-3P', 'keratin associated protein 8-3, pseudogene', 'pseudogene', 'ENSG00000227840'),
(2683, 18912, 'KRTAP9-1', 'keratin associated protein 9-1', 'protein-coding gene', 'ENSG00000240542'),
(2684, 18902, 'KRTAP9-4', 'keratin associated protein 9-4', 'protein-coding gene', 'ENSG00000241595'),
(2685, 34210, 'KRTAP9-10P', 'keratin associated protein 9-10, pseudogene', 'pseudogene', 'ENSG00000237183'),
(2686, 22967, 'KRTAP10-2', 'keratin associated protein 10-2', 'protein-coding gene', 'ENSG00000205445'),
(2687, 22970, 'KRTAP10-7', 'keratin associated protein 10-7', 'protein-coding gene', 'ENSG00000272804'),
(2688, 20532, 'KRTAP12-4', 'keratin associated protein 12-4', 'protein-coding gene', 'ENSG00000212933'),
(2689, 53815, 'KRTAP12-6P', 'keratin associated protein 12-6, pseudogene', 'pseudogene', 'ENSG00000276647'),
(2690, 18925, 'KRTAP13-3', 'keratin associated protein 13-3', 'protein-coding gene', 'ENSG00000240432'),
(2691, 18937, 'KRTAP19-2', 'keratin associated protein 19-2', 'protein-coding gene', 'ENSG00000186965'),
(2692, 18951, 'KRTAP19-10P', 'keratin associated protein 19-10, pseudogene', 'pseudogene', 'ENSG00000235312'),
(2693, 18943, 'KRTAP20-1', 'keratin associated protein 20-1', 'protein-coding gene', 'ENSG00000244624'),
(2694, 18954, 'KRTAP21-4P', 'keratin associated protein 21-4, pseudogene', 'pseudogene', 'ENSG00000236400'),
(2695, 37091, 'KRTAP22-2', 'keratin associated protein 22-2', 'protein-coding gene', 'ENSG00000206106'),
(2696, 18928, 'KRTAP23-1', 'keratin associated protein 23-1', 'protein-coding gene', 'ENSG00000186980'),
(2697, 28943, 'KRTCAP3', 'keratinocyte associated protein 3', 'protein-coding gene', 'ENSG00000157992'),
(2698, 25160, 'KTI12', 'KTI12 chromatin associated homolog', 'protein-coding gene', 'ENSG00000198841'),
(2699, 19842, 'KTN1-AS1', 'KTN1 antisense RNA 1', 'non-coding RNA', 'ENSG00000186615'),
(2700, 26576, 'KY', 'kyphoscoliosis peptidase', 'protein-coding gene', 'ENSG00000174611'),
(2701, 33238, 'KYAT3', 'kynurenine aminotransferase 3', 'protein-coding gene', 'ENSG00000137944'),
(2702, 39199, 'KYNUP1', 'kynureninase pseudogene 1', 'pseudogene', 'ENSG00000261987'),
(2703, 55247, 'L1CAM-AS1', 'L1CAM antisense RNA 1', 'non-coding RNA', 'ENSG00000273769'),
(2704, 23035, 'L3MBTL3', 'L3MBTL histone methyl-lysine binding protein 3', 'protein-coding gene', 'ENSG00000198945'),
(2705, 51320, 'L3MBTL4-AS1', 'L3MBTL4 antisense RNA 1', 'non-coding RNA', 'ENSG00000264707'),
(2706, 16468, 'LACTB', 'lactamase beta', 'protein-coding gene', 'ENSG00000103642'),
(2707, 6476, 'LAG3', 'lymphocyte activating 3', 'protein-coding gene', 'ENSG00000089692'),
(2708, 6480, 'LALBA', 'lactalbumin alpha', 'protein-coding gene', 'ENSG00000167531'),
(2709, 6488, 'LAMB2P1', 'laminin subunit beta 2 pseudogene 1', 'pseudogene', 'ENSG00000270441'),
(2710, 6491, 'LAMB4', 'laminin subunit beta 4', 'protein-coding gene', 'ENSG00000091128'),
(2711, 6492, 'LAMC1', 'laminin subunit gamma 1', 'protein-coding gene', 'ENSG00000135862'),
(2712, 6499, 'LAMP1', 'lysosomal associated membrane protein 1', 'protein-coding gene', 'ENSG00000185896'),
(2713, 40823, 'LAMTOR5-AS1', 'LAMTOR5 antisense RNA 1', 'non-coding RNA', 'ENSG00000224699'),
(2714, 50727, 'LANCL1-AS1', 'LANCL1 antisense RNA 1', 'non-coding RNA', 'ENSG00000234281'),
(2715, 42364, 'LAP3P1', 'leucine aminopeptidase 3 pseudogene 1', 'pseudogene', 'ENSG00000220091'),
(2716, 51935, 'LAPTM4BP2', 'lysosomal protein transmembrane 4 beta pseudogene 2', 'pseudogene', 'ENSG00000271266'),
(2717, 55162, 'LARGE1-AS1', 'LARGE1 antisense RNA 1', 'non-coding RNA', 'ENSG00000273082'),
(2718, 37097, 'LARP1BP1', 'LARP1B pseudogene 1', 'pseudogene', 'ENSG00000231442'),
(2719, 6513, 'LASP1', 'LIM and SH3 protein 1', 'protein-coding gene', 'ENSG00000002834'),
(2720, 6515, 'LATS2', 'large tumor suppressor kinase 2', 'protein-coding gene', 'ENSG00000150457'),
(2721, 29471, 'LAYN', 'layilin', 'protein-coding gene', 'ENSG00000204381'),
(2722, 52384, 'LBHD2', 'LBH domain containing 2', 'protein-coding gene', 'ENSG00000283071'),
(2723, 48678, 'LBX1-AS1', 'LBX1 antisense RNA 1', 'non-coding RNA', 'ENSG00000227128'),
(2724, 25136, 'LBX2-AS1', 'LBX2 antisense RNA 1', 'non-coding RNA', 'ENSG00000257702'),
(2725, 6522, 'LCAT', 'lecithin-cholesterol acyltransferase', 'protein-coding gene', 'ENSG00000213398'),
(2726, 29466, 'LCE1E', 'late cornified envelope 1E', 'protein-coding gene', 'ENSG00000186226'),
(2727, 16518, 'LCE2D', 'late cornified envelope 2D', 'protein-coding gene', 'ENSG00000187223'),
(2728, 16612, 'LCE3C', 'late cornified envelope 3C', 'protein-coding gene', 'ENSG00000244057'),
(2729, 31824, 'LCE6A', 'late cornified envelope 6A', 'protein-coding gene', 'ENSG00000235942'),
(2730, 6524, 'LCK', 'LCK proto-oncogene, Src family tyrosine kinase', 'protein-coding gene', 'ENSG00000182866'),
(2731, 51177, 'LCMT1-AS1', 'LCMT1 antisense RNA 1', 'non-coding RNA', 'ENSG00000260448'),
(2732, 17558, 'LCMT2', 'leucine carboxyl methyltransferase 2', 'protein-coding gene', 'ENSG00000168806'),
(2733, 6525, 'LCN1', 'lipocalin 1', 'protein-coding gene', 'ENSG00000160349'),
(2734, 23412, 'LCN1P1', 'lipocalin 1 pseudogene 1', 'pseudogene', 'ENSG00000119440'),
(2735, 6526, 'LCN2', 'lipocalin 2', 'protein-coding gene', 'ENSG00000148346'),
(2736, 28733, 'LCN12', 'lipocalin 12', 'protein-coding gene', 'ENSG00000184925'),
(2737, 29503, 'LCOR', 'ligand dependent nuclear receptor corepressor', 'protein-coding gene', 'ENSG00000196233'),
(2738, 6529, 'LCP2', 'lymphocyte cytosolic protein 2', 'protein-coding gene', 'ENSG00000043462'),
(2739, 30136, 'LDAF1', 'lipid droplet assembly factor 1', 'protein-coding gene', 'ENSG00000011638'),
(2740, 49677, 'LDC1P', 'leucine decarboxylase 1, pseudogene', 'pseudogene', 'ENSG00000260386'),
(2741, 44239, 'LDHAL6DP', 'lactate dehydrogenase A like 6D, pseudogene', 'pseudogene', 'ENSG00000250257'),
(2742, 44240, 'LDHAL6FP', 'lactate dehydrogenase A like 6F, pseudogene', 'pseudogene', 'ENSG00000217783'),
(2743, 6548, 'LDOC1', 'LDOC1 regulator of NFKB signaling', 'protein-coding gene', 'ENSG00000182195'),
(2744, 40339, 'LEF1-AS1', 'LEF1 antisense RNA 1', 'non-coding RNA', 'ENSG00000232021'),
(2745, 32046, 'LELP1', 'late cornified envelope like proline rich 1', 'protein-coding gene', 'ENSG00000203784'),
(2746, 44132, 'LEMD1-AS1', 'LEMD1 antisense RNA 1', 'non-coding RNA', 'ENSG00000226235'),
(2747, 15502, 'LENG1', 'leukocyte receptor cluster member 1', 'protein-coding gene', 'ENSG00000105617'),
(2748, 15500, 'LENG8', 'leukocyte receptor cluster member 8', 'protein-coding gene', 'ENSG00000167615'),
(2749, 29477, 'LEPROT', 'leptin receptor overlapping transcript', 'protein-coding gene', 'ENSG00000213625'),
(2750, 6561, 'LGALS1', 'galectin 1', 'protein-coding gene', 'ENSG00000100097'),
(2751, 6563, 'LGALS3', 'galectin 3', 'protein-coding gene', 'ENSG00000131981'),
(2752, 6565, 'LGALS4', 'galectin 4', 'protein-coding gene', 'ENSG00000171747'),
(2753, 15788, 'LGALS12', 'galectin 12', 'protein-coding gene', 'ENSG00000133317'),
(2754, 30054, 'LGALS14', 'galectin 14', 'protein-coding gene', 'ENSG00000006659'),
(2755, 40039, 'LGALS16', 'galectin 16', 'protein-coding gene', 'ENSG00000249861'),
(2756, 21016, 'LGSN', 'lengsin, lens protein with glutamine synthetase domain', 'protein-coding gene', 'ENSG00000146166'),
(2757, 6587, 'LHFPL1', 'LHFPL tetraspan subfamily member 1', 'protein-coding gene', 'ENSG00000182508'),
(2758, 6589, 'LHFPL3', 'LHFPL tetraspan subfamily member 3', 'protein-coding gene', 'ENSG00000187416'),
(2759, 29568, 'LHFPL4', 'LHFPL tetraspan subfamily member 4', 'protein-coding gene', 'ENSG00000156959'),
(2760, 53778, 'LHX1-DT', 'LHX1 divergent transcript', 'non-coding RNA', 'ENSG00000277268'),
(2761, 6597, 'LIFR', 'LIF receptor subunit alpha', 'protein-coding gene', 'ENSG00000113594'),
(2762, 15503, 'LILRA4', 'leukocyte immunoglobulin like receptor A4', 'protein-coding gene', 'ENSG00000239961'),
(2763, 15495, 'LILRA6', 'leukocyte immunoglobulin like receptor A6', 'protein-coding gene', 'ENSG00000244482'),
(2764, 6606, 'LILRB2', 'leukocyte immunoglobulin like receptor B2', 'protein-coding gene', 'ENSG00000131042'),
(2765, 15497, 'LILRP2', 'leukocyte immunoglobulin-like receptor pseudogene 2', 'pseudogene', 'ENSG00000170858'),
(2766, 56004, 'LIM2-AS1', 'LIM2 and SIGLEC10 antisense RNA 1', 'non-coding RNA', 'ENSG00000268889'),
(2767, 29191, 'LIMCH1', 'LIM and calponin homology domains 1', 'protein-coding gene', 'ENSG00000064042'),
(2768, 28142, 'LIMD2', 'LIM domain containing 2', 'protein-coding gene', 'ENSG00000136490'),
(2769, 21553, 'LIN28B-AS1', 'LIN28B antisense RNA 1', 'non-coding RNA', 'ENSG00000203809'),
(2770, 25397, 'LIN54', 'lin-54 DREAM MuvB core complex component', 'protein-coding gene', 'ENSG00000189308'),
(2771, 1265, 'LINC00114', 'long intergenic non-protein coding RNA 114', 'non-coding RNA', 'ENSG00000223806'),
(2772, 1283, 'LINC00158', 'long intergenic non-protein coding RNA 158', 'non-coding RNA', 'ENSG00000185433'),
(2773, 33166, 'LINC00165', 'long intergenic non-protein coding RNA 165', 'non-coding RNA', 'ENSG00000261706'),
(2774, 27788, 'LINC00174', 'long intergenic non-protein coding RNA 174', 'non-coding RNA', 'ENSG00000179406'),
(2775, 37192, 'LINC00184', 'long intergenic non-protein coding RNA 184', 'non-coding RNA', 'ENSG00000224939'),
(2776, 18461, 'LINC00189', 'long intergenic non-protein coding RNA 189', 'non-coding RNA', 'ENSG00000215533'),
(2777, 20169, 'LINC00221', 'long intergenic non-protein coding RNA 221', 'non-coding RNA', 'ENSG00000270816'),
(2778, 13240, 'LINC00229', 'long intergenic non-protein coding RNA 229', 'non-coding RNA', 'ENSG00000234300'),
(2779, 38536, 'LINC00265-3P', 'long intergenic non-protein coding RNA 265-3, pseudogene', 'pseudogene', 'ENSG00000233944'),
(2780, 38595, 'LINC00273', 'long intergenic non-protein coding RNA 273', 'non-coding RNA', 'ENSG00000256642'),
(2781, 38663, 'LINC00276', 'long intergenic non-protein coding RNA 276', 'non-coding RNA', 'ENSG00000230448'),
(2782, 39078, 'LINC00293', 'long intergenic non-protein coding RNA 293', 'non-coding RNA', 'ENSG00000253314'),
(2783, 49257, 'LINC00298', 'long intergenic non-protein coding RNA 298', 'non-coding RNA', 'ENSG00000235665'),
(2784, 26713, 'LINC00304', 'long intergenic non-protein coding RNA 304', 'non-coding RNA', 'ENSG00000180422'),
(2785, 16023, 'LINC00308', 'long intergenic non-protein coding RNA 308', 'non-coding RNA', 'ENSG00000184856'),
(2786, 25279, 'LINC00309', 'long intergenic non-protein coding RNA 309', 'non-coding RNA', 'ENSG00000230923'),
(2787, 16416, 'LINC00313', 'long intergenic non-protein coding RNA 313', 'non-coding RNA', 'ENSG00000185186'),
(2788, 19690, 'LINC00320', 'long intergenic non-protein coding RNA 320', 'non-coding RNA', 'ENSG00000224924'),
(2789, 33698, 'LINC00322', 'long intergenic non-protein coding RNA 322', 'non-coding RNA', 'ENSG00000237864'),
(2790, 26628, 'LINC00324', 'long intergenic non-protein coding RNA 324', 'non-coding RNA', 'ENSG00000178977'),
(2791, 42047, 'LINC00330', 'long intergenic non-protein coding RNA 330', 'non-coding RNA', 'ENSG00000235097'),
(2792, 42048, 'LINC00331', 'long intergenic non-protein coding RNA 331', 'non-coding RNA', 'ENSG00000225427'),
(2793, 42049, 'LINC00332', 'long intergenic non-protein coding RNA 332', 'non-coding RNA', 'ENSG00000230710'),
(2794, 16425, 'LINC00334', 'long intergenic non-protein coding RNA 334', 'non-coding RNA', 'ENSG00000182586'),
(2795, 42658, 'LINC00348', 'long intergenic non-protein coding RNA 348', 'non-coding RNA', 'ENSG00000226846'),
(2796, 42670, 'LINC00352', 'long intergenic non-protein coding RNA 352', 'non-coding RNA', 'ENSG00000227893'),
(2797, 27061, 'LINC00355', 'long intergenic non-protein coding RNA 355', 'non-coding RNA', 'ENSG00000227674'),
(2798, 42688, 'LINC00366', 'long intergenic non-protein coding RNA 366', 'non-coding RNA', 'ENSG00000229437'),
(2799, 42692, 'LINC00370', 'long intergenic non-protein coding RNA 370', 'non-coding RNA', 'ENSG00000223617'),
(2800, 42705, 'LINC00379', 'long intergenic non-protein coding RNA 379', 'non-coding RNA', 'ENSG00000229557'),
(2801, 42710, 'LINC00383', 'long intergenic non-protein coding RNA 383', 'non-coding RNA', 'ENSG00000235221'),
(2802, 42713, 'LINC00385', 'long intergenic non-protein coding RNA 385', 'non-coding RNA', 'ENSG00000232643'),
(2803, 42719, 'LINC00391', 'long intergenic non-protein coding RNA 391', 'non-coding RNA', 'ENSG00000238230'),
(2804, 42740, 'LINC00408', 'long intergenic non-protein coding RNA 408', 'non-coding RNA', 'ENSG00000226250'),
(2805, 42748, 'LINC00415', 'long intergenic non-protein coding RNA 415', 'non-coding RNA', 'ENSG00000231983'),
(2806, 42762, 'LINC00427', 'long intergenic non-protein coding RNA 427', 'non-coding RNA', 'ENSG00000236463'),
(2807, 42766, 'LINC00431', 'long intergenic non-protein coding RNA 431', 'non-coding RNA', 'ENSG00000225760'),
(2808, 42768, 'LINC00433', 'long intergenic non-protein coding RNA 433', 'non-coding RNA', 'ENSG00000229443'),
(2809, 42777, 'LINC00440', 'long intergenic non-protein coding RNA 440', 'non-coding RNA', 'ENSG00000234660'),
(2810, 42783, 'LINC00446', 'long intergenic non-protein coding RNA 446', 'non-coding RNA', 'ENSG00000229249'),
(2811, 42802, 'LINC00454', 'long intergenic non-protein coding RNA 454', 'non-coding RNA', 'ENSG00000226921'),
(2812, 42807, 'LINC00458', 'long intergenic non-protein coding RNA 458', 'non-coding RNA', 'ENSG00000234787'),
(2813, 23367, 'LINC00474', 'long intergenic non-protein coding RNA 474', 'non-coding RNA', 'ENSG00000204148'),
(2814, 26816, 'LINC00482', 'long intergenic non-protein coding RNA 482', 'non-coding RNA', 'ENSG00000185168'),
(2815, 32675, 'LINC00488', 'long intergenic non-protein coding RNA 488', 'non-coding RNA', 'ENSG00000214381'),
(2816, 43428, 'LINC00491', 'long intergenic non-protein coding RNA 491', 'non-coding RNA', 'ENSG00000250682'),
(2817, 43555, 'LINC00504', 'long intergenic non-protein coding RNA 504', 'non-coding RNA', 'ENSG00000248360'),
(2818, 28626, 'LINC00518', 'long intergenic non-protein coding RNA 518', 'non-coding RNA', 'ENSG00000183674'),
(2819, 40290, 'LINC00525', 'long intergenic non-protein coding RNA 525', 'non-coding RNA', 'ENSG00000146666'),
(2820, 43643, 'LINC00534', 'long intergenic non-protein coding RNA 534', 'non-coding RNA', 'ENSG00000253394'),
(2821, 43672, 'LINC00539', 'long intergenic non-protein coding RNA 539', 'non-coding RNA', 'ENSG00000224429'),
(2822, 43680, 'LINC00545', 'long intergenic non-protein coding RNA 545', 'non-coding RNA', 'ENSG00000236094'),
(2823, 43699, 'LINC00555', 'long intergenic non-protein coding RNA 555', 'non-coding RNA', 'ENSG00000261057'),
(2824, 43703, 'LINC00559', 'long intergenic non-protein coding RNA 559', 'non-coding RNA', 'ENSG00000261446'),
(2825, 43707, 'LINC00563', 'long intergenic non-protein coding RNA 563', 'non-coding RNA', 'ENSG00000261097'),
(2826, 43708, 'LINC00564', 'long intergenic non-protein coding RNA 564', 'non-coding RNA', 'ENSG00000260094'),
(2827, 43722, 'LINC00572', 'long intergenic non-protein coding RNA 572', 'non-coding RNA', 'ENSG00000224405'),
(2828, 31372, 'LINC00587', 'long intergenic non-protein coding RNA 587', 'non-coding RNA', 'ENSG00000204250'),
(2829, 32299, 'LINC00589', 'long intergenic non-protein coding RNA 589', 'non-coding RNA', 'ENSG00000251191'),
(2830, 26343, 'LINC00615', 'long intergenic non-protein coding RNA 615', 'non-coding RNA', 'ENSG00000196243'),
(2831, 20110, 'LINC00618', 'long intergenic non-protein coding RNA 618', 'non-coding RNA', 'ENSG00000225163'),
(2832, 27865, 'LINC00632', 'long intergenic non-protein coding RNA 632', 'non-coding RNA', 'ENSG00000203930'),
(2833, 44296, 'LINC00643', 'long intergenic non-protein coding RNA 643', 'other', 'ENSG00000186369'),
(2834, 25003, 'LINC00652', 'long intergenic non-protein coding RNA 652', 'non-coding RNA', 'ENSG00000179935'),
(2835, 44316, 'LINC00659', 'long intergenic non-protein coding RNA 659', 'non-coding RNA', 'ENSG00000228705'),
(2836, 44319, 'LINC00664', 'long intergenic non-protein coding RNA 664', 'non-coding RNA', 'ENSG00000268658'),
(2837, 44328, 'LINC00668', 'long intergenic non-protein coding RNA 668', 'non-coding RNA', 'ENSG00000265933'),
(2838, 44466, 'LINC00682', 'long intergenic non-protein coding RNA 682', 'non-coding RNA', 'ENSG00000245870'),
(2839, 27217, 'LINC00689', 'long intergenic non-protein coding RNA 689', 'non-coding RNA', 'ENSG00000231419'),
(2840, 44690, 'LINC00706', 'long intergenic non-protein coding RNA 706', 'non-coding RNA', 'ENSG00000281186'),
(2841, 45031, 'LINC00844', 'long intergenic non-protein coding RNA 844', 'non-coding RNA', 'ENSG00000237949'),
(2842, 45050, 'LINC00847', 'long intergenic non-protein coding RNA 847', 'non-coding RNA', 'ENSG00000245060'),
(2843, 45092, 'LINC00850', 'long intergenic non-protein coding RNA 850', 'non-coding RNA', 'ENSG00000280752'),
(2844, 45111, 'LINC00856', 'long intergenic non-protein coding RNA 856', 'non-coding RNA', 'ENSG00000230417'),
(2845, 45114, 'LINC00857', 'long intergenic non-protein coding RNA 857', 'non-coding RNA', 'ENSG00000237523'),
(2846, 45133, 'LINC00861', 'long intergenic non-protein coding RNA 861', 'non-coding RNA', 'ENSG00000245164'),
(2847, 47038, 'LINC00871', 'long intergenic non-protein coding RNA 871', 'non-coding RNA', 'ENSG00000258700'),
(2848, 27706, 'LINC00877', 'long intergenic non-protein coding RNA 877', 'non-coding RNA', 'ENSG00000241163'),
(2849, 48572, 'LINC00886', 'long intergenic non-protein coding RNA 886', 'non-coding RNA', 'ENSG00000240875'),
(2850, 48574, 'LINC00887', 'long intergenic non-protein coding RNA 887', 'non-coding RNA', 'ENSG00000214145'),
(2851, 27121, 'LINC00906', 'long intergenic non-protein coding RNA 906', 'non-coding RNA', 'ENSG00000267339'),
(2852, 28088, 'LINC00923', 'long intergenic non-protein coding RNA 923', 'non-coding RNA', 'ENSG00000251209'),
(2853, 27081, 'LINC00924', 'long intergenic non-protein coding RNA 924', 'non-coding RNA', 'ENSG00000259134'),
(2854, 48615, 'LINC00929', 'long intergenic non-protein coding RNA 929', 'non-coding RNA', 'ENSG00000259150'),
(2855, 48625, 'LINC00933', 'long intergenic non-protein coding RNA 933', 'non-coding RNA', 'ENSG00000259728'),
(2856, 48636, 'LINC00942', 'long intergenic non-protein coding RNA 942', 'non-coding RNA', 'ENSG00000249628'),
(2857, 48662, 'LINC00951', 'long intergenic non-protein coding RNA 951', 'non-coding RNA', 'ENSG00000204092'),
(2858, 48668, 'LINC00954', 'long intergenic non-protein coding RNA 954', 'non-coding RNA', 'ENSG00000228784'),
(2859, 48727, 'LINC00968', 'long intergenic non-protein coding RNA 968', 'non-coding RNA', 'ENSG00000246430'),
(2860, 27800, 'LINC00996', 'long intergenic non-protein coding RNA 996', 'non-coding RNA', 'ENSG00000242258'),
(2861, 48957, 'LINC01003', 'long intergenic non-protein coding RNA 1003', 'non-coding RNA', 'ENSG00000261455'),
(2862, 48973, 'LINC01007', 'long intergenic non-protein coding RNA 1007', 'non-coding RNA', 'ENSG00000233123'),
(2863, 48987, 'LINC01013', 'long intergenic non-protein coding RNA 1013', 'non-coding RNA', 'ENSG00000228495'),
(2864, 49027, 'LINC01039', 'long intergenic non-protein coding RNA 1039', 'non-coding RNA', 'ENSG00000234168'),
(2865, 49028, 'LINC01040', 'long intergenic non-protein coding RNA 1040', 'non-coding RNA', 'ENSG00000226037'),
(2866, 49032, 'LINC01044', 'long intergenic non-protein coding RNA 1044', 'non-coding RNA', 'ENSG00000223626'),
(2867, 49043, 'LINC01049', 'long intergenic non-protein coding RNA 1049', 'non-coding RNA', 'ENSG00000234384'),
(2868, 49046, 'LINC01052', 'long intergenic non-protein coding RNA 1052', 'non-coding RNA', 'ENSG00000234767'),
(2869, 49047, 'LINC01053', 'long intergenic non-protein coding RNA 1053', 'non-coding RNA', 'ENSG00000238169'),
(2870, 49050, 'LINC01056', 'long intergenic non-protein coding RNA 1056', 'non-coding RNA', 'ENSG00000237119'),
(2871, 49104, 'LINC01066', 'long intergenic non-protein coding RNA 1066', 'non-coding RNA', 'ENSG00000230403'),
(2872, 49106, 'LINC01068', 'long intergenic non-protein coding RNA 1068', 'non-coding RNA', 'ENSG00000227676'),
(2873, 49118, 'LINC01075', 'long intergenic non-protein coding RNA 1075', 'non-coding RNA', 'ENSG00000230142'),
(2874, 49122, 'LINC01079', 'long intergenic non-protein coding RNA 1079', 'non-coding RNA', 'ENSG00000229609'),
(2875, 49123, 'LINC01080', 'long intergenic non-protein coding RNA 1080', 'non-coding RNA', 'ENSG00000281721'),
(2876, 49124, 'LINC01081', 'long intergenic non-protein coding RNA 1081', 'non-coding RNA', 'ENSG00000268754'),
(2877, 49219, 'LINC01094', 'long intergenic non-protein coding RNA 1094', 'non-coding RNA', 'ENSG00000251442'),
(2878, 49225, 'LINC01103', 'long intergenic non-protein coding RNA 1103', 'non-coding RNA', 'ENSG00000234781'),
(2879, 26769, 'LINC01106', 'long intergenic non-protein coding RNA 1106', 'non-coding RNA', 'ENSG00000175772'),
(2880, 49235, 'LINC01109', 'long intergenic non-protein coding RNA 1109', 'non-coding RNA', 'ENSG00000271167'),
(2881, 49262, 'LINC01119', 'long intergenic non-protein coding RNA 1119', 'non-coding RNA', 'ENSG00000239332'),
(2882, 49267, 'LINC01122', 'long intergenic non-protein coding RNA 1122', 'non-coding RNA', 'ENSG00000233723'),
(2883, 49462, 'LINC01145', 'long intergenic non-protein coding RNA 1145', 'non-coding RNA', 'ENSG00000272419'),
(2884, 39757, 'LINC01149', 'long intergenic non-protein coding RNA 1149', 'non-coding RNA', 'ENSG00000230174'),
(2885, 49534, 'LINC01165', 'long intergenic non-protein coding RNA 1165', 'non-coding RNA', 'ENSG00000229081'),
(2886, 49536, 'LINC01167', 'long intergenic non-protein coding RNA 1167', 'non-coding RNA', 'ENSG00000224758'),
(2887, 49541, 'LINC01169', 'long intergenic non-protein coding RNA 1169', 'non-coding RNA', 'ENSG00000259471'),
(2888, 49542, 'LINC01170', 'long intergenic non-protein coding RNA 1170', 'non-coding RNA', 'ENSG00000253807'),
(2889, 49598, 'LINC01198', 'long intergenic non-protein coding RNA 1198', 'non-coding RNA', 'ENSG00000231817'),
(2890, 49640, 'LINC01209', 'long intergenic non-protein coding RNA 1209', 'non-coding RNA', 'ENSG00000228308'),
(2891, 49648, 'LINC01213', 'long intergenic non-protein coding RNA 1213', 'non-coding RNA', 'ENSG00000244541'),
(2892, 41419, 'LINC01217', 'long intergenic non-protein coding RNA 1217', 'non-coding RNA', 'ENSG00000251219'),
(2893, 49672, 'LINC01222', 'long intergenic non-protein coding RNA 1222', 'non-coding RNA', 'ENSG00000233410'),
(2894, 49682, 'LINC01229', 'long intergenic non-protein coding RNA 1229', 'non-coding RNA', 'ENSG00000260876'),
(2895, 49757, 'LINC01234', 'long intergenic non-protein coding RNA 1234', 'non-coding RNA', 'ENSG00000249550'),
(2896, 49796, 'LINC01239', 'long intergenic non-protein coding RNA 1239', 'non-coding RNA', 'ENSG00000234840'),
(2897, 49841, 'LINC01247', 'long intergenic non-protein coding RNA 1247', 'non-coding RNA', 'ENSG00000227007'),
(2898, 49844, 'LINC01250', 'long intergenic non-protein coding RNA 1250', 'non-coding RNA', 'ENSG00000234423'),
(2899, 49895, 'LINC01256', 'long intergenic non-protein coding RNA 1256', 'non-coding RNA', 'ENSG00000251398'),
(2900, 26972, 'LINC01257', 'long intergenic non-protein coding RNA 1257', 'non-coding RNA', 'ENSG00000204603'),
(2901, 50275, 'LINC01262', 'long intergenic non-protein coding RNA 1262', 'non-coding RNA', 'ENSG00000250739'),
(2902, 50309, 'LINC01266', 'long intergenic non-protein coding RNA 1266', 'non-coding RNA', 'ENSG00000224957'),
(2903, 50325, 'LINC01269', 'long intergenic non-protein coding RNA 1269', 'non-coding RNA', 'ENSG00000258689'),
(2904, 50331, 'LINC01275', 'long intergenic non-protein coding RNA 1275', 'non-coding RNA', 'ENSG00000237595'),
(2905, 50342, 'LINC01284', 'long intergenic non-protein coding RNA 1284', 'non-coding RNA', 'ENSG00000230317'),
(2906, 27839, 'LINC01299', 'long intergenic non-protein coding RNA 1299', 'non-coding RNA', 'ENSG00000254081'),
(2907, 50464, 'LINC01301', 'long intergenic non-protein coding RNA 1301', 'non-coding RNA', 'ENSG00000251396'),
(2908, 50501, 'LINC01310', 'long intergenic non-protein coding RNA 1310', 'non-coding RNA', 'ENSG00000205632'),
(2909, 28525, 'LINC01312', 'long intergenic non-protein coding RNA 1312', 'non-coding RNA', 'ENSG00000223586'),
(2910, 50524, 'LINC01318', 'long intergenic non-protein coding RNA 1318', 'non-coding RNA', 'ENSG00000237790'),
(2911, 50539, 'LINC01333', 'long intergenic non-protein coding RNA 1333', 'non-coding RNA', 'ENSG00000249343'),
(2912, 50550, 'LINC01340', 'long intergenic non-protein coding RNA 1340', 'non-coding RNA', 'ENSG00000250331'),
(2913, 50599, 'LINC01364', 'long intergenic non-protein coding RNA 1364', 'non-coding RNA', 'ENSG00000227290'),
(2914, 50631, 'LINC01374', 'long intergenic non-protein coding RNA 1374', 'non-coding RNA', 'ENSG00000280560'),
(2915, 50659, 'LINC01386', 'long intergenic non-protein coding RNA 1386', 'non-coding RNA', 'ENSG00000251324'),
(2916, 50678, 'LINC01398', 'long intergenic non-protein coding RNA 1398', 'non-coding RNA', 'ENSG00000224863'),
(2917, 50688, 'LINC01405', 'long intergenic non-protein coding RNA 1405', 'non-coding RNA', 'ENSG00000185847'),
(2918, 50705, 'LINC01413', 'long intergenic non-protein coding RNA 1413', 'non-coding RNA', 'ENSG00000260172'),
(2919, 51645, 'LINC01416', 'long intergenic non-protein coding RNA 1416', 'non-coding RNA', 'ENSG00000260930'),
(2920, 26364, 'LINC01465', 'long intergenic non-protein coding RNA 1465', 'non-coding RNA', 'ENSG00000221949'),
(2921, 51105, 'LINC01470', 'long intergenic non-protein coding RNA 1470', 'non-coding RNA', 'ENSG00000249484'),
(2922, 51119, 'LINC01477', 'long intergenic non-protein coding RNA 1477', 'non-coding RNA', 'ENSG00000261715'),
(2923, 51149, 'LINC01492', 'long intergenic non-protein coding RNA 1492', 'non-coding RNA', 'ENSG00000225564'),
(2924, 51150, 'LINC01493', 'long intergenic non-protein coding RNA 1493', 'non-coding RNA', 'ENSG00000254562'),
(2925, 51165, 'LINC01499', 'long intergenic non-protein coding RNA 1499', 'non-coding RNA', 'ENSG00000255171'),
(2926, 51185, 'LINC01504', 'long intergenic non-protein coding RNA 1504', 'non-coding RNA', 'ENSG00000225434'),
(2927, 51190, 'LINC01508', 'long intergenic non-protein coding RNA 1508', 'non-coding RNA', 'ENSG00000231107'),
(2928, 51200, 'LINC01511', 'long intergenic non-protein coding RNA 1511', 'non-coding RNA', 'ENSG00000250584'),
(2929, 51217, 'LINC01519', 'long intergenic non-protein coding RNA 1519', 'non-coding RNA', 'ENSG00000237267'),
(2930, 26029, 'LINC01521', 'long intergenic non-protein coding RNA 1521', 'non-coding RNA', 'ENSG00000213888'),
(2931, 51270, 'LINC01531', 'long intergenic non-protein coding RNA 1531', 'non-coding RNA', 'ENSG00000205786'),
(2932, 51272, 'LINC01532', 'long intergenic non-protein coding RNA 1532', 'non-coding RNA', 'ENSG00000267014'),
(2933, 51306, 'LINC01538', 'long intergenic non-protein coding RNA 1538', 'non-coding RNA', 'ENSG00000266952'),
(2934, 15707, 'LINC01547', 'long intergenic non-protein coding RNA 1547', 'non-coding RNA', 'ENSG00000183250'),
(2935, 1296, 'LINC01548', 'long intergenic non-protein coding RNA 1548', 'non-coding RNA', 'ENSG00000229086'),
(2936, 26647, 'LINC01555', 'long intergenic non-protein coding RNA 1555', 'non-coding RNA', 'ENSG00000180869'),
(2937, 31365, 'LINC01561', 'long intergenic non-protein coding RNA 1561', 'non-coding RNA', 'ENSG00000177234'),
(2938, 51426, 'LINC01584', 'long intergenic non-protein coding RNA 1584', 'non-coding RNA', 'ENSG00000260477'),
(2939, 51432, 'LINC01585', 'long intergenic non-protein coding RNA 1585', 'non-coding RNA', 'ENSG00000245479'),
(2940, 51557, 'LINC01592', 'long intergenic non-protein coding RNA 1592', 'non-coding RNA', 'ENSG00000253658'),
(2941, 51660, 'LINC01607', 'long intergenic non-protein coding RNA 1607', 'non-coding RNA', 'ENSG00000272138'),
(2942, 51662, 'LINC01608', 'long intergenic non-protein coding RNA 1608', 'non-coding RNA', 'ENSG00000253877'),
(2943, 51676, 'LINC01610', 'long intergenic non-protein coding RNA 1610', 'non-coding RNA', 'ENSG00000237643'),
(2944, 51837, 'LINC01612', 'long intergenic non-protein coding RNA 1612', 'non-coding RNA', 'ENSG00000250266'),
(2945, 51898, 'LINC01615', 'long intergenic non-protein coding RNA 1615', 'non-coding RNA', 'ENSG00000223485'),
(2946, 27195, 'LINC01618', 'long intergenic non-protein coding RNA 1618', 'non-coding RNA', 'ENSG00000250302'),
(2947, 16195, 'LINC01620', 'long intergenic non-protein coding RNA 1620', 'non-coding RNA', 'ENSG00000168746'),
(2948, 52258, 'LINC01627', 'long intergenic non-protein coding RNA 1627', 'non-coding RNA', 'ENSG00000224648'),
(2949, 52419, 'LINC01632', 'long intergenic non-protein coding RNA 1632', 'non-coding RNA', 'ENSG00000277199'),
(2950, 52421, 'LINC01634', 'long intergenic non-protein coding RNA 1634', 'non-coding RNA', 'ENSG00000235295'),
(2951, 52424, 'LINC01637', 'long intergenic non-protein coding RNA 1637', 'non-coding RNA', 'ENSG00000237476'),
(2952, 52433, 'LINC01646', 'long intergenic non-protein coding RNA 1646', 'non-coding RNA', 'ENSG00000232596'),
(2953, 52435, 'LINC01648', 'long intergenic non-protein coding RNA 1648', 'non-coding RNA', 'ENSG00000233399'),
(2954, 52458, 'LINC01670', 'long intergenic non-protein coding RNA 1670', 'non-coding RNA', 'ENSG00000279094'),
(2955, 52459, 'LINC01671', 'long intergenic non-protein coding RNA 1671', 'non-coding RNA', 'ENSG00000225431'),
(2956, 52461, 'LINC01673', 'long intergenic non-protein coding RNA 1673', 'non-coding RNA', 'ENSG00000234052'),
(2957, 52463, 'LINC01675', 'long intergenic non-protein coding RNA 1675', 'non-coding RNA', 'ENSG00000234142'),
(2958, 52464, 'LINC01676', 'long intergenic non-protein coding RNA 1676', 'non-coding RNA', 'ENSG00000230768'),
(2959, 52481, 'LINC01694', 'long intergenic non-protein coding RNA 1694', 'non-coding RNA', 'ENSG00000233922'),
(2960, 52483, 'LINC01695', 'long intergenic non-protein coding RNA 1695', 'non-coding RNA', 'ENSG00000236532'),
(2961, 52495, 'LINC01707', 'long intergenic non-protein coding RNA 1707', 'non-coding RNA', 'ENSG00000223883'),
(2962, 52496, 'LINC01708', 'long intergenic non-protein coding RNA 1708', 'non-coding RNA', 'ENSG00000224445'),
(2963, 52501, 'LINC01714', 'long intergenic non-protein coding RNA 1714', 'non-coding RNA', 'ENSG00000227634'),
(2964, 52507, 'LINC01720', 'long intergenic non-protein coding RNA 1720', 'non-coding RNA', 'ENSG00000231175'),
(2965, 52512, 'LINC01724', 'long intergenic non-protein coding RNA 1724', 'non-coding RNA', 'ENSG00000227421'),
(2966, 52514, 'LINC01726', 'long intergenic non-protein coding RNA 1726', 'non-coding RNA', 'ENSG00000280350'),
(2967, 52517, 'LINC01729', 'long intergenic non-protein coding RNA 1729', 'non-coding RNA', 'ENSG00000225640'),
(2968, 52523, 'LINC01735', 'long intergenic non-protein coding RNA 1735', 'non-coding RNA', 'ENSG00000261453'),
(2969, 52525, 'LINC01737', 'long intergenic non-protein coding RNA 1737', 'non-coding RNA', 'ENSG00000232964'),
(2970, 52526, 'LINC01738', 'long intergenic non-protein coding RNA 1738', 'non-coding RNA', 'ENSG00000227947'),
(2971, 52531, 'LINC01743', 'long intergenic non-protein coding RNA 1743', 'non-coding RNA', 'ENSG00000242042'),
(2972, 52534, 'LINC01746', 'long intergenic non-protein coding RNA 1746', 'non-coding RNA', 'ENSG00000274469'),
(2973, 52536, 'LINC01747', 'long intergenic non-protein coding RNA 1747', 'non-coding RNA', 'ENSG00000230400'),
(2974, 52545, 'LINC01756', 'long intergenic non-protein coding RNA 1756', 'non-coding RNA', 'ENSG00000230523'),
(2975, 52556, 'LINC01766', 'long intergenic non-protein coding RNA 1766', 'non-coding RNA', 'ENSG00000224910'),
(2976, 52557, 'LINC01767', 'long intergenic non-protein coding RNA 1767', 'non-coding RNA', 'ENSG00000223956'),
(2977, 52562, 'LINC01772', 'long intergenic non-protein coding RNA 1772', 'non-coding RNA', 'ENSG00000226029'),
(2978, 52572, 'LINC01782', 'long intergenic non-protein coding RNA 1782', 'non-coding RNA', 'ENSG00000267204'),
(2979, 52584, 'LINC01794', 'long intergenic non-protein coding RNA 1794', 'non-coding RNA', 'ENSG00000233128'),
(2980, 52587, 'LINC01797', 'long intergenic non-protein coding RNA 1797', 'non-coding RNA', 'ENSG00000237179'),
(2981, 52597, 'LINC01805', 'long intergenic non-protein coding RNA 1805', 'non-coding RNA', 'ENSG00000223863'),
(2982, 52622, 'LINC01817', 'long intergenic non-protein coding RNA 1817', 'non-coding RNA', 'ENSG00000231420'),
(2983, 52632, 'LINC01826', 'long intergenic non-protein coding RNA 1826', 'non-coding RNA', 'ENSG00000232740'),
(2984, 41330, 'LINC01839', 'long intergenic non-protein coding RNA 1839', 'non-coding RNA', 'ENSG00000227509'),
(2985, 52655, 'LINC01841', 'long intergenic non-protein coding RNA 1841', 'non-coding RNA', 'ENSG00000266913'),
(2986, 27747, 'LINC01845', 'long intergenic non-protein coding RNA 1845', 'non-coding RNA', 'ENSG00000253298'),
(2987, 52675, 'LINC01855', 'long intergenic non-protein coding RNA 1855', 'non-coding RNA', 'ENSG00000267517'),
(2988, 52677, 'LINC01859', 'long intergenic non-protein coding RNA 1859', 'non-coding RNA', 'ENSG00000261558'),
(2989, 52692, 'LINC01873', 'long intergenic non-protein coding RNA 1873', 'non-coding RNA', 'ENSG00000232164'),
(2990, 52693, 'LINC01874', 'long intergenic non-protein coding RNA 1874', 'non-coding RNA', 'ENSG00000223985'),
(2991, 52695, 'LINC01876', 'long intergenic non-protein coding RNA 1876', 'non-coding RNA', 'ENSG00000226383'),
(2992, 52699, 'LINC01880', 'long intergenic non-protein coding RNA 1880', 'non-coding RNA', 'ENSG00000232002'),
(2993, 52708, 'LINC01889', 'long intergenic non-protein coding RNA 1889', 'non-coding RNA', 'ENSG00000235491'),
(2994, 52715, 'LINC01896', 'long intergenic non-protein coding RNA 1896', 'non-coding RNA', 'ENSG00000263146'),
(2995, 52728, 'LINC01909', 'long intergenic non-protein coding RNA 1909', 'non-coding RNA', 'ENSG00000266258'),
(2996, 52734, 'LINC01915', 'long intergenic non-protein coding RNA 1915', 'non-coding RNA', 'ENSG00000265485'),
(2997, 52735, 'LINC01916', 'long intergenic non-protein coding RNA 1916', 'non-coding RNA', 'ENSG00000264232'),
(2998, 52759, 'LINC01936', 'long intergenic non-protein coding RNA 1936', 'non-coding RNA', 'ENSG00000235997'),
(2999, 52761, 'LINC01938', 'long intergenic non-protein coding RNA 1938', 'non-coding RNA', 'ENSG00000254066'),
(3000, 52766, 'LINC01942', 'long intergenic non-protein coding RNA 1942', 'non-coding RNA', 'ENSG00000253428'),
(3001, 52768, 'LINC01944', 'long intergenic non-protein coding RNA 1944', 'non-coding RNA', 'ENSG00000254299'),
(3002, 52776, 'LINC01953', 'long intergenic non-protein coding RNA 1953', 'non-coding RNA', 'ENSG00000236193'),
(3003, 52779, 'LINC01954', 'long intergenic non-protein coding RNA 1954', 'non-coding RNA', 'ENSG00000271952'),
(3004, 52784, 'LINC01958', 'long intergenic non-protein coding RNA 1958', 'non-coding RNA', 'ENSG00000283436'),
(3005, 52809, 'LINC01981', 'long intergenic non-protein coding RNA 1981', 'non-coding RNA', 'ENSG00000229243'),
(3006, 52819, 'LINC01987', 'long intergenic non-protein coding RNA 1987', 'non-coding RNA', 'ENSG00000267790'),
(3007, 52820, 'LINC01988', 'long intergenic non-protein coding RNA 1988', 'non-coding RNA', 'ENSG00000283036'),
(3008, 52822, 'LINC01990', 'long intergenic non-protein coding RNA 1990', 'non-coding RNA', 'ENSG00000273125'),
(3009, 52828, 'LINC01995', 'long intergenic non-protein coding RNA 1995', 'non-coding RNA', 'ENSG00000244247'),
(3010, 52835, 'LINC02000', 'long intergenic non-protein coding RNA 2000', 'non-coding RNA', 'ENSG00000243832');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(3011, 27191, 'LINC02011', 'long intergenic non-protein coding RNA 2011', 'non-coding RNA', 'ENSG00000260902'),
(3012, 52848, 'LINC02013', 'long intergenic non-protein coding RNA 2013', 'non-coding RNA', 'ENSG00000228730'),
(3013, 52850, 'LINC02015', 'long intergenic non-protein coding RNA 2015', 'non-coding RNA', 'ENSG00000231574'),
(3014, 52855, 'LINC02020', 'long intergenic non-protein coding RNA 2020', 'non-coding RNA', 'ENSG00000234548'),
(3015, 52857, 'LINC02022', 'long intergenic non-protein coding RNA 2022', 'non-coding RNA', 'ENSG00000232746'),
(3016, 52859, 'LINC02024', 'long intergenic non-protein coding RNA 2024', 'non-coding RNA', 'ENSG00000241213'),
(3017, 52860, 'LINC02025', 'long intergenic non-protein coding RNA 2025', 'non-coding RNA', 'ENSG00000242339'),
(3018, 52862, 'LINC02027', 'long intergenic non-protein coding RNA 2027', 'non-coding RNA', 'ENSG00000243694'),
(3019, 52898, 'LINC02056', 'long intergenic non-protein coding RNA 2056', 'non-coding RNA', 'ENSG00000248371'),
(3020, 52914, 'LINC02068', 'long intergenic non-protein coding RNA 2068', 'non-coding RNA', 'ENSG00000223387'),
(3021, 52915, 'LINC02069', 'long intergenic non-protein coding RNA 2069', 'non-coding RNA', 'ENSG00000229433'),
(3022, 52928, 'LINC02080', 'long intergenic non-protein coding RNA 2080', 'non-coding RNA', 'ENSG00000267065'),
(3023, 27190, 'LINC02085', 'long intergenic non-protein coding RNA 2085', 'non-coding RNA', 'ENSG00000214407'),
(3024, 52939, 'LINC02088', 'long intergenic non-protein coding RNA 2088', 'non-coding RNA', 'ENSG00000227685'),
(3025, 52948, 'LINC02097', 'long intergenic non-protein coding RNA 2097', 'non-coding RNA', 'ENSG00000226101'),
(3026, 52959, 'LINC02104', 'long intergenic non-protein coding RNA 2104', 'non-coding RNA', 'ENSG00000271334'),
(3027, 52963, 'LINC02108', 'long intergenic non-protein coding RNA 2108', 'non-coding RNA', 'ENSG00000250127'),
(3028, 27756, 'LINC02112', 'long intergenic non-protein coding RNA 2112', 'non-coding RNA', 'ENSG00000249781'),
(3029, 52977, 'LINC02121', 'long intergenic non-protein coding RNA 2121', 'non-coding RNA', 'ENSG00000250529'),
(3030, 52982, 'LINC02125', 'long intergenic non-protein coding RNA 2125', 'non-coding RNA', 'ENSG00000250514'),
(3031, 52993, 'LINC02133', 'long intergenic non-protein coding RNA 2133', 'non-coding RNA', 'ENSG00000261231'),
(3032, 53015, 'LINC02154', 'long intergenic non-protein coding RNA 2154', 'non-coding RNA', 'ENSG00000235385'),
(3033, 27749, 'LINC02159', 'long intergenic non-protein coding RNA 2159', 'non-coding RNA', 'ENSG00000253417'),
(3034, 53027, 'LINC02166', 'long intergenic non-protein coding RNA 2166', 'non-coding RNA', 'ENSG00000260259'),
(3035, 53030, 'LINC02168', 'long intergenic non-protein coding RNA 2168', 'non-coding RNA', 'ENSG00000261703'),
(3036, 53034, 'LINC02172', 'long intergenic non-protein coding RNA 2172', 'non-coding RNA', 'ENSG00000251632'),
(3037, 53035, 'LINC02173', 'long intergenic non-protein coding RNA 2173', 'non-coding RNA', 'ENSG00000249613'),
(3038, 53051, 'LINC02189', 'long intergenic non-protein coding RNA 2189', 'non-coding RNA', 'ENSG00000260026'),
(3039, 53053, 'LINC02191', 'long intergenic non-protein coding RNA 2191', 'non-coding RNA', 'ENSG00000261636'),
(3040, 53063, 'LINC02197', 'long intergenic non-protein coding RNA 2197', 'non-coding RNA', 'ENSG00000250387'),
(3041, 53068, 'LINC02202', 'long intergenic non-protein coding RNA 2202', 'non-coding RNA', 'ENSG00000245812'),
(3042, 53069, 'LINC02203', 'long intergenic non-protein coding RNA 2203', 'non-coding RNA', 'ENSG00000280709'),
(3043, 27827, 'LINC02209', 'long intergenic non-protein coding RNA 2209', 'non-coding RNA', 'ENSG00000253279'),
(3044, 53079, 'LINC02212', 'long intergenic non-protein coding RNA 2212', 'non-coding RNA', 'ENSG00000249396'),
(3045, 53082, 'LINC02215', 'long intergenic non-protein coding RNA 2215', 'non-coding RNA', 'ENSG00000249128'),
(3046, 53093, 'LINC02224', 'long intergenic non-protein coding RNA 2224', 'non-coding RNA', 'ENSG00000249203'),
(3047, 53099, 'LINC02230', 'long intergenic non-protein coding RNA 2230', 'non-coding RNA', 'ENSG00000251543'),
(3048, 53108, 'LINC02237', 'long intergenic non-protein coding RNA 2237', 'non-coding RNA', 'ENSG00000253434'),
(3049, 53929, 'LINC02244', 'long intergenic non-protein coding RNA 2244', 'non-coding RNA', 'ENSG00000259590'),
(3050, 53149, 'LINC02251', 'long intergenic non-protein coding RNA 2251', 'non-coding RNA', 'ENSG00000258483'),
(3051, 27956, 'LINC02260', 'long intergenic non-protein coding RNA 2260', 'non-coding RNA', 'ENSG00000250456'),
(3052, 53180, 'LINC02266', 'long intergenic non-protein coding RNA 2266', 'non-coding RNA', 'ENSG00000272727'),
(3053, 53183, 'LINC02268', 'long intergenic non-protein coding RNA 2268', 'non-coding RNA', 'ENSG00000248174'),
(3054, 53194, 'LINC02278', 'long intergenic non-protein coding RNA 2278', 'non-coding RNA', 'ENSG00000251635'),
(3055, 53197, 'LINC02281', 'long intergenic non-protein coding RNA 2281', 'non-coding RNA', 'ENSG00000257748'),
(3056, 53202, 'LINC02285', 'long intergenic non-protein coding RNA 2285', 'non-coding RNA', 'ENSG00000259004'),
(3057, 53205, 'LINC02289', 'long intergenic non-protein coding RNA 2289', 'non-coding RNA', 'ENSG00000258819'),
(3058, 53206, 'LINC02290', 'long intergenic non-protein coding RNA 2290', 'non-coding RNA', 'ENSG00000258502'),
(3059, 53214, 'LINC02297', 'long intergenic non-protein coding RNA 2297', 'non-coding RNA', 'ENSG00000257504'),
(3060, 53220, 'LINC02301', 'long intergenic non-protein coding RNA 2301', 'non-coding RNA', 'ENSG00000258743'),
(3061, 53223, 'LINC02304', 'long intergenic non-protein coding RNA 2304', 'non-coding RNA', 'ENSG00000259110'),
(3062, 53230, 'LINC02311', 'long intergenic non-protein coding RNA 2311', 'non-coding RNA', 'ENSG00000258718'),
(3063, 53231, 'LINC02312', 'long intergenic non-protein coding RNA 2312', 'non-coding RNA', 'ENSG00000258869'),
(3064, 53232, 'LINC02313', 'long intergenic non-protein coding RNA 2313', 'non-coding RNA', 'ENSG00000258474'),
(3065, 53238, 'LINC02319', 'long intergenic non-protein coding RNA 2319', 'non-coding RNA', 'ENSG00000258694'),
(3066, 53239, 'LINC02320', 'long intergenic non-protein coding RNA 2320', 'non-coding RNA', 'ENSG00000258404'),
(3067, 53267, 'LINC02345', 'long intergenic non-protein coding RNA 2345', 'non-coding RNA', 'ENSG00000259225'),
(3068, 53275, 'LINC02353', 'long intergenic non-protein coding RNA 2353', 'non-coding RNA', 'ENSG00000251329'),
(3069, 53276, 'LINC02354', 'long intergenic non-protein coding RNA 2354', 'non-coding RNA', 'ENSG00000257488'),
(3070, 53277, 'LINC02355', 'long intergenic non-protein coding RNA 2355', 'non-coding RNA', 'ENSG00000248210'),
(3071, 53279, 'LINC02357', 'long intergenic non-protein coding RNA 2357', 'non-coding RNA', 'ENSG00000283314'),
(3072, 53280, 'LINC02359', 'long intergenic non-protein coding RNA 2359', 'non-coding RNA', 'ENSG00000284848'),
(3073, 53283, 'LINC02361', 'long intergenic non-protein coding RNA 2361', 'non-coding RNA', 'ENSG00000256576'),
(3074, 53294, 'LINC02372', 'long intergenic non-protein coding RNA 2372', 'non-coding RNA', 'ENSG00000249873'),
(3075, 53301, 'LINC02378', 'long intergenic non-protein coding RNA 2378', 'non-coding RNA', 'ENSG00000256994'),
(3076, 53303, 'LINC02380', 'long intergenic non-protein coding RNA 2380', 'non-coding RNA', 'ENSG00000248505'),
(3077, 53313, 'LINC02387', 'long intergenic non-protein coding RNA 2387', 'non-coding RNA', 'ENSG00000256232'),
(3078, 53317, 'LINC02390', 'long intergenic non-protein coding RNA 2390', 'non-coding RNA', 'ENSG00000256582'),
(3079, 53323, 'LINC02397', 'long intergenic non-protein coding RNA 2397', 'non-coding RNA', 'ENSG00000205056'),
(3080, 53329, 'LINC02402', 'long intergenic non-protein coding RNA 2402', 'non-coding RNA', 'ENSG00000257510'),
(3081, 53350, 'LINC02420', 'long intergenic non-protein coding RNA 2420', 'non-coding RNA', 'ENSG00000256172'),
(3082, 53351, 'LINC02421', 'long intergenic non-protein coding RNA 2421', 'non-coding RNA', 'ENSG00000255970'),
(3083, 53356, 'LINC02425', 'long intergenic non-protein coding RNA 2425', 'non-coding RNA', 'ENSG00000256259'),
(3084, 53357, 'LINC02426', 'long intergenic non-protein coding RNA 2426', 'non-coding RNA', 'ENSG00000257747'),
(3085, 53369, 'LINC02437', 'long intergenic non-protein coding RNA 2437', 'non-coding RNA', 'ENSG00000248517'),
(3086, 53371, 'LINC02439', 'long intergenic non-protein coding RNA 2439', 'non-coding RNA', 'ENSG00000255814'),
(3087, 53373, 'LINC02441', 'long intergenic non-protein coding RNA 2441', 'non-coding RNA', 'ENSG00000256643'),
(3088, 53376, 'LINC02444', 'long intergenic non-protein coding RNA 2444', 'non-coding RNA', 'ENSG00000258123'),
(3089, 53382, 'LINC02450', 'long intergenic non-protein coding RNA 2450', 'non-coding RNA', 'ENSG00000257114'),
(3090, 53388, 'LINC02455', 'long intergenic non-protein coding RNA 2455', 'non-coding RNA', 'ENSG00000256672'),
(3091, 53389, 'LINC02456', 'long intergenic non-protein coding RNA 2456', 'non-coding RNA', 'ENSG00000283052'),
(3092, 53398, 'LINC02461', 'long intergenic non-protein coding RNA 2461', 'non-coding RNA', 'ENSG00000258331'),
(3093, 53400, 'LINC02463', 'long intergenic non-protein coding RNA 2463', 'non-coding RNA', 'ENSG00000257683'),
(3094, 53401, 'LINC02464', 'long intergenic non-protein coding RNA 2464', 'non-coding RNA', 'ENSG00000257677'),
(3095, 53406, 'LINC02468', 'long intergenic non-protein coding RNA 2468', 'non-coding RNA', 'ENSG00000256499'),
(3096, 53408, 'LINC02469', 'long intergenic non-protein coding RNA 2469', 'non-coding RNA', 'ENSG00000248408'),
(3097, 53417, 'LINC02474', 'long intergenic non-protein coding RNA 2474', 'non-coding RNA', 'ENSG00000228437'),
(3098, 53418, 'LINC02475', 'long intergenic non-protein coding RNA 2475', 'non-coding RNA', 'ENSG00000251350'),
(3099, 53425, 'LINC02477', 'long intergenic non-protein coding RNA 2477', 'non-coding RNA', 'ENSG00000249425'),
(3100, 53446, 'LINC02478', 'long intergenic non-protein coding RNA 2478', 'non-coding RNA', 'ENSG00000285373'),
(3101, 53453, 'LINC02479', 'long intergenic non-protein coding RNA 2479', 'non-coding RNA', 'ENSG00000251326'),
(3102, 53458, 'LINC02482', 'long intergenic non-protein coding RNA 2482', 'non-coding RNA', 'ENSG00000251580'),
(3103, 53477, 'LINC02493', 'long intergenic non-protein coding RNA 2493', 'non-coding RNA', 'ENSG00000250819'),
(3104, 53482, 'LINC02497', 'long intergenic non-protein coding RNA 2497', 'non-coding RNA', 'ENSG00000251182'),
(3105, 53499, 'LINC02510', 'long intergenic non-protein coding RNA 2510', 'non-coding RNA', 'ENSG00000250341'),
(3106, 53504, 'LINC02515', 'long intergenic non-protein coding RNA 2515', 'non-coding RNA', 'ENSG00000250620'),
(3107, 53509, 'LINC02518', 'long intergenic non-protein coding RNA 2518', 'non-coding RNA', 'ENSG00000232316'),
(3108, 53542, 'LINC02523', 'long intergenic non-protein coding RNA 2523', 'non-coding RNA', 'ENSG00000224506'),
(3109, 53553, 'LINC02527', 'long intergenic non-protein coding RNA 2527', 'non-coding RNA', 'ENSG00000227012'),
(3110, 53557, 'LINC02531', 'long intergenic non-protein coding RNA 2531', 'non-coding RNA', 'ENSG00000220908'),
(3111, 53587, 'LINC02552', 'long intergenic non-protein coding RNA 2552', 'non-coding RNA', 'ENSG00000256422'),
(3112, 53593, 'LINC02555', 'long intergenic non-protein coding RNA 2555', 'non-coding RNA', 'ENSG00000260943'),
(3113, 51430, 'LINC02568', 'long intergenic non-protein coding RNA 2568', 'non-coding RNA', 'ENSG00000259459'),
(3114, 39760, 'LINC02569', 'long intergenic non-protein coding RNA 2569', 'non-coding RNA', 'ENSG00000235781'),
(3115, 39766, 'LINC02570', 'long intergenic non-protein coding RNA 2570', 'non-coding RNA', 'ENSG00000237923'),
(3116, 53634, 'LINC02572', 'long intergenic non-protein coding RNA 2572', 'non-coding RNA', 'ENSG00000229536'),
(3117, 53746, 'LINC02574', 'long intergenic non-protein coding RNA 2574', 'non-coding RNA', 'ENSG00000233975'),
(3118, 53750, 'LINC02578', 'long intergenic non-protein coding RNA 2578', 'non-coding RNA', 'ENSG00000235201'),
(3119, 27942, 'LINC02579', 'long intergenic non-protein coding RNA 2579', 'non-coding RNA', 'ENSG00000233694'),
(3120, 53901, 'LINC02591', 'long intergenic non-protein coding RNA 2591', 'non-coding RNA', 'ENSG00000263590'),
(3121, 53946, 'LINC02595', 'long intergenic non-protein coding RNA 2595', 'non-coding RNA', 'ENSG00000231566'),
(3122, 53966, 'LINC02601', 'long intergenic non-protein coding RNA 2601', 'non-coding RNA', 'ENSG00000223714'),
(3123, 54047, 'LINC02606', 'long intergenic non-protein coding RNA 2606', 'non-coding RNA', 'ENSG00000284693'),
(3124, 54049, 'LINC02607', 'long intergenic non-protein coding RNA 2607', 'non-coding RNA', 'ENSG00000228971'),
(3125, 54067, 'LINC02612', 'long intergenic non-protein coding RNA 2612', 'non-coding RNA', 'ENSG00000224048'),
(3126, 54072, 'LINC02614', 'long intergenic non-protein coding RNA 2614', 'non-coding RNA', 'ENSG00000241288'),
(3127, 54105, 'LINC02626', 'long intergenic non-protein coding RNA 2626', 'non-coding RNA', 'ENSG00000236799'),
(3128, 54110, 'LINC02630', 'long intergenic non-protein coding RNA 2630', 'non-coding RNA', 'ENSG00000227313'),
(3129, 54114, 'LINC02632', 'long intergenic non-protein coding RNA 2632', 'non-coding RNA', 'ENSG00000234864'),
(3130, 54138, 'LINC02653', 'long intergenic non-protein coding RNA 2653', 'non-coding RNA', 'ENSG00000236373'),
(3131, 54145, 'LINC02659', 'long intergenic non-protein coding RNA 2659', 'non-coding RNA', 'ENSG00000236769'),
(3132, 54149, 'LINC02663', 'long intergenic non-protein coding RNA 2663', 'non-coding RNA', 'ENSG00000228636'),
(3133, 54159, 'LINC02672', 'long intergenic non-protein coding RNA 2672', 'non-coding RNA', 'ENSG00000227121'),
(3134, 54167, 'LINC02673', 'long intergenic non-protein coding RNA 2673', 'non-coding RNA', 'ENSG00000260151'),
(3135, 54170, 'LINC02676', 'long intergenic non-protein coding RNA 2676', 'non-coding RNA', 'ENSG00000234752'),
(3136, 54172, 'LINC02678', 'long intergenic non-protein coding RNA 2678', 'non-coding RNA', 'ENSG00000231483'),
(3137, 54174, 'LINC02680', 'long intergenic non-protein coding RNA 2680', 'non-coding RNA', 'ENSG00000285737'),
(3138, 54177, 'LINC02682', 'long intergenic non-protein coding RNA 2682', 'non-coding RNA', 'ENSG00000254661'),
(3139, 54180, 'LINC02684', 'long intergenic non-protein coding RNA 2684', 'non-coding RNA', 'ENSG00000255512'),
(3140, 54187, 'LINC02687', 'long intergenic non-protein coding RNA 2687', 'non-coding RNA', 'ENSG00000255267'),
(3141, 54184, 'LINC02688', 'long intergenic non-protein coding RNA 2688', 'non-coding RNA', 'ENSG00000254872'),
(3142, 54192, 'LINC02689', 'long intergenic non-protein coding RNA 2689', 'non-coding RNA', 'ENSG00000285985'),
(3143, 33796, 'LINC02694', 'long intergenic non-protein coding RNA 2694', 'non-coding RNA', 'ENSG00000175779'),
(3144, 54212, 'LINC02698', 'long intergenic non-protein coding RNA 2698', 'non-coding RNA', 'ENSG00000256717'),
(3145, 54213, 'LINC02699', 'long intergenic non-protein coding RNA 2699', 'non-coding RNA', 'ENSG00000254456'),
(3146, 54222, 'LINC02705', 'long intergenic non-protein coding RNA 2705', 'non-coding RNA', 'ENSG00000254952'),
(3147, 54228, 'LINC02711', 'long intergenic non-protein coding RNA 2711', 'non-coding RNA', 'ENSG00000255183'),
(3148, 54229, 'LINC02712', 'long intergenic non-protein coding RNA 2712', 'non-coding RNA', 'ENSG00000273409'),
(3149, 54231, 'LINC02714', 'long intergenic non-protein coding RNA 2714', 'non-coding RNA', 'ENSG00000251226'),
(3150, 54232, 'LINC02715', 'long intergenic non-protein coding RNA 2715', 'non-coding RNA', 'ENSG00000254659'),
(3151, 54242, 'LINC02725', 'long intergenic non-protein coding RNA 2725', 'non-coding RNA', 'ENSG00000273415'),
(3152, 54246, 'LINC02729', 'long intergenic non-protein coding RNA 2729', 'non-coding RNA', 'ENSG00000255335'),
(3153, 54248, 'LINC02731', 'long intergenic non-protein coding RNA 2731', 'non-coding RNA', 'ENSG00000204241'),
(3154, 54250, 'LINC02733', 'long intergenic non-protein coding RNA 2733', 'non-coding RNA', 'ENSG00000255553'),
(3155, 54257, 'LINC02740', 'long intergenic non-protein coding RNA 2740', 'non-coding RNA', 'ENSG00000255109'),
(3156, 54271, 'LINC02751', 'long intergenic non-protein coding RNA 2751', 'non-coding RNA', 'ENSG00000254946'),
(3157, 54275, 'LINC02755', 'long intergenic non-protein coding RNA 2755', 'non-coding RNA', 'ENSG00000254530'),
(3158, 54278, 'LINC02758', 'long intergenic non-protein coding RNA 2758', 'non-coding RNA', 'ENSG00000248990'),
(3159, 54280, 'LINC02760', 'long intergenic non-protein coding RNA 2760', 'non-coding RNA', 'ENSG00000254516'),
(3160, 54281, 'LINC02761', 'long intergenic non-protein coding RNA 2761', 'non-coding RNA', 'ENSG00000255362'),
(3161, 54286, 'LINC02766', 'long intergenic non-protein coding RNA 2766', 'non-coding RNA', 'ENSG00000229484'),
(3162, 54287, 'LINC02767', 'long intergenic non-protein coding RNA 2767', 'non-coding RNA', 'ENSG00000284237'),
(3163, 54293, 'LINC02773', 'long intergenic non-protein coding RNA 2773', 'non-coding RNA', 'ENSG00000237980'),
(3164, 54302, 'LINC02782', 'long intergenic non-protein coding RNA 2782', 'non-coding RNA', 'ENSG00000231510'),
(3165, 54303, 'LINC02783', 'long intergenic non-protein coding RNA 2783', 'non-coding RNA', 'ENSG00000204362'),
(3166, 54316, 'LINC02792', 'long intergenic non-protein coding RNA 2792', 'non-coding RNA', 'ENSG00000285462'),
(3167, 54317, 'LINC02793', 'long intergenic non-protein coding RNA 2793', 'non-coding RNA', 'ENSG00000285823'),
(3168, 27642, 'LINC02800', 'long intergenic non-protein coding RNA 2800', 'non-coding RNA', 'ENSG00000230023'),
(3169, 54342, 'LINC02810', 'long intergenic non-protein coding RNA 2810', 'non-coding RNA', 'ENSG00000236648'),
(3170, 54343, 'LINC02811', 'long intergenic non-protein coding RNA 2811', 'non-coding RNA', 'ENSG00000284678'),
(3171, 54346, 'LINC02814', 'long intergenic non-protein coding RNA 2814', 'non-coding RNA', 'ENSG00000236975'),
(3172, 54348, 'LINC02816', 'long intergenic non-protein coding RNA 2816', 'non-coding RNA', 'ENSG00000225857'),
(3173, 54349, 'LINC02818', 'long intergenic non-protein coding RNA 2818', 'non-coding RNA', 'ENSG00000231966'),
(3174, 54353, 'LINC02822', 'long intergenic non-protein coding RNA 2822', 'non-coding RNA', 'ENSG00000286021'),
(3175, 54358, 'LINC02827', 'long intergenic non-protein coding RNA 2827', 'non-coding RNA', 'ENSG00000236908'),
(3176, 54362, 'LINC02829', 'long intergenic non-protein coding RNA 2829', 'non-coding RNA', 'ENSG00000229274'),
(3177, 54365, 'LINC02831', 'long intergenic non-protein coding RNA 2831', 'non-coding RNA', 'ENSG00000224173'),
(3178, 54373, 'LINC02839', 'long intergenic non-protein coding RNA 2839', 'non-coding RNA', 'ENSG00000254123'),
(3179, 54374, 'LINC02840', 'long intergenic non-protein coding RNA 2840', 'non-coding RNA', 'ENSG00000224893'),
(3180, 54379, 'LINC02844', 'long intergenic non-protein coding RNA 2844', 'non-coding RNA', 'ENSG00000253679'),
(3181, 54384, 'LINC02848', 'long intergenic non-protein coding RNA 2848', 'non-coding RNA', 'ENSG00000226581'),
(3182, 54386, 'LINC02850', 'long intergenic non-protein coding RNA 2850', 'non-coding RNA', 'ENSG00000236436'),
(3183, 54392, 'LINC02855', 'long intergenic non-protein coding RNA 2855', 'non-coding RNA', 'ENSG00000254209'),
(3184, 54395, 'LINC02858', 'long intergenic non-protein coding RNA 2858', 'non-coding RNA', 'ENSG00000285869'),
(3185, 32045, 'LINC02869', 'long intergenic non-protein coding RNA 2869', 'non-coding RNA', 'ENSG00000228208'),
(3186, 26805, 'LINC02873', 'long intergenic non-protein coding RNA 2873', 'non-coding RNA', 'ENSG00000175728'),
(3187, 27473, 'LINC02874', 'long intergenic non-protein coding RNA 2874', 'non-coding RNA', 'ENSG00000257137'),
(3188, 37259, 'LINC02877', 'long intergenic non-protein coding RNA 2877', 'non-coding RNA', 'ENSG00000237787'),
(3189, 51236, 'LINC02881', 'long intergenic non-protein coding RNA 2881', 'non-coding RNA', 'ENSG00000277288'),
(3190, 55220, 'LINC02890', 'long intergenic non-protein coding RNA 2890', 'non-coding RNA', 'ENSG00000260905'),
(3191, 33759, 'LINC02897', 'long intergenic non-protein coding RNA 2897', 'non-coding RNA', 'ENSG00000221953'),
(3192, 26731, 'LINC02904', 'long intergenic non-protein coding RNA 2904', 'non-coding RNA', 'ENSG00000177335'),
(3193, 32200, 'LINC02905', 'long intergenic non-protein coding RNA 2905', 'non-coding RNA', 'ENSG00000255394'),
(3194, 44658, 'LINC02911', 'long intergenic non-protein coding RNA 2911', 'non-coding RNA', 'ENSG00000261190'),
(3195, 55667, 'LINC02922', 'long intergenic non-protein coding RNA 2922', 'non-coding RNA', 'ENSG00000235629'),
(3196, 55672, 'LINC02923', 'long intergenic non-protein coding RNA 2923', 'non-coding RNA', 'ENSG00000235497'),
(3197, 55853, 'LINC02931', 'long intergenic non-protein coding RNA 2931', 'non-coding RNA', 'ENSG00000224765'),
(3198, 55939, 'LINC02935', 'long intergenic non-protein coding RNA 2935', 'non-coding RNA', 'ENSG00000225292'),
(3199, 55942, 'LINC02937', 'long intergenic non-protein coding RNA 2937', 'non-coding RNA', 'ENSG00000230537'),
(3200, 55962, 'LINC02947', 'long intergenic non-protein coding RNA 2947', 'non-coding RNA', 'ENSG00000253140'),
(3201, 55964, 'LINC02949', 'long intergenic non-protein coding RNA 2949', 'non-coding RNA', 'ENSG00000253505'),
(3202, 55967, 'LINC02951', 'long intergenic non-protein coding RNA 2951', 'non-coding RNA', 'ENSG00000255503'),
(3203, 55985, 'LINC02960', 'long intergenic non-protein coding RNA 2960', 'non-coding RNA', 'ENSG00000275198'),
(3204, 55988, 'LINC02962', 'long intergenic non-protein coding RNA 2962', 'non-coding RNA', 'ENSG00000236427'),
(3205, 56003, 'LINC02965', 'long intergenic non-protein coding RNA 2965', 'non-coding RNA', 'ENSG00000269086'),
(3206, 56015, 'LINC02973', 'long intergenic non-protein coding RNA 2973', 'non-coding RNA', 'ENSG00000272002'),
(3207, 56043, 'LINC02979', 'long intergenic non-protein coding RNA 2979', 'non-coding RNA', 'ENSG00000267480'),
(3208, 56063, 'LINC02984', 'long intergenic non-protein coding RNA 2984', 'non-coding RNA', 'ENSG00000237807'),
(3209, 56100, 'LINC02989', 'long intergenic non-protein coding RNA 2989', 'non-coding RNA', 'ENSG00000255400'),
(3210, 56115, 'LINC02999', 'long intergenic non-protein coding RNA 2999', 'non-coding RNA', 'ENSG00000250564'),
(3211, 56116, 'LINC03000', 'long intergenic non-protein coding RNA 3000', 'non-coding RNA', 'ENSG00000241956'),
(3212, 56128, 'LINC03004', 'long intergenic non-protein coding RNA 3004', 'non-coding RNA', 'ENSG00000230533'),
(3213, 56139, 'LINC03012', 'long intergenic non-protein coding RNA 3012', 'non-coding RNA', 'ENSG00000226770'),
(3214, 56140, 'LINC03013', 'long intergenic non-protein coding RNA 3013', 'non-coding RNA', 'ENSG00000227544'),
(3215, 56174, 'LINC03031', 'long intergenic non-protein coding RNA 3031', 'non-coding RNA', 'ENSG00000254584'),
(3216, 56220, 'LINC03036', 'long intergenic non-protein coding RNA 3036', 'non-coding RNA', 'ENSG00000229272'),
(3217, 53956, 'LINCADL', 'lincRNA adipogenesis and lipogenesis associated', 'non-coding RNA', 'ENSG00000287148'),
(3218, 49089, 'LINCMD1', 'long intergenic non-protein coding RNA, muscle differentiation 1', 'non-coding RNA', 'ENSG00000225613'),
(3219, 27368, 'LINGO1-AS1', 'LINGO1 antisense RNA 1', 'non-coding RNA', 'ENSG00000259666'),
(3220, 21207, 'LINGO2', 'leucine rich repeat and Ig domain containing 2', 'protein-coding gene', 'ENSG00000174482'),
(3221, 48589, 'LIPE-AS1', 'LIPE antisense RNA 1', 'non-coding RNA', 'ENSG00000213904'),
(3222, 6623, 'LIPG', 'lipase G, endothelial type', 'protein-coding gene', 'ENSG00000101670'),
(3223, 23455, 'LIPM', 'lipase family member M', 'protein-coding gene', 'ENSG00000173239'),
(3224, 52976, 'LIX1-AS1', 'LIX1 and RIOK2 antisense RNA 1', 'non-coding RNA', 'ENSG00000251513'),
(3225, 21750, 'LLCFC1', 'LLLL and CFNLAS motif containing 1', 'protein-coding gene', 'ENSG00000165131'),
(3226, 50493, 'LLPH-DT', 'LLPH divergent transcript', 'non-coding RNA', 'ENSG00000239335'),
(3227, 50491, 'LLPHP1', 'LLPH pseudogene 1', 'pseudogene', 'ENSG00000270793'),
(3228, 6633, 'LMCD1', 'LIM and cysteine rich domains 1', 'protein-coding gene', 'ENSG00000071282'),
(3229, 25096, 'LMF2', 'lipase maturation factor 2', 'protein-coding gene', 'ENSG00000100258'),
(3230, 53089, 'LMNB1-DT', 'LMNB1 divergent transcript', 'non-coding RNA', 'ENSG00000251072'),
(3231, 6638, 'LMNB2', 'lamin B2', 'protein-coding gene', 'ENSG00000176619'),
(3232, 26683, 'LMNTD1', 'lamin tail domain containing 1', 'protein-coding gene', 'ENSG00000152936'),
(3233, 50277, 'LMO7-AS1', 'LMO7 antisense RNA 1', 'non-coding RNA', 'ENSG00000261105'),
(3234, 49790, 'LMO7DN-IT1', 'LMO7DN intronic transcript 1', 'non-coding RNA', 'ENSG00000223458'),
(3235, 6649, 'LMOD3', 'leiomodin 3', 'protein-coding gene', 'ENSG00000163380'),
(3236, 53864, 'LNCARSR', 'lncRNA regulator of Akt signaling associated with HCC and RCC', 'non-coding RNA', 'ENSG00000233086'),
(3237, 53947, 'LNCOC1', 'lncRNA associated with ovarian cancer 1', 'non-coding RNA', 'ENSG00000253741'),
(3238, 52746, 'LNCPRESS1', 'lncRNA p53 regulated and ESC associated 1', 'non-coding RNA', 'ENSG00000232301'),
(3239, 55755, 'LNCRNA-IUR', 'lncRNA imatinib upregulated', 'non-coding RNA', 'ENSG00000245552'),
(3240, 28014, 'LNP1', 'leukemia NUP98 fusion partner 1', 'protein-coding gene', 'ENSG00000206535'),
(3241, 6657, 'LNX1', 'ligand of numb-protein X 1', 'protein-coding gene', 'ENSG00000072201'),
(3242, 20421, 'LNX2', 'ligand of numb-protein X 2', 'protein-coding gene', 'ENSG00000139517'),
(3243, 9479, 'LONP1', 'lon peptidase 1, mitochondrial', 'protein-coding gene', 'ENSG00000196365'),
(3244, 39828, 'LONRF2P1', 'LONRF2 pseudogene 1', 'pseudogene', 'ENSG00000266605'),
(3245, 21152, 'LONRF3', 'LON peptidase N-terminal domain and ring finger 3', 'protein-coding gene', 'ENSG00000175556'),
(3246, 4478, 'LPAR4', 'lysophosphatidic acid receptor 4', 'protein-coding gene', 'ENSG00000147145'),
(3247, 26032, 'LPCAT2', 'lysophosphatidylcholine acyltransferase 2', 'protein-coding gene', 'ENSG00000087253'),
(3248, 30059, 'LPCAT4', 'lysophosphatidylcholine acyltransferase 4', 'protein-coding gene', 'ENSG00000176454'),
(3249, 14451, 'LPIN3', 'lipin 3', 'protein-coding gene', 'ENSG00000132793'),
(3250, 6677, 'LPL', 'lipoprotein lipase', 'protein-coding gene', 'ENSG00000175445'),
(3251, 6678, 'LPO', 'lactoperoxidase', 'protein-coding gene', 'ENSG00000167419'),
(3252, 20743, 'LRATD1', 'LRAT domain containing 1', 'protein-coding gene', 'ENSG00000162981'),
(3253, 29292, 'LRCH2', 'leucine rich repeats and calponin homology domain containing 2', 'protein-coding gene', 'ENSG00000130224'),
(3254, 6691, 'LRCH4', 'leucine rich repeats and calponin homology domain containing 4', 'protein-coding gene', 'ENSG00000077454'),
(3255, 30299, 'LRIF1', 'ligand dependent nuclear receptor interacting factor 1', 'protein-coding gene', 'ENSG00000121931'),
(3256, 55476, 'LRIG3-DT', 'LRIG3 divergent transcript', 'non-coding RNA', 'ENSG00000257443'),
(3257, 23443, 'LRIT2', 'leucine rich repeat, Ig-like and transmembrane domains 2', 'protein-coding gene', 'ENSG00000204033'),
(3258, 6695, 'LRP3', 'LDL receptor related protein 3', 'protein-coding gene', 'ENSG00000130881'),
(3259, 25323, 'LRP5L', 'LDL receptor related protein 5 like', 'protein-coding gene', 'ENSG00000100068'),
(3260, 14553, 'LRP10', 'LDL receptor related protein 10', 'protein-coding gene', 'ENSG00000197324'),
(3261, 31708, 'LRP12', 'LDL receptor related protein 12', 'protein-coding gene', 'ENSG00000147650'),
(3262, 14307, 'LRRC1', 'leucine rich repeat containing 1', 'protein-coding gene', 'ENSG00000137269'),
(3263, 15571, 'LRRC2-AS1', 'LRRC2 antisense RNA 1', 'non-coding RNA', 'ENSG00000268324'),
(3264, 30692, 'LRRC8B', 'leucine rich repeat containing 8 VRAC subunit B', 'protein-coding gene', 'ENSG00000197147'),
(3265, 25479, 'LRRC37A4P', 'leucine rich repeat containing 37 member A4, pseudogene', 'pseudogene', 'ENSG00000214425'),
(3266, 43813, 'LRRC37A9P', 'leucine rich repeat containing 37 member A9, pseudogene', 'pseudogene', 'ENSG00000271013'),
(3267, 43815, 'LRRC37A11P', 'leucine rich repeat containing 37 member A11, pseudogene', 'pseudogene', 'ENSG00000214553'),
(3268, 26004, 'LRRC40', 'leucine rich repeat containing 40', 'protein-coding gene', 'ENSG00000066557'),
(3269, 29207, 'LRRC47', 'leucine rich repeat containing 47', 'protein-coding gene', 'ENSG00000130764'),
(3270, 28817, 'LRRC59', 'leucine rich repeat containing 59', 'protein-coding gene', 'ENSG00000108829'),
(3271, 34299, 'LRRC66', 'leucine rich repeat containing 66', 'protein-coding gene', 'ENSG00000188993'),
(3272, 26556, 'LRRC71', 'leucine rich repeat containing 71', 'protein-coding gene', 'ENSG00000160838'),
(3273, 21375, 'LRRC73', 'leucine rich repeat containing 73', 'protein-coding gene', 'ENSG00000204052'),
(3274, 34301, 'LRRC74B', 'leucine rich repeat containing 74B', 'protein-coding gene', 'ENSG00000187905'),
(3275, 29373, 'LRRCC1', 'leucine rich repeat and coiled-coil centrosomal protein 1', 'protein-coding gene', 'ENSG00000133739'),
(3276, 34298, 'LRRIQ4', 'leucine rich repeats and IQ motif containing 4', 'protein-coding gene', 'ENSG00000188306'),
(3277, 20980, 'LRRN1', 'leucine rich repeat neuronal 1', 'protein-coding gene', 'ENSG00000175928'),
(3278, 16914, 'LRRN2', 'leucine rich repeat neuronal 2', 'protein-coding gene', 'ENSG00000170382'),
(3279, 19411, 'LRRTM4', 'leucine rich repeat transmembrane neuronal 4', 'protein-coding gene', 'ENSG00000176204'),
(3280, 25023, 'LRTM1', 'leucine rich repeats and transmembrane domains 1', 'protein-coding gene', 'ENSG00000144771'),
(3281, 32443, 'LRTM2', 'leucine rich repeats and transmembrane domains 2', 'protein-coding gene', 'ENSG00000166159'),
(3282, 25652, 'LSG1', 'large 60S subunit nuclear export GTPase 1', 'protein-coding gene', 'ENSG00000041802'),
(3283, 20472, 'LSM1', 'LSM1 homolog, mRNA degradation associated', 'protein-coding gene', 'ENSG00000175324'),
(3284, 13940, 'LSM2', 'LSM2 homolog, U6 small nuclear RNA and mRNA degradation associated', 'protein-coding gene', 'ENSG00000204392'),
(3285, 39716, 'LSP1P1', 'LSP1 pseudogene 1', 'pseudogene', 'ENSG00000269099'),
(3286, 6713, 'LTB4R', 'leukotriene B4 receptor', 'protein-coding gene', 'ENSG00000213903'),
(3287, 6714, 'LTBP1', 'latent transforming growth factor beta binding protein 1', 'protein-coding gene', 'ENSG00000049323'),
(3288, 21608, 'LUC7L2', 'LUC7 like 2, pre-mRNA splicing factor', 'protein-coding gene', 'ENSG00000146963'),
(3289, 51199, 'LUNAR1', 'leukemia-associated non-coding IGF1R activator RNA 1', 'non-coding RNA', 'ENSG00000278090'),
(3290, 23206, 'LUZP2', 'leucine zipper protein 2', 'protein-coding gene', 'ENSG00000187398'),
(3291, 24971, 'LUZP4', 'leucine zipper protein 4', 'protein-coding gene', 'ENSG00000102021'),
(3292, 13932, 'LY6G5C', 'lymphocyte antigen 6 family member G5C', 'protein-coding gene', 'ENSG00000204428'),
(3293, 38821, 'LY6G6F-LY6G6D', 'LY6G6F-LY6G6D readthrough', 'other', 'ENSG00000250641'),
(3294, 6729, 'LY75', 'lymphocyte antigen 75', 'protein-coding gene', 'ENSG00000054219'),
(3295, 16837, 'LY86', 'lymphocyte antigen 86', 'protein-coding gene', 'ENSG00000112799'),
(3296, 44005, 'LYPLA1P1', 'LYPLA1 pseudogene 1', 'pseudogene', 'ENSG00000223595'),
(3297, 44007, 'LYPLA1P3', 'LYPLA1 pseudogene 3', 'pseudogene', 'ENSG00000218350'),
(3298, 21069, 'LYPLA2P1', 'LYPLA2 pseudogene 1', 'pseudogene', 'ENSG00000228285'),
(3299, 20440, 'LYPLAL1', 'lysophospholipase like 1', 'protein-coding gene', 'ENSG00000143353'),
(3300, 54054, 'LYPLAL1-AS1', 'LYPLAL1 antisense RNA 1', 'non-coding RNA', 'ENSG00000228536'),
(3301, 21365, 'LYRM4', 'LYR motif containing 4', 'protein-coding gene', 'ENSG00000214113'),
(3302, 28072, 'LYRM7', 'LYR motif containing 7', 'protein-coding gene', 'ENSG00000186687'),
(3303, 30502, 'LYZL1', 'lysozyme like 1', 'protein-coding gene', 'ENSG00000120563'),
(3304, 29381, 'LZTS2', 'leucine zipper tumor suppressor 2', 'protein-coding gene', 'ENSG00000107816'),
(3305, 41257, 'MACC1-AS1', 'MACC1 antisense RNA 1', 'non-coding RNA', 'ENSG00000228598'),
(3306, 16126, 'MACROD2', 'mono-ADP ribosylhydrolase 2', 'protein-coding gene', 'ENSG00000172264'),
(3307, 37193, 'MACROD2-AS1', 'MACROD2 antisense RNA 1', 'non-coding RNA', 'ENSG00000235914'),
(3308, 4740, 'MACROH2A1', 'macroH2A.1 histone', 'protein-coding gene', 'ENSG00000113648'),
(3309, 14453, 'MACROH2A2', 'macroH2A.2 histone', 'protein-coding gene', 'ENSG00000099284'),
(3310, 21059, 'MAD2L1BP', 'MAD2L1 binding protein', 'protein-coding gene', 'ENSG00000124688'),
(3311, 6776, 'MAF', 'MAF bZIP transcription factor', 'protein-coding gene', 'ENSG00000178573'),
(3312, 6780, 'MAFF', 'MAF bZIP transcription factor F', 'protein-coding gene', 'ENSG00000185022'),
(3313, 6796, 'MAGEA1', 'MAGE family member A1', 'protein-coding gene', 'ENSG00000198681'),
(3314, 6800, 'MAGEA2', 'MAGE family member A2', 'protein-coding gene', 'ENSG00000268606'),
(3315, 19340, 'MAGEA2B', 'MAGE family member A2B', 'protein-coding gene', 'ENSG00000183305'),
(3316, 6802, 'MAGEA4', 'MAGE family member A4', 'protein-coding gene', 'ENSG00000147381'),
(3317, 6803, 'MAGEA5P', 'MAGE family member A5, pseudogene', 'pseudogene', 'ENSG00000242520'),
(3318, 6810, 'MAGEB3', 'MAGE family member B3', 'protein-coding gene', 'ENSG00000198798'),
(3319, 25377, 'MAGEB10', 'MAGE family member B10', 'protein-coding gene', 'ENSG00000177689'),
(3320, 28515, 'MAGEB18', 'MAGE family member B18', 'protein-coding gene', 'ENSG00000176774'),
(3321, 18957, 'MAGI2', 'membrane associated guanylate kinase, WW and PDZ domain containing 2', 'protein-coding gene', 'ENSG00000187391'),
(3322, 25504, 'MAGOHB', 'mago homolog B, exon junction complex subunit', 'protein-coding gene', 'ENSG00000111196'),
(3323, 28880, 'MAGT1', 'magnesium transporter 1', 'protein-coding gene', 'ENSG00000102158'),
(3324, 29665, 'MALAT1', 'metastasis associated lung adenocarcinoma transcript 1', 'non-coding RNA', 'ENSG00000251562'),
(3325, 55038, 'MALLP1', 'MALL pseudogene 1', 'pseudogene', 'ENSG00000282785'),
(3326, 24331, 'MALRD1', 'MAM and LDL receptor class A domain containing 1', 'protein-coding gene', 'ENSG00000204740'),
(3327, 55306, 'MALT1-AS1', 'MALT1 antisense RNA 1', 'non-coding RNA', 'ENSG00000267226'),
(3328, 6821, 'MAN1A1', 'mannosidase alpha class 1A member 1', 'protein-coding gene', 'ENSG00000111885'),
(3329, 54641, 'MANEALP1', 'MANEAL pseudogene 1', 'pseudogene', 'ENSG00000214070'),
(3330, 6838, 'MAP1LC3A', 'microtubule associated protein 1 light chain 3 alpha', 'protein-coding gene', 'ENSG00000101460'),
(3331, 13353, 'MAP1LC3C', 'microtubule associated protein 1 light chain 3 gamma', 'protein-coding gene', 'ENSG00000197769'),
(3332, 15715, 'MAP1S', 'microtubule associated protein 1S', 'protein-coding gene', 'ENSG00000130479'),
(3333, 6856, 'MAP3K4', 'mitogen-activated protein kinase kinase kinase 4', 'protein-coding gene', 'ENSG00000085511'),
(3334, 16457, 'MAP3K7CL', 'MAP3K7 C-terminal like', 'protein-coding gene', 'ENSG00000156265'),
(3335, 31689, 'MAP3K15', 'mitogen-activated protein kinase kinase kinase 15', 'protein-coding gene', 'ENSG00000180815'),
(3336, 6863, 'MAP4K1', 'mitogen-activated protein kinase kinase kinase kinase 1', 'protein-coding gene', 'ENSG00000104814'),
(3337, 6867, 'MAP4K5', 'mitogen-activated protein kinase kinase kinase kinase 5', 'protein-coding gene', 'ENSG00000012983'),
(3338, 56110, 'MAP9-AS1', 'MAP9 antisense RNA 1', 'non-coding RNA', 'ENSG00000250910'),
(3339, 6878, 'MAPK4', 'mitogen-activated protein kinase 4', 'protein-coding gene', 'ENSG00000141639'),
(3340, 6879, 'MAPK6', 'mitogen-activated protein kinase 6', 'protein-coding gene', 'ENSG00000069956'),
(3341, 16756, 'MAPK6P2', 'mitogen-activated protein kinase 6 pseudogene 2', 'pseudogene', 'ENSG00000223488'),
(3342, 18979, 'MAPK6P5', 'mitogen-activated protein kinase 6 pseudogene 5', 'pseudogene', 'ENSG00000254185'),
(3343, 52402, 'MAPK8IP1P2', 'mitogen-activated protein kinase 8 interacting protein 1 pseudogene 2', 'pseudogene', 'ENSG00000263503'),
(3344, 6883, 'MAPK8IP2', 'mitogen-activated protein kinase 8 interacting protein 2', 'protein-coding gene', 'ENSG00000008735'),
(3345, 56087, 'MAPK8IP3-AS1', 'MAPK8IP3 antisense RNA 1', 'non-coding RNA', 'ENSG00000261399'),
(3346, 6874, 'MAPK12', 'mitogen-activated protein kinase 12', 'protein-coding gene', 'ENSG00000188130'),
(3347, 6887, 'MAPKAPK2', 'MAPK activated protein kinase 2', 'protein-coding gene', 'ENSG00000162889'),
(3348, 6889, 'MAPKAPK5', 'MAPK activated protein kinase 5', 'protein-coding gene', 'ENSG00000089022'),
(3349, 37762, 'MAPRE1P3', 'MAPRE1 pseudogene 3', 'pseudogene', 'ENSG00000233204'),
(3350, 6891, 'MAPRE2', 'microtubule associated protein RP/EB family member 2', 'protein-coding gene', 'ENSG00000166974'),
(3351, 43741, 'MAPT-IT1', 'MAPT intronic transcript 1', 'non-coding RNA', 'ENSG00000279685'),
(3352, 41287, 'MARCHF11-AS1', 'MARCHF11 antisense RNA 1', 'non-coding RNA', 'ENSG00000250981'),
(3353, 39801, 'MARK2P10', 'microtubule affinity regulating kinase 2 pseudogene 10', 'pseudogene', 'ENSG00000227284'),
(3354, 44495, 'MARK2P14', 'microtubule affinity regulating kinase 2 pseudogene 14', 'pseudogene', 'ENSG00000231897'),
(3355, 13538, 'MARK4', 'microtubule affinity regulating kinase 4', 'protein-coding gene', 'ENSG00000007047'),
(3356, 19034, 'MAST1', 'microtubule associated serine/threonine kinase 1', 'protein-coding gene', 'ENSG00000105613'),
(3357, 55276, 'MAST3-AS1', 'MAST3 antisense RNA 1', 'non-coding RNA', 'ENSG00000269145'),
(3358, 6903, 'MAT1A', 'methionine adenosyltransferase 1A', 'protein-coding gene', 'ENSG00000151224'),
(3359, 6907, 'MATN1', 'matrilin 1', 'protein-coding gene', 'ENSG00000162510'),
(3360, 6909, 'MATN3', 'matrilin 3', 'protein-coding gene', 'ENSG00000132031'),
(3361, 6915, 'MB', 'myoglobin', 'protein-coding gene', 'ENSG00000198125'),
(3362, 18532, 'MBD3L2', 'methyl-CpG binding domain protein 3 like 2', 'protein-coding gene', 'ENSG00000230522'),
(3363, 6919, 'MBD4', 'methyl-CpG binding domain 4, DNA glycosylase', 'protein-coding gene', 'ENSG00000129071'),
(3364, 20427, 'MBIP', 'MAP3K12 binding inhibitory protein 1', 'protein-coding gene', 'ENSG00000151332'),
(3365, 2221, 'MBL3P', 'mannose-binding lectin family member 3, pseudogene', 'pseudogene', 'ENSG00000219430'),
(3366, 19866, 'MBTD1', 'mbt domain containing 1', 'protein-coding gene', 'ENSG00000011258'),
(3367, 15456, 'MBTPS1', 'membrane bound transcription factor peptidase, site 1', 'protein-coding gene', 'ENSG00000140943'),
(3368, 6931, 'MC3R', 'melanocortin 3 receptor', 'protein-coding gene', 'ENSG00000124089'),
(3369, 29622, 'MCAT', 'malonyl-CoA-acyl carrier protein transacylase', 'protein-coding gene', 'ENSG00000100294'),
(3370, 30319, 'MCF2L2', 'MCF.2 cell line derived transforming sequence-like 2', 'protein-coding gene', 'ENSG00000053524'),
(3371, 21582, 'MCFD2P1', 'multiple coagulation factor deficiency 2 pseudogene 1', 'pseudogene', 'ENSG00000237154'),
(3372, 6945, 'MCM3', 'minichromosome maintenance complex component 3', 'protein-coding gene', 'ENSG00000112118'),
(3373, 16147, 'MCM8', 'minichromosome maintenance 8 homologous recombination repair factor', 'protein-coding gene', 'ENSG00000125885'),
(3374, 13357, 'MCOLN2', 'mucolipin TRP cation channel 2', 'protein-coding gene', 'ENSG00000153898'),
(3375, 14142, 'MCRIP2', 'MAPK regulated corepressor interacting protein 2', 'protein-coding gene', 'ENSG00000172366'),
(3376, 49631, 'MCRIP2P2', 'MAPK regulated corepressor interacting protein 2 pseudogene 2', 'pseudogene', 'ENSG00000270920'),
(3377, 6960, 'MCRS1', 'microspherule protein 1', 'protein-coding gene', 'ENSG00000187778'),
(3378, 25636, 'MCTP2', 'multiple C2 and transmembrane domain containing 2', 'protein-coding gene', 'ENSG00000140563'),
(3379, 49760, 'MCTS2', 'MCTS family member 2', 'protein-coding gene', 'ENSG00000101898'),
(3380, 39764, 'MDC1-AS1', 'MDC1 antisense RNA 1', 'non-coding RNA', 'ENSG00000224328'),
(3381, 28870, 'MDFIC', 'MyoD family inhibitor domain containing', 'protein-coding gene', 'ENSG00000135272'),
(3382, 17836, 'MDH1B', 'malate dehydrogenase 1B', 'protein-coding gene', 'ENSG00000138400'),
(3383, 40837, 'MDN1-AS1', 'MDN1 antisense RNA 1', 'non-coding RNA', 'ENSG00000228124'),
(3384, 6983, 'ME1', 'malic enzyme 1', 'protein-coding gene', 'ENSG00000065833'),
(3385, 49809, 'ME2P1', 'malic enzyme 2 pseudogene 1', 'pseudogene', 'ENSG00000230097'),
(3386, 3498, 'MECOM', 'MDS1 and EVI1 complex locus', 'protein-coding gene', 'ENSG00000085276'),
(3387, 40908, 'MED8-AS1', 'MED8 antisense RNA 1', 'non-coding RNA', 'ENSG00000229431'),
(3388, 14248, 'MED15', 'mediator complex subunit 15', 'protein-coding gene', 'ENSG00000099917'),
(3389, 44130, 'MED15P9', 'mediator complex subunit 15 pseudogene 9', 'pseudogene', 'ENSG00000223760'),
(3390, 25944, 'MED18', 'mediator complex subunit 18', 'protein-coding gene', 'ENSG00000130772'),
(3391, 2376, 'MED26', 'mediator complex subunit 26', 'protein-coding gene', 'ENSG00000105085'),
(3392, 45083, 'MED28P6', 'mediator complex subunit 28 pseudogene 6', 'pseudogene', 'ENSG00000259183'),
(3393, 6996, 'MEF2C', 'myocyte enhancer factor 2C', 'protein-coding gene', 'ENSG00000081189'),
(3394, 28613, 'MEI1', 'meiotic double-stranded break formation protein 1', 'protein-coding gene', 'ENSG00000167077'),
(3395, 43638, 'MEI4', 'meiotic double-stranded break formation protein 4', 'protein-coding gene', 'ENSG00000269964'),
(3396, 7001, 'MEIS2', 'Meis homeobox 2', 'protein-coding gene', 'ENSG00000134138'),
(3397, 7002, 'MEIS3P1', 'Meis homeobox 3 pseudogene 1', 'pseudogene', 'ENSG00000179277'),
(3398, 7037, 'MELTF', 'melanotransferrin', 'protein-coding gene', 'ENSG00000163975'),
(3399, 38503, 'MEMO1P3', 'mediator of cell motility 1 pseudogene 3', 'pseudogene', 'ENSG00000239238'),
(3400, 7014, 'MEOX2', 'mesenchyme homeobox 2', 'protein-coding gene', 'ENSG00000106511'),
(3401, 7015, 'MEP1A', 'meprin A subunit alpha', 'protein-coding gene', 'ENSG00000112818'),
(3402, 7016, 'MEP1AP1', 'meprin A subunit alpha pseudogene 1', 'pseudogene', 'ENSG00000283246'),
(3403, 13520, 'MESD', 'mesoderm development LRP chaperone', 'protein-coding gene', 'ENSG00000117899'),
(3404, 29658, 'MESP1', 'mesoderm posterior bHLH transcription factor 1', 'protein-coding gene', 'ENSG00000166823'),
(3405, 38554, 'MESTP4', 'mesoderm specific transcript pseudogene 4', 'pseudogene', 'ENSG00000215004'),
(3406, 14151, 'METRN', 'meteorin, glial cell differentiation regulator', 'protein-coding gene', 'ENSG00000103260'),
(3407, 25755, 'METTL2A', 'methyltransferase 2A, methylcytidine', 'protein-coding gene', 'ENSG00000087995'),
(3408, 18272, 'METTL2B', 'methyltransferase 2B, methylcytidine', 'protein-coding gene', 'ENSG00000165055'),
(3409, 25856, 'METTL8', 'methyltransferase 8, methylcytidine', 'protein-coding gene', 'ENSG00000123600'),
(3410, 28793, 'METTL18', 'methyltransferase like 18', 'protein-coding gene', 'ENSG00000171806'),
(3411, 41921, 'METTL21AP1', 'methyltransferase like 21A pseudogene 1', 'pseudogene', 'ENSG00000229623'),
(3412, 29673, 'MFAP5', 'microfibril associated protein 5', 'protein-coding gene', 'ENSG00000197614'),
(3413, 24858, 'MFF', 'mitochondrial fission factor', 'protein-coding gene', 'ENSG00000168958'),
(3414, 54537, 'MFFP1', 'MFF pseudogene 1', 'pseudogene', 'ENSG00000215720'),
(3415, 54540, 'MFFP2', 'MFF pseudogene 2', 'pseudogene', 'ENSG00000251583'),
(3416, 54944, 'MFFP3', 'MFF pseudogene 3', 'pseudogene', 'ENSG00000204915'),
(3417, 16982, 'MFHAS1', 'multifunctional ROCO family signaling regulator 1', 'protein-coding gene', 'ENSG00000147324'),
(3418, 28156, 'MFSD5', 'major facilitator superfamily domain containing 5', 'protein-coding gene', 'ENSG00000182544'),
(3419, 29969, 'MGARP', 'mitochondria localized glutamic acid rich protein', 'protein-coding gene', 'ENSG00000137463'),
(3420, 7045, 'MGAT2', 'alpha-1,6-mannosyl-glycoprotein 2-beta-N-acetylglucosaminyltransferase', 'protein-coding gene', 'ENSG00000168282'),
(3421, 51244, 'MGAT2P1', 'MGAT2 pseudogene 1', 'pseudogene', 'ENSG00000233861'),
(3422, 43619, 'MGAT4D', 'MGAT4 family member D', 'protein-coding gene', 'ENSG00000205301'),
(3423, 49418, 'MGAT4EP', 'MGAT4 family member E, pseudogene', 'pseudogene', 'ENSG00000184774'),
(3424, 7049, 'MGAT5', 'alpha-1,6-mannosylglycoprotein 6-beta-N-acetylglucosaminyltransferase', 'protein-coding gene', 'ENSG00000152127'),
(3425, 17038, 'MGLL', 'monoglyceride lipase', 'protein-coding gene', 'ENSG00000074416'),
(3426, 20254, 'MGRN1', 'mahogunin ring finger 1', 'protein-coding gene', 'ENSG00000102858'),
(3427, 55436, 'MIA2-AS1', 'MIA2 antisense RNA 1', 'non-coding RNA', 'ENSG00000258940'),
(3428, 16802, 'MICG', 'MHC class I polypeptide-related sequence G (pseudogene)', 'pseudogene', 'ENSG00000237042'),
(3429, 48338, 'MICOS10-NBL1', 'MICOS10-NBL1 readthrough', 'other', 'ENSG00000270136'),
(3430, 44093, 'MICOS10P3', 'MICOS10 pseudogene 3', 'pseudogene', 'ENSG00000224237'),
(3431, 7095, 'MID1', 'midline 1', 'protein-coding gene', 'ENSG00000101871'),
(3432, 56194, 'MIDEAS-AS1', 'MIDEAS antisense RNA 1', 'non-coding RNA', 'ENSG00000259065'),
(3433, 25979, 'MIEF1', 'mitochondrial elongation factor 1', 'protein-coding gene', 'ENSG00000100335'),
(3434, 25715, 'MIIP', 'migration and invasion inhibitory protein', 'protein-coding gene', 'ENSG00000116691'),
(3435, 25648, 'MINDY1', 'MINDY lysine 48 deubiquitinase 1', 'protein-coding gene', 'ENSG00000143409'),
(3436, 55187, 'MIOS-DT', 'MIOS divergent transcript', 'non-coding RNA', 'ENSG00000272894'),
(3437, 7103, 'MIP', 'major intrinsic protein of lens fiber', 'protein-coding gene', 'ENSG00000135517'),
(3438, 39457, 'MIPEPP2', 'mitochondrial intermediate peptidase pseudogene 2', 'pseudogene', 'ENSG00000224783'),
(3439, 31499, 'MIR1-1', 'microRNA 1-1', 'non-coding RNA', 'ENSG00000199017'),
(3440, 31500, 'MIR1-2', 'microRNA 1-2', 'non-coding RNA', 'ENSG00000284453'),
(3441, 31639, 'MIR7-2', 'microRNA 7-2', 'non-coding RNA', 'ENSG00000207703'),
(3442, 30780, 'MIR9-1HG', 'MIR9-1 host gene', 'non-coding RNA', 'ENSG00000125462'),
(3443, 27388, 'MIR9-3HG', 'MIR9-3 host gene', 'non-coding RNA', 'ENSG00000255571'),
(3444, 31545, 'MIR16-1', 'microRNA 16-1', 'non-coding RNA', 'ENSG00000208006'),
(3445, 31574, 'MIR19A', 'microRNA 19a', 'non-coding RNA', 'ENSG00000284204'),
(3446, 31576, 'MIR19B2', 'microRNA 19b-2', 'non-coding RNA', 'ENSG00000284107'),
(3447, 31599, 'MIR22', 'microRNA 22', 'non-coding RNA', 'ENSG00000283824'),
(3448, 31608, 'MIR24-2', 'microRNA 24-2', 'non-coding RNA', 'ENSG00000284387'),
(3449, 31610, 'MIR26A1', 'microRNA 26a-1', 'non-coding RNA', 'ENSG00000199075'),
(3450, 31615, 'MIR28', 'microRNA 28', 'non-coding RNA', 'ENSG00000207651'),
(3451, 32018, 'MIR29B2CHG', 'MIR29B2 and MIR29C host gene', 'non-coding RNA', 'ENSG00000203709'),
(3452, 31626, 'MIR30C1', 'microRNA 30c-1', 'non-coding RNA', 'ENSG00000207962'),
(3453, 32791, 'MIR33B', 'microRNA 33b', 'non-coding RNA', 'ENSG00000207839'),
(3454, 31635, 'MIR34A', 'microRNA 34a', 'non-coding RNA', 'ENSG00000284357'),
(3455, 55987, 'MIR34BHG', 'MIR34B and MIR34C host gene', 'non-coding RNA', 'ENSG00000286028'),
(3456, 31647, 'MIR95', 'microRNA 95', 'non-coding RNA', 'ENSG00000207807'),
(3457, 31649, 'MIR98', 'microRNA 98', 'non-coding RNA', 'ENSG00000271886'),
(3458, 39522, 'MIR100HG', 'mir-100-let-7a-2-mir-125b-1 cluster host gene', 'non-coding RNA', 'ENSG00000255248'),
(3459, 35385, 'MIR103B2', 'microRNA 103b-2', 'non-coding RNA', 'ENSG00000283320'),
(3460, 31496, 'MIR107', 'microRNA 107', 'non-coding RNA', 'ENSG00000198997'),
(3461, 31501, 'MIR122', 'microRNA 122', 'non-coding RNA', 'ENSG00000284440'),
(3462, 27231, 'MIR124-1HG', 'MIR124-1 host gene', 'non-coding RNA', 'ENSG00000253230'),
(3463, 48723, 'MIR124-2HG', 'MIR124-2 host gene', 'non-coding RNA', 'ENSG00000254377'),
(3464, 31505, 'MIR125A', 'microRNA 125a', 'non-coding RNA', 'ENSG00000208008'),
(3465, 31508, 'MIR126', 'microRNA 126', 'non-coding RNA', 'ENSG00000199161'),
(3466, 31514, 'MIR130A', 'microRNA 130a', 'non-coding RNA', 'ENSG00000208009'),
(3467, 31520, 'MIR135A1', 'microRNA 135a-1', 'non-coding RNA', 'ENSG00000207926'),
(3468, 41588, 'MIR151B', 'microRNA 151b', 'non-coding RNA', 'ENSG00000265154'),
(3469, 31539, 'MIR153-1', 'microRNA 153-1', 'non-coding RNA', 'ENSG00000207647'),
(3470, 48659, 'MIR181A1HG', 'MIR181A1 host gene', 'non-coding RNA', 'ENSG00000229989'),
(3471, 37188, 'MIR181A2HG', 'MIR181A2 host gene', 'non-coding RNA', 'ENSG00000224020'),
(3472, 32089, 'MIR181D', 'microRNA 181d', 'non-coding RNA', 'ENSG00000207585'),
(3473, 51945, 'MIR193BHG', 'MIR193b-365a host gene', 'non-coding RNA', 'ENSG00000262454'),
(3474, 31564, 'MIR194-1', 'microRNA 194-1', 'non-coding RNA', 'ENSG00000207624'),
(3475, 31565, 'MIR194-2', 'microRNA 194-2', 'non-coding RNA', 'ENSG00000284155'),
(3476, 31566, 'MIR195', 'microRNA 195', 'non-coding RNA', 'ENSG00000284112'),
(3477, 31579, 'MIR200B', 'microRNA 200b', 'non-coding RNA', 'ENSG00000207730'),
(3478, 53161, 'MIR200CHG', 'MIR200C and MIR141 host gene', 'non-coding RNA', 'ENSG00000257084'),
(3479, 31581, 'MIR203A', 'microRNA 203a', 'non-coding RNA', 'ENSG00000207568'),
(3480, 31591, 'MIR214', 'microRNA 214', 'non-coding RNA', 'ENSG00000283844'),
(3481, 31594, 'MIR217', 'microRNA 217', 'non-coding RNA', 'ENSG00000207548'),
(3482, 31597, 'MIR219A1', 'microRNA 219a-1', 'non-coding RNA', 'ENSG00000199036'),
(3483, 55938, 'MIR219A2HG', 'MIR219A2 host gene', 'non-coding RNA', 'ENSG00000207955'),
(3484, 54520, 'MIR223HG', 'MIR223 host gene', 'non-coding RNA', 'ENSG00000274536'),
(3485, 33691, 'MIR297', 'microRNA 297', 'non-coding RNA', 'ENSG00000215961'),
(3486, 33667, 'MIR301B', 'microRNA 301b', 'non-coding RNA', 'ENSG00000212102'),
(3487, 31623, 'MIR302A', 'microRNA 302a', 'non-coding RNA', 'ENSG00000207927'),
(3488, 31769, 'MIR326', 'microRNA 326', 'non-coding RNA', 'ENSG00000199090'),
(3489, 31779, 'MIR345', 'microRNA 345', 'non-coding RNA', 'ENSG00000198984'),
(3490, 31780, 'MIR346', 'microRNA 346', 'non-coding RNA', 'ENSG00000199104'),
(3491, 31787, 'MIR373', 'microRNA 373', 'non-coding RNA', 'ENSG00000199143'),
(3492, 31868, 'MIR375', 'microRNA 375', 'non-coding RNA', 'ENSG00000198973'),
(3493, 32066, 'MIR376B', 'microRNA 376b', 'non-coding RNA', 'ENSG00000283556'),
(3494, 31870, 'MIR377', 'microRNA 377', 'non-coding RNA', 'ENSG00000199015'),
(3495, 38283, 'MIR378B', 'microRNA 378b', 'non-coding RNA', 'ENSG00000264534'),
(3496, 41671, 'MIR378E', 'microRNA 378e', 'non-coding RNA', 'ENSG00000263831'),
(3497, 41686, 'MIR378F', 'microRNA 378f', 'non-coding RNA', 'ENSG00000264926'),
(3498, 41620, 'MIR378I', 'microRNA 378i', 'non-coding RNA', 'ENSG00000283829'),
(3499, 20136, 'MIR381HG', 'MIR381 host gene', 'non-coding RNA', 'ENSG00000258861'),
(3500, 32065, 'MIR410', 'microRNA 410', 'non-coding RNA', 'ENSG00000199092');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(3501, 32792, 'MIR411', 'microRNA 411', 'non-coding RNA', 'ENSG00000199109'),
(3502, 32793, 'MIR421', 'microRNA 421', 'non-coding RNA', 'ENSG00000202566'),
(3503, 32026, 'MIR433', 'microRNA 433', 'non-coding RNA', 'ENSG00000207569'),
(3504, 33642, 'MIR450B', 'microRNA 450b', 'non-coding RNA', 'ENSG00000216001'),
(3505, 32053, 'MIR451A', 'microRNA 451a', 'non-coding RNA', 'ENSG00000284565'),
(3506, 32340, 'MIR483', 'microRNA 483', 'non-coding RNA', 'ENSG00000207805'),
(3507, 32082, 'MIR493', 'microRNA 493', 'non-coding RNA', 'ENSG00000207989'),
(3508, 38223, 'MIR500B', 'microRNA 500b', 'non-coding RNA', 'ENSG00000239057'),
(3509, 32138, 'MIR503', 'microRNA 503', 'non-coding RNA', 'ENSG00000208005'),
(3510, 33641, 'MIR509-2', 'microRNA 509-2', 'non-coding RNA', 'ENSG00000212013'),
(3511, 32090, 'MIR512-1', 'microRNA 512-1', 'non-coding RNA', 'ENSG00000207645'),
(3512, 32142, 'MIR513A2', 'microRNA 513a-2', 'non-coding RNA', 'ENSG00000207984'),
(3513, 32094, 'MIR515-1', 'microRNA 515-1', 'non-coding RNA', 'ENSG00000207616'),
(3514, 32117, 'MIR516B2', 'microRNA 516b-2', 'non-coding RNA', 'ENSG00000207925'),
(3515, 32121, 'MIR518D', 'microRNA 518d', 'non-coding RNA', 'ENSG00000283330'),
(3516, 32108, 'MIR520C', 'microRNA 520c', 'non-coding RNA', 'ENSG00000207738'),
(3517, 32113, 'MIR521-2', 'microRNA 521-2', 'non-coding RNA', 'ENSG00000207549'),
(3518, 32103, 'MIR523', 'microRNA 523', 'non-coding RNA', 'ENSG00000283455'),
(3519, 32129, 'MIR527', 'microRNA 527', 'non-coding RNA', 'ENSG00000207979'),
(3520, 32795, 'MIR532', 'microRNA 532', 'non-coding RNA', 'ENSG00000207758'),
(3521, 33664, 'MIR543', 'microRNA 543', 'non-coding RNA', 'ENSG00000212040'),
(3522, 32530, 'MIR544A', 'microRNA 544a', 'non-coding RNA', 'ENSG00000207587'),
(3523, 41626, 'MIR548AC', 'microRNA 548ac', 'non-coding RNA', 'ENSG00000264419'),
(3524, 41625, 'MIR548AG1', 'microRNA 548ag-1', 'non-coding RNA', 'ENSG00000265829'),
(3525, 43455, 'MIR548AR', 'microRNA 548ar', 'non-coding RNA', 'ENSG00000264539'),
(3526, 43517, 'MIR548AT', 'microRNA 548at', 'non-coding RNA', 'ENSG00000264314'),
(3527, 49981, 'MIR548AZ', 'microRNA 548az', 'non-coding RNA', 'ENSG00000276479'),
(3528, 35306, 'MIR548F2', 'microRNA 548f-2', 'non-coding RNA', 'ENSG00000221782'),
(3529, 35307, 'MIR548F3', 'microRNA 548f-3', 'non-coding RNA', 'ENSG00000221436'),
(3530, 35308, 'MIR548F4', 'microRNA 548f-4', 'non-coding RNA', 'ENSG00000221442'),
(3531, 35276, 'MIR548J', 'microRNA 548j', 'non-coding RNA', 'ENSG00000221760'),
(3532, 35333, 'MIR548O', 'microRNA 548o', 'non-coding RNA', 'ENSG00000221510'),
(3533, 38255, 'MIR548W', 'microRNA 548w', 'non-coding RNA', 'ENSG00000265005'),
(3534, 38992, 'MIR550B1', 'microRNA 550b-1', 'non-coding RNA', 'ENSG00000283237'),
(3535, 32819, 'MIR563', 'microRNA 563', 'non-coding RNA', 'ENSG00000207815'),
(3536, 32824, 'MIR568', 'microRNA 568', 'non-coding RNA', 'ENSG00000284134'),
(3537, 32828, 'MIR572', 'microRNA 572', 'non-coding RNA', 'ENSG00000207716'),
(3538, 32831, 'MIR575', 'microRNA 575', 'non-coding RNA', 'ENSG00000207746'),
(3539, 32842, 'MIR586', 'microRNA 586', 'non-coding RNA', 'ENSG00000207769'),
(3540, 32849, 'MIR593', 'microRNA 593', 'non-coding RNA', 'ENSG00000207588'),
(3541, 32851, 'MIR595', 'microRNA 595', 'non-coding RNA', 'ENSG00000207637'),
(3542, 23642, 'MIR600HG', 'MIR600 host gene', 'non-coding RNA', 'ENSG00000236901'),
(3543, 32857, 'MIR601', 'microRNA 601', 'non-coding RNA', 'ENSG00000207991'),
(3544, 32860, 'MIR604', 'microRNA 604', 'non-coding RNA', 'ENSG00000207612'),
(3545, 32868, 'MIR612', 'microRNA 612', 'non-coding RNA', 'ENSG00000283791'),
(3546, 32870, 'MIR614', 'microRNA 614', 'non-coding RNA', 'ENSG00000283759'),
(3547, 32877, 'MIR621', 'microRNA 621', 'non-coding RNA', 'ENSG00000207652'),
(3548, 32885, 'MIR629', 'microRNA 629', 'non-coding RNA', 'ENSG00000207965'),
(3549, 32893, 'MIR637', 'microRNA 637', 'non-coding RNA', 'ENSG00000283928'),
(3550, 32894, 'MIR638', 'microRNA 638', 'non-coding RNA', 'ENSG00000207972'),
(3551, 32899, 'MIR643', 'microRNA 643', 'non-coding RNA', 'ENSG00000208002'),
(3552, 32900, 'MIR644A', 'microRNA 644a', 'non-coding RNA', 'ENSG00000207997'),
(3553, 32909, 'MIR653', 'microRNA 653', 'non-coding RNA', 'ENSG00000208014'),
(3554, 35270, 'MIR663B', 'microRNA 663b', 'non-coding RNA', 'ENSG00000221288'),
(3555, 43501, 'MIR664B', 'microRNA 664b', 'non-coding RNA', 'ENSG00000284450'),
(3556, 33135, 'MIR668', 'microRNA 668', 'non-coding RNA', 'ENSG00000276352'),
(3557, 37304, 'MIR670', 'microRNA 670', 'non-coding RNA', 'ENSG00000211568'),
(3558, 33133, 'MIR758', 'microRNA 758', 'non-coding RNA', 'ENSG00000211582'),
(3559, 33666, 'MIR760', 'microRNA 760', 'non-coding RNA', 'ENSG00000211575'),
(3560, 37303, 'MIR762', 'microRNA 762', 'non-coding RNA', 'ENSG00000211591'),
(3561, 33663, 'MIR873', 'microRNA 873', 'non-coding RNA', 'ENSG00000215939'),
(3562, 33643, 'MIR874', 'microRNA 874', 'non-coding RNA', 'ENSG00000216009'),
(3563, 33649, 'MIR892B', 'microRNA 892b', 'non-coding RNA', 'ENSG00000216098'),
(3564, 33670, 'MIR920', 'microRNA 920', 'non-coding RNA', 'ENSG00000216192'),
(3565, 33671, 'MIR921', 'microRNA 921', 'non-coding RNA', 'ENSG00000215952'),
(3566, 33676, 'MIR933', 'microRNA 933', 'non-coding RNA', 'ENSG00000215973'),
(3567, 33685, 'MIR941-2', 'microRNA 941-2', 'non-coding RNA', 'ENSG00000216141'),
(3568, 35264, 'MIR1183', 'microRNA 1183', 'non-coding RNA', 'ENSG00000221783'),
(3569, 37059, 'MIR1204', 'microRNA 1204', 'non-coding RNA', 'ENSG00000283710'),
(3570, 35272, 'MIR1206', 'microRNA 1206', 'non-coding RNA', 'ENSG00000283200'),
(3571, 33931, 'MIR1225', 'microRNA 1225', 'non-coding RNA', 'ENSG00000221656'),
(3572, 33924, 'MIR1229', 'microRNA 1229', 'non-coding RNA', 'ENSG00000221394'),
(3573, 33933, 'MIR1238', 'microRNA 1238', 'non-coding RNA', 'ENSG00000221410'),
(3574, 38321, 'MIR1244-2', 'microRNA 1244-2', 'non-coding RNA', 'ENSG00000283498'),
(3575, 50831, 'MIR1244-4', 'microRNA 1244-4', 'non-coding RNA', 'ENSG00000283475'),
(3576, 35311, 'MIR1245A', 'microRNA 1245a', 'non-coding RNA', 'ENSG00000221502'),
(3577, 35365, 'MIR1252', 'microRNA 1252', 'non-coding RNA', 'ENSG00000221788'),
(3578, 35325, 'MIR1260A', 'microRNA 1260a', 'non-coding RNA', 'ENSG00000221754'),
(3579, 35246, 'MIR1264', 'microRNA 1264', 'non-coding RNA', 'ENSG00000276158'),
(3580, 35332, 'MIR1265', 'microRNA 1265', 'non-coding RNA', 'ENSG00000221371'),
(3581, 35335, 'MIR1267', 'microRNA 1267', 'non-coding RNA', 'ENSG00000221650'),
(3582, 35339, 'MIR1272', 'microRNA 1272', 'non-coding RNA', 'ENSG00000221033'),
(3583, 35347, 'MIR1276', 'microRNA 1276', 'non-coding RNA', 'ENSG00000221634'),
(3584, 35356, 'MIR1278', 'microRNA 1278', 'non-coding RNA', 'ENSG00000221680'),
(3585, 35255, 'MIR1283-1', 'microRNA 1283-1', 'non-coding RNA', 'ENSG00000221421'),
(3586, 35362, 'MIR1284', 'microRNA 1284', 'non-coding RNA', 'ENSG00000221264'),
(3587, 35280, 'MIR1287', 'microRNA 1287', 'non-coding RNA', 'ENSG00000284415'),
(3588, 35283, 'MIR1290', 'microRNA 1290', 'non-coding RNA', 'ENSG00000221662'),
(3589, 52482, 'MIR1302-2HG', 'MIR1302-2 host gene', 'non-coding RNA', 'ENSG00000243485'),
(3590, 35371, 'MIR1306', 'microRNA 1306', 'non-coding RNA', 'ENSG00000284464'),
(3591, 35378, 'MIR1469', 'microRNA 1469', 'non-coding RNA', 'ENSG00000283888'),
(3592, 35393, 'MIR1909', 'microRNA 1909', 'non-coding RNA', 'ENSG00000284216'),
(3593, 35398, 'MIR1914', 'microRNA 1914', 'non-coding RNA', 'ENSG00000284433'),
(3594, 37068, 'MIR2052', 'microRNA 2052', 'non-coding RNA', 'ENSG00000283188'),
(3595, 37058, 'MIR2113', 'microRNA 2113', 'non-coding RNA', 'ENSG00000238367'),
(3596, 37311, 'MIR2117', 'microRNA 2117', 'non-coding RNA', 'ENSG00000284344'),
(3597, 38268, 'MIR3074', 'microRNA 3074', 'non-coding RNA', 'ENSG00000207617'),
(3598, 38371, 'MIR3115', 'microRNA 3115', 'non-coding RNA', 'ENSG00000263793'),
(3599, 38385, 'MIR3117', 'microRNA 3117', 'non-coding RNA', 'ENSG00000264720'),
(3600, 38287, 'MIR3118-4', 'microRNA 3118-4', 'non-coding RNA', 'ENSG00000265793'),
(3601, 38253, 'MIR3119-1', 'microRNA 3119-1', 'non-coding RNA', 'ENSG00000283340'),
(3602, 38259, 'MIR3121', 'microRNA 3121', 'non-coding RNA', 'ENSG00000265435'),
(3603, 38217, 'MIR3129', 'microRNA 3129', 'non-coding RNA', 'ENSG00000264725'),
(3604, 38254, 'MIR3134', 'microRNA 3134', 'non-coding RNA', 'ENSG00000264354'),
(3605, 38263, 'MIR3137', 'microRNA 3137', 'non-coding RNA', 'ENSG00000265333'),
(3606, 38297, 'MIR3142', 'microRNA 3142', 'non-coding RNA', 'ENSG00000265237'),
(3607, 56144, 'MIR3147HG', 'MIR3147 host gene', 'non-coding RNA', 'ENSG00000260653'),
(3608, 38362, 'MIR3150A', 'microRNA 3150a', 'non-coding RNA', 'ENSG00000283522'),
(3609, 38176, 'MIR3154', 'microRNA 3154', 'non-coding RNA', 'ENSG00000264823'),
(3610, 38196, 'MIR3158-1', 'microRNA 3158-1', 'non-coding RNA', 'ENSG00000263436'),
(3611, 38285, 'MIR3161', 'microRNA 3161', 'non-coding RNA', 'ENSG00000263693'),
(3612, 38288, 'MIR3164', 'microRNA 3164', 'non-coding RNA', 'ENSG00000265539'),
(3613, 38242, 'MIR3167', 'microRNA 3167', 'non-coding RNA', 'ENSG00000266215'),
(3614, 38264, 'MIR3174', 'microRNA 3174', 'non-coding RNA', 'ENSG00000265871'),
(3615, 38353, 'MIR3179-1', 'microRNA 3179-1', 'non-coding RNA', 'ENSG00000284305'),
(3616, 38239, 'MIR3180-3', 'microRNA 3180-3', 'non-coding RNA', 'ENSG00000266291'),
(3617, 38311, 'MIR3186', 'microRNA 3186', 'non-coding RNA', 'ENSG00000266189'),
(3618, 38222, 'MIR3191', 'microRNA 3191', 'non-coding RNA', 'ENSG00000284411'),
(3619, 38294, 'MIR3199-1', 'microRNA 3199-1', 'non-coding RNA', 'ENSG00000264073'),
(3620, 38227, 'MIR3200', 'microRNA 3200', 'non-coding RNA', 'ENSG00000264661'),
(3621, 38922, 'MIR3605', 'microRNA 3605', 'non-coding RNA', 'ENSG00000284154'),
(3622, 38998, 'MIR3619', 'microRNA 3619', 'non-coding RNA', 'ENSG00000266533'),
(3623, 38917, 'MIR3620', 'microRNA 3620', 'non-coding RNA', 'ENSG00000284163'),
(3624, 38930, 'MIR3621', 'microRNA 3621', 'non-coding RNA', 'ENSG00000263697'),
(3625, 38961, 'MIR3622B', 'microRNA 3622b', 'non-coding RNA', 'ENSG00000265075'),
(3626, 38894, 'MIR3652', 'microRNA 3652', 'non-coding RNA', 'ENSG00000284503'),
(3627, 38960, 'MIR3655', 'microRNA 3655', 'non-coding RNA', 'ENSG00000284325'),
(3628, 38906, 'MIR3657', 'microRNA 3657', 'non-coding RNA', 'ENSG00000266370'),
(3629, 54306, 'MIR3659HG', 'MIR3659 host gene', 'non-coding RNA', 'ENSG00000224592'),
(3630, 38985, 'MIR3660', 'microRNA 3660', 'non-coding RNA', 'ENSG00000264342'),
(3631, 38958, 'MIR3663', 'microRNA 3663', 'non-coding RNA', 'ENSG00000266782'),
(3632, 38982, 'MIR3668', 'microRNA 3668', 'non-coding RNA', 'ENSG00000263514'),
(3633, 50828, 'MIR3670-4', 'microRNA 3670-4', 'non-coding RNA', 'ENSG00000274025'),
(3634, 38925, 'MIR3671', 'microRNA 3671', 'non-coding RNA', 'ENSG00000265996'),
(3635, 55382, 'MIR3677HG', 'MIR3677 and MIR940 host gene', 'non-coding RNA', 'ENSG00000260778'),
(3636, 38994, 'MIR3681', 'microRNA 3681', 'non-coding RNA', 'ENSG00000264089'),
(3637, 41735, 'MIR3688-2', 'microRNA 3688-2', 'non-coding RNA', 'ENSG00000283379'),
(3638, 38924, 'MIR3689B', 'microRNA 3689b', 'non-coding RNA', 'ENSG00000264163'),
(3639, 38928, 'MIR3714', 'microRNA 3714', 'non-coding RNA', 'ENSG00000283885'),
(3640, 38966, 'MIR3910-1', 'microRNA 3910-1', 'non-coding RNA', 'ENSG00000266855'),
(3641, 38962, 'MIR3911', 'microRNA 3911', 'non-coding RNA', 'ENSG00000283874'),
(3642, 38953, 'MIR3913-2', 'microRNA 3913-2', 'non-coding RNA', 'ENSG00000283677'),
(3643, 38984, 'MIR3924', 'microRNA 3924', 'non-coding RNA', 'ENSG00000264747'),
(3644, 38959, 'MIR3926-1', 'microRNA 3926-1', 'non-coding RNA', 'ENSG00000266206'),
(3645, 38933, 'MIR3928', 'microRNA 3928', 'non-coding RNA', 'ENSG00000264141'),
(3646, 38893, 'MIR3940', 'microRNA 3940', 'non-coding RNA', 'ENSG00000284159'),
(3647, 38954, 'MIR3945', 'microRNA 3945', 'non-coding RNA', 'ENSG00000266698'),
(3648, 41756, 'MIR3973', 'microRNA 3973', 'non-coding RNA', 'ENSG00000263389'),
(3649, 41630, 'MIR3978', 'microRNA 3978', 'non-coding RNA', 'ENSG00000265584'),
(3650, 38370, 'MIR4251', 'microRNA 4251', 'non-coding RNA', 'ENSG00000283572'),
(3651, 38231, 'MIR4253', 'microRNA 4253', 'non-coding RNA', 'ENSG00000264014'),
(3652, 38312, 'MIR4257', 'microRNA 4257', 'non-coding RNA', 'ENSG00000264553'),
(3653, 38281, 'MIR4258', 'microRNA 4258', 'non-coding RNA', 'ENSG00000264349'),
(3654, 38291, 'MIR4269', 'microRNA 4269', 'non-coding RNA', 'ENSG00000265215'),
(3655, 38334, 'MIR4280', 'microRNA 4280', 'non-coding RNA', 'ENSG00000265919'),
(3656, 38322, 'MIR4284', 'microRNA 4284', 'non-coding RNA', 'ENSG00000265724'),
(3657, 38278, 'MIR4289', 'microRNA 4289', 'non-coding RNA', 'ENSG00000265873'),
(3658, 38220, 'MIR4295', 'microRNA 4295', 'non-coding RNA', 'ENSG00000264763'),
(3659, 38329, 'MIR4299', 'microRNA 4299', 'non-coding RNA', 'ENSG00000266645'),
(3660, 52004, 'MIR4307HG', 'MIR4307 host gene', 'non-coding RNA', 'ENSG00000257612'),
(3661, 38191, 'MIR4314', 'microRNA 4314', 'non-coding RNA', 'ENSG00000264005'),
(3662, 38394, 'MIR4323', 'microRNA 4323', 'non-coding RNA', 'ENSG00000266226'),
(3663, 38304, 'MIR4325', 'microRNA 4325', 'non-coding RNA', 'ENSG00000266666'),
(3664, 38273, 'MIR4330', 'microRNA 4330', 'non-coding RNA', 'ENSG00000265789'),
(3665, 41678, 'MIR4427', 'microRNA 4427', 'non-coding RNA', 'ENSG00000265744'),
(3666, 41646, 'MIR4430', 'microRNA 4430', 'non-coding RNA', 'ENSG00000283591'),
(3667, 41649, 'MIR4432', 'microRNA 4432', 'non-coding RNA', 'ENSG00000266078'),
(3668, 41634, 'MIR4433A', 'microRNA 4433a', 'non-coding RNA', 'ENSG00000283222'),
(3669, 41837, 'MIR4435-2', 'microRNA 4435-2', 'non-coding RNA', 'ENSG00000266139'),
(3670, 41553, 'MIR4454', 'microRNA 4454', 'non-coding RNA', 'ENSG00000283468'),
(3671, 41549, 'MIR4462', 'microRNA 4462', 'non-coding RNA', 'ENSG00000263926'),
(3672, 41528, 'MIR4464', 'microRNA 4464', 'non-coding RNA', 'ENSG00000266760'),
(3673, 41726, 'MIR4466', 'microRNA 4466', 'non-coding RNA', 'ENSG00000271899'),
(3674, 41556, 'MIR4469', 'microRNA 4469', 'non-coding RNA', 'ENSG00000284062'),
(3675, 41833, 'MIR4470', 'microRNA 4470', 'non-coding RNA', 'ENSG00000264408'),
(3676, 41859, 'MIR4477A', 'microRNA 4477a', 'non-coding RNA', 'ENSG00000276029'),
(3677, 41759, 'MIR4478', 'microRNA 4478', 'non-coding RNA', 'ENSG00000266583'),
(3678, 41767, 'MIR4479', 'microRNA 4479', 'non-coding RNA', 'ENSG00000266507'),
(3679, 41566, 'MIR4486', 'microRNA 4486', 'non-coding RNA', 'ENSG00000265210'),
(3680, 41599, 'MIR4488', 'microRNA 4488', 'non-coding RNA', 'ENSG00000266006'),
(3681, 41624, 'MIR4504', 'microRNA 4504', 'non-coding RNA', 'ENSG00000264712'),
(3682, 41610, 'MIR4509-3', 'microRNA 4509-3', 'non-coding RNA', 'ENSG00000263964'),
(3683, 41878, 'MIR4517', 'microRNA 4517', 'non-coding RNA', 'ENSG00000284541'),
(3684, 41839, 'MIR4520-2', 'microRNA 4520-2', 'non-coding RNA', 'ENSG00000283301'),
(3685, 41813, 'MIR4521', 'microRNA 4521', 'non-coding RNA', 'ENSG00000283160'),
(3686, 41764, 'MIR4530', 'microRNA 4530', 'non-coding RNA', 'ENSG00000266559'),
(3687, 41872, 'MIR4531', 'microRNA 4531', 'non-coding RNA', 'ENSG00000283673'),
(3688, 41692, 'MIR4534', 'microRNA 4534', 'non-coding RNA', 'ENSG00000284266'),
(3689, 41682, 'MIR4537', 'microRNA 4537', 'non-coding RNA', 'ENSG00000264781'),
(3690, 41593, 'MIR4632', 'microRNA 4632', 'non-coding RNA', 'ENSG00000263676'),
(3691, 41841, 'MIR4638', 'microRNA 4638', 'non-coding RNA', 'ENSG00000264732'),
(3692, 41558, 'MIR4669', 'microRNA 4669', 'non-coding RNA', 'ENSG00000263897'),
(3693, 41729, 'MIR4674', 'microRNA 4674', 'non-coding RNA', 'ENSG00000265181'),
(3694, 41890, 'MIR4679-2', 'microRNA 4679-2', 'non-coding RNA', 'ENSG00000265375'),
(3695, 41753, 'MIR4681', 'microRNA 4681', 'non-coding RNA', 'ENSG00000265719'),
(3696, 41707, 'MIR4690', 'microRNA 4690', 'non-coding RNA', 'ENSG00000266041'),
(3697, 41818, 'MIR4693', 'microRNA 4693', 'non-coding RNA', 'ENSG00000264200'),
(3698, 41576, 'MIR4706', 'microRNA 4706', 'non-coding RNA', 'ENSG00000266531'),
(3699, 41690, 'MIR4709', 'microRNA 4709', 'non-coding RNA', 'ENSG00000283944'),
(3700, 41847, 'MIR4711', 'microRNA 4711', 'non-coding RNA', 'ENSG00000266150'),
(3701, 41763, 'MIR4714', 'microRNA 4714', 'non-coding RNA', 'ENSG00000264480'),
(3702, 41705, 'MIR4720', 'microRNA 4720', 'non-coding RNA', 'ENSG00000284473'),
(3703, 41609, 'MIR4721', 'microRNA 4721', 'non-coding RNA', 'ENSG00000283845'),
(3704, 41590, 'MIR4724', 'microRNA 4724', 'non-coding RNA', 'ENSG00000284424'),
(3705, 41608, 'MIR4725', 'microRNA 4725', 'non-coding RNA', 'ENSG00000265976'),
(3706, 41597, 'MIR4731', 'microRNA 4731', 'non-coding RNA', 'ENSG00000265110'),
(3707, 41661, 'MIR4741', 'microRNA 4741', 'non-coding RNA', 'ENSG00000284331'),
(3708, 41786, 'MIR4754', 'microRNA 4754', 'non-coding RNA', 'ENSG00000266640'),
(3709, 41529, 'MIR4756', 'microRNA 4756', 'non-coding RNA', 'ENSG00000265595'),
(3710, 41714, 'MIR4764', 'microRNA 4764', 'non-coding RNA', 'ENSG00000266012'),
(3711, 41680, 'MIR4766', 'microRNA 4766', 'non-coding RNA', 'ENSG00000266594'),
(3712, 41901, 'MIR4771-1', 'microRNA 4771-1', 'non-coding RNA', 'ENSG00000264793'),
(3713, 41631, 'MIR4776-2', 'microRNA 4776-2', 'non-coding RNA', 'ENSG00000283637'),
(3714, 41635, 'MIR4782', 'microRNA 4782', 'non-coding RNA', 'ENSG00000265429'),
(3715, 41584, 'MIR4799', 'microRNA 4799', 'non-coding RNA', 'ENSG00000264274'),
(3716, 41877, 'MIR4800', 'microRNA 4800', 'non-coding RNA', 'ENSG00000284276'),
(3717, 43462, 'MIR5001', 'microRNA 5001', 'non-coding RNA', 'ENSG00000284407'),
(3718, 43547, 'MIR5090', 'microRNA 5090', 'non-coding RNA', 'ENSG00000284176'),
(3719, 43467, 'MIR5092', 'microRNA 5092', 'non-coding RNA', 'ENSG00000264986'),
(3720, 43534, 'MIR5193', 'microRNA 5193', 'non-coding RNA', 'ENSG00000283726'),
(3721, 43498, 'MIR5194', 'microRNA 5194', 'non-coding RNA', 'ENSG00000264653'),
(3722, 43542, 'MIR5196', 'microRNA 5196', 'non-coding RNA', 'ENSG00000284034'),
(3723, 43450, 'MIR5197', 'microRNA 5197', 'non-coding RNA', 'ENSG00000266478'),
(3724, 43513, 'MIR5571', 'microRNA 5571', 'non-coding RNA', 'ENSG00000264824'),
(3725, 43527, 'MIR5581', 'microRNA 5581', 'non-coding RNA', 'ENSG00000263675'),
(3726, 43461, 'MIR5582', 'microRNA 5582', 'non-coding RNA', 'ENSG00000263540'),
(3727, 43491, 'MIR5583-1', 'microRNA 5583-1', 'non-coding RNA', 'ENSG00000266148'),
(3728, 43508, 'MIR5587', 'microRNA 5587', 'non-coding RNA', 'ENSG00000266124'),
(3729, 43541, 'MIR5590', 'microRNA 5590', 'non-coding RNA', 'ENSG00000263783'),
(3730, 43518, 'MIR5681A', 'microRNA 5681a', 'non-coding RNA', 'ENSG00000266502'),
(3731, 43453, 'MIR5683', 'microRNA 5683', 'non-coding RNA', 'ENSG00000283616'),
(3732, 43543, 'MIR5685', 'microRNA 5685', 'non-coding RNA', 'ENSG00000264056'),
(3733, 43545, 'MIR5691', 'microRNA 5691', 'non-coding RNA', 'ENSG00000264984'),
(3734, 43535, 'MIR5692B', 'microRNA 5692b', 'non-coding RNA', 'ENSG00000264580'),
(3735, 43448, 'MIR5692C2', 'microRNA 5692c-2', 'non-coding RNA', 'ENSG00000266668'),
(3736, 43487, 'MIR5698', 'microRNA 5698', 'non-coding RNA', 'ENSG00000263987'),
(3737, 43522, 'MIR5701-1', 'microRNA 5701-1', 'non-coding RNA', 'ENSG00000266545'),
(3738, 50844, 'MIR5701-3', 'microRNA 5701-3', 'non-coding RNA', 'ENSG00000264902'),
(3739, 43469, 'MIR5704', 'microRNA 5704', 'non-coding RNA', 'ENSG00000265859'),
(3740, 49950, 'MIR6070', 'microRNA 6070', 'non-coding RNA', 'ENSG00000278433'),
(3741, 50198, 'MIR6075', 'microRNA 6075', 'non-coding RNA', 'ENSG00000273742'),
(3742, 50142, 'MIR6080', 'microRNA 6080', 'non-coding RNA', 'ENSG00000278581'),
(3743, 50164, 'MIR6088', 'microRNA 6088', 'non-coding RNA', 'ENSG00000275726'),
(3744, 50033, 'MIR6501', 'microRNA 6501', 'non-coding RNA', 'ENSG00000284448'),
(3745, 50199, 'MIR6507', 'microRNA 6507', 'non-coding RNA', 'ENSG00000274056'),
(3746, 50217, 'MIR6508', 'microRNA 6508', 'non-coding RNA', 'ENSG00000275523'),
(3747, 50230, 'MIR6511B2', 'microRNA 6511b-2', 'non-coding RNA', 'ENSG00000283346'),
(3748, 50048, 'MIR6716', 'microRNA 6716', 'non-coding RNA', 'ENSG00000284246'),
(3749, 50830, 'MIR6724-4', 'microRNA 6724-4', 'non-coding RNA', 'ENSG00000275692'),
(3750, 50072, 'MIR6736', 'microRNA 6736', 'non-coding RNA', 'ENSG00000278549'),
(3751, 49939, 'MIR6738', 'microRNA 6738', 'non-coding RNA', 'ENSG00000277817'),
(3752, 50090, 'MIR6742', 'microRNA 6742', 'non-coding RNA', 'ENSG00000284311'),
(3753, 50020, 'MIR6752', 'microRNA 6752', 'non-coding RNA', 'ENSG00000276769'),
(3754, 50255, 'MIR6753', 'microRNA 6753', 'non-coding RNA', 'ENSG00000275022'),
(3755, 50038, 'MIR6758', 'microRNA 6758', 'non-coding RNA', 'ENSG00000284152'),
(3756, 50139, 'MIR6763', 'microRNA 6763', 'non-coding RNA', 'ENSG00000277052'),
(3757, 50132, 'MIR6773', 'microRNA 6773', 'non-coding RNA', 'ENSG00000284259'),
(3758, 50193, 'MIR6776', 'microRNA 6776', 'non-coding RNA', 'ENSG00000273606'),
(3759, 50159, 'MIR6783', 'microRNA 6783', 'non-coding RNA', 'ENSG00000278223'),
(3760, 49970, 'MIR6786', 'microRNA 6786', 'non-coding RNA', 'ENSG00000277784'),
(3761, 50094, 'MIR6789', 'microRNA 6789', 'non-coding RNA', 'ENSG00000284129'),
(3762, 50031, 'MIR6795', 'microRNA 6795', 'non-coding RNA', 'ENSG00000275711'),
(3763, 50186, 'MIR6796', 'microRNA 6796', 'non-coding RNA', 'ENSG00000275652'),
(3764, 50178, 'MIR6801', 'microRNA 6801', 'non-coding RNA', 'ENSG00000274380'),
(3765, 50191, 'MIR6807', 'microRNA 6807', 'non-coding RNA', 'ENSG00000275924'),
(3766, 50112, 'MIR6817', 'microRNA 6817', 'non-coding RNA', 'ENSG00000277872'),
(3767, 49980, 'MIR6821', 'microRNA 6821', 'non-coding RNA', 'ENSG00000276753'),
(3768, 49999, 'MIR6822', 'microRNA 6822', 'non-coding RNA', 'ENSG00000284158'),
(3769, 49946, 'MIR6824', 'microRNA 6824', 'non-coding RNA', 'ENSG00000284364'),
(3770, 49936, 'MIR6831', 'microRNA 6831', 'non-coding RNA', 'ENSG00000283717'),
(3771, 50140, 'MIR6832', 'microRNA 6832', 'non-coding RNA', 'ENSG00000274494'),
(3772, 50245, 'MIR6833', 'microRNA 6833', 'non-coding RNA', 'ENSG00000277264'),
(3773, 50067, 'MIR6836', 'microRNA 6836', 'non-coding RNA', 'ENSG00000284047'),
(3774, 50254, 'MIR6842', 'microRNA 6842', 'non-coding RNA', 'ENSG00000273836'),
(3775, 50240, 'MIR6843', 'microRNA 6843', 'non-coding RNA', 'ENSG00000284280'),
(3776, 50022, 'MIR6847', 'microRNA 6847', 'non-coding RNA', 'ENSG00000284200'),
(3777, 50176, 'MIR6848', 'microRNA 6848', 'non-coding RNA', 'ENSG00000284229'),
(3778, 49991, 'MIR6849', 'microRNA 6849', 'non-coding RNA', 'ENSG00000283770'),
(3779, 50093, 'MIR6850', 'microRNA 6850', 'non-coding RNA', 'ENSG00000283764'),
(3780, 50242, 'MIR6856', 'microRNA 6856', 'non-coding RNA', 'ENSG00000277713'),
(3781, 50250, 'MIR6858', 'microRNA 6858', 'non-coding RNA', 'ENSG00000276350'),
(3782, 50840, 'MIR6859-4', 'microRNA 6859-4', 'non-coding RNA', 'ENSG00000278739'),
(3783, 50226, 'MIR6864', 'microRNA 6864', 'non-coding RNA', 'ENSG00000274300'),
(3784, 50096, 'MIR6868', 'microRNA 6868', 'non-coding RNA', 'ENSG00000275360'),
(3785, 50231, 'MIR6873', 'microRNA 6873', 'non-coding RNA', 'ENSG00000284517'),
(3786, 50269, 'MIR6878', 'microRNA 6878', 'non-coding RNA', 'ENSG00000283933'),
(3787, 49957, 'MIR6879', 'microRNA 6879', 'non-coding RNA', 'ENSG00000278851'),
(3788, 50121, 'MIR6886', 'microRNA 6886', 'non-coding RNA', 'ENSG00000284553'),
(3789, 50130, 'MIR6893', 'microRNA 6893', 'non-coding RNA', 'ENSG00000276598'),
(3790, 49938, 'MIR6894', 'microRNA 6894', 'non-coding RNA', 'ENSG00000277474'),
(3791, 50149, 'MIR7112', 'microRNA 7112', 'non-coding RNA', 'ENSG00000284054'),
(3792, 50170, 'MIR7151', 'microRNA 7151', 'non-coding RNA', 'ENSG00000276866'),
(3793, 50190, 'MIR7153', 'microRNA 7153', 'non-coding RNA', 'ENSG00000283492'),
(3794, 49978, 'MIR7159', 'microRNA 7159', 'non-coding RNA', 'ENSG00000276824'),
(3795, 50028, 'MIR7160', 'microRNA 7160', 'non-coding RNA', 'ENSG00000273593'),
(3796, 50189, 'MIR7162', 'microRNA 7162', 'non-coding RNA', 'ENSG00000284277'),
(3797, 49839, 'MIR7515', 'microRNA 7515', 'non-coding RNA', 'ENSG00000283394'),
(3798, 50089, 'MIR7704', 'microRNA 7704', 'non-coding RNA', 'ENSG00000283880'),
(3799, 50044, 'MIR7844', 'microRNA 7844', 'non-coding RNA', 'ENSG00000283818'),
(3800, 50153, 'MIR7847', 'microRNA 7847', 'non-coding RNA', 'ENSG00000284594'),
(3801, 50058, 'MIR7848', 'microRNA 7848', 'non-coding RNA', 'ENSG00000276961'),
(3802, 50080, 'MIR7973-2', 'microRNA 7973-2', 'non-coding RNA', 'ENSG00000283614'),
(3803, 49992, 'MIR7974', 'microRNA 7974', 'non-coding RNA', 'ENSG00000274713'),
(3804, 50092, 'MIR7976', 'microRNA 7976', 'non-coding RNA', 'ENSG00000276083'),
(3805, 50177, 'MIR8054', 'microRNA 8054', 'non-coding RNA', 'ENSG00000275868'),
(3806, 50241, 'MIR8055', 'microRNA 8055', 'non-coding RNA', 'ENSG00000276580'),
(3807, 50018, 'MIR8058', 'microRNA 8058', 'non-coding RNA', 'ENSG00000277387'),
(3808, 50180, 'MIR8060', 'microRNA 8060', 'non-coding RNA', 'ENSG00000278103'),
(3809, 50236, 'MIR8064', 'microRNA 8064', 'non-coding RNA', 'ENSG00000275789'),
(3810, 49934, 'MIR8067', 'microRNA 8067', 'non-coding RNA', 'ENSG00000277919'),
(3811, 50174, 'MIR8072', 'microRNA 8072', 'non-coding RNA', 'ENSG00000284425'),
(3812, 49997, 'MIR8076', 'microRNA 8076', 'non-coding RNA', 'ENSG00000275670'),
(3813, 50107, 'MIR8086', 'microRNA 8086', 'non-coding RNA', 'ENSG00000275036'),
(3814, 31481, 'MIRLET7D', 'microRNA let-7d', 'non-coding RNA', 'ENSG00000199133'),
(3815, 27000, 'MISP', 'mitotic spindle positioning', 'protein-coding gene', 'ENSG00000099812'),
(3816, 45026, 'MIX23P3', 'MIX23 pseudogene 3', 'pseudogene', 'ENSG00000267076'),
(3817, 7108, 'MKKS', 'MKKS centrosomal shuttling protein', 'protein-coding gene', 'ENSG00000125863'),
(3818, 7110, 'MKNK1', 'MAPK interacting serine/threonine kinase 1', 'protein-coding gene', 'ENSG00000079277'),
(3819, 7117, 'MKRN5P', 'makorin ring finger protein 5, pseudogene', 'pseudogene', 'ENSG00000224430'),
(3820, 7125, 'MLF1', 'myeloid leukemia factor 1', 'protein-coding gene', 'ENSG00000178053'),
(3821, 41461, 'MLIP-IT1', 'MLIP intronic transcript 1', 'non-coding RNA', 'ENSG00000236996'),
(3822, 26617, 'MLKL', 'mixed lineage kinase domain like pseudokinase', 'protein-coding gene', 'ENSG00000168404'),
(3823, 15794, 'MLLT10P1', 'MLLT10 pseudogene 1', 'pseudogene', 'ENSG00000238151'),
(3824, 7141, 'MLN', 'motilin', 'protein-coding gene', 'ENSG00000096395'),
(3825, 29643, 'MLPH', 'melanophilin', 'protein-coding gene', 'ENSG00000115648'),
(3826, 24825, 'MLST8', 'MTOR associated protein, LST8 homolog', 'protein-coding gene', 'ENSG00000167965'),
(3827, 19331, 'MMAB', 'metabolism of cobalamin associated B', 'protein-coding gene', 'ENSG00000139428'),
(3828, 24525, 'MMACHC', 'metabolism of cobalamin associated C', 'protein-coding gene', 'ENSG00000132763'),
(3829, 41087, 'MMADHC-DT', 'MMADHC divergent transcript', 'non-coding RNA', 'ENSG00000231969'),
(3830, 54996, 'MMADHCP1', 'MMADHC pseudogene 1', 'pseudogene', 'ENSG00000237252'),
(3831, 40376, 'MME-AS1', 'MME antisense RNA 1', 'non-coding RNA', 'ENSG00000240666'),
(3832, 7159, 'MMP13', 'matrix metallopeptidase 13', 'protein-coding gene', 'ENSG00000137745'),
(3833, 7167, 'MMP20', 'matrix metallopeptidase 20', 'protein-coding gene', 'ENSG00000137674'),
(3834, 14357, 'MMP21', 'matrix metallopeptidase 21', 'protein-coding gene', 'ENSG00000154485'),
(3835, 7170, 'MMP23A', 'matrix metallopeptidase 23A (pseudogene)', 'pseudogene', 'ENSG00000215914'),
(3836, 7171, 'MMP23B', 'matrix metallopeptidase 23B', 'protein-coding gene', 'ENSG00000189409'),
(3837, 44421, 'MMP24OS', 'MMP24 opposite strand', 'protein-coding gene', 'ENSG00000126005'),
(3838, 51372, 'MMP25-AS1', 'MMP25 antisense RNA 1', 'non-coding RNA', 'ENSG00000261971'),
(3839, 14249, 'MMP26', 'matrix metallopeptidase 26', 'protein-coding gene', 'ENSG00000167346'),
(3840, 7178, 'MMRN1', 'multimerin 1', 'protein-coding gene', 'ENSG00000138722'),
(3841, 13824, 'MMS19', 'MMS19 homolog, cytosolic iron-sulfur assembly component', 'protein-coding gene', 'ENSG00000155229'),
(3842, 7526, 'MMUT', 'methylmalonyl-CoA mutase', 'protein-coding gene', 'ENSG00000146085'),
(3843, 7181, 'MNAT1', 'MNAT1 component of CDK activating kinase', 'protein-coding gene', 'ENSG00000020426'),
(3844, 24839, 'MND1', 'meiotic nuclear divisions 1', 'protein-coding gene', 'ENSG00000121211'),
(3845, 42639, 'MOB1AP2', 'MOB kinase activator 1A pseudogene 2', 'pseudogene', 'ENSG00000233810'),
(3846, 54749, 'MOB4P1', 'MOB4 pseudogene 1', 'pseudogene', 'ENSG00000231386'),
(3847, 54750, 'MOB4P2', 'MOB4 pseudogene 2', 'pseudogene', 'ENSG00000271318'),
(3848, 7190, 'MOCS1', 'molybdenum cofactor synthesis 1', 'protein-coding gene', 'ENSG00000124615'),
(3849, 27417, 'MOCS2-DT', 'MOCS2 divergent transcript', 'non-coding RNA', 'ENSG00000247796'),
(3850, 18210, 'MOGAT1', 'monoacylglycerol O-acyltransferase 1', 'protein-coding gene', 'ENSG00000124003'),
(3851, 23249, 'MOGAT3', 'monoacylglycerol O-acyltransferase 3', 'protein-coding gene', 'ENSG00000106384'),
(3852, 25020, 'MON1B', 'MON1 homolog B, secretory trafficking associated', 'protein-coding gene', 'ENSG00000103111'),
(3853, 7198, 'MORC1', 'MORC family CW-type zinc finger 1', 'protein-coding gene', 'ENSG00000114487'),
(3854, 23572, 'MORC3', 'MORC family CW-type zinc finger 3', 'protein-coding gene', 'ENSG00000159256'),
(3855, 15773, 'MORF4', 'mortality factor 4 (pseudogene)', 'pseudogene', 'ENSG00000234801'),
(3856, 16989, 'MORF4L1', 'mortality factor 4 like 1', 'protein-coding gene', 'ENSG00000185787'),
(3857, 33605, 'MOXD2P', 'monooxygenase DBH like 2, pseudogene', 'pseudogene', 'ENSG00000240268'),
(3858, 55377, 'MPHOSPH6-DT', 'MPHOSPH6 divergent transcript', 'non-coding RNA', 'ENSG00000261029'),
(3859, 29810, 'MPHOSPH8', 'M-phase phosphoprotein 8', 'protein-coding gene', 'ENSG00000196199'),
(3860, 55694, 'MPHOSPH10P7', 'MPHOSPH10 pseudogene 7', 'pseudogene', 'ENSG00000261497'),
(3861, 20143, 'MPPE1P1', 'metallophosphoesterase 1 pseudogene 1', 'pseudogene', 'ENSG00000258990'),
(3862, 7224, 'MPV17', 'mitochondrial inner membrane protein MPV17', 'protein-coding gene', 'ENSG00000115204'),
(3863, 7226, 'MPZL1', 'myelin protein zero like 1', 'protein-coding gene', 'ENSG00000197965'),
(3864, 1304, 'MRAP', 'melanocortin 2 receptor accessory protein', 'protein-coding gene', 'ENSG00000170262'),
(3865, 21232, 'MRAP2', 'melanocortin 2 receptor accessory protein 2', 'protein-coding gene', 'ENSG00000135324'),
(3866, 7227, 'MRAS', 'muscle RAS oncogene homolog', 'protein-coding gene', 'ENSG00000158186'),
(3867, 7231, 'MRE11P1', 'MRE11 homolog, double strand break repair nuclease pseudogene 1', 'pseudogene', 'ENSG00000242537'),
(3868, 50749, 'MREGP1', 'melanoregulin pseudogene 1', 'pseudogene', 'ENSG00000270395'),
(3869, 24829, 'MRGPRG', 'MAS related GPR family member G', 'protein-coding gene', 'ENSG00000182170'),
(3870, 54335, 'MRGPRX11P', 'MAS related GPR family member X11, pseudogene', 'pseudogene', 'ENSG00000254738'),
(3871, 54337, 'MRGPRX13P', 'MAS related GPR family member X13, pseudogene', 'pseudogene', 'ENSG00000254546'),
(3872, 48649, 'MRLN', 'myoregulin', 'protein-coding gene', 'ENSG00000227877'),
(3873, 56030, 'MRNIP-DT', 'MRNIP divergent transcript', 'non-coding RNA', 'ENSG00000245317'),
(3874, 27936, 'MROH2A', 'maestro heat like repeat family member 2A', 'protein-coding gene', 'ENSG00000185038'),
(3875, 14277, 'MRPL9', 'mitochondrial ribosomal protein L9', 'protein-coding gene', 'ENSG00000143436'),
(3876, 14055, 'MRPL10', 'mitochondrial ribosomal protein L10', 'protein-coding gene', 'ENSG00000159111'),
(3877, 14279, 'MRPL14', 'mitochondrial ribosomal protein L14', 'protein-coding gene', 'ENSG00000180992'),
(3878, 14053, 'MRPL17', 'mitochondrial ribosomal protein L17', 'protein-coding gene', 'ENSG00000158042'),
(3879, 14478, 'MRPL20', 'mitochondrial ribosomal protein L20', 'protein-coding gene', 'ENSG00000242485'),
(3880, 29699, 'MRPL20P1', 'mitochondrial ribosomal protein L20 pseudogene 1', 'pseudogene', 'ENSG00000215734'),
(3881, 14479, 'MRPL21', 'mitochondrial ribosomal protein L21', 'protein-coding gene', 'ENSG00000197345'),
(3882, 42812, 'MRPL23-AS1', 'MRPL23 antisense RNA 1', 'non-coding RNA', 'ENSG00000226416'),
(3883, 29702, 'MRPL30P1', 'mitochondrial ribosomal protein L30 pseudogene 1', 'pseudogene', 'ENSG00000276576'),
(3884, 14487, 'MRPL33', 'mitochondrial ribosomal protein L33', 'protein-coding gene', 'ENSG00000243147'),
(3885, 14489, 'MRPL35', 'mitochondrial ribosomal protein L35', 'protein-coding gene', 'ENSG00000132313'),
(3886, 29708, 'MRPL36P1', 'mitochondrial ribosomal protein L36 pseudogene 1', 'pseudogene', 'ENSG00000225392'),
(3887, 14034, 'MRPL37', 'mitochondrial ribosomal protein L37', 'protein-coding gene', 'ENSG00000116221'),
(3888, 14027, 'MRPL39', 'mitochondrial ribosomal protein L39', 'protein-coding gene', 'ENSG00000154719'),
(3889, 14491, 'MRPL40', 'mitochondrial ribosomal protein L40', 'protein-coding gene', 'ENSG00000185608'),
(3890, 14517, 'MRPL43', 'mitochondrial ribosomal protein L43', 'protein-coding gene', 'ENSG00000055950'),
(3891, 16652, 'MRPL47', 'mitochondrial ribosomal protein L47', 'protein-coding gene', 'ENSG00000136522'),
(3892, 16654, 'MRPL50', 'mitochondrial ribosomal protein L50', 'protein-coding gene', 'ENSG00000136897'),
(3893, 16684, 'MRPL53', 'mitochondrial ribosomal protein L53', 'protein-coding gene', 'ENSG00000204822'),
(3894, 16685, 'MRPL54', 'mitochondrial ribosomal protein L54', 'protein-coding gene', 'ENSG00000183617'),
(3895, 29781, 'MRPS6P2', 'mitochondrial ribosomal protein S6 pseudogene 2', 'pseudogene', 'ENSG00000237130'),
(3896, 14499, 'MRPS7', 'mitochondrial ribosomal protein S7', 'protein-coding gene', 'ENSG00000125445'),
(3897, 40687, 'MRPS9-AS2', 'MRPS9 antisense RNA 2', 'non-coding RNA', 'ENSG00000224509'),
(3898, 29727, 'MRPS10P2', 'mitochondrial ribosomal protein S10 pseudogene 2', 'pseudogene', 'ENSG00000234325'),
(3899, 14048, 'MRPS16', 'mitochondrial ribosomal protein S16', 'protein-coding gene', 'ENSG00000182180'),
(3900, 16541, 'MRPS16P2', 'mitochondrial ribosomal protein S16 pseudogene 2', 'pseudogene', 'ENSG00000232925'),
(3901, 29737, 'MRPS17P5', 'mitochondrial ribosomal protein S17 pseudogene 5', 'pseudogene', 'ENSG00000274493'),
(3902, 29739, 'MRPS17P9', 'mitochondrial ribosomal protein S17 pseudogene 9', 'pseudogene', 'ENSG00000227814'),
(3903, 29747, 'MRPS18CP6', 'MRPS18C pseudogene 6', 'pseudogene', 'ENSG00000228807'),
(3904, 44530, 'MRPS18CP7', 'MRPS18C pseudogene 7', 'pseudogene', 'ENSG00000235916'),
(3905, 14508, 'MRPS22', 'mitochondrial ribosomal protein S22', 'protein-coding gene', 'ENSG00000175110'),
(3906, 14509, 'MRPS23', 'mitochondrial ribosomal protein S23', 'protein-coding gene', 'ENSG00000181610'),
(3907, 8769, 'MRPS30', 'mitochondrial ribosomal protein S30', 'protein-coding gene', 'ENSG00000112996'),
(3908, 16634, 'MRPS33', 'mitochondrial ribosomal protein S33', 'protein-coding gene', 'ENSG00000090263'),
(3909, 29774, 'MRPS36P4', 'mitochondrial ribosomal protein S36 pseudogene 4', 'pseudogene', 'ENSG00000255231'),
(3910, 7234, 'MRRF', 'mitochondrial ribosome recycling factor', 'protein-coding gene', 'ENSG00000148187'),
(3911, 20590, 'MRS2P1', 'MRS2 pseudogene 1', 'pseudogene', 'ENSG00000250428'),
(3912, 29819, 'MRTFB', 'myocardin related transcription factor B', 'protein-coding gene', 'ENSG00000186260'),
(3913, 14285, 'MS4A6E', 'membrane spanning 4-domains A6E', 'protein-coding gene', 'ENSG00000166926'),
(3914, 13370, 'MS4A12', 'membrane spanning 4-domains A12', 'protein-coding gene', 'ENSG00000071203'),
(3915, 37636, 'MS4A18', 'membrane spanning 4-domains A18', 'protein-coding gene', 'ENSG00000214782'),
(3916, 33741, 'MSANTD1', 'Myb/SANT DNA binding domain containing 1', 'protein-coding gene', 'ENSG00000188981'),
(3917, 55601, 'MSANTD2-AS1', 'MSANTD2 antisense RNA 1', 'non-coding RNA', 'ENSG00000245498'),
(3918, 38838, 'MSANTD3-TMEFF1', 'MSANTD3-TMEFF1 readthrough', 'other', 'ENSG00000251349'),
(3919, 7321, 'MSC', 'musculin', 'protein-coding gene', 'ENSG00000178860'),
(3920, 40319, 'MSH2-OT1', 'MSH2 overlapping transcript 1', 'non-coding RNA', 'ENSG00000235760'),
(3921, 7327, 'MSH4', 'mutS homolog 4', 'protein-coding gene', 'ENSG00000057468'),
(3922, 25544, 'MSL2', 'MSL complex subunit 2', 'protein-coding gene', 'ENSG00000174579'),
(3923, 7371, 'MSLN', 'mesothelin', 'protein-coding gene', 'ENSG00000102854'),
(3924, 17061, 'MSRB2', 'methionine sulfoxide reductase B2', 'protein-coding gene', 'ENSG00000148450'),
(3925, 7381, 'MST1R', 'macrophage stimulating 1 receptor', 'protein-coding gene', 'ENSG00000164078'),
(3926, 4223, 'MSTN', 'myostatin', 'protein-coding gene', 'ENSG00000138379'),
(3927, 24976, 'MSX2P1', 'msh homeobox 2 pseudogene 1', 'pseudogene', 'ENSG00000229590'),
(3928, 7414, 'MT-ATP6', 'mitochondrially encoded ATP synthase membrane subunit 6', 'protein-coding gene', 'ENSG00000198899'),
(3929, 7460, 'MT-ND4L', 'mitochondrially encoded NADH:ubiquinone oxidoreductase core subunit 4L', 'protein-coding gene', 'ENSG00000212907'),
(3930, 7461, 'MT-ND5', 'mitochondrially encoded NADH:ubiquinone oxidoreductase core subunit 5', 'protein-coding gene', 'ENSG00000198786'),
(3931, 7470, 'MT-RNR1', 'mitochondrially encoded 12S rRNA', 'non-coding RNA', 'ENSG00000211459'),
(3932, 7475, 'MT-TA', 'mitochondrially encoded tRNA-Ala (GCN)', 'non-coding RNA', 'ENSG00000210127'),
(3933, 7488, 'MT-TI', 'mitochondrially encoded tRNA-Ile (AUU/C)', 'non-coding RNA', 'ENSG00000210100'),
(3934, 7494, 'MT-TP', 'mitochondrially encoded tRNA-Pro (CCN)', 'non-coding RNA', 'ENSG00000210196'),
(3935, 7497, 'MT-TS1', 'mitochondrially encoded tRNA-Ser (UCN) 1', 'non-coding RNA', 'ENSG00000210151'),
(3936, 7395, 'MT1CP', 'metallothionein 1C, pseudogene', 'pseudogene', 'ENSG00000205360'),
(3937, 7397, 'MT1E', 'metallothionein 1E', 'protein-coding gene', 'ENSG00000169715'),
(3938, 7400, 'MT1H', 'metallothionein 1H', 'protein-coding gene', 'ENSG00000205358'),
(3939, 18705, 'MT4', 'metallothionein 4', 'protein-coding gene', 'ENSG00000102891'),
(3940, 7411, 'MTA2', 'metastasis associated 1 family member 2', 'protein-coding gene', 'ENSG00000149480'),
(3941, 44577, 'MTATP6P3', 'MT-ATP6 pseudogene 3', 'pseudogene', 'ENSG00000263483'),
(3942, 44583, 'MTATP6P9', 'MT-ATP6 pseudogene 9', 'pseudogene', 'ENSG00000248420'),
(3943, 52179, 'MTATP6P23', 'MT-ATP6 pseudogene 23', 'pseudogene', 'ENSG00000230755'),
(3944, 52181, 'MTATP6P25', 'MT-ATP6 pseudogene 25', 'pseudogene', 'ENSG00000262095'),
(3945, 44571, 'MTATP8P1', 'MT-ATP8 pseudogene 1', 'pseudogene', 'ENSG00000240409'),
(3946, 7417, 'MTBP', 'MDM2 binding protein', 'protein-coding gene', 'ENSG00000172167'),
(3947, 52010, 'MTCO1P8', 'MT-CO1 pseudogene 8', 'pseudogene', 'ENSG00000234700'),
(3948, 52013, 'MTCO1P11', 'MT-CO1 pseudogene 11', 'pseudogene', 'ENSG00000224083'),
(3949, 52016, 'MTCO1P14', 'MT-CO1 pseudogene 14', 'pseudogene', 'ENSG00000232551'),
(3950, 52017, 'MTCO1P15', 'MT-CO1 pseudogene 15', 'pseudogene', 'ENSG00000255350'),
(3951, 52019, 'MTCO1P17', 'MT-CO1 pseudogene 17', 'pseudogene', 'ENSG00000223619'),
(3952, 52021, 'MTCO1P19', 'MT-CO1 pseudogene 19', 'pseudogene', 'ENSG00000237300'),
(3953, 52092, 'MTCO1P27', 'MT-CO1 pseudogene 27', 'pseudogene', 'ENSG00000232579'),
(3954, 52113, 'MTCO1P48', 'MT-CO1 pseudogene 48', 'pseudogene', 'ENSG00000237055'),
(3955, 52116, 'MTCO1P51', 'MT-CO1 pseudogene 51', 'pseudogene', 'ENSG00000232981'),
(3956, 16564, 'MTCO2P1', 'MT-CO2 pseudogene 1', 'pseudogene', 'ENSG00000229690'),
(3957, 52149, 'MTCO2P20', 'MT-CO2 pseudogene 20', 'pseudogene', 'ENSG00000231576'),
(3958, 52150, 'MTCO2P21', 'MT-CO2 pseudogene 21', 'pseudogene', 'ENSG00000236689'),
(3959, 31342, 'MTCO3P1', 'MT-CO3 pseudogene 1', 'pseudogene', 'ENSG00000235040'),
(3960, 52037, 'MTCO3P7', 'MT-CO3 pseudogene 7', 'pseudogene', 'ENSG00000249997'),
(3961, 52046, 'MTCO3P16', 'MT-CO3 pseudogene 16', 'pseudogene', 'ENSG00000227736'),
(3962, 52048, 'MTCO3P18', 'MT-CO3 pseudogene 18', 'pseudogene', 'ENSG00000227661'),
(3963, 52125, 'MTCO3P22', 'MT-CO3 pseudogene 22', 'pseudogene', 'ENSG00000270388'),
(3964, 52127, 'MTCO3P24', 'MT-CO3 pseudogene 24', 'pseudogene', 'ENSG00000262158'),
(3965, 52130, 'MTCO3P27', 'MT-CO3 pseudogene 27', 'pseudogene', 'ENSG00000251430'),
(3966, 52134, 'MTCO3P31', 'MT-CO3 pseudogene 31', 'pseudogene', 'ENSG00000217044'),
(3967, 52138, 'MTCO3P35', 'MT-CO3 pseudogene 35', 'pseudogene', 'ENSG00000242836'),
(3968, 52145, 'MTCO3P42', 'MT-CO3 pseudogene 42', 'pseudogene', 'ENSG00000268391'),
(3969, 52147, 'MTCO3P44', 'MT-CO3 pseudogene 44', 'pseudogene', 'ENSG00000248654'),
(3970, 7423, 'MTCP1', 'mature T cell proliferation 1', 'protein-coding gene', 'ENSG00000214827'),
(3971, 39579, 'MTCYBP3', 'MT-CYB pseudogene 3', 'pseudogene', 'ENSG00000232373'),
(3972, 51964, 'MTCYBP7', 'MT-CYB pseudogene 7', 'pseudogene', 'ENSG00000227789'),
(3973, 51968, 'MTCYBP15', 'MT-CYB pseudogene 15', 'pseudogene', 'ENSG00000232154'),
(3974, 51976, 'MTCYBP18', 'MT-CYB pseudogene 18', 'pseudogene', 'ENSG00000244921'),
(3975, 51997, 'MTCYBP31', 'MT-CYB pseudogene 31', 'pseudogene', 'ENSG00000226579'),
(3976, 52304, 'MTCYBP36', 'MT-CYB pseudogene 36', 'pseudogene', 'ENSG00000216853'),
(3977, 29608, 'MTDH', 'metadherin', 'protein-coding gene', 'ENSG00000147649'),
(3978, 52360, 'MTDHP4', 'metadherin pseudogene 4', 'pseudogene', 'ENSG00000268535'),
(3979, 48862, 'MTHFD2P4', 'methylenetetrahydrofolate dehydrogenase (NADP+ dependent) 2, methenyltetrahydrofolate cyclohydrolase pseudogene 4', 'pseudogene', 'ENSG00000251253'),
(3980, 48864, 'MTHFD2P6', 'methylenetetrahydrofolate dehydrogenase (NADP+ dependent) 2, methenyltetrahydrofolate cyclohydrolase pseudogene 6', 'pseudogene', 'ENSG00000249266'),
(3981, 25778, 'MTHFSD', 'methenyltetrahydrofolate synthetase domain containing', 'protein-coding gene', 'ENSG00000103248'),
(3982, 7448, 'MTM1', 'myotubularin 1', 'protein-coding gene', 'ENSG00000171100'),
(3983, 7453, 'MTMR6', 'myotubularin related protein 6', 'protein-coding gene', 'ENSG00000139505'),
(3984, 7454, 'MTMR7', 'myotubularin related protein 7', 'protein-coding gene', 'ENSG00000003987'),
(3985, 16825, 'MTMR8', 'myotubularin related protein 8', 'protein-coding gene', 'ENSG00000102043'),
(3986, 14596, 'MTMR9', 'myotubularin related protein 9', 'protein-coding gene', 'ENSG00000104643'),
(3987, 18191, 'MTMR12', 'myotubularin related protein 12', 'protein-coding gene', 'ENSG00000150712'),
(3988, 42100, 'MTND1P8', 'MT-ND1 pseudogene 8', 'pseudogene', 'ENSG00000263177'),
(3989, 42065, 'MTND1P16', 'MT-ND1 pseudogene 16', 'pseudogene', 'ENSG00000239586'),
(3990, 42067, 'MTND1P18', 'MT-ND1 pseudogene 18', 'pseudogene', 'ENSG00000225276'),
(3991, 42092, 'MTND1P23', 'MT-ND1 pseudogene 23', 'pseudogene', 'ENSG00000225972'),
(3992, 42073, 'MTND1P24', 'MT-ND1 pseudogene 24', 'pseudogene', 'ENSG00000257858'),
(3993, 42075, 'MTND1P26', 'MT-ND1 pseudogene 26', 'pseudogene', 'ENSG00000234576'),
(3994, 42078, 'MTND1P29', 'MT-ND1 pseudogene 29', 'pseudogene', 'ENSG00000237722'),
(3995, 42082, 'MTND1P33', 'MT-ND1 pseudogene 33', 'pseudogene', 'ENSG00000235539'),
(3996, 42088, 'MTND1P35', 'MT-ND1 pseudogene 35', 'pseudogene', 'ENSG00000255055'),
(3997, 42120, 'MTND2P19', 'MT-ND2 pseudogene 19', 'pseudogene', 'ENSG00000231567'),
(3998, 42122, 'MTND2P21', 'MT-ND2 pseudogene 21', 'pseudogene', 'ENSG00000230950'),
(3999, 42125, 'MTND2P24', 'MT-ND2 pseudogene 24', 'pseudogene', 'ENSG00000231947'),
(4000, 42144, 'MTND3P4', 'MT-ND3 pseudogene 4', 'pseudogene', 'ENSG00000230302'),
(4001, 42150, 'MTND3P10', 'MT-ND3 pseudogene 10', 'pseudogene', 'ENSG00000233286'),
(4002, 52170, 'MTND3P24', 'MT-ND3 pseudogene 24', 'pseudogene', 'ENSG00000249045'),
(4003, 31347, 'MTND4LP1', 'MT-ND4L pseudogene 1', 'pseudogene', 'ENSG00000231501'),
(4004, 42236, 'MTND4LP2', 'MT-ND4L pseudogene 2', 'pseudogene', 'ENSG00000248315'),
(4005, 42246, 'MTND4LP12', 'MT-ND4L pseudogene 12', 'pseudogene', 'ENSG00000236300'),
(4006, 42247, 'MTND4LP13', 'MT-ND4L pseudogene 13', 'pseudogene', 'ENSG00000235318'),
(4007, 42251, 'MTND4LP17', 'MT-ND4L pseudogene 17', 'pseudogene', 'ENSG00000241221'),
(4008, 42252, 'MTND4LP18', 'MT-ND4L pseudogene 18', 'pseudogene', 'ENSG00000254747'),
(4009, 42255, 'MTND4LP21', 'MT-ND4L pseudogene 21', 'pseudogene', 'ENSG00000231582'),
(4010, 42260, 'MTND4LP26', 'MT-ND4L pseudogene 26', 'pseudogene', 'ENSG00000254015'),
(4011, 52318, 'MTND4LP32', 'MT-ND4L pseudogene 32', 'pseudogene', 'ENSG00000283481'),
(4012, 42190, 'MTND4P3', 'MT-ND4 pseudogene 3', 'pseudogene', 'ENSG00000225959'),
(4013, 42192, 'MTND4P5', 'MT-ND4 pseudogene 5', 'pseudogene', 'ENSG00000227584'),
(4014, 42223, 'MTND4P11', 'MT-ND4 pseudogene 11', 'pseudogene', 'ENSG00000234099'),
(4015, 42202, 'MTND4P15', 'MT-ND4 pseudogene 15', 'pseudogene', 'ENSG00000227321'),
(4016, 42204, 'MTND4P17', 'MT-ND4 pseudogene 17', 'pseudogene', 'ENSG00000242178'),
(4017, 42207, 'MTND4P20', 'MT-ND4 pseudogene 20', 'pseudogene', 'ENSG00000233377'),
(4018, 51947, 'MTND4P33', 'MT-ND4 pseudogene 33', 'pseudogene', 'ENSG00000258762'),
(4019, 42276, 'MTND5P14', 'MT-ND5 pseudogene 14', 'pseudogene', 'ENSG00000230225'),
(4020, 42300, 'MTND5P20', 'MT-ND5 pseudogene 20', 'pseudogene', 'ENSG00000238256'),
(4021, 42295, 'MTND5P26', 'MT-ND5 pseudogene 26', 'pseudogene', 'ENSG00000234886'),
(4022, 42292, 'MTND5P30', 'MT-ND5 pseudogene 30', 'pseudogene', 'ENSG00000233039'),
(4023, 51951, 'MTND5P32', 'MT-ND5 pseudogene 32', 'pseudogene', 'ENSG00000259379'),
(4024, 38730, 'MTND6P1', 'MT-ND6 pseudogene 1', 'pseudogene', 'ENSG00000223955'),
(4025, 39471, 'MTND6P8', 'MT-ND6 pseudogene 8', 'pseudogene', 'ENSG00000248136'),
(4026, 39473, 'MTND6P10', 'MT-ND6 pseudogene 10', 'pseudogene', 'ENSG00000227275'),
(4027, 39476, 'MTND6P13', 'MT-ND6 pseudogene 13', 'pseudogene', 'ENSG00000234901'),
(4028, 39480, 'MTND6P17', 'MT-ND6 pseudogene 17', 'pseudogene', 'ENSG00000249770'),
(4029, 39483, 'MTND6P20', 'MT-ND6 pseudogene 20', 'pseudogene', 'ENSG00000254156'),
(4030, 39639, 'MTND6P21', 'MT-ND6 pseudogene 21', 'pseudogene', 'ENSG00000223431'),
(4031, 51978, 'MTND6P22', 'MT-ND6 pseudogene 22', 'pseudogene', 'ENSG00000270230'),
(4032, 51982, 'MTND6P24', 'MT-ND6 pseudogene 24', 'pseudogene', 'ENSG00000232922'),
(4033, 52175, 'MTND6P33', 'MT-ND6 pseudogene 33', 'pseudogene', 'ENSG00000262107'),
(4034, 7464, 'MTNR1B', 'melatonin receptor 1B', 'protein-coding gene', 'ENSG00000134640'),
(4035, 25532, 'MTPAP', 'mitochondrial poly(A) polymerase', 'protein-coding gene', 'ENSG00000107951'),
(4036, 7469, 'MTRF1', 'mitochondrial translation release factor 1', 'protein-coding gene', 'ENSG00000120662'),
(4037, 21051, 'MTRF1L', 'mitochondrial translation release factor 1 like', 'protein-coding gene', 'ENSG00000112031'),
(4038, 50612, 'MTRF1LP2', 'mitochondrial translational release factor 1 like pseudogene 2', 'pseudogene', 'ENSG00000224110'),
(4039, 37156, 'MTRNR2L2', 'MT-RNR2 like 2 (pseudogene)', 'pseudogene', 'ENSG00000271043'),
(4040, 37157, 'MTRNR2L3', 'MT-RNR2 like 3 (pseudogene)', 'pseudogene', 'ENSG00000256222'),
(4041, 20443, 'MTSS1', 'MTSS I-BAR domain containing 1', 'protein-coding gene', 'ENSG00000170873'),
(4042, 29789, 'MTUS1', 'microtubule associated scaffold protein 1', 'protein-coding gene', 'ENSG00000129422'),
(4043, 20595, 'MTUS2', 'microtubule associated scaffold protein 2', 'protein-coding gene', 'ENSG00000132938'),
(4044, 7514, 'MUC4', 'mucin 4, cell surface associated', 'protein-coding gene', 'ENSG00000145113'),
(4045, 53936, 'MUC5B-AS1', 'MUC5B antisense RNA 1', 'non-coding RNA', 'ENSG00000255177'),
(4046, 7510, 'MUC12', 'mucin 12, cell surface associated', 'protein-coding gene', 'ENSG00000205277'),
(4047, 14362, 'MUC19', 'mucin 19, oligomeric', 'protein-coding gene', 'ENSG00000205592'),
(4048, 53807, 'MUC20-OT1', 'MUC20 overlapping transcript', 'non-coding RNA', 'ENSG00000242086'),
(4049, 30588, 'MUCL1', 'mucin like 1', 'protein-coding gene', 'ENSG00000172551'),
(4050, 21666, 'MUCL3', 'mucin like 3', 'protein-coding gene', 'ENSG00000168631'),
(4051, 7532, 'MX1', 'MX dynamin like GTPase 1', 'protein-coding gene', 'ENSG00000157601'),
(4052, 14008, 'MXD3', 'MAX dimerization protein 3', 'protein-coding gene', 'ENSG00000213347'),
(4053, 7542, 'MXRA8', 'matrix remodeling associated 8', 'protein-coding gene', 'ENSG00000162576'),
(4054, 37457, 'MYB-AS1', 'MYB antisense RNA 1', 'non-coding RNA', 'ENSG00000236703'),
(4055, 30434, 'MYBPHL', 'myosin binding protein H like', 'protein-coding gene', 'ENSG00000221986'),
(4056, 7554, 'MYCBP', 'MYC binding protein', 'protein-coding gene', 'ENSG00000214114'),
(4057, 7559, 'MYCN', 'MYCN proto-oncogene, bHLH transcription factor', 'protein-coding gene', 'ENSG00000134323'),
(4058, 7566, 'MYF6', 'myogenic factor 6', 'protein-coding gene', 'ENSG00000111046'),
(4059, 7567, 'MYH1', 'myosin heavy chain 1', 'protein-coding gene', 'ENSG00000109061'),
(4060, 15906, 'MYH7B', 'myosin heavy chain 7B', 'protein-coding gene', 'ENSG00000078814'),
(4061, 23212, 'MYH14', 'myosin heavy chain 14', 'protein-coding gene', 'ENSG00000105357'),
(4062, 31073, 'MYH15', 'myosin heavy chain 15', 'protein-coding gene', 'ENSG00000144821'),
(4063, 31038, 'MYH16', 'myosin heavy chain 16 pseudogene', 'pseudogene', 'ENSG00000002079'),
(4064, 29823, 'MYL6B', 'myosin light chain 6B', 'protein-coding gene', 'ENSG00000196465'),
(4065, 37812, 'MYL6P3', 'MYL6 pseudogene 3', 'pseudogene', 'ENSG00000227173'),
(4066, 37813, 'MYL6P4', 'MYL6 pseudogene 4', 'pseudogene', 'ENSG00000240677'),
(4067, 15754, 'MYL9', 'myosin light chain 9', 'protein-coding gene', 'ENSG00000101335'),
(4068, 55331, 'MYL12-AS1', 'MYL12A and MYL12B antisense RNA 1', 'non-coding RNA', 'ENSG00000264235'),
(4069, 40387, 'MYLK-AS2', 'MYLK antisense RNA 2', 'non-coding RNA', 'ENSG00000250174'),
(4070, 29826, 'MYLK3', 'myosin light chain kinase 3', 'protein-coding gene', 'ENSG00000140795'),
(4071, 14955, 'MYNN', 'myoneurin', 'protein-coding gene', 'ENSG00000085274'),
(4072, 13879, 'MYO1H', 'myosin IH', 'protein-coding gene', 'ENSG00000174527'),
(4073, 7602, 'MYO5A', 'myosin VA', 'protein-coding gene', 'ENSG00000197535'),
(4074, 38495, 'MYO5BP1', 'myosin VB pseudogene 1', 'pseudogene', 'ENSG00000274680'),
(4075, 38496, 'MYO5BP2', 'myosin VB pseudogene 2', 'pseudogene', 'ENSG00000238245'),
(4076, 7605, 'MYO6', 'myosin VI', 'protein-coding gene', 'ENSG00000196586'),
(4077, 7593, 'MYO10', 'myosin X', 'protein-coding gene', 'ENSG00000145555'),
(4078, 40750, 'MYOCD-AS1', 'MYOCD antisense RNA 1', 'non-coding RNA', 'ENSG00000227274'),
(4079, 53429, 'MYOCOS', 'myocilin opposite strand', 'protein-coding gene', 'ENSG00000283683'),
(4080, 7613, 'MYOM1', 'myomesin 1', 'protein-coding gene', 'ENSG00000101605'),
(4081, 19918, 'MYORG', 'myogenesis regulating glycosidase (putative)', 'protein-coding gene', 'ENSG00000164976'),
(4082, 51821, 'MYOSLID', 'myocardin-induced smooth muscle lncRNA, inducer of differentiation', 'non-coding RNA', 'ENSG00000229647'),
(4083, 40846, 'MYOZ3-AS1', 'MYOZ3 antisense RNA 1', 'non-coding RNA', 'ENSG00000250309'),
(4084, 23246, 'MYPN', 'myopalladin', 'protein-coding gene', 'ENSG00000138347'),
(4085, 20178, 'MYPOP', 'Myb related transcription factor, partner of profilin', 'protein-coding gene', 'ENSG00000176182'),
(4086, 1181, 'MYRF', 'myelin regulatory factor', 'protein-coding gene', 'ENSG00000124920');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(4087, 7622, 'MYT1', 'myelin transcription factor 1', 'protein-coding gene', 'ENSG00000196132'),
(4088, 28125, 'NAA11', 'N-alpha-acetyltransferase 11, NatA catalytic subunit', 'protein-coding gene', 'ENSG00000156269'),
(4089, 24340, 'NAA35', 'N-alpha-acetyltransferase 35, NatC auxiliary subunit', 'protein-coding gene', 'ENSG00000135040'),
(4090, 25875, 'NAA60', 'N-alpha-acetyltransferase 60, NatF catalytic subunit', 'protein-coding gene', 'ENSG00000122390'),
(4091, 7627, 'NAB2', 'NGFI-A binding protein 2', 'protein-coding gene', 'ENSG00000166886'),
(4092, 26232, 'NABP1', 'nucleic acid binding protein 1', 'protein-coding gene', 'ENSG00000173559'),
(4093, 28412, 'NABP2', 'nucleic acid binding protein 2', 'protein-coding gene', 'ENSG00000139579'),
(4094, 23290, 'NACA2', 'nascent polypeptide associated complex subunit alpha 2', 'protein-coding gene', 'ENSG00000253506'),
(4095, 24688, 'NACA4P', 'NACA family member 4, pseudogene', 'pseudogene', 'ENSG00000228224'),
(4096, 49489, 'NACAP2', 'NACA pseudogene 2', 'pseudogene', 'ENSG00000180230'),
(4097, 49492, 'NACAP5', 'NACA pseudogene 5', 'pseudogene', 'ENSG00000249488'),
(4098, 29831, 'NADK', 'NAD kinase', 'protein-coding gene', 'ENSG00000008130'),
(4099, 621, 'NAE1', 'NEDD8 activating enzyme E1 subunit 1', 'protein-coding gene', 'ENSG00000159593'),
(4100, 7632, 'NAGLU', 'N-acetyl-alpha-glucosaminidase', 'protein-coding gene', 'ENSG00000108784'),
(4101, 19082, 'NALCN', 'sodium leak channel, non-selective', 'protein-coding gene', 'ENSG00000102452'),
(4102, 42160, 'NANOGNBP3', 'NANOGNB pseudogene 3', 'pseudogene', 'ENSG00000270813'),
(4103, 23105, 'NANOGP7', 'Nanog homeobox pseudogene 7', 'pseudogene', 'ENSG00000258774'),
(4104, 7638, 'NAP1L2', 'nucleosome assembly protein 1 like 2', 'protein-coding gene', 'ENSG00000186462'),
(4105, 7640, 'NAP1L4', 'nucleosome assembly protein 1 like 4', 'protein-coding gene', 'ENSG00000205531'),
(4106, 39739, 'NAP1L4P2', 'nucleosome assembly protein 1 like 4 pseudogene 2', 'pseudogene', 'ENSG00000224816'),
(4107, 19968, 'NAP1L5', 'nucleosome assembly protein 1 like 5', 'protein-coding gene', 'ENSG00000177432'),
(4108, 15751, 'NAPB', 'NSF attachment protein beta', 'protein-coding gene', 'ENSG00000125814'),
(4109, 45165, 'NAPGP1', 'N-ethylmaleimide-sensitive factor attachment protein, gamma pseudogene 1', 'pseudogene', 'ENSG00000271408'),
(4110, 13396, 'NAPSB', 'napsin B aspartic peptidase, pseudogene', 'pseudogene', 'ENSG00000131401'),
(4111, 43651, 'NARF-IT1', 'NARF intronic transcript 1', 'non-coding RNA', 'ENSG00000266236'),
(4112, 26274, 'NARS2', 'asparaginyl-tRNA synthetase 2, mitochondrial', 'protein-coding gene', 'ENSG00000137513'),
(4113, 7646, 'NAT2', 'N-acetyltransferase 2', 'protein-coding gene', 'ENSG00000156006'),
(4114, 30235, 'NAT8B', 'N-acetyltransferase 8B (putative, gene/pseudogene)', 'protein-coding gene', 'ENSG00000204872'),
(4115, 23133, 'NAT9', 'N-acetyltransferase 9 (putative)', 'protein-coding gene', 'ENSG00000109065'),
(4116, 15997, 'NAV2', 'neuron navigator 2', 'protein-coding gene', 'ENSG00000166833'),
(4117, 40743, 'NAV2-AS2', 'NAV2 antisense RNA 2', 'non-coding RNA', 'ENSG00000254453'),
(4118, 40011, 'NBEAP6', 'neurobeachin pseudogene 6', 'pseudogene', 'ENSG00000285990'),
(4119, 25076, 'NBPF3', 'NBPF member 3', 'protein-coding gene', 'ENSG00000142794'),
(4120, 24491, 'NBPF5P', 'NBPF member 5, pseudogene', 'pseudogene', 'ENSG00000243967'),
(4121, 31993, 'NBPF11', 'NBPF member 11', 'protein-coding gene', 'ENSG00000263956'),
(4122, 31995, 'NBPF13P', 'NBPF member 13, pseudogene', 'pseudogene', 'ENSG00000283342'),
(4123, 25232, 'NBPF14', 'NBPF member 14', 'protein-coding gene', 'ENSG00000270629'),
(4124, 31997, 'NBPF17P', 'NBPF member 17, pseudogene', 'pseudogene', 'ENSG00000179571'),
(4125, 31998, 'NBPF18P', 'NBPF member 18, pseudogene', 'pseudogene', 'ENSG00000240667'),
(4126, 28731, 'NBPF22P', 'NBPF member 22, pseudogene', 'pseudogene', 'ENSG00000205449'),
(4127, 48675, 'NCAM1-AS1', 'NCAM1 antisense RNA1', 'non-coding RNA', 'ENSG00000227487'),
(4128, 24305, 'NCAPD2', 'non-SMC condensin I complex subunit D2', 'protein-coding gene', 'ENSG00000010292'),
(4129, 21904, 'NCAPG2', 'non-SMC condensin II complex subunit G2', 'protein-coding gene', 'ENSG00000146918'),
(4130, 1112, 'NCAPH', 'non-SMC condensin I complex subunit H', 'protein-coding gene', 'ENSG00000121152'),
(4131, 40392, 'NCBP2-AS1', 'NCBP2 antisense RNA 1', 'non-coding RNA', 'ENSG00000225578'),
(4132, 7660, 'NCF1', 'neutrophil cytosolic factor 1', 'protein-coding gene', 'ENSG00000158517'),
(4133, 32522, 'NCF1B', 'neutrophil cytosolic factor 1B pseudogene', 'pseudogene', 'ENSG00000182487'),
(4134, 32523, 'NCF1C', 'neutrophil cytosolic factor 1C pseudogene', 'pseudogene', 'ENSG00000165178'),
(4135, 7664, 'NCK1', 'NCK adaptor protein 1', 'protein-coding gene', 'ENSG00000158092'),
(4136, 7666, 'NCKAP1', 'NCK associated protein 1', 'protein-coding gene', 'ENSG00000061676'),
(4137, 15486, 'NCKIPSD', 'NCK interacting protein with SH3 domain', 'protein-coding gene', 'ENSG00000213672'),
(4138, 7667, 'NCL', 'nucleolin', 'protein-coding gene', 'ENSG00000115053'),
(4139, 7671, 'NCOA4', 'nuclear receptor coactivator 4', 'protein-coding gene', 'ENSG00000266412'),
(4140, 20022, 'NCOA4P1', 'nuclear receptor coactivator 4 pseudogene 1', 'pseudogene', 'ENSG00000258629'),
(4141, 7672, 'NCOR1', 'nuclear receptor corepressor 1', 'protein-coding gene', 'ENSG00000141027'),
(4142, 19077, 'NCR3', 'natural cytotoxicity triggering receptor 3', 'protein-coding gene', 'ENSG00000204475'),
(4143, 3953, 'NCS1', 'neuronal calcium sensor 1', 'protein-coding gene', 'ENSG00000107130'),
(4144, 49866, 'NDFIP1P1', 'Nedd4 family interacting protein 1 pseudogene 1', 'pseudogene', 'ENSG00000255892'),
(4145, 26256, 'NDNF', 'neuron derived neurotrophic factor', 'protein-coding gene', 'ENSG00000173376'),
(4146, 40395, 'NDP-AS1', 'NDP antisense RNA 1', 'non-coding RNA', 'ENSG00000236276'),
(4147, 14466, 'NDRG4', 'NDRG family member 4', 'protein-coding gene', 'ENSG00000103034'),
(4148, 7680, 'NDST1', 'N-deacetylase and N-sulfotransferase 1', 'protein-coding gene', 'ENSG00000070614'),
(4149, 20779, 'NDST4', 'N-deacetylase and N-sulfotransferase 4', 'protein-coding gene', 'ENSG00000138653'),
(4150, 7683, 'NDUFA1', 'NADH:ubiquinone oxidoreductase subunit A1', 'protein-coding gene', 'ENSG00000125356'),
(4151, 7686, 'NDUFA3', 'NADH:ubiquinone oxidoreductase subunit A3', 'protein-coding gene', 'ENSG00000170906'),
(4152, 45043, 'NDUFA3P1', 'NADH:ubiquinone oxidoreductase subunit A3 pseudogene 1', 'pseudogene', 'ENSG00000267590'),
(4153, 45053, 'NDUFA3P4', 'NADH:ubiquinone oxidoreductase subunit A3 pseudogene 4', 'pseudogene', 'ENSG00000259262'),
(4154, 45055, 'NDUFA3P6', 'NADH:ubiquinone oxidoreductase subunit A3 pseudogene 6', 'pseudogene', 'ENSG00000262366'),
(4155, 48848, 'NDUFA5P6', 'NADH:ubiquinone oxidoreductase subunit A5 pseudogene 6', 'pseudogene', 'ENSG00000256310'),
(4156, 48849, 'NDUFA5P7', 'NADH:ubiquinone oxidoreductase subunit A5 pseudogene 7', 'pseudogene', 'ENSG00000234039'),
(4157, 48852, 'NDUFA5P10', 'NADH:ubiquinone oxidoreductase subunit A5 pseudogene 10', 'pseudogene', 'ENSG00000224927'),
(4158, 48854, 'NDUFA5P12', 'NADH:ubiquinone oxidoreductase subunit A5 pseudogene 12', 'pseudogene', 'ENSG00000248531'),
(4159, 7684, 'NDUFA10', 'NADH:ubiquinone oxidoreductase subunit A10', 'protein-coding gene', 'ENSG00000130414'),
(4160, 52265, 'NDUFAB1P1', 'NADH:ubiquinone oxidoreductase subunit AB1 pseudogene 1', 'pseudogene', 'ENSG00000217767'),
(4161, 29918, 'NDUFAF3', 'NADH:ubiquinone oxidoreductase complex assembly factor 3', 'protein-coding gene', 'ENSG00000178057'),
(4162, 40396, 'NDUFB2-AS1', 'NDUFB2 antisense RNA 1', 'non-coding RNA', 'ENSG00000240889'),
(4163, 7699, 'NDUFB4', 'NADH:ubiquinone oxidoreductase subunit B4', 'protein-coding gene', 'ENSG00000065518'),
(4164, 45259, 'NDUFB4P11', 'NADH:ubiquinone oxidoreductase subunit B4 pseudogene 11', 'pseudogene', 'ENSG00000259374'),
(4165, 52270, 'NDUFB9P2', 'NADH:ubiquinone oxidoreductase subunit B9 pseudogene 2', 'pseudogene', 'ENSG00000236281'),
(4166, 33980, 'NDUFB11P1', 'NADH:ubiquinone oxidoreductase subunit B11 pseudogene 1', 'pseudogene', 'ENSG00000235547'),
(4167, 7708, 'NDUFS2', 'NADH:ubiquinone oxidoreductase core subunit S2', 'protein-coding gene', 'ENSG00000158864'),
(4168, 7711, 'NDUFS4', 'NADH:ubiquinone oxidoreductase subunit S4', 'protein-coding gene', 'ENSG00000164258'),
(4169, 44039, 'NDUFS5P1', 'NADH:ubiquinone oxidoreductase subunit S5 pseudogene 1', 'pseudogene', 'ENSG00000218424'),
(4170, 7713, 'NDUFS6', 'NADH:ubiquinone oxidoreductase subunit S6', 'protein-coding gene', 'ENSG00000145494'),
(4171, 43912, 'NECAP1P1', 'NECAP endocytosis associated 1 pseudogene 1', 'pseudogene', 'ENSG00000178503'),
(4172, 54270, 'NECTIN1-AS1', 'NECTIN1 antisense RNA 1', 'non-coding RNA', 'ENSG00000255247'),
(4173, 40813, 'NECTIN3-AS1', 'NECTIN3 antisense RNA 1', 'non-coding RNA', 'ENSG00000242242'),
(4174, 7733, 'NEDD9', 'neural precursor cell expressed, developmentally down-regulated 9', 'protein-coding gene', 'ENSG00000111859'),
(4175, 7738, 'NEFHP1', 'neurofilament heavy pseudogene 1', 'pseudogene', 'ENSG00000223489'),
(4176, 37662, 'NEFLP1', 'neurofilament light pseudogene 1', 'pseudogene', 'ENSG00000232634'),
(4177, 41432, 'NEGR1-IT1', 'NEGR1 intronic transcript 1', 'non-coding RNA', 'ENSG00000228853'),
(4178, 18448, 'NEIL1', 'nei like DNA glycosylase 1', 'protein-coding gene', 'ENSG00000140398'),
(4179, 7745, 'NEK2', 'NIMA related kinase 2', 'protein-coding gene', 'ENSG00000117650'),
(4180, 7749, 'NEK6', 'NIMA related kinase 6', 'protein-coding gene', 'ENSG00000119408'),
(4181, 12768, 'NELFA', 'negative elongation factor complex member A', 'protein-coding gene', 'ENSG00000185049'),
(4182, 15934, 'NELFCD', 'negative elongation factor complex member C/D', 'protein-coding gene', 'ENSG00000101158'),
(4183, 33700, 'NEMP2', 'nuclear envelope integral membrane protein 2', 'protein-coding gene', 'ENSG00000189362'),
(4184, 30384, 'NENF', 'neudesin neurotrophic factor', 'protein-coding gene', 'ENSG00000117691'),
(4185, 7754, 'NEO1', 'neogenin 1', 'protein-coding gene', 'ENSG00000067141'),
(4186, 41049, 'NEPRO-AS1', 'NEPRO antisense RNA 1', 'non-coding RNA', 'ENSG00000240057'),
(4187, 7756, 'NES', 'nestin', 'protein-coding gene', 'ENSG00000132688'),
(4188, 14644, 'NETO2', 'neuropilin and tolloid like 2', 'protein-coding gene', 'ENSG00000171208'),
(4189, 7760, 'NEU3', 'neuraminidase 3', 'protein-coding gene', 'ENSG00000162139'),
(4190, 21328, 'NEU4', 'neuraminidase 4', 'protein-coding gene', 'ENSG00000204099'),
(4191, 34410, 'NEURL4', 'neuralized E3 ubiquitin protein ligase 4', 'protein-coding gene', 'ENSG00000215041'),
(4192, 7764, 'NEUROG1', 'neurogenin 1', 'protein-coding gene', 'ENSG00000181965'),
(4193, 51736, 'NF1P9', 'neurofibromin 1 pseudogene 9', 'pseudogene', 'ENSG00000281347'),
(4194, 51737, 'NF1P10', 'neurofibromin 1 pseudogene 10', 'pseudogene', 'ENSG00000277529'),
(4195, 51738, 'NF1P11', 'neurofibromin 1 pseudogene 11', 'pseudogene', 'ENSG00000278184'),
(4196, 29872, 'NFAM1', 'NFAT activating protein with ITAM motif 1', 'protein-coding gene', 'ENSG00000235568'),
(4197, 7774, 'NFAT5', 'nuclear factor of activated T cells 5', 'protein-coding gene', 'ENSG00000102908'),
(4198, 7775, 'NFATC1', 'nuclear factor of activated T cells 1', 'protein-coding gene', 'ENSG00000131196'),
(4199, 7777, 'NFATC3', 'nuclear factor of activated T cells 3', 'protein-coding gene', 'ENSG00000072736'),
(4200, 7778, 'NFATC4', 'nuclear factor of activated T cells 4', 'protein-coding gene', 'ENSG00000100968'),
(4201, 22278, 'NFE2L3P1', 'nuclear factor, erythroid 2 like 3 pseudogene 1', 'pseudogene', 'ENSG00000267497'),
(4202, 7784, 'NFIA', 'nuclear factor I A', 'protein-coding gene', 'ENSG00000162599'),
(4203, 56058, 'NFIB-AS1', 'NFIB antisense RNA 1', 'non-coding RNA', 'ENSG00000225472'),
(4204, 7786, 'NFIC', 'nuclear factor I C', 'protein-coding gene', 'ENSG00000141905'),
(4205, 7800, 'NFKBIL1', 'NFKB inhibitor like 1', 'protein-coding gene', 'ENSG00000204498'),
(4206, 7802, 'NFRKB', 'nuclear factor related to kappaB binding protein', 'protein-coding gene', 'ENSG00000170322'),
(4207, 44553, 'NFU1P1', 'NFU1 iron-sulfur cluster scaffold pseudogene 1', 'pseudogene', 'ENSG00000230757'),
(4208, 7818, 'NHLH2', 'nescient helix-loop-helix 2', 'protein-coding gene', 'ENSG00000177551'),
(4209, 24731, 'NHLRC2', 'NHL repeat containing 2', 'protein-coding gene', 'ENSG00000196865'),
(4210, 26700, 'NHLRC4', 'NHL repeat containing 4', 'protein-coding gene', 'ENSG00000257108'),
(4211, 40403, 'NHS-AS1', 'NHS antisense RNA 1', 'non-coding RNA', 'ENSG00000230020'),
(4212, 16784, 'NIBAN1', 'niban apoptosis regulator 1', 'protein-coding gene', 'ENSG00000135842'),
(4213, 44956, 'NIFKP8', 'nucleolar protein interacting with the FHA domain of MKI67 pseudogene 8', 'pseudogene', 'ENSG00000259449'),
(4214, 14906, 'NIN', 'ninein', 'protein-coding gene', 'ENSG00000100503'),
(4215, 7825, 'NINJ2', 'ninjurin 2', 'protein-coding gene', 'ENSG00000171840'),
(4216, 45181, 'NIP7P2', 'NIP7 pseudogene 2', 'pseudogene', 'ENSG00000213264'),
(4217, 25854, 'NIPAL2', 'NIPA like domain containing 2', 'protein-coding gene', 'ENSG00000104361'),
(4218, 28018, 'NIPAL4', 'NIPA like domain containing 4', 'protein-coding gene', 'ENSG00000172548'),
(4219, 7827, 'NIPSNAP1', 'nipsnap homolog 1', 'protein-coding gene', 'ENSG00000184117'),
(4220, 26706, 'NKAPP1', 'NFKB activating protein pseudogene 1', 'pseudogene', 'ENSG00000233382'),
(4221, 51599, 'NKILA', 'NF-kappaB interacting lncRNA', 'non-coding RNA', 'ENSG00000278709'),
(4222, 17899, 'NKIRAS1', 'NFKB inhibitor interacting Ras like 1', 'protein-coding gene', 'ENSG00000197885'),
(4223, 19374, 'NKRF', 'NFKB repressing factor', 'protein-coding gene', 'ENSG00000186416'),
(4224, 7837, 'NKX2-4', 'NK2 homeobox 4', 'protein-coding gene', 'ENSG00000125816'),
(4225, 16364, 'NKX2-8', 'NK2 homeobox 8', 'protein-coding gene', 'ENSG00000136327'),
(4226, 951, 'NKX3-2', 'NK3 homeobox 2', 'protein-coding gene', 'ENSG00000109705'),
(4227, 7839, 'NKX6-1', 'NK6 homeobox 1', 'protein-coding gene', 'ENSG00000163623'),
(4228, 40676, 'NLGN1-AS1', 'NLGN1 antisense RNA 1', 'non-coding RNA', 'ENSG00000228213'),
(4229, 14290, 'NLGN2', 'neuroligin 2', 'protein-coding gene', 'ENSG00000169992'),
(4230, 29933, 'NLRC5', 'NLR family CARD domain containing 5', 'protein-coding gene', 'ENSG00000140853'),
(4231, 14374, 'NLRP1', 'NLR family pyrin domain containing 1', 'protein-coding gene', 'ENSG00000091592'),
(4232, 21269, 'NLRP5', 'NLR family pyrin domain containing 5', 'protein-coding gene', 'ENSG00000171487'),
(4233, 22947, 'NLRP7', 'NLR family pyrin domain containing 7', 'protein-coding gene', 'ENSG00000167634'),
(4234, 39904, 'NME1P1', 'NME/NM23 nucleoside diphosphate kinase 1 pseudogene 1', 'pseudogene', 'ENSG00000237175'),
(4235, 54767, 'NME2P3', 'NME2 pseudogene 3', 'pseudogene', 'ENSG00000229338'),
(4236, 16473, 'NME8', 'NME/NM23 family member 8', 'protein-coding gene', 'ENSG00000086288'),
(4237, 49164, 'NMNAT1P2', 'NMNAT1 pseudogene 2', 'pseudogene', 'ENSG00000225719'),
(4238, 49167, 'NMNAT1P5', 'NMNAT1 pseudogene 5', 'pseudogene', 'ENSG00000259573'),
(4239, 52332, 'NMRAL2P', 'NmrA like redox sensor 2, pseudogene', 'pseudogene', 'ENSG00000171658'),
(4240, 7857, 'NMT1', 'N-myristoyltransferase 1', 'protein-coding gene', 'ENSG00000136448'),
(4241, 35051, 'NMTRQ-TTG12-1', 'nuclear-encoded mitochondrial tRNA-Gln (TTG) 12-1', 'non-coding RNA', 'ENSG00000242752'),
(4242, 14254, 'NOCT', 'nocturnin', 'protein-coding gene', 'ENSG00000151014'),
(4243, 16390, 'NOD1', 'nucleotide binding oligomerization domain containing 1', 'protein-coding gene', 'ENSG00000106100'),
(4244, 23387, 'NOL8', 'nucleolar protein 8', 'protein-coding gene', 'ENSG00000198000'),
(4245, 25862, 'NOL10', 'nucleolar protein 10', 'protein-coding gene', 'ENSG00000115761'),
(4246, 13244, 'NOM1', 'nucleolar protein with MIF4G domain 1', 'protein-coding gene', 'ENSG00000146909'),
(4247, 42032, 'NONOP2', 'non-POU domain containing, octamer-binding pseudogene 2', 'pseudogene', 'ENSG00000237522'),
(4248, 53924, 'NOTCH2NLC', 'notch 2 N-terminal like C', 'protein-coding gene', 'ENSG00000286219'),
(4249, 7884, 'NOTCH4', 'notch receptor 4', 'protein-coding gene', 'ENSG00000204301'),
(4250, 31839, 'NOTO', 'notochord homeobox', 'protein-coding gene', 'ENSG00000214513'),
(4251, 19827, 'NOVA1-DT', 'NOVA1 divergent transcript', 'non-coding RNA', 'ENSG00000257842'),
(4252, 7889, 'NOX1', 'NADPH oxidase 1', 'protein-coding gene', 'ENSG00000007952'),
(4253, 7891, 'NOX4', 'NADPH oxidase 4', 'protein-coding gene', 'ENSG00000086991'),
(4254, 7897, 'NPC1', 'NPC intracellular cholesterol transporter 1', 'protein-coding gene', 'ENSG00000141458'),
(4255, 7905, 'NPHP1', 'nephrocystin 1', 'protein-coding gene', 'ENSG00000144061'),
(4256, 7908, 'NPHS1', 'NPHS1 adhesion molecule, nephrin', 'protein-coding gene', 'ENSG00000161270'),
(4257, 41980, 'NPIPA5', 'nuclear pore complex interacting protein family member A5', 'protein-coding gene', 'ENSG00000183793'),
(4258, 41983, 'NPIPA8', 'nuclear pore complex interacting protein family member A8', 'protein-coding gene', 'ENSG00000214940'),
(4259, 41984, 'NPIPA9', 'nuclear pore complex interacting protein family, member A9', 'protein-coding gene', 'ENSG00000233024'),
(4260, 28989, 'NPIPB3', 'nuclear pore complex interacting protein family member B3', 'protein-coding gene', 'ENSG00000169246'),
(4261, 37490, 'NPIPB8', 'nuclear pore complex interacting protein family member B8', 'protein-coding gene', 'ENSG00000255524'),
(4262, 41990, 'NPIPB14P', 'nuclear pore complex interacting protein family member B14, pseudogene', 'pseudogene', 'ENSG00000226232'),
(4263, 16781, 'NPL', 'N-acetylneuraminate pyruvate lyase', 'protein-coding gene', 'ENSG00000135838'),
(4264, 7911, 'NPM1P1', 'nucleophosmin 1 pseudogene 1', 'pseudogene', 'ENSG00000267652'),
(4265, 7929, 'NPM1P9', 'nucleophosmin 1 pseudogene 9', 'pseudogene', 'ENSG00000231066'),
(4266, 7915, 'NPM1P13', 'nucleophosmin 1 pseudogene 13', 'pseudogene', 'ENSG00000232492'),
(4267, 7916, 'NPM1P14', 'nucleophosmin 1 pseudogene 14', 'pseudogene', 'ENSG00000182965'),
(4268, 7920, 'NPM1P18', 'nucleophosmin 1 pseudogene 18', 'pseudogene', 'ENSG00000225739'),
(4269, 7921, 'NPM1P19', 'nucleophosmin 1 pseudogene 19', 'pseudogene', 'ENSG00000223864'),
(4270, 45219, 'NPM1P40', 'nucleophosmin 1 pseudogene 40', 'pseudogene', 'ENSG00000236523'),
(4271, 45226, 'NPM1P47', 'nucleophosmin 1 pseudogene 47', 'pseudogene', 'ENSG00000259466'),
(4272, 45227, 'NPM1P48', 'nucleophosmin 1 pseudogene 48', 'pseudogene', 'ENSG00000231821'),
(4273, 45230, 'NPM1P51', 'nucleophosmin 1 pseudogene 51', 'pseudogene', 'ENSG00000230913'),
(4274, 7940, 'NPPB', 'natriuretic peptide B', 'protein-coding gene', 'ENSG00000120937'),
(4275, 7941, 'NPPC', 'natriuretic peptide C', 'protein-coding gene', 'ENSG00000163273'),
(4276, 24969, 'NPRL2', 'NPR2 like, GATOR1 complex subunit', 'protein-coding gene', 'ENSG00000114388'),
(4277, 7953, 'NPTX2', 'neuronal pentraxin 2', 'protein-coding gene', 'ENSG00000106236'),
(4278, 7958, 'NPY5R', 'neuropeptide Y receptor Y5', 'protein-coding gene', 'ENSG00000164129'),
(4279, 7962, 'NR1D1', 'nuclear receptor subfamily 1 group D member 1', 'protein-coding gene', 'ENSG00000126368'),
(4280, 7968, 'NR1I2', 'nuclear receptor subfamily 1 group I member 2', 'protein-coding gene', 'ENSG00000144852'),
(4281, 7969, 'NR1I3', 'nuclear receptor subfamily 1 group I member 3', 'protein-coding gene', 'ENSG00000143257'),
(4282, 7971, 'NR2C1', 'nuclear receptor subfamily 2 group C member 1', 'protein-coding gene', 'ENSG00000120798'),
(4283, 7977, 'NR2F6', 'nuclear receptor subfamily 2 group F member 6', 'protein-coding gene', 'ENSG00000160113'),
(4284, 7983, 'NR5A1', 'nuclear receptor subfamily 5 group A member 1', 'protein-coding gene', 'ENSG00000136931'),
(4285, 44606, 'NRBF2P3', 'nuclear receptor binding factor 2 pseudogene 3', 'pseudogene', 'ENSG00000237415'),
(4286, 19339, 'NRBP2', 'nuclear receptor binding protein 2', 'protein-coding gene', 'ENSG00000185189'),
(4287, 29811, 'NRN1L', 'neuritin 1 like', 'protein-coding gene', 'ENSG00000188038'),
(4288, 24613, 'NRROS', 'negative regulator of reactive oxygen species', 'protein-coding gene', 'ENSG00000174004'),
(4289, 51222, 'NRSN2-AS1', 'NRSN2 antisense RNA 1', 'non-coding RNA', 'ENSG00000225377'),
(4290, 8007, 'NRTN', 'neurturin', 'protein-coding gene', 'ENSG00000171119'),
(4291, 8008, 'NRXN1', 'neurexin 1', 'protein-coding gene', 'ENSG00000179915'),
(4292, 54583, 'NSA2P4', 'NSA2 pseudogene 4', 'pseudogene', 'ENSG00000259750'),
(4293, 54584, 'NSA2P5', 'NSA2 pseudogene 5', 'pseudogene', 'ENSG00000227176'),
(4294, 14234, 'NSD1', 'nuclear receptor binding SET domain protein 1', 'protein-coding gene', 'ENSG00000165671'),
(4295, 13398, 'NSDHL', 'NAD(P) dependent steroid dehydrogenase-like', 'protein-coding gene', 'ENSG00000147383'),
(4296, 8016, 'NSF', 'N-ethylmaleimide sensitive factor, vesicle fusing ATPase', 'protein-coding gene', 'ENSG00000073969'),
(4297, 18790, 'NSG1', 'neuronal vesicle trafficking associated 1', 'protein-coding gene', 'ENSG00000168824'),
(4298, 29897, 'NSMCE1', 'NSE1 homolog, SMC5-SMC6 complex component', 'protein-coding gene', 'ENSG00000169189'),
(4299, 25935, 'NSMCE4A', 'NSE4 homolog A, SMC5-SMC6 complex component', 'protein-coding gene', 'ENSG00000107672'),
(4300, 29843, 'NSMF', 'NMDA receptor synaptonuclear signaling and neuronal migration factor', 'protein-coding gene', 'ENSG00000165802'),
(4301, 23529, 'NSUN6', 'NOP2/Sun RNA methyltransferase 6', 'protein-coding gene', 'ENSG00000241058'),
(4302, 21556, 'NT5DC1', '5\'-nucleotidase domain containing 1', 'protein-coding gene', 'ENSG00000178425'),
(4303, 30826, 'NT5DC3', '5\'-nucleotidase domain containing 3', 'protein-coding gene', 'ENSG00000111696'),
(4304, 32293, 'NTM-AS1', 'NTM antisense RNA 1', 'non-coding RNA', 'ENSG00000224795'),
(4305, 23373, 'NTMT1', 'N-terminal Xaa-Pro-Lys N-methyltransferase 1', 'protein-coding gene', 'ENSG00000148335'),
(4306, 8030, 'NTN3', 'netrin 3', 'protein-coding gene', 'ENSG00000162068'),
(4307, 25208, 'NTN5', 'netrin 5', 'protein-coding gene', 'ENSG00000142233'),
(4308, 14288, 'NTNG2', 'netrin G2', 'protein-coding gene', 'ENSG00000196358'),
(4309, 40419, 'NUCB1-AS1', 'NUCB1 antisense RNA 1', 'non-coding RNA', 'ENSG00000235191'),
(4310, 51943, 'NUCKS1P1', 'nuclear casein kinase and cyclin dependent kinase substrate 1 pseudogene 1', 'pseudogene', 'ENSG00000232864'),
(4311, 8050, 'NUDT3', 'nudix hydrolase 3', 'protein-coding gene', 'ENSG00000272325'),
(4312, 8055, 'NUDT8', 'nudix hydrolase 8', 'protein-coding gene', 'ENSG00000167799'),
(4313, 23063, 'NUDT15', 'nudix hydrolase 15', 'protein-coding gene', 'ENSG00000136159'),
(4314, 27947, 'NUDT16-DT', 'NUDT16 divergent transcript', 'non-coding RNA', 'ENSG00000250608'),
(4315, 28154, 'NUDT16L1', 'nudix hydrolase 16 like 1', 'protein-coding gene', 'ENSG00000168101'),
(4316, 26194, 'NUDT18', 'nudix hydrolase 18', 'protein-coding gene', 'ENSG00000275074'),
(4317, 32036, 'NUDT19', 'nudix hydrolase 19', 'protein-coding gene', 'ENSG00000213965'),
(4318, 55061, 'NUDT19P6', 'NUDT19 pseudogene 6', 'pseudogene', 'ENSG00000270625'),
(4319, 28189, 'NUDT22', 'nudix hydrolase 22', 'protein-coding gene', 'ENSG00000149761'),
(4320, 52371, 'NUP35P2', 'nucleoporin 35 pseudogene 2', 'pseudogene', 'ENSG00000226285'),
(4321, 8065, 'NUP50', 'nucleoporin 50', 'protein-coding gene', 'ENSG00000093000'),
(4322, 44052, 'NUP58P1', 'nucleoporin 58 pseudogene 1', 'pseudogene', 'ENSG00000251436'),
(4323, 55370, 'NUP93-DT', 'NUP93 divergent transcript', 'non-coding RNA', 'ENSG00000261302'),
(4324, 8068, 'NUP98', 'nucleoporin 98 and 96 precursor', 'protein-coding gene', 'ENSG00000110713'),
(4325, 29914, 'NUP107', 'nucleoporin 107', 'protein-coding gene', 'ENSG00000111581'),
(4326, 27399, 'NUP210P1', 'nucleoporin 210 pseudogene 1', 'pseudogene', 'ENSG00000198284'),
(4327, 44164, 'NUPR2', 'nuclear protein 2, transcriptional regulator', 'protein-coding gene', 'ENSG00000185290'),
(4328, 50452, 'NUTF2P3', 'nuclear transport factor 2 pseudogene 3', 'pseudogene', 'ENSG00000228248'),
(4329, 50453, 'NUTF2P4', 'nuclear transport factor 2 pseudogene 4', 'pseudogene', 'ENSG00000234790'),
(4330, 23438, 'NUTM2A', 'NUT family member 2A', 'protein-coding gene', 'ENSG00000184923'),
(4331, 23445, 'NUTM2B', 'NUT family member 2B', 'protein-coding gene', 'ENSG00000188199'),
(4332, 51204, 'NUTM2B-AS1', 'NUTM2B antisense RNA 1', 'non-coding RNA', 'ENSG00000225484'),
(4333, 45017, 'NUTM2HP', 'NUT family member 2H, pseudogene', 'pseudogene', 'ENSG00000232706'),
(4334, 8070, 'NVL', 'nuclear VCP like', 'protein-coding gene', 'ENSG00000143748'),
(4335, 29229, 'NWD2', 'NACHT and WD repeat domain containing 2', 'protein-coding gene', 'ENSG00000174145'),
(4336, 23984, 'NXF2B', 'nuclear RNA export factor 2B', 'protein-coding gene', 'ENSG00000269437'),
(4337, 8074, 'NXF4', 'nuclear RNA export factor 4 pseudogene', 'pseudogene', 'ENSG00000196970'),
(4338, 26331, 'NXPE2', 'neurexophilin and PC-esterase domain family member 2', 'protein-coding gene', 'ENSG00000204361'),
(4339, 8076, 'NXPH2', 'neurexophilin 2', 'protein-coding gene', 'ENSG00000144227'),
(4340, 8077, 'NXPH3', 'neurexophilin 3', 'protein-coding gene', 'ENSG00000182575'),
(4341, 8078, 'NXPH4', 'neurexophilin 4', 'protein-coding gene', 'ENSG00000182379'),
(4342, 29291, 'NYAP2', 'neuronal tyrosine-phosphorylated phosphoinositide-3-kinase adaptor 2', 'protein-coding gene', 'ENSG00000144460'),
(4343, 8086, 'OAS1', '2\'-5\'-oligoadenylate synthetase 1', 'protein-coding gene', 'ENSG00000089127'),
(4344, 53738, 'OASL2P', '2\'-5\' oligoadenylate synthetase like 2, pseudogene', 'pseudogene', 'ENSG00000283542'),
(4345, 8095, 'OAZ1', 'ornithine decarboxylase antizyme 1', 'protein-coding gene', 'ENSG00000104904'),
(4346, 54556, 'OAZ1P1', 'OAZ1 pseudogene 1', 'pseudogene', 'ENSG00000226745'),
(4347, 8096, 'OAZ2', 'ornithine decarboxylase antizyme 2', 'protein-coding gene', 'ENSG00000180304'),
(4348, 29092, 'OBSL1', 'obscurin like cytoskeletal adaptor 1', 'protein-coding gene', 'ENSG00000124006'),
(4349, 16074, 'OCIAD1', 'OCIA domain containing 1', 'protein-coding gene', 'ENSG00000109180'),
(4350, 8104, 'OCLN', 'occludin', 'protein-coding gene', 'ENSG00000197822'),
(4351, 53916, 'OCLNP1', 'OCLN pseudogene 1', 'pseudogene', 'ENSG00000230847'),
(4352, 16116, 'OCSTAMP', 'osteoclast stimulatory transmembrane protein', 'protein-coding gene', 'ENSG00000149635'),
(4353, 44937, 'ODAD2P1', 'outer dynein arm docking complex subunit 2 pseudogene 1', 'pseudogene', 'ENSG00000238021'),
(4354, 28303, 'ODAD3', 'outer dynein arm docking complex subunit 3', 'protein-coding gene', 'ENSG00000198003'),
(4355, 25280, 'ODAD4', 'outer dynein arm docking complex subunit 4', 'protein-coding gene', 'ENSG00000204815'),
(4356, 8110, 'ODCP', 'ornithine decarboxylase pseudogene', 'pseudogene', 'ENSG00000244556'),
(4357, 34388, 'ODF3B', 'outer dense fiber of sperm tails 3B', 'protein-coding gene', 'ENSG00000177989'),
(4358, 21017, 'OFCC1', 'orofacial cleft 1 candidate 1', 'other', 'ENSG00000181355'),
(4359, 23875, 'OFD1P3Y', 'OFD1 pseudogene 3 Y-linked', 'pseudogene', 'ENSG00000231988'),
(4360, 23879, 'OFD1P7Y', 'OFD1 pseudogene 7 Y-linked', 'pseudogene', 'ENSG00000238088'),
(4361, 23887, 'OFD1P15Y', 'OFD1 pseudogene 15 Y-linked', 'pseudogene', 'ENSG00000234888'),
(4362, 21378, 'OGFRL1', 'opioid growth factor receptor like 1', 'protein-coding gene', 'ENSG00000119900'),
(4363, 20300, 'OIP5', 'Opa interacting protein 5', 'protein-coding gene', 'ENSG00000104147'),
(4364, 45274, 'OLA1P1', 'OLA1 pseudogene 1', 'pseudogene', 'ENSG00000213790'),
(4365, 45278, 'OLA1P3', 'OLA1 pseudogene 3', 'pseudogene', 'ENSG00000257966'),
(4366, 17990, 'OLFM3', 'olfactomedin 3', 'protein-coding gene', 'ENSG00000118733'),
(4367, 17190, 'OLFM4', 'olfactomedin 4', 'protein-coding gene', 'ENSG00000102837'),
(4368, 9398, 'OLIG2', 'oligodendrocyte transcription factor 2', 'protein-coding gene', 'ENSG00000205927'),
(4369, 29661, 'OMA1', 'OMA1 zinc metallopeptidase', 'protein-coding gene', 'ENSG00000162600'),
(4370, 21382, 'OOEP', 'oocyte expressed protein', 'protein-coding gene', 'ENSG00000203907'),
(4371, 54934, 'OOEPP2', 'OOEP pseudogene 2', 'pseudogene', 'ENSG00000256192'),
(4372, 49241, 'OOSP1P2', 'oocyte secreted protein 1 pseudogene 2', 'pseudogene', 'ENSG00000263749'),
(4373, 53903, 'OOSP3', 'oocyte secreted protein family member 3', 'protein-coding gene', 'ENSG00000285231'),
(4374, 53905, 'OOSP4B', 'oocyte secreted protein family member 4B', 'protein-coding gene', 'ENSG00000255393'),
(4375, 8140, 'OPA1', 'OPA1 mitochondrial dynamin like GTPase', 'protein-coding gene', 'ENSG00000198836'),
(4376, 8142, 'OPA3', 'outer mitochondrial membrane lipid metabolism regulator OPA3', 'protein-coding gene', 'ENSG00000125741'),
(4377, 20707, 'OPALIN', 'oligodendrocytic myelin paranodal and inner loop protein', 'protein-coding gene', 'ENSG00000197430'),
(4378, 4206, 'OPN1MW', 'opsin 1, medium wave sensitive', 'protein-coding gene', 'ENSG00000268221'),
(4379, 8179, 'OR1A1', 'olfactory receptor family 1 subfamily A member 1', 'protein-coding gene', 'ENSG00000172146'),
(4380, 8182, 'OR1C1', 'olfactory receptor family 1 subfamily C member 1', 'protein-coding gene', 'ENSG00000221888'),
(4381, 8191, 'OR1E3', 'olfactory receptor family 1 subfamily E member 3 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000142163'),
(4382, 8194, 'OR1F1', 'olfactory receptor family 1 subfamily F member 1', 'protein-coding gene', 'ENSG00000168124'),
(4383, 8208, 'OR1J1', 'olfactory receptor family 1 subfamily J member 1', 'protein-coding gene', 'ENSG00000136834'),
(4384, 8215, 'OR1L3', 'olfactory receptor family 1 subfamily L member 3', 'protein-coding gene', 'ENSG00000171481'),
(4385, 15110, 'OR1L8', 'olfactory receptor family 1 subfamily L member 8', 'protein-coding gene', 'ENSG00000171496'),
(4386, 8227, 'OR1S1', 'olfactory receptor family 1 subfamily S member 1', 'protein-coding gene', 'ENSG00000280204'),
(4387, 14729, 'OR2A4', 'olfactory receptor family 2 subfamily A member 4', 'protein-coding gene', 'ENSG00000180658'),
(4388, 15083, 'OR2A13P', 'olfactory receptor family 2 subfamily A member 13 pseudogene', 'pseudogene', 'ENSG00000273234'),
(4389, 31246, 'OR2A41P', 'olfactory receptor family 2 subfamily A member 41 pseudogene', 'pseudogene', 'ENSG00000239967'),
(4390, 15142, 'OR2AG1', 'olfactory receptor family 2 subfamily AG member 1', 'protein-coding gene', 'ENSG00000279486'),
(4391, 14712, 'OR2AL1P', 'olfactory receptor family 2 subfamily AL member 1 pseudogene', 'pseudogene', 'ENSG00000254767'),
(4392, 15003, 'OR2AQ1P', 'olfactory receptor family 2 subfamily AQ member 1 pseudogene', 'pseudogene', 'ENSG00000229724'),
(4393, 15004, 'OR2AS1P', 'olfactory receptor family 2 subfamily AS member 1 pseudogene', 'pseudogene', 'ENSG00000227102'),
(4394, 13966, 'OR2B2', 'olfactory receptor family 2 subfamily B member 2', 'protein-coding gene', 'ENSG00000168131'),
(4395, 13968, 'OR2B8P', 'olfactory receptor family 2 subfamily B member 8 pseudogene', 'pseudogene', 'ENSG00000182477'),
(4396, 15008, 'OR2G3', 'olfactory receptor family 2 subfamily G member 3', 'protein-coding gene', 'ENSG00000177476'),
(4397, 8252, 'OR2H1', 'olfactory receptor family 2 subfamily H member 1', 'protein-coding gene', 'ENSG00000204688'),
(4398, 8253, 'OR2H2', 'olfactory receptor family 2 subfamily H member 2', 'protein-coding gene', 'ENSG00000204657'),
(4399, 8261, 'OR2J3', 'olfactory receptor family 2 subfamily J member 3', 'protein-coding gene', 'ENSG00000204701'),
(4400, 8262, 'OR2J4P', 'olfactory receptor family 2 subfamily J member 4 pseudogene', 'pseudogene', 'ENSG00000224233'),
(4401, 8264, 'OR2K2', 'olfactory receptor family 2 subfamily K member 2', 'protein-coding gene', 'ENSG00000171133'),
(4402, 8265, 'OR2L1P', 'olfactory receptor family 2 subfamily L member 1 pseudogene', 'pseudogene', 'ENSG00000224227'),
(4403, 8266, 'OR2L2', 'olfactory receptor family 2 subfamily L member 2', 'protein-coding gene', 'ENSG00000203663'),
(4404, 8267, 'OR2M1P', 'olfactory receptor family 2 subfamily M member 1 pseudogene', 'pseudogene', 'ENSG00000177233'),
(4405, 8273, 'OR2Q1P', 'olfactory receptor family 2 subfamily Q member 1 pseudogene', 'pseudogene', 'ENSG00000273377'),
(4406, 15018, 'OR2T6', 'olfactory receptor family 2 subfamily T member 6', 'protein-coding gene', 'ENSG00000198104'),
(4407, 31255, 'OR2T33', 'olfactory receptor family 2 subfamily T member 33', 'protein-coding gene', 'ENSG00000177212'),
(4408, 8279, 'OR2U2P', 'olfactory receptor family 2 subfamily U member 2 pseudogene', 'pseudogene', 'ENSG00000242524'),
(4409, 8281, 'OR2W1', 'olfactory receptor family 2 subfamily W member 1', 'protein-coding gene', 'ENSG00000204704'),
(4410, 8284, 'OR3A3', 'olfactory receptor family 3 subfamily A member 3', 'protein-coding gene', 'ENSG00000159961'),
(4411, 15510, 'OR3A4P', 'olfactory receptor family 3 subfamily A member 4 pseudogene', 'pseudogene', 'ENSG00000180068'),
(4412, 15159, 'OR4A2P', 'olfactory receptor family 4 subfamily A member 2 pseudogene', 'pseudogene', 'ENSG00000227547'),
(4413, 15166, 'OR4A9P', 'olfactory receptor family 4 subfamily A member 9 pseudogene', 'pseudogene', 'ENSG00000254891'),
(4414, 15155, 'OR4A18P', 'olfactory receptor family 4 subfamily A member 18 pseudogene', 'pseudogene', 'ENSG00000254637'),
(4415, 31261, 'OR4A42P', 'olfactory receptor family 4 subfamily A member 42 pseudogene', 'pseudogene', 'ENSG00000254674'),
(4416, 31265, 'OR4A46P', 'olfactory receptor family 4 subfamily A member 46 pseudogene', 'pseudogene', 'ENSG00000255304'),
(4417, 31269, 'OR4A50P', 'olfactory receptor family 4 subfamily A member 50 pseudogene', 'pseudogene', 'ENSG00000255294'),
(4418, 14800, 'OR4C10P', 'olfactory receptor family 4 subfamily C member 10 pseudogene', 'pseudogene', 'ENSG00000184789'),
(4419, 15172, 'OR4C16', 'olfactory receptor family 4 subfamily C member 16', 'protein-coding gene', 'ENSG00000279514'),
(4420, 31271, 'OR4C46', 'olfactory receptor family 4 subfamily C member 46', 'protein-coding gene', 'ENSG00000185926'),
(4421, 31272, 'OR4C48P', 'olfactory receptor family 4 subfamily C member 48 pseudogene', 'pseudogene', 'ENSG00000283605'),
(4422, 15178, 'OR4D9', 'olfactory receptor family 4 subfamily D member 9', 'protein-coding gene', 'ENSG00000172742'),
(4423, 8300, 'OR4F3', 'olfactory receptor family 4 subfamily F member 3', 'protein-coding gene', 'ENSG00000230178'),
(4424, 14825, 'OR4F5', 'olfactory receptor family 4 subfamily F member 5', 'protein-coding gene', 'ENSG00000186092'),
(4425, 15089, 'OR4F7P', 'olfactory receptor family 4 subfamily F member 7 pseudogene', 'pseudogene', 'ENSG00000217874'),
(4426, 15076, 'OR4F13P', 'olfactory receptor family 4 subfamily F member 13 pseudogene', 'pseudogene', 'ENSG00000214344'),
(4427, 15381, 'OR4F17', 'olfactory receptor family 4 subfamily F member 17', 'protein-coding gene', 'ENSG00000176695'),
(4428, 8303, 'OR4G2P', 'olfactory receptor family 4 subfamily G member 2 pseudogene', 'pseudogene', 'ENSG00000183909'),
(4429, 55112, 'OR4H6BP', 'olfactory receptor family 4 subfamily H member 6B pseudogene', 'pseudogene', 'ENSG00000285116'),
(4430, 14726, 'OR4K1', 'olfactory receptor family 4 subfamily K member 1', 'protein-coding gene', 'ENSG00000155249'),
(4431, 14731, 'OR4K3', 'olfactory receptor family 4 subfamily K member 3 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000176290'),
(4432, 14756, 'OR4K7P', 'olfactory receptor family 4 subfamily K member 7 pseudogene', 'pseudogene', 'ENSG00000265340'),
(4433, 15403, 'OR4K12P', 'olfactory receptor family 4 subfamily K member 12 pseudogene', 'pseudogene', 'ENSG00000218549'),
(4434, 15351, 'OR4K13', 'olfactory receptor family 4 subfamily K member 13', 'protein-coding gene', 'ENSG00000176253'),
(4435, 15355, 'OR4K17', 'olfactory receptor family 4 subfamily K member 17', 'protein-coding gene', 'ENSG00000176230'),
(4436, 56199, 'OR4M2-OT1', 'OR4M2 overlapping transcript 1', 'non-coding RNA', 'ENSG00000285472'),
(4437, 15375, 'OR4N4', 'olfactory receptor family 4 subfamily N member 4', 'protein-coding gene', 'ENSG00000183706'),
(4438, 15426, 'OR4Q3', 'olfactory receptor family 4 subfamily Q member 3', 'protein-coding gene', 'ENSG00000182652'),
(4439, 14705, 'OR4S1', 'olfactory receptor family 4 subfamily S member 1', 'protein-coding gene', 'ENSG00000176555'),
(4440, 14736, 'OR4V1P', 'olfactory receptor family 4 subfamily V member 1 pseudogene', 'pseudogene', 'ENSG00000254841'),
(4441, 8319, 'OR5A1', 'olfactory receptor family 5 subfamily A member 1', 'protein-coding gene', 'ENSG00000172320'),
(4442, 15431, 'OR5AC2', 'olfactory receptor family 5 subfamily AC member 2', 'protein-coding gene', 'ENSG00000196578'),
(4443, 15253, 'OR5AK4P', 'olfactory receptor family 5 subfamily AK member 4 pseudogene', 'pseudogene', 'ENSG00000283307'),
(4444, 15256, 'OR5AN2P', 'olfactory receptor family 5 subfamily AN member 2 pseudogene', 'pseudogene', 'ENSG00000235678'),
(4445, 15260, 'OR5AR1', 'olfactory receptor family 5 subfamily AR member 1', 'protein-coding gene', 'ENSG00000172459'),
(4446, 15362, 'OR5AU1', 'olfactory receptor family 5 subfamily AU member 1', 'protein-coding gene', 'ENSG00000169327'),
(4447, 8322, 'OR5B1P', 'olfactory receptor family 5 subfamily B member 1 pseudogene', 'pseudogene', 'ENSG00000233499'),
(4448, 15272, 'OR5BC1P', 'olfactory receptor family 5 subfamily BC member 1 pseudogene', 'pseudogene', 'ENSG00000255218'),
(4449, 14843, 'OR5BD1P', 'olfactory receptor family 5 subfamily BD member 1 pseudogene', 'pseudogene', 'ENSG00000254749'),
(4450, 15273, 'OR5BE1P', 'olfactory receptor family 5 subfamily BE member 1 pseudogene', 'pseudogene', 'ENSG00000225538'),
(4451, 15434, 'OR5BJ1P', 'olfactory receptor family 5 subfamily BJ member 1 pseudogene', 'pseudogene', 'ENSG00000257792'),
(4452, 8331, 'OR5C1', 'olfactory receptor family 5 subfamily C member 1', 'protein-coding gene', 'ENSG00000148215'),
(4453, 15284, 'OR5D17P', 'olfactory receptor family 5 subfamily D member 17 pseudogene', 'pseudogene', 'ENSG00000181837'),
(4454, 15285, 'OR5D18', 'olfactory receptor family 5 subfamily D member 18', 'protein-coding gene', 'ENSG00000186119'),
(4455, 8343, 'OR5F1', 'olfactory receptor family 5 subfamily F member 1', 'protein-coding gene', 'ENSG00000149133'),
(4456, 8344, 'OR5G1P', 'olfactory receptor family 5 subfamily G member 1 pseudogene', 'pseudogene', 'ENSG00000181296'),
(4457, 31286, 'OR5H14', 'olfactory receptor family 5 subfamily H member 14', 'protein-coding gene', 'ENSG00000236032'),
(4458, 8347, 'OR5I1', 'olfactory receptor family 5 subfamily I member 1', 'protein-coding gene', 'ENSG00000167825'),
(4459, 31289, 'OR5J7P', 'olfactory receptor family 5 subfamily J member 7 pseudogene', 'pseudogene', 'ENSG00000255217'),
(4460, 31291, 'OR5K4', 'olfactory receptor family 5 subfamily K member 4', 'protein-coding gene', 'ENSG00000196098'),
(4461, 8352, 'OR5M1', 'olfactory receptor family 5 subfamily M member 1', 'protein-coding gene', 'ENSG00000255012'),
(4462, 14803, 'OR5M2P', 'olfactory receptor family 5 subfamily M member 2 pseudogene', 'pseudogene', 'ENSG00000254752'),
(4463, 14814, 'OR5M6P', 'olfactory receptor family 5 subfamily M member 6 pseudogene', 'pseudogene', 'ENSG00000254603'),
(4464, 15040, 'OR5S1P', 'olfactory receptor family 5 subfamily S member 1 pseudogene', 'pseudogene', 'ENSG00000213048'),
(4465, 15296, 'OR5T2', 'olfactory receptor family 5 subfamily T member 2', 'protein-coding gene', 'ENSG00000181718'),
(4466, 8355, 'OR6C1', 'olfactory receptor family 6 subfamily C member 1', 'protein-coding gene', 'ENSG00000205330'),
(4467, 19632, 'OR6C4', 'olfactory receptor family 6 subfamily C member 4', 'protein-coding gene', 'ENSG00000179626'),
(4468, 31296, 'OR6C66P', 'olfactory receptor family 6 subfamily C member 66 pseudogene', 'pseudogene', 'ENSG00000233606'),
(4469, 31303, 'OR6C74', 'olfactory receptor family 6 subfamily C member 74', 'protein-coding gene', 'ENSG00000197706'),
(4470, 15031, 'OR6K4P', 'olfactory receptor family 6 subfamily K member 4 pseudogene', 'pseudogene', 'ENSG00000180437'),
(4471, 14713, 'OR6M2P', 'olfactory receptor family 6 subfamily M member 2 pseudogene', 'pseudogene', 'ENSG00000254613'),
(4472, 14848, 'OR6T1', 'olfactory receptor family 6 subfamily T member 1', 'protein-coding gene', 'ENSG00000181499'),
(4473, 15091, 'OR6W1P', 'olfactory receptor family 6 subfamily W member 1 pseudogene', 'pseudogene', 'ENSG00000179420'),
(4474, 8364, 'OR7A1P', 'olfactory receptor family 7 subfamily A member 1 pseudogene', 'pseudogene', 'ENSG00000268834'),
(4475, 8356, 'OR7A10', 'olfactory receptor family 7 subfamily A member 10', 'protein-coding gene', 'ENSG00000127515'),
(4476, 8377, 'OR7D1P', 'olfactory receptor family 7 subfamily D member 1 pseudogene', 'pseudogene', 'ENSG00000188314'),
(4477, 8378, 'OR7D2', 'olfactory receptor family 7 subfamily D member 2', 'protein-coding gene', 'ENSG00000188000'),
(4478, 8458, 'OR7E8P', 'olfactory receptor family 7 subfamily E member 8 pseudogene', 'pseudogene', 'ENSG00000177400'),
(4479, 8385, 'OR7E14P', 'olfactory receptor family 7 subfamily E member 14 pseudogene', 'pseudogene', 'ENSG00000184669'),
(4480, 8420, 'OR7E46P', 'olfactory receptor family 7 subfamily E member 46 pseudogene', 'pseudogene', 'ENSG00000234485'),
(4481, 8430, 'OR7E55P', 'olfactory receptor family 7 subfamily E member 55 pseudogene', 'pseudogene', 'ENSG00000230655'),
(4482, 8434, 'OR7E59P', 'olfactory receptor family 7 subfamily E member 59 pseudogene', 'pseudogene', 'ENSG00000250561'),
(4483, 14688, 'OR7E83P', 'olfactory receptor family 7 subfamily E member 83 pseudogene', 'pseudogene', 'ENSG00000249866'),
(4484, 14733, 'OR7E90P', 'olfactory receptor family 7 subfamily E member 90 pseudogene', 'pseudogene', 'ENSG00000188668'),
(4485, 14815, 'OR7E96P', 'olfactory receptor family 7 subfamily E member 96 pseudogene', 'pseudogene', 'ENSG00000227013'),
(4486, 14834, 'OR7E97P', 'olfactory receptor family 7 subfamily E member 97 pseudogene', 'pseudogene', 'ENSG00000179170'),
(4487, 15043, 'OR7E102P', 'olfactory receptor family 7 subfamily E member 102 pseudogene', 'pseudogene', 'ENSG00000168992'),
(4488, 15365, 'OR7E106P', 'olfactory receptor family 7 subfamily E member 106 pseudogene', 'pseudogene', 'ENSG00000258550'),
(4489, 55115, 'OR7E111FP', 'olfactory receptor family 7 subfamily E member 111F pseudogene', 'pseudogene', 'ENSG00000250804'),
(4490, 19561, 'OR7E140P', 'olfactory receptor family 7 subfamily E member 140 pseudogene', 'pseudogene', 'ENSG00000238152'),
(4491, 31309, 'OR7E154P', 'olfactory receptor family 7 subfamily E member 154 pseudogene', 'pseudogene', 'ENSG00000254715'),
(4492, 28374, 'OR7E162P', 'olfactory receptor family 7 subfamily E member 162 pseudogene', 'pseudogene', 'ENSG00000234386'),
(4493, 8466, 'OR7G2', 'olfactory receptor family 7 subfamily G member 2', 'protein-coding gene', 'ENSG00000170923'),
(4494, 14827, 'OR7L1P', 'olfactory receptor family 7 subfamily L member 1 pseudogene', 'pseudogene', 'ENSG00000232787'),
(4495, 15128, 'OR7M1P', 'olfactory receptor family 7 subfamily M member 1 pseudogene', 'pseudogene', 'ENSG00000273336'),
(4496, 8469, 'OR8A1', 'olfactory receptor family 8 subfamily A member 1', 'protein-coding gene', 'ENSG00000196119'),
(4497, 8474, 'OR8B5P', 'olfactory receptor family 8 subfamily B member 5 pseudogene', 'pseudogene', 'ENSG00000255030'),
(4498, 14746, 'OR8B9P', 'olfactory receptor family 8 subfamily B member 9 pseudogene', 'pseudogene', 'ENSG00000229386'),
(4499, 14698, 'OR8G3P', 'olfactory receptor family 8 subfamily G member 3 pseudogene', 'pseudogene', 'ENSG00000255425'),
(4500, 15309, 'OR8H3', 'olfactory receptor family 8 subfamily H member 3', 'protein-coding gene', 'ENSG00000181761'),
(4501, 15313, 'OR8K3', 'olfactory receptor family 8 subfamily K member 3 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000280314'),
(4502, 14841, 'OR8U3', 'olfactory receptor family 8 subfamily U member 3', 'protein-coding gene', 'ENSG00000279961'),
(4503, 31318, 'OR8X1P', 'olfactory receptor family 8 subfamily X member 1 pseudogene', 'pseudogene', 'ENSG00000255048'),
(4504, 15321, 'OR9G3P', 'olfactory receptor family 9 subfamily G member 3 pseudogene', 'pseudogene', 'ENSG00000181325'),
(4505, 14718, 'OR9I1', 'olfactory receptor family 9 subfamily I member 1', 'protein-coding gene', 'ENSG00000172377'),
(4506, 15096, 'OR9N1P', 'olfactory receptor family 9 subfamily N member 1 pseudogene', 'pseudogene', 'ENSG00000244292'),
(4507, 8161, 'OR10A2', 'olfactory receptor family 10 subfamily A member 2', 'protein-coding gene', 'ENSG00000170790'),
(4508, 15132, 'OR10A6', 'olfactory receptor family 10 subfamily A member 6 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000279000'),
(4509, 14758, 'OR10AC1', 'olfactory receptor family 10 subfamily AC member 1 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000176510'),
(4510, 14819, 'OR10AD1', 'olfactory receptor family 10 subfamily AD member 1', 'protein-coding gene', 'ENSG00000172640'),
(4511, 14990, 'OR10AE1P', 'olfactory receptor family 10 subfamily AE member 1 pseudogene', 'pseudogene', 'ENSG00000271890'),
(4512, 31235, 'OR10AE3P', 'olfactory receptor family 10 subfamily AE member 3 pseudogene', 'pseudogene', 'ENSG00000272837'),
(4513, 8170, 'OR10G2', 'olfactory receptor family 10 subfamily G member 2', 'protein-coding gene', 'ENSG00000255582'),
(4514, 8171, 'OR10G3', 'olfactory receptor family 10 subfamily G member 3', 'protein-coding gene', 'ENSG00000169208'),
(4515, 15129, 'OR10G9', 'olfactory receptor family 10 subfamily G member 9', 'protein-coding gene', 'ENSG00000236981'),
(4516, 8172, 'OR10H1', 'olfactory receptor family 10 subfamily H member 1', 'protein-coding gene', 'ENSG00000186723'),
(4517, 8173, 'OR10H2', 'olfactory receptor family 10 subfamily H member 2', 'protein-coding gene', 'ENSG00000171942'),
(4518, 14992, 'OR10J3', 'olfactory receptor family 10 subfamily J member 3', 'protein-coding gene', 'ENSG00000196266'),
(4519, 15408, 'OR10J4', 'olfactory receptor family 10 subfamily J member 4 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000249730'),
(4520, 14689, 'OR10N1P', 'olfactory receptor family 10 subfamily N member 1 pseudogene', 'pseudogene', 'ENSG00000213181'),
(4521, 14813, 'OR10R1P', 'olfactory receptor family 10 subfamily R member 1 pseudogene', 'pseudogene', 'ENSG00000227445'),
(4522, 15136, 'OR10V1', 'olfactory receptor family 10 subfamily V member 1', 'protein-coding gene', 'ENSG00000172289'),
(4523, 14996, 'OR10Z1', 'olfactory receptor family 10 subfamily Z member 1', 'protein-coding gene', 'ENSG00000198967'),
(4524, 15347, 'OR11H4', 'olfactory receptor family 11 subfamily H member 4', 'protein-coding gene', 'ENSG00000176198'),
(4525, 14998, 'OR11L1', 'olfactory receptor family 11 subfamily L member 1', 'protein-coding gene', 'ENSG00000197591'),
(4526, 19582, 'OR11N1P', 'olfactory receptor family 11 subfamily N member 1 pseudogene', 'pseudogene', 'ENSG00000185903'),
(4527, 19636, 'OR11P1P', 'olfactory receptor family 11 subfamily P member 1 pseudogene', 'pseudogene', 'ENSG00000284742'),
(4528, 8178, 'OR12D2', 'olfactory receptor family 12 subfamily D member 2', 'protein-coding gene', 'ENSG00000280236'),
(4529, 14701, 'OR13C2', 'olfactory receptor family 13 subfamily C member 2', 'protein-coding gene', 'ENSG00000276119'),
(4530, 14722, 'OR13C4', 'olfactory receptor family 13 subfamily C member 4', 'protein-coding gene', 'ENSG00000148136'),
(4531, 15101, 'OR13C6P', 'olfactory receptor family 13 subfamily C member 6 pseudogene', 'pseudogene', 'ENSG00000179443'),
(4532, 15106, 'OR13D3P', 'olfactory receptor family 13 subfamily D member 3 pseudogene', 'pseudogene', 'ENSG00000188712'),
(4533, 15107, 'OR13E1P', 'olfactory receptor family 13 subfamily E member 1 pseudogene', 'pseudogene', 'ENSG00000236083'),
(4534, 14999, 'OR13G1', 'olfactory receptor family 13 subfamily G member 1', 'protein-coding gene', 'ENSG00000197437'),
(4535, 31240, 'OR13Z1P', 'olfactory receptor family 13 subfamily Z member 1 pseudogene', 'pseudogene', 'ENSG00000226653'),
(4536, 19575, 'OR14I1', 'olfactory receptor family 14 subfamily I member 1', 'protein-coding gene', 'ENSG00000189181'),
(4537, 19599, 'OR51B5', 'olfactory receptor family 51 subfamily B member 5', 'protein-coding gene', 'ENSG00000167355'),
(4538, 15193, 'OR51D1', 'olfactory receptor family 51 subfamily D member 1', 'protein-coding gene', 'ENSG00000197428'),
(4539, 31282, 'OR51F4P', 'olfactory receptor family 51 subfamily F member 4 pseudogene', 'pseudogene', 'ENSG00000273051'),
(4540, 14738, 'OR51G1', 'olfactory receptor family 51 subfamily G member 1', 'protein-coding gene', 'ENSG00000278870'),
(4541, 15199, 'OR51H2P', 'olfactory receptor family 51 subfamily H member 2 pseudogene', 'pseudogene', 'ENSG00000198217'),
(4542, 15202, 'OR51K1P', 'olfactory receptor family 51 subfamily K member 1 pseudogene', 'pseudogene', 'ENSG00000248424'),
(4543, 14759, 'OR51L1', 'olfactory receptor family 51 subfamily L member 1', 'protein-coding gene', 'ENSG00000176798'),
(4544, 15203, 'OR51R1P', 'olfactory receptor family 51 subfamily R member 1 pseudogene', 'pseudogene', 'ENSG00000237272'),
(4545, 19597, 'OR51V1', 'olfactory receptor family 51 subfamily V member 1', 'protein-coding gene', 'ENSG00000176742'),
(4546, 19579, 'OR52A4P', 'olfactory receptor family 52 subfamily A member 4 pseudogene', 'pseudogene', 'ENSG00000205494'),
(4547, 14766, 'OR52E1', 'olfactory receptor family 52 subfamily E member 1 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000273085'),
(4548, 15217, 'OR52E8', 'olfactory receptor family 52 subfamily E member 8', 'protein-coding gene', 'ENSG00000183269'),
(4549, 15219, 'OR52H2P', 'olfactory receptor family 52 subfamily H member 2 pseudogene', 'pseudogene', 'ENSG00000248553'),
(4550, 15225, 'OR52M1', 'olfactory receptor family 52 subfamily M member 1', 'protein-coding gene', 'ENSG00000197790'),
(4551, 15231, 'OR52N5', 'olfactory receptor family 52 subfamily N member 5', 'protein-coding gene', 'ENSG00000181009'),
(4552, 15235, 'OR52R1', 'olfactory receptor family 52 subfamily R member 1', 'protein-coding gene', 'ENSG00000279270'),
(4553, 15237, 'OR52U1P', 'olfactory receptor family 52 subfamily U member 1 pseudogene', 'pseudogene', 'ENSG00000232381'),
(4554, 15239, 'OR52W1', 'olfactory receptor family 52 subfamily W member 1', 'protein-coding gene', 'ENSG00000175485'),
(4555, 14786, 'OR56A3', 'olfactory receptor family 56 subfamily A member 3', 'protein-coding gene', 'ENSG00000184478'),
(4556, 15248, 'OR56B4', 'olfactory receptor family 56 subfamily B member 4', 'protein-coding gene', 'ENSG00000180919'),
(4557, 16994, 'OS9', 'OS9 endoplasmic reticulum lectin', 'protein-coding gene', 'ENSG00000135506'),
(4558, 8503, 'OSBP', 'oxysterol binding protein', 'protein-coding gene', 'ENSG00000110048');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(4559, 16398, 'OSBPL1A', 'oxysterol binding protein like 1A', 'protein-coding gene', 'ENSG00000141447'),
(4560, 16386, 'OSBPL9', 'oxysterol binding protein like 9', 'protein-coding gene', 'ENSG00000117859'),
(4561, 48732, 'OSBPL9P2', 'oxysterol binding protein like 9 pseudogene 2', 'pseudogene', 'ENSG00000254677'),
(4562, 48735, 'OSBPL9P5', 'oxysterol binding protein like 9 pseudogene 5', 'pseudogene', 'ENSG00000256285'),
(4563, 16395, 'OSBPL10', 'oxysterol binding protein like 10', 'protein-coding gene', 'ENSG00000144645'),
(4564, 48585, 'OSER1-DT', 'OSER1 divergent transcript', 'non-coding RNA', 'ENSG00000223891'),
(4565, 30093, 'OSGIN1', 'oxidative stress induced growth inhibitor 1', 'protein-coding gene', 'ENSG00000140961'),
(4566, 1355, 'OSGIN2', 'oxidative stress induced growth inhibitor family member 2', 'protein-coding gene', 'ENSG00000164823'),
(4567, 8111, 'OSR1', 'odd-skipped related transcription factor 1', 'protein-coding gene', 'ENSG00000143867'),
(4568, 15830, 'OSR2', 'odd-skipped related transciption factor 2', 'protein-coding gene', 'ENSG00000164920'),
(4569, 42865, 'OSTCP3', 'oligosaccharyltransferase complex subunit pseudogene 3', 'pseudogene', 'ENSG00000269608'),
(4570, 42869, 'OSTCP8', 'oligosaccharyltransferase complex subunit pseudogene 8', 'pseudogene', 'ENSG00000226801'),
(4571, 21652, 'OSTM1', 'osteoclastogenesis associated transmembrane protein 1', 'protein-coding gene', 'ENSG00000081087'),
(4572, 41250, 'OSTN-AS1', 'OSTN antisense RNA 1', 'non-coding RNA', 'ENSG00000233308'),
(4573, 8515, 'OTOF', 'otoferlin', 'protein-coding gene', 'ENSG00000115155'),
(4574, 34071, 'OTOL1', 'otolin 1', 'protein-coding gene', 'ENSG00000182447'),
(4575, 19656, 'OTOP1', 'otopetrin 1', 'protein-coding gene', 'ENSG00000163982'),
(4576, 8518, 'OTP', 'orthopedia homeobox', 'protein-coding gene', 'ENSG00000171540'),
(4577, 25402, 'OTUD5', 'OTU deubiquitinase 5', 'protein-coding gene', 'ENSG00000068308'),
(4578, 25118, 'OTULIN', 'OTU deubiquitinase with linear linkage specificity', 'protein-coding gene', 'ENSG00000154124'),
(4579, 25629, 'OTULINL', 'OTU deubiquitinase with linear linkage specificity like', 'protein-coding gene', 'ENSG00000145569'),
(4580, 8522, 'OTX2', 'orthodenticle homeobox 2', 'protein-coding gene', 'ENSG00000165588'),
(4581, 44484, 'OVCH1-AS1', 'OVCH1 antisense RNA 1', 'non-coding RNA', 'ENSG00000257599'),
(4582, 55448, 'OXA1L-DT', 'OXA1L divergent transcript', 'non-coding RNA', 'ENSG00000258458'),
(4583, 18606, 'OXCT2', '3-oxoacid CoA-transferase 2', 'protein-coding gene', 'ENSG00000198754'),
(4584, 55533, 'OXR1-AS1', 'OXR1 antisense RNA 1', 'non-coding RNA', 'ENSG00000253582'),
(4585, 8529, 'OXTR', 'oxytocin receptor', 'protein-coding gene', 'ENSG00000180914'),
(4586, 8533, 'P2RX1', 'purinergic receptor P2X 1', 'protein-coding gene', 'ENSG00000108405'),
(4587, 49191, 'P2RX5-TAX1BP3', 'P2RX5-TAX1BP3 readthrough (NMD candidate)', 'other', 'ENSG00000257950'),
(4588, 8537, 'P2RX7', 'purinergic receptor P2X 7', 'protein-coding gene', 'ENSG00000089041'),
(4589, 40886, 'P3H2-AS1', 'P3H2 antisense RNA 1', 'non-coding RNA', 'ENSG00000225764'),
(4590, 53451, 'P3R3URF', 'PIK3R3 upstream open reading frame', 'protein-coding gene', 'ENSG00000250719'),
(4591, 54999, 'P3R3URF-PIK3R3', 'P3R3URF-PIK3R3 readthrough', 'other', 'ENSG00000278139'),
(4592, 30135, 'P4HA3', 'prolyl 4-hydroxylase subunit alpha 3', 'protein-coding gene', 'ENSG00000149380'),
(4593, 28858, 'P4HTM', 'prolyl 4-hydroxylase, transmembrane', 'protein-coding gene', 'ENSG00000178467'),
(4594, 8551, 'PA2G4P1', 'proliferation-associated 2G4 pseudogene 1', 'pseudogene', 'ENSG00000237828'),
(4595, 32219, 'PA2G4P6', 'proliferation-associated 2G4 pseudogene 6', 'pseudogene', 'ENSG00000231799'),
(4596, 8554, 'PABPC1', 'poly(A) binding protein cytoplasmic 1', 'protein-coding gene', 'ENSG00000070756'),
(4597, 50345, 'PABPC1L2B-AS1', 'PABPC1L2B antisense RNA 1 (head to head)', 'non-coding RNA', 'ENSG00000226725'),
(4598, 8558, 'PABPC1P1', 'poly(A) binding protein cytoplasmic 1 pseudogene 1', 'pseudogene', 'ENSG00000231707'),
(4599, 8559, 'PABPC1P2', 'poly(A) binding protein cytoplasmic 1 pseudogene 2', 'pseudogene', 'ENSG00000198526'),
(4600, 8560, 'PABPC1P3', 'poly(A) binding protein cytoplasmic 1 pseudogene 3', 'pseudogene', 'ENSG00000230673'),
(4601, 8563, 'PABPC1P4', 'poly(A) binding protein cytoplasmic 1 pseudogene 4', 'pseudogene', 'ENSG00000255642'),
(4602, 37995, 'PABPC1P13', 'poly(A) binding protein cytoplasmic 1 pseudogene 13', 'pseudogene', 'ENSG00000260307'),
(4603, 40424, 'PABPC4-AS1', 'PABPC4 antisense RNA 1', 'non-coding RNA', 'ENSG00000228060'),
(4604, 50552, 'PACERR', 'PTGS2 antisense NFKB1 complex-mediated expression regulator RNA', 'non-coding RNA', 'ENSG00000273129'),
(4605, 30032, 'PACS1', 'phosphofurin acidic cluster sorting protein 1', 'protein-coding gene', 'ENSG00000175115'),
(4606, 18368, 'PADI4', 'peptidyl arginine deiminase 4', 'protein-coding gene', 'ENSG00000159339'),
(4607, 54906, 'PAFAH1B2P2', 'PAFAH1B2 pseudogene 2', 'pseudogene', 'ENSG00000257501'),
(4608, 30043, 'PAG1', 'phosphoprotein membrane anchor with glycosphingolipid microdomains 1', 'protein-coding gene', 'ENSG00000076641'),
(4609, 28707, 'PAGR1', 'PAXIP1 associated glutamate rich protein 1', 'protein-coding gene', 'ENSG00000280789'),
(4610, 8587, 'PAICS', 'phosphoribosylaminoimidazole carboxylase and phosphoribosylaminoimidazolesuccinocarboxamide synthase', 'protein-coding gene', 'ENSG00000128050'),
(4611, 38100, 'PAICSP7', 'phosphoribosylaminoimidazole carboxylase, phosphoribosylaminoimidazole succinocarboxamide synthetase pseudogene 7', 'pseudogene', 'ENSG00000232293'),
(4612, 16945, 'PAIP1', 'poly(A) binding protein interacting protein 1', 'protein-coding gene', 'ENSG00000172239'),
(4613, 8592, 'PAK3', 'p21 (RAC1) activated kinase 3', 'protein-coding gene', 'ENSG00000077264'),
(4614, 16059, 'PAK4', 'p21 (RAC1) activated kinase 4', 'protein-coding gene', 'ENSG00000130669'),
(4615, 15916, 'PAK5', 'p21 (RAC1) activated kinase 5', 'protein-coding gene', 'ENSG00000101349'),
(4616, 16061, 'PAK6', 'p21 (RAC1) activated kinase 6', 'protein-coding gene', 'ENSG00000137843'),
(4617, 33868, 'PAK6-AS1', 'PAK6 antisense RNA 1', 'non-coding RNA', 'ENSG00000176753'),
(4618, 17068, 'PALLD', 'palladin, cytoskeletal associated protein', 'protein-coding gene', 'ENSG00000129116'),
(4619, 33274, 'PALM3', 'paralemmin 3', 'protein-coding gene', 'ENSG00000187867'),
(4620, 18669, 'PALS1', 'protein associated with LIN7 1, MAGUK p55 family member', 'protein-coding gene', 'ENSG00000072415'),
(4621, 20074, 'PAN2', 'poly(A) specific ribonuclease subunit PAN2', 'protein-coding gene', 'ENSG00000135473'),
(4622, 44048, 'PANDAR', 'promoter of CDKN1A antisense DNA damage activated RNA', 'non-coding RNA', 'ENSG00000281450'),
(4623, 19366, 'PANK4', 'pantothenate kinase 4 (inactive)', 'protein-coding gene', 'ENSG00000157881'),
(4624, 15970, 'PAPOLB', 'poly(A) polymerase beta', 'protein-coding gene', 'ENSG00000218823'),
(4625, 35152, 'PAPPA-AS1', 'PAPPA antisense RNA 1', 'non-coding RNA', 'ENSG00000256040'),
(4626, 14615, 'PAPPA2', 'pappalysin 2', 'protein-coding gene', 'ENSG00000116183'),
(4627, 45008, 'PARGP1', 'poly(ADP-ribose) glycohydrolase pseudogene 1', 'pseudogene', 'ENSG00000239883'),
(4628, 8609, 'PARN', 'poly(A)-specific ribonuclease', 'protein-coding gene', 'ENSG00000140694'),
(4629, 272, 'PARP2', 'poly(ADP-ribose) polymerase 2', 'protein-coding gene', 'ENSG00000129484'),
(4630, 37760, 'PARP4P2', 'poly(ADP-ribose) polymerase family member 4 pseudogene 2', 'pseudogene', 'ENSG00000224976'),
(4631, 274, 'PARP4P3', 'poly(ADP-ribose) polymerase family member 4 pseudogene 3', 'pseudogene', 'ENSG00000249263'),
(4632, 1186, 'PARP11', 'poly(ADP-ribose) polymerase family member 11', 'protein-coding gene', 'ENSG00000111224'),
(4633, 21919, 'PARP12', 'poly(ADP-ribose) polymerase family member 12', 'protein-coding gene', 'ENSG00000059378'),
(4634, 26074, 'PARPBP', 'PARP1 binding protein', 'protein-coding gene', 'ENSG00000185480'),
(4635, 30563, 'PARS2', 'prolyl-tRNA synthetase 2, mitochondrial', 'protein-coding gene', 'ENSG00000162396'),
(4636, 17263, 'PART1', 'prostate androgen-regulated transcript 1', 'non-coding RNA', 'ENSG00000152931'),
(4637, 14652, 'PARVA', 'parvin alpha', 'protein-coding gene', 'ENSG00000197702'),
(4638, 14653, 'PARVB', 'parvin beta', 'protein-coding gene', 'ENSG00000188677'),
(4639, 20686, 'PASD1', 'PAS domain containing repressor 1', 'protein-coding gene', 'ENSG00000166049'),
(4640, 35427, 'PATE4', 'prostate and testis expressed 4', 'protein-coding gene', 'ENSG00000237353'),
(4641, 8616, 'PAX2', 'paired box 2', 'protein-coding gene', 'ENSG00000075891'),
(4642, 8617, 'PAX3', 'paired box 3', 'protein-coding gene', 'ENSG00000135903'),
(4643, 8619, 'PAX5', 'paired box 5', 'protein-coding gene', 'ENSG00000196092'),
(4644, 39603, 'PAXBP1-AS1', 'PAXBP1 antisense RNA 1', 'non-coding RNA', 'ENSG00000238197'),
(4645, 27849, 'PAXX', 'PAXX non-homologous end joining factor', 'protein-coding gene', 'ENSG00000148362'),
(4646, 23301, 'PBLD', 'phenazine biosynthesis like protein domain containing', 'protein-coding gene', 'ENSG00000108187'),
(4647, 13403, 'PBX4', 'PBX homeobox 4', 'protein-coding gene', 'ENSG00000105717'),
(4648, 34383, 'PCARE', 'photoreceptor cilium actin regulator', 'protein-coding gene', 'ENSG00000179270'),
(4649, 8646, 'PCBD1', 'pterin-4 alpha-carbinolamine dehydratase 1', 'protein-coding gene', 'ENSG00000166228'),
(4650, 39032, 'PCBP2P3', 'poly(rC) binding protein 2 pseudogene 3', 'pseudogene', 'ENSG00000248826'),
(4651, 40426, 'PCBP3-AS1', 'PCBP3 antisense RNA 1', 'non-coding RNA', 'ENSG00000205424'),
(4652, 39901, 'PCCA-AS1', 'PCCA antisense RNA 1', 'non-coding RNA', 'ENSG00000234650'),
(4653, 8661, 'PCDH9', 'protocadherin 9', 'protein-coding gene', 'ENSG00000184226'),
(4654, 40428, 'PCDH9-AS4', 'PCDH9 antisense RNA 4', 'non-coding RNA', 'ENSG00000233840'),
(4655, 14674, 'PCDH15', 'protocadherin related 15', 'protein-coding gene', 'ENSG00000150275'),
(4656, 14270, 'PCDH19', 'protocadherin 19', 'protein-coding gene', 'ENSG00000165194'),
(4657, 8670, 'PCDHA4', 'protocadherin alpha 4', 'other', 'ENSG00000204967'),
(4658, 8675, 'PCDHA9', 'protocadherin alpha 9', 'other', 'ENSG00000204961'),
(4659, 8665, 'PCDHA11', 'protocadherin alpha 11', 'other', 'ENSG00000249158'),
(4660, 8676, 'PCDHAC1', 'protocadherin alpha subfamily C, 1', 'other', 'ENSG00000248383'),
(4661, 8689, 'PCDHB4', 'protocadherin beta 4', 'other', 'ENSG00000081818'),
(4662, 8682, 'PCDHB11', 'protocadherin beta 11', 'other', 'ENSG00000197479'),
(4663, 14548, 'PCDHB18P', 'protocadherin beta 18 pseudogene', 'pseudogene', 'ENSG00000146001'),
(4664, 8701, 'PCDHGA3', 'protocadherin gamma subfamily A, 3', 'other', 'ENSG00000254245'),
(4665, 8703, 'PCDHGA5', 'protocadherin gamma subfamily A, 5', 'other', 'ENSG00000253485'),
(4666, 8706, 'PCDHGA8', 'protocadherin gamma subfamily A, 8', 'other', 'ENSG00000253767'),
(4667, 8714, 'PCDHGB7', 'protocadherin gamma subfamily B, 7', 'other', 'ENSG00000254122'),
(4668, 15688, 'PCDHGB9P', 'protocadherin gamma subfamily B, 9 pseudogene', 'pseudogene', 'ENSG00000276545'),
(4669, 8718, 'PCDHGC5', 'protocadherin gamma subfamily C, 5', 'other', 'ENSG00000240764'),
(4670, 44166, 'PCED1B-AS1', 'PCED1B antisense RNA 1', 'non-coding RNA', 'ENSG00000247774'),
(4671, 30097, 'PCF11', 'PCF11 cleavage and polyadenylation factor subunit', 'protein-coding gene', 'ENSG00000165494'),
(4672, 28264, 'PCGF5', 'polycomb group ring finger 5', 'protein-coding gene', 'ENSG00000180628'),
(4673, 21156, 'PCGF6', 'polycomb group ring finger 6', 'protein-coding gene', 'ENSG00000156374'),
(4674, 28961, 'PCLAF', 'PCNA clamp associated factor', 'protein-coding gene', 'ENSG00000166803'),
(4675, 55791, 'PCMTD1-DT', 'PCMTD1 divergent transcript', 'non-coding RNA', 'ENSG00000228801'),
(4676, 20349, 'PCNX4', 'pecanex 4', 'protein-coding gene', 'ENSG00000126773'),
(4677, 17301, 'PCSK1N', 'proprotein convertase subtilisin/kexin type 1 inhibitor', 'protein-coding gene', 'ENSG00000102109'),
(4678, 8748, 'PCSK7', 'proprotein convertase subtilisin/kexin type 7', 'protein-coding gene', 'ENSG00000160613'),
(4679, 8754, 'PCYT1A', 'phosphate cytidylyltransferase 1A, choline', 'protein-coding gene', 'ENSG00000161217'),
(4680, 14634, 'PDAP1', 'PDGFA associated protein 1', 'protein-coding gene', 'ENSG00000106244'),
(4681, 8759, 'PDC', 'phosducin', 'protein-coding gene', 'ENSG00000116703'),
(4682, 18731, 'PDCD1LG2', 'programmed cell death 1 ligand 2', 'protein-coding gene', 'ENSG00000197646'),
(4683, 27425, 'PDCD4-AS1', 'PDCD4 antisense RNA 1', 'non-coding RNA', 'ENSG00000203497'),
(4684, 55763, 'PDCD6P1', 'PDCD6 pseudogene 1', 'pseudogene', 'ENSG00000188002'),
(4685, 13408, 'PDCD11', 'programmed cell death 11', 'protein-coding gene', 'ENSG00000148843'),
(4686, 29524, 'PDCL2', 'phosducin like 2', 'protein-coding gene', 'ENSG00000163440'),
(4687, 50340, 'PDCL2P1', 'PDCL2 pseudogene 1', 'pseudogene', 'ENSG00000228610'),
(4688, 50341, 'PDCL2P2', 'PDCL2 pseudogene 2', 'pseudogene', 'ENSG00000255058'),
(4689, 44504, 'PDCL3P3', 'PDCL3 pseudogene 3', 'pseudogene', 'ENSG00000214286'),
(4690, 40434, 'PDE2A-AS2', 'PDE2A antisense RNA 2', 'non-coding RNA', 'ENSG00000256633'),
(4691, 8783, 'PDE4D', 'phosphodiesterase 4D', 'protein-coding gene', 'ENSG00000113448'),
(4692, 55083, 'PDE4DIPP4', 'PDE4DIP pseudogene 4', 'pseudogene', 'ENSG00000275585'),
(4693, 55101, 'PDE4DIPP10', 'PDE4DIP pseudogene 10', 'pseudogene', 'ENSG00000228823'),
(4694, 8786, 'PDE6B', 'phosphodiesterase 6B', 'protein-coding gene', 'ENSG00000133256'),
(4695, 8789, 'PDE6G', 'phosphodiesterase 6G', 'protein-coding gene', 'ENSG00000185527'),
(4696, 8794, 'PDE8B', 'phosphodiesterase 8B', 'protein-coding gene', 'ENSG00000113231'),
(4697, 25386, 'PDE12', 'phosphodiesterase 12', 'protein-coding gene', 'ENSG00000174840'),
(4698, 30012, 'PDF', 'peptide deformylase, mitochondrial', 'protein-coding gene', 'ENSG00000258429'),
(4699, 55865, 'PDGFA-DT', 'PDGFA divergent transcript', 'non-coding RNA', 'ENSG00000223855'),
(4700, 8804, 'PDGFRB', 'platelet derived growth factor receptor beta', 'protein-coding gene', 'ENSG00000113721'),
(4701, 49403, 'PDIA3P2', 'protein disulfide isomerase family A member 3 pseudogene 2', 'pseudogene', 'ENSG00000224677'),
(4702, 27338, 'PDILT', 'protein disulfide isomerase like, testis expressed', 'protein-coding gene', 'ENSG00000169340'),
(4703, 8810, 'PDK2', 'pyruvate dehydrogenase kinase 2', 'protein-coding gene', 'ENSG00000005882'),
(4704, 2067, 'PDLIM1', 'PDZ and LIM domain 1', 'protein-coding gene', 'ENSG00000107438'),
(4705, 48945, 'PDLIM1P2', 'PDZ and LIM domain 1 pseudogene 2', 'pseudogene', 'ENSG00000265881'),
(4706, 16501, 'PDLIM4', 'PDZ and LIM domain 4', 'protein-coding gene', 'ENSG00000131435'),
(4707, 17468, 'PDLIM5', 'PDZ and LIM domain 5', 'protein-coding gene', 'ENSG00000163110'),
(4708, 9279, 'PDP1', 'pyruvate dehydrogenase phosphatase catalytic subunit 1', 'protein-coding gene', 'ENSG00000164951'),
(4709, 8816, 'PDPK1', '3-phosphoinositide dependent protein kinase 1', 'protein-coding gene', 'ENSG00000140992'),
(4710, 28995, 'PDXDC1', 'pyridoxal dependent decarboxylase domain containing 1', 'protein-coding gene', 'ENSG00000179889'),
(4711, 51488, 'PDZPH1P', 'PDZ and pleckstrin homology domains 1, pseudogene', 'pseudogene', 'ENSG00000226926'),
(4712, 20054, 'PEBP1P1', 'phosphatidylethanolamine binding protein 1 pseudogene 1', 'pseudogene', 'ENSG00000259059'),
(4713, 50328, 'PELATON', 'plaque enriched lncRNA in atherosclerotic and inflammatory bowel macrophage regulation', 'non-coding RNA', 'ENSG00000224397'),
(4714, 8828, 'PELI2', 'pellino E3 ubiquitin protein ligase family member 2', 'protein-coding gene', 'ENSG00000139946'),
(4715, 52293, 'PERCC1', 'proline and glutamate rich with coiled coil 1', 'protein-coding gene', 'ENSG00000284395'),
(4716, 8850, 'PEX1', 'peroxisomal biogenesis factor 1', 'protein-coding gene', 'ENSG00000127980'),
(4717, 8858, 'PEX3', 'peroxisomal biogenesis factor 3', 'protein-coding gene', 'ENSG00000034693'),
(4718, 9719, 'PEX5', 'peroxisomal biogenesis factor 5', 'protein-coding gene', 'ENSG00000139197'),
(4719, 30024, 'PEX5L', 'peroxisomal biogenesis factor 5 like', 'protein-coding gene', 'ENSG00000114757'),
(4720, 8852, 'PEX11A', 'peroxisomal biogenesis factor 11 alpha', 'protein-coding gene', 'ENSG00000166821'),
(4721, 8857, 'PEX16', 'peroxisomal biogenesis factor 16', 'protein-coding gene', 'ENSG00000121680'),
(4722, 8867, 'PFDN2', 'prefoldin subunit 2', 'protein-coding gene', 'ENSG00000143256'),
(4723, 8874, 'PFKFB3', '6-phosphofructo-2-kinase/fructose-2,6-biphosphatase 3', 'protein-coding gene', 'ENSG00000170525'),
(4724, 8877, 'PFKM', 'phosphofructokinase, muscle', 'protein-coding gene', 'ENSG00000152556'),
(4725, 8881, 'PFN1', 'profilin 1', 'protein-coding gene', 'ENSG00000108518'),
(4726, 42987, 'PFN1P3', 'profilin 1 pseudogene 3', 'pseudogene', 'ENSG00000234367'),
(4727, 42991, 'PFN1P9', 'profilin 1 pseudogene 9', 'pseudogene', 'ENSG00000227205'),
(4728, 8882, 'PFN2', 'profilin 2', 'protein-coding gene', 'ENSG00000070087'),
(4729, 8887, 'PGA5', 'pepsinogen A5', 'protein-coding gene', 'ENSG00000256713'),
(4730, 42448, 'PGAM1P1', 'phosphoglycerate mutase 1 pseudogene 1', 'pseudogene', 'ENSG00000248271'),
(4731, 42461, 'PGAM1P13', 'phosphoglycerate mutase 1 pseudogene 13', 'pseudogene', 'ENSG00000248838'),
(4732, 25712, 'PGAP1', 'post-GPI attachment to proteins inositol deacylase 1', 'protein-coding gene', 'ENSG00000197121'),
(4733, 28180, 'PGAP4', 'post-GPI attachment to proteins GalNAc transferase 4', 'protein-coding gene', 'ENSG00000165152'),
(4734, 17205, 'PGAP6', 'post-GPI attachment to proteins 6', 'protein-coding gene', 'ENSG00000129925'),
(4735, 44066, 'PGBD4P1', 'piggyBac transposable element derived 4 pseudogene 1', 'pseudogene', 'ENSG00000244273'),
(4736, 8893, 'PGF', 'placental growth factor', 'protein-coding gene', 'ENSG00000119630'),
(4737, 45112, 'PGGT1BP2', 'protein geranylgeranyltransferase type I subunit beta pseudogene 2', 'pseudogene', 'ENSG00000214584'),
(4738, 8896, 'PGK1', 'phosphoglycerate kinase 1', 'protein-coding gene', 'ENSG00000102144'),
(4739, 8898, 'PGK2', 'phosphoglycerate kinase 2', 'protein-coding gene', 'ENSG00000170950'),
(4740, 8904, 'PGLYRP1', 'peptidoglycan recognition protein 1', 'protein-coding gene', 'ENSG00000008438'),
(4741, 30015, 'PGLYRP4', 'peptidoglycan recognition protein 4', 'protein-coding gene', 'ENSG00000163218'),
(4742, 51194, 'PGM5P3-AS1', 'PGM5P3 antisense RNA 1', 'non-coding RNA', 'ENSG00000277631'),
(4743, 49605, 'PGM5P4', 'phosphoglucomutase 5 pseudogene 4', 'pseudogene', 'ENSG00000225398'),
(4744, 8910, 'PGR', 'progesterone receptor', 'protein-coding gene', 'ENSG00000082175'),
(4745, 40943, 'PHACTR2-AS1', 'PHACTR2 antisense RNA 1', 'non-coding RNA', 'ENSG00000235740'),
(4746, 49488, 'PHACTR2P1', 'phosphatase and actin regulator 2 pseudogene 1', 'pseudogene', 'ENSG00000270300'),
(4747, 40727, 'PHACTR3-AS1', 'PHACTR3 antisense RNA 1', 'non-coding RNA', 'ENSG00000238194'),
(4748, 29564, 'PHAF1', 'phagosome assembly factor 1', 'protein-coding gene', 'ENSG00000125149'),
(4749, 10241, 'PHAX', 'phosphorylated adaptor for RNA export', 'protein-coding gene', 'ENSG00000164902'),
(4750, 8912, 'PHB1', 'prohibitin 1', 'protein-coding gene', 'ENSG00000167085'),
(4751, 8913, 'PHB1P1', 'PHB1 pseudogene 1', 'pseudogene', 'ENSG00000213091'),
(4752, 39290, 'PHB1P11', 'PHB1 pseudogene 11', 'pseudogene', 'ENSG00000227621'),
(4753, 51550, 'PHB1P17', 'PHB1 pseudogene 17', 'pseudogene', 'ENSG00000254407'),
(4754, 51551, 'PHB1P18', 'PHB1 pseudogene 18', 'pseudogene', 'ENSG00000257885'),
(4755, 51552, 'PHB1P19', 'PHB1 pseudogene 19', 'pseudogene', 'ENSG00000257246'),
(4756, 3182, 'PHC1', 'polyhomeotic homolog 1', 'protein-coding gene', 'ENSG00000111752'),
(4757, 26509, 'PHETA1', 'PH domain containing endocytic trafficking adaptor 1', 'protein-coding gene', 'ENSG00000198324'),
(4758, 40445, 'PHEX-AS1', 'PHEX antisense RNA 1', 'non-coding RNA', 'ENSG00000224204'),
(4759, 23269, 'PHF5GP', 'PHD finger protein 5G pseudogene', 'pseudogene', 'ENSG00000238259'),
(4760, 22203, 'PHF14', 'PHD finger protein 14', 'protein-coding gene', 'ENSG00000106443'),
(4761, 24566, 'PHF19', 'PHD finger protein 19', 'protein-coding gene', 'ENSG00000119403'),
(4762, 25161, 'PHF21B', 'PHD finger protein 21B', 'protein-coding gene', 'ENSG00000056487'),
(4763, 28428, 'PHF23', 'PHD finger protein 23', 'protein-coding gene', 'ENSG00000040633'),
(4764, 29180, 'PHF24', 'PHD finger protein 24', 'protein-coding gene', 'ENSG00000122733'),
(4765, 33919, 'PHKA1P1', 'phosphorylase kinase regulatory subunit alpha 1 pseudogene', 'pseudogene', 'ENSG00000232882'),
(4766, 8926, 'PHKA2', 'phosphorylase kinase regulatory subunit alpha 2', 'protein-coding gene', 'ENSG00000044446'),
(4767, 33918, 'PHKG1P4', 'phosphorylase kinase catalytic subunit gamma 1 pseudogene 4', 'pseudogene', 'ENSG00000229508'),
(4768, 8933, 'PHLDA1', 'pleckstrin homology like domain family A member 1', 'protein-coding gene', 'ENSG00000139289'),
(4769, 29573, 'PHLDB2', 'pleckstrin homology like domain family B member 2', 'protein-coding gene', 'ENSG00000144824'),
(4770, 29149, 'PHLPP2', 'PH domain and leucine rich repeat protein phosphatase 2', 'protein-coding gene', 'ENSG00000040199'),
(4771, 691, 'PHOX2A', 'paired like homeobox 2A', 'protein-coding gene', 'ENSG00000165462'),
(4772, 9143, 'PHOX2B', 'paired like homeobox 2B', 'protein-coding gene', 'ENSG00000109132'),
(4773, 23396, 'PHYHD1', 'phytanoyl-CoA dioxygenase domain containing 1', 'protein-coding gene', 'ENSG00000175287'),
(4774, 8947, 'PI3', 'peptidase inhibitor 3', 'protein-coding gene', 'ENSG00000124102'),
(4775, 8983, 'PI4KA', 'phosphatidylinositol 4-kinase alpha', 'protein-coding gene', 'ENSG00000241973'),
(4776, 8984, 'PI4KB', 'phosphatidylinositol 4-kinase beta', 'protein-coding gene', 'ENSG00000143393'),
(4777, 2752, 'PIAS1', 'protein inhibitor of activated STAT 1', 'protein-coding gene', 'ENSG00000033800'),
(4778, 27009, 'PIFO', 'primary cilia formation', 'protein-coding gene', 'ENSG00000173947'),
(4779, 8960, 'PIGC', 'phosphatidylinositol glycan anchor biosynthesis class C', 'protein-coding gene', 'ENSG00000135845'),
(4780, 45149, 'PIGCP2', 'phosphatidylinositol glycan anchor biosynthesis class C pseudogene 2', 'pseudogene', 'ENSG00000229626'),
(4781, 8962, 'PIGF', 'phosphatidylinositol glycan anchor biosynthesis class F', 'protein-coding gene', 'ENSG00000151665'),
(4782, 45150, 'PIGFP2', 'phosphatidylinositol glycan anchor biosynthesis class F pseudogene 2', 'pseudogene', 'ENSG00000234881'),
(4783, 45152, 'PIGHP1', 'phosphatidylinositol glycan anchor biosynthesis class H pseudogene 1', 'pseudogene', 'ENSG00000259657'),
(4784, 45154, 'PIGPP2', 'phosphatidylinositol glycan anchor biosynthesis class P pseudogene 2', 'pseudogene', 'ENSG00000234204'),
(4785, 45155, 'PIGPP3', 'phosphatidylinositol glycan anchor biosynthesis class P pseudogene 3', 'pseudogene', 'ENSG00000228958'),
(4786, 45157, 'PIGQP1', 'phosphatidylinositol glycan anchor biosynthesis class Q pseudogene 1', 'pseudogene', 'ENSG00000227104'),
(4787, 8968, 'PIGR', 'polymeric immunoglobulin receptor', 'protein-coding gene', 'ENSG00000162896'),
(4788, 14937, 'PIGS', 'phosphatidylinositol glycan anchor biosynthesis class S', 'protein-coding gene', 'ENSG00000087111'),
(4789, 14938, 'PIGT', 'phosphatidylinositol glycan anchor biosynthesis class T', 'protein-coding gene', 'ENSG00000124155'),
(4790, 45158, 'PIGUP1', 'phosphatidylinositol glycan anchor biosynthesis class U pseudogene 1', 'pseudogene', 'ENSG00000224437'),
(4791, 26031, 'PIGV', 'phosphatidylinositol glycan anchor biosynthesis class V', 'protein-coding gene', 'ENSG00000060642'),
(4792, 54080, 'PIGY-DT', 'PIGY divergent transcript', 'non-coding RNA', 'ENSG00000285122'),
(4793, 26075, 'PIH1D1', 'PIH1 domain containing 1', 'protein-coding gene', 'ENSG00000104872'),
(4794, 25210, 'PIH1D2', 'PIH1 domain containing 2', 'protein-coding gene', 'ENSG00000150773'),
(4795, 8972, 'PIK3C2B', 'phosphatidylinositol-4-phosphate 3-kinase catalytic subunit type 2 beta', 'protein-coding gene', 'ENSG00000133056'),
(4796, 8975, 'PIK3CA', 'phosphatidylinositol-4,5-bisphosphate 3-kinase catalytic subunit alpha', 'protein-coding gene', 'ENSG00000121879'),
(4797, 27101, 'PIK3R6', 'phosphoinositide-3-kinase regulatory subunit 6', 'protein-coding gene', 'ENSG00000276231'),
(4798, 18297, 'PILRB', 'paired immunoglobin like type 2 receptor beta', 'protein-coding gene', 'ENSG00000121716'),
(4799, 54613, 'PIMREGP2', 'PIMREG pseudogene 2', 'pseudogene', 'ENSG00000216425'),
(4800, 14581, 'PINK1', 'PTEN induced kinase 1', 'protein-coding gene', 'ENSG00000158828'),
(4801, 55532, 'PINX1-DT', 'PINX1 divergent transcript', 'non-coding RNA', 'ENSG00000253695'),
(4802, 16671, 'PISRT1', 'PISRT1 lncRNA', 'non-coding RNA', 'ENSG00000281473'),
(4803, 44116, 'PITPNA-AS1', 'PITPNA antisense RNA 1', 'non-coding RNA', 'ENSG00000236618'),
(4804, 21045, 'PITPNC1', 'phosphatidylinositol transfer protein cytoplasmic 1', 'protein-coding gene', 'ENSG00000154217'),
(4805, 21043, 'PITPNM3', 'PITPNM family member 3', 'protein-coding gene', 'ENSG00000091622'),
(4806, 44675, 'PITRM1-AS1', 'PITRM1 antisense RNA 1', 'non-coding RNA', 'ENSG00000237399'),
(4807, 9006, 'PITX3', 'paired like homeodomain 3', 'protein-coding gene', 'ENSG00000107859'),
(4808, 55493, 'PIWIL4-AS1', 'PIWIL4 antisense RNA 1', 'non-coding RNA', 'ENSG00000255929'),
(4809, 16648, 'PJA1', 'praja ring finger ubiquitin ligase 1', 'protein-coding gene', 'ENSG00000181191'),
(4810, 21716, 'PKD1L3', 'polycystin 1 like 3, transient receptor potential channel interacting', 'protein-coding gene', 'ENSG00000277481'),
(4811, 30065, 'PKD1P1', 'polycystin 1, transient receptor potential channel interacting pseudogene 1', 'pseudogene', 'ENSG00000244257'),
(4812, 55557, 'PKD2L2-DT', 'PKD2L2 divergent transcript', 'non-coding RNA', 'ENSG00000250159'),
(4813, 9017, 'PKIA', 'cAMP-dependent protein kinase inhibitor alpha', 'protein-coding gene', 'ENSG00000171033'),
(4814, 9018, 'PKIB', 'cAMP-dependent protein kinase inhibitor beta', 'protein-coding gene', 'ENSG00000135549'),
(4815, 9021, 'PKM', 'pyruvate kinase M1/2', 'protein-coding gene', 'ENSG00000067225'),
(4816, 44246, 'PKMP4', 'pyruvate kinase M1/2 pseudogene 4', 'pseudogene', 'ENSG00000254023'),
(4817, 9405, 'PKN1', 'protein kinase N1', 'protein-coding gene', 'ENSG00000123143'),
(4818, 9406, 'PKN2', 'protein kinase N2', 'protein-coding gene', 'ENSG00000065243'),
(4819, 16714, 'PKNOX2', 'PBX/knotted 1 homeobox 2', 'protein-coding gene', 'ENSG00000165495'),
(4820, 42661, 'PKP4P1', 'plakophilin 4 pseudogene 1', 'pseudogene', 'ENSG00000229670'),
(4821, 9036, 'PLA2G4B', 'phospholipase A2 group IVB', 'protein-coding gene', 'ENSG00000243708'),
(4822, 9038, 'PLA2G5', 'phospholipase A2 group V', 'protein-coding gene', 'ENSG00000127472'),
(4823, 18554, 'PLA2G12A', 'phospholipase A2 group XIIA', 'protein-coding gene', 'ENSG00000123739'),
(4824, 39248, 'PLA2G12AP1', 'phospholipase A2 group XIIA pseudogene 1', 'pseudogene', 'ENSG00000224680'),
(4825, 39249, 'PLA2G12AP2', 'phospholipase A2 group XIIA pseudogene 2', 'pseudogene', 'ENSG00000225221'),
(4826, 19254, 'PLAC8', 'placenta associated 8', 'protein-coding gene', 'ENSG00000145287'),
(4827, 9047, 'PLAGL2', 'PLAG1 like zinc finger 2', 'protein-coding gene', 'ENSG00000126003'),
(4828, 27283, 'PLBD2', 'phospholipase B domain containing 2', 'protein-coding gene', 'ENSG00000151176'),
(4829, 15917, 'PLCB1', 'phospholipase C beta 1', 'protein-coding gene', 'ENSG00000182621'),
(4830, 43662, 'PLCB2-AS1', 'PLCB2 antisense RNA 1', 'non-coding RNA', 'ENSG00000259307'),
(4831, 17175, 'PLCE1', 'phospholipase C epsilon 1', 'protein-coding gene', 'ENSG00000138193'),
(4832, 29185, 'PLCH1', 'phospholipase C eta 1', 'protein-coding gene', 'ENSG00000114805'),
(4833, 41231, 'PLCH1-AS1', 'PLCH1 antisense RNA 1', 'non-coding RNA', 'ENSG00000239508'),
(4834, 23148, 'PLCXD1', 'phosphatidylinositol specific phospholipase C X domain containing 1', 'protein-coding gene', 'ENSG00000182378'),
(4835, 31822, 'PLCXD3', 'phosphatidylinositol specific phospholipase C X domain containing 3', 'protein-coding gene', 'ENSG00000182836'),
(4836, 9069, 'PLEC', 'plectin', 'protein-coding gene', 'ENSG00000178209'),
(4837, 19238, 'PLEK2', 'pleckstrin 2', 'protein-coding gene', 'ENSG00000100558'),
(4838, 30037, 'PLEKHA8', 'pleckstrin homology domain containing A8', 'protein-coding gene', 'ENSG00000106086'),
(4839, 29399, 'PLEKHG4B', 'pleckstrin homology and RhoGEF domain containing G4B', 'protein-coding gene', 'ENSG00000153404'),
(4840, 25562, 'PLEKHG6', 'pleckstrin homology and RhoGEF domain containing G6', 'protein-coding gene', 'ENSG00000008323'),
(4841, 26105, 'PLEKHH3', 'pleckstrin homology, MyTH4 and FERM domain containing H3', 'protein-coding gene', 'ENSG00000068137'),
(4842, 25284, 'PLEKHN1', 'pleckstrin homology domain containing N1', 'protein-coding gene', 'ENSG00000187583'),
(4843, 9073, 'PLGLB2', 'plasminogen like B2', 'protein-coding gene', 'ENSG00000125551'),
(4844, 33196, 'PLIN5', 'perilipin 5', 'protein-coding gene', 'ENSG00000214456'),
(4845, 27001, 'PLK5', 'polo like kinase 5 (inactive)', 'protein-coding gene', 'ENSG00000185988'),
(4846, 9086, 'PLP1', 'proteolipid protein 1', 'protein-coding gene', 'ENSG00000123560'),
(4847, 9228, 'PLPP1', 'phospholipid phosphatase 1', 'protein-coding gene', 'ENSG00000067113'),
(4848, 23497, 'PLPPR3', 'phospholipid phosphatase related 3', 'protein-coding gene', 'ENSG00000129951'),
(4849, 31703, 'PLPPR5', 'phospholipid phosphatase related 5', 'protein-coding gene', 'ENSG00000117598'),
(4850, 9090, 'PLS1', 'plastin 1', 'protein-coding gene', 'ENSG00000120756'),
(4851, 9091, 'PLS3', 'plastin 3', 'protein-coding gene', 'ENSG00000102024'),
(4852, 19952, 'PLSCR5', 'phospholipid scramblase family member 5', 'protein-coding gene', 'ENSG00000231213'),
(4853, 43698, 'PLUT', 'PDX1 associated lncRNA, upregulator of transcription', 'non-coding RNA', 'ENSG00000247381'),
(4854, 9099, 'PLXNA1', 'plexin A1', 'protein-coding gene', 'ENSG00000114554'),
(4855, 9102, 'PLXNA4', 'plexin A4', 'protein-coding gene', 'ENSG00000221866'),
(4856, 9103, 'PLXNB1', 'plexin B1', 'protein-coding gene', 'ENSG00000164050'),
(4857, 9106, 'PLXNC1', 'plexin C1', 'protein-coding gene', 'ENSG00000136040'),
(4858, 9110, 'PMCHL1', 'pro-melanin concentrating hormone like 1 (pseudogene)', 'pseudogene', 'ENSG00000168967'),
(4859, 10880, 'PMEL', 'premelanosome protein', 'protein-coding gene', 'ENSG00000185664'),
(4860, 17728, 'PMFBP1', 'polyamine modulated factor 1 binding protein 1', 'protein-coding gene', 'ENSG00000118557'),
(4861, 9115, 'PMM2', 'phosphomannomutase 2', 'protein-coding gene', 'ENSG00000140650'),
(4862, 9117, 'PMP2', 'peripheral myelin protein 2', 'protein-coding gene', 'ENSG00000147588'),
(4863, 9121, 'PMS1', 'PMS1 homolog 1, mismatch repair system component', 'protein-coding gene', 'ENSG00000064933'),
(4864, 9122, 'PMS2', 'PMS1 homolog 2, mismatch repair system component', 'protein-coding gene', 'ENSG00000122512'),
(4865, 33514, 'PMS2P6', 'PMS1 homolog 2, mismatch repair system component pseudogene 6', 'pseudogene', 'ENSG00000174384'),
(4866, 9124, 'PMS2P10', 'PMS1 homolog 2, mismatch repair system component pseudogene 10', 'pseudogene', 'ENSG00000273598'),
(4867, 13641, 'PMS2P12', 'PMS1 homolog 2, mismatch repair system component pseudogene 12', 'pseudogene', 'ENSG00000228546'),
(4868, 9153, 'PNKD', 'PNKD metallo-beta-lactamase domain containing', 'protein-coding gene', 'ENSG00000127838'),
(4869, 49628, 'PNKDP1', 'PNKD pseudogene 1', 'pseudogene', 'ENSG00000228089'),
(4870, 21185, 'PNLDC1', 'PARN like ribonuclease domain containing exonuclease 1', 'protein-coding gene', 'ENSG00000146453'),
(4871, 9159, 'PNMA2', 'PNMA family member 2', 'protein-coding gene', 'ENSG00000240694'),
(4872, 53119, 'PNMA6F', 'PNMA family member 6F', 'protein-coding gene', 'ENSG00000225110'),
(4873, 25578, 'PNMA8A', 'PNMA family member 8A', 'protein-coding gene', 'ENSG00000182013'),
(4874, 55974, 'PNN-AS1', 'PNN antisense RNA 1', 'non-coding RNA', 'ENSG00000259083'),
(4875, 32790, 'PNO1', 'partner of NOB1 homolog', 'protein-coding gene', 'ENSG00000115946'),
(4876, 7892, 'PNP', 'purine nucleoside phosphorylase', 'protein-coding gene', 'ENSG00000198805'),
(4877, 24887, 'PNPLA4', 'patatin like phospholipase domain containing 4', 'protein-coding gene', 'ENSG00000006757'),
(4878, 16268, 'PNPLA6', 'patatin like phospholipase domain containing 6', 'protein-coding gene', 'ENSG00000032444'),
(4879, 30260, 'PNPO', 'pyridoxamine 5\'-phosphate oxidase', 'protein-coding gene', 'ENSG00000108439'),
(4880, 23166, 'PNPT1', 'polyribonucleotide nucleotidyltransferase 1', 'protein-coding gene', 'ENSG00000138035'),
(4881, 42957, 'POC1B-GALNT4', 'POC1B-GALNT4 readthrough', 'other', 'ENSG00000259075'),
(4882, 9171, 'PODXL', 'podocalyxin like', 'protein-coding gene', 'ENSG00000128567'),
(4883, 39193, 'POGLUT2P1', 'POGLUT2 pseudogene 1', 'pseudogene', 'ENSG00000250329'),
(4884, 28496, 'POGLUT3', 'protein O-glucosyltransferase 3', 'protein-coding gene', 'ENSG00000178202'),
(4885, 9173, 'POLA1', 'DNA polymerase alpha 1, catalytic subunit', 'protein-coding gene', 'ENSG00000101868'),
(4886, 9176, 'POLD2', 'DNA polymerase delta 2, accessory subunit', 'protein-coding gene', 'ENSG00000106628'),
(4887, 23781, 'POLDIP2', 'DNA polymerase delta interacting protein 2', 'protein-coding gene', 'ENSG00000004142'),
(4888, 9177, 'POLE', 'DNA polymerase epsilon, catalytic subunit', 'protein-coding gene', 'ENSG00000177084'),
(4889, 18755, 'POLE4', 'DNA polymerase epsilon 4, accessory subunit', 'protein-coding gene', 'ENSG00000115350'),
(4890, 9179, 'POLG', 'DNA polymerase gamma, catalytic subunit', 'protein-coding gene', 'ENSG00000140521'),
(4891, 9180, 'POLG2', 'DNA polymerase gamma 2, accessory subunit', 'protein-coding gene', 'ENSG00000256525'),
(4892, 43967, 'POLHP1', 'DNA polymerase eta pseudogene 1', 'pseudogene', 'ENSG00000232970'),
(4893, 17631, 'POLR1E', 'RNA polymerase I subunit E', 'protein-coding gene', 'ENSG00000137054'),
(4894, 9191, 'POLR2D', 'RNA polymerase II subunit D', 'protein-coding gene', 'ENSG00000144231'),
(4895, 54765, 'POLR2DP2', 'POLR2D pseudogene 2', 'pseudogene', 'ENSG00000244565'),
(4896, 9195, 'POLR2H', 'RNA polymerase II, I and III subunit H', 'protein-coding gene', 'ENSG00000163882'),
(4897, 23208, 'POLR2J2', 'RNA polymerase II subunit J2', 'protein-coding gene', 'ENSG00000228049'),
(4898, 42650, 'POLR2KP1', 'RNA polymerase II subunit K pseudogene 1', 'pseudogene', 'ENSG00000258284'),
(4899, 14862, 'POLR2M', 'RNA polymerase II subunit M', 'protein-coding gene', 'ENSG00000255529'),
(4900, 30074, 'POLR3A', 'RNA polymerase III subunit A', 'protein-coding gene', 'ENSG00000148606'),
(4901, 1080, 'POLR3D', 'RNA polymerase III subunit D', 'protein-coding gene', 'ENSG00000168495'),
(4902, 50691, 'POLR3GP2', 'RNA polymerase III subunit G pseudogene 2', 'pseudogene', 'ENSG00000266984'),
(4903, 28865, 'POLRMTP1', 'RNA polymerase mitochondrial pseudogene 1', 'pseudogene', 'ENSG00000266066'),
(4904, 34005, 'POM121C', 'POM121 transmembrane nucleoporin C', 'protein-coding gene', 'ENSG00000272391'),
(4905, 13973, 'POM121L2', 'POM121 transmembrane nucleoporin like 2', 'protein-coding gene', 'ENSG00000158553'),
(4906, 16440, 'POM121L3P', 'POM121 transmembrane nucleoporin like 3, pseudogene', 'pseudogene', 'ENSG00000167390'),
(4907, 35444, 'POM121L7P', 'POM121 transmembrane nucleoporin like 7 pseudogene', 'pseudogene', 'ENSG00000239511'),
(4908, 44414, 'POM121L14P', 'POM121 transmembrane nucleoporin like 14, pseudogene', 'pseudogene', 'ENSG00000218189'),
(4909, 55894, 'POM121L15P', 'POM121 transmembrane nucleoporin like 15, pseudogene', 'pseudogene', 'ENSG00000161103'),
(4910, 9201, 'POMC', 'proopiomelanocortin', 'protein-coding gene', 'ENSG00000115138'),
(4911, 9202, 'POMT1', 'protein O-mannosyltransferase 1', 'protein-coding gene', 'ENSG00000130714'),
(4912, 9203, 'POMZP3', 'POM121 and ZP3 fusion', 'protein-coding gene', 'ENSG00000146707'),
(4913, 17649, 'POPDC3', 'popeye domain containing 3', 'protein-coding gene', 'ENSG00000132429'),
(4914, 16953, 'POSTN', 'periostin', 'protein-coding gene', 'ENSG00000133110'),
(4915, 9211, 'POU2AF1', 'POU class 2 homeobox associating factor 1', 'protein-coding gene', 'ENSG00000110777'),
(4916, 30527, 'POU2AF2', 'POU class 2 homeobox associating factor 2', 'protein-coding gene', 'ENSG00000150750'),
(4917, 9215, 'POU3F2', 'POU class 3 homeobox 2', 'protein-coding gene', 'ENSG00000184486'),
(4918, 9220, 'POU4F3', 'POU class 4 homeobox 3', 'protein-coding gene', 'ENSG00000091010'),
(4919, 33312, 'POU5F1P6', 'POU class 5 homeobox 1 pseudogene 6', 'pseudogene', 'ENSG00000242551'),
(4920, 26367, 'POU5F2', 'POU domain class 5, transcription factor 2', 'protein-coding gene', 'ENSG00000248483'),
(4921, 40979, 'POU6F2-AS1', 'POU6F2 antisense RNA 1', 'non-coding RNA', 'ENSG00000224122'),
(4922, 9237, 'PPARGC1A', 'PPARG coactivator 1 alpha', 'protein-coding gene', 'ENSG00000109819'),
(4923, 25686, 'PPCS', 'phosphopantothenoylcysteine synthetase', 'protein-coding gene', 'ENSG00000127125'),
(4924, 9243, 'PPEF1', 'protein phosphatase with EF-hand domain 1', 'protein-coding gene', 'ENSG00000086717'),
(4925, 54792, 'PPFIA1P1', 'PPFIA1 pseudogene 1', 'pseudogene', 'ENSG00000271639'),
(4926, 9246, 'PPFIA2', 'PTPRF interacting protein alpha 2', 'protein-coding gene', 'ENSG00000139220'),
(4927, 24369, 'PPIAL4A', 'peptidylprolyl isomerase A like 4A', 'protein-coding gene', 'ENSG00000263353'),
(4928, 16542, 'PPIAP2', 'peptidylprolyl isomerase A pseudogene 2', 'pseudogene', 'ENSG00000227379'),
(4929, 19935, 'PPIAP4', 'peptidylprolyl isomerase A pseudogene 4', 'pseudogene', 'ENSG00000258591'),
(4930, 9270, 'PPIAP7', 'peptidylprolyl isomerase A pseudogene 7', 'pseudogene', 'ENSG00000173810'),
(4931, 9263, 'PPIAP11', 'peptidylprolyl isomerase A pseudogene 11', 'pseudogene', 'ENSG00000251495'),
(4932, 9268, 'PPIAP15', 'peptidylprolyl isomerase A pseudogene 15', 'pseudogene', 'ENSG00000244196'),
(4933, 39270, 'PPIAP25', 'peptidylprolyl isomerase A pseudogene 25', 'pseudogene', 'ENSG00000229303'),
(4934, 53671, 'PPIAP47', 'peptidylprolyl isomerase A pseudogene 47', 'pseudogene', 'ENSG00000260815'),
(4935, 53673, 'PPIAP49', 'peptidylprolyl isomerase A pseudogene 49', 'pseudogene', 'ENSG00000260471'),
(4936, 53676, 'PPIAP52', 'peptidylprolyl isomerase A pseudogene 52', 'pseudogene', 'ENSG00000270606'),
(4937, 53677, 'PPIAP53', 'peptidylprolyl isomerase A pseudogene 53', 'pseudogene', 'ENSG00000223878'),
(4938, 53678, 'PPIAP54', 'peptidylprolyl isomerase A pseudogene 54', 'pseudogene', 'ENSG00000264655'),
(4939, 53691, 'PPIAP67', 'peptidylprolyl isomerase A pseudogene 67', 'pseudogene', 'ENSG00000237260'),
(4940, 53693, 'PPIAP69', 'peptidylprolyl isomerase A pseudogene 69', 'pseudogene', 'ENSG00000228337'),
(4941, 53696, 'PPIAP72', 'peptidylprolyl isomerase A pseudogene 72', 'pseudogene', 'ENSG00000174715'),
(4942, 53699, 'PPIAP75', 'peptidylprolyl isomerase A pseudogene 75', 'pseudogene', 'ENSG00000271131'),
(4943, 53701, 'PPIAP77', 'peptidylprolyl isomerase A pseudogene 77', 'pseudogene', 'ENSG00000249092'),
(4944, 53702, 'PPIAP78', 'peptidylprolyl isomerase A pseudogene 78', 'pseudogene', 'ENSG00000234838'),
(4945, 53703, 'PPIAP79', 'peptidylprolyl isomerase A pseudogene 79', 'pseudogene', 'ENSG00000214853'),
(4946, 53713, 'PPIAP89', 'peptidylprolyl isomerase A pseudogene 89', 'pseudogene', 'ENSG00000223819'),
(4947, 9257, 'PPID', 'peptidylprolyl isomerase D', 'protein-coding gene', 'ENSG00000171497'),
(4948, 9259, 'PPIF', 'peptidylprolyl isomerase F', 'protein-coding gene', 'ENSG00000108179'),
(4949, 31356, 'PPIHP2', 'peptidylprolyl isomerase H pseudogene 2', 'pseudogene', 'ENSG00000220541'),
(4950, 21557, 'PPIL6', 'peptidylprolyl isomerase like 6', 'protein-coding gene', 'ENSG00000185250'),
(4951, 55161, 'PPM1B-DT', 'PPM1B divergent transcript', 'non-coding RNA', 'ENSG00000273106'),
(4952, 19388, 'PPM1F', 'protein phosphatase, Mg2+/Mn2+ dependent 1F', 'protein-coding gene', 'ENSG00000100034'),
(4953, 54093, 'PPM1K-DT', 'PPM1K divergent transcript', 'non-coding RNA', 'ENSG00000246375'),
(4954, 16381, 'PPM1L', 'protein phosphatase, Mg2+/Mn2+ dependent 1L', 'protein-coding gene', 'ENSG00000163590'),
(4955, 26506, 'PPM1M', 'protein phosphatase, Mg2+/Mn2+ dependent 1M', 'protein-coding gene', 'ENSG00000164088'),
(4956, 9287, 'PPP1R1B', 'protein phosphatase 1 regulatory inhibitor subunit 1B', 'protein-coding gene', 'ENSG00000131771'),
(4957, 14944, 'PPP1R3F', 'protein phosphatase 1 regulatory subunit 3F', 'protein-coding gene', 'ENSG00000049769'),
(4958, 9296, 'PPP1R8', 'protein phosphatase 1 regulatory subunit 8', 'protein-coding gene', 'ENSG00000117751'),
(4959, 9284, 'PPP1R10', 'protein phosphatase 1 regulatory subunit 10', 'protein-coding gene', 'ENSG00000204569'),
(4960, 51903, 'PPP1R12A-AS1', 'PPP1R12A antisense RNA 1', 'non-coding RNA', 'ENSG00000257557'),
(4961, 55456, 'PPP1R12A-AS2', 'PPP1R12A antisense RNA 2', 'non-coding RNA', 'ENSG00000258048'),
(4962, 18498, 'PPP1R12BP1', 'protein phosphatase 1 regulatory subunit 12B pseudogene 1', 'pseudogene', 'ENSG00000229238'),
(4963, 16329, 'PPP1R14BP2', 'protein phosphatase 1 regulatory inhibitor subunit 14B pseudogene 2', 'pseudogene', 'ENSG00000213082'),
(4964, 48717, 'PPP1R26-AS1', 'PPP1R26 antisense RNA 1', 'non-coding RNA', 'ENSG00000225361'),
(4965, 42018, 'PPP1R26P4', 'protein phosphatase 1 regulatory subunit 26 pseudogene 4', 'pseudogene', 'ENSG00000278008'),
(4966, 9300, 'PPP2CB', 'protein phosphatase 2 catalytic subunit beta', 'protein-coding gene', 'ENSG00000104695'),
(4967, 23732, 'PPP2R2D', 'protein phosphatase 2 regulatory subunit Bdelta', 'protein-coding gene', 'ENSG00000175470'),
(4968, 44544, 'PPP2R2DP1', 'protein phosphatase 2 regulatory subunit Bdelta pseudogene 1', 'pseudogene', 'ENSG00000231668'),
(4969, 17485, 'PPP2R3C', 'protein phosphatase 2 regulatory subunit B\'\'gamma', 'protein-coding gene', 'ENSG00000092020'),
(4970, 9312, 'PPP2R5D', 'protein phosphatase 2 regulatory subunit B\'delta', 'protein-coding gene', 'ENSG00000112640'),
(4971, 50750, 'PPP3CB-AS1', 'PPP3CB antisense RNA 1 (head to head)', 'non-coding RNA', 'ENSG00000221817'),
(4972, 20219, 'PPP4R3A', 'protein phosphatase 4 regulatory subunit 3A', 'protein-coding gene', 'ENSG00000100796'),
(4973, 9322, 'PPP5C', 'protein phosphatase 5 catalytic subunit', 'protein-coding gene', 'ENSG00000011485'),
(4974, 29195, 'PPP6R1', 'protein phosphatase 6 regulatory subunit 1', 'protein-coding gene', 'ENSG00000105063'),
(4975, 48343, 'PPT2-EGFL8', 'PPT2-EGFL8 readthrough (NMD candidate)', 'other', 'ENSG00000258388'),
(4976, 30695, 'PPTC7', 'protein phosphatase targeting COQ7', 'protein-coding gene', 'ENSG00000196850'),
(4977, 9328, 'PPY2P', 'pancreatic polypeptide 2, pseudogene', 'pseudogene', 'ENSG00000265060'),
(4978, 30591, 'PRAC1', 'PRAC1 small nuclear protein', 'protein-coding gene', 'ENSG00000159182'),
(4979, 30091, 'PRAM1', 'PML-RARA regulated adaptor molecule 1', 'protein-coding gene', 'ENSG00000133246'),
(4980, 28840, 'PRAMEF1', 'PRAME family member 1', 'protein-coding gene', 'ENSG00000116721'),
(4981, 28841, 'PRAMEF2', 'PRAME family member 2', 'protein-coding gene', 'ENSG00000120952'),
(4982, 24074, 'PRAMEF8', 'PRAME family member 8', 'protein-coding gene', 'ENSG00000182330'),
(4983, 30693, 'PRAMEF18', 'PRAME family member 18', 'protein-coding gene', 'ENSG00000279804'),
(4984, 24908, 'PRAMEF19', 'PRAME family member 19', 'protein-coding gene', 'ENSG00000204480'),
(4985, 49179, 'PRAMEF25', 'PRAME family member 25', 'protein-coding gene', 'ENSG00000229571'),
(4986, 51891, 'PRAMEF29P', 'PRAME family member 29, pseudogene', 'pseudogene', 'ENSG00000234064'),
(4987, 9340, 'PRB4', 'proline rich protein BstNI subfamily 4', 'protein-coding gene', 'ENSG00000230657'),
(4988, 9346, 'PRDM1', 'PR/SET domain 1', 'protein-coding gene', 'ENSG00000057657'),
(4989, 9347, 'PRDM2', 'PR/SET domain 2', 'protein-coding gene', 'ENSG00000116731'),
(4990, 56186, 'PRDM4-AS1', 'PRDM4 antisense RNA 1', 'non-coding RNA', 'ENSG00000258136'),
(4991, 9351, 'PRDM7', 'PR/SET domain 7', 'protein-coding gene', 'ENSG00000126856'),
(4992, 13996, 'PRDM11', 'PR/SET domain 11', 'protein-coding gene', 'ENSG00000019485'),
(4993, 44969, 'PRDX2P4', 'peroxiredoxin 2 pseudogene 4', 'pseudogene', 'ENSG00000213177'),
(4994, 9354, 'PRDX3', 'peroxiredoxin 3', 'protein-coding gene', 'ENSG00000165672'),
(4995, 39264, 'PRDX3P1', 'peroxiredoxin 3 pseudogene 1', 'pseudogene', 'ENSG00000229598'),
(4996, 44643, 'PRDX3P4', 'peroxiredoxin 3 pseudogene 4', 'pseudogene', 'ENSG00000239926'),
(4997, 24639, 'PRELID3A', 'PRELI domain containing 3A', 'protein-coding gene', 'ENSG00000141391'),
(4998, 49063, 'PRELID3BP1', 'PRELI domain containing 3B pseudogene 1', 'pseudogene', 'ENSG00000226226'),
(4999, 49072, 'PRELID3BP10', 'PRELI domain containing 3B pseudogene 10', 'pseudogene', 'ENSG00000236105'),
(5000, 49073, 'PRELID3BP11', 'PRELI domain containing 3B pseudogene 11', 'pseudogene', 'ENSG00000231108'),
(5001, 30228, 'PREPL', 'prolyl endopeptidase like', 'protein-coding gene', 'ENSG00000138078'),
(5002, 22950, 'PREX2', 'phosphatidylinositol-3,4,5-trisphosphate dependent Rac exchange factor 2', 'protein-coding gene', 'ENSG00000046889'),
(5003, 9360, 'PRF1', 'perforin 1', 'protein-coding gene', 'ENSG00000180644'),
(5004, 9362, 'PRG2', 'proteoglycan 2, pro eosinophil major basic protein', 'protein-coding gene', 'ENSG00000186652'),
(5005, 9367, 'PRH2', 'proline rich protein HaeIII subfamily 2', 'protein-coding gene', 'ENSG00000134551'),
(5006, 9376, 'PRKAA1', 'protein kinase AMP-activated catalytic subunit alpha 1', 'protein-coding gene', 'ENSG00000132356'),
(5007, 9377, 'PRKAA2', 'protein kinase AMP-activated catalytic subunit alpha 2', 'protein-coding gene', 'ENSG00000162409'),
(5008, 9385, 'PRKAG1', 'protein kinase AMP-activated non-catalytic subunit gamma 1', 'protein-coding gene', 'ENSG00000181929'),
(5009, 9388, 'PRKAR1A', 'protein kinase cAMP-dependent type I regulatory subunit alpha', 'protein-coding gene', 'ENSG00000108946'),
(5010, 51347, 'PRKCA-AS1', 'PRKCA antisense RNA 1', 'non-coding RNA', 'ENSG00000264630'),
(5011, 55588, 'PRKCH-AS1', 'PRKCH antisense RNA 1', 'non-coding RNA', 'ENSG00000247287'),
(5012, 55035, 'PRKCIP1', 'PRKCI pseudogene 1', 'pseudogene', 'ENSG00000237682'),
(5013, 44689, 'PRKCQ-AS1', 'PRKCQ antisense RNA 1', 'non-coding RNA', 'ENSG00000237943'),
(5014, 9414, 'PRKG1', 'protein kinase cGMP-dependent 1', 'protein-coding gene', 'ENSG00000185532'),
(5015, 9438, 'PRKRA', 'protein activator of interferon induced protein kinase EIF2AK2', 'protein-coding gene', 'ENSG00000180228'),
(5016, 5187, 'PRMT1', 'protein arginine methyltransferase 1', 'protein-coding gene', 'ENSG00000126457'),
(5017, 30163, 'PRMT3', 'protein arginine methyltransferase 3', 'protein-coding gene', 'ENSG00000185238'),
(5018, 55482, 'PRMT5-DT', 'PRMT5 divergent transcript', 'non-coding RNA', 'ENSG00000257285'),
(5019, 32524, 'PRMT5P1', 'protein arginine methyltransferase 5 pseudogene 1', 'pseudogene', 'ENSG00000249004'),
(5020, 18046, 'PRNT', 'prion locus lncRNA, testis expressed', 'non-coding RNA', 'ENSG00000180259'),
(5021, 41906, 'PROB1', 'proline rich basic protein 1', 'protein-coding gene', 'ENSG00000228672'),
(5022, 23728, 'PROSER2', 'proline and serine rich 2', 'protein-coding gene', 'ENSG00000148426'),
(5023, 25204, 'PROSER3', 'proline and serine rich 3', 'protein-coding gene', 'ENSG00000167595'),
(5024, 15860, 'PRPF6', 'pre-mRNA processing factor 6', 'protein-coding gene', 'ENSG00000101161'),
(5025, 17351, 'PRPF18', 'pre-mRNA processing factor 18', 'protein-coding gene', 'ENSG00000165630'),
(5026, 55484, 'PRPF19-DT', 'PRPF19 divergent transcript', 'non-coding RNA', 'ENSG00000257052'),
(5027, 23182, 'PRPF19P1', 'PRPF19 pseudogene 1', 'pseudogene', 'ENSG00000264685'),
(5028, 25512, 'PRPF38B', 'pre-mRNA processing factor 38B', 'protein-coding gene', 'ENSG00000134186'),
(5029, 28130, 'PRR7', 'proline rich 7, synaptic', 'protein-coding gene', 'ENSG00000131188'),
(5030, 50620, 'PRR13P7', 'proline rich 13 pseudogene 7', 'pseudogene', 'ENSG00000271202'),
(5031, 22310, 'PRR15', 'proline rich 15', 'protein-coding gene', 'ENSG00000176532'),
(5032, 33728, 'PRR19', 'proline rich 19', 'protein-coding gene', 'ENSG00000188368'),
(5033, 24754, 'PRR20A', 'proline rich 20A', 'protein-coding gene', 'ENSG00000204919'),
(5034, 49097, 'PRR20FP', 'proline rich 20F, pseudogene', 'pseudogene', 'ENSG00000271140'),
(5035, 49396, 'PRR23D2', 'proline rich 23 domain containing 2', 'protein-coding gene', 'ENSG00000255378'),
(5036, 51822, 'PRR29-AS1', 'PRR29 antisense RNA 1', 'non-coding RNA', 'ENSG00000264954'),
(5037, 28677, 'PRR30', 'proline rich 30', 'protein-coding gene', 'ENSG00000186143'),
(5038, 34498, 'PRR32', 'proline rich 32', 'protein-coding gene', 'ENSG00000183631'),
(5039, 9142, 'PRRX1', 'paired related homeobox 1', 'protein-coding gene', 'ENSG00000116132'),
(5040, 50684, 'PRRX2-AS1', 'PRRX2 antisense RNA 1', 'non-coding RNA', 'ENSG00000236024'),
(5041, 43787, 'PRSS3P1', 'PRSS3 pseudogene 1', 'pseudogene', 'ENSG00000250591'),
(5042, 43789, 'PRSS3P4', 'PRSS3 pseudogene 4', 'pseudogene', 'ENSG00000204982'),
(5043, 9485, 'PRSS21', 'serine protease 21', 'protein-coding gene', 'ENSG00000007038'),
(5044, 37324, 'PRSS44P', 'serine protease 44, pseudogene', 'pseudogene', 'ENSG00000226074'),
(5045, 37325, 'PRSS46P', 'serine protease 46, pseudogene', 'pseudogene', 'ENSG00000261603'),
(5046, 37326, 'PRSS47P', 'serine protease 47, pseudogene', 'pseudogene', 'ENSG00000276717'),
(5047, 37322, 'PRSS52P', 'serine protease 52, pseudogene', 'pseudogene', 'ENSG00000285237'),
(5048, 30824, 'PRSS55', 'serine protease 55', 'protein-coding gene', 'ENSG00000184647'),
(5049, 23333, 'PRTFDC1', 'phosphoribosyl transferase domain containing 1', 'protein-coding gene', 'ENSG00000099256'),
(5050, 25209, 'PRUNE2', 'prune homolog 2 with BCH domain', 'protein-coding gene', 'ENSG00000106772'),
(5051, 28651, 'PRXL2A', 'peroxiredoxin like 2A', 'protein-coding gene', 'ENSG00000122378'),
(5052, 52407, 'PRXL2AP1', 'peroxiredoxin like 2A pseudogene 1', 'pseudogene', 'ENSG00000257220'),
(5053, 34018, 'PRYP1', 'PTPN13 like Y-linked pseudogene 1', 'pseudogene', 'ENSG00000224166'),
(5054, 34021, 'PRYP4', 'PTPN13 like Y-linked pseudogene 4', 'pseudogene', 'ENSG00000172283'),
(5055, 38785, 'PRYP5', 'PTPN13 like Y-linked pseudogene 5', 'pseudogene', 'ENSG00000233546'),
(5056, 38786, 'PRYP6', 'PTPN13 like Y-linked pseudogene 6', 'pseudogene', 'ENSG00000248573'),
(5057, 52550, 'PSG8-AS1', 'PSG8 antisense RNA 1', 'non-coding RNA', 'ENSG00000225877'),
(5058, 9526, 'PSG9', 'pregnancy specific beta-1-glycoprotein 9', 'protein-coding gene', 'ENSG00000183668'),
(5059, 31132, 'PSIP1P1', 'PC4 and SFRS1 interacting protein 1 pseudogene 1', 'pseudogene', 'ENSG00000234297');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(5060, 9530, 'PSMA1', 'proteasome 20S subunit alpha 1', 'protein-coding gene', 'ENSG00000129084'),
(5061, 9531, 'PSMA2', 'proteasome 20S subunit alpha 2', 'protein-coding gene', 'ENSG00000106588'),
(5062, 9535, 'PSMA6', 'proteasome 20S subunit alpha 6', 'protein-coding gene', 'ENSG00000100902'),
(5063, 22985, 'PSMA8', 'proteasome 20S subunit alpha 8', 'protein-coding gene', 'ENSG00000154611'),
(5064, 9537, 'PSMB1', 'proteasome 20S subunit beta 1', 'protein-coding gene', 'ENSG00000008018'),
(5065, 9539, 'PSMB2', 'proteasome 20S subunit beta 2', 'protein-coding gene', 'ENSG00000126067'),
(5066, 9540, 'PSMB3', 'proteasome 20S subunit beta 3', 'protein-coding gene', 'ENSG00000277791'),
(5067, 30150, 'PSMB3P2', 'proteasome subunit beta 3 pseudogene 2', 'pseudogene', 'ENSG00000235444'),
(5068, 39758, 'PSMB8-AS1', 'PSMB8 antisense RNA 1 (head to head)', 'non-coding RNA', 'ENSG00000204261'),
(5069, 31963, 'PSMB11', 'proteasome subunit beta 11', 'protein-coding gene', 'ENSG00000222028'),
(5070, 39782, 'PSMC1P7', 'proteasome 26S subunit, ATPase 1 pseudogene 7', 'pseudogene', 'ENSG00000243838'),
(5071, 39786, 'PSMC1P11', 'proteasome 26S subunit, ATPase 1 pseudogene 11', 'pseudogene', 'ENSG00000217385'),
(5072, 39787, 'PSMC1P12', 'proteasome 26S subunit, ATPase 1 pseudogene 12', 'pseudogene', 'ENSG00000226126'),
(5073, 9551, 'PSMC4', 'proteasome 26S subunit, ATPase 4', 'protein-coding gene', 'ENSG00000013275'),
(5074, 9553, 'PSMC6', 'proteasome 26S subunit, ATPase 6', 'protein-coding gene', 'ENSG00000100519'),
(5075, 9559, 'PSMD2', 'proteasome 26S subunit ubiquitin receptor, non-ATPase 2', 'protein-coding gene', 'ENSG00000175166'),
(5076, 34013, 'PSMD8P1', 'proteasome 26S subunit, non-ATPase, 8 pseudogene 1', 'pseudogene', 'ENSG00000228264'),
(5077, 9567, 'PSMD9', 'proteasome 26S subunit, non-ATPase 9', 'protein-coding gene', 'ENSG00000110801'),
(5078, 9569, 'PSME2', 'proteasome activator subunit 2', 'protein-coding gene', 'ENSG00000100911'),
(5079, 30156, 'PSME2P3', 'proteasome activator subunit 2 pseudogene 3', 'pseudogene', 'ENSG00000248988'),
(5080, 3043, 'PSMG1', 'proteasome assembly chaperone 1', 'protein-coding gene', 'ENSG00000183527'),
(5081, 24929, 'PSMG2', 'proteasome assembly chaperone 2', 'protein-coding gene', 'ENSG00000128789'),
(5082, 22420, 'PSMG3', 'proteasome assembly chaperone 3', 'protein-coding gene', 'ENSG00000157778'),
(5083, 17199, 'PSORS1C2', 'psoriasis susceptibility 1 candidate 2', 'protein-coding gene', 'ENSG00000204538'),
(5084, 17203, 'PSORS1C3', 'psoriasis susceptibility 1 candidate 3', 'non-coding RNA', 'ENSG00000204528'),
(5085, 42033, 'PSPC1P1', 'paraspeckle component 1 pseudogene 1', 'pseudogene', 'ENSG00000227879'),
(5086, 25734, 'PTCD2', 'pentatricopeptide repeat domain 2', 'protein-coding gene', 'ENSG00000049883'),
(5087, 9586, 'PTCH2', 'patched 2', 'protein-coding gene', 'ENSG00000117425'),
(5088, 44946, 'PTCHD3P2', 'patched domain containing 3 pseudogene 2', 'pseudogene', 'ENSG00000231550'),
(5089, 44947, 'PTCHD3P3', 'patched domain containing 3 pseudogene 3', 'pseudogene', 'ENSG00000219700'),
(5090, 9594, 'PTGER2', 'prostaglandin E receptor 2', 'protein-coding gene', 'ENSG00000125384'),
(5091, 16049, 'PTGES3', 'prostaglandin E synthase 3', 'protein-coding gene', 'ENSG00000110958'),
(5092, 43824, 'PTGES3P1', 'prostaglandin E synthase 3 pseudogene 1', 'pseudogene', 'ENSG00000234518'),
(5093, 43822, 'PTGES3P2', 'prostaglandin E synthase 3 pseudogene 2', 'pseudogene', 'ENSG00000217643'),
(5094, 9609, 'PTH2R', 'parathyroid hormone 2 receptor', 'protein-coding gene', 'ENSG00000144407'),
(5095, 9607, 'PTHLH', 'parathyroid hormone like hormone', 'protein-coding gene', 'ENSG00000087494'),
(5096, 9618, 'PTK7', 'protein tyrosine kinase 7 (inactive)', 'protein-coding gene', 'ENSG00000112655'),
(5097, 9623, 'PTMA', 'prothymosin alpha', 'protein-coding gene', 'ENSG00000187514'),
(5098, 9627, 'PTMAP4', 'prothymosin alpha pseudogene 4', 'pseudogene', 'ENSG00000231503'),
(5099, 53979, 'PTMAP11', 'prothymosin alpha pseudogene 11', 'pseudogene', 'ENSG00000269907'),
(5100, 9632, 'PTOV1', 'PTOV1 extended AT-hook containing adaptor protein', 'protein-coding gene', 'ENSG00000104960'),
(5101, 9634, 'PTP4A1', 'protein tyrosine phosphatase 4A1', 'protein-coding gene', 'ENSG00000112245'),
(5102, 41928, 'PTP4A1P1', 'PTP4A1 pseudogene 1', 'pseudogene', 'ENSG00000231158'),
(5103, 41929, 'PTP4A1P2', 'PTP4A1 pseudogene 2', 'pseudogene', 'ENSG00000255807'),
(5104, 41932, 'PTP4A1P5', 'PTP4A1 pseudogene 5', 'pseudogene', 'ENSG00000235642'),
(5105, 9636, 'PTP4A3', 'protein tyrosine phosphatase 4A3', 'protein-coding gene', 'ENSG00000184489'),
(5106, 9642, 'PTPN1', 'protein tyrosine phosphatase non-receptor type 1', 'protein-coding gene', 'ENSG00000196396'),
(5107, 9654, 'PTPN2P2', 'PTPN2 pseudogene 2', 'pseudogene', 'ENSG00000224117'),
(5108, 9655, 'PTPN3', 'protein tyrosine phosphatase non-receptor type 3', 'protein-coding gene', 'ENSG00000070159'),
(5109, 9647, 'PTPN14', 'protein tyrosine phosphatase non-receptor type 14', 'protein-coding gene', 'ENSG00000152104'),
(5110, 23423, 'PTPN20', 'protein tyrosine phosphatase non-receptor type 20', 'protein-coding gene', 'ENSG00000204179'),
(5111, 9652, 'PTPN22', 'protein tyrosine phosphatase non-receptor type 22', 'protein-coding gene', 'ENSG00000134242'),
(5112, 55397, 'PTPN23-DT', 'PTPN23 divergent transcript', 'non-coding RNA', 'ENSG00000260236'),
(5113, 9667, 'PTPRCAP', 'protein tyrosine phosphatase receptor type C associated protein', 'protein-coding gene', 'ENSG00000213402'),
(5114, 9672, 'PTPRH', 'protein tyrosine phosphatase receptor type H', 'protein-coding gene', 'ENSG00000080031'),
(5115, 9675, 'PTPRM', 'protein tyrosine phosphatase receptor type M', 'protein-coding gene', 'ENSG00000173482'),
(5116, 40491, 'PTPRT-AS1', 'PTPRT antisense RNA 1', 'non-coding RNA', 'ENSG00000227599'),
(5117, 20055, 'PTTG4P', 'pituitary tumor-transforming 4 pseudogene', 'pseudogene', 'ENSG00000258571'),
(5118, 20200, 'PUDPP1', 'pseudouridine 5\'-phosphatase pseudogene 1', 'pseudogene', 'ENSG00000234620'),
(5119, 14958, 'PUM2', 'pumilio RNA binding family member 2', 'protein-coding gene', 'ENSG00000055917'),
(5120, 9711, 'PWP2', 'PWP2 small subunit processome component', 'protein-coding gene', 'ENSG00000241945'),
(5121, 49130, 'PWRN4', 'Prader-Willi region non-protein coding RNA 4', 'non-coding RNA', 'ENSG00000260232'),
(5122, 39709, 'PWWP2AP1', 'PWWP domain containing 2A pseudogene 1', 'pseudogene', 'ENSG00000226683'),
(5123, 25150, 'PWWP2B', 'PWWP domain containing 2B', 'protein-coding gene', 'ENSG00000171813'),
(5124, 14966, 'PXDN', 'peroxidasin', 'protein-coding gene', 'ENSG00000130508'),
(5125, 45036, 'PYCARD-AS1', 'PYCARD antisense RNA 1', 'non-coding RNA', 'ENSG00000261359'),
(5126, 30262, 'PYCR2', 'pyrroline-5-carboxylate reductase 2', 'protein-coding gene', 'ENSG00000143811'),
(5127, 9726, 'PYGM', 'glycogen phosphorylase, muscle associated', 'protein-coding gene', 'ENSG00000068976'),
(5128, 25952, 'QPCTL', 'glutaminyl-peptide cyclotransferase like', 'protein-coding gene', 'ENSG00000011478'),
(5129, 43667, 'QRSL1P1', 'QRSL1 pseudogene 1', 'pseudogene', 'ENSG00000215833'),
(5130, 44056, 'R3HDM2P1', 'R3H domain containing 2 pseudogene 1', 'pseudogene', 'ENSG00000248735'),
(5131, 55830, 'R3HDML-AS1', 'R3HDML antisense RNA 1', 'non-coding RNA', 'ENSG00000226812'),
(5132, 9758, 'RAB1A', 'RAB1A, member RAS oncogene family', 'protein-coding gene', 'ENSG00000138069'),
(5133, 9777, 'RAB3A', 'RAB3A, member RAS oncogene family', 'protein-coding gene', 'ENSG00000105649'),
(5134, 9779, 'RAB3D', 'RAB3D, member RAS oncogene family', 'protein-coding gene', 'ENSG00000105514'),
(5135, 9782, 'RAB4B', 'RAB4B, member RAS oncogene family', 'protein-coding gene', 'ENSG00000167578'),
(5136, 9785, 'RAB5C', 'RAB5C, member RAS oncogene family', 'protein-coding gene', 'ENSG00000108774'),
(5137, 49278, 'RAB6C-AS1', 'RAB6C antisense RNA 1', 'non-coding RNA', 'ENSG00000225449'),
(5138, 38107, 'RAB9AP3', 'RAB9A, member RAS oncogene family pseudogene 3', 'pseudogene', 'ENSG00000223655'),
(5139, 9761, 'RAB11B', 'RAB11B, member RAS oncogene family', 'protein-coding gene', 'ENSG00000185236'),
(5140, 17224, 'RAB11FIP3', 'RAB11 family interacting protein 3', 'protein-coding gene', 'ENSG00000090565'),
(5141, 56028, 'RAB17-DT', 'RAB17 divergent transcript', 'non-coding RNA', 'ENSG00000234949'),
(5142, 14263, 'RAB23', 'RAB23, member RAS oncogene family', 'protein-coding gene', 'ENSG00000112210'),
(5143, 9766, 'RAB27A', 'RAB27A, member RAS oncogene family', 'protein-coding gene', 'ENSG00000069974'),
(5144, 9789, 'RAB29', 'RAB29, member RAS oncogene family', 'protein-coding gene', 'ENSG00000117280'),
(5145, 9771, 'RAB31', 'RAB31, member RAS oncogene family', 'protein-coding gene', 'ENSG00000168461'),
(5146, 9772, 'RAB32', 'RAB32, member RAS oncogene family', 'protein-coding gene', 'ENSG00000118508'),
(5147, 16519, 'RAB34', 'RAB34, member RAS oncogene family', 'protein-coding gene', 'ENSG00000109113'),
(5148, 30268, 'RAB37', 'RAB37, member RAS oncogene family', 'protein-coding gene', 'ENSG00000172794'),
(5149, 16499, 'RAB39B', 'RAB39B, member RAS oncogene family', 'protein-coding gene', 'ENSG00000155961'),
(5150, 19983, 'RAB43', 'RAB43, member RAS oncogene family', 'protein-coding gene', 'ENSG00000172780'),
(5151, 17677, 'RABEP1', 'rabaptin, RAB GTPase binding effector protein 1', 'protein-coding gene', 'ENSG00000029725'),
(5152, 16896, 'RABEPK', 'Rab9 effector protein with kelch motifs', 'protein-coding gene', 'ENSG00000136933'),
(5153, 17155, 'RABGAP1', 'RAB GTPase activating protein 1', 'protein-coding gene', 'ENSG00000011454'),
(5154, 24663, 'RABGAP1L', 'RAB GTPase activating protein 1 like', 'protein-coding gene', 'ENSG00000152061'),
(5155, 9801, 'RAC1', 'Rac family small GTPase 1', 'protein-coding gene', 'ENSG00000136238'),
(5156, 9804, 'RACGAP1', 'Rac GTPase activating protein 1', 'protein-coding gene', 'ENSG00000161800'),
(5157, 24689, 'RACGAP1P1', 'Rac GTPase activating protein 1 pseudogene 1', 'pseudogene', 'ENSG00000257331'),
(5158, 9806, 'RAD1', 'RAD1 checkpoint DNA exonuclease', 'protein-coding gene', 'ENSG00000113456'),
(5159, 9807, 'RAD17', 'RAD17 checkpoint clamp loader component', 'protein-coding gene', 'ENSG00000152942'),
(5160, 9811, 'RAD21', 'RAD21 cohesin complex component', 'protein-coding gene', 'ENSG00000164754'),
(5161, 9813, 'RAD23B', 'RAD23 homolog B, nucleotide excision repair protein', 'protein-coding gene', 'ENSG00000119318'),
(5162, 9817, 'RAD51', 'RAD51 recombinase', 'protein-coding gene', 'ENSG00000051180'),
(5163, 54570, 'RAD54L2P1', 'RAD54L2 pseudogene 1', 'pseudogene', 'ENSG00000269316'),
(5164, 9832, 'RAG2', 'recombination activating 2', 'protein-coding gene', 'ENSG00000175097'),
(5165, 40496, 'RAI1-AS1', 'RAI1 antisense RNA 1', 'non-coding RNA', 'ENSG00000237328'),
(5166, 9840, 'RALB', 'RAS like proto-oncogene B', 'protein-coding gene', 'ENSG00000144118'),
(5167, 23203, 'RALGAPA1P1', 'RALGAPA1 pseudogene 1', 'pseudogene', 'ENSG00000229419'),
(5168, 55163, 'RALGPS2-AS1', 'RALGPS2 antisense RNA 1', 'non-coding RNA', 'ENSG00000273062'),
(5169, 31022, 'RAMAC', 'RNA guanine-7 methyltransferase activating subunit', 'protein-coding gene', 'ENSG00000169612'),
(5170, 9843, 'RAMP1', 'receptor activity modifying protein 1', 'protein-coding gene', 'ENSG00000132329'),
(5171, 44358, 'RAMP2-AS1', 'RAMP2 antisense RNA 1', 'non-coding RNA', 'ENSG00000197291'),
(5172, 14428, 'RANBP17', 'RAN binding protein 17', 'protein-coding gene', 'ENSG00000204764'),
(5173, 9854, 'RANGAP1', 'Ran GTPase activating protein 1', 'protein-coding gene', 'ENSG00000100401'),
(5174, 17679, 'RANGRF', 'RAN guanine nucleotide release factor', 'protein-coding gene', 'ENSG00000108961'),
(5175, 39858, 'RANP3', 'RAN pseudogene 3', 'pseudogene', 'ENSG00000254500'),
(5176, 39864, 'RANP9', 'RAN pseudogene 9', 'pseudogene', 'ENSG00000253393'),
(5177, 9855, 'RAP1A', 'RAP1A, member of RAS oncogene family', 'protein-coding gene', 'ENSG00000116473'),
(5178, 9862, 'RAP2B', 'RAP2B, member of RAS oncogene family', 'protein-coding gene', 'ENSG00000181467'),
(5179, 17428, 'RAPGEFL1', 'Rap guanine nucleotide exchange factor like 1', 'protein-coding gene', 'ENSG00000108352'),
(5180, 9865, 'RARB', 'retinoic acid receptor beta', 'protein-coding gene', 'ENSG00000077092'),
(5181, 48702, 'RARRES2P3', 'retinoic acid receptor responder 2 pseudogene 3', 'pseudogene', 'ENSG00000231913'),
(5182, 48705, 'RARRES2P6', 'retinoic acid receptor responder 2 pseudogene 6', 'pseudogene', 'ENSG00000261010'),
(5183, 48709, 'RARRES2P7', 'retinoic acid receptor responder 2 pseudogene 7', 'pseudogene', 'ENSG00000260812'),
(5184, 20331, 'RASA3', 'RAS p21 protein activator 3', 'protein-coding gene', 'ENSG00000185989'),
(5185, 44185, 'RASA4CP', 'RAS p21 protein activator 4C, pseudogene', 'pseudogene', 'ENSG00000228903'),
(5186, 24881, 'RASGEF1B', 'RasGEF domain family member 1B', 'protein-coding gene', 'ENSG00000138670'),
(5187, 27400, 'RASGEF1C', 'RasGEF domain family member 1C', 'protein-coding gene', 'ENSG00000146090'),
(5188, 9875, 'RASGRF1', 'Ras protein specific guanine nucleotide releasing factor 1', 'protein-coding gene', 'ENSG00000058335'),
(5189, 9876, 'RASGRF2', 'Ras protein specific guanine nucleotide releasing factor 2', 'protein-coding gene', 'ENSG00000113319'),
(5190, 55489, 'RASSF3-DT', 'RASSF3 divergent transcript', 'non-coding RNA', 'ENSG00000256670'),
(5191, 1166, 'RASSF7', 'Ras association domain family member 7', 'protein-coding gene', 'ENSG00000099849'),
(5192, 33984, 'RASSF10', 'Ras association domain family member 10', 'protein-coding gene', 'ENSG00000189431'),
(5193, 18662, 'RAX', 'retina and anterior neural fold homeobox', 'protein-coding gene', 'ENSG00000134438'),
(5194, 15574, 'RB1CC1', 'RB1 inducible coiled-coil 1', 'protein-coding gene', 'ENSG00000023287'),
(5195, 42369, 'RBBP4P2', 'RBBP4 pseudogene 2', 'pseudogene', 'ENSG00000242457'),
(5196, 42371, 'RBBP4P4', 'RBBP4 pseudogene 4', 'pseudogene', 'ENSG00000214561'),
(5197, 9888, 'RBBP5', 'RB binding protein 5, histone lysine methyltransferase complex subunit', 'protein-coding gene', 'ENSG00000117222'),
(5198, 9902, 'RBM5', 'RNA binding motif protein 5', 'protein-coding gene', 'ENSG00000003756'),
(5199, 9904, 'RBM7', 'RNA binding motif protein 7', 'protein-coding gene', 'ENSG00000076053'),
(5200, 9905, 'RBM8A', 'RNA binding motif protein 8A', 'protein-coding gene', 'ENSG00000265241'),
(5201, 9898, 'RBM12', 'RNA binding motif protein 12', 'protein-coding gene', 'ENSG00000244462'),
(5202, 28818, 'RBM12B-AS1', 'RBM12B antisense RNA 1', 'non-coding RNA', 'ENSG00000279331'),
(5203, 24303, 'RBM15B', 'RNA binding motif protein 15B', 'protein-coding gene', 'ENSG00000259956'),
(5204, 50366, 'RBM17P1', 'RNA binding motif protein 17 pseudogene 1', 'pseudogene', 'ENSG00000226625'),
(5205, 50369, 'RBM17P4', 'RNA binding motif protein 17 pseudogene 4', 'pseudogene', 'ENSG00000259585'),
(5206, 49207, 'RBM22P12', 'RNA binding motif protein 22 pseudogene 12', 'pseudogene', 'ENSG00000260631'),
(5207, 20327, 'RBM26', 'RNA binding motif protein 26', 'protein-coding gene', 'ENSG00000139746'),
(5208, 24790, 'RBM43', 'RNA binding motif protein 43', 'protein-coding gene', 'ENSG00000184898'),
(5209, 44054, 'RBM48P1', 'RNA binding motif protein 48 pseudogene 1', 'pseudogene', 'ENSG00000223620'),
(5210, 9909, 'RBMS2', 'RNA binding motif single stranded interacting protein 2', 'protein-coding gene', 'ENSG00000076067'),
(5211, 39924, 'RBMX2P2', 'RBMX2 pseudogene 2', 'pseudogene', 'ENSG00000213423'),
(5212, 33949, 'RBMXP3', 'RBMX pseudogene 3', 'pseudogene', 'ENSG00000255063'),
(5213, 18849, 'RBMY1A3P', 'RNA binding motif protein Y-linked family 1 member A3, pseudogene', 'pseudogene', 'ENSG00000197038'),
(5214, 23914, 'RBMY1B', 'RNA binding motif protein Y-linked family 1 member B', 'protein-coding gene', 'ENSG00000242875'),
(5215, 23917, 'RBMY1J', 'RNA binding motif protein Y-linked family 1 member J', 'protein-coding gene', 'ENSG00000226941'),
(5216, 9918, 'RBMY2BP', 'RNA binding motif protein Y-linked family 2 member B, pseudogene', 'pseudogene', 'ENSG00000224657'),
(5217, 23892, 'RBMY2GP', 'RNA binding motif protein Y-linked family 2 member G, pseudogene', 'pseudogene', 'ENSG00000223744'),
(5218, 23901, 'RBMY2XP', 'RNA binding motif protein Y-linked family 2 member X, pseudogene', 'pseudogene', 'ENSG00000234399'),
(5219, 9919, 'RBP1', 'retinol binding protein 1', 'protein-coding gene', 'ENSG00000114115'),
(5220, 37485, 'RBPJP5', 'RBPJ pseudogene 5', 'pseudogene', 'ENSG00000232239'),
(5221, 48721, 'RBPMS-AS1', 'RBPMS antisense RNA 1', 'non-coding RNA', 'ENSG00000254109'),
(5222, 20759, 'RBSN', 'rabenosyn, RAB effector', 'protein-coding gene', 'ENSG00000131381'),
(5223, 3041, 'RCAN2', 'regulator of calcineurin 2', 'protein-coding gene', 'ENSG00000172348'),
(5224, 39009, 'RCAN3AS', 'RCAN3 antisense RNA', 'non-coding RNA', 'ENSG00000286061'),
(5225, 1913, 'RCC1', 'regulator of chromosome condensation 1', 'protein-coding gene', 'ENSG00000180198'),
(5226, 37710, 'RCC2P1', 'regulator of chromosome condensation 2 pseudogene 1', 'pseudogene', 'ENSG00000234385'),
(5227, 38419, 'RCC2P2', 'regulator of chromosome condensation 2 pseudogene 2', 'pseudogene', 'ENSG00000237997'),
(5228, 42379, 'RCC2P3', 'regulator of chromosome condensation 2 pseudogene 3', 'pseudogene', 'ENSG00000233951'),
(5229, 42381, 'RCC2P5', 'regulator of chromosome condensation 2 pseudogene 5', 'pseudogene', 'ENSG00000241018'),
(5230, 13721, 'RCE1', 'Ras converting CAAX endopeptidase 1', 'protein-coding gene', 'ENSG00000173653'),
(5231, 17687, 'RCL1', 'RNA terminal phosphate cyclase like 1', 'protein-coding gene', 'ENSG00000120158'),
(5232, 9934, 'RCN1', 'reticulocalbin 1', 'protein-coding gene', 'ENSG00000049449'),
(5233, 21145, 'RCN3', 'reticulocalbin 3', 'protein-coding gene', 'ENSG00000142552'),
(5234, 17441, 'RCOR1', 'REST corepressor 1', 'protein-coding gene', 'ENSG00000089902'),
(5235, 9937, 'RCVRN', 'recoverin', 'protein-coding gene', 'ENSG00000109047'),
(5236, 51658, 'RDH10-AS1', 'RDH10 antisense RNA 1', 'non-coding RNA', 'ENSG00000250295'),
(5237, 17964, 'RDH11', 'retinol dehydrogenase 11', 'protein-coding gene', 'ENSG00000072042'),
(5238, 53918, 'RDM1P2', 'RDM1 pseudogene 2', 'pseudogene', 'ENSG00000266497'),
(5239, 53920, 'RDM1P4', 'RDM1 pseudogene 4', 'pseudogene', 'ENSG00000271974'),
(5240, 9949, 'RECQL4', 'RecQ like helicase 4', 'protein-coding gene', 'ENSG00000160957'),
(5241, 53638, 'REELD1', 'reeler domain containing 1', 'protein-coding gene', 'ENSG00000250673'),
(5242, 17975, 'REEP2', 'receptor accessory protein 2', 'protein-coding gene', 'ENSG00000132563'),
(5243, 8601, 'REG3A', 'regenerating family member 3 alpha', 'protein-coding gene', 'ENSG00000172016'),
(5244, 13764, 'RELT', 'RELT TNF receptor', 'protein-coding gene', 'ENSG00000054967'),
(5245, 17922, 'REPIN1', 'replication initiator 1', 'protein-coding gene', 'ENSG00000214022'),
(5246, 30309, 'RER1', 'retention in endoplasmic reticulum sorting receptor 1', 'protein-coding gene', 'ENSG00000157916'),
(5247, 39991, 'RERG-IT1', 'RERG intronic transcript 1', 'non-coding RNA', 'ENSG00000256650'),
(5248, 20389, 'RETN', 'resistin', 'protein-coding gene', 'ENSG00000104918'),
(5249, 32240, 'REXO1L3P', 'REXO1 like 3, pseudogene', 'pseudogene', 'ENSG00000273567'),
(5250, 32243, 'REXO1L6P', 'REXO1 like 6, pseudogene', 'pseudogene', 'ENSG00000277422'),
(5251, 44432, 'REXO1L9P', 'REXO1 like 9, pseudogene', 'pseudogene', 'ENSG00000271381'),
(5252, 9969, 'RFC1', 'replication factor C subunit 1', 'protein-coding gene', 'ENSG00000035928'),
(5253, 9970, 'RFC2', 'replication factor C subunit 2', 'protein-coding gene', 'ENSG00000049541'),
(5254, 44531, 'RFC3P1', 'replication factor C 3 pseudogene 1', 'pseudogene', 'ENSG00000236158'),
(5255, 50450, 'RFC5P1', 'replication factor C 5 pseudogene 1', 'pseudogene', 'ENSG00000233526'),
(5256, 30324, 'RFK', 'riboflavin kinase', 'protein-coding gene', 'ENSG00000135002'),
(5257, 9977, 'RFPL1', 'ret finger protein like 1', 'protein-coding gene', 'ENSG00000128250'),
(5258, 45138, 'RFPL4AP1', 'ret finger protein like 4A pseudogene 1', 'pseudogene', 'ENSG00000255238'),
(5259, 9982, 'RFX1', 'regulatory factor X1', 'protein-coding gene', 'ENSG00000132005'),
(5260, 40503, 'RFX5-AS1', 'RFX5 antisense RNA 1', 'non-coding RNA', 'ENSG00000237976'),
(5261, 21965, 'RGP1', 'RGP1 homolog, RAB6A GEF complex partner 1', 'protein-coding gene', 'ENSG00000107185'),
(5262, 32414, 'RGPD1', 'RANBP2 like and GRIP domain containing 1', 'protein-coding gene', 'ENSG00000187627'),
(5263, 9849, 'RGPD8', 'RANBP2 like and GRIP domain containing 8', 'protein-coding gene', 'ENSG00000169629'),
(5264, 9999, 'RGS3', 'regulator of G protein signaling 3', 'protein-coding gene', 'ENSG00000138835'),
(5265, 40504, 'RGS5-AS1', 'RGS5 antisense RNA 1', 'non-coding RNA', 'ENSG00000232892'),
(5266, 10003, 'RGS7', 'regulator of G protein signaling 7', 'protein-coding gene', 'ENSG00000182901'),
(5267, 23271, 'RGS7BP', 'regulator of G protein signaling 7 binding protein', 'protein-coding gene', 'ENSG00000186479'),
(5268, 9997, 'RGS16', 'regulator of G protein signaling 16', 'protein-coding gene', 'ENSG00000143333'),
(5269, 14261, 'RGS18', 'regulator of G protein signaling 18', 'protein-coding gene', 'ENSG00000150681'),
(5270, 13735, 'RGS19', 'regulator of G protein signaling 19', 'protein-coding gene', 'ENSG00000171700'),
(5271, 18636, 'RGSL1', 'regulator of G protein signaling like 1', 'protein-coding gene', 'ENSG00000121446'),
(5272, 10006, 'RHAG', 'Rh associated glycoprotein', 'protein-coding gene', 'ENSG00000112077'),
(5273, 23081, 'RHBDD1', 'rhomboid domain containing 1', 'protein-coding gene', 'ENSG00000144468'),
(5274, 23082, 'RHBDD2', 'rhomboid domain containing 2', 'protein-coding gene', 'ENSG00000005486'),
(5275, 10007, 'RHBDL1', 'rhomboid like 1', 'protein-coding gene', 'ENSG00000103269'),
(5276, 16502, 'RHBDL3', 'rhomboid like 3', 'protein-coding gene', 'ENSG00000141314'),
(5277, 10009, 'RHD', 'Rh blood group D antigen', 'protein-coding gene', 'ENSG00000187010'),
(5278, 10011, 'RHEB', 'Ras homolog, mTORC1 binding', 'protein-coding gene', 'ENSG00000106615'),
(5279, 10010, 'RHEBP1', 'RHEB pseudogene 1', 'pseudogene', 'ENSG00000229927'),
(5280, 25341, 'RHEX', 'regulator of hemoglobinization and erythroid cell expansion', 'protein-coding gene', 'ENSG00000263961'),
(5281, 18738, 'RHOBTB1', 'Rho related BTB domain containing 1', 'protein-coding gene', 'ENSG00000072422'),
(5282, 669, 'RHOC', 'ras homolog family member C', 'protein-coding gene', 'ENSG00000155366'),
(5283, 37838, 'RHOT1P2', 'ras homolog family member T1 pseudogene 2', 'pseudogene', 'ENSG00000203616'),
(5284, 17794, 'RHOU', 'ras homolog family member U', 'protein-coding gene', 'ENSG00000116574'),
(5285, 18313, 'RHOV', 'ras homolog family member V', 'protein-coding gene', 'ENSG00000104140'),
(5286, 51611, 'RHOXF1P2', 'Rhox homeobox family member 1 pseudogene 2', 'pseudogene', 'ENSG00000282850'),
(5287, 19973, 'RHPN1', 'rhophilin Rho GTPase binding protein 1', 'protein-coding gene', 'ENSG00000158106'),
(5288, 19974, 'RHPN2', 'rhophilin Rho GTPase binding protein 2', 'protein-coding gene', 'ENSG00000131941'),
(5289, 30338, 'RIC3', 'RIC3 acetylcholine receptor chaperone', 'protein-coding gene', 'ENSG00000166405'),
(5290, 30266, 'RILP', 'Rab interacting lysosomal protein', 'protein-coding gene', 'ENSG00000167705'),
(5291, 26814, 'RILPL1', 'Rab interacting lysosomal protein like 1', 'protein-coding gene', 'ENSG00000188026'),
(5292, 34034, 'RIMKLBP1', 'ribosomal modification protein rimK like family member B pseudogene 1', 'pseudogene', 'ENSG00000189089'),
(5293, 18751, 'RIN3', 'Ras and Rab interactor 3', 'protein-coding gene', 'ENSG00000100599'),
(5294, 21876, 'RINT1', 'RAD50 interactor 1', 'protein-coding gene', 'ENSG00000135249'),
(5295, 39714, 'RIOK3P1', 'RIO kinase 3 pseudogene 1', 'pseudogene', 'ENSG00000225944'),
(5296, 19441, 'RIOX2', 'ribosomal oxygenase 2', 'protein-coding gene', 'ENSG00000170854'),
(5297, 10019, 'RIPK1', 'receptor interacting serine/threonine kinase 1', 'protein-coding gene', 'ENSG00000137275'),
(5298, 55545, 'RIPK2-DT', 'RIPK2 divergent transcript', 'non-coding RNA', 'ENSG00000251136'),
(5299, 496, 'RIPK4', 'receptor interacting serine/threonine kinase 4', 'protein-coding gene', 'ENSG00000183421'),
(5300, 16168, 'RIPOR3', 'RIPOR family member 3', 'protein-coding gene', 'ENSG00000042062'),
(5301, 39682, 'RLIMP1', 'ring finger protein, LIM domain interacting pseudogene 1', 'pseudogene', 'ENSG00000229456'),
(5302, 39683, 'RLIMP2', 'ring finger protein, LIM domain interacting pseudogene 2', 'pseudogene', 'ENSG00000237278'),
(5303, 41150, 'RMDN2-AS1', 'RMDN2 antisense RNA 1', 'non-coding RNA', 'ENSG00000235848'),
(5304, 25850, 'RMND5A', 'required for meiotic nuclear division 5 homolog A', 'protein-coding gene', 'ENSG00000153561'),
(5305, 29893, 'RMST', 'rhabdomyosarcoma 2 associated transcript', 'non-coding RNA', 'ENSG00000255794'),
(5306, 42621, 'RN7SKP3', 'RN7SK pseudogene 3', 'pseudogene', 'ENSG00000223341'),
(5307, 42626, 'RN7SKP8', 'RN7SK pseudogene 8', 'pseudogene', 'ENSG00000222969'),
(5308, 45735, 'RN7SKP11', 'RN7SK pseudogene 11', 'pseudogene', 'ENSG00000252827'),
(5309, 45736, 'RN7SKP12', 'RN7SK pseudogene 12', 'pseudogene', 'ENSG00000252084'),
(5310, 45741, 'RN7SKP17', 'RN7SK pseudogene 17', 'pseudogene', 'ENSG00000223174'),
(5311, 45743, 'RN7SKP19', 'RN7SK pseudogene 19', 'pseudogene', 'ENSG00000251825'),
(5312, 45748, 'RN7SKP24', 'RN7SK pseudogene 24', 'pseudogene', 'ENSG00000251697'),
(5313, 45751, 'RN7SKP27', 'RN7SK pseudogene 27', 'pseudogene', 'ENSG00000222616'),
(5314, 45756, 'RN7SKP32', 'RN7SK pseudogene 32', 'pseudogene', 'ENSG00000222099'),
(5315, 45759, 'RN7SKP35', 'RN7SK pseudogene 35', 'pseudogene', 'ENSG00000253019'),
(5316, 45760, 'RN7SKP36', 'RN7SK pseudogene 36', 'pseudogene', 'ENSG00000200867'),
(5317, 45764, 'RN7SKP40', 'RN7SK pseudogene 40', 'pseudogene', 'ENSG00000253020'),
(5318, 45775, 'RN7SKP51', 'RN7SK pseudogene 51', 'pseudogene', 'ENSG00000222713'),
(5319, 45776, 'RN7SKP52', 'RN7SK pseudogene 52', 'pseudogene', 'ENSG00000252028'),
(5320, 45781, 'RN7SKP57', 'RN7SK pseudogene 57', 'pseudogene', 'ENSG00000253057'),
(5321, 45785, 'RN7SKP61', 'RN7SK pseudogene 61', 'pseudogene', 'ENSG00000222574'),
(5322, 45788, 'RN7SKP64', 'RN7SK pseudogene 64', 'pseudogene', 'ENSG00000253015'),
(5323, 45789, 'RN7SKP65', 'RN7SK pseudogene 65', 'pseudogene', 'ENSG00000222210'),
(5324, 45790, 'RN7SKP66', 'RN7SK pseudogene 66', 'pseudogene', 'ENSG00000252490'),
(5325, 45794, 'RN7SKP70', 'RN7SK pseudogene 70', 'pseudogene', 'ENSG00000252464'),
(5326, 45796, 'RN7SKP72', 'RN7SK pseudogene 72', 'pseudogene', 'ENSG00000199197'),
(5327, 45798, 'RN7SKP74', 'RN7SK pseudogene 74', 'pseudogene', 'ENSG00000199719'),
(5328, 45801, 'RN7SKP77', 'RN7SK pseudogene 77', 'pseudogene', 'ENSG00000200131'),
(5329, 45803, 'RN7SKP79', 'RN7SK pseudogene 79', 'pseudogene', 'ENSG00000200243'),
(5330, 45813, 'RN7SKP89', 'RN7SK pseudogene 89', 'pseudogene', 'ENSG00000222706'),
(5331, 45816, 'RN7SKP92', 'RN7SK pseudogene 92', 'pseudogene', 'ENSG00000253075'),
(5332, 45820, 'RN7SKP96', 'RN7SK pseudogene 96', 'pseudogene', 'ENSG00000252757'),
(5333, 45827, 'RN7SKP103', 'RN7SK pseudogene 103', 'pseudogene', 'ENSG00000200718'),
(5334, 45831, 'RN7SKP107', 'RN7SK pseudogene 107', 'pseudogene', 'ENSG00000201027'),
(5335, 45832, 'RN7SKP108', 'RN7SK pseudogene 108', 'pseudogene', 'ENSG00000223299'),
(5336, 45842, 'RN7SKP118', 'RN7SK pseudogene 118', 'pseudogene', 'ENSG00000201201'),
(5337, 45843, 'RN7SKP119', 'RN7SK pseudogene 119', 'pseudogene', 'ENSG00000222685'),
(5338, 45870, 'RN7SKP146', 'RN7SK pseudogene 146', 'pseudogene', 'ENSG00000222174'),
(5339, 45871, 'RN7SKP147', 'RN7SK pseudogene 147', 'pseudogene', 'ENSG00000252963'),
(5340, 45872, 'RN7SKP148', 'RN7SK pseudogene 148', 'pseudogene', 'ENSG00000222111'),
(5341, 45878, 'RN7SKP154', 'RN7SK pseudogene 154', 'pseudogene', 'ENSG00000222068'),
(5342, 45880, 'RN7SKP156', 'RN7SK pseudogene 156', 'pseudogene', 'ENSG00000222240'),
(5343, 45883, 'RN7SKP159', 'RN7SK pseudogene 159', 'pseudogene', 'ENSG00000222589'),
(5344, 45884, 'RN7SKP160', 'RN7SK pseudogene 160', 'pseudogene', 'ENSG00000200674'),
(5345, 45886, 'RN7SKP162', 'RN7SK pseudogene 162', 'pseudogene', 'ENSG00000200475'),
(5346, 45889, 'RN7SKP165', 'RN7SK pseudogene 165', 'pseudogene', 'ENSG00000223282'),
(5347, 45891, 'RN7SKP167', 'RN7SK pseudogene 167', 'pseudogene', 'ENSG00000222979'),
(5348, 45901, 'RN7SKP177', 'RN7SK pseudogene 177', 'pseudogene', 'ENSG00000222499'),
(5349, 45905, 'RN7SKP181', 'RN7SK pseudogene 181', 'pseudogene', 'ENSG00000223120'),
(5350, 45907, 'RN7SKP183', 'RN7SK pseudogene 183', 'pseudogene', 'ENSG00000252978'),
(5351, 45917, 'RN7SKP193', 'RN7SK pseudogene 193', 'pseudogene', 'ENSG00000201358'),
(5352, 45919, 'RN7SKP195', 'RN7SK pseudogene 195', 'pseudogene', 'ENSG00000252396'),
(5353, 45923, 'RN7SKP199', 'RN7SK pseudogene 199', 'pseudogene', 'ENSG00000222257'),
(5354, 45927, 'RN7SKP203', 'RN7SK pseudogene 203', 'pseudogene', 'ENSG00000200488'),
(5355, 45928, 'RN7SKP204', 'RN7SK pseudogene 204', 'pseudogene', 'ENSG00000202351'),
(5356, 45929, 'RN7SKP205', 'RN7SK pseudogene 205', 'pseudogene', 'ENSG00000222931'),
(5357, 45950, 'RN7SKP226', 'RN7SK pseudogene 226', 'pseudogene', 'ENSG00000201782'),
(5358, 45954, 'RN7SKP230', 'RN7SK pseudogene 230', 'pseudogene', 'ENSG00000202512'),
(5359, 45959, 'RN7SKP235', 'RN7SK pseudogene 235', 'pseudogene', 'ENSG00000222594'),
(5360, 45963, 'RN7SKP239', 'RN7SK pseudogene 239', 'pseudogene', 'ENSG00000201684'),
(5361, 45964, 'RN7SKP240', 'RN7SK pseudogene 240', 'pseudogene', 'ENSG00000222515'),
(5362, 45970, 'RN7SKP246', 'RN7SK pseudogene 246', 'pseudogene', 'ENSG00000201423'),
(5363, 45976, 'RN7SKP252', 'RN7SK pseudogene 252', 'pseudogene', 'ENSG00000223142'),
(5364, 45986, 'RN7SKP262', 'RN7SK pseudogene 262', 'pseudogene', 'ENSG00000222950'),
(5365, 45992, 'RN7SKP268', 'RN7SK pseudogene 268', 'pseudogene', 'ENSG00000223039'),
(5366, 45996, 'RN7SKP272', 'RN7SK pseudogene 272', 'pseudogene', 'ENSG00000252797'),
(5367, 46001, 'RN7SKP277', 'RN7SK pseudogene 277', 'pseudogene', 'ENSG00000252704'),
(5368, 46008, 'RN7SKP284', 'RN7SK pseudogene 284', 'pseudogene', 'ENSG00000222934'),
(5369, 46009, 'RN7SKP285', 'RN7SK pseudogene 285', 'pseudogene', 'ENSG00000222069'),
(5370, 46014, 'RN7SKP290', 'RN7SK pseudogene 290', 'pseudogene', 'ENSG00000271814'),
(5371, 46015, 'RN7SKP291', 'RN7SK pseudogene 291', 'pseudogene', 'ENSG00000199831'),
(5372, 46018, 'RN7SKP294', 'RN7SK pseudogene 294', 'pseudogene', 'ENSG00000199640'),
(5373, 10043, 'RN7SL8P', 'RNA, 7SL, cytoplasmic 8, pseudogene', 'pseudogene', 'ENSG00000243352'),
(5374, 46030, 'RN7SL14P', 'RNA, 7SL, cytoplasmic 14, pseudogene', 'pseudogene', 'ENSG00000266720'),
(5375, 46031, 'RN7SL15P', 'RNA, 7SL, cytoplasmic 15, pseudogene', 'pseudogene', 'ENSG00000264573'),
(5376, 46044, 'RN7SL28P', 'RNA, 7SL, cytoplasmic 28, pseudogene', 'pseudogene', 'ENSG00000244512'),
(5377, 46046, 'RN7SL30P', 'RNA, 7SL, cytoplasmic 30, pseudogene', 'pseudogene', 'ENSG00000243845'),
(5378, 46053, 'RN7SL37P', 'RNA, 7SL, cytoplasmic 37, pseudogene', 'pseudogene', 'ENSG00000242493'),
(5379, 46056, 'RN7SL40P', 'RNA, 7SL, cytoplasmic 40, pseudogene', 'pseudogene', 'ENSG00000242696'),
(5380, 46057, 'RN7SL41P', 'RNA, 7SL, cytoplasmic 41, pseudogene', 'pseudogene', 'ENSG00000241550'),
(5381, 46059, 'RN7SL43P', 'RNA, 7SL, cytoplasmic 43, pseudogene', 'pseudogene', 'ENSG00000275878'),
(5382, 46078, 'RN7SL62P', 'RNA, 7SL, cytoplasmic 62, pseudogene', 'pseudogene', 'ENSG00000239640'),
(5383, 46081, 'RN7SL65P', 'RNA, 7SL, cytoplasmic 65, pseudogene', 'pseudogene', 'ENSG00000243770'),
(5384, 46085, 'RN7SL69P', 'RNA, 7SL, cytoplasmic 69, pseudogene', 'pseudogene', 'ENSG00000240533'),
(5385, 46107, 'RN7SL91P', 'RNA, 7SL, cytoplasmic 91, pseudogene', 'pseudogene', 'ENSG00000240439'),
(5386, 46109, 'RN7SL93P', 'RNA, 7SL, cytoplasmic 93, pseudogene', 'pseudogene', 'ENSG00000240327'),
(5387, 46112, 'RN7SL96P', 'RNA, 7SL, cytoplasmic 96, pseudogene', 'pseudogene', 'ENSG00000265905'),
(5388, 46116, 'RN7SL100P', 'RNA, 7SL, cytoplasmic 100, pseudogene', 'pseudogene', 'ENSG00000240306'),
(5389, 46140, 'RN7SL124P', 'RNA, 7SL, cytoplasmic 124, pseudogene', 'pseudogene', 'ENSG00000242113'),
(5390, 46142, 'RN7SL126P', 'RNA, 7SL, cytoplasmic 126, pseudogene', 'pseudogene', 'ENSG00000276281'),
(5391, 46146, 'RN7SL130P', 'RNA, 7SL, cytoplasmic 130, pseudogene', 'pseudogene', 'ENSG00000244256'),
(5392, 46148, 'RN7SL132P', 'RNA, 7SL, cytoplasmic 132, pseudogene', 'pseudogene', 'ENSG00000242653'),
(5393, 46156, 'RN7SL140P', 'RNA, 7SL, cytoplasmic 140, pseudogene', 'pseudogene', 'ENSG00000266059'),
(5394, 46166, 'RN7SL150P', 'RNA, 7SL, cytoplasmic 150, pseudogene', 'pseudogene', 'ENSG00000240626'),
(5395, 46168, 'RN7SL152P', 'RNA, 7SL, cytoplasmic 152, pseudogene', 'pseudogene', 'ENSG00000242102'),
(5396, 46178, 'RN7SL162P', 'RNA, 7SL, cytoplasmic 162, pseudogene', 'pseudogene', 'ENSG00000266503'),
(5397, 46180, 'RN7SL164P', 'RNA, 7SL, cytoplasmic 164, pseudogene', 'pseudogene', 'ENSG00000242614'),
(5398, 46192, 'RN7SL176P', 'RNA, 7SL, cytoplasmic 176, pseudogene', 'pseudogene', 'ENSG00000266610'),
(5399, 46194, 'RN7SL178P', 'RNA, 7SL, cytoplasmic 178, pseudogene', 'pseudogene', 'ENSG00000263616'),
(5400, 46197, 'RN7SL181P', 'RNA, 7SL, cytoplasmic 181, pseudogene', 'pseudogene', 'ENSG00000243738'),
(5401, 46198, 'RN7SL182P', 'RNA, 7SL, cytoplasmic 182, pseudogene', 'pseudogene', 'ENSG00000241461'),
(5402, 46201, 'RN7SL185P', 'RNA, 7SL, cytoplasmic 185, pseudogene', 'pseudogene', 'ENSG00000275776'),
(5403, 46204, 'RN7SL188P', 'RNA, 7SL, cytoplasmic 188, pseudogene', 'pseudogene', 'ENSG00000241943'),
(5404, 46217, 'RN7SL201P', 'RNA, 7SL, cytoplasmic 201, pseudogene', 'pseudogene', 'ENSG00000242118'),
(5405, 46221, 'RN7SL205P', 'RNA, 7SL, cytoplasmic 205, pseudogene', 'pseudogene', 'ENSG00000241392'),
(5406, 46235, 'RN7SL219P', 'RNA, 7SL, cytoplasmic 219, pseudogene', 'pseudogene', 'ENSG00000265386'),
(5407, 46237, 'RN7SL221P', 'RNA, 7SL, cytoplasmic 221, pseudogene', 'pseudogene', 'ENSG00000239472'),
(5408, 46238, 'RN7SL222P', 'RNA, 7SL, cytoplasmic 222, pseudogene', 'pseudogene', 'ENSG00000242165'),
(5409, 46244, 'RN7SL228P', 'RNA, 7SL, cytoplasmic 228, pseudogene', 'pseudogene', 'ENSG00000244033'),
(5410, 46252, 'RN7SL236P', 'RNA, 7SL, cytoplasmic 236, pseudogene', 'pseudogene', 'ENSG00000243870'),
(5411, 46255, 'RN7SL239P', 'RNA, 7SL, cytoplasmic 239, pseudogene', 'pseudogene', 'ENSG00000242999'),
(5412, 46276, 'RN7SL260P', 'RNA, 7SL, cytoplasmic 260, pseudogene', 'pseudogene', 'ENSG00000253602'),
(5413, 46279, 'RN7SL263P', 'RNA, 7SL, cytoplasmic 263, pseudogene', 'pseudogene', 'ENSG00000240160'),
(5414, 46282, 'RN7SL266P', 'RNA, 7SL, cytoplasmic 266, pseudogene', 'pseudogene', 'ENSG00000243011'),
(5415, 46285, 'RN7SL269P', 'RNA, 7SL, cytoplasmic 269, pseudogene', 'pseudogene', 'ENSG00000243051'),
(5416, 46293, 'RN7SL277P', 'RNA, 7SL, cytoplasmic 277, pseudogene', 'pseudogene', 'ENSG00000240490'),
(5417, 46294, 'RN7SL278P', 'RNA, 7SL, cytoplasmic 278, pseudogene', 'pseudogene', 'ENSG00000243365'),
(5418, 46296, 'RN7SL280P', 'RNA, 7SL, cytoplasmic 280, pseudogene', 'pseudogene', 'ENSG00000244671'),
(5419, 46301, 'RN7SL285P', 'RNA, 7SL, cytoplasmic 285, pseudogene', 'pseudogene', 'ENSG00000243313'),
(5420, 46302, 'RN7SL286P', 'RNA, 7SL, cytoplasmic 286, pseudogene', 'pseudogene', 'ENSG00000277464'),
(5421, 46304, 'RN7SL288P', 'RNA, 7SL, cytoplasmic 288, pseudogene', 'pseudogene', 'ENSG00000240767'),
(5422, 46319, 'RN7SL303P', 'RNA, 7SL, cytoplasmic 303, pseudogene', 'pseudogene', 'ENSG00000240116'),
(5423, 46325, 'RN7SL309P', 'RNA, 7SL, cytoplasmic 309, pseudogene', 'pseudogene', 'ENSG00000239356'),
(5424, 46326, 'RN7SL310P', 'RNA, 7SL, cytoplasmic 310, pseudogene', 'pseudogene', 'ENSG00000240663'),
(5425, 46329, 'RN7SL313P', 'RNA, 7SL, cytoplasmic 313, pseudogene', 'pseudogene', 'ENSG00000275655'),
(5426, 46330, 'RN7SL314P', 'RNA, 7SL, cytoplasmic 314, pseudogene', 'pseudogene', 'ENSG00000244402'),
(5427, 46336, 'RN7SL320P', 'RNA, 7SL, cytoplasmic 320, pseudogene', 'pseudogene', 'ENSG00000243900'),
(5428, 46338, 'RN7SL322P', 'RNA, 7SL, cytoplasmic 322, pseudogene', 'pseudogene', 'ENSG00000276588'),
(5429, 46343, 'RN7SL327P', 'RNA, 7SL, cytoplasmic 327, pseudogene', 'pseudogene', 'ENSG00000275992'),
(5430, 46344, 'RN7SL328P', 'RNA, 7SL, cytoplasmic 328, pseudogene', 'pseudogene', 'ENSG00000240853'),
(5431, 46352, 'RN7SL336P', 'RNA, 7SL, cytoplasmic 336, pseudogene', 'pseudogene', 'ENSG00000264017'),
(5432, 46353, 'RN7SL337P', 'RNA, 7SL, cytoplasmic 337, pseudogene', 'pseudogene', 'ENSG00000243488'),
(5433, 46354, 'RN7SL338P', 'RNA, 7SL, cytoplasmic 338, pseudogene', 'pseudogene', 'ENSG00000241568'),
(5434, 46360, 'RN7SL344P', 'RNA, 7SL, cytoplasmic 344, pseudogene', 'pseudogene', 'ENSG00000241395'),
(5435, 46373, 'RN7SL357P', 'RNA, 7SL, cytoplasmic 357, pseudogene', 'pseudogene', 'ENSG00000265894'),
(5436, 46378, 'RN7SL362P', 'RNA, 7SL, cytoplasmic 362, pseudogene', 'pseudogene', 'ENSG00000242707'),
(5437, 46379, 'RN7SL363P', 'RNA, 7SL, cytoplasmic 363, pseudogene', 'pseudogene', 'ENSG00000241869'),
(5438, 46380, 'RN7SL364P', 'RNA, 7SL, cytoplasmic 364, pseudogene', 'pseudogene', 'ENSG00000243560'),
(5439, 46387, 'RN7SL371P', 'RNA, 7SL, cytoplasmic 371, pseudogene', 'pseudogene', 'ENSG00000266210'),
(5440, 46388, 'RN7SL372P', 'RNA, 7SL, cytoplasmic 372, pseudogene', 'pseudogene', 'ENSG00000242565'),
(5441, 46391, 'RN7SL375P', 'RNA, 7SL, cytoplasmic 375, pseudogene', 'pseudogene', 'ENSG00000265745'),
(5442, 46406, 'RN7SL390P', 'RNA, 7SL, cytoplasmic 390, pseudogene', 'pseudogene', 'ENSG00000241785'),
(5443, 46409, 'RN7SL393P', 'RNA, 7SL, cytoplasmic 393, pseudogene', 'pseudogene', 'ENSG00000243723'),
(5444, 46410, 'RN7SL394P', 'RNA, 7SL, cytoplasmic 394, pseudogene', 'pseudogene', 'ENSG00000239942'),
(5445, 46415, 'RN7SL399P', 'RNA, 7SL, cytoplasmic 399, pseudogene', 'pseudogene', 'ENSG00000239542'),
(5446, 46419, 'RN7SL403P', 'RNA, 7SL, cytoplasmic 403, pseudogene', 'pseudogene', 'ENSG00000240625'),
(5447, 46420, 'RN7SL404P', 'RNA, 7SL, cytoplasmic 404, pseudogene', 'pseudogene', 'ENSG00000264840'),
(5448, 46421, 'RN7SL405P', 'RNA, 7SL, cytoplasmic 405, pseudogene', 'pseudogene', 'ENSG00000264540'),
(5449, 46432, 'RN7SL416P', 'RNA, 7SL, cytoplasmic 416, pseudogene', 'pseudogene', 'ENSG00000242101'),
(5450, 46457, 'RN7SL441P', 'RNA, 7SL, cytoplasmic 441, pseudogene', 'pseudogene', 'ENSG00000241413'),
(5451, 46465, 'RN7SL449P', 'RNA, 7SL, cytoplasmic 449, pseudogene', 'pseudogene', 'ENSG00000242889'),
(5452, 46472, 'RN7SL456P', 'RNA, 7SL, cytoplasmic 456, pseudogene', 'pseudogene', 'ENSG00000242266'),
(5453, 46494, 'RN7SL478P', 'RNA, 7SL, cytoplasmic 478, pseudogene', 'pseudogene', 'ENSG00000277946'),
(5454, 46499, 'RN7SL483P', 'RNA, 7SL, cytoplasmic 483, pseudogene', 'pseudogene', 'ENSG00000244091'),
(5455, 46504, 'RN7SL488P', 'RNA, 7SL, cytoplasmic 488, pseudogene', 'pseudogene', 'ENSG00000264271'),
(5456, 46510, 'RN7SL494P', 'RNA, 7SL, cytoplasmic 494, pseudogene', 'pseudogene', 'ENSG00000241175'),
(5457, 46519, 'RN7SL503P', 'RNA, 7SL, cytoplasmic 503, pseudogene', 'pseudogene', 'ENSG00000240374'),
(5458, 46525, 'RN7SL509P', 'RNA, 7SL, cytoplasmic 509, pseudogene', 'pseudogene', 'ENSG00000263479'),
(5459, 46529, 'RN7SL513P', 'RNA, 7SL, cytoplasmic 513, pseudogene', 'pseudogene', 'ENSG00000239821'),
(5460, 46532, 'RN7SL516P', 'RNA, 7SL, cytoplasmic 516, pseudogene', 'pseudogene', 'ENSG00000242699'),
(5461, 46534, 'RN7SL518P', 'RNA, 7SL, cytoplasmic 518, pseudogene', 'pseudogene', 'ENSG00000265486'),
(5462, 46542, 'RN7SL526P', 'RNA, 7SL, cytoplasmic 526, pseudogene', 'pseudogene', 'ENSG00000243642'),
(5463, 46547, 'RN7SL531P', 'RNA, 7SL, cytoplasmic 531, pseudogene', 'pseudogene', 'ENSG00000264071'),
(5464, 46551, 'RN7SL535P', 'RNA, 7SL, cytoplasmic 535, pseudogene', 'pseudogene', 'ENSG00000239419'),
(5465, 46558, 'RN7SL542P', 'RNA, 7SL, cytoplasmic 542, pseudogene', 'pseudogene', 'ENSG00000243633'),
(5466, 46573, 'RN7SL557P', 'RNA, 7SL, cytoplasmic 557, pseudogene', 'pseudogene', 'ENSG00000266166'),
(5467, 46586, 'RN7SL570P', 'RNA, 7SL, cytoplasmic 570, pseudogene', 'pseudogene', 'ENSG00000241174'),
(5468, 46589, 'RN7SL573P', 'RNA, 7SL, cytoplasmic 573, pseudogene', 'pseudogene', 'ENSG00000239607'),
(5469, 46600, 'RN7SL584P', 'RNA, 7SL, cytoplasmic 584, pseudogene', 'pseudogene', 'ENSG00000239471'),
(5470, 46618, 'RN7SL602P', 'RNA, 7SL, cytoplasmic 602, pseudogene', 'pseudogene', 'ENSG00000264352'),
(5471, 46626, 'RN7SL610P', 'RNA, 7SL, cytoplasmic 610, pseudogene', 'pseudogene', 'ENSG00000243847'),
(5472, 46634, 'RN7SL618P', 'RNA, 7SL, cytoplasmic 618, pseudogene', 'pseudogene', 'ENSG00000241613'),
(5473, 46643, 'RN7SL627P', 'RNA, 7SL, cytoplasmic 627, pseudogene', 'pseudogene', 'ENSG00000274747'),
(5474, 46648, 'RN7SL632P', 'RNA, 7SL, cytoplasmic 632, pseudogene', 'pseudogene', 'ENSG00000241524'),
(5475, 46654, 'RN7SL638P', 'RNA, 7SL, cytoplasmic 638, pseudogene', 'pseudogene', 'ENSG00000243702'),
(5476, 46659, 'RN7SL643P', 'RNA, 7SL, cytoplasmic 643, pseudogene', 'pseudogene', 'ENSG00000243124'),
(5477, 46668, 'RN7SL652P', 'RNA, 7SL, cytoplasmic 652, pseudogene', 'pseudogene', 'ENSG00000265559'),
(5478, 46674, 'RN7SL658P', 'RNA, 7SL, cytoplasmic 658, pseudogene', 'pseudogene', 'ENSG00000239333'),
(5479, 46675, 'RN7SL659P', 'RNA, 7SL, cytoplasmic 659, pseudogene', 'pseudogene', 'ENSG00000244104'),
(5480, 46684, 'RN7SL668P', 'RNA, 7SL, cytoplasmic 668, pseudogene', 'pseudogene', 'ENSG00000239690'),
(5481, 46697, 'RN7SL681P', 'RNA, 7SL, cytoplasmic 681, pseudogene', 'pseudogene', 'ENSG00000240966'),
(5482, 46699, 'RN7SL683P', 'RNA, 7SL, cytoplasmic 683, pseudogene', 'pseudogene', 'ENSG00000242330'),
(5483, 46701, 'RN7SL685P', 'RNA, 7SL, cytoplasmic 685, pseudogene', 'pseudogene', 'ENSG00000242315'),
(5484, 46706, 'RN7SL690P', 'RNA, 7SL, cytoplasmic 690, pseudogene', 'pseudogene', 'ENSG00000264879'),
(5485, 46707, 'RN7SL691P', 'RNA, 7SL, cytoplasmic 691, pseudogene', 'pseudogene', 'ENSG00000239464'),
(5486, 46709, 'RN7SL693P', 'RNA, 7SL, cytoplasmic 693, pseudogene', 'pseudogene', 'ENSG00000265272'),
(5487, 46713, 'RN7SL697P', 'RNA, 7SL, cytoplasmic 697, pseudogene', 'pseudogene', 'ENSG00000264484'),
(5488, 46714, 'RN7SL698P', 'RNA, 7SL, cytoplasmic 698, pseudogene', 'pseudogene', 'ENSG00000244232'),
(5489, 46727, 'RN7SL711P', 'RNA, 7SL, cytoplasmic 711, pseudogene', 'pseudogene', 'ENSG00000276047'),
(5490, 46730, 'RN7SL714P', 'RNA, 7SL, cytoplasmic 714, pseudogene', 'pseudogene', 'ENSG00000241757'),
(5491, 46748, 'RN7SL732P', 'RNA, 7SL, cytoplasmic 732, pseudogene', 'pseudogene', 'ENSG00000264618'),
(5492, 46764, 'RN7SL748P', 'RNA, 7SL, cytoplasmic 748, pseudogene', 'pseudogene', 'ENSG00000239964'),
(5493, 46767, 'RN7SL751P', 'RNA, 7SL, cytoplasmic 751, pseudogene', 'pseudogene', 'ENSG00000240964'),
(5494, 46768, 'RN7SL752P', 'RNA, 7SL, cytoplasmic 752, pseudogene', 'pseudogene', 'ENSG00000239437'),
(5495, 46770, 'RN7SL754P', 'RNA, 7SL, cytoplasmic 754, pseudogene', 'pseudogene', 'ENSG00000239822'),
(5496, 46777, 'RN7SL761P', 'RNA, 7SL, cytoplasmic 761, pseudogene', 'pseudogene', 'ENSG00000243671'),
(5497, 46779, 'RN7SL763P', 'RNA, 7SL, cytoplasmic 763, pseudogene', 'pseudogene', 'ENSG00000277774'),
(5498, 46783, 'RN7SL767P', 'RNA, 7SL, cytoplasmic 767, pseudogene', 'pseudogene', 'ENSG00000241529'),
(5499, 46791, 'RN7SL775P', 'RNA, 7SL, cytoplasmic 775, pseudogene', 'pseudogene', 'ENSG00000243370'),
(5500, 46792, 'RN7SL776P', 'RNA, 7SL, cytoplasmic 776, pseudogene', 'pseudogene', 'ENSG00000240772'),
(5501, 46804, 'RN7SL788P', 'RNA, 7SL, cytoplasmic 788, pseudogene', 'pseudogene', 'ENSG00000241745'),
(5502, 46808, 'RN7SL792P', 'RNA, 7SL, cytoplasmic 792, pseudogene', 'pseudogene', 'ENSG00000239888'),
(5503, 46818, 'RN7SL802P', 'RNA, 7SL, cytoplasmic 802, pseudogene', 'pseudogene', 'ENSG00000277506'),
(5504, 46820, 'RN7SL804P', 'RNA, 7SL, cytoplasmic 804, pseudogene', 'pseudogene', 'ENSG00000266185'),
(5505, 46831, 'RN7SL815P', 'RNA, 7SL, cytoplasmic 815, pseudogene', 'pseudogene', 'ENSG00000243359'),
(5506, 46840, 'RN7SL824P', 'RNA, 7SL, cytoplasmic 824, pseudogene', 'pseudogene', 'ENSG00000242764'),
(5507, 46852, 'RN7SL836P', 'RNA, 7SL, cytoplasmic 836, pseudogene', 'pseudogene', 'ENSG00000241226'),
(5508, 46854, 'RN7SL838P', 'RNA, 7SL, cytoplasmic 838, pseudogene', 'pseudogene', 'ENSG00000243562'),
(5509, 46859, 'RN7SL843P', 'RNA, 7SL, cytoplasmic 843, pseudogene', 'pseudogene', 'ENSG00000239547'),
(5510, 46863, 'RN7SL847P', 'RNA, 7SL, cytoplasmic 847, pseudogene', 'pseudogene', 'ENSG00000265319'),
(5511, 46870, 'RN7SL854P', 'RNA, 7SL, cytoplasmic 854, pseudogene', 'pseudogene', 'ENSG00000239319'),
(5512, 53525, 'RNA5-8SN3', 'RNA, 5.8S ribosomal N3', 'non-coding RNA', 'ENSG00000275215'),
(5513, 41958, 'RNA5-8SP4', 'RNA, 5.8S ribosomal pseudogene 4', 'pseudogene', 'ENSG00000201966'),
(5514, 41962, 'RNA5-8SP7', 'RNA, 5.8S ribosomal pseudogene 7', 'pseudogene', 'ENSG00000200313'),
(5515, 34363, 'RNA5S2', 'RNA, 5S ribosomal 2', 'non-coding RNA', 'ENSG00000201588'),
(5516, 34368, 'RNA5S7', 'RNA, 5S ribosomal 7', 'non-coding RNA', 'ENSG00000202521'),
(5517, 34373, 'RNA5S12', 'RNA, 5S ribosomal 12', 'non-coding RNA', 'ENSG00000199270'),
(5518, 34378, 'RNA5S17', 'RNA, 5S ribosomal 17', 'non-coding RNA', 'ENSG00000200370'),
(5519, 42604, 'RNA5SP28', 'RNA, 5S ribosomal pseudogene 28', 'pseudogene', 'ENSG00000200711'),
(5520, 42614, 'RNA5SP38', 'RNA, 5S ribosomal pseudogene 38', 'pseudogene', 'ENSG00000222682'),
(5521, 42818, 'RNA5SP42', 'RNA, 5S ribosomal pseudogene 42', 'pseudogene', 'ENSG00000201148'),
(5522, 42824, 'RNA5SP48', 'RNA, 5S ribosomal pseudogene 48', 'pseudogene', 'ENSG00000200839'),
(5523, 42828, 'RNA5SP51', 'RNA, 5S ribosomal pseudogene 51', 'pseudogene', 'ENSG00000201620'),
(5524, 42832, 'RNA5SP55', 'RNA, 5S ribosomal pseudogene 55', 'pseudogene', 'ENSG00000252510'),
(5525, 42834, 'RNA5SP57', 'RNA, 5S ribosomal pseudogene 57', 'pseudogene', 'ENSG00000238765'),
(5526, 42838, 'RNA5SP61', 'RNA, 5S ribosomal pseudogene 61', 'pseudogene', 'ENSG00000252262'),
(5527, 42845, 'RNA5SP68', 'RNA, 5S ribosomal pseudogene 68', 'pseudogene', 'ENSG00000200755'),
(5528, 42886, 'RNA5SP88', 'RNA, 5S ribosomal pseudogene 88', 'pseudogene', 'ENSG00000202430'),
(5529, 42888, 'RNA5SP90', 'RNA, 5S ribosomal pseudogene 90', 'pseudogene', 'ENSG00000201671'),
(5530, 42905, 'RNA5SP107', 'RNA, 5S ribosomal pseudogene 107', 'pseudogene', 'ENSG00000223290'),
(5531, 42908, 'RNA5SP110', 'RNA, 5S ribosomal pseudogene 110', 'pseudogene', 'ENSG00000199508'),
(5532, 42914, 'RNA5SP116', 'RNA, 5S ribosomal pseudogene 116', 'pseudogene', 'ENSG00000251941'),
(5533, 42918, 'RNA5SP120', 'RNA, 5S ribosomal pseudogene 120', 'pseudogene', 'ENSG00000222832'),
(5534, 43036, 'RNA5SP136', 'RNA, 5S ribosomal pseudogene 136', 'pseudogene', 'ENSG00000222838'),
(5535, 43049, 'RNA5SP149', 'RNA, 5S ribosomal pseudogene 149', 'pseudogene', 'ENSG00000201822'),
(5536, 43061, 'RNA5SP161', 'RNA, 5S ribosomal pseudogene 161', 'pseudogene', 'ENSG00000200741'),
(5537, 43067, 'RNA5SP167', 'RNA, 5S ribosomal pseudogene 167', 'pseudogene', 'ENSG00000202331'),
(5538, 43069, 'RNA5SP169', 'RNA, 5S ribosomal pseudogene 169', 'pseudogene', 'ENSG00000253077'),
(5539, 43073, 'RNA5SP173', 'RNA, 5S ribosomal pseudogene 173', 'pseudogene', 'ENSG00000201727'),
(5540, 43075, 'RNA5SP175', 'RNA, 5S ribosomal pseudogene 175', 'pseudogene', 'ENSG00000201145'),
(5541, 43084, 'RNA5SP184', 'RNA, 5S ribosomal pseudogene 184', 'pseudogene', 'ENSG00000223003'),
(5542, 43091, 'RNA5SP191', 'RNA, 5S ribosomal pseudogene 191', 'pseudogene', 'ENSG00000199455'),
(5543, 43098, 'RNA5SP198', 'RNA, 5S ribosomal pseudogene 198', 'pseudogene', 'ENSG00000222308'),
(5544, 43114, 'RNA5SP214', 'RNA, 5S ribosomal pseudogene 214', 'pseudogene', 'ENSG00000200248'),
(5545, 43117, 'RNA5SP217', 'RNA, 5S ribosomal pseudogene 217', 'pseudogene', 'ENSG00000251768'),
(5546, 43118, 'RNA5SP218', 'RNA, 5S ribosomal pseudogene 218', 'pseudogene', 'ENSG00000200058'),
(5547, 43119, 'RNA5SP219', 'RNA, 5S ribosomal pseudogene 219', 'pseudogene', 'ENSG00000212242'),
(5548, 43123, 'RNA5SP223', 'RNA, 5S ribosomal pseudogene 223', 'pseudogene', 'ENSG00000202044'),
(5549, 43129, 'RNA5SP229', 'RNA, 5S ribosomal pseudogene 229', 'pseudogene', 'ENSG00000222741'),
(5550, 43132, 'RNA5SP232', 'RNA, 5S ribosomal pseudogene 232', 'pseudogene', 'ENSG00000201014'),
(5551, 43136, 'RNA5SP236', 'RNA, 5S ribosomal pseudogene 236', 'pseudogene', 'ENSG00000251978'),
(5552, 43144, 'RNA5SP244', 'RNA, 5S ribosomal pseudogene 244', 'pseudogene', 'ENSG00000212238'),
(5553, 43145, 'RNA5SP245', 'RNA, 5S ribosomal pseudogene 245', 'pseudogene', 'ENSG00000201109'),
(5554, 43148, 'RNA5SP248', 'RNA, 5S ribosomal pseudogene 248', 'pseudogene', 'ENSG00000202472'),
(5555, 43167, 'RNA5SP267', 'RNA, 5S ribosomal pseudogene 267', 'pseudogene', 'ENSG00000201763'),
(5556, 43168, 'RNA5SP268', 'RNA, 5S ribosomal pseudogene 268', 'pseudogene', 'ENSG00000252637'),
(5557, 43170, 'RNA5SP270', 'RNA, 5S ribosomal pseudogene 270', 'pseudogene', 'ENSG00000223293'),
(5558, 43171, 'RNA5SP271', 'RNA, 5S ribosomal pseudogene 271', 'pseudogene', 'ENSG00000252509'),
(5559, 43176, 'RNA5SP276', 'RNA, 5S ribosomal pseudogene 276', 'pseudogene', 'ENSG00000199450'),
(5560, 43183, 'RNA5SP283', 'RNA, 5S ribosomal pseudogene 283', 'pseudogene', 'ENSG00000202474'),
(5561, 43186, 'RNA5SP286', 'RNA, 5S ribosomal pseudogene 286', 'pseudogene', 'ENSG00000212454'),
(5562, 43188, 'RNA5SP288', 'RNA, 5S ribosomal pseudogene 288', 'pseudogene', 'ENSG00000251884'),
(5563, 43189, 'RNA5SP289', 'RNA, 5S ribosomal pseudogene 289', 'pseudogene', 'ENSG00000199202'),
(5564, 43206, 'RNA5SP306', 'RNA, 5S ribosomal pseudogene 306', 'pseudogene', 'ENSG00000223019'),
(5565, 43209, 'RNA5SP309', 'RNA, 5S ribosomal pseudogene 309', 'pseudogene', 'ENSG00000252479'),
(5566, 43219, 'RNA5SP319', 'RNA, 5S ribosomal pseudogene 319', 'pseudogene', 'ENSG00000199638'),
(5567, 43224, 'RNA5SP324', 'RNA, 5S ribosomal pseudogene 324', 'pseudogene', 'ENSG00000202047'),
(5568, 43229, 'RNA5SP329', 'RNA, 5S ribosomal pseudogene 329', 'pseudogene', 'ENSG00000202147'),
(5569, 43231, 'RNA5SP331', 'RNA, 5S ribosomal pseudogene 331', 'pseudogene', 'ENSG00000201856'),
(5570, 43233, 'RNA5SP333', 'RNA, 5S ribosomal pseudogene 333', 'pseudogene', 'ENSG00000200336'),
(5571, 43237, 'RNA5SP337', 'RNA, 5S ribosomal pseudogene 337', 'pseudogene', 'ENSG00000252816'),
(5572, 43244, 'RNA5SP344', 'RNA, 5S ribosomal pseudogene 344', 'pseudogene', 'ENSG00000223013'),
(5573, 43245, 'RNA5SP345', 'RNA, 5S ribosomal pseudogene 345', 'pseudogene', 'ENSG00000222578'),
(5574, 43247, 'RNA5SP347', 'RNA, 5S ribosomal pseudogene 347', 'pseudogene', 'ENSG00000199315'),
(5575, 43252, 'RNA5SP352', 'RNA, 5S ribosomal pseudogene 352', 'pseudogene', 'ENSG00000200278'),
(5576, 43253, 'RNA5SP353', 'RNA, 5S ribosomal pseudogene 353', 'pseudogene', 'ENSG00000201476');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(5577, 43256, 'RNA5SP356', 'RNA, 5S ribosomal pseudogene 356', 'pseudogene', 'ENSG00000251781'),
(5578, 43258, 'RNA5SP358', 'RNA, 5S ribosomal pseudogene 358', 'pseudogene', 'ENSG00000199843'),
(5579, 43266, 'RNA5SP366', 'RNA, 5S ribosomal pseudogene 366', 'pseudogene', 'ENSG00000202324'),
(5580, 43276, 'RNA5SP376', 'RNA, 5S ribosomal pseudogene 376', 'pseudogene', 'ENSG00000212251'),
(5581, 43289, 'RNA5SP389', 'RNA, 5S ribosomal pseudogene 389', 'pseudogene', 'ENSG00000199480'),
(5582, 43292, 'RNA5SP392', 'RNA, 5S ribosomal pseudogene 392', 'pseudogene', 'ENSG00000252714'),
(5583, 43296, 'RNA5SP396', 'RNA, 5S ribosomal pseudogene 396', 'pseudogene', 'ENSG00000201704'),
(5584, 43301, 'RNA5SP401', 'RNA, 5S ribosomal pseudogene 401', 'pseudogene', 'ENSG00000251729'),
(5585, 43304, 'RNA5SP404', 'RNA, 5S ribosomal pseudogene 404', 'pseudogene', 'ENSG00000252927'),
(5586, 43308, 'RNA5SP408', 'RNA, 5S ribosomal pseudogene 408', 'pseudogene', 'ENSG00000251924'),
(5587, 43312, 'RNA5SP412', 'RNA, 5S ribosomal pseudogene 412', 'pseudogene', 'ENSG00000277004'),
(5588, 43317, 'RNA5SP417', 'RNA, 5S ribosomal pseudogene 417', 'pseudogene', 'ENSG00000252268'),
(5589, 43322, 'RNA5SP422', 'RNA, 5S ribosomal pseudogene 422', 'pseudogene', 'ENSG00000252587'),
(5590, 43325, 'RNA5SP425', 'RNA, 5S ribosomal pseudogene 425', 'pseudogene', 'ENSG00000222268'),
(5591, 43330, 'RNA5SP430', 'RNA, 5S ribosomal pseudogene 430', 'pseudogene', 'ENSG00000199299'),
(5592, 43338, 'RNA5SP438', 'RNA, 5S ribosomal pseudogene 438', 'pseudogene', 'ENSG00000252370'),
(5593, 43339, 'RNA5SP439', 'RNA, 5S ribosomal pseudogene 439', 'pseudogene', 'ENSG00000274164'),
(5594, 43349, 'RNA5SP449', 'RNA, 5S ribosomal pseudogene 449', 'pseudogene', 'ENSG00000252680'),
(5595, 43350, 'RNA5SP450', 'RNA, 5S ribosomal pseudogene 450', 'pseudogene', 'ENSG00000223138'),
(5596, 43351, 'RNA5SP451', 'RNA, 5S ribosomal pseudogene 451', 'pseudogene', 'ENSG00000222520'),
(5597, 43357, 'RNA5SP457', 'RNA, 5S ribosomal pseudogene 457', 'pseudogene', 'ENSG00000200527'),
(5598, 43359, 'RNA5SP459', 'RNA, 5S ribosomal pseudogene 459', 'pseudogene', 'ENSG00000252437'),
(5599, 43360, 'RNA5SP460', 'RNA, 5S ribosomal pseudogene 460', 'pseudogene', 'ENSG00000252598'),
(5600, 43362, 'RNA5SP462', 'RNA, 5S ribosomal pseudogene 462', 'pseudogene', 'ENSG00000252539'),
(5601, 43376, 'RNA5SP476', 'RNA, 5S ribosomal pseudogene 476', 'pseudogene', 'ENSG00000252422'),
(5602, 43397, 'RNA5SP497', 'RNA, 5S ribosomal pseudogene 497', 'pseudogene', 'ENSG00000251890'),
(5603, 43398, 'RNA5SP498', 'RNA, 5S ribosomal pseudogene 498', 'pseudogene', 'ENSG00000223274'),
(5604, 43401, 'RNA5SP501', 'RNA, 5S ribosomal pseudogene 501', 'pseudogene', 'ENSG00000222922'),
(5605, 43408, 'RNA5SP508', 'RNA, 5S ribosomal pseudogene 508', 'pseudogene', 'ENSG00000223259'),
(5606, 43409, 'RNA5SP509', 'RNA, 5S ribosomal pseudogene 509', 'pseudogene', 'ENSG00000201447'),
(5607, 43410, 'RNA5SP510', 'RNA, 5S ribosomal pseudogene 510', 'pseudogene', 'ENSG00000201567'),
(5608, 53793, 'RNA5SP524', 'RNA, 5S ribosomal pseudogene 524', 'pseudogene', 'ENSG00000201285'),
(5609, 53797, 'RNA5SP528', 'RNA, 5S ribosomal pseudogene 528', 'pseudogene', 'ENSG00000275305'),
(5610, 53798, 'RNA5SP529', 'RNA, 5S ribosomal pseudogene 529', 'pseudogene', 'ENSG00000276442'),
(5611, 53804, 'RNA5SP535', 'RNA, 5S ribosomal pseudogene 535', 'pseudogene', 'ENSG00000274097'),
(5612, 53805, 'RNA5SP536', 'RNA, 5S ribosomal pseudogene 536', 'pseudogene', 'ENSG00000274408'),
(5613, 10045, 'RNASE2', 'ribonuclease A family member 2', 'protein-coding gene', 'ENSG00000169385'),
(5614, 20673, 'RNASE9', 'ribonuclease A family member 9 (inactive)', 'protein-coding gene', 'ENSG00000188655'),
(5615, 25285, 'RNASE13', 'ribonuclease A family member 13 (inactive)', 'protein-coding gene', 'ENSG00000206150'),
(5616, 33987, 'RNF2P1', 'ring finger protein 2 pseudogene 1', 'pseudogene', 'ENSG00000231381'),
(5617, 39922, 'RNF6P1', 'ring finger protein 6 pseudogene 1', 'pseudogene', 'ENSG00000227406'),
(5618, 43425, 'RNF7P1', 'ring finger protein 7 pseudogene 1', 'pseudogene', 'ENSG00000239831'),
(5619, 17118, 'RNF32', 'ring finger protein 32', 'protein-coding gene', 'ENSG00000105982'),
(5620, 16867, 'RNF40', 'ring finger protein 40', 'protein-coding gene', 'ENSG00000103549'),
(5621, 21070, 'RNF121', 'ring finger protein 121', 'protein-coding gene', 'ENSG00000137522'),
(5622, 21153, 'RNF128', 'ring finger protein 128', 'protein-coding gene', 'ENSG00000133135'),
(5623, 21158, 'RNF135', 'ring finger protein 135', 'protein-coding gene', 'ENSG00000181481'),
(5624, 17023, 'RNF139', 'ring finger protein 139', 'protein-coding gene', 'ENSG00000170881'),
(5625, 22411, 'RNF148', 'ring finger protein 148', 'protein-coding gene', 'ENSG00000235631'),
(5626, 23235, 'RNF151', 'ring finger protein 151', 'protein-coding gene', 'ENSG00000179580'),
(5627, 31696, 'RNF165', 'ring finger protein 165', 'protein-coding gene', 'ENSG00000141622'),
(5628, 41127, 'RNF186-AS1', 'RNF186 antisense RNA 1', 'non-coding RNA', 'ENSG00000235434'),
(5629, 27146, 'RNF187', 'ring finger protein 187', 'protein-coding gene', 'ENSG00000168159'),
(5630, 32947, 'RNF207', 'ring finger protein 207', 'protein-coding gene', 'ENSG00000158286'),
(5631, 41912, 'RNF224', 'ring finger protein 224', 'protein-coding gene', 'ENSG00000233198'),
(5632, 44389, 'RNFT1P3', 'ring finger protein, transmembrane 1 pseudogene 3', 'pseudogene', 'ENSG00000187870'),
(5633, 25905, 'RNFT2', 'ring finger protein, transmembrane 2', 'protein-coding gene', 'ENSG00000135119'),
(5634, 25641, 'RNLS', 'renalase, FAD dependent amine oxidase', 'protein-coding gene', 'ENSG00000184719'),
(5635, 10130, 'RNU1-3', 'RNA, U1 small nuclear 3', 'non-coding RNA', 'ENSG00000207513'),
(5636, 41943, 'RNU1-17P', 'RNA, U1 small nuclear 17, pseudogene', 'pseudogene', 'ENSG00000199892'),
(5637, 41944, 'RNU1-18P', 'RNA, U1 small nuclear 18, pseudogene', 'pseudogene', 'ENSG00000199932'),
(5638, 41946, 'RNU1-20P', 'RNA, U1 small nuclear 20, pseudogene', 'pseudogene', 'ENSG00000200184'),
(5639, 41963, 'RNU1-22P', 'RNA, U1 small nuclear 22, pseudogene', 'pseudogene', 'ENSG00000200204'),
(5640, 48371, 'RNU1-29P', 'RNA, U1 small nuclear 29, pseudogene', 'pseudogene', 'ENSG00000271739'),
(5641, 48378, 'RNU1-36P', 'RNA, U1 small nuclear 36, pseudogene', 'pseudogene', 'ENSG00000202000'),
(5642, 48381, 'RNU1-39P', 'RNA, U1 small nuclear 39, pseudogene', 'pseudogene', 'ENSG00000206624'),
(5643, 48386, 'RNU1-44P', 'RNA, U1 small nuclear 44, pseudogene', 'pseudogene', 'ENSG00000207182'),
(5644, 48400, 'RNU1-58P', 'RNA, U1 small nuclear 58, pseudogene', 'pseudogene', 'ENSG00000199283'),
(5645, 48410, 'RNU1-68P', 'RNA, U1 small nuclear 68, pseudogene', 'pseudogene', 'ENSG00000275229'),
(5646, 48419, 'RNU1-77P', 'RNA, U1 small nuclear 77, pseudogene', 'pseudogene', 'ENSG00000212170'),
(5647, 48433, 'RNU1-91P', 'RNA, U1 small nuclear 91, pseudogene', 'pseudogene', 'ENSG00000201616'),
(5648, 48439, 'RNU1-97P', 'RNA, U1 small nuclear 97, pseudogene', 'pseudogene', 'ENSG00000252681'),
(5649, 48440, 'RNU1-98P', 'RNA, U1 small nuclear 98, pseudogene', 'pseudogene', 'ENSG00000239023'),
(5650, 48443, 'RNU1-101P', 'RNA, U1 small nuclear 101, pseudogene', 'pseudogene', 'ENSG00000212473'),
(5651, 48445, 'RNU1-103P', 'RNA, U1 small nuclear 103, pseudogene', 'pseudogene', 'ENSG00000252311'),
(5652, 48450, 'RNU1-108P', 'RNA, U1 small nuclear 108, pseudogene', 'pseudogene', 'ENSG00000199426'),
(5653, 48461, 'RNU1-119P', 'RNA, U1 small nuclear 119, pseudogene', 'pseudogene', 'ENSG00000212424'),
(5654, 48466, 'RNU1-124P', 'RNA, U1 small nuclear 124, pseudogene', 'pseudogene', 'ENSG00000200731'),
(5655, 48470, 'RNU1-128P', 'RNA, U1 small nuclear 128, pseudogene', 'pseudogene', 'ENSG00000252513'),
(5656, 48480, 'RNU1-138P', 'RNA, U1 small nuclear 138, pseudogene', 'pseudogene', 'ENSG00000206820'),
(5657, 48482, 'RNU1-140P', 'RNA, U1 small nuclear 140, pseudogene', 'pseudogene', 'ENSG00000201910'),
(5658, 48484, 'RNU1-142P', 'RNA, U1 small nuclear 142, pseudogene', 'pseudogene', 'ENSG00000252491'),
(5659, 48488, 'RNU1-146P', 'RNA, U1 small nuclear 146, pseudogene', 'pseudogene', 'ENSG00000200885'),
(5660, 54437, 'RNU1-155P', 'RNA, U1 small nuclear 155 pseudogene', 'pseudogene', 'ENSG00000252135'),
(5661, 10142, 'RNU2-1', 'RNA, U2 small nuclear 1', 'non-coding RNA', 'ENSG00000274585'),
(5662, 10154, 'RNU2-4P', 'RNA, U2 small nuclear 4, pseudogene', 'pseudogene', 'ENSG00000277084'),
(5663, 48506, 'RNU2-13P', 'RNA, U2 small nuclear 13, pseudogene', 'pseudogene', 'ENSG00000251718'),
(5664, 48510, 'RNU2-17P', 'RNA, U2 small nuclear 17, pseudogene', 'pseudogene', 'ENSG00000222222'),
(5665, 48517, 'RNU2-24P', 'RNA, U2 small nuclear 24, pseudogene', 'pseudogene', 'ENSG00000252639'),
(5666, 48528, 'RNU2-35P', 'RNA, U2 small nuclear 35, pseudogene', 'pseudogene', 'ENSG00000252255'),
(5667, 48538, 'RNU2-45P', 'RNA, U2 small nuclear 45, pseudogene', 'pseudogene', 'ENSG00000251877'),
(5668, 48545, 'RNU2-52P', 'RNA, U2 small nuclear 52, pseudogene', 'pseudogene', 'ENSG00000222612'),
(5669, 48550, 'RNU2-57P', 'RNA, U2 small nuclear 57, pseudogene', 'pseudogene', 'ENSG00000252468'),
(5670, 48558, 'RNU2-65P', 'RNA, U2 small nuclear 65, pseudogene', 'pseudogene', 'ENSG00000222094'),
(5671, 48562, 'RNU2-69P', 'RNA, U2 small nuclear 69, pseudogene', 'pseudogene', 'ENSG00000251870'),
(5672, 46947, 'RNU4-11P', 'RNA, U4 small nuclear 11, pseudogene', 'pseudogene', 'ENSG00000202157'),
(5673, 46948, 'RNU4-12P', 'RNA, U4 small nuclear 12, pseudogene', 'pseudogene', 'ENSG00000202103'),
(5674, 46958, 'RNU4-22P', 'RNA, U4 small nuclear 22, pseudogene', 'pseudogene', 'ENSG00000222990'),
(5675, 46963, 'RNU4-27P', 'RNA, U4 small nuclear 27, pseudogene', 'pseudogene', 'ENSG00000222821'),
(5676, 46966, 'RNU4-30P', 'RNA, U4 small nuclear 30, pseudogene', 'pseudogene', 'ENSG00000222177'),
(5677, 46974, 'RNU4-38P', 'RNA, U4 small nuclear 38, pseudogene', 'pseudogene', 'ENSG00000201342'),
(5678, 46975, 'RNU4-39P', 'RNA, U4 small nuclear 39, pseudogene', 'pseudogene', 'ENSG00000199325'),
(5679, 46976, 'RNU4-40P', 'RNA, U4 small nuclear 40, pseudogene', 'pseudogene', 'ENSG00000201221'),
(5680, 46978, 'RNU4-42P', 'RNA, U4 small nuclear 42, pseudogene', 'pseudogene', 'ENSG00000201608'),
(5681, 46984, 'RNU4-48P', 'RNA, U4 small nuclear 48, pseudogene', 'pseudogene', 'ENSG00000202429'),
(5682, 46985, 'RNU4-49P', 'RNA, U4 small nuclear 49, pseudogene', 'pseudogene', 'ENSG00000251889'),
(5683, 46988, 'RNU4-52P', 'RNA, U4 small nuclear 52, pseudogene', 'pseudogene', 'ENSG00000206936'),
(5684, 46991, 'RNU4-55P', 'RNA, U4 small nuclear 55, pseudogene', 'pseudogene', 'ENSG00000222663'),
(5685, 46995, 'RNU4-59P', 'RNA, U4 small nuclear 59, pseudogene', 'pseudogene', 'ENSG00000201317'),
(5686, 47004, 'RNU4-68P', 'RNA, U4 small nuclear 68, pseudogene', 'pseudogene', 'ENSG00000201184'),
(5687, 47007, 'RNU4-71P', 'RNA, U4 small nuclear 71, pseudogene', 'pseudogene', 'ENSG00000252067'),
(5688, 47009, 'RNU4-73P', 'RNA, U4 small nuclear 73, pseudogene', 'pseudogene', 'ENSG00000200034'),
(5689, 47016, 'RNU4-80P', 'RNA, U4 small nuclear 80, pseudogene', 'pseudogene', 'ENSG00000200070'),
(5690, 47019, 'RNU4-83P', 'RNA, U4 small nuclear 83, pseudogene', 'pseudogene', 'ENSG00000222795'),
(5691, 47021, 'RNU4-85P', 'RNA, U4 small nuclear 85, pseudogene', 'pseudogene', 'ENSG00000201545'),
(5692, 47025, 'RNU4-89P', 'RNA, U4 small nuclear 89, pseudogene', 'pseudogene', 'ENSG00000272359'),
(5693, 47026, 'RNU4-90P', 'RNA, U4 small nuclear 90, pseudogene', 'pseudogene', 'ENSG00000199643'),
(5694, 46894, 'RNU4ATAC8P', 'RNA, U4atac small nuclear 8, pseudogene', 'pseudogene', 'ENSG00000252005'),
(5695, 46895, 'RNU4ATAC9P', 'RNA, U4atac small nuclear 9, pseudogene', 'pseudogene', 'ENSG00000252955'),
(5696, 10211, 'RNU5A-1', 'RNA, U5A small nuclear 1', 'non-coding RNA', 'ENSG00000199568'),
(5697, 42520, 'RNU5E-5P', 'RNA, U5E small nuclear 5, pseudogene', 'pseudogene', 'ENSG00000202249'),
(5698, 42526, 'RNU5E-7P', 'RNA, U5E small nuclear 7, pseudogene', 'pseudogene', 'ENSG00000202160'),
(5699, 42528, 'RNU5E-8P', 'RNA, U5E small nuclear 8, pseudogene', 'pseudogene', 'ENSG00000200372'),
(5700, 10216, 'RNU5F-1', 'RNA, U5F small nuclear 1', 'non-coding RNA', 'ENSG00000199377'),
(5701, 42516, 'RNU5F-4P', 'RNA, U5F small nuclear 4, pseudogene', 'pseudogene', 'ENSG00000252390'),
(5702, 10228, 'RNU6-6P', 'RNA, U6 small nuclear 6, pseudogene', 'pseudogene', 'ENSG00000272055'),
(5703, 34255, 'RNU6-11P', 'RNA, U6 small nuclear 11, pseudogene', 'pseudogene', 'ENSG00000201104'),
(5704, 34257, 'RNU6-13P', 'RNA, U6 small nuclear 13, pseudogene', 'pseudogene', 'ENSG00000206975'),
(5705, 34260, 'RNU6-16P', 'RNA, U6 small nuclear 16, pseudogene', 'pseudogene', 'ENSG00000207113'),
(5706, 34262, 'RNU6-18P', 'RNA, U6 small nuclear 18, pseudogene', 'pseudogene', 'ENSG00000207257'),
(5707, 34263, 'RNU6-19P', 'RNA, U6 small nuclear 19, pseudogene', 'pseudogene', 'ENSG00000207449'),
(5708, 34267, 'RNU6-23P', 'RNA, U6 small nuclear 23, pseudogene', 'pseudogene', 'ENSG00000200153'),
(5709, 34268, 'RNU6-24P', 'RNA, U6 small nuclear 24, pseudogene', 'pseudogene', 'ENSG00000207169'),
(5710, 34272, 'RNU6-28P', 'RNA, U6 small nuclear 28, pseudogene', 'pseudogene', 'ENSG00000199248'),
(5711, 34281, 'RNU6-37P', 'RNA, U6 small nuclear 37, pseudogene', 'pseudogene', 'ENSG00000199562'),
(5712, 42562, 'RNU6-72P', 'RNA, U6 small nuclear 72, pseudogene', 'pseudogene', 'ENSG00000207012'),
(5713, 42568, 'RNU6-78P', 'RNA, U6 small nuclear 78, pseudogene', 'pseudogene', 'ENSG00000199767'),
(5714, 42571, 'RNU6-81P', 'RNA, U6 small nuclear 81, pseudogene', 'pseudogene', 'ENSG00000202478'),
(5715, 47051, 'RNU6-88P', 'RNA, U6 small nuclear 88, pseudogene', 'pseudogene', 'ENSG00000272507'),
(5716, 47055, 'RNU6-92P', 'RNA, U6 small nuclear 92, pseudogene', 'pseudogene', 'ENSG00000272393'),
(5717, 47064, 'RNU6-101P', 'RNA, U6 small nuclear 101, pseudogene', 'pseudogene', 'ENSG00000222255'),
(5718, 47073, 'RNU6-110P', 'RNA, U6 small nuclear 110, pseudogene', 'pseudogene', 'ENSG00000207237'),
(5719, 47076, 'RNU6-113P', 'RNA, U6 small nuclear 113, pseudogene', 'pseudogene', 'ENSG00000252462'),
(5720, 47083, 'RNU6-120P', 'RNA, U6 small nuclear 120, pseudogene', 'pseudogene', 'ENSG00000251886'),
(5721, 47085, 'RNU6-122P', 'RNA, U6 small nuclear 122, pseudogene', 'pseudogene', 'ENSG00000252627'),
(5722, 47086, 'RNU6-123P', 'RNA, U6 small nuclear 123, pseudogene', 'pseudogene', 'ENSG00000251972'),
(5723, 47090, 'RNU6-127P', 'RNA, U6 small nuclear 127, pseudogene', 'pseudogene', 'ENSG00000212199'),
(5724, 47093, 'RNU6-130P', 'RNA, U6 small nuclear 130, pseudogene', 'pseudogene', 'ENSG00000223044'),
(5725, 47098, 'RNU6-135P', 'RNA, U6 small nuclear 135, pseudogene', 'pseudogene', 'ENSG00000252578'),
(5726, 47105, 'RNU6-142P', 'RNA, U6 small nuclear 142, pseudogene', 'pseudogene', 'ENSG00000206746'),
(5727, 47111, 'RNU6-148P', 'RNA, U6 small nuclear 148, pseudogene', 'pseudogene', 'ENSG00000252823'),
(5728, 47131, 'RNU6-168P', 'RNA, U6 small nuclear 168, pseudogene', 'pseudogene', 'ENSG00000251998'),
(5729, 47132, 'RNU6-169P', 'RNA, U6 small nuclear 169, pseudogene', 'pseudogene', 'ENSG00000202206'),
(5730, 47145, 'RNU6-182P', 'RNA, U6 small nuclear 182, pseudogene', 'pseudogene', 'ENSG00000252779'),
(5731, 47168, 'RNU6-205P', 'RNA, U6 small nuclear 205, pseudogene', 'pseudogene', 'ENSG00000212160'),
(5732, 47191, 'RNU6-228P', 'RNA, U6 small nuclear 228, pseudogene', 'pseudogene', 'ENSG00000199570'),
(5733, 47192, 'RNU6-229P', 'RNA, U6 small nuclear 229, pseudogene', 'pseudogene', 'ENSG00000252423'),
(5734, 47202, 'RNU6-239P', 'RNA, U6 small nuclear 239, pseudogene', 'pseudogene', 'ENSG00000212292'),
(5735, 47203, 'RNU6-240P', 'RNA, U6 small nuclear 240, pseudogene', 'pseudogene', 'ENSG00000251907'),
(5736, 47204, 'RNU6-241P', 'RNA, U6 small nuclear 241, pseudogene', 'pseudogene', 'ENSG00000212450'),
(5737, 47206, 'RNU6-243P', 'RNA, U6 small nuclear 243, pseudogene', 'pseudogene', 'ENSG00000212442'),
(5738, 47207, 'RNU6-244P', 'RNA, U6 small nuclear 244, pseudogene', 'pseudogene', 'ENSG00000212330'),
(5739, 47209, 'RNU6-246P', 'RNA, U6 small nuclear 246, pseudogene', 'pseudogene', 'ENSG00000207433'),
(5740, 47210, 'RNU6-247P', 'RNA, U6 small nuclear 247, pseudogene', 'pseudogene', 'ENSG00000199506'),
(5741, 47211, 'RNU6-248P', 'RNA, U6 small nuclear 248, pseudogene', 'pseudogene', 'ENSG00000222652'),
(5742, 47216, 'RNU6-253P', 'RNA, U6 small nuclear 253, pseudogene', 'pseudogene', 'ENSG00000207461'),
(5743, 47225, 'RNU6-262P', 'RNA, U6 small nuclear 262, pseudogene', 'pseudogene', 'ENSG00000222249'),
(5744, 47229, 'RNU6-266P', 'RNA, U6 small nuclear 266, pseudogene', 'pseudogene', 'ENSG00000201095'),
(5745, 47230, 'RNU6-267P', 'RNA, U6 small nuclear 267, pseudogene', 'pseudogene', 'ENSG00000252523'),
(5746, 47232, 'RNU6-269P', 'RNA, U6 small nuclear 269, pseudogene', 'pseudogene', 'ENSG00000212379'),
(5747, 47233, 'RNU6-270P', 'RNA, U6 small nuclear 270, pseudogene', 'pseudogene', 'ENSG00000201001'),
(5748, 47236, 'RNU6-273P', 'RNA, U6 small nuclear 273, pseudogene', 'pseudogene', 'ENSG00000252746'),
(5749, 47238, 'RNU6-275P', 'RNA, U6 small nuclear 275, pseudogene', 'pseudogene', 'ENSG00000201780'),
(5750, 47248, 'RNU6-285P', 'RNA, U6 small nuclear 285, pseudogene', 'pseudogene', 'ENSG00000222488'),
(5751, 47263, 'RNU6-300P', 'RNA, U6 small nuclear 300, pseudogene', 'pseudogene', 'ENSG00000238616'),
(5752, 47265, 'RNU6-302P', 'RNA, U6 small nuclear 302, pseudogene', 'pseudogene', 'ENSG00000202119'),
(5753, 47271, 'RNU6-308P', 'RNA, U6 small nuclear 308, pseudogene', 'pseudogene', 'ENSG00000212259'),
(5754, 47279, 'RNU6-316P', 'RNA, U6 small nuclear 316, pseudogene', 'pseudogene', 'ENSG00000212329'),
(5755, 47281, 'RNU6-318P', 'RNA, U6 small nuclear 318, pseudogene', 'pseudogene', 'ENSG00000207010'),
(5756, 47282, 'RNU6-319P', 'RNA, U6 small nuclear 319, pseudogene', 'pseudogene', 'ENSG00000251834'),
(5757, 47290, 'RNU6-327P', 'RNA, U6 small nuclear 327, pseudogene', 'pseudogene', 'ENSG00000252079'),
(5758, 47297, 'RNU6-334P', 'RNA, U6 small nuclear 334, pseudogene', 'pseudogene', 'ENSG00000252881'),
(5759, 47299, 'RNU6-336P', 'RNA, U6 small nuclear 336, pseudogene', 'pseudogene', 'ENSG00000201761'),
(5760, 47307, 'RNU6-344P', 'RNA, U6 small nuclear 344, pseudogene', 'pseudogene', 'ENSG00000252444'),
(5761, 47311, 'RNU6-348P', 'RNA, U6 small nuclear 348, pseudogene', 'pseudogene', 'ENSG00000207114'),
(5762, 47318, 'RNU6-355P', 'RNA, U6 small nuclear 355, pseudogene', 'pseudogene', 'ENSG00000222359'),
(5763, 47319, 'RNU6-356P', 'RNA, U6 small nuclear 356, pseudogene', 'pseudogene', 'ENSG00000206867'),
(5764, 47324, 'RNU6-361P', 'RNA, U6 small nuclear 361, pseudogene', 'pseudogene', 'ENSG00000201324'),
(5765, 47328, 'RNU6-365P', 'RNA, U6 small nuclear 365, pseudogene', 'pseudogene', 'ENSG00000252922'),
(5766, 47332, 'RNU6-369P', 'RNA, U6 small nuclear 369, pseudogene', 'pseudogene', 'ENSG00000199385'),
(5767, 47337, 'RNU6-374P', 'RNA, U6 small nuclear 374, pseudogene', 'pseudogene', 'ENSG00000201016'),
(5768, 47342, 'RNU6-379P', 'RNA, U6 small nuclear 379, pseudogene', 'pseudogene', 'ENSG00000200683'),
(5769, 47346, 'RNU6-383P', 'RNA, U6 small nuclear 383, pseudogene', 'pseudogene', 'ENSG00000222796'),
(5770, 47352, 'RNU6-389P', 'RNA, U6 small nuclear 389, pseudogene', 'pseudogene', 'ENSG00000252857'),
(5771, 47354, 'RNU6-391P', 'RNA, U6 small nuclear 391, pseudogene', 'pseudogene', 'ENSG00000202050'),
(5772, 47355, 'RNU6-392P', 'RNA, U6 small nuclear 392, pseudogene', 'pseudogene', 'ENSG00000201796'),
(5773, 47357, 'RNU6-394P', 'RNA, U6 small nuclear 394, pseudogene', 'pseudogene', 'ENSG00000222667'),
(5774, 47372, 'RNU6-409P', 'RNA, U6 small nuclear 409, pseudogene', 'pseudogene', 'ENSG00000206841'),
(5775, 47375, 'RNU6-412P', 'RNA, U6 small nuclear 412, pseudogene', 'pseudogene', 'ENSG00000252243'),
(5776, 47379, 'RNU6-416P', 'RNA, U6 small nuclear 416, pseudogene', 'pseudogene', 'ENSG00000252074'),
(5777, 47382, 'RNU6-419P', 'RNA, U6 small nuclear 419, pseudogene', 'pseudogene', 'ENSG00000252839'),
(5778, 47387, 'RNU6-424P', 'RNA, U6 small nuclear 424, pseudogene', 'pseudogene', 'ENSG00000207095'),
(5779, 47388, 'RNU6-425P', 'RNA, U6 small nuclear 425, pseudogene', 'pseudogene', 'ENSG00000206604'),
(5780, 47392, 'RNU6-429P', 'RNA, U6 small nuclear 429, pseudogene', 'pseudogene', 'ENSG00000207312'),
(5781, 47395, 'RNU6-432P', 'RNA, U6 small nuclear 432, pseudogene', 'pseudogene', 'ENSG00000206923'),
(5782, 47401, 'RNU6-438P', 'RNA, U6 small nuclear 438, pseudogene', 'pseudogene', 'ENSG00000202431'),
(5783, 47403, 'RNU6-440P', 'RNA, U6 small nuclear 440, pseudogene', 'pseudogene', 'ENSG00000212184'),
(5784, 47404, 'RNU6-441P', 'RNA, U6 small nuclear 441, pseudogene', 'pseudogene', 'ENSG00000207275'),
(5785, 47412, 'RNU6-449P', 'RNA, U6 small nuclear 449, pseudogene', 'pseudogene', 'ENSG00000206641'),
(5786, 47413, 'RNU6-450P', 'RNA, U6 small nuclear 450, pseudogene', 'pseudogene', 'ENSG00000201524'),
(5787, 47421, 'RNU6-458P', 'RNA, U6 small nuclear 458, pseudogene', 'pseudogene', 'ENSG00000206906'),
(5788, 47424, 'RNU6-461P', 'RNA, U6 small nuclear 461, pseudogene', 'pseudogene', 'ENSG00000201065'),
(5789, 47428, 'RNU6-465P', 'RNA, U6 small nuclear 465, pseudogene', 'pseudogene', 'ENSG00000207149'),
(5790, 47440, 'RNU6-477P', 'RNA, U6 small nuclear 477, pseudogene', 'pseudogene', 'ENSG00000206614'),
(5791, 47448, 'RNU6-485P', 'RNA, U6 small nuclear 485, pseudogene', 'pseudogene', 'ENSG00000200345'),
(5792, 47454, 'RNU6-491P', 'RNA, U6 small nuclear 491, pseudogene', 'pseudogene', 'ENSG00000251908'),
(5793, 47459, 'RNU6-496P', 'RNA, U6 small nuclear 496, pseudogene', 'pseudogene', 'ENSG00000251954'),
(5794, 47460, 'RNU6-497P', 'RNA, U6 small nuclear 497, pseudogene', 'pseudogene', 'ENSG00000202186'),
(5795, 47467, 'RNU6-504P', 'RNA, U6 small nuclear 504, pseudogene', 'pseudogene', 'ENSG00000252377'),
(5796, 47472, 'RNU6-509P', 'RNA, U6 small nuclear 509, pseudogene', 'pseudogene', 'ENSG00000200389'),
(5797, 47487, 'RNU6-524P', 'RNA, U6 small nuclear 524, pseudogene', 'pseudogene', 'ENSG00000206997'),
(5798, 47496, 'RNU6-533P', 'RNA, U6 small nuclear 533, pseudogene', 'pseudogene', 'ENSG00000206871'),
(5799, 47498, 'RNU6-535P', 'RNA, U6 small nuclear 535, pseudogene', 'pseudogene', 'ENSG00000207453'),
(5800, 47517, 'RNU6-554P', 'RNA, U6 small nuclear 554, pseudogene', 'pseudogene', 'ENSG00000222398'),
(5801, 47518, 'RNU6-555P', 'RNA, U6 small nuclear 555, pseudogene', 'pseudogene', 'ENSG00000207515'),
(5802, 47527, 'RNU6-564P', 'RNA, U6 small nuclear 564, pseudogene', 'pseudogene', 'ENSG00000222915'),
(5803, 47530, 'RNU6-567P', 'RNA, U6 small nuclear 567, pseudogene', 'pseudogene', 'ENSG00000252555'),
(5804, 47541, 'RNU6-578P', 'RNA, U6 small nuclear 578, pseudogene', 'pseudogene', 'ENSG00000212282'),
(5805, 47545, 'RNU6-582P', 'RNA, U6 small nuclear 582, pseudogene', 'pseudogene', 'ENSG00000199859'),
(5806, 47546, 'RNU6-583P', 'RNA, U6 small nuclear 583, pseudogene', 'pseudogene', 'ENSG00000251821'),
(5807, 47556, 'RNU6-593P', 'RNA, U6 small nuclear 593, pseudogene', 'pseudogene', 'ENSG00000201586'),
(5808, 47558, 'RNU6-595P', 'RNA, U6 small nuclear 595, pseudogene', 'pseudogene', 'ENSG00000200814'),
(5809, 47567, 'RNU6-604P', 'RNA, U6 small nuclear 604, pseudogene', 'pseudogene', 'ENSG00000212219'),
(5810, 47570, 'RNU6-607P', 'RNA, U6 small nuclear 607, pseudogene', 'pseudogene', 'ENSG00000223215'),
(5811, 47571, 'RNU6-608P', 'RNA, U6 small nuclear 608, pseudogene', 'pseudogene', 'ENSG00000206654'),
(5812, 47586, 'RNU6-623P', 'RNA, U6 small nuclear 623, pseudogene', 'pseudogene', 'ENSG00000200013'),
(5813, 47587, 'RNU6-624P', 'RNA, U6 small nuclear 624, pseudogene', 'pseudogene', 'ENSG00000200281'),
(5814, 47593, 'RNU6-630P', 'RNA, U6 small nuclear 630, pseudogene', 'pseudogene', 'ENSG00000212560'),
(5815, 47597, 'RNU6-634P', 'RNA, U6 small nuclear 634, pseudogene', 'pseudogene', 'ENSG00000239189'),
(5816, 47598, 'RNU6-635P', 'RNA, U6 small nuclear 635, pseudogene', 'pseudogene', 'ENSG00000252460'),
(5817, 47600, 'RNU6-637P', 'RNA, U6 small nuclear 637, pseudogene', 'pseudogene', 'ENSG00000206777'),
(5818, 47601, 'RNU6-638P', 'RNA, U6 small nuclear 638, pseudogene', 'pseudogene', 'ENSG00000252391'),
(5819, 47606, 'RNU6-643P', 'RNA, U6 small nuclear 643, pseudogene', 'pseudogene', 'ENSG00000206745'),
(5820, 47615, 'RNU6-652P', 'RNA, U6 small nuclear 652, pseudogene', 'pseudogene', 'ENSG00000202358'),
(5821, 47621, 'RNU6-658P', 'RNA, U6 small nuclear 658, pseudogene', 'pseudogene', 'ENSG00000207336'),
(5822, 47633, 'RNU6-670P', 'RNA, U6 small nuclear 670, pseudogene', 'pseudogene', 'ENSG00000201182'),
(5823, 47635, 'RNU6-672P', 'RNA, U6 small nuclear 672, pseudogene', 'pseudogene', 'ENSG00000206638'),
(5824, 47644, 'RNU6-681P', 'RNA, U6 small nuclear 681, pseudogene', 'pseudogene', 'ENSG00000200882'),
(5825, 47652, 'RNU6-689P', 'RNA, U6 small nuclear 689, pseudogene', 'pseudogene', 'ENSG00000206924'),
(5826, 47655, 'RNU6-692P', 'RNA, U6 small nuclear 692, pseudogene', 'pseudogene', 'ENSG00000207225'),
(5827, 47658, 'RNU6-695P', 'RNA, U6 small nuclear 695, pseudogene', 'pseudogene', 'ENSG00000212459'),
(5828, 47660, 'RNU6-697P', 'RNA, U6 small nuclear 697, pseudogene', 'pseudogene', 'ENSG00000200218'),
(5829, 47667, 'RNU6-704P', 'RNA, U6 small nuclear 704, pseudogene', 'pseudogene', 'ENSG00000201032'),
(5830, 47673, 'RNU6-710P', 'RNA, U6 small nuclear 710, pseudogene', 'pseudogene', 'ENSG00000222356'),
(5831, 47679, 'RNU6-716P', 'RNA, U6 small nuclear 716, pseudogene', 'pseudogene', 'ENSG00000202491'),
(5832, 47681, 'RNU6-718P', 'RNA, U6 small nuclear 718, pseudogene', 'pseudogene', 'ENSG00000251975'),
(5833, 47682, 'RNU6-719P', 'RNA, U6 small nuclear 719, pseudogene', 'pseudogene', 'ENSG00000252480'),
(5834, 47686, 'RNU6-723P', 'RNA, U6 small nuclear 723, pseudogene', 'pseudogene', 'ENSG00000206700'),
(5835, 47696, 'RNU6-733P', 'RNA, U6 small nuclear 733, pseudogene', 'pseudogene', 'ENSG00000222691'),
(5836, 47700, 'RNU6-737P', 'RNA, U6 small nuclear 737, pseudogene', 'pseudogene', 'ENSG00000202240'),
(5837, 47705, 'RNU6-742P', 'RNA, U6 small nuclear 742, pseudogene', 'pseudogene', 'ENSG00000202159'),
(5838, 47710, 'RNU6-747P', 'RNA, U6 small nuclear 747, pseudogene', 'pseudogene', 'ENSG00000212230'),
(5839, 47712, 'RNU6-749P', 'RNA, U6 small nuclear 749, pseudogene', 'pseudogene', 'ENSG00000238489'),
(5840, 47717, 'RNU6-754P', 'RNA, U6 small nuclear 754, pseudogene', 'pseudogene', 'ENSG00000212468'),
(5841, 47721, 'RNU6-758P', 'RNA, U6 small nuclear 758, pseudogene', 'pseudogene', 'ENSG00000252101'),
(5842, 47725, 'RNU6-762P', 'RNA, U6 small nuclear 762, pseudogene', 'pseudogene', 'ENSG00000252916'),
(5843, 47726, 'RNU6-763P', 'RNA, U6 small nuclear 763, pseudogene', 'pseudogene', 'ENSG00000212167'),
(5844, 47727, 'RNU6-764P', 'RNA, U6 small nuclear 764, pseudogene', 'pseudogene', 'ENSG00000252205'),
(5845, 47740, 'RNU6-777P', 'RNA, U6 small nuclear 777, pseudogene', 'pseudogene', 'ENSG00000201135'),
(5846, 47753, 'RNU6-790P', 'RNA, U6 small nuclear 790, pseudogene', 'pseudogene', 'ENSG00000207208'),
(5847, 47759, 'RNU6-796P', 'RNA, U6 small nuclear 796, pseudogene', 'pseudogene', 'ENSG00000212388'),
(5848, 47775, 'RNU6-812P', 'RNA, U6 small nuclear 812, pseudogene', 'pseudogene', 'ENSG00000200048'),
(5849, 47779, 'RNU6-816P', 'RNA, U6 small nuclear 816, pseudogene', 'pseudogene', 'ENSG00000212216'),
(5850, 47783, 'RNU6-820P', 'RNA, U6 small nuclear 820, pseudogene', 'pseudogene', 'ENSG00000207000'),
(5851, 47789, 'RNU6-826P', 'RNA, U6 small nuclear 826, pseudogene', 'pseudogene', 'ENSG00000252636'),
(5852, 47799, 'RNU6-836P', 'RNA, U6 small nuclear 836, pseudogene', 'pseudogene', 'ENSG00000199790'),
(5853, 47802, 'RNU6-839P', 'RNA, U6 small nuclear 839, pseudogene', 'pseudogene', 'ENSG00000200217'),
(5854, 47825, 'RNU6-862P', 'RNA, U6 small nuclear 862, pseudogene', 'pseudogene', 'ENSG00000199674'),
(5855, 47826, 'RNU6-863P', 'RNA, U6 small nuclear 863, pseudogene', 'pseudogene', 'ENSG00000251798'),
(5856, 47832, 'RNU6-869P', 'RNA, U6 small nuclear 869, pseudogene', 'pseudogene', 'ENSG00000207138'),
(5857, 47840, 'RNU6-877P', 'RNA, U6 small nuclear 877, pseudogene', 'pseudogene', 'ENSG00000206595'),
(5858, 47848, 'RNU6-885P', 'RNA, U6 small nuclear 885, pseudogene', 'pseudogene', 'ENSG00000252416'),
(5859, 47851, 'RNU6-888P', 'RNA, U6 small nuclear 888, pseudogene', 'pseudogene', 'ENSG00000199880'),
(5860, 47853, 'RNU6-890P', 'RNA, U6 small nuclear 890, pseudogene', 'pseudogene', 'ENSG00000206848'),
(5861, 47855, 'RNU6-892P', 'RNA, U6 small nuclear 892, pseudogene', 'pseudogene', 'ENSG00000222267'),
(5862, 47858, 'RNU6-895P', 'RNA, U6 small nuclear 895, pseudogene', 'pseudogene', 'ENSG00000206852'),
(5863, 47872, 'RNU6-909P', 'RNA, U6 small nuclear 909, pseudogene', 'pseudogene', 'ENSG00000252867'),
(5864, 47878, 'RNU6-915P', 'RNA, U6 small nuclear 915, pseudogene', 'pseudogene', 'ENSG00000201813'),
(5865, 47880, 'RNU6-917P', 'RNA, U6 small nuclear 917, pseudogene', 'pseudogene', 'ENSG00000252103'),
(5866, 47885, 'RNU6-922P', 'RNA, U6 small nuclear 922, pseudogene', 'pseudogene', 'ENSG00000252562'),
(5867, 47901, 'RNU6-938P', 'RNA, U6 small nuclear 938, pseudogene', 'pseudogene', 'ENSG00000223217'),
(5868, 47903, 'RNU6-940P', 'RNA, U6 small nuclear 940, pseudogene', 'pseudogene', 'ENSG00000200303'),
(5869, 47904, 'RNU6-941P', 'RNA, U6 small nuclear 941, pseudogene', 'pseudogene', 'ENSG00000252155'),
(5870, 47910, 'RNU6-947P', 'RNA, U6 small nuclear 947, pseudogene', 'pseudogene', 'ENSG00000252073'),
(5871, 47911, 'RNU6-948P', 'RNA, U6 small nuclear 948, pseudogene', 'pseudogene', 'ENSG00000252183'),
(5872, 47914, 'RNU6-951P', 'RNA, U6 small nuclear 951, pseudogene', 'pseudogene', 'ENSG00000199603'),
(5873, 47916, 'RNU6-953P', 'RNA, U6 small nuclear 953, pseudogene', 'pseudogene', 'ENSG00000238941'),
(5874, 47923, 'RNU6-960P', 'RNA, U6 small nuclear 960, pseudogene', 'pseudogene', 'ENSG00000200926'),
(5875, 47931, 'RNU6-968P', 'RNA, U6 small nuclear 968, pseudogene', 'pseudogene', 'ENSG00000206803'),
(5876, 47933, 'RNU6-970P', 'RNA, U6 small nuclear 970, pseudogene', 'pseudogene', 'ENSG00000252121'),
(5877, 47935, 'RNU6-972P', 'RNA, U6 small nuclear 972, pseudogene', 'pseudogene', 'ENSG00000212510'),
(5878, 47940, 'RNU6-977P', 'RNA, U6 small nuclear 977, pseudogene', 'pseudogene', 'ENSG00000252220'),
(5879, 47941, 'RNU6-978P', 'RNA, U6 small nuclear 978, pseudogene', 'pseudogene', 'ENSG00000201241'),
(5880, 47945, 'RNU6-982P', 'RNA, U6 small nuclear 982, pseudogene', 'pseudogene', 'ENSG00000252025'),
(5881, 47948, 'RNU6-985P', 'RNA, U6 small nuclear 985, pseudogene', 'pseudogene', 'ENSG00000222114'),
(5882, 47950, 'RNU6-987P', 'RNA, U6 small nuclear 987, pseudogene', 'pseudogene', 'ENSG00000207490'),
(5883, 47964, 'RNU6-1001P', 'RNA, U6 small nuclear 1001, pseudogene', 'pseudogene', 'ENSG00000223197'),
(5884, 47966, 'RNU6-1003P', 'RNA, U6 small nuclear 1003, pseudogene', 'pseudogene', 'ENSG00000252908'),
(5885, 47973, 'RNU6-1010P', 'RNA, U6 small nuclear 1010, pseudogene', 'pseudogene', 'ENSG00000199627'),
(5886, 47983, 'RNU6-1020P', 'RNA, U6 small nuclear 1020, pseudogene', 'pseudogene', 'ENSG00000200554'),
(5887, 47991, 'RNU6-1028P', 'RNA, U6 small nuclear 1028, pseudogene', 'pseudogene', 'ENSG00000252973'),
(5888, 47997, 'RNU6-1034P', 'RNA, U6 small nuclear 1034, pseudogene', 'pseudogene', 'ENSG00000202205'),
(5889, 47999, 'RNU6-1036P', 'RNA, U6 small nuclear 1036, pseudogene', 'pseudogene', 'ENSG00000206686'),
(5890, 48002, 'RNU6-1039P', 'RNA, U6 small nuclear 1039, pseudogene', 'pseudogene', 'ENSG00000206658'),
(5891, 48005, 'RNU6-1042P', 'RNA, U6 small nuclear 1042, pseudogene', 'pseudogene', 'ENSG00000206931'),
(5892, 48009, 'RNU6-1046P', 'RNA, U6 small nuclear 1046, pseudogene', 'pseudogene', 'ENSG00000252347'),
(5893, 48010, 'RNU6-1047P', 'RNA, U6 small nuclear 1047, pseudogene', 'pseudogene', 'ENSG00000201288'),
(5894, 48011, 'RNU6-1048P', 'RNA, U6 small nuclear 1048, pseudogene', 'pseudogene', 'ENSG00000200924'),
(5895, 48016, 'RNU6-1053P', 'RNA, U6 small nuclear 1053, pseudogene', 'pseudogene', 'ENSG00000251739'),
(5896, 48024, 'RNU6-1061P', 'RNA, U6 small nuclear 1061, pseudogene', 'pseudogene', 'ENSG00000252339'),
(5897, 48028, 'RNU6-1065P', 'RNA, U6 small nuclear 1065, pseudogene', 'pseudogene', 'ENSG00000207242'),
(5898, 48038, 'RNU6-1075P', 'RNA, U6 small nuclear 1075, pseudogene', 'pseudogene', 'ENSG00000201260'),
(5899, 48039, 'RNU6-1076P', 'RNA, U6 small nuclear 1076, pseudogene', 'pseudogene', 'ENSG00000222329'),
(5900, 48045, 'RNU6-1082P', 'RNA, U6 small nuclear 1082, pseudogene', 'pseudogene', 'ENSG00000201444'),
(5901, 48046, 'RNU6-1083P', 'RNA, U6 small nuclear 1083, pseudogene', 'pseudogene', 'ENSG00000206749'),
(5902, 48048, 'RNU6-1085P', 'RNA, U6 small nuclear 1085, pseudogene', 'pseudogene', 'ENSG00000200446'),
(5903, 48051, 'RNU6-1088P', 'RNA, U6 small nuclear 1088, pseudogene', 'pseudogene', 'ENSG00000252659'),
(5904, 48053, 'RNU6-1090P', 'RNA, U6 small nuclear 1090, pseudogene', 'pseudogene', 'ENSG00000200935'),
(5905, 48059, 'RNU6-1096P', 'RNA, U6 small nuclear 1096, pseudogene', 'pseudogene', 'ENSG00000252898'),
(5906, 48082, 'RNU6-1119P', 'RNA, U6 small nuclear 1119, pseudogene', 'pseudogene', 'ENSG00000207077'),
(5907, 48094, 'RNU6-1131P', 'RNA, U6 small nuclear 1131, pseudogene', 'pseudogene', 'ENSG00000201825'),
(5908, 48104, 'RNU6-1141P', 'RNA, U6 small nuclear 1141, pseudogene', 'pseudogene', 'ENSG00000201390'),
(5909, 48107, 'RNU6-1144P', 'RNA, U6 small nuclear 1144, pseudogene', 'pseudogene', 'ENSG00000206974'),
(5910, 48126, 'RNU6-1163P', 'RNA, U6 small nuclear 1163, pseudogene', 'pseudogene', 'ENSG00000201386'),
(5911, 48127, 'RNU6-1164P', 'RNA, U6 small nuclear 1164, pseudogene', 'pseudogene', 'ENSG00000201298'),
(5912, 48130, 'RNU6-1167P', 'RNA, U6 small nuclear 1167, pseudogene', 'pseudogene', 'ENSG00000200097'),
(5913, 48132, 'RNU6-1169P', 'RNA, U6 small nuclear 1169, pseudogene', 'pseudogene', 'ENSG00000200407'),
(5914, 48133, 'RNU6-1170P', 'RNA, U6 small nuclear 1170, pseudogene', 'pseudogene', 'ENSG00000251783'),
(5915, 48135, 'RNU6-1172P', 'RNA, U6 small nuclear 1172, pseudogene', 'pseudogene', 'ENSG00000202095'),
(5916, 48138, 'RNU6-1175P', 'RNA, U6 small nuclear 1175, pseudogene', 'pseudogene', 'ENSG00000202070'),
(5917, 48140, 'RNU6-1177P', 'RNA, U6 small nuclear 1177, pseudogene', 'pseudogene', 'ENSG00000212360'),
(5918, 48141, 'RNU6-1178P', 'RNA, U6 small nuclear 1178, pseudogene', 'pseudogene', 'ENSG00000252483'),
(5919, 48146, 'RNU6-1183P', 'RNA, U6 small nuclear 1183, pseudogene', 'pseudogene', 'ENSG00000252863'),
(5920, 48151, 'RNU6-1188P', 'RNA, U6 small nuclear 1188, pseudogene', 'pseudogene', 'ENSG00000200665'),
(5921, 48170, 'RNU6-1207P', 'RNA, U6 small nuclear 1207, pseudogene', 'pseudogene', 'ENSG00000207071'),
(5922, 48174, 'RNU6-1211P', 'RNA, U6 small nuclear 1211, pseudogene', 'pseudogene', 'ENSG00000238382'),
(5923, 48175, 'RNU6-1212P', 'RNA, U6 small nuclear 1212, pseudogene', 'pseudogene', 'ENSG00000252832'),
(5924, 48178, 'RNU6-1215P', 'RNA, U6 small nuclear 1215, pseudogene', 'pseudogene', 'ENSG00000207170'),
(5925, 48182, 'RNU6-1219P', 'RNA, U6 small nuclear 1219, pseudogene', 'pseudogene', 'ENSG00000251952'),
(5926, 48187, 'RNU6-1224P', 'RNA, U6 small nuclear 1224, pseudogene', 'pseudogene', 'ENSG00000252593'),
(5927, 48192, 'RNU6-1229P', 'RNA, U6 small nuclear 1229, pseudogene', 'pseudogene', 'ENSG00000201165'),
(5928, 48194, 'RNU6-1231P', 'RNA, U6 small nuclear 1231, pseudogene', 'pseudogene', 'ENSG00000252994'),
(5929, 48196, 'RNU6-1233P', 'RNA, U6 small nuclear 1233, pseudogene', 'pseudogene', 'ENSG00000199792'),
(5930, 48206, 'RNU6-1243P', 'RNA, U6 small nuclear 1243, pseudogene', 'pseudogene', 'ENSG00000200898'),
(5931, 48209, 'RNU6-1246P', 'RNA, U6 small nuclear 1246, pseudogene', 'pseudogene', 'ENSG00000212366'),
(5932, 48212, 'RNU6-1249P', 'RNA, U6 small nuclear 1249, pseudogene', 'pseudogene', 'ENSG00000200107'),
(5933, 48217, 'RNU6-1254P', 'RNA, U6 small nuclear 1254, pseudogene', 'pseudogene', 'ENSG00000212568'),
(5934, 48225, 'RNU6-1262P', 'RNA, U6 small nuclear 1262, pseudogene', 'pseudogene', 'ENSG00000252026'),
(5935, 48226, 'RNU6-1263P', 'RNA, U6 small nuclear 1263, pseudogene', 'pseudogene', 'ENSG00000207331'),
(5936, 48231, 'RNU6-1268P', 'RNA, U6 small nuclear 1268, pseudogene', 'pseudogene', 'ENSG00000212516'),
(5937, 48233, 'RNU6-1270P', 'RNA, U6 small nuclear 1270, pseudogene', 'pseudogene', 'ENSG00000252937'),
(5938, 48236, 'RNU6-1273P', 'RNA, U6 small nuclear 1273, pseudogene', 'pseudogene', 'ENSG00000199903'),
(5939, 48239, 'RNU6-1276P', 'RNA, U6 small nuclear 1276, pseudogene', 'pseudogene', 'ENSG00000202242'),
(5940, 48242, 'RNU6-1279P', 'RNA, U6 small nuclear 1279, pseudogene', 'pseudogene', 'ENSG00000206644'),
(5941, 48247, 'RNU6-1284P', 'RNA, U6 small nuclear 1284, pseudogene', 'pseudogene', 'ENSG00000200571'),
(5942, 48250, 'RNU6-1287P', 'RNA, U6 small nuclear 1287, pseudogene', 'pseudogene', 'ENSG00000199784'),
(5943, 48256, 'RNU6-1293P', 'RNA, U6 small nuclear 1293, pseudogene', 'pseudogene', 'ENSG00000206804'),
(5944, 48260, 'RNU6-1297P', 'RNA, U6 small nuclear 1297, pseudogene', 'pseudogene', 'ENSG00000207144'),
(5945, 48263, 'RNU6-1300P', 'RNA, U6 small nuclear 1300, pseudogene', 'pseudogene', 'ENSG00000212348'),
(5946, 48269, 'RNU6-1306P', 'RNA, U6 small nuclear 1306, pseudogene', 'pseudogene', 'ENSG00000202089'),
(5947, 48279, 'RNU6-1316P', 'RNA, U6 small nuclear 1316, pseudogene', 'pseudogene', 'ENSG00000206969'),
(5948, 48280, 'RNU6-1317P', 'RNA, U6 small nuclear 1317, pseudogene', 'pseudogene', 'ENSG00000201452'),
(5949, 48284, 'RNU6-1321P', 'RNA, U6 small nuclear 1321, pseudogene', 'pseudogene', 'ENSG00000212207'),
(5950, 48288, 'RNU6-1325P', 'RNA, U6 small nuclear 1325, pseudogene', 'pseudogene', 'ENSG00000201775'),
(5951, 48295, 'RNU6-1332P', 'RNA, U6 small nuclear 1332, pseudogene', 'pseudogene', 'ENSG00000252475'),
(5952, 34017, 'RNU6ATAC', 'RNA, U6atac small nuclear (U12-dependent splicing)', 'non-coding RNA', 'ENSG00000221676'),
(5953, 34094, 'RNU6ATAC4P', 'RNA, U6atac small nuclear 4, pseudogene', 'pseudogene', 'ENSG00000210181'),
(5954, 46910, 'RNU6ATAC11P', 'RNA, U6atac small nuclear 11, pseudogene', 'pseudogene', 'ENSG00000221468'),
(5955, 46923, 'RNU6ATAC24P', 'RNA, U6atac small nuclear 24, pseudogene', 'pseudogene', 'ENSG00000252620'),
(5956, 46930, 'RNU6ATAC31P', 'RNA, U6atac small nuclear 31, pseudogene', 'pseudogene', 'ENSG00000221440'),
(5957, 46935, 'RNU6ATAC36P', 'RNA, U6atac small nuclear 36, pseudogene', 'pseudogene', 'ENSG00000252684'),
(5958, 10230, 'RNU6V', 'RNA, U6 small nuclear variant sequence with SNRPE pseudogene sequence', 'pseudogene', 'ENSG00000206832'),
(5959, 34099, 'RNU7-3P', 'RNA, U7 small nuclear 3 pseudogene', 'pseudogene', 'ENSG00000252244'),
(5960, 34114, 'RNU7-18P', 'RNA, U7 small nuclear 18 pseudogene', 'pseudogene', 'ENSG00000252174'),
(5961, 34115, 'RNU7-19P', 'RNA, U7 small nuclear 19 pseudogene', 'pseudogene', 'ENSG00000238959'),
(5962, 34117, 'RNU7-21P', 'RNA, U7 small nuclear 21 pseudogene', 'pseudogene', 'ENSG00000238558'),
(5963, 34143, 'RNU7-47P', 'RNA, U7 small nuclear 47 pseudogene', 'pseudogene', 'ENSG00000251787'),
(5964, 34147, 'RNU7-51P', 'RNA, U7 small nuclear 51 pseudogene', 'pseudogene', 'ENSG00000252369'),
(5965, 34150, 'RNU7-54P', 'RNA, U7 small nuclear 54 pseudogene', 'pseudogene', 'ENSG00000238590'),
(5966, 34152, 'RNU7-56P', 'RNA, U7 small nuclear 56 pseudogene', 'pseudogene', 'ENSG00000238709'),
(5967, 34153, 'RNU7-57P', 'RNA, U7 small nuclear 57 pseudogene', 'pseudogene', 'ENSG00000238365'),
(5968, 34156, 'RNU7-60P', 'RNA, U7 small nuclear 60 pseudogene', 'pseudogene', 'ENSG00000251747'),
(5969, 34169, 'RNU7-73P', 'RNA, U7 small nuclear 73 pseudogene', 'pseudogene', 'ENSG00000239105'),
(5970, 34176, 'RNU7-80P', 'RNA, U7 small nuclear 80 pseudogene', 'pseudogene', 'ENSG00000238778'),
(5971, 34177, 'RNU7-81P', 'RNA, U7 small nuclear 81 pseudogene', 'pseudogene', 'ENSG00000252507'),
(5972, 45629, 'RNU7-95P', 'RNA, U7 small nuclear 95 pseudogene', 'pseudogene', 'ENSG00000239007'),
(5973, 45630, 'RNU7-96P', 'RNA, U7 small nuclear 96 pseudogene', 'pseudogene', 'ENSG00000238719'),
(5974, 45644, 'RNU7-110P', 'RNA, U7 small nuclear 110 pseudogene', 'pseudogene', 'ENSG00000252700'),
(5975, 45671, 'RNU7-137P', 'RNA, U7 small nuclear 137 pseudogene', 'pseudogene', 'ENSG00000252597'),
(5976, 45681, 'RNU7-147P', 'RNA, U7 small nuclear 147 pseudogene', 'pseudogene', 'ENSG00000238698'),
(5977, 45682, 'RNU7-148P', 'RNA, U7 small nuclear 148 pseudogene', 'pseudogene', 'ENSG00000238357'),
(5978, 45683, 'RNU7-149P', 'RNA, U7 small nuclear 149 pseudogene', 'pseudogene', 'ENSG00000252548'),
(5979, 45686, 'RNU7-152P', 'RNA, U7 small nuclear 152 pseudogene', 'pseudogene', 'ENSG00000238789'),
(5980, 45705, 'RNU7-171P', 'RNA, U7 small nuclear 171 pseudogene', 'pseudogene', 'ENSG00000238406'),
(5981, 45719, 'RNU7-185P', 'RNA, U7 small nuclear 185 pseudogene', 'pseudogene', 'ENSG00000239102'),
(5982, 45726, 'RNU7-192P', 'RNA, U7 small nuclear 192 pseudogene', 'pseudogene', 'ENSG00000252275'),
(5983, 45728, 'RNU7-194P', 'RNA, U7 small nuclear 194 pseudogene', 'pseudogene', 'ENSG00000238721'),
(5984, 45729, 'RNU7-195P', 'RNA, U7 small nuclear 195 pseudogene', 'pseudogene', 'ENSG00000239151'),
(5985, 45734, 'RNU7-200P', 'RNA, U7 small nuclear 200 pseudogene', 'pseudogene', 'ENSG00000251914'),
(5986, 46944, 'RNU11-4P', 'RNA, U11 small nuclear 4, pseudogene', 'pseudogene', 'ENSG00000212451'),
(5987, 46945, 'RNU11-5P', 'RNA, U11 small nuclear 5, pseudogene', 'pseudogene', 'ENSG00000212518'),
(5988, 10109, 'RNU12-2P', 'RNA, U12 small nuclear 2, pseudogene', 'pseudogene', 'ENSG00000201659'),
(5989, 10104, 'RNU105C', 'RNA, U105C small nucleolar', 'non-coding RNA', 'ENSG00000199212'),
(5990, 48320, 'RNVU1-15', 'RNA, variant U1 small nuclear 15', 'non-coding RNA', 'ENSG00000207205'),
(5991, 37496, 'RNVU1-18', 'RNA, variant U1 small nuclear 18', 'non-coding RNA', 'ENSG00000206737'),
(5992, 54433, 'RNVU1-29', 'RNA, variant U1 small nuclear 29', 'non-coding RNA', 'ENSG00000273768'),
(5993, 42481, 'RNY1P4', 'RNY1 pseudogene 4', 'pseudogene', 'ENSG00000207325'),
(5994, 42483, 'RNY1P6', 'RNY1 pseudogene 6', 'pseudogene', 'ENSG00000206920'),
(5995, 50875, 'RNY1P12', 'RNY1 pseudogene 12', 'pseudogene', 'ENSG00000201121'),
(5996, 50876, 'RNY1P13', 'RNY1 pseudogene 13', 'pseudogene', 'ENSG00000201900'),
(5997, 10243, 'RNY3', 'RNA, Ro60-associated Y3', 'non-coding RNA', 'ENSG00000202354'),
(5998, 42488, 'RNY3P4', 'RNY3 pseudogene 4', 'pseudogene', 'ENSG00000207157'),
(5999, 42492, 'RNY3P8', 'RNY3 pseudogene 8', 'pseudogene', 'ENSG00000223298'),
(6000, 50891, 'RNY3P16', 'RNY3 pseudogene 16', 'pseudogene', 'ENSG00000252147'),
(6001, 34064, 'RNY4P14', 'RNY4 pseudogene 14', 'pseudogene', 'ENSG00000200526'),
(6002, 34069, 'RNY4P19', 'RNY4 pseudogene 19', 'pseudogene', 'ENSG00000199400'),
(6003, 42473, 'RNY4P23', 'RNY4 pseudogene 23', 'pseudogene', 'ENSG00000201377'),
(6004, 42497, 'RNY4P29', 'RNY4 pseudogene 29', 'pseudogene', 'ENSG00000222733'),
(6005, 42498, 'RNY4P30', 'RNY4 pseudogene 30', 'pseudogene', 'ENSG00000222148'),
(6006, 50882, 'RNY4P34', 'RNY4 pseudogene 34', 'pseudogene', 'ENSG00000201649'),
(6007, 50884, 'RNY4P36', 'RNY4 pseudogene 36', 'pseudogene', 'ENSG00000212418'),
(6008, 50885, 'RNY4P37', 'RNY4 pseudogene 37', 'pseudogene', 'ENSG00000252034'),
(6009, 10250, 'ROBO2', 'roundabout guidance receptor 2', 'protein-coding gene', 'ENSG00000185008'),
(6010, 37832, 'ROCK1P1', 'Rho associated coiled-coil containing protein kinase 1 pseudogene 1', 'pseudogene', 'ENSG00000263006'),
(6011, 29478, 'ROGDI', 'rogdi atypical leucine zipper', 'protein-coding gene', 'ENSG00000067836'),
(6012, 39984, 'ROPN1L-AS1', 'ROPN1L antisense RNA 1', 'non-coding RNA', 'ENSG00000250600'),
(6013, 51410, 'RORA-AS1', 'RORA antisense RNA 1', 'non-coding RNA', 'ENSG00000245534'),
(6014, 10274, 'RP2', 'RP2 activator of ARL3 GTPase', 'protein-coding gene', 'ENSG00000102218'),
(6015, 33969, 'RP9P', 'RP9 pseudogene', 'pseudogene', 'ENSG00000205763'),
(6016, 54791, 'RPA3P2', 'RPA3 pseudogene 2', 'pseudogene', 'ENSG00000218261'),
(6017, 13436, 'RPGRIP1', 'RPGR interacting protein 1', 'protein-coding gene', 'ENSG00000092200'),
(6018, 29168, 'RPGRIP1L', 'RPGRIP1 like', 'protein-coding gene', 'ENSG00000103494'),
(6019, 10297, 'RPIA', 'ribose 5-phosphate isomerase A', 'protein-coding gene', 'ENSG00000153574'),
(6020, 27250, 'RPIAP1', 'ribose 5-phosphate isomerase A pseudogene 1', 'pseudogene', 'ENSG00000267597'),
(6021, 36179, 'RPL4P4', 'ribosomal protein L4 pseudogene 4', 'pseudogene', 'ENSG00000229638'),
(6022, 10361, 'RPL5P1', 'ribosomal protein L5 pseudogene 1', 'pseudogene', 'ENSG00000241061'),
(6023, 16568, 'RPL5P2', 'ribosomal protein L5 pseudogene 2', 'pseudogene', 'ENSG00000237068'),
(6024, 36557, 'RPL5P9', 'ribosomal protein L5 pseudogene 9', 'pseudogene', 'ENSG00000236330'),
(6025, 36846, 'RPL5P10', 'ribosomal protein L5 pseudogene 10', 'pseudogene', 'ENSG00000234067'),
(6026, 36221, 'RPL5P12', 'ribosomal protein L5 pseudogene 12', 'pseudogene', 'ENSG00000242697'),
(6027, 37029, 'RPL5P21', 'ribosomal protein L5 pseudogene 21', 'pseudogene', 'ENSG00000218689'),
(6028, 36553, 'RPL5P23', 'ribosomal protein L5 pseudogene 23', 'pseudogene', 'ENSG00000240395'),
(6029, 36335, 'RPL5P29', 'ribosomal protein L5 pseudogene 29', 'pseudogene', 'ENSG00000242208'),
(6030, 35837, 'RPL5P30', 'ribosomal protein L5 pseudogene 30', 'pseudogene', 'ENSG00000243431'),
(6031, 36463, 'RPL5P34', 'ribosomal protein L5 pseudogene 34', 'pseudogene', 'ENSG00000234009'),
(6032, 35964, 'RPL6P2', 'ribosomal protein L6 pseudogene 2', 'pseudogene', 'ENSG00000227056'),
(6033, 35925, 'RPL6P3', 'ribosomal protein L6 pseudogene 3', 'pseudogene', 'ENSG00000229022'),
(6034, 36199, 'RPL6P5', 'ribosomal protein L6 pseudogene 5', 'pseudogene', 'ENSG00000214064'),
(6035, 36673, 'RPL6P6', 'ribosomal protein L6 pseudogene 6', 'pseudogene', 'ENSG00000231063'),
(6036, 36575, 'RPL6P10', 'ribosomal protein L6 pseudogene 10', 'pseudogene', 'ENSG00000243199'),
(6037, 32433, 'RPL7AP10', 'ribosomal protein L7a pseudogene 10', 'pseudogene', 'ENSG00000240522'),
(6038, 16565, 'RPL7AP13', 'ribosomal protein L7a pseudogene 13', 'pseudogene', 'ENSG00000235208'),
(6039, 16590, 'RPL7AP14', 'ribosomal protein L7a pseudogene 14', 'pseudogene', 'ENSG00000213979'),
(6040, 36358, 'RPL7AP20', 'ribosomal protein L7a pseudogene 20', 'pseudogene', 'ENSG00000234981'),
(6041, 36806, 'RPL7AP27', 'ribosomal protein L7a pseudogene 27', 'pseudogene', 'ENSG00000242169'),
(6042, 36857, 'RPL7AP31', 'ribosomal protein L7a pseudogene 31', 'pseudogene', 'ENSG00000242083'),
(6043, 36415, 'RPL7AP32', 'ribosomal protein L7a pseudogene 32', 'pseudogene', 'ENSG00000243160'),
(6044, 35883, 'RPL7AP40', 'ribosomal protein L7a pseudogene 40', 'pseudogene', 'ENSG00000224475'),
(6045, 36716, 'RPL7AP42', 'ribosomal protein L7a pseudogene 42', 'pseudogene', 'ENSG00000234358'),
(6046, 35775, 'RPL7AP43', 'ribosomal protein L7a pseudogene 43', 'pseudogene', 'ENSG00000213542'),
(6047, 36645, 'RPL7AP44', 'ribosomal protein L7a pseudogene 44', 'pseudogene', 'ENSG00000231562'),
(6048, 35953, 'RPL7AP48', 'ribosomal protein L7a pseudogene 48', 'pseudogene', 'ENSG00000237088'),
(6049, 36314, 'RPL7AP55', 'ribosomal protein L7a pseudogene 55', 'pseudogene', 'ENSG00000241008'),
(6050, 36697, 'RPL7AP69', 'ribosomal protein L7a pseudogene 69', 'pseudogene', 'ENSG00000268483'),
(6051, 55900, 'RPL7AP77', 'ribosomal protein L7a pseudogene 77', 'pseudogene', 'ENSG00000225005'),
(6052, 21370, 'RPL7L1', 'ribosomal protein L7 like 1', 'protein-coding gene', 'ENSG00000146223'),
(6053, 39486, 'RPL7L1P4', 'ribosomal protein L7 like 1 pseudogene 4', 'pseudogene', 'ENSG00000249582'),
(6054, 39492, 'RPL7L1P10', 'ribosomal protein L7 like 1 pseudogene 10', 'pseudogene', 'ENSG00000237322'),
(6055, 37028, 'RPL7P9', 'ribosomal protein L7 pseudogene 9', 'pseudogene', 'ENSG00000137970'),
(6056, 35667, 'RPL7P11', 'ribosomal protein L7 pseudogene 11', 'pseudogene', 'ENSG00000234619'),
(6057, 36013, 'RPL7P20', 'ribosomal protein L7 pseudogene 20', 'pseudogene', 'ENSG00000254252'),
(6058, 35522, 'RPL7P45', 'ribosomal protein L7 pseudogene 45', 'pseudogene', 'ENSG00000225823'),
(6059, 36706, 'RPL7P46', 'ribosomal protein L7 pseudogene 46', 'pseudogene', 'ENSG00000229917'),
(6060, 36432, 'RPL7P51', 'ribosomal protein L7 pseudogene 51', 'pseudogene', 'ENSG00000243469'),
(6061, 13980, 'RPL8P1', 'ribosomal protein L8 pseudogene 1', 'pseudogene', 'ENSG00000216676'),
(6062, 17220, 'RPL8P2', 'ribosomal protein L8 pseudogene 2', 'pseudogene', 'ENSG00000225267'),
(6063, 36558, 'RPL9P13', 'ribosomal protein L9 pseudogene 13', 'pseudogene', 'ENSG00000228374'),
(6064, 36954, 'RPL9P18', 'ribosomal protein L9 pseudogene 18', 'pseudogene', 'ENSG00000213309'),
(6065, 36112, 'RPL9P25', 'ribosomal protein L9 pseudogene 25', 'pseudogene', 'ENSG00000240821'),
(6066, 19813, 'RPL10AP1', 'ribosomal protein L10a pseudogene 1', 'pseudogene', 'ENSG00000244691'),
(6067, 29803, 'RPL10AP3', 'ribosomal protein L10a pseudogene 3', 'pseudogene', 'ENSG00000215264'),
(6068, 52342, 'RPL10P4', 'ribosomal protein L10 pseudogene 4', 'pseudogene', 'ENSG00000238003'),
(6069, 52344, 'RPL10P8', 'ribosomal protein L10 pseudogene 8', 'pseudogene', 'ENSG00000254012'),
(6070, 35579, 'RPL10P9', 'ribosomal protein L10 pseudogene 9', 'pseudogene', 'ENSG00000233913'),
(6071, 36565, 'RPL10P11', 'ribosomal protein L10 pseudogene 11', 'pseudogene', 'ENSG00000230853'),
(6072, 52345, 'RPL10P12', 'ribosomal protein L10 pseudogene 12', 'pseudogene', 'ENSG00000234040'),
(6073, 52347, 'RPL10P15', 'ribosomal protein L10 pseudogene 15', 'pseudogene', 'ENSG00000267119'),
(6074, 37021, 'RPL11P1', 'ribosomal protein L11 pseudogene 1', 'pseudogene', 'ENSG00000227394'),
(6075, 16335, 'RPL12P3', 'ribosomal protein L12 pseudogene 3', 'pseudogene', 'ENSG00000233106'),
(6076, 36619, 'RPL12P15', 'ribosomal protein L12 pseudogene 15', 'pseudogene', 'ENSG00000230993'),
(6077, 35791, 'RPL12P29', 'ribosomal protein L12 pseudogene 29', 'pseudogene', 'ENSG00000233189'),
(6078, 35970, 'RPL12P30', 'ribosomal protein L12 pseudogene 30', 'pseudogene', 'ENSG00000242353'),
(6079, 35696, 'RPL12P33', 'ribosomal protein L12 pseudogene 33', 'pseudogene', 'ENSG00000244585'),
(6080, 36165, 'RPL12P42', 'ribosomal protein L12 pseudogene 42', 'pseudogene', 'ENSG00000213253'),
(6081, 51940, 'RPL12P48', 'ribosomal protein L12 pseudogene 48', 'pseudogene', 'ENSG00000270865'),
(6082, 10304, 'RPL13A', 'ribosomal protein L13a', 'protein-coding gene', 'ENSG00000142541'),
(6083, 19675, 'RPL13AP2', 'ribosomal protein L13a pseudogene 2', 'pseudogene', 'ENSG00000244053'),
(6084, 35855, 'RPL13AP19', 'ribosomal protein L13a pseudogene 19', 'pseudogene', 'ENSG00000228754'),
(6085, 31027, 'RPL13P4', 'ribosomal protein L13 pseudogene 4', 'pseudogene', 'ENSG00000241890');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(6086, 30363, 'RPL13P5', 'ribosomal protein L13 pseudogene 5', 'pseudogene', 'ENSG00000240370'),
(6087, 10305, 'RPL14', 'ribosomal protein L14', 'protein-coding gene', 'ENSG00000188846'),
(6088, 54686, 'RPL14P6', 'RPL14 pseudogene 6', 'pseudogene', 'ENSG00000185631'),
(6089, 21538, 'RPL15P3', 'ribosomal protein L15 pseudogene 3', 'pseudogene', 'ENSG00000212802'),
(6090, 35746, 'RPL15P5', 'ribosomal protein L15 pseudogene 5', 'pseudogene', 'ENSG00000233045'),
(6091, 44661, 'RPL17-C18ORF32', 'RPL17-C18orf32 readthrough', 'other', 'ENSG00000215472'),
(6092, 35838, 'RPL17P10', 'ribosomal protein L17 pseudogene 10', 'pseudogene', 'ENSG00000224672'),
(6093, 35597, 'RPL17P26', 'ribosomal protein L17 pseudogene 26', 'pseudogene', 'ENSG00000216854'),
(6094, 36672, 'RPL17P40', 'ribosomal protein L17 pseudogene 40', 'pseudogene', 'ENSG00000241067'),
(6095, 36202, 'RPL17P46', 'ribosomal protein L17 pseudogene 46', 'pseudogene', 'ENSG00000239689'),
(6096, 45098, 'RPL17P50', 'ribosomal protein L17 pseudogene 50', 'pseudogene', 'ENSG00000213700'),
(6097, 36624, 'RPL18AP14', 'ribosomal protein L18a pseudogene 14', 'pseudogene', 'ENSG00000223733'),
(6098, 36010, 'RPL18AP15', 'ribosomal protein L18a pseudogene 15', 'pseudogene', 'ENSG00000236189'),
(6099, 36288, 'RPL18AP16', 'ribosomal protein L18a pseudogene 16', 'pseudogene', 'ENSG00000237793'),
(6100, 36325, 'RPL19P5', 'ribosomal protein L19 pseudogene 5', 'pseudogene', 'ENSG00000230580'),
(6101, 35684, 'RPL19P14', 'ribosomal protein L19 pseudogene 14', 'pseudogene', 'ENSG00000240870'),
(6102, 35713, 'RPL19P20', 'ribosomal protein L19 pseudogene 20', 'pseudogene', 'ENSG00000229168'),
(6103, 10313, 'RPL21', 'ribosomal protein L21', 'protein-coding gene', 'ENSG00000122026'),
(6104, 17959, 'RPL21P4', 'ribosomal protein L21 pseudogene 4', 'pseudogene', 'ENSG00000240828'),
(6105, 19795, 'RPL21P10', 'ribosomal protein L21 pseudogene 10', 'pseudogene', 'ENSG00000239272'),
(6106, 36091, 'RPL21P30', 'ribosomal protein L21 pseudogene 30', 'pseudogene', 'ENSG00000235937'),
(6107, 36900, 'RPL21P35', 'ribosomal protein L21 pseudogene 35', 'pseudogene', 'ENSG00000231494'),
(6108, 37017, 'RPL21P42', 'ribosomal protein L21 pseudogene 42', 'pseudogene', 'ENSG00000240068'),
(6109, 36008, 'RPL21P43', 'ribosomal protein L21 pseudogene 43', 'pseudogene', 'ENSG00000231688'),
(6110, 36017, 'RPL21P65', 'ribosomal protein L21 pseudogene 65', 'pseudogene', 'ENSG00000216977'),
(6111, 36139, 'RPL21P67', 'ribosomal protein L21 pseudogene 67', 'pseudogene', 'ENSG00000219776'),
(6112, 36049, 'RPL21P71', 'ribosomal protein L21 pseudogene 71', 'pseudogene', 'ENSG00000239412'),
(6113, 35548, 'RPL21P90', 'ribosomal protein L21 pseudogene 90', 'pseudogene', 'ENSG00000227805'),
(6114, 36450, 'RPL21P91', 'ribosomal protein L21 pseudogene 91', 'pseudogene', 'ENSG00000224907'),
(6115, 36732, 'RPL21P103', 'ribosomal protein L21 pseudogene 103', 'pseudogene', 'ENSG00000241423'),
(6116, 35496, 'RPL21P108', 'ribosomal protein L21 pseudogene 108', 'pseudogene', 'ENSG00000232701'),
(6117, 36526, 'RPL21P112', 'ribosomal protein L21 pseudogene 112', 'pseudogene', 'ENSG00000237924'),
(6118, 36429, 'RPL21P121', 'ribosomal protein L21 pseudogene 121', 'pseudogene', 'ENSG00000237382'),
(6119, 36003, 'RPL21P133', 'ribosomal protein L21 pseudogene 133', 'pseudogene', 'ENSG00000236509'),
(6120, 36006, 'RPL21P134', 'ribosomal protein L21 pseudogene 134', 'pseudogene', 'ENSG00000233254'),
(6121, 49854, 'RPL21P136', 'ribosomal protein L21 pseudogene 136', 'pseudogene', 'ENSG00000271215'),
(6122, 36299, 'RPL22P4', 'ribosomal protein L22 pseudogene 4', 'pseudogene', 'ENSG00000225483'),
(6123, 36352, 'RPL22P13', 'ribosomal protein L22 pseudogene 13', 'pseudogene', 'ENSG00000242670'),
(6124, 35990, 'RPL22P14', 'ribosomal protein L22 pseudogene 14', 'pseudogene', 'ENSG00000218300'),
(6125, 53759, 'RPL22P23', 'ribosomal protein L22 pseudogene 23', 'pseudogene', 'ENSG00000232379'),
(6126, 36726, 'RPL23AP18', 'ribosomal protein L23a pseudogene 18', 'pseudogene', 'ENSG00000225338'),
(6127, 36708, 'RPL23AP19', 'ribosomal protein L23a pseudogene 19', 'pseudogene', 'ENSG00000229716'),
(6128, 36176, 'RPL23AP24', 'ribosomal protein L23a pseudogene 24', 'pseudogene', 'ENSG00000236679'),
(6129, 36497, 'RPL23AP27', 'ribosomal protein L23a pseudogene 27', 'pseudogene', 'ENSG00000225669'),
(6130, 36355, 'RPL23AP29', 'ribosomal protein L23a pseudogene 29', 'pseudogene', 'ENSG00000214024'),
(6131, 35617, 'RPL23AP30', 'ribosomal protein L23a pseudogene 30', 'pseudogene', 'ENSG00000226658'),
(6132, 36580, 'RPL23AP35', 'ribosomal protein L23a pseudogene 35', 'pseudogene', 'ENSG00000232568'),
(6133, 35685, 'RPL23AP36', 'ribosomal protein L23a pseudogene 36', 'pseudogene', 'ENSG00000225124'),
(6134, 35894, 'RPL23AP46', 'ribosomal protein L23a pseudogene 46', 'pseudogene', 'ENSG00000213122'),
(6135, 36276, 'RPL23AP62', 'ribosomal protein L23a pseudogene 62', 'pseudogene', 'ENSG00000213233'),
(6136, 36148, 'RPL23AP74', 'ribosomal protein L23a pseudogene 74', 'pseudogene', 'ENSG00000227694'),
(6137, 35975, 'RPL23AP75', 'ribosomal protein L23a pseudogene 75', 'pseudogene', 'ENSG00000240125'),
(6138, 36354, 'RPL23AP77', 'ribosomal protein L23a pseudogene 77', 'pseudogene', 'ENSG00000267301'),
(6139, 35518, 'RPL23AP78', 'ribosomal protein L23a pseudogene 78', 'pseudogene', 'ENSG00000269244'),
(6140, 33730, 'RPL23AP82', 'ribosomal protein L23a pseudogene 82', 'pseudogene', 'ENSG00000184319'),
(6141, 35846, 'RPL23AP83', 'ribosomal protein L23a pseudogene 83', 'pseudogene', 'ENSG00000234135'),
(6142, 51579, 'RPL23AP88', 'ribosomal protein L23a pseudogene 88', 'pseudogene', 'ENSG00000271153'),
(6143, 51624, 'RPL23AP90', 'ribosomal protein L23a pseudogene 90', 'pseudogene', 'ENSG00000271415'),
(6144, 51628, 'RPL23AP93', 'ribosomal protein L23a pseudogene 93', 'pseudogene', 'ENSG00000232873'),
(6145, 51630, 'RPL23AP95', 'ribosomal protein L23a pseudogene 95', 'pseudogene', 'ENSG00000236848'),
(6146, 36678, 'RPL23P4', 'ribosomal protein L23 pseudogene 4', 'pseudogene', 'ENSG00000223903'),
(6147, 35747, 'RPL23P5', 'ribosomal protein L23 pseudogene 5', 'pseudogene', 'ENSG00000230406'),
(6148, 36862, 'RPL24P7', 'RPL24 pseudogene 7', 'pseudogene', 'ENSG00000215016'),
(6149, 36409, 'RPL24P8', 'RPL24 pseudogene 8', 'pseudogene', 'ENSG00000236801'),
(6150, 54886, 'RPL24P9', 'RPL24 pseudogene 9', 'pseudogene', 'ENSG00000225722'),
(6151, 10327, 'RPL26', 'ribosomal protein L26', 'protein-coding gene', 'ENSG00000161970'),
(6152, 36639, 'RPL26P13', 'ribosomal protein L26 pseudogene 13', 'pseudogene', 'ENSG00000213495'),
(6153, 35512, 'RPL26P15', 'ribosomal protein L26 pseudogene 15', 'pseudogene', 'ENSG00000233829'),
(6154, 36733, 'RPL26P30', 'ribosomal protein L26 pseudogene 30', 'pseudogene', 'ENSG00000236264'),
(6155, 36278, 'RPL26P35', 'ribosomal protein L26 pseudogene 35', 'pseudogene', 'ENSG00000244229'),
(6156, 36004, 'RPL26P37', 'ribosomal protein L26 pseudogene 37', 'pseudogene', 'ENSG00000235175'),
(6157, 10328, 'RPL27', 'ribosomal protein L27', 'protein-coding gene', 'ENSG00000131469'),
(6158, 16250, 'RPL27AP', 'ribosomal protein L27a pseudogene', 'pseudogene', 'ENSG00000215467'),
(6159, 36544, 'RPL27AP8', 'ribosomal protein L27a pseudogene 8', 'pseudogene', 'ENSG00000229423'),
(6160, 36905, 'RPL29P11', 'ribosomal protein L29 pseudogene 11', 'pseudogene', 'ENSG00000224858'),
(6161, 36608, 'RPL29P12', 'ribosomal protein L29 pseudogene 12', 'pseudogene', 'ENSG00000224993'),
(6162, 35675, 'RPL29P22', 'ribosomal protein L29 pseudogene 22', 'pseudogene', 'ENSG00000239924'),
(6163, 36601, 'RPL29P30', 'ribosomal protein L29 pseudogene 30', 'pseudogene', 'ENSG00000235420'),
(6164, 16549, 'RPL31P3', 'ribosomal protein L31 pseudogene 3', 'pseudogene', 'ENSG00000237929'),
(6165, 35849, 'RPL31P11', 'ribosomal protein L31 pseudogene 11', 'pseudogene', 'ENSG00000213075'),
(6166, 36932, 'RPL31P35', 'ribosomal protein L31 pseudogene 35', 'pseudogene', 'ENSG00000232612'),
(6167, 36336, 'RPL31P56', 'ribosomal protein L31 pseudogene 56', 'pseudogene', 'ENSG00000240760'),
(6168, 35703, 'RPL31P57', 'ribosomal protein L31 pseudogene 57', 'pseudogene', 'ENSG00000256358'),
(6169, 35862, 'RPL31P58', 'ribosomal protein L31 pseudogene 58', 'pseudogene', 'ENSG00000243053'),
(6170, 35804, 'RPL32P7', 'ribosomal protein L32 pseudogene 7', 'pseudogene', 'ENSG00000243396'),
(6171, 35723, 'RPL32P11', 'ribosomal protein L32 pseudogene 11', 'pseudogene', 'ENSG00000213872'),
(6172, 36600, 'RPL32P12', 'ribosomal protein L32 pseudogene 12', 'pseudogene', 'ENSG00000242209'),
(6173, 37038, 'RPL32P14', 'ribosomal protein L32 pseudogene 14', 'pseudogene', 'ENSG00000242654'),
(6174, 36743, 'RPL32P19', 'ribosomal protein L32 pseudogene 19', 'pseudogene', 'ENSG00000226836'),
(6175, 36363, 'RPL32P21', 'ribosomal protein L32 pseudogene 21', 'pseudogene', 'ENSG00000125385'),
(6176, 36027, 'RPL32P26', 'ribosomal protein L32 pseudogene 26', 'pseudogene', 'ENSG00000241941'),
(6177, 36729, 'RPL32P30', 'ribosomal protein L32 pseudogene 30', 'pseudogene', 'ENSG00000241130'),
(6178, 36231, 'RPL32P33', 'ribosomal protein L32 pseudogene 33', 'pseudogene', 'ENSG00000243514'),
(6179, 35903, 'RPL32P34', 'ribosomal protein L32 pseudogene 34', 'pseudogene', 'ENSG00000239524'),
(6180, 36547, 'RPL32P35', 'ribosomal protein L32 pseudogene 35', 'pseudogene', 'ENSG00000223995'),
(6181, 36613, 'RPL32P36', 'ribosomal protein L32 pseudogene 36', 'pseudogene', 'ENSG00000189145'),
(6182, 10340, 'RPL34', 'ribosomal protein L34', 'protein-coding gene', 'ENSG00000109475'),
(6183, 10341, 'RPL34P1', 'ribosomal protein L34 pseudogene 1', 'pseudogene', 'ENSG00000237049'),
(6184, 36963, 'RPL34P8', 'ribosomal protein L34 pseudogene 8', 'pseudogene', 'ENSG00000237583'),
(6185, 36793, 'RPL35AP6', 'ribosomal protein L35a pseudogene 6', 'pseudogene', 'ENSG00000228879'),
(6186, 36212, 'RPL35AP7', 'ribosomal protein L35a pseudogene 7', 'pseudogene', 'ENSG00000225487'),
(6187, 35643, 'RPL35AP9', 'ribosomal protein L35a pseudogene 9', 'pseudogene', 'ENSG00000243675'),
(6188, 36783, 'RPL35AP14', 'ribosomal protein L35a pseudogene 14', 'pseudogene', 'ENSG00000240436'),
(6189, 36974, 'RPL35AP15', 'ribosomal protein L35a pseudogene 15', 'pseudogene', 'ENSG00000243758'),
(6190, 36384, 'RPL35AP17', 'ribosomal protein L35a pseudogene 17', 'pseudogene', 'ENSG00000239317'),
(6191, 36812, 'RPL35AP18', 'ribosomal protein L35a pseudogene 18', 'pseudogene', 'ENSG00000220311'),
(6192, 35544, 'RPL35AP24', 'ribosomal protein L35a pseudogene 24', 'pseudogene', 'ENSG00000230166'),
(6193, 36284, 'RPL35AP31', 'ribosomal protein L35a pseudogene 31', 'pseudogene', 'ENSG00000233460'),
(6194, 36955, 'RPL35P5', 'ribosomal protein L35 pseudogene 5', 'pseudogene', 'ENSG00000225573'),
(6195, 48349, 'RPL36A-HNRNPH2', 'RPL36A-HNRNPH2 readthrough', 'other', 'ENSG00000257529'),
(6196, 31328, 'RPL36AP7', 'ribosomal protein L36a pseudogene 7', 'pseudogene', 'ENSG00000228007'),
(6197, 35872, 'RPL36AP9', 'ribosomal protein L36a pseudogene 9', 'pseudogene', 'ENSG00000213987'),
(6198, 37041, 'RPL36AP21', 'ribosomal protein L36a pseudogene 21', 'pseudogene', 'ENSG00000240785'),
(6199, 35650, 'RPL36AP27', 'ribosomal protein L36a pseudogene 27', 'pseudogene', 'ENSG00000225443'),
(6200, 36216, 'RPL36AP30', 'ribosomal protein L36a pseudogene 30', 'pseudogene', 'ENSG00000224629'),
(6201, 36066, 'RPL36AP31', 'ribosomal protein L36a pseudogene 31', 'pseudogene', 'ENSG00000227753'),
(6202, 35639, 'RPL36AP35', 'ribosomal protein L36a pseudogene 35', 'pseudogene', 'ENSG00000231810'),
(6203, 35594, 'RPL36AP38', 'ribosomal protein L36a pseudogene 38', 'pseudogene', 'ENSG00000241097'),
(6204, 36032, 'RPL36AP45', 'ribosomal protein L36a pseudogene 45', 'pseudogene', 'ENSG00000240366'),
(6205, 35624, 'RPL36AP47', 'ribosomal protein L36a pseudogene 47', 'pseudogene', 'ENSG00000242123'),
(6206, 44939, 'RPL36AP55', 'ribosomal protein L36a pseudogene 55', 'pseudogene', 'ENSG00000226016'),
(6207, 16338, 'RPL36P1', 'ribosomal protein L36 pseudogene 1', 'pseudogene', 'ENSG00000230636'),
(6208, 36046, 'RPL36P6', 'ribosomal protein L36 pseudogene 6', 'pseudogene', 'ENSG00000224348'),
(6209, 36271, 'RPL36P11', 'ribosomal protein L36 pseudogene 11', 'pseudogene', 'ENSG00000240518'),
(6210, 36941, 'RPL36P13', 'ribosomal protein L36 pseudogene 13', 'pseudogene', 'ENSG00000236580'),
(6211, 36787, 'RPL36P15', 'ribosomal protein L36 pseudogene 15', 'pseudogene', 'ENSG00000240100'),
(6212, 42648, 'RPL36P19', 'ribosomal protein L36 pseudogene 19', 'pseudogene', 'ENSG00000232540'),
(6213, 40510, 'RPL37A-DT', 'RPL37A divergent transcript', 'non-coding RNA', 'ENSG00000232485'),
(6214, 17092, 'RPL37P2', 'ribosomal protein L37 pseudogene 2', 'pseudogene', 'ENSG00000239559'),
(6215, 36951, 'RPL37P10', 'ribosomal protein L37 pseudogene 10', 'pseudogene', 'ENSG00000224627'),
(6216, 35980, 'RPL38P3', 'RPL38 pseudogene 3', 'pseudogene', 'ENSG00000244422'),
(6217, 54607, 'RPL38P5', 'RPL38 pseudogene 5', 'pseudogene', 'ENSG00000235579'),
(6218, 10350, 'RPL39', 'ribosomal protein L39', 'protein-coding gene', 'ENSG00000198918'),
(6219, 26015, 'RPL39P5', 'ribosomal protein L39 pseudogene 5', 'pseudogene', 'ENSG00000214289'),
(6220, 36609, 'RPL39P14', 'ribosomal protein L39 pseudogene 14', 'pseudogene', 'ENSG00000224463'),
(6221, 35856, 'RPL39P15', 'ribosomal protein L39 pseudogene 15', 'pseudogene', 'ENSG00000231414'),
(6222, 35619, 'RPL39P28', 'ribosomal protein L39 pseudogene 28', 'pseudogene', 'ENSG00000244432'),
(6223, 35808, 'RPL39P29', 'ribosomal protein L39 pseudogene 29', 'pseudogene', 'ENSG00000236860'),
(6224, 10371, 'RPLP0', 'ribosomal protein lateral stalk subunit P0', 'protein-coding gene', 'ENSG00000089157'),
(6225, 35809, 'RPLP1P6', 'ribosomal protein lateral stalk subunit P1 pseudogene 6', 'pseudogene', 'ENSG00000213433'),
(6226, 35620, 'RPLP0P5', 'ribosomal protein lateral stalk subunit P0 pseudogene 5', 'pseudogene', 'ENSG00000232883'),
(6227, 35867, 'RPLP0P8', 'ribosomal protein lateral stalk subunit P0 pseudogene 8', 'pseudogene', 'ENSG00000244640'),
(6228, 10382, 'RPN2', 'ribophorin II', 'protein-coding gene', 'ENSG00000118705'),
(6229, 21300, 'RPP21', 'ribonuclease P/MRP subunit p21', 'protein-coding gene', 'ENSG00000241370'),
(6230, 17688, 'RPP30', 'ribonuclease P/MRP subunit p30', 'protein-coding gene', 'ENSG00000148688'),
(6231, 30329, 'RPP38', 'ribonuclease P/MRP subunit p38', 'protein-coding gene', 'ENSG00000152464'),
(6232, 20992, 'RPP40', 'ribonuclease P/MRP subunit p40', 'protein-coding gene', 'ENSG00000124787'),
(6233, 32422, 'RPRML', 'reprimo like', 'protein-coding gene', 'ENSG00000179673'),
(6234, 19790, 'RPS2P2', 'ribosomal protein S2 pseudogene 2', 'pseudogene', 'ENSG00000177776'),
(6235, 36757, 'RPS2P35', 'ribosomal protein S2 pseudogene 35', 'pseudogene', 'ENSG00000238172'),
(6236, 35985, 'RPS2P48', 'ribosomal protein S2 pseudogene 48', 'pseudogene', 'ENSG00000233380'),
(6237, 16537, 'RPS3AP3', 'RPS3A pseudogene 3', 'pseudogene', 'ENSG00000231241'),
(6238, 35638, 'RPS3AP8', 'RPS3A pseudogene 8', 'pseudogene', 'ENSG00000233562'),
(6239, 36150, 'RPS3AP9', 'RPS3A pseudogene 9', 'pseudogene', 'ENSG00000231022'),
(6240, 36036, 'RPS3AP10', 'RPS3A pseudogene 10', 'pseudogene', 'ENSG00000226292'),
(6241, 54572, 'RPS3AP13', 'RPS3A pseudogene 13', 'pseudogene', 'ENSG00000230783'),
(6242, 35781, 'RPS3AP15', 'RPS3A pseudogene 15', 'pseudogene', 'ENSG00000244674'),
(6243, 35893, 'RPS3AP18', 'RPS3A pseudogene 18', 'pseudogene', 'ENSG00000243417'),
(6244, 36467, 'RPS3AP19', 'RPS3A pseudogene 19', 'pseudogene', 'ENSG00000244004'),
(6245, 36767, 'RPS3AP23', 'RPS3A pseudogene 23', 'pseudogene', 'ENSG00000218351'),
(6246, 35902, 'RPS3AP35', 'RPS3A pseudogene 35', 'pseudogene', 'ENSG00000244289'),
(6247, 16603, 'RPS3P2', 'ribosomal protein S3 pseudogene 2', 'pseudogene', 'ENSG00000231307'),
(6248, 36061, 'RPS3P6', 'ribosomal protein S3 pseudogene 6', 'pseudogene', 'ENSG00000213363'),
(6249, 36056, 'RPS3P7', 'ribosomal protein S3 pseudogene 7', 'pseudogene', 'ENSG00000243101'),
(6250, 16251, 'RPS4XP3', 'ribosomal protein S4X pseudogene 3', 'pseudogene', 'ENSG00000214541'),
(6251, 36670, 'RPS4XP5', 'ribosomal protein S4X pseudogene 5', 'pseudogene', 'ENSG00000229920'),
(6252, 36683, 'RPS4XP8', 'ribosomal protein S4X pseudogene 8', 'pseudogene', 'ENSG00000219146'),
(6253, 35792, 'RPS4XP9', 'ribosomal protein S4X pseudogene 9', 'pseudogene', 'ENSG00000217404'),
(6254, 35741, 'RPS4XP10', 'ribosomal protein S4X pseudogene 10', 'pseudogene', 'ENSG00000244217'),
(6255, 37013, 'RPS4XP11', 'ribosomal protein S4X pseudogene 11', 'pseudogene', 'ENSG00000234335'),
(6256, 35951, 'RPS4XP12', 'ribosomal protein S4X pseudogene 12', 'pseudogene', 'ENSG00000244400'),
(6257, 36531, 'RPS5P8', 'RPS5 pseudogene 8', 'pseudogene', 'ENSG00000237730'),
(6258, 10430, 'RPS6KA1', 'ribosomal protein S6 kinase A1', 'protein-coding gene', 'ENSG00000117676'),
(6259, 10431, 'RPS6KA2', 'ribosomal protein S6 kinase A2', 'protein-coding gene', 'ENSG00000071242'),
(6260, 10435, 'RPS6KA6', 'ribosomal protein S6 kinase A6', 'protein-coding gene', 'ENSG00000072133'),
(6261, 10440, 'RPS7', 'ribosomal protein S7', 'protein-coding gene', 'ENSG00000171863'),
(6262, 36998, 'RPS7P9', 'ribosomal protein S7 pseudogene 9', 'pseudogene', 'ENSG00000233353'),
(6263, 39903, 'RPS7P10', 'ribosomal protein S7 pseudogene 10', 'pseudogene', 'ENSG00000226525'),
(6264, 17478, 'RPS8P4', 'ribosomal protein S8 pseudogene 4', 'pseudogene', 'ENSG00000227437'),
(6265, 10442, 'RPS9', 'ribosomal protein S9', 'protein-coding gene', 'ENSG00000170889'),
(6266, 36423, 'RPS10P7', 'ribosomal protein S10 pseudogene 7', 'pseudogene', 'ENSG00000223396'),
(6267, 10384, 'RPS11', 'ribosomal protein S11', 'protein-coding gene', 'ENSG00000142534'),
(6268, 16553, 'RPS11P1', 'ribosomal protein S11 pseudogene 1', 'pseudogene', 'ENSG00000235544'),
(6269, 36724, 'RPS11P7', 'ribosomal protein S11 pseudogene 7', 'pseudogene', 'ENSG00000214047'),
(6270, 35892, 'RPS12P27', 'ribosomal protein S12 pseudogene 27', 'pseudogene', 'ENSG00000240435'),
(6271, 35578, 'RPS12P31', 'ribosomal protein S12 pseudogene 31', 'pseudogene', 'ENSG00000242325'),
(6272, 10389, 'RPS15A', 'ribosomal protein S15a', 'protein-coding gene', 'ENSG00000134419'),
(6273, 36707, 'RPS15AP11', 'ribosomal protein S15a pseudogene 11', 'pseudogene', 'ENSG00000234093'),
(6274, 35640, 'RPS15AP15', 'ribosomal protein S15a pseudogene 15', 'pseudogene', 'ENSG00000223739'),
(6275, 35981, 'RPS15AP29', 'ribosomal protein S15a pseudogene 29', 'pseudogene', 'ENSG00000237827'),
(6276, 35879, 'RPS15AP32', 'ribosomal protein S15a pseudogene 32', 'pseudogene', 'ENSG00000242461'),
(6277, 35800, 'RPS15AP39', 'ribosomal protein S15a pseudogene 39', 'pseudogene', 'ENSG00000229822'),
(6278, 36041, 'RPS15AP40', 'ribosomal protein S15a pseudogene 40', 'pseudogene', 'ENSG00000233921'),
(6279, 35712, 'RPS15P4', 'ribosomal protein S15 pseudogene 4', 'pseudogene', 'ENSG00000233762'),
(6280, 10398, 'RPS17P2', 'ribosomal protein S17 pseudogene 2', 'pseudogene', 'ENSG00000197575'),
(6281, 36772, 'RPS17P8', 'ribosomal protein S17 pseudogene 8', 'pseudogene', 'ENSG00000226242'),
(6282, 36664, 'RPS17P13', 'ribosomal protein S17 pseudogene 13', 'pseudogene', 'ENSG00000224706'),
(6283, 36028, 'RPS18P6', 'ribosomal protein S18 pseudogene 6', 'pseudogene', 'ENSG00000244048'),
(6284, 36483, 'RPS18P9', 'ribosomal protein S18 pseudogene 9', 'pseudogene', 'ENSG00000220848'),
(6285, 35967, 'RPS18P12', 'ribosomal protein S18 pseudogene 12', 'pseudogene', 'ENSG00000230897'),
(6286, 16534, 'RPS19P1', 'ribosomal protein S19 pseudogene 1', 'pseudogene', 'ENSG00000214612'),
(6287, 35550, 'RPS19P7', 'ribosomal protein S19 pseudogene 7', 'pseudogene', 'ENSG00000228462'),
(6288, 10405, 'RPS20', 'ribosomal protein S20', 'protein-coding gene', 'ENSG00000008988'),
(6289, 10408, 'RPS20P1', 'ribosomal protein S20 pseudogene 1', 'pseudogene', 'ENSG00000229761'),
(6290, 36379, 'RPS20P22', 'ribosomal protein S20 pseudogene 22', 'pseudogene', 'ENSG00000239218'),
(6291, 36283, 'RPS20P24', 'ribosomal protein S20 pseudogene 24', 'pseudogene', 'ENSG00000236862'),
(6292, 35767, 'RPS20P31', 'ribosomal protein S20 pseudogene 31', 'pseudogene', 'ENSG00000240925'),
(6293, 10409, 'RPS21', 'ribosomal protein S21', 'protein-coding gene', 'ENSG00000171858'),
(6294, 35499, 'RPS23P3', 'ribosomal protein S23 pseudogene 3', 'pseudogene', 'ENSG00000244099'),
(6295, 36805, 'RPS24P13', 'ribosomal protein S24 pseudogene 13', 'pseudogene', 'ENSG00000233190'),
(6296, 35744, 'RPS24P14', 'ribosomal protein S24 pseudogene 14', 'pseudogene', 'ENSG00000223688'),
(6297, 36348, 'RPS24P17', 'ribosomal protein S24 pseudogene 17', 'pseudogene', 'ENSG00000243988'),
(6298, 36936, 'RPS25P9', 'ribosomal protein S25 pseudogene 9', 'pseudogene', 'ENSG00000232142'),
(6299, 23776, 'RPS26P5', 'ribosomal protein S26 pseudogene 5', 'pseudogene', 'ENSG00000224602'),
(6300, 31817, 'RPS26P11', 'ribosomal protein S26 pseudogene 11', 'pseudogene', 'ENSG00000196933'),
(6301, 36243, 'RPS26P42', 'ribosomal protein S26 pseudogene 42', 'pseudogene', 'ENSG00000232437'),
(6302, 35519, 'RPS26P48', 'ribosomal protein S26 pseudogene 48', 'pseudogene', 'ENSG00000239438'),
(6303, 35514, 'RPS26P49', 'ribosomal protein S26 pseudogene 49', 'pseudogene', 'ENSG00000239365'),
(6304, 36863, 'RPS26P52', 'ribosomal protein S26 pseudogene 52', 'pseudogene', 'ENSG00000242307'),
(6305, 36868, 'RPS26P54', 'ribosomal protein S26 pseudogene 54', 'pseudogene', 'ENSG00000224161'),
(6306, 10416, 'RPS27', 'ribosomal protein S27', 'protein-coding gene', 'ENSG00000177954'),
(6307, 36530, 'RPS27AP14', 'RPS27A pseudogene 14', 'pseudogene', 'ENSG00000236594'),
(6308, 52299, 'RPS27AP18', 'RPS27A pseudogene 18', 'pseudogene', 'ENSG00000249851'),
(6309, 35961, 'RPS27P10', 'ribosomal protein S27 pseudogene 10', 'pseudogene', 'ENSG00000231017'),
(6310, 36296, 'RPS27P18', 'ribosomal protein S27 pseudogene 18', 'pseudogene', 'ENSG00000233135'),
(6311, 31363, 'RPS29P3', 'ribosomal protein S29 pseudogene 3', 'pseudogene', 'ENSG00000225770'),
(6312, 35718, 'RPS29P6', 'ribosomal protein S29 pseudogene 6', 'pseudogene', 'ENSG00000230451'),
(6313, 36594, 'RPS29P7', 'ribosomal protein S29 pseudogene 7', 'pseudogene', 'ENSG00000231622'),
(6314, 37006, 'RPS29P10', 'ribosomal protein S29 pseudogene 10', 'pseudogene', 'ENSG00000226884'),
(6315, 36413, 'RPS29P11', 'ribosomal protein S29 pseudogene 11', 'pseudogene', 'ENSG00000242640'),
(6316, 36458, 'RPS29P12', 'ribosomal protein S29 pseudogene 12', 'pseudogene', 'ENSG00000243664'),
(6317, 36471, 'RPS29P14', 'ribosomal protein S29 pseudogene 14', 'pseudogene', 'ENSG00000229054'),
(6318, 36490, 'RPS29P26', 'ribosomal protein S29 pseudogene 26', 'pseudogene', 'ENSG00000239320'),
(6319, 36830, 'RPS29P28', 'ribosomal protein S29 pseudogene 28', 'pseudogene', 'ENSG00000232069'),
(6320, 16560, 'RPSAP1', 'ribosomal protein SA pseudogene 1', 'pseudogene', 'ENSG00000228820'),
(6321, 31460, 'RPSAP10', 'ribosomal protein SA pseudogene 10', 'pseudogene', 'ENSG00000224439'),
(6322, 6503, 'RPSAP11', 'ribosomal protein SA pseudogene 11', 'pseudogene', 'ENSG00000237433'),
(6323, 36928, 'RPSAP21', 'ribosomal protein SA pseudogene 21', 'pseudogene', 'ENSG00000226498'),
(6324, 36435, 'RPSAP22', 'ribosomal protein SA pseudogene 22', 'pseudogene', 'ENSG00000229648'),
(6325, 36447, 'RPSAP35', 'ribosomal protein SA pseudogene 35', 'pseudogene', 'ENSG00000237684'),
(6326, 35727, 'RPSAP36', 'ribosomal protein SA pseudogene 36', 'pseudogene', 'ENSG00000243175'),
(6327, 37040, 'RPSAP39', 'ribosomal protein SA pseudogene 39', 'pseudogene', 'ENSG00000244002'),
(6328, 36828, 'RPSAP40', 'ribosomal protein SA pseudogene 40', 'pseudogene', 'ENSG00000231368'),
(6329, 36265, 'RPSAP42', 'ribosomal protein SA pseudogene 42', 'pseudogene', 'ENSG00000219463'),
(6330, 51914, 'RPSAP65', 'ribosomal protein SA pseudogene 65', 'pseudogene', 'ENSG00000223683'),
(6331, 30287, 'RPTOR', 'regulatory associated protein of MTOR complex 1', 'protein-coding gene', 'ENSG00000141564'),
(6332, 10446, 'RRAD', 'RRAD, Ras related glycolysis inhibitor and calcium channel regulator', 'protein-coding gene', 'ENSG00000166592'),
(6333, 20242, 'RRAGAP1', 'Ras related GTP binding A pseudogene 1', 'pseudogene', 'ENSG00000259046'),
(6334, 17271, 'RRAS2', 'RAS related 2', 'protein-coding gene', 'ENSG00000133818'),
(6335, 54561, 'RRAS2P1', 'RRAS2 pseudogene 1', 'pseudogene', 'ENSG00000236360'),
(6336, 10450, 'RRH', 'retinal pigment epithelium-derived rhodopsin homolog', 'protein-coding gene', 'ENSG00000180245'),
(6337, 10451, 'RRM1', 'ribonucleotide reductase catalytic subunit M1', 'protein-coding gene', 'ENSG00000167325'),
(6338, 10452, 'RRM2', 'ribonucleotide reductase regulatory subunit M2', 'protein-coding gene', 'ENSG00000171848'),
(6339, 17296, 'RRM2B', 'ribonucleotide reductase regulatory TP53 inducible subunit M2B', 'protein-coding gene', 'ENSG00000048392'),
(6340, 10454, 'RRM2P2', 'ribonucleotide reductase M2 polypeptide pseudogene 2', 'pseudogene', 'ENSG00000236484'),
(6341, 10456, 'RRM2P4', 'ribonucleotide reductase M2 polypeptide pseudogene 4', 'pseudogene', 'ENSG00000235598'),
(6342, 30346, 'RRN3', 'RRN3 homolog, RNA polymerase I transcription factor', 'protein-coding gene', 'ENSG00000085721'),
(6343, 30454, 'RRP7BP', 'ribosomal RNA processing 7 homolog B, pseudogene', 'pseudogene', 'ENSG00000182841'),
(6344, 17083, 'RRS1', 'ribosome biogenesis regulator 1 homolog', 'protein-coding gene', 'ENSG00000179041'),
(6345, 24765, 'RSBN1L', 'round spermatid basic protein 1 like', 'protein-coding gene', 'ENSG00000187257'),
(6346, 10458, 'RSC1A1', 'regulator of solute carriers 1', 'protein-coding gene', 'ENSG00000215695'),
(6347, 41439, 'RSF1-IT1', 'RSF1 intronic transcript 1', 'non-coding RNA', 'ENSG00000255409'),
(6348, 55337, 'RSL1D1-DT', 'RSL1D1 divergent transcript', 'non-coding RNA', 'ENSG00000263307'),
(6349, 13979, 'RSL24D1P1', 'ribosomal L24 domain containing 1 pseudogene 1', 'pseudogene', 'ENSG00000218069'),
(6350, 12371, 'RSPH1', 'radial spoke head component 1', 'protein-coding gene', 'ENSG00000160188'),
(6351, 14241, 'RSPH6A', 'radial spoke head 6 homolog A', 'protein-coding gene', 'ENSG00000104941'),
(6352, 34385, 'RSPH10B2', 'radial spoke head 10 homolog B2', 'protein-coding gene', 'ENSG00000169402'),
(6353, 24152, 'RSRC1', 'arginine and serine rich coiled-coil 1', 'protein-coding gene', 'ENSG00000174891'),
(6354, 44392, 'RSU1P3', 'Ras suppressor protein 1 pseudogene 3', 'pseudogene', 'ENSG00000213659'),
(6355, 17981, 'RTCA', 'RNA 3\'-terminal phosphate cyclase', 'protein-coding gene', 'ENSG00000137996'),
(6356, 26935, 'RTCB', 'RNA 2\',3\'-cyclic phosphate and 5\'-OH ligase', 'protein-coding gene', 'ENSG00000100220'),
(6357, 15888, 'RTEL1', 'regulator of telomere elongation helicase 1', 'protein-coding gene', 'ENSG00000258366'),
(6358, 19364, 'RTKN2', 'rhotekin 2', 'protein-coding gene', 'ENSG00000182010'),
(6359, 29245, 'RTL9', 'retrotransposon Gag like 9', 'protein-coding gene', 'ENSG00000243978'),
(6360, 10467, 'RTN1', 'reticulon 1', 'protein-coding gene', 'ENSG00000139970'),
(6361, 18601, 'RTN4R', 'reticulon 4 receptor', 'protein-coding gene', 'ENSG00000040608'),
(6362, 23053, 'RTN4RL2', 'reticulon 4 receptor like 2', 'protein-coding gene', 'ENSG00000186907'),
(6363, 51344, 'RUNDC3A-AS1', 'RUNDC3A antisense RNA 1', 'non-coding RNA', 'ENSG00000267750'),
(6364, 10473, 'RUNX3', 'RUNX family transcription factor 3', 'protein-coding gene', 'ENSG00000020633'),
(6365, 17153, 'RUSC1', 'RUN and SH3 domain containing 1', 'protein-coding gene', 'ENSG00000160753'),
(6366, 10474, 'RUVBL1', 'RuvB like AAA ATPase 1', 'protein-coding gene', 'ENSG00000175792'),
(6367, 23753, 'RWDD4P1', 'RWD domain containing 4 pseudogene 1', 'pseudogene', 'ENSG00000244490'),
(6368, 10479, 'RXRG', 'retinoid X receptor gamma', 'protein-coding gene', 'ENSG00000143171'),
(6369, 10485, 'RYR3', 'ryanodine receptor 3', 'protein-coding gene', 'ENSG00000198838'),
(6370, 3169, 'S1PR2', 'sphingosine-1-phosphate receptor 2', 'protein-coding gene', 'ENSG00000267534'),
(6371, 10494, 'S100A4', 'S100 calcium binding protein A4', 'protein-coding gene', 'ENSG00000196154'),
(6372, 10497, 'S100A7', 'S100 calcium binding protein A7', 'protein-coding gene', 'ENSG00000143556'),
(6373, 10498, 'S100A8', 'S100 calcium binding protein A8', 'protein-coding gene', 'ENSG00000143546'),
(6374, 54954, 'S100A11P5', 'S100A11 pseudogene 5', 'pseudogene', 'ENSG00000238032'),
(6375, 54956, 'S100A11P7', 'S100A11 pseudogene 7', 'pseudogene', 'ENSG00000231568'),
(6376, 54958, 'S100A11P9', 'S100A11 pseudogene 9', 'pseudogene', 'ENSG00000270747'),
(6377, 18901, 'S100A14', 'S100 calcium binding protein A14', 'protein-coding gene', 'ENSG00000189334'),
(6378, 10500, 'S100B', 'S100 calcium binding protein B', 'protein-coding gene', 'ENSG00000160307'),
(6379, 10504, 'S100P', 'S100 calcium binding protein P', 'protein-coding gene', 'ENSG00000163993'),
(6380, 17059, 'SACM1L', 'SAC1 like phosphatidylinositide phosphatase', 'protein-coding gene', 'ENSG00000211456'),
(6381, 21605, 'SAFB2', 'scaffold attachment factor B2', 'protein-coding gene', 'ENSG00000130254'),
(6382, 10521, 'SAG', 'S-antigen visual arrestin', 'protein-coding gene', 'ENSG00000130561'),
(6383, 30369, 'SAGE1', 'sarcoma antigen 1', 'protein-coding gene', 'ENSG00000181433'),
(6384, 51339, 'SAGE4P', 'sarcoma antigen 4, pseudogene', 'pseudogene', 'ENSG00000224539'),
(6385, 15924, 'SALL4', 'spalt like transcription factor 4', 'protein-coding gene', 'ENSG00000101115'),
(6386, 39819, 'SALL4P2', 'spalt like transcription factor 4 pseudogene 2', 'pseudogene', 'ENSG00000238040'),
(6387, 39823, 'SALL4P6', 'spalt like transcription factor 4 pseudogene 6', 'pseudogene', 'ENSG00000231280'),
(6388, 17958, 'SAMD1', 'sterile alpha motif domain containing 1', 'protein-coding gene', 'ENSG00000141858'),
(6389, 23023, 'SAMD4A', 'sterile alpha motif domain containing 4A', 'protein-coding gene', 'ENSG00000020577'),
(6390, 25492, 'SAMD4B', 'sterile alpha motif domain containing 4B', 'protein-coding gene', 'ENSG00000179134'),
(6391, 1348, 'SAMD9', 'sterile alpha motif domain containing 9', 'protein-coding gene', 'ENSG00000205413'),
(6392, 18631, 'SAMD15', 'sterile alpha motif domain containing 15', 'protein-coding gene', 'ENSG00000100583'),
(6393, 39599, 'SAMSN1-AS1', 'SAMSN1 antisense RNA 1', 'non-coding RNA', 'ENSG00000223662'),
(6394, 29387, 'SANBR', 'SANT and BTB domain regulator of CSR', 'protein-coding gene', 'ENSG00000162929'),
(6395, 51568, 'SAP18P2', 'SAP18 pseudogene 2', 'pseudogene', 'ENSG00000223873'),
(6396, 10532, 'SAP30', 'Sin3A associated protein 30', 'protein-coding gene', 'ENSG00000164105'),
(6397, 13938, 'SAPCD1', 'suppressor APC domain containing 1', 'protein-coding gene', 'ENSG00000228727'),
(6398, 28055, 'SAPCD2', 'suppressor APC domain containing 2', 'protein-coding gene', 'ENSG00000186193'),
(6399, 32317, 'SAR1AP3', 'secretion associated Ras related GTPase 1A pseudogene 3', 'pseudogene', 'ENSG00000225665'),
(6400, 37638, 'SAR1AP4', 'secretion associated Ras related GTPase 1A pseudogene 4', 'pseudogene', 'ENSG00000233063'),
(6401, 10538, 'SART1', 'spliceosome associated factor 1, recruiter of U4/U6.U5 tri-snRNP', 'protein-coding gene', 'ENSG00000175467'),
(6402, 15975, 'SASH3', 'SAM and SH3 domain containing 3', 'protein-coding gene', 'ENSG00000122122'),
(6403, 25403, 'SASS6', 'SAS-6 centriolar assembly protein', 'protein-coding gene', 'ENSG00000156876'),
(6404, 50687, 'SATB1-AS1', 'SATB1 antisense RNA 1', 'non-coding RNA', 'ENSG00000228956'),
(6405, 27438, 'SBF2-AS1', 'SBF2 antisense RNA 1', 'non-coding RNA', 'ENSG00000246273'),
(6406, 29158, 'SBNO2', 'strawberry notch homolog 2', 'protein-coding gene', 'ENSG00000064932'),
(6407, 19304, 'SCAF4', 'SR-related CTD associated factor 4', 'protein-coding gene', 'ENSG00000156304'),
(6408, 26709, 'SCAI', 'suppressor of cancer cell invasion', 'protein-coding gene', 'ENSG00000173611'),
(6409, 10567, 'SCAND2P', 'SCAN domain containing 2 pseudogene', 'pseudogene', 'ENSG00000176700'),
(6410, 13081, 'SCAPER', 'S-phase cyclin A associated protein in the ER', 'protein-coding gene', 'ENSG00000140386'),
(6411, 32566, 'SCARNA9', 'small Cajal body-specific RNA 9', 'non-coding RNA', 'ENSG00000254911'),
(6412, 32569, 'SCARNA12', 'small Cajal body-specific RNA 12', 'non-coding RNA', 'ENSG00000238795'),
(6413, 32573, 'SCARNA16', 'small Cajal body-specific RNA 16', 'non-coding RNA', 'ENSG00000275143'),
(6414, 30676, 'SCFD2', 'sec1 family domain containing 2', 'protein-coding gene', 'ENSG00000184178'),
(6415, 40524, 'SCG5-AS1', 'SCG5 antisense RNA 1', 'non-coding RNA', 'ENSG00000241818'),
(6416, 18395, 'SCGB1D1', 'secretoglobin family 1D member 1', 'protein-coding gene', 'ENSG00000168515'),
(6417, 31748, 'SCGB1D4', 'secretoglobin family 1D member 4', 'protein-coding gene', 'ENSG00000197745'),
(6418, 27616, 'SCGB2B2', 'secretoglobin family 2B member 2', 'protein-coding gene', 'ENSG00000205209'),
(6419, 31895, 'SCGB2B3P', 'secretoglobin family 2B member 3, pseudogene', 'pseudogene', 'ENSG00000269811'),
(6420, 18384, 'SCGB3A1', 'secretoglobin family 3A member 1', 'protein-coding gene', 'ENSG00000161055'),
(6421, 48603, 'SCHLAP1', 'SWI/SNF complex antagonist associated with prostate cancer 1', 'non-coding RNA', 'ENSG00000281131'),
(6422, 21695, 'SCIN', 'scinderin', 'protein-coding gene', 'ENSG00000006747'),
(6423, 55341, 'SCIRT', 'stem cell inhibitory RNA transcript', 'non-coding RNA', 'ENSG00000237686'),
(6424, 18161, 'SCLY', 'selenocysteine lyase', 'protein-coding gene', 'ENSG00000132330'),
(6425, 21397, 'SCML4', 'Scm polycomb group protein like 4', 'protein-coding gene', 'ENSG00000146285'),
(6426, 10585, 'SCN1A', 'sodium voltage-gated channel alpha subunit 1', 'protein-coding gene', 'ENSG00000144285'),
(6427, 10583, 'SCN11A', 'sodium voltage-gated channel alpha subunit 11', 'protein-coding gene', 'ENSG00000168356'),
(6428, 10600, 'SCNN1B', 'sodium channel epithelial 1 subunit beta', 'protein-coding gene', 'ENSG00000168447'),
(6429, 10603, 'SCO1', 'synthesis of cytochrome C oxidase 1', 'protein-coding gene', 'ENSG00000133028'),
(6430, 20335, 'SCOC', 'short coiled-coil protein', 'protein-coding gene', 'ENSG00000153130'),
(6431, 10606, 'SCP2', 'sterol carrier protein 2', 'protein-coding gene', 'ENSG00000116171'),
(6432, 30377, 'SCRIB', 'scribble planar cell polarity protein', 'protein-coding gene', 'ENSG00000180900'),
(6433, 34223, 'SCYGR4', 'small cysteine and glycine repeat containing 4', 'protein-coding gene', 'ENSG00000284631'),
(6434, 34226, 'SCYGR7', 'small cysteine and glycine repeat containing 7', 'protein-coding gene', 'ENSG00000284718'),
(6435, 34219, 'SCYGR9', 'small cysteine and glycine repeat containing 9 (gene/pseudogene)', 'protein-coding gene', 'ENSG00000285843'),
(6436, 14372, 'SCYL1', 'SCY1 like pseudokinase 1', 'protein-coding gene', 'ENSG00000142186'),
(6437, 54685, 'SCYL2P1', 'SCYL2 pseudogene 1', 'pseudogene', 'ENSG00000213090'),
(6438, 25537, 'SDAD1', 'SDA1 domain containing 1', 'protein-coding gene', 'ENSG00000198301'),
(6439, 31403, 'SDAD1P1', 'SDA1 domain containing 1 pseudogene 1', 'pseudogene', 'ENSG00000228451'),
(6440, 39260, 'SDAD1P3', 'SDA1 domain containing 1 pseudogene 3', 'pseudogene', 'ENSG00000227707'),
(6441, 39261, 'SDAD1P4', 'SDA1 domain containing 1 pseudogene 4', 'pseudogene', 'ENSG00000236803'),
(6442, 15756, 'SDCBP2', 'syndecan binding protein 2', 'protein-coding gene', 'ENSG00000125775'),
(6443, 26643, 'SDE2', 'SDE2 telomere maintenance homolog', 'protein-coding gene', 'ENSG00000143751'),
(6444, 10675, 'SDF2', 'stromal cell derived factor 2', 'protein-coding gene', 'ENSG00000132581'),
(6445, 32455, 'SDHAP1', 'SDHA pseudogene 1', 'pseudogene', 'ENSG00000185485'),
(6446, 45179, 'SDHCP4', 'succinate dehydrogenase complex subunit C pseudogene 4', 'pseudogene', 'ENSG00000255035'),
(6447, 10684, 'SDHDP1', 'succinate dehydrogenase complex subunit D pseudogene 1', 'pseudogene', 'ENSG00000267162'),
(6448, 29958, 'SDR9C7', 'short chain dehydrogenase/reductase family 9C member 7', 'protein-coding gene', 'ENSG00000170426'),
(6449, 30311, 'SDR16C5', 'short chain dehydrogenase/reductase family 16C member 5', 'protein-coding gene', 'ENSG00000170786'),
(6450, 29834, 'SDR42E1', 'short chain dehydrogenase/reductase family 42E, member 1', 'protein-coding gene', 'ENSG00000184860'),
(6451, 32942, 'SEBOX', 'SEBOX homeobox', 'protein-coding gene', 'ENSG00000274529'),
(6452, 17718, 'SEC11A', 'SEC11 homolog A, signal peptidase complex subunit', 'protein-coding gene', 'ENSG00000140612'),
(6453, 44529, 'SEC13P1', 'SEC13 homolog, nuclear pore and COPII coat complex component pseudogene 1', 'pseudogene', 'ENSG00000223899'),
(6454, 18655, 'SEC14L3', 'SEC14 like lipid binding 3', 'protein-coding gene', 'ENSG00000100012'),
(6455, 29032, 'SEC14L5', 'SEC14 like lipid binding 5', 'protein-coding gene', 'ENSG00000103184'),
(6456, 29006, 'SEC16A', 'SEC16 homolog A, endoplasmic reticulum export factor', 'protein-coding gene', 'ENSG00000148396'),
(6457, 53767, 'SEC24AP1', 'SEC24 homolog A pseudogene 1', 'pseudogene', 'ENSG00000267361'),
(6458, 44003, 'SEC24B-AS1', 'SEC24B antisense RNA 1', 'non-coding RNA', 'ENSG00000247950'),
(6459, 23197, 'SEC31B', 'SEC31 homolog B, COPII coat complex component', 'protein-coding gene', 'ENSG00000075826'),
(6460, 54783, 'SEC61GP1', 'SEC61G pseudogene 1', 'pseudogene', 'ENSG00000224219'),
(6461, 53724, 'SELENOKP1', 'selenoprotein K pseudogene 1', 'pseudogene', 'ENSG00000267319'),
(6462, 53725, 'SELENOKP2', 'selenoprotein K pseudogene 2', 'pseudogene', 'ENSG00000219532'),
(6463, 30397, 'SELENOM', 'selenoprotein M', 'protein-coding gene', 'ENSG00000198832'),
(6464, 30395, 'SELENOO', 'selenoprotein O', 'protein-coding gene', 'ENSG00000073169'),
(6465, 10752, 'SELENOW', 'selenoprotein W', 'protein-coding gene', 'ENSG00000178980'),
(6466, 10721, 'SELP', 'selectin P', 'protein-coding gene', 'ENSG00000174175'),
(6467, 10723, 'SEMA3A', 'semaphorin 3A', 'protein-coding gene', 'ENSG00000075213'),
(6468, 30400, 'SEMA3G', 'semaphorin 3G', 'protein-coding gene', 'ENSG00000010319'),
(6469, 10729, 'SEMA4A', 'semaphorin 4A', 'protein-coding gene', 'ENSG00000196189'),
(6470, 10736, 'SEMA5A', 'semaphorin 5A', 'protein-coding gene', 'ENSG00000112902'),
(6471, 10737, 'SEMA5B', 'semaphorin 5B', 'protein-coding gene', 'ENSG00000082684'),
(6472, 10740, 'SEMA6C', 'semaphorin 6C', 'protein-coding gene', 'ENSG00000143434'),
(6473, 10741, 'SEMA7A', 'semaphorin 7A (John Milton Hagen blood group)', 'protein-coding gene', 'ENSG00000138623'),
(6474, 17862, 'SENP3', 'SUMO specific peptidase 3', 'protein-coding gene', 'ENSG00000161956'),
(6475, 20944, 'SENP6', 'SUMO specific peptidase 6', 'protein-coding gene', 'ENSG00000112701'),
(6476, 42161, 'SEPHS1P1', 'selenophosphate synthetase 1 pseudogene 1', 'pseudogene', 'ENSG00000182722'),
(6477, 42169, 'SEPHS1P4', 'selenophosphate synthetase 1 pseudogene 4', 'pseudogene', 'ENSG00000230146'),
(6478, 42168, 'SEPHS1P6', 'selenophosphate synthetase 1 pseudogene 6', 'pseudogene', 'ENSG00000213938'),
(6479, 51345, 'SEPTIN4-AS1', 'SEPTIN4 antisense RNA 1', 'non-coding RNA', 'ENSG00000264672'),
(6480, 19926, 'SEPTIN7P1', 'septin 7 pseudogene 1', 'pseudogene', 'ENSG00000259090'),
(6481, 38043, 'SEPTIN7P7', 'septin 7 pseudogene 7', 'pseudogene', 'ENSG00000229897'),
(6482, 55092, 'SEPTIN7P13', 'septin 7 pseudogene 13', 'pseudogene', 'ENSG00000185495'),
(6483, 51687, 'SEPTIN14P3', 'septin 14 pseudogene 3', 'pseudogene', 'ENSG00000226008'),
(6484, 51688, 'SEPTIN14P4', 'septin 14 pseudogene 4', 'pseudogene', 'ENSG00000251155'),
(6485, 44630, 'SERBP1P3', 'SERPINE1 mRNA binding protein 1 pseudogene 3', 'pseudogene', 'ENSG00000242142'),
(6486, 44631, 'SERBP1P4', 'SERPINE1 mRNA binding protein 1 pseudogene 4', 'pseudogene', 'ENSG00000230275'),
(6487, 10755, 'SERF1A', 'small EDRK-rich factor 1A', 'protein-coding gene', 'ENSG00000172058'),
(6488, 10756, 'SERF1B', 'small EDRK-rich factor 1B', 'protein-coding gene', 'ENSG00000205572'),
(6489, 10757, 'SERF2', 'small EDRK-rich factor 2', 'protein-coding gene', 'ENSG00000140264'),
(6490, 10759, 'SERP1', 'stress associated endoplasmic reticulum protein 1', 'protein-coding gene', 'ENSG00000120742'),
(6491, 8941, 'SERPINA1', 'serpin family A member 1', 'protein-coding gene', 'ENSG00000197249'),
(6492, 16, 'SERPINA3', 'serpin family A member 3', 'protein-coding gene', 'ENSG00000196136'),
(6493, 11583, 'SERPINA7', 'serpin family A member 7', 'protein-coding gene', 'ENSG00000123561'),
(6494, 3311, 'SERPINB1', 'serpin family B member 1', 'protein-coding gene', 'ENSG00000021355'),
(6495, 10569, 'SERPINB3', 'serpin family B member 3', 'protein-coding gene', 'ENSG00000057149'),
(6496, 8583, 'SERPINE1', 'serpin family E member 1', 'protein-coding gene', 'ENSG00000106366'),
(6497, 8951, 'SERPINE2', 'serpin family E member 2', 'protein-coding gene', 'ENSG00000135919'),
(6498, 24774, 'SERPINE3', 'serpin family E member 3', 'protein-coding gene', 'ENSG00000253309'),
(6499, 17931, 'SERTAD3', 'SERTA domain containing 3', 'protein-coding gene', 'ENSG00000167565'),
(6500, 32019, 'SERTAD4-AS1', 'SERTAD4 antisense RNA 1', 'non-coding RNA', 'ENSG00000203706'),
(6501, 15573, 'SETBP1', 'SET binding protein 1', 'protein-coding gene', 'ENSG00000152217'),
(6502, 29187, 'SETD1B', 'SET domain containing 1B, histone lysine methyltransferase', 'protein-coding gene', 'ENSG00000139718'),
(6503, 10761, 'SETDB1', 'SET domain bifurcated histone lysine methyltransferase 1', 'protein-coding gene', 'ENSG00000143379'),
(6504, 20032, 'SETP2', 'SET pseudogene 2', 'pseudogene', 'ENSG00000258893'),
(6505, 42929, 'SETP10', 'SET pseudogene 10', 'pseudogene', 'ENSG00000231905'),
(6506, 42930, 'SETP11', 'SET pseudogene 11', 'pseudogene', 'ENSG00000239570'),
(6507, 42937, 'SETSIP', 'SET like protein', 'protein-coding gene', 'ENSG00000230667'),
(6508, 10763, 'SEZ6L', 'seizure related 6 homolog like', 'protein-coding gene', 'ENSG00000100095'),
(6509, 10767, 'SF3A3', 'splicing factor 3a subunit 3', 'protein-coding gene', 'ENSG00000183431'),
(6510, 10771, 'SF3B4', 'splicing factor 3b subunit 4', 'protein-coding gene', 'ENSG00000143368'),
(6511, 21083, 'SF3B5', 'splicing factor 3b subunit 5', 'protein-coding gene', 'ENSG00000169976'),
(6512, 30096, 'SF3B6', 'splicing factor 3b subunit 6', 'protein-coding gene', 'ENSG00000115128'),
(6513, 29574, 'SFR1', 'SWI5 dependent homologous recombination repair protein 1', 'protein-coding gene', 'ENSG00000156384'),
(6514, 51532, 'SFR1P2', 'SFR1 pseudogene 2', 'pseudogene', 'ENSG00000223707'),
(6515, 18387, 'SFTA3', 'surfactant associated 3', 'other', 'ENSG00000229415'),
(6516, 51589, 'SFTPD-AS1', 'SFTPD antisense RNA 1', 'non-coding RNA', 'ENSG00000273372'),
(6517, 10812, 'SGK3', 'serum/glucocorticoid regulated kinase family member 3', 'protein-coding gene', 'ENSG00000104205'),
(6518, 25088, 'SGO1', 'shugoshin 1', 'protein-coding gene', 'ENSG00000129810'),
(6519, 50776, 'SGO1P1', 'shugoshin 1 pseudogene 1', 'pseudogene', 'ENSG00000270615'),
(6520, 19953, 'SGPP2', 'sphingosine-1-phosphate phosphatase 2', 'protein-coding gene', 'ENSG00000163082'),
(6521, 10818, 'SGSH', 'N-sulfoglucosamine sulfohydrolase', 'protein-coding gene', 'ENSG00000181523'),
(6522, 29410, 'SGSM1', 'small G protein signaling modulator 1', 'protein-coding gene', 'ENSG00000167037'),
(6523, 56091, 'SGSM2-AS1', 'SGSM2 antisense RNA 1', 'non-coding RNA', 'ENSG00000263345'),
(6524, 30416, 'SH2D1B', 'SH2 domain containing 1B', 'protein-coding gene', 'ENSG00000198574'),
(6525, 26102, 'SH2D4A', 'SH2 domain containing 4A', 'protein-coding gene', 'ENSG00000104611'),
(6526, 10824, 'SH3BP1', 'SH3 domain binding protein 1', 'protein-coding gene', 'ENSG00000100092'),
(6527, 10826, 'SH3BP4', 'SH3 domain binding protein 4', 'protein-coding gene', 'ENSG00000130147'),
(6528, 44501, 'SH3BP5-AS1', 'SH3BP5 antisense RNA 1', 'non-coding RNA', 'ENSG00000224660'),
(6529, 30418, 'SH3D19', 'SH3 domain containing 19', 'protein-coding gene', 'ENSG00000109686'),
(6530, 26236, 'SH3D21', 'SH3 domain containing 21', 'protein-coding gene', 'ENSG00000214193'),
(6531, 10832, 'SH3GL3', 'SH3 domain containing GRB2 like 3, endophilin A3', 'protein-coding gene', 'ENSG00000140600'),
(6532, 10834, 'SH3GLB2', 'SH3 domain containing GRB2 like, endophilin B2', 'protein-coding gene', 'ENSG00000148341'),
(6533, 23664, 'SH3PXD2A', 'SH3 and PX domains 2A', 'protein-coding gene', 'ENSG00000107957'),
(6534, 14295, 'SHANK2', 'SH3 and multiple ankyrin repeat domains 2', 'protein-coding gene', 'ENSG00000162105'),
(6535, 25649, 'SHFL', 'shiftless antiviral inhibitor of ribosomal frameshifting', 'protein-coding gene', 'ENSG00000130813'),
(6536, 27139, 'SHISA4', 'shisa family member 4', 'protein-coding gene', 'ENSG00000198892'),
(6537, 35409, 'SHISA7', 'shisa family member 7', 'protein-coding gene', 'ENSG00000187902'),
(6538, 19214, 'SHKBP1', 'SH3KBP1 binding protein 1', 'protein-coding gene', 'ENSG00000160410'),
(6539, 26318, 'SHLD1', 'shieldin complex subunit 1', 'protein-coding gene', 'ENSG00000171984'),
(6540, 10851, 'SHMT1P1', 'serine hydroxymethyltransferase 1 (soluble) pseudogene 1', 'pseudogene', 'ENSG00000224751'),
(6541, 26535, 'SHOC1', 'shortage in chiasmata 1', 'protein-coding gene', 'ENSG00000165181'),
(6542, 1492, 'SHPK', 'sedoheptulokinase', 'protein-coding gene', 'ENSG00000197417'),
(6543, 19336, 'SHPRH', 'SNF2 histone linker PHD RING helicase', 'protein-coding gene', 'ENSG00000146414'),
(6544, 630, 'SHROOM2', 'shroom family member 2', 'protein-coding gene', 'ENSG00000146950'),
(6545, 29319, 'SHTN1', 'shootin 1', 'protein-coding gene', 'ENSG00000187164'),
(6546, 30966, 'SIAH1P1', 'siah E3 ubiquitin protein ligase 1 pseudogene 1', 'pseudogene', 'ENSG00000230227'),
(6547, 30553, 'SIAH3', 'siah E3 ubiquitin protein ligase family member 3', 'protein-coding gene', 'ENSG00000215475'),
(6548, 10874, 'SIGLEC5', 'sialic acid binding Ig like lectin 5', 'protein-coding gene', 'ENSG00000105501'),
(6549, 15482, 'SIGLEC12', 'sialic acid binding Ig like lectin 12', 'protein-coding gene', 'ENSG00000254521'),
(6550, 27596, 'SIGLEC15', 'sialic acid binding Ig like lectin 15', 'protein-coding gene', 'ENSG00000197046'),
(6551, 24851, 'SIGLEC16', 'sialic acid binding Ig like lectin 16', 'protein-coding gene', 'ENSG00000161643'),
(6552, 26856, 'SIGLECL1', 'SIGLEC family like 1', 'protein-coding gene', 'ENSG00000179213'),
(6553, 29165, 'SIK3', 'SIK family kinase 3', 'protein-coding gene', 'ENSG00000160584'),
(6554, 24779, 'SIMC1', 'SUMO interacting motifs containing 1', 'protein-coding gene', 'ENSG00000170085'),
(6555, 53902, 'SIRLNT', 'SIRT1 regulating lncRNA tumor promoter', 'non-coding RNA', 'ENSG00000253802'),
(6556, 9662, 'SIRPA', 'signal regulatory protein alpha', 'protein-coding gene', 'ENSG00000198053'),
(6557, 9663, 'SIRPAP1', 'signal regulatory protein alpha pseudogene 1', 'pseudogene', 'ENSG00000225774'),
(6558, 15757, 'SIRPG', 'signal regulatory protein gamma', 'protein-coding gene', 'ENSG00000089012'),
(6559, 14929, 'SIRT1', 'sirtuin 1', 'protein-coding gene', 'ENSG00000096717'),
(6560, 14935, 'SIRT7', 'sirtuin 7', 'protein-coding gene', 'ENSG00000187531'),
(6561, 10888, 'SIX2', 'SIX homeobox 2', 'protein-coding gene', 'ENSG00000170577'),
(6562, 10891, 'SIX5', 'SIX homeobox 5', 'protein-coding gene', 'ENSG00000177045'),
(6563, 28006, 'SKA2', 'spindle and kinetochore associated complex subunit 2', 'protein-coding gene', 'ENSG00000182628'),
(6564, 15605, 'SKAP1', 'src kinase associated phosphoprotein 1', 'protein-coding gene', 'ENSG00000141293'),
(6565, 15687, 'SKAP2', 'src kinase associated phosphoprotein 2', 'protein-coding gene', 'ENSG00000005020'),
(6566, 32697, 'SKIDA1', 'SKI/DACH domain containing 1', 'protein-coding gene', 'ENSG00000180592'),
(6567, 50370, 'SKP1P3', 'S-phase kinase associated protein 1 pseudogene 3', 'pseudogene', 'ENSG00000229707'),
(6568, 10901, 'SKP2', 'S-phase kinase associated protein 2', 'protein-coding gene', 'ENSG00000145604'),
(6569, 17329, 'SLA2', 'Src like adaptor 2', 'protein-coding gene', 'ENSG00000101082'),
(6570, 29282, 'SLAIN2', 'SLAIN motif family member 2', 'protein-coding gene', 'ENSG00000109171'),
(6571, 10903, 'SLAMF1', 'signaling lymphocytic activation molecule family member 1', 'protein-coding gene', 'ENSG00000117090'),
(6572, 10939, 'SLC1A1', 'solute carrier family 1 member 1', 'protein-coding gene', 'ENSG00000106688'),
(6573, 10944, 'SLC1A6', 'solute carrier family 1 member 6', 'protein-coding gene', 'ENSG00000105143'),
(6574, 10945, 'SLC1A7', 'solute carrier family 1 member 7', 'protein-coding gene', 'ENSG00000162383'),
(6575, 44187, 'SLC2A1-DT', 'SLC2A1 divergent transcript', 'non-coding RNA', 'ENSG00000227533'),
(6576, 31076, 'SLC2A3P4', 'solute carrier family 2 member 3 pseudogene 4', 'pseudogene', 'ENSG00000254088'),
(6577, 11011, 'SLC2A6', 'solute carrier family 2 member 6', 'protein-coding gene', 'ENSG00000160326'),
(6578, 13445, 'SLC2A7', 'solute carrier family 2 member 7', 'protein-coding gene', 'ENSG00000197241'),
(6579, 13812, 'SLC2A8', 'solute carrier family 2 member 8', 'protein-coding gene', 'ENSG00000136856'),
(6580, 13444, 'SLC2A10', 'solute carrier family 2 member 10', 'protein-coding gene', 'ENSG00000197496'),
(6581, 11026, 'SLC3A2', 'solute carrier family 3 member 2', 'protein-coding gene', 'ENSG00000168003'),
(6582, 11030, 'SLC4A4', 'solute carrier family 4 member 4', 'protein-coding gene', 'ENSG00000080493'),
(6583, 11034, 'SLC4A8', 'solute carrier family 4 member 8', 'protein-coding gene', 'ENSG00000050438'),
(6584, 11035, 'SLC4A9', 'solute carrier family 4 member 9', 'protein-coding gene', 'ENSG00000113073'),
(6585, 11038, 'SLC5A3', 'solute carrier family 5 member 3', 'protein-coding gene', 'ENSG00000198743'),
(6586, 45041, 'SLC5A4P1', 'solute carrier family 5 member 4 pseudogene 1', 'pseudogene', 'ENSG00000255116'),
(6587, 22146, 'SLC5A9', 'solute carrier family 5 member 9', 'protein-coding gene', 'ENSG00000117834'),
(6588, 11052, 'SLC6A6', 'solute carrier family 6 member 6', 'protein-coding gene', 'ENSG00000131389'),
(6589, 11053, 'SLC6A6P1', 'solute carrier family 6 member 6 pseudogene 1', 'pseudogene', 'ENSG00000226818'),
(6590, 11043, 'SLC6A10P', 'solute carrier family 6 member 10, pseudogene', 'pseudogene', 'ENSG00000214617'),
(6591, 54530, 'SLC6A14P2', 'SLC6A14 pseudogene 2', 'pseudogene', 'ENSG00000237860'),
(6592, 54531, 'SLC6A14P3', 'SLC6A14 pseudogene 3', 'pseudogene', 'ENSG00000236655'),
(6593, 11057, 'SLC7A1', 'solute carrier family 7 member 1', 'protein-coding gene', 'ENSG00000139514'),
(6594, 54925, 'SLC7A2-IT1', 'SLC7A2 intronic transcript 1', 'non-coding RNA', 'ENSG00000279903'),
(6595, 11065, 'SLC7A7', 'solute carrier family 7 member 7', 'protein-coding gene', 'ENSG00000155465'),
(6596, 23092, 'SLC7A13', 'solute carrier family 7 member 13', 'protein-coding gene', 'ENSG00000164893'),
(6597, 19325, 'SLC9A3P2', 'solute carrier family 9 member 3 pseudogene 2', 'pseudogene', 'ENSG00000238125'),
(6598, 40928, 'SLC9A9-AS1', 'SLC9A9 antisense RNA 1', 'non-coding RNA', 'ENSG00000240012');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(6599, 37493, 'SLC9B1P2', 'solute carrier family 9 member B1 pseudogene 2', 'pseudogene', 'ENSG00000214329'),
(6600, 31401, 'SLC9C1', 'solute carrier family 9 member C1', 'protein-coding gene', 'ENSG00000172139'),
(6601, 10906, 'SLC10A2', 'solute carrier family 10 member 2', 'protein-coding gene', 'ENSG00000125255'),
(6602, 53143, 'SLC12A5-AS1', 'SLC12A5 and MMP9 antisense RNA 1', 'non-coding RNA', 'ENSG00000204044'),
(6603, 10914, 'SLC12A6', 'solute carrier family 12 member 6', 'protein-coding gene', 'ENSG00000140199'),
(6604, 10915, 'SLC12A7', 'solute carrier family 12 member 7', 'protein-coding gene', 'ENSG00000113504'),
(6605, 40807, 'SLC12A9-AS1', 'SLC12A9 antisense RNA 1', 'non-coding RNA', 'ENSG00000236305'),
(6606, 10919, 'SLC14A2', 'solute carrier family 14 member 2', 'protein-coding gene', 'ENSG00000132874'),
(6607, 18068, 'SLC15A3', 'solute carrier family 15 member 3', 'protein-coding gene', 'ENSG00000110446'),
(6608, 10924, 'SLC16A3', 'solute carrier family 16 member 3', 'protein-coding gene', 'ENSG00000141526'),
(6609, 10928, 'SLC16A7', 'solute carrier family 16 member 7', 'protein-coding gene', 'ENSG00000118596'),
(6610, 16270, 'SLC16A8', 'solute carrier family 16 member 8', 'protein-coding gene', 'ENSG00000100156'),
(6611, 10931, 'SLC17A3', 'solute carrier family 17 member 3', 'protein-coding gene', 'ENSG00000124564'),
(6612, 10946, 'SLC20A1', 'solute carrier family 20 member 1', 'protein-coding gene', 'ENSG00000144136'),
(6613, 10967, 'SLC22A3', 'solute carrier family 22 member 3', 'protein-coding gene', 'ENSG00000146477'),
(6614, 18120, 'SLC22A11', 'solute carrier family 22 member 11', 'protein-coding gene', 'ENSG00000168065'),
(6615, 8494, 'SLC22A13', 'solute carrier family 22 member 13', 'protein-coding gene', 'ENSG00000172940'),
(6616, 20302, 'SLC22A16', 'solute carrier family 22 member 16', 'protein-coding gene', 'ENSG00000004809'),
(6617, 29867, 'SLC22A20P', 'solute carrier family 22 member 20, pseudogene', 'pseudogene', 'ENSG00000197847'),
(6618, 21106, 'SLC22A23', 'solute carrier family 22 member 23', 'protein-coding gene', 'ENSG00000137266'),
(6619, 20601, 'SLC23A3', 'solute carrier family 23 member 3', 'protein-coding gene', 'ENSG00000213901'),
(6620, 20602, 'SLC23A4P', 'solute carrier family 23 member 4, pseudogene', 'pseudogene', 'ENSG00000276067'),
(6621, 10979, 'SLC25A1', 'solute carrier family 25 member 1', 'protein-coding gene', 'ENSG00000100075'),
(6622, 43845, 'SLC25A1P1', 'solute carrier family 25 member 1 pseudogene 1', 'pseudogene', 'ENSG00000254479'),
(6623, 22921, 'SLC25A2', 'solute carrier family 25 member 2', 'protein-coding gene', 'ENSG00000120329'),
(6624, 43784, 'SLC25A3P2', 'solute carrier family 25 member 3 pseudogene 2', 'pseudogene', 'ENSG00000258373'),
(6625, 10990, 'SLC25A4', 'solute carrier family 25 member 4', 'protein-coding gene', 'ENSG00000151729'),
(6626, 507, 'SLC25A5P3', 'solute carrier family 25 member 5 pseudogene 3', 'pseudogene', 'ENSG00000213673'),
(6627, 512, 'SLC25A5P6', 'solute carrier family 25 member 5 pseudogene 6', 'pseudogene', 'ENSG00000213332'),
(6628, 10980, 'SLC25A10', 'solute carrier family 25 member 10', 'protein-coding gene', 'ENSG00000183048'),
(6629, 10984, 'SLC25A14', 'solute carrier family 25 member 14', 'protein-coding gene', 'ENSG00000102078'),
(6630, 43857, 'SLC25A18P1', 'solute carrier family 25 member 18 pseudogene 1', 'pseudogene', 'ENSG00000234309'),
(6631, 20663, 'SLC25A25', 'solute carrier family 25 member 25', 'protein-coding gene', 'ENSG00000148339'),
(6632, 55979, 'SLC25A28-DT', 'SLC25A28 divergent transcript', 'non-coding RNA', 'ENSG00000260475'),
(6633, 29683, 'SLC25A32', 'solute carrier family 25 member 32', 'protein-coding gene', 'ENSG00000164933'),
(6634, 53623, 'SLC25A34-AS1', 'SLC25A34 and TMEM82 antisense RNA 1', 'non-coding RNA', 'ENSG00000224459'),
(6635, 43858, 'SLC25A38P1', 'solute carrier family 25 member 38 pseudogene 1', 'pseudogene', 'ENSG00000229785'),
(6636, 23323, 'SLC25A51', 'solute carrier family 25 member 51', 'protein-coding gene', 'ENSG00000122696'),
(6637, 23325, 'SLC25A51P1', 'SLC25A51 pseudogene 1', 'pseudogene', 'ENSG00000220483'),
(6638, 22385, 'SLC26A4-AS1', 'SLC26A4 antisense RNA 1', 'non-coding RNA', 'ENSG00000233705'),
(6639, 14468, 'SLC26A8', 'solute carrier family 26 member 8', 'protein-coding gene', 'ENSG00000112053'),
(6640, 14469, 'SLC26A9', 'solute carrier family 26 member 9', 'protein-coding gene', 'ENSG00000174502'),
(6641, 10995, 'SLC27A1', 'solute carrier family 27 member 1', 'protein-coding gene', 'ENSG00000130304'),
(6642, 55417, 'SLC28A2-AS1', 'SLC28A2 antisense RNA 1', 'non-coding RNA', 'ENSG00000259520'),
(6643, 11003, 'SLC29A1', 'solute carrier family 29 member 1 (Augustine blood group)', 'protein-coding gene', 'ENSG00000112759'),
(6644, 19089, 'SLC30A5', 'solute carrier family 30 member 5', 'protein-coding gene', 'ENSG00000145740'),
(6645, 55203, 'SLC30A6-DT', 'SLC30A6 divergent transcript', 'non-coding RNA', 'ENSG00000272716'),
(6646, 19306, 'SLC30A7', 'solute carrier family 30 member 7', 'protein-coding gene', 'ENSG00000162695'),
(6647, 11016, 'SLC31A1', 'solute carrier family 31 member 1', 'protein-coding gene', 'ENSG00000136868'),
(6648, 11018, 'SLC32A1', 'solute carrier family 32 member 1', 'protein-coding gene', 'ENSG00000101438'),
(6649, 11019, 'SLC34A1', 'solute carrier family 34 member 1', 'protein-coding gene', 'ENSG00000131183'),
(6650, 11021, 'SLC35A1', 'solute carrier family 35 member A1', 'protein-coding gene', 'ENSG00000164414'),
(6651, 20792, 'SLC35A5', 'solute carrier family 35 member A5', 'protein-coding gene', 'ENSG00000138459'),
(6652, 54894, 'SLC35C2P1', 'SLC35C2 pseudogene 1', 'pseudogene', 'ENSG00000223498'),
(6653, 15621, 'SLC35D3', 'solute carrier family 35 member D3', 'protein-coding gene', 'ENSG00000182747'),
(6654, 17058, 'SLC35E4', 'solute carrier family 35 member E4', 'protein-coding gene', 'ENSG00000100036'),
(6655, 23616, 'SLC35F3', 'solute carrier family 35 member F3', 'protein-coding gene', 'ENSG00000183780'),
(6656, 31043, 'SLC35G4', 'solute carrier family 35 member G4', 'protein-coding gene', 'ENSG00000236396'),
(6657, 20644, 'SLC37A2', 'solute carrier family 37 member 2', 'protein-coding gene', 'ENSG00000134955'),
(6658, 13448, 'SLC38A2', 'solute carrier family 38 member 2', 'protein-coding gene', 'ENSG00000134294'),
(6659, 18070, 'SLC38A5', 'solute carrier family 38 member 5', 'protein-coding gene', 'ENSG00000017483'),
(6660, 26907, 'SLC38A9', 'solute carrier family 38 member 9', 'protein-coding gene', 'ENSG00000177058'),
(6661, 12876, 'SLC39A1', 'solute carrier family 39 member 1', 'protein-coding gene', 'ENSG00000143570'),
(6662, 17127, 'SLC39A2', 'solute carrier family 39 member 2', 'protein-coding gene', 'ENSG00000165794'),
(6663, 20182, 'SLC39A9', 'solute carrier family 39 member 9', 'protein-coding gene', 'ENSG00000029364'),
(6664, 44881, 'SLC39A12-AS1', 'SLC39A12 antisense RNA 1', 'non-coding RNA', 'ENSG00000226083'),
(6665, 20859, 'SLC39A13', 'solute carrier family 39 member 13', 'protein-coding gene', 'ENSG00000165915'),
(6666, 10909, 'SLC40A1', 'solute carrier family 40 member 1', 'protein-coding gene', 'ENSG00000138449'),
(6667, 17292, 'SLC44A2', 'solute carrier family 44 member 2', 'protein-coding gene', 'ENSG00000129353'),
(6668, 49057, 'SLC44A3-AS1', 'SLC44A3 antisense RNA 1', 'non-coding RNA', 'ENSG00000224081'),
(6669, 16472, 'SLC45A2', 'solute carrier family 45 member 2', 'protein-coding gene', 'ENSG00000164175'),
(6670, 29196, 'SLC45A4', 'solute carrier family 45 member 4', 'protein-coding gene', 'ENSG00000022567'),
(6671, 27501, 'SLC46A3', 'solute carrier family 46 member 3', 'protein-coding gene', 'ENSG00000139508'),
(6672, 51849, 'SLC47A1P1', 'SLC47A1 pseudogene 1', 'pseudogene', 'ENSG00000228983'),
(6673, 26177, 'SLC49A3', 'solute carrier family 49 member 3', 'protein-coding gene', 'ENSG00000169026'),
(6674, 43986, 'SLC66A2P1', 'SLC66A2 pseudogene 1', 'pseudogene', 'ENSG00000231763'),
(6675, 13819, 'SLCO1C1', 'solute carrier organic anion transporter family member 1C1', 'protein-coding gene', 'ENSG00000139155'),
(6676, 23612, 'SLCO4C1', 'solute carrier organic anion transporter family member 4C1', 'protein-coding gene', 'ENSG00000173930'),
(6677, 26313, 'SLFNL1', 'schlafen like 1', 'protein-coding gene', 'ENSG00000171790'),
(6678, 55149, 'SLIRPP1', 'SLIRP. pseudogene 1', 'pseudogene', 'ENSG00000227505'),
(6679, 11086, 'SLIT2', 'slit guidance ligand 2', 'protein-coding gene', 'ENSG00000145147'),
(6680, 20297, 'SLITRK1', 'SLIT and NTRK like family member 1', 'protein-coding gene', 'ENSG00000178235'),
(6681, 13449, 'SLITRK2', 'SLIT and NTRK like family member 2', 'protein-coding gene', 'ENSG00000185985'),
(6682, 11089, 'SLN', 'sarcolipin', 'protein-coding gene', 'ENSG00000170290'),
(6683, 11092, 'SLPI', 'secretory leukocyte peptidase inhibitor', 'protein-coding gene', 'ENSG00000124107'),
(6684, 20709, 'SLTM', 'SAFB like transcription modulator', 'protein-coding gene', 'ENSG00000137776'),
(6685, 6767, 'SMAD1', 'SMAD family member 1', 'protein-coding gene', 'ENSG00000170365'),
(6686, 6770, 'SMAD4', 'SMAD family member 4', 'protein-coding gene', 'ENSG00000141646'),
(6687, 6774, 'SMAD9', 'SMAD family member 9', 'protein-coding gene', 'ENSG00000120693'),
(6688, 11098, 'SMARCA2', 'SWI/SNF related, matrix associated, actin dependent regulator of chromatin, subfamily a, member 2', 'protein-coding gene', 'ENSG00000080503'),
(6689, 11100, 'SMARCA4', 'SWI/SNF related, matrix associated, actin dependent regulator of chromatin, subfamily a, member 4', 'protein-coding gene', 'ENSG00000127616'),
(6690, 11103, 'SMARCB1', 'SWI/SNF related, matrix associated, actin dependent regulator of chromatin, subfamily b, member 1', 'protein-coding gene', 'ENSG00000099956'),
(6691, 11108, 'SMARCD3', 'SWI/SNF related, matrix associated, actin dependent regulator of chromatin, subfamily d, member 3', 'protein-coding gene', 'ENSG00000082014'),
(6692, 39735, 'SMARCE1P4', 'SWI/SNF related, matrix associated, actin dependent regulator of chromatin, subfamily e, member 1 pseudogene 4', 'pseudogene', 'ENSG00000253650'),
(6693, 39737, 'SMARCE1P6', 'SWI/SNF related, matrix associated, actin dependent regulator of chromatin, subfamily e, member 1 pseudogene 6', 'pseudogene', 'ENSG00000214465'),
(6694, 14011, 'SMC2', 'structural maintenance of chromosomes 2', 'protein-coding gene', 'ENSG00000136824'),
(6695, 34448, 'SMCO2', 'single-pass membrane protein with coiled-coil domains 2', 'protein-coding gene', 'ENSG00000165935'),
(6696, 34401, 'SMCO3', 'single-pass membrane protein with coiled-coil domains 3', 'protein-coding gene', 'ENSG00000179256'),
(6697, 49559, 'SMCO4P1', 'single-pass membrane protein with coiled-coil domains 4 pseudogene 1', 'pseudogene', 'ENSG00000267384'),
(6698, 55394, 'SMG1-DT', 'SMG1 divergent transcript', 'non-coding RNA', 'ENSG00000260352'),
(6699, 44186, 'SMG1P1', 'SMG1 pseudogene 1', 'pseudogene', 'ENSG00000237296'),
(6700, 49859, 'SMG1P2', 'SMG1 pseudogene 2', 'pseudogene', 'ENSG00000205534'),
(6701, 49862, 'SMG1P5', 'SMG1 pseudogene 5', 'pseudogene', 'ENSG00000183604'),
(6702, 17809, 'SMG6', 'SMG6 nonsense mediated mRNA decay factor', 'protein-coding gene', 'ENSG00000070366'),
(6703, 28776, 'SMIM2', 'small integral membrane protein 2', 'protein-coding gene', 'ENSG00000139656'),
(6704, 37257, 'SMIM4', 'small integral membrane protein 4', 'protein-coding gene', 'ENSG00000168273'),
(6705, 40032, 'SMIM6', 'small integral membrane protein 6', 'protein-coding gene', 'ENSG00000259120'),
(6706, 41913, 'SMIM10', 'small integral membrane protein 10', 'protein-coding gene', 'ENSG00000184785'),
(6707, 49847, 'SMIM10L1', 'small integral membrane protein 10 like 1', 'protein-coding gene', 'ENSG00000256537'),
(6708, 53137, 'SMIM10L2B-AS1', 'SMIM10L2B antisense RNA 1', 'non-coding RNA', 'ENSG00000228372'),
(6709, 21400, 'SMIM11P1', 'small integral membrane protein 11 pseudogene 1', 'pseudogene', 'ENSG00000198738'),
(6710, 25154, 'SMIM12', 'small integral membrane protein 12', 'protein-coding gene', 'ENSG00000163866'),
(6711, 51598, 'SMIM12P1', 'small integral membrane protein 12 pseudogene 1', 'pseudogene', 'ENSG00000271284'),
(6712, 53455, 'SMIM14-DT', 'SMIM14 divergent transcript', 'non-coding RNA', 'ENSG00000255458'),
(6713, 33861, 'SMIM15', 'small integral membrane protein 15', 'protein-coding gene', 'ENSG00000188725'),
(6714, 27114, 'SMIM17', 'small integral membrane protein 17', 'protein-coding gene', 'ENSG00000268182'),
(6715, 42973, 'SMIM18', 'small integral membrane protein 18', 'protein-coding gene', 'ENSG00000253457'),
(6716, 39601, 'SMIM34', 'small integral membrane protein 34', 'protein-coding gene', 'ENSG00000243627'),
(6717, 44179, 'SMIM35', 'small integral membrane protein 35', 'protein-coding gene', 'ENSG00000255274'),
(6718, 54075, 'SMIM41', 'small integral membrane protein 41', 'protein-coding gene', 'ENSG00000284791'),
(6719, 11120, 'SMPD1', 'sphingomyelin phosphodiesterase 1', 'protein-coding gene', 'ENSG00000166311'),
(6720, 52275, 'SMPD5', 'sphingomyelin phosphodiesterase 5 (pseudogene)', 'pseudogene', 'ENSG00000204791'),
(6721, 32394, 'SMTNL1', 'smoothelin like 1', 'protein-coding gene', 'ENSG00000214872'),
(6722, 20986, 'SMYD1', 'SET and MYND domain containing 1', 'protein-coding gene', 'ENSG00000115593'),
(6723, 21067, 'SMYD4', 'SET and MYND domain containing 4', 'protein-coding gene', 'ENSG00000186532'),
(6724, 11128, 'SNAI1', 'snail family transcriptional repressor 1', 'protein-coding gene', 'ENSG00000124216'),
(6725, 11129, 'SNAI1P1', 'snail family zinc finger 1 pseudogene 1', 'pseudogene', 'ENSG00000237194'),
(6726, 11094, 'SNAI2', 'snail family transcriptional repressor 2', 'protein-coding gene', 'ENSG00000019549'),
(6727, 28327, 'SNAI3-AS1', 'SNAI3 antisense RNA 1', 'non-coding RNA', 'ENSG00000260630'),
(6728, 11132, 'SNAP25', 'synaptosome associated protein 25', 'protein-coding gene', 'ENSG00000132639'),
(6729, 41501, 'SNAP47-AS1', 'SNAP47 antisense RNA 1', 'non-coding RNA', 'ENSG00000230005'),
(6730, 15484, 'SNAPC5', 'small nuclear RNA activating complex polypeptide 5', 'protein-coding gene', 'ENSG00000174446'),
(6731, 11138, 'SNCA', 'synuclein alpha', 'protein-coding gene', 'ENSG00000145335'),
(6732, 11141, 'SNCG', 'synuclein gamma', 'protein-coding gene', 'ENSG00000173267'),
(6733, 55639, 'SND1-DT', 'SND1 divergent transcript', 'non-coding RNA', 'ENSG00000240790'),
(6734, 41060, 'SNED1-AS1', 'SNED1 antisense RNA 1', 'non-coding RNA', 'ENSG00000225521'),
(6735, 32964, 'SNHG4', 'small nucleolar RNA host gene 4', 'non-coding RNA', 'ENSG00000281398'),
(6736, 25046, 'SNHG11', 'small nucleolar RNA host gene 11', 'non-coding RNA', 'ENSG00000174365'),
(6737, 49574, 'SNHG19', 'small nucleolar RNA host gene 19', 'non-coding RNA', 'ENSG00000260260'),
(6738, 50285, 'SNHG22', 'small nucleolar RNA host gene 22', 'non-coding RNA', 'ENSG00000267322'),
(6739, 51534, 'SNHG25', 'small nucleolar RNA host gene 25', 'non-coding RNA', 'ENSG00000266402'),
(6740, 53131, 'SNHG26', 'small nucleolar RNA host gene 26', 'non-coding RNA', 'ENSG00000228649'),
(6741, 52836, 'SNHG30', 'small nucleolar RNA host gene 30', 'non-coding RNA', 'ENSG00000267321'),
(6742, 19078, 'SNHG32', 'small nucleolar RNA host gene 32', 'non-coding RNA', 'ENSG00000204387'),
(6743, 32584, 'SNORA2A', 'small nucleolar RNA, H/ACA box 2A', 'non-coding RNA', 'ENSG00000206612'),
(6744, 32589, 'SNORA5B', 'small nucleolar RNA, H/ACA box 5B', 'non-coding RNA', 'ENSG00000200656'),
(6745, 32598, 'SNORA10', 'small nucleolar RNA, H/ACA box 10', 'non-coding RNA', 'ENSG00000206811'),
(6746, 33622, 'SNORA11D', 'small nucleolar RNA, H/ACA box 11D', 'non-coding RNA', 'ENSG00000221475'),
(6747, 32600, 'SNORA12', 'small nucleolar RNA, H/ACA box 12', 'non-coding RNA', 'ENSG00000212464'),
(6748, 32601, 'SNORA13', 'small nucleolar RNA, H/ACA box 13', 'non-coding RNA', 'ENSG00000238363'),
(6749, 32636, 'SNORA17B', 'small nucleolar RNA, H/ACA box 17B', 'non-coding RNA', 'ENSG00000276161'),
(6750, 32609, 'SNORA19', 'small nucleolar RNA, H/ACA box 19', 'non-coding RNA', 'ENSG00000207468'),
(6751, 52196, 'SNORA22B', 'small nucleolar RNA, H/ACA box 22B', 'non-coding RNA', 'ENSG00000206603'),
(6752, 32615, 'SNORA25', 'small nucleolar RNA, H/ACA box 25', 'non-coding RNA', 'ENSG00000207112'),
(6753, 32620, 'SNORA30', 'small nucleolar RNA, H/ACA box 30', 'non-coding RNA', 'ENSG00000206755'),
(6754, 33616, 'SNORA36C', 'small nucleolar RNA, H/ACA box 36C', 'non-coding RNA', 'ENSG00000207016'),
(6755, 33617, 'SNORA38B', 'small nucleolar RNA, H/ACA box 38B', 'non-coding RNA', 'ENSG00000200394'),
(6756, 52205, 'SNORA40C', 'small nucleolar RNA, H/ACA box 40C', 'non-coding RNA', 'ENSG00000212587'),
(6757, 52206, 'SNORA41B', 'small nucleolar RNA, H/ACA box 41B', 'non-coding RNA', 'ENSG00000207516'),
(6758, 32637, 'SNORA44', 'small nucleolar RNA, H/ACA box 44', 'non-coding RNA', 'ENSG00000273544'),
(6759, 32639, 'SNORA46', 'small nucleolar RNA, H/ACA box 46', 'non-coding RNA', 'ENSG00000207493'),
(6760, 32644, 'SNORA51', 'small nucleolar RNA, H/ACA box 51', 'non-coding RNA', 'ENSG00000271798'),
(6761, 32652, 'SNORA58', 'small nucleolar RNA, H/ACA box 58', 'non-coding RNA', 'ENSG00000249020'),
(6762, 10107, 'SNORA62', 'small nucleolar RNA, H/ACA box 62', 'non-coding RNA', 'ENSG00000202363'),
(6763, 10106, 'SNORA63', 'small nucleolar RNA, H/ACA box 63', 'non-coding RNA', 'ENSG00000200320'),
(6764, 33618, 'SNORA70B', 'small nucleolar RNA, H/ACA box 70B', 'non-coding RNA', 'ENSG00000206937'),
(6765, 10233, 'SNORA71B', 'small nucleolar RNA, H/ACA box 71B', 'non-coding RNA', 'ENSG00000235408'),
(6766, 10234, 'SNORA72', 'small nucleolar RNA, H/ACA box 72', 'non-coding RNA', 'ENSG00000207067'),
(6767, 32660, 'SNORA74B', 'small nucleolar RNA, H/ACA box 74B', 'non-coding RNA', 'ENSG00000212402'),
(6768, 52221, 'SNORA77B', 'small nucleolar RNA, H/ACA box 77B', 'non-coding RNA', 'ENSG00000264346'),
(6769, 32635, 'SNORA80E', 'small nucleolar RNA, H/ACA box 80E', 'non-coding RNA', 'ENSG00000207475'),
(6770, 32556, 'SNORD1A', 'small nucleolar RNA, C/D box 1A', 'non-coding RNA', 'ENSG00000278261'),
(6771, 10168, 'SNORD3B-1', 'small nucleolar RNA, C/D box 3B-1', 'non-coding RNA', 'ENSG00000265185'),
(6772, 32702, 'SNORD5', 'small nucleolar RNA, C/D box 5', 'non-coding RNA', 'ENSG00000239195'),
(6773, 20159, 'SNORD8', 'small nucleolar RNA, C/D box 8', 'non-coding RNA', 'ENSG00000200785'),
(6774, 32706, 'SNORD10', 'small nucleolar RNA, C/D box 10', 'non-coding RNA', 'ENSG00000238917'),
(6775, 32707, 'SNORD11', 'small nucleolar RNA, C/D box 11', 'non-coding RNA', 'ENSG00000238317'),
(6776, 10105, 'SNORD12C', 'small nucleolar RNA, C/D box 12C', 'non-coding RNA', 'ENSG00000209042'),
(6777, 52254, 'SNORD13E', 'small nucleolar RNA, C/D box 13E', 'non-coding RNA', 'ENSG00000238311'),
(6778, 10110, 'SNORD13P1', 'small nucleolar RNA, C/D box 13 pseudogene 1', 'pseudogene', 'ENSG00000238498'),
(6779, 32713, 'SNORD17', 'small nucleolar RNA, C/D box 17', 'non-coding RNA', 'ENSG00000212232'),
(6780, 32715, 'SNORD18B', 'small nucleolar RNA, C/D box 18B', 'non-coding RNA', 'ENSG00000202529'),
(6781, 10164, 'SNORD36B', 'small nucleolar RNA, C/D box 36B', 'non-coding RNA', 'ENSG00000200831'),
(6782, 10179, 'SNORD41', 'small nucleolar RNA, C/D box 41', 'non-coding RNA', 'ENSG00000209702'),
(6783, 10180, 'SNORD42A', 'small nucleolar RNA, C/D box 42A', 'non-coding RNA', 'ENSG00000238649'),
(6784, 10203, 'SNORD53', 'small nucleolar RNA, C/D box 53', 'non-coding RNA', 'ENSG00000265145'),
(6785, 10205, 'SNORD55', 'small nucleolar RNA, C/D box 55', 'non-coding RNA', 'ENSG00000264294'),
(6786, 33613, 'SNORD58C', 'small nucleolar RNA, C/D box 58C', 'non-coding RNA', 'ENSG00000202093'),
(6787, 32726, 'SNORD65', 'small nucleolar RNA, C/D box 65', 'non-coding RNA', 'ENSG00000277512'),
(6788, 52232, 'SNORD65C', 'small nucleolar RNA, C/D box 65C', 'non-coding RNA', 'ENSG00000212264'),
(6789, 32730, 'SNORD69', 'small nucleolar RNA, C/D box 69', 'non-coding RNA', 'ENSG00000212452'),
(6790, 52235, 'SNORD77B', 'small nucleolar RNA, C/D box 77B', 'non-coding RNA', 'ENSG00000212414'),
(6791, 32748, 'SNORD88B', 'small nucleolar RNA, C/D box 88B', 'non-coding RNA', 'ENSG00000221381'),
(6792, 32751, 'SNORD90', 'small nucleolar RNA, C/D box 90', 'non-coding RNA', 'ENSG00000212447'),
(6793, 32756, 'SNORD94', 'small nucleolar RNA, C/D box 94', 'non-coding RNA', 'ENSG00000208772'),
(6794, 32763, 'SNORD100', 'small nucleolar RNA, C/D box 100', 'non-coding RNA', 'ENSG00000221500'),
(6795, 32769, 'SNORD105', 'small nucleolar RNA, C/D box 105', 'non-coding RNA', 'ENSG00000209645'),
(6796, 32771, 'SNORD107', 'small nucleolar RNA, C/D box 107', 'non-coding RNA', 'ENSG00000276314'),
(6797, 32773, 'SNORD109A', 'small nucleolar RNA, C/D box 109A', 'non-coding RNA', 'ENSG00000274640'),
(6798, 32776, 'SNORD111', 'small nucleolar RNA, C/D box 111', 'non-coding RNA', 'ENSG00000221066'),
(6799, 32981, 'SNORD113-2', 'small nucleolar RNA, C/D box 113-2', 'non-coding RNA', 'ENSG00000212384'),
(6800, 32986, 'SNORD113-7', 'small nucleolar RNA, C/D box 113-7', 'non-coding RNA', 'ENSG00000200632'),
(6801, 32991, 'SNORD114-3', 'small nucleolar RNA, C/D box 114-3', 'non-coding RNA', 'ENSG00000201839'),
(6802, 32995, 'SNORD114-7', 'small nucleolar RNA, C/D box 114-7', 'non-coding RNA', 'ENSG00000199390'),
(6803, 33001, 'SNORD114-13', 'small nucleolar RNA, C/D box 114-13', 'non-coding RNA', 'ENSG00000201247'),
(6804, 33006, 'SNORD114-18', 'small nucleolar RNA, C/D box 114-18', 'non-coding RNA', 'ENSG00000202142'),
(6805, 33008, 'SNORD114-20', 'small nucleolar RNA, C/D box 114-20', 'non-coding RNA', 'ENSG00000202048'),
(6806, 33013, 'SNORD114-25', 'small nucleolar RNA, C/D box 114-25', 'non-coding RNA', 'ENSG00000200612'),
(6807, 33018, 'SNORD114-30', 'small nucleolar RNA, C/D box 114-30', 'non-coding RNA', 'ENSG00000201318'),
(6808, 33023, 'SNORD115-4', 'small nucleolar RNA, C/D box 115-4', 'non-coding RNA', 'ENSG00000200680'),
(6809, 33028, 'SNORD115-9', 'small nucleolar RNA, C/D box 115-9', 'non-coding RNA', 'ENSG00000199782'),
(6810, 33033, 'SNORD115-14', 'small nucleolar RNA, C/D box 115-14', 'non-coding RNA', 'ENSG00000199960'),
(6811, 33038, 'SNORD115-19', 'small nucleolar RNA, C/D box 115-19', 'non-coding RNA', 'ENSG00000199968'),
(6812, 33043, 'SNORD115-24', 'small nucleolar RNA, C/D box 115-24', 'non-coding RNA', 'ENSG00000200398'),
(6813, 33048, 'SNORD115-29', 'small nucleolar RNA, C/D box 115-29', 'non-coding RNA', 'ENSG00000199704'),
(6814, 33053, 'SNORD115-34', 'small nucleolar RNA, C/D box 115-34', 'non-coding RNA', 'ENSG00000199311'),
(6815, 33058, 'SNORD115-39', 'small nucleolar RNA, C/D box 115-39', 'non-coding RNA', 'ENSG00000200564'),
(6816, 33063, 'SNORD115-44', 'small nucleolar RNA, C/D box 115-44', 'non-coding RNA', 'ENSG00000202261'),
(6817, 33343, 'SNORD115-48', 'small nucleolar RNA, C/D box 115-48', 'non-coding RNA', 'ENSG00000201634'),
(6818, 33071, 'SNORD116-5', 'small nucleolar RNA, C/D box 116-5', 'non-coding RNA', 'ENSG00000207191'),
(6819, 33076, 'SNORD116-10', 'small nucleolar RNA, C/D box 116-10', 'non-coding RNA', 'ENSG00000200661'),
(6820, 33081, 'SNORD116-15', 'small nucleolar RNA, C/D box 116-15', 'non-coding RNA', 'ENSG00000207174'),
(6821, 33093, 'SNORD116-27', 'small nucleolar RNA, C/D box 116-27', 'non-coding RNA', 'ENSG00000251896'),
(6822, 33564, 'SNORD125', 'small nucleolar RNA, C/D box 125', 'non-coding RNA', 'ENSG00000239127'),
(6823, 14161, 'SNRNP25', 'small nuclear ribonucleoprotein U11/U12 subunit 25', 'protein-coding gene', 'ENSG00000161981'),
(6824, 11150, 'SNRNP70', 'small nuclear ribonucleoprotein U1 subunit 70', 'protein-coding gene', 'ENSG00000104852'),
(6825, 55431, 'SNRPA1-DT', 'SNRPA1 divergent transcript', 'non-coding RNA', 'ENSG00000259172'),
(6826, 49835, 'SNRPCP20', 'small nuclear ribonucleoprotein polypeptide C pseudogene 20', 'pseudogene', 'ENSG00000267182'),
(6827, 38598, 'SNRPD2P2', 'small nuclear ribonucleoprotein D2 pseudogene 2', 'pseudogene', 'ENSG00000223982'),
(6828, 43572, 'SNRPEP7', 'SNRPE pseudogene 7', 'pseudogene', 'ENSG00000225990'),
(6829, 43574, 'SNRPEP9', 'SNRPE pseudogene 9', 'pseudogene', 'ENSG00000214124'),
(6830, 16551, 'SNRPFP1', 'small nuclear ribonucleoprotein polypeptide F pseudogene 1', 'pseudogene', 'ENSG00000231878'),
(6831, 20033, 'SNRPGP1', 'small nuclear ribonucleoprotein polypeptide G pseudogene 1', 'pseudogene', 'ENSG00000258577'),
(6832, 39322, 'SNRPGP3', 'small nuclear ribonucleoprotein polypeptide G pseudogene 3', 'pseudogene', 'ENSG00000239919'),
(6833, 39326, 'SNRPGP7', 'small nuclear ribonucleoprotein polypeptide G pseudogene 7', 'pseudogene', 'ENSG00000242915'),
(6834, 39328, 'SNRPGP9', 'small nuclear ribonucleoprotein polypeptide G pseudogene 9', 'pseudogene', 'ENSG00000228551'),
(6835, 39331, 'SNRPGP12', 'small nuclear ribonucleoprotein polypeptide G pseudogene 12', 'pseudogene', 'ENSG00000226734'),
(6836, 11167, 'SNTA1', 'syntrophin alpha 1', 'protein-coding gene', 'ENSG00000101400'),
(6837, 54058, 'SNTG2-AS1', 'SNTG2 antisense RNA 1', 'non-coding RNA', 'ENSG00000235688'),
(6838, 33706, 'SNTN', 'sentan, cilia apical structure protein', 'protein-coding gene', 'ENSG00000188817'),
(6839, 29543, 'SNURFL', 'SNRPN upstream open reading frame like (pseudogene)', 'pseudogene', 'ENSG00000173954'),
(6840, 41514, 'SNX2P1', 'sorting nexin 2 pseudogene 1', 'pseudogene', 'ENSG00000270585'),
(6841, 11174, 'SNX3', 'sorting nexin 3', 'protein-coding gene', 'ENSG00000112335'),
(6842, 11175, 'SNX4', 'sorting nexin 4', 'protein-coding gene', 'ENSG00000114520'),
(6843, 41512, 'SNX5P1', 'sorting nexin 5 pseudogene 1', 'pseudogene', 'ENSG00000249858'),
(6844, 41513, 'SNX5P2', 'sorting nexin 5 pseudogene 2', 'pseudogene', 'ENSG00000258033'),
(6845, 14970, 'SNX6', 'sorting nexin 6', 'protein-coding gene', 'ENSG00000129515'),
(6846, 40699, 'SNX9-AS1', 'SNX9 antisense RNA 1', 'non-coding RNA', 'ENSG00000236324'),
(6847, 21335, 'SNX13', 'sorting nexin 13', 'protein-coding gene', 'ENSG00000071189'),
(6848, 14979, 'SNX17', 'sorting nexin 17', 'protein-coding gene', 'ENSG00000115234'),
(6849, 39616, 'SNX18P8', 'sorting nexin 18 pseudogene 8', 'pseudogene', 'ENSG00000231390'),
(6850, 39617, 'SNX18P9', 'sorting nexin 18 pseudogene 9', 'pseudogene', 'ENSG00000224185'),
(6851, 39620, 'SNX18P12', 'sorting nexin 18 pseudogene 12', 'pseudogene', 'ENSG00000279718'),
(6852, 39631, 'SNX18P23', 'sorting nexin 18 pseudogene 23', 'pseudogene', 'ENSG00000250016'),
(6853, 39633, 'SNX18P25', 'sorting nexin 18 pseudogene 25', 'pseudogene', 'ENSG00000249337'),
(6854, 39635, 'SNX18P27', 'sorting nexin 18 pseudogene 27', 'pseudogene', 'ENSG00000253418'),
(6855, 21532, 'SNX19', 'sorting nexin 19', 'protein-coding gene', 'ENSG00000120451'),
(6856, 41510, 'SNX19P4', 'sorting nexin 19 pseudogene 4', 'pseudogene', 'ENSG00000276531'),
(6857, 16154, 'SNX21', 'sorting nexin family member 21', 'protein-coding gene', 'ENSG00000124104'),
(6858, 16315, 'SNX22', 'sorting nexin 22', 'protein-coding gene', 'ENSG00000157734'),
(6859, 31914, 'SNX29P2', 'sorting nexin 29 pseudogene 2', 'pseudogene', 'ENSG00000271699'),
(6860, 26423, 'SNX32', 'sorting nexin 32', 'protein-coding gene', 'ENSG00000172803'),
(6861, 54421, 'SOCAR', 'serous ovarian cancer associated RNA', 'non-coding RNA', 'ENSG00000240350'),
(6862, 19382, 'SOCS2', 'suppressor of cytokine signaling 2', 'protein-coding gene', 'ENSG00000120833'),
(6863, 16069, 'SOCS2P1', 'suppressor of cytokine signaling 2 pseudogene 1', 'pseudogene', 'ENSG00000237662'),
(6864, 44600, 'SOCS5P4', 'suppressor of cytokine signaling 5 pseudogene 4', 'pseudogene', 'ENSG00000227536'),
(6865, 45134, 'SOD1P1', 'superoxide dismutase 1 pseudogene 1', 'pseudogene', 'ENSG00000219074'),
(6866, 16111, 'SOGA1', 'suppressor of glucose, autophagy associated 1', 'protein-coding gene', 'ENSG00000149639'),
(6867, 45244, 'SORCS3-AS1', 'SORCS3 antisense RNA 1', 'non-coding RNA', 'ENSG00000226387'),
(6868, 11185, 'SORL1', 'sortilin related receptor 1', 'protein-coding gene', 'ENSG00000137642'),
(6869, 13771, 'SOST', 'sclerostin', 'protein-coding gene', 'ENSG00000167941'),
(6870, 21748, 'SOSTDC1', 'sclerostin domain containing 1', 'protein-coding gene', 'ENSG00000171243'),
(6871, 27033, 'SOWAHA', 'sosondowah ankyrin repeat domain family member A', 'protein-coding gene', 'ENSG00000198944'),
(6872, 26149, 'SOWAHC', 'sosondowah ankyrin repeat domain family member C', 'protein-coding gene', 'ENSG00000198142'),
(6873, 11189, 'SOX1', 'SRY-box transcription factor 1', 'protein-coding gene', 'ENSG00000182968'),
(6874, 11195, 'SOX2', 'SRY-box transcription factor 2', 'protein-coding gene', 'ENSG00000181449'),
(6875, 18196, 'SOX7', 'SRY-box transcription factor 7', 'protein-coding gene', 'ENSG00000171056'),
(6876, 11203, 'SOX8', 'SRY-box transcription factor 8', 'protein-coding gene', 'ENSG00000005513'),
(6877, 11192, 'SOX13', 'SRY-box transcription factor 13', 'protein-coding gene', 'ENSG00000143842'),
(6878, 11196, 'SOX15', 'SRY-box transcription factor 15', 'protein-coding gene', 'ENSG00000129194'),
(6879, 19196, 'SP8', 'Sp8 transcription factor', 'protein-coding gene', 'ENSG00000164651'),
(6880, 25105, 'SP140L', 'SP140 nuclear body protein like', 'protein-coding gene', 'ENSG00000185404'),
(6881, 14967, 'SPACA1', 'sperm acrosome associated 1', 'protein-coding gene', 'ENSG00000118434'),
(6882, 16260, 'SPACA3', 'sperm acrosome associated 3', 'protein-coding gene', 'ENSG00000141316'),
(6883, 19142, 'SPACA5B', 'sperm acrosome associated 5B', 'protein-coding gene', 'ENSG00000171478'),
(6884, 1367, 'SPACA9', 'sperm acrosome associated 9', 'protein-coding gene', 'ENSG00000165698'),
(6885, 22135, 'SPACDR', 'sperm acrosome developmental regulator', 'protein-coding gene', 'ENSG00000185955'),
(6886, 11214, 'SPAG4', 'sperm associated antigen 4', 'protein-coding gene', 'ENSG00000061656'),
(6887, 11215, 'SPAG6', 'sperm associated antigen 6', 'protein-coding gene', 'ENSG00000077327'),
(6888, 14105, 'SPAG8', 'sperm associated antigen 8', 'protein-coding gene', 'ENSG00000137098'),
(6889, 14524, 'SPAG9', 'sperm associated antigen 9', 'protein-coding gene', 'ENSG00000008294'),
(6890, 14332, 'SPANXD', 'SPANX family member D', 'protein-coding gene', 'ENSG00000196406'),
(6891, 33174, 'SPANXN1', 'SPANX family member N1', 'protein-coding gene', 'ENSG00000203923'),
(6892, 33175, 'SPANXN2', 'SPANX family member N2', 'protein-coding gene', 'ENSG00000268988'),
(6893, 33177, 'SPANXN4', 'SPANX family member N4', 'protein-coding gene', 'ENSG00000189326'),
(6894, 18514, 'SPART', 'spartin', 'protein-coding gene', 'ENSG00000133104'),
(6895, 28013, 'SPATA3-AS1', 'SPATA3 antisense RNA 1 (head to head)', 'non-coding RNA', 'ENSG00000238062'),
(6896, 30614, 'SPATA19', 'spermatogenesis associated 19', 'protein-coding gene', 'ENSG00000166118'),
(6897, 39636, 'SPATA20P1', 'spermatogenesis associated 20 pseudogene 1', 'pseudogene', 'ENSG00000231123'),
(6898, 16158, 'SPATA25', 'spermatogenesis associated 25', 'protein-coding gene', 'ENSG00000149634'),
(6899, 32003, 'SPATA31A3', 'SPATA31 subfamily A member 3', 'protein-coding gene', 'ENSG00000275969'),
(6900, 32006, 'SPATA31A6', 'SPATA31 subfamily A member 6', 'protein-coding gene', 'ENSG00000185775'),
(6901, 32007, 'SPATA31A7', 'SPATA31 subfamily A member 7', 'protein-coding gene', 'ENSG00000276040'),
(6902, 38603, 'SPATA31D3', 'SPATA31 subfamily D member 3', 'protein-coding gene', 'ENSG00000186788'),
(6903, 26349, 'SPATA32', 'spermatogenesis associated 32', 'protein-coding gene', 'ENSG00000184361'),
(6904, 33709, 'SPATA45', 'spermatogenesis associated 45', 'protein-coding gene', 'ENSG00000185523'),
(6905, 18650, 'SPATS2', 'spermatogenesis associated serine rich 2', 'protein-coding gene', 'ENSG00000123352'),
(6906, 31885, 'SPCS2P1', 'signal peptidase complex subunit 2 pseudogene 1', 'pseudogene', 'ENSG00000260928'),
(6907, 45237, 'SPCS2P4', 'signal peptidase complex subunit 2 pseudogene 4', 'pseudogene', 'ENSG00000228589'),
(6908, 26212, 'SPCS3', 'signal peptidase complex subunit 3', 'protein-coding gene', 'ENSG00000129128'),
(6909, 30613, 'SPDYA', 'speedy/RINGO cell cycle regulator family member A', 'protein-coding gene', 'ENSG00000163806'),
(6910, 35462, 'SPDYE3', 'speedy/RINGO cell cycle regulator family member E3', 'protein-coding gene', 'ENSG00000214300'),
(6911, 35466, 'SPDYE7P', 'speedy/RINGO cell cycle regulator family member E7, pseudogene', 'pseudogene', 'ENSG00000179994'),
(6912, 51508, 'SPDYE12', 'speedy/RINGO cell cycle regulator family member E12', 'protein-coding gene', 'ENSG00000184616'),
(6913, 51517, 'SPDYE21', 'speedy/RINGO cell cycle regulator family member E21', 'protein-coding gene', 'ENSG00000230358'),
(6914, 51518, 'SPDYE22P', 'speedy/RINGO cell cycle regulator family member E22, pseudogene', 'pseudogene', 'ENSG00000266537'),
(6915, 55376, 'SPECC1-DT', 'SPECC1 divergent transcript', 'non-coding RNA', 'ENSG00000261033'),
(6916, 53867, 'SPECC1P1', 'SPECC1 pseudogene 1', 'pseudogene', 'ENSG00000227790'),
(6917, 15874, 'SPEF1', 'sperm flagellar 1', 'protein-coding gene', 'ENSG00000101222'),
(6918, 11237, 'SPG7', 'SPG7 matrix AAA peptidase subunit, paraplegin', 'protein-coding gene', 'ENSG00000197912'),
(6919, 11242, 'SPIB', 'Spi-B transcription factor', 'protein-coding gene', 'ENSG00000269404'),
(6920, 20694, 'SPIN2A', 'spindlin family member 2A', 'protein-coding gene', 'ENSG00000147059'),
(6921, 27272, 'SPIN3', 'spindlin family member 3', 'protein-coding gene', 'ENSG00000204271'),
(6922, 11244, 'SPINK1', 'serine peptidase inhibitor Kazal type 1', 'protein-coding gene', 'ENSG00000164266'),
(6923, 29486, 'SPINK6', 'serine peptidase inhibitor Kazal type 6', 'protein-coding gene', 'ENSG00000178172'),
(6924, 24643, 'SPINK7', 'serine peptidase inhibitor Kazal type 7', 'protein-coding gene', 'ENSG00000145879'),
(6925, 16161, 'SPINT5P', 'serine peptidase inhibitor, Kunitz type 5, pseudogene', 'pseudogene', 'ENSG00000168630'),
(6926, 17722, 'SPRED2', 'sprouty related EVH1 domain containing 2', 'protein-coding gene', 'ENSG00000198369'),
(6927, 11265, 'SPRR2E', 'small proline rich protein 2E', 'protein-coding gene', 'ENSG00000203785'),
(6928, 53428, 'SPRR5', 'small proline rich protein 5', 'protein-coding gene', 'ENSG00000283227'),
(6929, 11274, 'SPTB', 'spectrin beta, erythrocytic', 'protein-coding gene', 'ENSG00000070182'),
(6930, 11276, 'SPTBN2', 'spectrin beta, non-erythrocytic 2', 'protein-coding gene', 'ENSG00000173898'),
(6931, 39672, 'SPTLC1P5', 'serine palmitoyltransferase long chain base subunit 1 pseudogene 5', 'pseudogene', 'ENSG00000227922'),
(6932, 30721, 'SPZ1', 'spermatogenic leucine zipper 1', 'protein-coding gene', 'ENSG00000164299'),
(6933, 11279, 'SQLE', 'squalene epoxidase', 'protein-coding gene', 'ENSG00000104549'),
(6934, 49099, 'SQSTM1P1', 'sequestosome 1 pseudogene 1', 'pseudogene', 'ENSG00000271465'),
(6935, 25812, 'SRD5A3', 'steroid 5 alpha-reductase 3', 'protein-coding gene', 'ENSG00000128039'),
(6936, 53953, 'SREBF2-AS1', 'SREBF2 antisense RNA 1', 'non-coding RNA', 'ENSG00000184068'),
(6937, 26716, 'SREK1IP1', 'SREK1 interacting protein 1', 'protein-coding gene', 'ENSG00000153006'),
(6938, 54504, 'SREK1IP1P1', 'SREK1IP1 pseudogene 1', 'pseudogene', 'ENSG00000229336'),
(6939, 26333, 'SRFBP1', 'serum response factor binding protein 1', 'protein-coding gene', 'ENSG00000151304'),
(6940, 43932, 'SRGAP2D', 'SLIT-ROBO Rho GTPase activating protein 2D (pseudogene)', 'pseudogene', 'ENSG00000270872'),
(6941, 40898, 'SRGAP3-AS1', 'SRGAP3 antisense RNA 1', 'non-coding RNA', 'ENSG00000224808'),
(6942, 11292, 'SRI', 'sorcin', 'protein-coding gene', 'ENSG00000075142'),
(6943, 50643, 'SRP54-AS1', 'SRP54 antisense RNA 1', 'non-coding RNA', 'ENSG00000258704'),
(6944, 11302, 'SRP68', 'signal recognition particle 68', 'protein-coding gene', 'ENSG00000167881'),
(6945, 26729, 'SRRM3', 'serine/arginine repetitive matrix 3', 'protein-coding gene', 'ENSG00000177679'),
(6946, 10786, 'SRSF4', 'serine and arginine rich splicing factor 4', 'protein-coding gene', 'ENSG00000116350'),
(6947, 10788, 'SRSF6', 'serine and arginine rich splicing factor 6', 'protein-coding gene', 'ENSG00000124193'),
(6948, 54947, 'SRSF6P2', 'SRSF6 pseudogene 2', 'pseudogene', 'ENSG00000235554'),
(6949, 10789, 'SRSF7', 'serine and arginine rich splicing factor 7', 'protein-coding gene', 'ENSG00000115875'),
(6950, 10791, 'SRSF9', 'serine and arginine rich splicing factor 9', 'protein-coding gene', 'ENSG00000111786'),
(6951, 11311, 'SRY', 'sex determining region Y', 'protein-coding gene', 'ENSG00000184895'),
(6952, 15592, 'SS18L1', 'SS18L1 subunit of BAF chromatin remodeling complex', 'protein-coding gene', 'ENSG00000184402'),
(6953, 44965, 'SS18L2P1', 'SS18 like 2 pseudogene 1', 'pseudogene', 'ENSG00000232525'),
(6954, 44966, 'SS18L2P2', 'SS18 like 2 pseudogene 2', 'pseudogene', 'ENSG00000266201'),
(6955, 54577, 'SSBP3P1', 'SSBP3 pseudogene 1', 'pseudogene', 'ENSG00000233225'),
(6956, 15676, 'SSBP4', 'single stranded DNA binding protein 4', 'protein-coding gene', 'ENSG00000130511'),
(6957, 30580, 'SSH2', 'slingshot protein phosphatase 2', 'protein-coding gene', 'ENSG00000141298'),
(6958, 29580, 'SSMEM1', 'serine rich single-pass membrane protein 1', 'protein-coding gene', 'ENSG00000165120'),
(6959, 21998, 'SSPOP', 'SCO-spondin, pseudogene', 'pseudogene', 'ENSG00000197558'),
(6960, 11326, 'SSR4', 'signal sequence receptor subunit 4', 'protein-coding gene', 'ENSG00000180879'),
(6961, 11329, 'SST', 'somatostatin', 'protein-coding gene', 'ENSG00000157005'),
(6962, 11332, 'SSTR3', 'somatostatin receptor 3', 'protein-coding gene', 'ENSG00000278195'),
(6963, 43624, 'SSU72P5', 'SSU72 pseudogene 5', 'other', 'ENSG00000284018'),
(6964, 43626, 'SSU72P7', 'SSU72 pseudogene 7', 'other', 'ENSG00000284438'),
(6965, 43627, 'SSU72P8', 'SSU72 pseudogene 8', 'other', 'ENSG00000230268'),
(6966, 16880, 'SSX4B', 'SSX family member 4B', 'protein-coding gene', 'ENSG00000269791'),
(6967, 30641, 'SSXP4', 'SSX family pseudogene 4', 'pseudogene', 'ENSG00000185319'),
(6968, 55372, 'ST3GAL1-DT', 'ST3GAL1 divergent transcript', 'non-coding RNA', 'ENSG00000261220'),
(6969, 10866, 'ST3GAL3', 'ST3 beta-galactoside alpha-2,3-sialyltransferase 3', 'protein-coding gene', 'ENSG00000126091'),
(6970, 51129, 'ST3GAL5-AS1', 'ST3GAL5 antisense RNA 1 (head to head)', 'non-coding RNA', 'ENSG00000232504'),
(6971, 18080, 'ST3GAL6', 'ST3 beta-galactoside alpha-2,3-sialyltransferase 6', 'protein-coding gene', 'ENSG00000064225'),
(6972, 10860, 'ST6GAL1', 'ST6 beta-galactoside alpha-2,6-sialyltransferase 1', 'protein-coding gene', 'ENSG00000073849'),
(6973, 10861, 'ST6GAL2', 'ST6 beta-galactoside alpha-2,6-sialyltransferase 2', 'protein-coding gene', 'ENSG00000144057'),
(6974, 19342, 'ST6GALNAC5', 'ST6 N-acetylgalactosaminide alpha-2,6-sialyltransferase 5', 'protein-coding gene', 'ENSG00000117069'),
(6975, 16044, 'ST7-AS2', 'ST7 antisense RNA 2', 'non-coding RNA', 'ENSG00000226367'),
(6976, 10869, 'ST8SIA1', 'ST8 alpha-N-acetyl-neuraminide alpha-2,8-sialyltransferase 1', 'protein-coding gene', 'ENSG00000111728'),
(6977, 38787, 'ST13P12', 'ST13, Hsp70 interacting protein pseudogene 12', 'pseudogene', 'ENSG00000248400'),
(6978, 38864, 'ST13P21', 'ST13, Hsp70 interacting protein pseudogene 21', 'pseudogene', 'ENSG00000227832'),
(6979, 18629, 'STAB2', 'stabilin 2', 'protein-coding gene', 'ENSG00000136011'),
(6980, 23990, 'STAC2', 'SH3 and cysteine rich domain 2', 'protein-coding gene', 'ENSG00000141750'),
(6981, 33852, 'STAG3L1', 'stromal antigen 3-like 1 (pseudogene)', 'pseudogene', 'ENSG00000205583'),
(6982, 18058, 'STARD4', 'StAR related lipid transfer domain containing 4', 'protein-coding gene', 'ENSG00000164211'),
(6983, 18065, 'STARD5', 'StAR related lipid transfer domain containing 5', 'protein-coding gene', 'ENSG00000172345'),
(6984, 18066, 'STARD6', 'StAR related lipid transfer domain containing 6', 'protein-coding gene', 'ENSG00000174448'),
(6985, 19162, 'STARD9', 'StAR related lipid transfer domain containing 9', 'protein-coding gene', 'ENSG00000159433'),
(6986, 19164, 'STARD13', 'StAR related lipid transfer domain containing 13', 'protein-coding gene', 'ENSG00000133121'),
(6987, 11366, 'STAT5A', 'signal transducer and activator of transcription 5A', 'protein-coding gene', 'ENSG00000126561'),
(6988, 11367, 'STAT5B', 'signal transducer and activator of transcription 5B', 'protein-coding gene', 'ENSG00000173757'),
(6989, 55011, 'STAU2P1', 'STAU2 pseudogene 1', 'pseudogene', 'ENSG00000227581'),
(6990, 11374, 'STC2', 'stanniocalcin 2', 'protein-coding gene', 'ENSG00000113739'),
(6991, 11378, 'STEAP1', 'STEAP family member 1', 'protein-coding gene', 'ENSG00000164647'),
(6992, 41907, 'STEAP1B', 'STEAP family member 1B', 'protein-coding gene', 'ENSG00000105889'),
(6993, 40568, 'STIM1-AS1', 'STIM1 antisense RNA 1', 'non-coding RNA', 'ENSG00000228661'),
(6994, 11394, 'STK16', 'serine/threonine kinase 16', 'protein-coding gene', 'ENSG00000115661'),
(6995, 19283, 'STK16P1', 'serine/threonine kinase 16 pseudogene 1', 'pseudogene', 'ENSG00000259155'),
(6996, 11403, 'STK24', 'serine/threonine kinase 24', 'protein-coding gene', 'ENSG00000102572'),
(6997, 6510, 'STMN1', 'stathmin 1', 'protein-coding gene', 'ENSG00000117632'),
(6998, 26200, 'STN1', 'STN1 subunit of CST complex', 'protein-coding gene', 'ENSG00000107960'),
(6999, 3383, 'STOM', 'stomatin', 'protein-coding gene', 'ENSG00000148175'),
(7000, 14559, 'STOML2', 'stomatin like 2', 'protein-coding gene', 'ENSG00000165283'),
(7001, 30651, 'STON1-GTF2A1L', 'STON1-GTF2A1L readthrough', 'other', 'ENSG00000068781'),
(7002, 37285, 'STPG3', 'sperm-tail PG-rich repeat containing 3', 'protein-coding gene', 'ENSG00000197768'),
(7003, 30650, 'STRA6', 'signaling receptor and transporter of retinol STRA6', 'protein-coding gene', 'ENSG00000137868'),
(7004, 11425, 'STS', 'steroid sulfatase', 'protein-coding gene', 'ENSG00000101846'),
(7005, 11440, 'STX5', 'syntaxin 5', 'protein-coding gene', 'ENSG00000162236'),
(7006, 11430, 'STX12', 'syntaxin 12', 'protein-coding gene', 'ENSG00000117758'),
(7007, 11431, 'STX16', 'syntaxin 16', 'protein-coding gene', 'ENSG00000124222'),
(7008, 19665, 'STXBP5', 'syntaxin binding protein 5', 'protein-coding gene', 'ENSG00000164506'),
(7009, 30757, 'STXBP5L', 'syntaxin binding protein 5L', 'protein-coding gene', 'ENSG00000145087'),
(7010, 25034, 'STYXL2', 'serine/threonine/tyrosine interacting like 2', 'protein-coding gene', 'ENSG00000198842'),
(7011, 38102, 'SUCLA2P2', 'SUCLA2 pseudogene 2', 'pseudogene', 'ENSG00000233107'),
(7012, 49643, 'SUCLG2-DT', 'SUCLG2 divergent transcript', 'non-coding RNA', 'ENSG00000241316'),
(7013, 18643, 'SUGP1', 'SURP and G-patch domain containing 1', 'protein-coding gene', 'ENSG00000105705'),
(7014, 18641, 'SUGP2', 'SURP and G-patch domain containing 2', 'protein-coding gene', 'ENSG00000064607'),
(7015, 16987, 'SUGT1', 'SGT1 homolog, MIS12 kinetochore complex assembly cochaperone', 'protein-coding gene', 'ENSG00000165416'),
(7016, 31377, 'SUGT1P2', 'SUGT1 pseudogene 2', 'pseudogene', 'ENSG00000213842'),
(7017, 11454, 'SULT1A2', 'sulfotransferase family 1A member 2', 'protein-coding gene', 'ENSG00000197165'),
(7018, 17845, 'SULT1B1', 'sulfotransferase family 1B member 1', 'protein-coding gene', 'ENSG00000173597'),
(7019, 11456, 'SULT1C2', 'sulfotransferase family 1C member 2', 'protein-coding gene', 'ENSG00000198203'),
(7020, 14903, 'SULT4A1', 'sulfotransferase family 4A member 1', 'protein-coding gene', 'ENSG00000130540'),
(7021, 39015, 'SUMO2P5', 'SUMO2 pseudogene 5', 'pseudogene', 'ENSG00000251663'),
(7022, 39018, 'SUMO2P8', 'SUMO2 pseudogene 8', 'pseudogene', 'ENSG00000228976'),
(7023, 49358, 'SUMO2P17', 'SUMO2 pseudogene 17', 'pseudogene', 'ENSG00000248278'),
(7024, 49356, 'SUMO2P18', 'SUMO2 pseudogene 18', 'pseudogene', 'ENSG00000253639'),
(7025, 55054, 'SUMO2P21', 'SUMO2 pseudogene 21', 'pseudogene', 'ENSG00000228532'),
(7026, 11124, 'SUMO3', 'small ubiquitin like modifier 3', 'protein-coding gene', 'ENSG00000184900'),
(7027, 18587, 'SUN1', 'Sad1 and UNC84 domain containing 1', 'protein-coding gene', 'ENSG00000164828'),
(7028, 11460, 'SUOX', 'sulfite oxidase', 'protein-coding gene', 'ENSG00000139531'),
(7029, 11466, 'SUPT3H', 'SPT3 homolog, SAGA and STAGA complex component', 'protein-coding gene', 'ENSG00000196284'),
(7030, 11476, 'SURF4', 'surfeit 4', 'protein-coding gene', 'ENSG00000148248'),
(7031, 16874, 'SV2B', 'synaptic vesicle glycoprotein 2B', 'protein-coding gene', 'ENSG00000185518'),
(7032, 55583, 'SV2C-AS1', 'SV2C antisense RNA 1', 'non-coding RNA', 'ENSG00000248127'),
(7033, 27034, 'SVOPL', 'SVOP like', 'protein-coding gene', 'ENSG00000157703'),
(7034, 25841, 'SYDE2', 'synapse defective Rho GTPase homolog 2', 'protein-coding gene', 'ENSG00000097096'),
(7035, 38139, 'SYF2P2', 'SYF2 pre-mRNA splicing factor pseudogene 2', 'pseudogene', 'ENSG00000233148'),
(7036, 11491, 'SYK', 'spleen associated tyrosine kinase', 'protein-coding gene', 'ENSG00000165025'),
(7037, 11494, 'SYN1', 'synapsin I', 'protein-coding gene', 'ENSG00000008056'),
(7038, 16918, 'SYNCRIP', 'synaptotagmin binding cytoplasmic RNA interacting protein', 'protein-coding gene', 'ENSG00000135316'),
(7039, 17084, 'SYNE2', 'spectrin repeat containing nuclear envelope protein 2', 'protein-coding gene', 'ENSG00000054654'),
(7040, 11498, 'SYNGR1', 'synaptogyrin 1', 'protein-coding gene', 'ENSG00000100321'),
(7041, 11500, 'SYNGR2P1', 'synaptogyrin 2 pseudogene 1', 'pseudogene', 'ENSG00000260174'),
(7042, 41387, 'SYNJ2-IT1', 'SYNJ2 intronic transcript 1', 'non-coding RNA', 'ENSG00000233496'),
(7043, 48350, 'SYNJ2BP-COX16', 'SYNJ2BP-COX16 readthrough', 'other', 'ENSG00000258644'),
(7044, 16162, 'SYS1', 'SYS1 golgi trafficking protein', 'protein-coding gene', 'ENSG00000204070'),
(7045, 11511, 'SYT3', 'synaptotagmin 3', 'protein-coding gene', 'ENSG00000213023'),
(7046, 18638, 'SYT6', 'synaptotagmin 6', 'protein-coding gene', 'ENSG00000134207'),
(7047, 19264, 'SYT8', 'synaptotagmin 8', 'protein-coding gene', 'ENSG00000149043'),
(7048, 19265, 'SYT9', 'synaptotagmin 9', 'protein-coding gene', 'ENSG00000170743'),
(7049, 33429, 'SYT14P1', 'synaptotagmin 14 pseudogene 1', 'pseudogene', 'ENSG00000215127'),
(7050, 17167, 'SYT15', 'synaptotagmin 15', 'protein-coding gene', 'ENSG00000204176'),
(7051, 51487, 'SYT15B', 'synaptotagmin 15B', 'protein-coding gene', 'ENSG00000277758'),
(7052, 20738, 'SYVN1', 'synoviolin 1', 'protein-coding gene', 'ENSG00000162298'),
(7053, 31924, 'TAAR4P', 'trace amine associated receptor 4, pseudogene', 'pseudogene', 'ENSG00000237449'),
(7054, 20977, 'TAAR9', 'trace amine associated receptor 9', 'protein-coding gene', 'ENSG00000237110'),
(7055, 40013, 'TAB3-AS2', 'TAB3 antisense RNA 2', 'non-coding RNA', 'ENSG00000235512'),
(7056, 11522, 'TACC1', 'transforming acidic coiled-coil containing protein 1', 'protein-coding gene', 'ENSG00000147526'),
(7057, 24316, 'TACO1', 'translational activator of cytochrome c oxidase I', 'protein-coding gene', 'ENSG00000136463'),
(7058, 55593, 'TACR3-AS1', 'TACR3 antisense RNA 1', 'non-coding RNA', 'ENSG00000251577'),
(7059, 11531, 'TADA2A', 'transcriptional adaptor 2A', 'protein-coding gene', 'ENSG00000276234'),
(7060, 11535, 'TAF1', 'TATA-box binding protein associated factor 1', 'protein-coding gene', 'ENSG00000147133'),
(7061, 11532, 'TAF1A', 'TATA-box binding protein associated factor, RNA polymerase I subunit A', 'protein-coding gene', 'ENSG00000143498'),
(7062, 38836, 'TAF9BP2', 'TATA-box binding protein associated factor 9b pseudogene 2', 'pseudogene', 'ENSG00000215760'),
(7063, 30678, 'TAF9P3', 'TATA-box binding protein associated factor 9 pseudogene 3', 'pseudogene', 'ENSG00000267692'),
(7064, 53847, 'TAF11L4', 'TATA-box binding protein associated factor 11 like 4', 'protein-coding gene', 'ENSG00000284283'),
(7065, 53851, 'TAF11L8', 'TATA-box binding protein associated factor 11 like 8', 'protein-coding gene', 'ENSG00000283967'),
(7066, 53854, 'TAF11L11', 'TATA-box binding protein associated factor 11 like 11', 'protein-coding gene', 'ENSG00000283740'),
(7067, 53856, 'TAF11L13', 'TATA-box binding protein associated factor 11 like 13', 'protein-coding gene', 'ENSG00000283776'),
(7068, 52502, 'TAF12-DT', 'TAF12 divergent transcript', 'non-coding RNA', 'ENSG00000229388'),
(7069, 38161, 'TAF13P2', 'TATA-box binding protein associated factor 13 pseudogene 2', 'pseudogene', 'ENSG00000225658'),
(7070, 11547, 'TAF15', 'TATA-box binding protein associated factor 15', 'protein-coding gene', 'ENSG00000270647'),
(7071, 11577, 'TAFAZZIN', 'tafazzin, phospholipid-lysophospholipid transacylase', 'protein-coding gene', 'ENSG00000102125'),
(7072, 55239, 'TAGAP-AS1', 'TAGAP antisense RNA 1', 'non-coding RNA', 'ENSG00000271913'),
(7073, 18707, 'TAMALIN', 'trafficking regulator and scaffold protein tamalin', 'protein-coding gene', 'ENSG00000161835'),
(7074, 30212, 'TANC2', 'tetratricopeptide repeat, ankyrin repeat and coiled-coil containing 2', 'protein-coding gene', 'ENSG00000170921'),
(7075, 18133, 'TAOK3', 'TAO kinase 3', 'protein-coding gene', 'ENSG00000135090'),
(7076, 30683, 'TAPBPL', 'TAP binding protein like', 'protein-coding gene', 'ENSG00000139192'),
(7077, 26832, 'TAPT1-AS1', 'TAPT1 antisense RNA 1 (head to head)', 'non-coding RNA', 'ENSG00000263327'),
(7078, 55123, 'TARDBPP4', 'TARDBP pseudogene 4', 'pseudogene', 'ENSG00000253555'),
(7079, 20616, 'TAS2R6P', 'taste 2 receptor member 6 pseudogene', 'pseudogene', 'ENSG00000270923'),
(7080, 14913, 'TAS2R7', 'taste 2 receptor member 7', 'protein-coding gene', 'ENSG00000121377'),
(7081, 19108, 'TAS2R19', 'taste 2 receptor member 19', 'protein-coding gene', 'ENSG00000212124'),
(7082, 18875, 'TAS2R43', 'taste 2 receptor member 43', 'protein-coding gene', 'ENSG00000255374'),
(7083, 25667, 'TASL', 'TLR adaptor interacting with endolysosomal SLC15A4', 'protein-coding gene', 'ENSG00000120280'),
(7084, 23484, 'TASOR2', 'transcription activation suppressor family member 2', 'protein-coding gene', 'ENSG00000108021'),
(7085, 45058, 'TATDN1P1', 'TatD DNase domain containing 1 pseudogene 1', 'pseudogene', 'ENSG00000234369'),
(7086, 11578, 'TBC1D1', 'TBC1 domain family member 1', 'protein-coding gene', 'ENSG00000065882'),
(7087, 30708, 'TBC1D3H', 'TBC1 domain family member 3H', 'protein-coding gene', 'ENSG00000274226'),
(7088, 27445, 'TBC1D3P1', 'TBC1 domain family member 3 pseudogene 1', 'pseudogene', 'ENSG00000238283'),
(7089, 19165, 'TBC1D4', 'TBC1 domain family member 4', 'protein-coding gene', 'ENSG00000136111'),
(7090, 21066, 'TBC1D7', 'TBC1 domain family member 7', 'protein-coding gene', 'ENSG00000145979'),
(7091, 24702, 'TBC1D10C', 'TBC1 domain family member 10C', 'protein-coding gene', 'ENSG00000175463'),
(7092, 25694, 'TBC1D15', 'TBC1 domain family member 15', 'protein-coding gene', 'ENSG00000121749'),
(7093, 16133, 'TBC1D20', 'TBC1 domain family member 20', 'protein-coding gene', 'ENSG00000125875'),
(7094, 28536, 'TBC1D21', 'TBC1 domain family member 21', 'protein-coding gene', 'ENSG00000167139'),
(7095, 21602, 'TBC1D22B', 'TBC1 domain family member 22B', 'protein-coding gene', 'ENSG00000065491');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(7096, 21485, 'TBC1D32', 'TBC1 domain family member 32', 'protein-coding gene', 'ENSG00000146350'),
(7097, 42630, 'TBCAP1', 'tubulin folding cofactor A pseudogene 1', 'pseudogene', 'ENSG00000226781'),
(7098, 42631, 'TBCAP2', 'tubulin folding cofactor A pseudogene 2', 'pseudogene', 'ENSG00000235829'),
(7099, 11581, 'TBCD', 'tubulin folding cofactor D', 'protein-coding gene', 'ENSG00000141556'),
(7100, 50355, 'TBX2-AS1', 'TBX2 antisense RNA 1', 'non-coding RNA', 'ENSG00000267280'),
(7101, 11604, 'TBX5', 'T-box transcription factor 5', 'protein-coding gene', 'ENSG00000089225'),
(7102, 52256, 'TBX18-AS1', 'TBX18 antisense RNA 1', 'non-coding RNA', 'ENSG00000228290'),
(7103, 11596, 'TBX19', 'T-box transcription factor 19', 'protein-coding gene', 'ENSG00000143178'),
(7104, 11600, 'TBX22', 'T-box transcription factor 22', 'protein-coding gene', 'ENSG00000122145'),
(7105, 33603, 'TCAF2P1', 'TRPM8 channel associated factor 2 pseudogene 1', 'pseudogene', 'ENSG00000159860'),
(7106, 11612, 'TCEA1', 'transcription elongation factor A1', 'protein-coding gene', 'ENSG00000187735'),
(7107, 11613, 'TCEA1P1', 'transcription elongation factor A1 pseudogene 1', 'pseudogene', 'ENSG00000197214'),
(7108, 30569, 'TCEA1P3', 'transcription elongation factor A1 pseudogene 3', 'pseudogene', 'ENSG00000215165'),
(7109, 11615, 'TCEA3', 'transcription elongation factor A3', 'protein-coding gene', 'ENSG00000204219'),
(7110, 26121, 'TCEAL4', 'transcription elongation factor A like 4', 'protein-coding gene', 'ENSG00000133142'),
(7111, 22282, 'TCEAL5', 'transcription elongation factor A like 5', 'protein-coding gene', 'ENSG00000204065'),
(7112, 28277, 'TCEANC', 'transcription elongation factor A N-terminal and central domain containing', 'protein-coding gene', 'ENSG00000176896'),
(7113, 49532, 'TCERG1L-AS1', 'TCERG1L antisense RNA 1', 'non-coding RNA', 'ENSG00000230098'),
(7114, 11640, 'TCF7L1', 'transcription factor 7 like 1', 'protein-coding gene', 'ENSG00000152284'),
(7115, 32275, 'TCF24', 'transcription factor 24', 'protein-coding gene', 'ENSG00000261787'),
(7116, 11646, 'TCFL5', 'transcription factor like 5', 'protein-coding gene', 'ENSG00000101190'),
(7117, 11791, 'TCHH', 'trichohyalin', 'protein-coding gene', 'ENSG00000159450'),
(7118, 11654, 'TCOF1', 'treacle ribosome biogenesis factor 1', 'protein-coding gene', 'ENSG00000070814'),
(7119, 11659, 'TCP1P1', 't-complex 1 pseudogene 1', 'pseudogene', 'ENSG00000229161'),
(7120, 25655, 'TCP11L1', 't-complex 11 like 1', 'protein-coding gene', 'ENSG00000176148'),
(7121, 28627, 'TCP11L2', 't-complex 11 like 2', 'protein-coding gene', 'ENSG00000166046'),
(7122, 48370, 'TCP11X3P', 't-complex 11 family, X-linked 3, pseudogene', 'pseudogene', 'ENSG00000251525'),
(7123, 11708, 'TDO2', 'tryptophan 2,3-dioxygenase', 'protein-coding gene', 'ENSG00000151790'),
(7124, 56119, 'TDRD6-AS1', 'TDRD6 and SLC25A27 antisense RNA 1', 'non-coding RNA', 'ENSG00000242973'),
(7125, 45037, 'TDRD15', 'tudor domain containing 15', 'protein-coding gene', 'ENSG00000218819'),
(7126, 11713, 'TDRKH', 'tudor and KH domain containing', 'protein-coding gene', 'ENSG00000182134'),
(7127, 26951, 'TDRP', 'testis development related protein', 'protein-coding gene', 'ENSG00000180190'),
(7128, 11717, 'TEAD4', 'TEA domain transcription factor 4', 'protein-coding gene', 'ENSG00000197905'),
(7129, 53456, 'TEMN3-AS1', 'TENM3 antisense transcript 1', 'non-coding RNA', 'ENSG00000251336'),
(7130, 16705, 'TENT4A', 'terminal nucleotidyltransferase 4A', 'protein-coding gene', 'ENSG00000112941'),
(7131, 28273, 'TENT5B', 'terminal nucleotidyltransferase 5B', 'protein-coding gene', 'ENSG00000158246'),
(7132, 24712, 'TENT5C', 'terminal nucleotidyltransferase 5C', 'protein-coding gene', 'ENSG00000183508'),
(7133, 33745, 'TEPP', 'testis, prostate and placenta expressed', 'protein-coding gene', 'ENSG00000159648'),
(7134, 26065, 'TESC', 'tescalcin', 'protein-coding gene', 'ENSG00000088992'),
(7135, 29484, 'TET1', 'tet methylcytosine dioxygenase 1', 'protein-coding gene', 'ENSG00000138336'),
(7136, 41125, 'TET2-AS1', 'TET2 antisense RNA 1', 'non-coding RNA', 'ENSG00000251586'),
(7137, 28313, 'TET3', 'tet methylcytosine dioxygenase 3', 'protein-coding gene', 'ENSG00000187605'),
(7138, 33802, 'TEX19', 'testis expressed 19', 'protein-coding gene', 'ENSG00000182459'),
(7139, 40026, 'TEX22', 'testis expressed 22', 'protein-coding gene', 'ENSG00000226174'),
(7140, 2563, 'TEX28', 'testis expressed 28', 'protein-coding gene', 'ENSG00000278057'),
(7141, 25366, 'TEX35', 'testis expressed 35', 'protein-coding gene', 'ENSG00000240021'),
(7142, 26341, 'TEX37', 'testis expressed 37', 'protein-coding gene', 'ENSG00000172073'),
(7143, 52387, 'TEX51', 'testis expressed 51', 'protein-coding gene', 'ENSG00000237524'),
(7144, 11742, 'TFAP2A', 'transcription factor AP-2 alpha', 'protein-coding gene', 'ENSG00000137203'),
(7145, 54930, 'TFDP1P2', 'TFDP1 pseudogene 2', 'pseudogene', 'ENSG00000223723'),
(7146, 11752, 'TFE3', 'transcription factor binding to IGHM enhancer 3', 'protein-coding gene', 'ENSG00000068323'),
(7147, 11756, 'TFF2', 'trefoil factor 2', 'protein-coding gene', 'ENSG00000160181'),
(7148, 11758, 'TFG', 'trafficking from ER to golgi regulator', 'protein-coding gene', 'ENSG00000114354'),
(7149, 11760, 'TFPI', 'tissue factor pathway inhibitor', 'protein-coding gene', 'ENSG00000003436'),
(7150, 11762, 'TFR2', 'transferrin receptor 2', 'protein-coding gene', 'ENSG00000106327'),
(7151, 11767, 'TGFB1I1', 'transforming growth factor beta 1 induced transcript 1', 'protein-coding gene', 'ENSG00000140682'),
(7152, 11773, 'TGFBR2', 'transforming growth factor beta receptor 2', 'protein-coding gene', 'ENSG00000163513'),
(7153, 11774, 'TGFBR3', 'transforming growth factor beta receptor 3', 'protein-coding gene', 'ENSG00000069702'),
(7154, 11779, 'TGM3', 'transglutaminase 3', 'protein-coding gene', 'ENSG00000125780'),
(7155, 11780, 'TGM4', 'transglutaminase 4', 'protein-coding gene', 'ENSG00000163810'),
(7156, 11781, 'TGM5', 'transglutaminase 5', 'protein-coding gene', 'ENSG00000104055'),
(7157, 15450, 'TGOLN2', 'trans-golgi network protein 2', 'protein-coding gene', 'ENSG00000152291'),
(7158, 20855, 'THAP3', 'THAP domain containing 3', 'protein-coding gene', 'ENSG00000041988'),
(7159, 23189, 'THAP6', 'THAP domain containing 6', 'protein-coding gene', 'ENSG00000174796'),
(7160, 23190, 'THAP7', 'THAP domain containing 7', 'protein-coding gene', 'ENSG00000184436'),
(7161, 23193, 'THAP10', 'THAP domain containing 10', 'protein-coding gene', 'ENSG00000129028'),
(7162, 23194, 'THAP11', 'THAP domain containing 11', 'protein-coding gene', 'ENSG00000168286'),
(7163, 39563, 'THAP12P1', 'THAP domain containing 12 pseudogene 1', 'pseudogene', 'ENSG00000230665'),
(7164, 39567, 'THAP12P3', 'THAP domain containing 12 pseudogene 3', 'pseudogene', 'ENSG00000227972'),
(7165, 39569, 'THAP12P5', 'THAP domain containing 12 pseudogene 5', 'pseudogene', 'ENSG00000218020'),
(7166, 11785, 'THBS1', 'thrombospondin 1', 'protein-coding gene', 'ENSG00000137801'),
(7167, 40582, 'THBS3-AS1', 'THBS3 antisense RNA 1', 'non-coding RNA', 'ENSG00000231064'),
(7168, 11788, 'THBS4', 'thrombospondin 4', 'protein-coding gene', 'ENSG00000113296'),
(7169, 13706, 'THEG', 'theg spermatid protein', 'protein-coding gene', 'ENSG00000105549'),
(7170, 11799, 'THRB', 'thyroid hormone receptor beta', 'protein-coding gene', 'ENSG00000151090'),
(7171, 49503, 'THRIL', 'TNF and HNRNPL related immunoregulatory long non-coding RNA', 'non-coding RNA', 'ENSG00000280634'),
(7172, 29348, 'THSD7B', 'thrombospondin type 1 domain containing 7B', 'protein-coding gene', 'ENSG00000144229'),
(7173, 50793, 'THUMPD3P1', 'THUMP domain containing 3 pseudogene 1', 'pseudogene', 'ENSG00000248711'),
(7174, 11806, 'TIAM2', 'TIAM Rac1 associated GEF 2', 'protein-coding gene', 'ENSG00000146426'),
(7175, 21354, 'TICAM2', 'TIR domain containing adaptor molecule 2', 'protein-coding gene', 'ENSG00000243414'),
(7176, 18333, 'TIGD2', 'tigger transposable element derived 2', 'protein-coding gene', 'ENSG00000180346'),
(7177, 18336, 'TIGD5', 'tigger transposable element derived 5', 'protein-coding gene', 'ENSG00000179886'),
(7178, 17317, 'TIMM22', 'translocase of inner mitochondrial membrane 22', 'protein-coding gene', 'ENSG00000177370'),
(7179, 11823, 'TIMP4', 'TIMP metallopeptidase inhibitor 4', 'protein-coding gene', 'ENSG00000157150'),
(7180, 11828, 'TJP2', 'tight junction protein 2', 'protein-coding gene', 'ENSG00000119139'),
(7181, 11845, 'TLN1', 'talin 1', 'protein-coding gene', 'ENSG00000137076'),
(7182, 40720, 'TLR8-AS1', 'TLR8 antisense RNA 1', 'non-coding RNA', 'ENSG00000233338'),
(7183, 15634, 'TLR10', 'toll like receptor 10', 'protein-coding gene', 'ENSG00000174123'),
(7184, 37183, 'TLX1NB', 'TLX1 neighbor', 'non-coding RNA', 'ENSG00000236311'),
(7185, 13532, 'TLX3', 'T cell leukemia homeobox 3', 'protein-coding gene', 'ENSG00000164438'),
(7186, 24128, 'TM2D3', 'TM2 domain containing 3', 'protein-coding gene', 'ENSG00000184277'),
(7187, 11857, 'TM4SF5', 'transmembrane 4 L six family member 5', 'protein-coding gene', 'ENSG00000142484'),
(7188, 49190, 'TM4SF19-DYNLT2B', 'TM4SF19-DYNLT2B readthrough (NMD candidate)', 'other', 'ENSG00000273331'),
(7189, 11860, 'TM6SF1', 'transmembrane 6 superfamily member 1', 'protein-coding gene', 'ENSG00000136404'),
(7190, 11863, 'TM7SF2', 'transmembrane 7 superfamily member 2', 'protein-coding gene', 'ENSG00000149809'),
(7191, 11864, 'TM9SF1', 'transmembrane 9 superfamily member 1', 'protein-coding gene', 'ENSG00000100926'),
(7192, 49212, 'TMBIM7P', 'transmembrane BAX inhibitor motif containing 7, pseudogene', 'pseudogene', 'ENSG00000230927'),
(7193, 24239, 'TMCC2', 'transmembrane and coiled-coil domain family 2', 'protein-coding gene', 'ENSG00000133069'),
(7194, 53646, 'TMDD1', 'transmembrane and death domain 1', 'protein-coding gene', 'ENSG00000284730'),
(7195, 16996, 'TMED2', 'transmembrane p24 trafficking protein 2', 'protein-coding gene', 'ENSG00000086598'),
(7196, 28331, 'TMED6', 'transmembrane p24 trafficking protein 6', 'protein-coding gene', 'ENSG00000157315'),
(7197, 38105, 'TMED10P2', 'transmembrane p24 trafficking protein 10 pseudogene 2', 'pseudogene', 'ENSG00000239405'),
(7198, 19230, 'TMEM9B-AS1', 'TMEM9B antisense RNA 1', 'non-coding RNA', 'ENSG00000254860'),
(7199, 55230, 'TMEM14B-DT', 'TMEM14B divergent transcript', 'non-coding RNA', 'ENSG00000272097'),
(7200, 34386, 'TMEM14EP', 'transmembrane protein 14E, pseudogene', 'pseudogene', 'ENSG00000221962'),
(7201, 54481, 'TMEM18-DT', 'TMEM18 divergent transcript', 'non-coding RNA', 'ENSG00000233296'),
(7202, 25605, 'TMEM19', 'transmembrane protein 19', 'protein-coding gene', 'ENSG00000139291'),
(7203, 55058, 'TMEM30BP1', 'TMEM30B pseudogene 1', 'pseudogene', 'ENSG00000250995'),
(7204, 28462, 'TMEM38A', 'transmembrane protein 38A', 'protein-coding gene', 'ENSG00000072954'),
(7205, 25535, 'TMEM38B', 'transmembrane protein 38B', 'protein-coding gene', 'ENSG00000095209'),
(7206, 25600, 'TMEM39A', 'transmembrane protein 39A', 'protein-coding gene', 'ENSG00000176142'),
(7207, 28948, 'TMEM41B', 'transmembrane protein 41B', 'protein-coding gene', 'ENSG00000166471'),
(7208, 1239, 'TMEM59', 'transmembrane protein 59', 'protein-coding gene', 'ENSG00000116209'),
(7209, 13237, 'TMEM59L', 'transmembrane protein 59 like', 'protein-coding gene', 'ENSG00000105696'),
(7210, 31658, 'TMEM72', 'transmembrane protein 72', 'protein-coding gene', 'ENSG00000187783'),
(7211, 15893, 'TMEM74B', 'transmembrane protein 74B', 'protein-coding gene', 'ENSG00000125895'),
(7212, 37099, 'TMEM88B', 'transmembrane protein 88B', 'protein-coding gene', 'ENSG00000205116'),
(7213, 50442, 'TMEM92-AS1', 'TMEM92 antisense RNA 1', 'non-coding RNA', 'ENSG00000251179'),
(7214, 27898, 'TMEM95', 'transmembrane protein 95', 'protein-coding gene', 'ENSG00000182896'),
(7215, 28653, 'TMEM101', 'transmembrane protein 101', 'protein-coding gene', 'ENSG00000091947'),
(7216, 28775, 'TMEM106C', 'transmembrane protein 106C', 'protein-coding gene', 'ENSG00000134291'),
(7217, 28451, 'TMEM108', 'transmembrane protein 108', 'protein-coding gene', 'ENSG00000144868'),
(7218, 25308, 'TMEM117', 'transmembrane protein 117', 'protein-coding gene', 'ENSG00000139173'),
(7219, 21697, 'TMEM120A', 'transmembrane protein 120A', 'protein-coding gene', 'ENSG00000189077'),
(7220, 32008, 'TMEM120B', 'transmembrane protein 120B', 'protein-coding gene', 'ENSG00000188735'),
(7221, 28275, 'TMEM125', 'transmembrane protein 125', 'protein-coding gene', 'ENSG00000179178'),
(7222, 26038, 'TMEM127', 'transmembrane protein 127', 'protein-coding gene', 'ENSG00000135956'),
(7223, 25137, 'TMEM129', 'transmembrane protein 129, E3 ubiquitin ligase', 'protein-coding gene', 'ENSG00000168936'),
(7224, 53324, 'TMEM132D-AS2', 'TMEM132D antisense RNA 2', 'non-coding RNA', 'ENSG00000256699'),
(7225, 25603, 'TMEM143', 'transmembrane protein 143', 'protein-coding gene', 'ENSG00000161558'),
(7226, 25633, 'TMEM144', 'transmembrane protein 144', 'protein-coding gene', 'ENSG00000164124'),
(7227, 51273, 'TMEM147-AS1', 'TMEM147 antisense RNA 1', 'non-coding RNA', 'ENSG00000236144'),
(7228, 21315, 'TMEM151B', 'transmembrane protein 151B', 'protein-coding gene', 'ENSG00000178233'),
(7229, 26260, 'TMEM156', 'transmembrane protein 156', 'protein-coding gene', 'ENSG00000121895'),
(7230, 26042, 'TMEM160', 'transmembrane protein 160', 'protein-coding gene', 'ENSG00000130748'),
(7231, 55076, 'TMEM167B-DT', 'TMEM167B divergent transcript', 'non-coding RNA', 'ENSG00000273382'),
(7232, 28709, 'TMEM175', 'transmembrane protein 175', 'protein-coding gene', 'ENSG00000127419'),
(7233, 20958, 'TMEM181', 'transmembrane protein 181', 'protein-coding gene', 'ENSG00000146433'),
(7234, 26391, 'TMEM182', 'transmembrane protein 182', 'protein-coding gene', 'ENSG00000170417'),
(7235, 55544, 'TMEM184C-DT', 'TMEM184C divergent transcript', 'non-coding RNA', 'ENSG00000251298'),
(7236, 31717, 'TMEM185AP1', 'transmembrane protein 185A pseudogene 1', 'pseudogene', 'ENSG00000235254'),
(7237, 33600, 'TMEM191B', 'transmembrane protein 191B', 'protein-coding gene', 'ENSG00000278558'),
(7238, 26775, 'TMEM192', 'transmembrane protein 192', 'protein-coding gene', 'ENSG00000170088'),
(7239, 33719, 'TMEM201', 'transmembrane protein 201', 'protein-coding gene', 'ENSG00000188807'),
(7240, 53265, 'TMEM202-AS1', 'TMEM202 antisense RNA 1', 'non-coding RNA', 'ENSG00000261423'),
(7241, 28217, 'TMEM203', 'transmembrane protein 203', 'protein-coding gene', 'ENSG00000187713'),
(7242, 33705, 'TMEM207', 'transmembrane protein 207', 'protein-coding gene', 'ENSG00000198398'),
(7243, 41505, 'TMEM212-IT1', 'TMEM212 intronic transcript 1', 'non-coding RNA', 'ENSG00000235943'),
(7244, 44357, 'TMEM220-AS1', 'TMEM220 antisense RNA 1', 'non-coding RNA', 'ENSG00000263400'),
(7245, 25363, 'TMEM222', 'transmembrane protein 222', 'protein-coding gene', 'ENSG00000186501'),
(7246, 37234, 'TMEM231', 'transmembrane protein 231', 'protein-coding gene', 'ENSG00000205084'),
(7247, 23473, 'TMEM236', 'transmembrane protein 236', 'protein-coding gene', 'ENSG00000148483'),
(7248, 14432, 'TMEM237', 'transmembrane protein 237', 'protein-coding gene', 'ENSG00000155755'),
(7249, 42967, 'TMEM247', 'transmembrane protein 247', 'protein-coding gene', 'ENSG00000284701'),
(7250, 31009, 'TMEM250', 'transmembrane protein 250', 'protein-coding gene', 'ENSG00000238227'),
(7251, 20218, 'TMEM251', 'transmembrane protein 251', 'protein-coding gene', 'ENSG00000153485'),
(7252, 52396, 'TMEM251P1', 'transmembrane protein 251 pseudogene 1', 'pseudogene', 'ENSG00000249514'),
(7253, 25804, 'TMEM254', 'transmembrane protein 254', 'protein-coding gene', 'ENSG00000133678'),
(7254, 26086, 'TMEM255A', 'transmembrane protein 255A', 'protein-coding gene', 'ENSG00000125355'),
(7255, 28297, 'TMEM255B', 'transmembrane protein 255B', 'protein-coding gene', 'ENSG00000184497'),
(7256, 55395, 'TMEM263-DT', 'TMEM263 divergent transcript', 'non-coding RNA', 'ENSG00000260329'),
(7257, 24513, 'TMEM268', 'transmembrane protein 268', 'protein-coding gene', 'ENSG00000157693'),
(7258, 52381, 'TMEM269', 'transmembrane protein 269', 'protein-coding gene', 'ENSG00000274386'),
(7259, 53732, 'TMEM274P', 'transmembrane protein 274, pseudogene', 'pseudogene', 'ENSG00000283611'),
(7260, 32431, 'TMIGD1', 'transmembrane and immunoglobulin domain containing 1', 'protein-coding gene', 'ENSG00000182271'),
(7261, 28324, 'TMIGD2', 'transmembrane and immunoglobulin domain containing 2', 'protein-coding gene', 'ENSG00000167664'),
(7262, 18308, 'TMLHE', 'trimethyllysine hydroxylase, epsilon', 'protein-coding gene', 'ENSG00000185973'),
(7263, 11871, 'TMOD1', 'tropomodulin 1', 'protein-coding gene', 'ENSG00000136842'),
(7264, 11873, 'TMOD3', 'tropomodulin 3', 'protein-coding gene', 'ENSG00000138594'),
(7265, 44158, 'TMPO-AS1', 'TMPO antisense RNA 1', 'non-coding RNA', 'ENSG00000257167'),
(7266, 16517, 'TMPRSS6', 'transmembrane serine protease 6', 'protein-coding gene', 'ENSG00000187045'),
(7267, 30846, 'TMPRSS7', 'transmembrane serine protease 7', 'protein-coding gene', 'ENSG00000176040'),
(7268, 24465, 'TMPRSS11E', 'transmembrane serine protease 11E', 'protein-coding gene', 'ENSG00000087128'),
(7269, 42983, 'TMPRSS11GP', 'transmembrane serine protease 11G, pseudogene', 'pseudogene', 'ENSG00000229009'),
(7270, 28779, 'TMPRSS12', 'transmembrane serine protease 12', 'protein-coding gene', 'ENSG00000186452'),
(7271, 11885, 'TMSB4XP8', 'TMSB4X pseudogene 8', 'pseudogene', 'ENSG00000187653'),
(7272, 41950, 'TMSB10P2', 'thymosin beta 10 pseudogene 2', 'pseudogene', 'ENSG00000235211'),
(7273, 25904, 'TMTC4', 'transmembrane O-mannosyltransferase targeting cadherins 4', 'protein-coding gene', 'ENSG00000125247'),
(7274, 21709, 'TMUB1', 'transmembrane and ubiquitin like domain containing 1', 'protein-coding gene', 'ENSG00000164897'),
(7275, 28459, 'TMUB2', 'transmembrane and ubiquitin like domain containing 2', 'protein-coding gene', 'ENSG00000168591'),
(7276, 30739, 'TMX2', 'thioredoxin related transmembrane protein 2', 'protein-coding gene', 'ENSG00000213593'),
(7277, 5318, 'TNC', 'tenascin C', 'protein-coding gene', 'ENSG00000041982'),
(7278, 17260, 'TNFAIP8', 'TNF alpha induced protein 8', 'protein-coding gene', 'ENSG00000145779'),
(7279, 28279, 'TNFAIP8L1', 'TNF alpha induced protein 8 like 1', 'protein-coding gene', 'ENSG00000185361'),
(7280, 20620, 'TNFAIP8L3', 'TNF alpha induced protein 8 like 3', 'protein-coding gene', 'ENSG00000183578'),
(7281, 11924, 'TNFRSF9', 'TNF receptor superfamily member 9', 'protein-coding gene', 'ENSG00000049249'),
(7282, 53164, 'TNFRSF10A-AS1', 'TNFRSF10A antisense RNA 1', 'non-coding RNA', 'ENSG00000253930'),
(7283, 18152, 'TNFRSF12A', 'TNF receptor superfamily member 12A', 'protein-coding gene', 'ENSG00000006327'),
(7284, 18153, 'TNFRSF13B', 'TNF receptor superfamily member 13B', 'protein-coding gene', 'ENSG00000240505'),
(7285, 11926, 'TNFSF11', 'TNF superfamily member 11', 'protein-coding gene', 'ENSG00000120659'),
(7286, 11930, 'TNFSF14', 'TNF superfamily member 14', 'protein-coding gene', 'ENSG00000125735'),
(7287, 11932, 'TNFSF18', 'TNF superfamily member 18', 'protein-coding gene', 'ENSG00000120337'),
(7288, 30765, 'TNIK', 'TRAF2 and NCK interacting kinase', 'protein-coding gene', 'ENSG00000154310'),
(7289, 16903, 'TNIP1', 'TNFAIP3 interacting protein 1', 'protein-coding gene', 'ENSG00000145901'),
(7290, 19081, 'TNKS1BP1', 'tankyrase 1 binding protein 1', 'protein-coding gene', 'ENSG00000149115'),
(7291, 22942, 'TNN', 'tenascin N', 'protein-coding gene', 'ENSG00000120332'),
(7292, 11949, 'TNNT2', 'troponin T2, cardiac type', 'protein-coding gene', 'ENSG00000118194'),
(7293, 11951, 'TNP1', 'transition protein 1', 'protein-coding gene', 'ENSG00000118245'),
(7294, 40328, 'TNPO1-DT', 'TNPO1 divergent transcript', 'non-coding RNA', 'ENSG00000249085'),
(7295, 11953, 'TNR', 'tenascin R', 'protein-coding gene', 'ENSG00000116147'),
(7296, 11969, 'TNRC6A', 'trinucleotide repeat containing adaptor 6A', 'protein-coding gene', 'ENSG00000090905'),
(7297, 34014, 'TNRC18P2', 'trinucleotide repeat containing 18 pseudogene 2', 'pseudogene', 'ENSG00000223566'),
(7298, 40589, 'TNS1-AS1', 'TNS1 antisense RNA 1', 'non-coding RNA', 'ENSG00000223923'),
(7299, 19737, 'TNS2', 'tensin 2', 'protein-coding gene', 'ENSG00000111077'),
(7300, 11975, 'TNXA', 'tenascin XA (pseudogene)', 'pseudogene', 'ENSG00000248290'),
(7301, 11976, 'TNXB', 'tenascin XB', 'protein-coding gene', 'ENSG00000168477'),
(7302, 11979, 'TOB1', 'transducer of ERBB2, 1', 'protein-coding gene', 'ENSG00000141232'),
(7303, 11982, 'TOM1', 'target of myb1 membrane trafficking protein', 'protein-coding gene', 'ENSG00000100284'),
(7304, 31369, 'TOMM5', 'translocase of outer mitochondrial membrane 5', 'protein-coding gene', 'ENSG00000175768'),
(7305, 33752, 'TOMM20L', 'translocase of outer mitochondrial membrane 20 like', 'protein-coding gene', 'ENSG00000196860'),
(7306, 50518, 'TOMM20P1', 'TOMM20 pseudogene 1', 'pseudogene', 'ENSG00000224829'),
(7307, 54624, 'TOMM40P2', 'TOMM40 pseudogene 2', 'pseudogene', 'ENSG00000215270'),
(7308, 54632, 'TOMM40P3', 'TOMM40 pseudogene 3', 'pseudogene', 'ENSG00000249360'),
(7309, 55527, 'TOMT', 'transmembrane O-methyltransferase', 'protein-coding gene', 'ENSG00000284844'),
(7310, 11987, 'TOP1P1', 'DNA topoisomerase I pseudogene 1', 'pseudogene', 'ENSG00000285665'),
(7311, 11990, 'TOP2B', 'DNA topoisomerase II beta', 'protein-coding gene', 'ENSG00000077097'),
(7312, 17008, 'TOPBP1', 'DNA topoisomerase II binding protein 1', 'protein-coding gene', 'ENSG00000163781'),
(7313, 21653, 'TOPORS', 'TOP1 binding arginine/serine rich protein, E3 ubiquitin ligase', 'protein-coding gene', 'ENSG00000197579'),
(7314, 18988, 'TOX', 'thymocyte selection associated high mobility group box', 'protein-coding gene', 'ENSG00000198846'),
(7315, 16095, 'TOX2', 'TOX high mobility group box family member 2', 'protein-coding gene', 'ENSG00000124191'),
(7316, 20161, 'TOX4', 'TOX high mobility group box family member 4', 'protein-coding gene', 'ENSG00000092203'),
(7317, 44009, 'TOX4P1', 'TOX high mobility group box family member 4 pseudogene 1', 'pseudogene', 'ENSG00000248697'),
(7318, 11998, 'TP53', 'tumor protein p53', 'protein-coding gene', 'ENSG00000141510'),
(7319, 11999, 'TP53BP1', 'tumor protein p53 binding protein 1', 'protein-coding gene', 'ENSG00000067369'),
(7320, 30759, 'TP53TG3', 'TP53 target 3', 'protein-coding gene', 'ENSG00000183632'),
(7321, 37202, 'TP53TG3B', 'TP53 target 3B', 'protein-coding gene', 'ENSG00000261509'),
(7322, 42962, 'TP53TG3C', 'TP53 target 3C', 'protein-coding gene', 'ENSG00000205457'),
(7323, 15979, 'TP63', 'tumor protein p63', 'protein-coding gene', 'ENSG00000073282'),
(7324, 40591, 'TP73-AS2', 'TP73 antisense RNA 2', 'non-coding RNA', 'ENSG00000235131'),
(7325, 44159, 'TPBGL', 'trophoblast glycoprotein like', 'protein-coding gene', 'ENSG00000261594'),
(7326, 12006, 'TPD52L1', 'TPD52 like 1', 'protein-coding gene', 'ENSG00000111907'),
(7327, 23382, 'TPD52L3', 'TPD52 like 3', 'protein-coding gene', 'ENSG00000170777'),
(7328, 12008, 'TPH1', 'tryptophan hydroxylase 1', 'protein-coding gene', 'ENSG00000129167'),
(7329, 39166, 'TPM3P3', 'tropomyosin 3 pseudogene 3', 'pseudogene', 'ENSG00000254195'),
(7330, 39168, 'TPM3P5', 'tropomyosin 3 pseudogene 5', 'pseudogene', 'ENSG00000268034'),
(7331, 44142, 'TPM3P9', 'tropomyosin 3 pseudogene 9', 'pseudogene', 'ENSG00000241015'),
(7332, 2073, 'TPP1', 'tripeptidyl peptidase 1', 'protein-coding gene', 'ENSG00000166340'),
(7333, 12017, 'TPR', 'translocated promoter region, nuclear basket protein', 'protein-coding gene', 'ENSG00000047410'),
(7334, 52353, 'TPRG1LP1', 'tumor protein p63 regulated 1 like pseudogene 1', 'pseudogene', 'ENSG00000269097'),
(7335, 44943, 'TPRKBP1', 'TP53RK binding protein pseudogene 1', 'pseudogene', 'ENSG00000231911'),
(7336, 32175, 'TPRX2', 'tetrapeptide repeat homeobox 2', 'protein-coding gene', 'ENSG00000259009'),
(7337, 14120, 'TPSB2', 'tryptase beta 2', 'protein-coding gene', 'ENSG00000197253'),
(7338, 44425, 'TPST2P1', 'tyrosylprotein sulfotransferase 2 pseudogene 1', 'pseudogene', 'ENSG00000260582'),
(7339, 43686, 'TPT1-AS1', 'TPT1 antisense RNA 1', 'non-coding RNA', 'ENSG00000170919'),
(7340, 49294, 'TPT1P2', 'TPT1 pseudogene 2', 'pseudogene', 'ENSG00000228111'),
(7341, 49297, 'TPT1P6', 'TPT1 pseudogene 6', 'pseudogene', 'ENSG00000214460'),
(7342, 49300, 'TPT1P7', 'TPT1 pseudogene 7', 'pseudogene', 'ENSG00000231328'),
(7343, 38077, 'TPTE2P4', 'transmembrane phosphoinositide 3-phosphatase and tensin homolog 2 pseudogene 4', 'pseudogene', 'ENSG00000215506'),
(7344, 42644, 'TPTE2P6', 'transmembrane phosphoinositide 3-phosphatase and tensin homolog 2 pseudogene 6', 'pseudogene', 'ENSG00000205822'),
(7345, 16645, 'TRA2A', 'transformer 2 alpha homolog', 'protein-coding gene', 'ENSG00000164548'),
(7346, 27013, 'TRABD2A', 'TraB domain containing 2A', 'protein-coding gene', 'ENSG00000186854'),
(7347, 12048, 'TRAJ2', 'T cell receptor alpha joining 2 (non-functional)', 'other', 'ENSG00000211887'),
(7348, 12095, 'TRAJ7', 'T cell receptor alpha joining 7', 'other', 'ENSG00000211882'),
(7349, 12040, 'TRAJ12', 'T cell receptor alpha joining 12', 'other', 'ENSG00000211877'),
(7350, 12046, 'TRAJ18', 'T cell receptor alpha joining 18', 'other', 'ENSG00000211871'),
(7351, 12052, 'TRAJ23', 'T cell receptor alpha joining 23', 'other', 'ENSG00000211866'),
(7352, 12057, 'TRAJ28', 'T cell receptor alpha joining 28', 'other', 'ENSG00000211861'),
(7353, 12063, 'TRAJ33', 'T cell receptor alpha joining 33', 'other', 'ENSG00000211856'),
(7354, 12068, 'TRAJ38', 'T cell receptor alpha joining 38', 'other', 'ENSG00000211851'),
(7355, 12074, 'TRAJ43', 'T cell receptor alpha joining 43', 'other', 'ENSG00000211846'),
(7356, 12079, 'TRAJ48', 'T cell receptor alpha joining 48', 'other', 'ENSG00000211841'),
(7357, 12085, 'TRAJ53', 'T cell receptor alpha joining 53', 'other', 'ENSG00000211837'),
(7358, 12090, 'TRAJ58', 'T cell receptor alpha joining 58 (non-functional)', 'other', 'ENSG00000211833'),
(7359, 28371, 'TRAM1L1', 'translocation associated membrane protein 1 like 1', 'protein-coding gene', 'ENSG00000174599'),
(7360, 19894, 'TRAPPC1', 'trafficking protein particle complex subunit 1', 'protein-coding gene', 'ENSG00000170043'),
(7361, 30887, 'TRAPPC2L', 'trafficking protein particle complex subunit 2L', 'protein-coding gene', 'ENSG00000167515'),
(7362, 10711, 'TRAPPC2P2', 'trafficking protein particle complex 2 pseudogene 2', 'pseudogene', 'ENSG00000253124'),
(7363, 37731, 'TRAPPC2P8', 'trafficking protein particle complex 2 pseudogene 8', 'pseudogene', 'ENSG00000225895'),
(7364, 19942, 'TRAPPC3', 'trafficking protein particle complex subunit 3', 'protein-coding gene', 'ENSG00000054116'),
(7365, 23069, 'TRAPPC6A', 'trafficking protein particle complex subunit 6A', 'protein-coding gene', 'ENSG00000007255'),
(7366, 29169, 'TRAPPC8', 'trafficking protein particle complex subunit 8', 'protein-coding gene', 'ENSG00000153339'),
(7367, 24284, 'TRAPPC12', 'trafficking protein particle complex subunit 12', 'protein-coding gene', 'ENSG00000171853'),
(7368, 25828, 'TRAPPC13', 'trafficking protein particle complex subunit 13', 'protein-coding gene', 'ENSG00000113597'),
(7369, 12143, 'TRAV5', 'T cell receptor alpha variable 5', 'other', 'ENSG00000211779'),
(7370, 12148, 'TRAV8-3', 'T cell receptor alpha variable 8-3', 'other', 'ENSG00000211787'),
(7371, 12153, 'TRAV9-1', 'T cell receptor alpha variable 9-1', 'other', 'ENSG00000211783'),
(7372, 12107, 'TRAV12-3', 'T cell receptor alpha variable 12-3', 'other', 'ENSG00000211794'),
(7373, 12109, 'TRAV13-2', 'T cell receptor alpha variable 13-2', 'other', 'ENSG00000211791'),
(7374, 12115, 'TRAV19', 'T cell receptor alpha variable 19', 'other', 'ENSG00000211799'),
(7375, 12119, 'TRAV22', 'T cell receptor alpha variable 22', 'other', 'ENSG00000211802'),
(7376, 12123, 'TRAV26-1', 'T cell receptor alpha variable 26-1', 'other', 'ENSG00000211807'),
(7377, 12124, 'TRAV26-2', 'T cell receptor alpha variable 26-2', 'other', 'ENSG00000211812'),
(7378, 12129, 'TRAV30', 'T cell receptor alpha variable 30', 'other', 'ENSG00000259092'),
(7379, 12137, 'TRAV38-1', 'T cell receptor alpha variable 38-1', 'other', 'ENSG00000211816'),
(7380, 12164, 'TRBJ1-3', 'T cell receptor beta joining 1-3', 'other', 'ENSG00000282133'),
(7381, 12168, 'TRBJ2-1', 'T cell receptor beta joining 2-1', 'other', 'ENSG00000211764'),
(7382, 12173, 'TRBJ2-5', 'T cell receptor beta joining 2-5', 'other', 'ENSG00000211769'),
(7383, 12176, 'TRBV1', 'T cell receptor beta variable 1 (pseudogene)', 'pseudogene', 'ENSG00000242736'),
(7384, 12220, 'TRBV5-3', 'T cell receptor beta variable 5-3 (non-functional)', 'other', 'ENSG00000211715'),
(7385, 12221, 'TRBV5-4', 'T cell receptor beta variable 5-4', 'other', 'ENSG00000230099'),
(7386, 12226, 'TRBV6-1', 'T cell receptor beta variable 6-1', 'other', 'ENSG00000211706'),
(7387, 12240, 'TRBV7-6', 'T cell receptor beta variable 7-6', 'other', 'ENSG00000211727'),
(7388, 12243, 'TRBV7-9', 'T cell receptor beta variable 7-9', 'other', 'ENSG00000278030'),
(7389, 12244, 'TRBV8-1', 'T cell receptor beta variable 8-1 (pseudogene)', 'pseudogene', 'ENSG00000243889'),
(7390, 12178, 'TRBV10-2', 'T cell receptor beta variable 10-2', 'other', 'ENSG00000229769'),
(7391, 12186, 'TRBV12-4', 'T cell receptor beta variable 12-4', 'other', 'ENSG00000276953'),
(7392, 12192, 'TRBV17', 'T cell receptor beta variable 17 (non-functional)', 'other', 'ENSG00000277880'),
(7393, 12200, 'TRBV22-1', 'T cell receptor beta variable 22-1 (pseudogene)', 'pseudogene', 'ENSG00000240578'),
(7394, 12202, 'TRBV23OR9-2', 'T cell receptor beta variable 23/OR9-2 (pseudogene)', 'pseudogene', 'ENSG00000229063'),
(7395, 15485, 'TRBV26OR9-2', 'T cell receptor beta variable 26/OR9-2 (pseudogene)', 'pseudogene', 'ENSG00000231165'),
(7396, 12247, 'TRBVA', 'T cell receptor beta variable A (pseudogene)', 'pseudogene', 'ENSG00000239992'),
(7397, 12253, 'TRDC', 'T cell receptor delta constant', 'other', 'ENSG00000211829'),
(7398, 12256, 'TRDD3', 'T cell receptor delta diversity 3', 'other', 'ENSG00000228985'),
(7399, 17761, 'TREM2', 'triggering receptor expressed on myeloid cells 2', 'protein-coding gene', 'ENSG00000095970'),
(7400, 30808, 'TREML5P', 'triggering receptor expressed on myeloid cells like 5, pseudogene', 'pseudogene', 'ENSG00000225690'),
(7401, 12269, 'TREX1', 'three prime repair exonuclease 1', 'protein-coding gene', 'ENSG00000213689'),
(7402, 48974, 'TRG-AS1', 'T cell receptor gamma locus antisense RNA 1', 'non-coding RNA', 'ENSG00000281103'),
(7403, 12281, 'TRGJP2', 'T cell receptor gamma joining P2', 'other', 'ENSG00000211688'),
(7404, 12287, 'TRGV2', 'T cell receptor gamma variable 2', 'other', 'ENSG00000233306'),
(7405, 12286, 'TRGV11', 'T cell receptor gamma variable 11 (non-functional)', 'other', 'ENSG00000211693'),
(7406, 12296, 'TRGVA', 'T cell receptor gamma variable A (pseudogene)', 'pseudogene', 'ENSG00000225992'),
(7407, 27471, 'TRHDE-AS1', 'TRHDE antisense RNA 1', 'non-coding RNA', 'ENSG00000236333'),
(7408, 12299, 'TRHR', 'thyrotropin releasing hormone receptor', 'protein-coding gene', 'ENSG00000174417'),
(7409, 30809, 'TRIB2', 'tribbles pseudokinase 2', 'protein-coding gene', 'ENSG00000071575'),
(7410, 16277, 'TRIM6', 'tripartite motif containing 6', 'protein-coding gene', 'ENSG00000121236'),
(7411, 16278, 'TRIM7', 'tripartite motif containing 7', 'protein-coding gene', 'ENSG00000146054'),
(7412, 15579, 'TRIM8', 'tripartite motif containing 8', 'protein-coding gene', 'ENSG00000171206'),
(7413, 16288, 'TRIM9', 'tripartite motif containing 9', 'protein-coding gene', 'ENSG00000100505'),
(7414, 9976, 'TRIM13', 'tripartite motif containing 13', 'protein-coding gene', 'ENSG00000204977'),
(7415, 16284, 'TRIM15', 'tripartite motif containing 15', 'protein-coding gene', 'ENSG00000204610'),
(7416, 9975, 'TRIM27', 'tripartite motif containing 27', 'protein-coding gene', 'ENSG00000204713'),
(7417, 16289, 'TRIM31', 'tripartite motif containing 31', 'protein-coding gene', 'ENSG00000204616'),
(7418, 16280, 'TRIM36', 'tripartite motif containing 36', 'protein-coding gene', 'ENSG00000152503'),
(7419, 19018, 'TRIM45', 'tripartite motif containing 45', 'protein-coding gene', 'ENSG00000134253'),
(7420, 19021, 'TRIM48', 'tripartite motif containing 48', 'protein-coding gene', 'ENSG00000150244'),
(7421, 43969, 'TRIM51DP', 'tripartite motif-containing 51D, pseudogene', 'pseudogene', 'ENSG00000255190'),
(7422, 43966, 'TRIM51FP', 'tripartite motif-containing 51F, pseudogene', 'pseudogene', 'ENSG00000219061'),
(7423, 19025, 'TRIM53AP', 'tripartite motif containing 53A, pseudogene', 'pseudogene', 'ENSG00000225581'),
(7424, 14215, 'TRIM55', 'tripartite motif containing 55', 'protein-coding gene', 'ENSG00000147573'),
(7425, 30834, 'TRIM59', 'tripartite motif containing 59', 'protein-coding gene', 'ENSG00000213186'),
(7426, 21162, 'TRIM60', 'tripartite motif containing 60', 'protein-coding gene', 'ENSG00000176979'),
(7427, 43975, 'TRIM64EP', 'tripartite motif containing 64E, pseudogene', 'pseudogene', 'ENSG00000223709'),
(7428, 29005, 'TRIM66', 'tripartite motif containing 66', 'protein-coding gene', 'ENSG00000166436'),
(7429, 31859, 'TRIM67', 'tripartite motif containing 67', 'protein-coding gene', 'ENSG00000119283'),
(7430, 17857, 'TRIM69', 'tripartite motif containing 69', 'protein-coding gene', 'ENSG00000185880'),
(7431, 17453, 'TRIM74', 'tripartite motif containing 74', 'protein-coding gene', 'ENSG00000155428'),
(7432, 43980, 'TRIM77BP', 'tripartite motif containing 77B, pseudogene', 'pseudogene', 'ENSG00000254993'),
(7433, 12304, 'TRIP10', 'thyroid hormone receptor interactor 10', 'protein-coding gene', 'ENSG00000125733'),
(7434, 27828, 'TRIQK', 'triple QxxK/R motif containing', 'protein-coding gene', 'ENSG00000205133'),
(7435, 30967, 'TRMO', 'tRNA methyltransferase O', 'protein-coding gene', 'ENSG00000136932'),
(7436, 26454, 'TRMT10B', 'tRNA methyltransferase 10B', 'protein-coding gene', 'ENSG00000165275'),
(7437, 26653, 'TRMT44', 'tRNA methyltransferase 44 homolog', 'protein-coding gene', 'ENSG00000155275'),
(7438, 44020, 'TRMT112P1', 'tRNA methyltransferase subunit 11-2 pseudogene 1', 'pseudogene', 'ENSG00000250272'),
(7439, 44025, 'TRMT112P6', 'tRNA methyltransferase subunit 11-2 pseudogene 6', 'pseudogene', 'ENSG00000268412'),
(7440, 17341, 'TRNT1', 'tRNA nucleotidyl transferase 1', 'protein-coding gene', 'ENSG00000072756'),
(7441, 55453, 'TROAP-AS1', 'TROAP and PRPH antisense RNA 1', 'non-coding RNA', 'ENSG00000258334'),
(7442, 40593, 'TRPC5OS', 'TRPC5 opposite strand', 'protein-coding gene', 'ENSG00000204025'),
(7443, 55947, 'TRPC6P6', 'TRPC6 pseudogene 6', 'pseudogene', 'ENSG00000250099'),
(7444, 40937, 'TRPC7-AS2', 'TRPC7 antisense RNA 2', 'non-coding RNA', 'ENSG00000250947'),
(7445, 7146, 'TRPM1', 'transient receptor potential cation channel subfamily M member 1', 'protein-coding gene', 'ENSG00000134160'),
(7446, 17992, 'TRPM3', 'transient receptor potential cation channel subfamily M member 3', 'protein-coding gene', 'ENSG00000083067'),
(7447, 17993, 'TRPM4', 'transient receptor potential cation channel subfamily M member 4', 'protein-coding gene', 'ENSG00000130529'),
(7448, 14323, 'TRPM5', 'transient receptor potential cation channel subfamily M member 5', 'protein-coding gene', 'ENSG00000070985'),
(7449, 18084, 'TRPV3', 'transient receptor potential cation channel subfamily V member 3', 'protein-coding gene', 'ENSG00000167723'),
(7450, 28422, 'TSEN2', 'tRNA splicing endonuclease subunit 2', 'protein-coding gene', 'ENSG00000154743'),
(7451, 27561, 'TSEN54', 'tRNA splicing endonuclease subunit 54', 'protein-coding gene', 'ENSG00000182173'),
(7452, 14927, 'TSGA10', 'testis specific 10', 'protein-coding gene', 'ENSG00000135951'),
(7453, 12369, 'TSGA13', 'testis specific 13', 'protein-coding gene', 'ENSG00000213265'),
(7454, 28850, 'TSKU', 'tsukushi, small leucine rich proteoglycan', 'protein-coding gene', 'ENSG00000182704'),
(7455, 20659, 'TSPAN2', 'tetraspanin 2', 'protein-coding gene', 'ENSG00000134198'),
(7456, 17753, 'TSPAN5', 'tetraspanin 5', 'protein-coding gene', 'ENSG00000168785'),
(7457, 41462, 'TSPAN9-IT1', 'TSPAN9 intronic transcript 1', 'non-coding RNA', 'ENSG00000256197'),
(7458, 30795, 'TSPAN11', 'tetraspanin 11', 'protein-coding gene', 'ENSG00000110900'),
(7459, 23298, 'TSPAN15', 'tetraspanin 15', 'protein-coding gene', 'ENSG00000099282'),
(7460, 13594, 'TSPAN17', 'tetraspanin 17', 'protein-coding gene', 'ENSG00000048140'),
(7461, 54221, 'TSPAN18-AS1', 'TSPAN18 antisense RNA 1', 'non-coding RNA', 'ENSG00000255032'),
(7462, 1268, 'TSPEAR', 'thrombospondin type laminin G domain and EAR repeats', 'protein-coding gene', 'ENSG00000175894'),
(7463, 44148, 'TSPOAP1-AS1', 'TSPOAP1, SUPT4H1 and RNF43 antisense RNA 1', 'non-coding RNA', 'ENSG00000265148'),
(7464, 37471, 'TSPY8', 'testis specific protein Y-linked 8', 'protein-coding gene', 'ENSG00000229549'),
(7465, 37472, 'TSPY9', 'testis specific protein Y-linked 9', 'protein-coding gene', 'ENSG00000238074'),
(7466, 23904, 'TSPY12P', 'testis specific protein Y-linked 12, pseudogene', 'pseudogene', 'ENSG00000236435'),
(7467, 37725, 'TSPY18P', 'testis specific protein Y-linked 18, pseudogene', 'pseudogene', 'ENSG00000231874'),
(7468, 38093, 'TSPY20P', 'testis specific protein Y-linked 20, pseudogene', 'pseudogene', 'ENSG00000243643'),
(7469, 14521, 'TSPYL6', 'TSPY like 6', 'protein-coding gene', 'ENSG00000178021'),
(7470, 25542, 'TSR1', 'TSR1 ribosome maturation factor', 'protein-coding gene', 'ENSG00000167721'),
(7471, 12384, 'TSSC2', 'tumor suppressing subtransferable candidate 2 (pseudogene)', 'pseudogene', 'ENSG00000223756'),
(7472, 11400, 'TSSK1A', 'testis specific serine kinase 1A (pseudogene)', 'pseudogene', 'ENSG00000231086'),
(7473, 14968, 'TSSK1B', 'testis specific serine kinase 1B', 'protein-coding gene', 'ENSG00000212122'),
(7474, 30410, 'TSSK6', 'testis specific serine kinase 6', 'protein-coding gene', 'ENSG00000178093'),
(7475, 40910, 'TSTD3', 'thiosulfate sulfurtransferase like domain containing 3', 'protein-coding gene', 'ENSG00000279170'),
(7476, 19140, 'TTBK1', 'tau tubulin kinase 1', 'protein-coding gene', 'ENSG00000146216'),
(7477, 19141, 'TTBK2', 'tau tubulin kinase 2', 'protein-coding gene', 'ENSG00000128881'),
(7478, 25986, 'TTC27', 'tetratricopeptide repeat domain 27', 'protein-coding gene', 'ENSG00000018699'),
(7479, 34297, 'TTC34', 'tetratricopeptide repeat domain 34', 'protein-coding gene', 'ENSG00000215912'),
(7480, 21211, 'TTLL2', 'tubulin tyrosine ligase like 2', 'protein-coding gene', 'ENSG00000120440'),
(7481, 41486, 'TTLL7-IT1', 'TTLL7 intronic transcript 1', 'non-coding RNA', 'ENSG00000233061'),
(7482, 26693, 'TTLL10', 'tubulin tyrosine ligase like 10', 'protein-coding gene', 'ENSG00000162571'),
(7483, 44124, 'TTN-AS1', 'TTN antisense RNA 1', 'non-coding RNA', 'ENSG00000237298'),
(7484, 14022, 'TTTY1', 'testis-specific transcript, Y-linked 1', 'non-coding RNA', 'ENSG00000129845'),
(7485, 16482, 'TTTY5', 'testis-specific transcript, Y-linked 5', 'non-coding RNA', 'ENSG00000215560'),
(7486, 31887, 'TTTY6B', 'testis-specific transcript, Y-linked 6B', 'non-coding RNA', 'ENSG00000131548'),
(7487, 18488, 'TTTY7', 'testis-specific transcript, Y-linked 7', 'non-coding RNA', 'ENSG00000147753'),
(7488, 32425, 'TTTY9B', 'testis-specific transcript, Y-linked 9B', 'non-coding RNA', 'ENSG00000131007'),
(7489, 18492, 'TTTY11', 'testis-specific transcript, Y-linked 11', 'non-coding RNA', 'ENSG00000180910'),
(7490, 31890, 'TTTY17C', 'testis-specific transcript, Y-linked 17C', 'non-coding RNA', 'ENSG00000223641'),
(7491, 20766, 'TUBA1A', 'tubulin alpha 1a', 'protein-coding gene', 'ENSG00000167552'),
(7492, 24071, 'TUBA3D', 'tubulin alpha 3d', 'protein-coding gene', 'ENSG00000075886'),
(7493, 54875, 'TUBAP8', 'tubulin alpha pseudogene 8', 'pseudogene', 'ENSG00000238145'),
(7494, 23982, 'TUBB1P1', 'tubulin beta 1 class VI pseudogene 1', 'pseudogene', 'ENSG00000249726'),
(7495, 23981, 'TUBB1P2', 'tubulin beta 1 class VI pseudogene 2', 'pseudogene', 'ENSG00000228578'),
(7496, 12412, 'TUBB2A', 'tubulin beta 2A class IIa', 'protein-coding gene', 'ENSG00000137267'),
(7497, 42340, 'TUBB4AP1', 'tubulin beta 4A class IVa pseudogene 1', 'pseudogene', 'ENSG00000228466'),
(7498, 42331, 'TUBB4BP3', 'TUBB4B pseudogene 3', 'pseudogene', 'ENSG00000237458'),
(7499, 42338, 'TUBB8P3', 'tubulin beta 8 class VIII pseudogene 3', 'pseudogene', 'ENSG00000250307'),
(7500, 42185, 'TUBB8P4', 'tubulin beta 8 class VIII pseudogene 4', 'pseudogene', 'ENSG00000250788'),
(7501, 42346, 'TUBB8P8', 'tubulin beta 8 class VIII pseudogene 8', 'pseudogene', 'ENSG00000213113'),
(7502, 42348, 'TUBB8P10', 'tubulin beta 8 class VIII pseudogene 10', 'pseudogene', 'ENSG00000237469'),
(7503, 12415, 'TUBBP2', 'tubulin beta pseudogene 2', 'pseudogene', 'ENSG00000214222'),
(7504, 42184, 'TUBBP11', 'tubulin beta class I pseudogene 11', 'pseudogene', 'ENSG00000243195'),
(7505, 12418, 'TUBG1P', 'tubulin gamma 1 pseudogene', 'pseudogene', 'ENSG00000237972'),
(7506, 12421, 'TUFMP1', 'Tu translation elongation factor, mitochondrial pseudogene 1', 'pseudogene', 'ENSG00000265646'),
(7507, 44088, 'TUNAR', 'TCL1 upstream neural differentiation-associated RNA', 'non-coding RNA', 'ENSG00000250366'),
(7508, 31010, 'TUSC1', 'tumor suppressor candidate 1', 'protein-coding gene', 'ENSG00000198680'),
(7509, 17034, 'TUSC2', 'tumor suppressor 2, mitochondrial calcium regulator', 'protein-coding gene', 'ENSG00000114383'),
(7510, 27701, 'TUSC7', 'tumor suppressor candidate 7', 'non-coding RNA', 'ENSG00000243197'),
(7511, 38869, 'TVP23BP2', 'TVP23B pseudogene 2', 'pseudogene', 'ENSG00000108442'),
(7512, 21736, 'TWF1P1', 'twinfilin 1 pseudogene 1', 'pseudogene', 'ENSG00000178082'),
(7513, 12434, 'TXK', 'TXK tyrosine kinase', 'protein-coding gene', 'ENSG00000074966'),
(7514, 17772, 'TXN2', 'thioredoxin 2', 'protein-coding gene', 'ENSG00000100348'),
(7515, 54554, 'TXN2P1', 'TXN2 pseudogene 1', 'pseudogene', 'ENSG00000213540'),
(7516, 24110, 'TXNDC9', 'thioredoxin domain containing 9', 'protein-coding gene', 'ENSG00000115514'),
(7517, 28218, 'TXNDC17', 'thioredoxin domain containing 17', 'protein-coding gene', 'ENSG00000129235'),
(7518, 30551, 'TXNL4A', 'thioredoxin like 4A', 'protein-coding gene', 'ENSG00000141759'),
(7519, 26041, 'TXNL4B', 'thioredoxin like 4B', 'protein-coding gene', 'ENSG00000140830'),
(7520, 49486, 'TXNP6', 'thioredoxin pseudogene 6', 'pseudogene', 'ENSG00000234036'),
(7521, 12437, 'TXNRD1', 'thioredoxin reductase 1', 'protein-coding gene', 'ENSG00000198431'),
(7522, 12441, 'TYMS', 'thymidylate synthetase', 'protein-coding gene', 'ENSG00000176890'),
(7523, 12446, 'TYRO3', 'TYRO3 protein tyrosine kinase', 'protein-coding gene', 'ENSG00000092445'),
(7524, 12447, 'TYRO3P', 'TYRO3P protein tyrosine kinase pseudogene', 'pseudogene', 'ENSG00000259581'),
(7525, 12450, 'TYRP1', 'tyrosinase related protein 1', 'protein-coding gene', 'ENSG00000107165'),
(7526, 15947, 'UACA', 'uveal autoantigen with coiled-coil domains and ankyrin repeats', 'protein-coding gene', 'ENSG00000137831'),
(7527, 12457, 'UAP1', 'UDP-N-acetylglucosamine pyrophosphorylase 1', 'protein-coding gene', 'ENSG00000117143'),
(7528, 30661, 'UBA2', 'ubiquitin like modifier activating enzyme 2', 'protein-coding gene', 'ENSG00000126261'),
(7529, 36763, 'UBA52P6', 'ubiquitin A-52 residue ribosomal protein fusion product 1 pseudogene 6', 'pseudogene', 'ENSG00000215221'),
(7530, 35625, 'UBA52P8', 'ubiquitin A-52 residue ribosomal protein fusion product 1 pseudogene 8', 'pseudogene', 'ENSG00000240793'),
(7531, 42502, 'UBAC2-AS1', 'UBAC2 antisense RNA 1', 'non-coding RNA', 'ENSG00000228889'),
(7532, 12463, 'UBB', 'ubiquitin B', 'protein-coding gene', 'ENSG00000170315'),
(7533, 42645, 'UBBP5', 'ubiquitin B pseudogene 5', 'pseudogene', 'ENSG00000228074'),
(7534, 12468, 'UBC', 'ubiquitin C', 'protein-coding gene', 'ENSG00000150991'),
(7535, 12473, 'UBE2B', 'ubiquitin conjugating enzyme E2 B', 'protein-coding gene', 'ENSG00000119048'),
(7536, 43552, 'UBE2CP3', 'ubiquitin conjugating enzyme E2 C pseudogene 3', 'pseudogene', 'ENSG00000250384'),
(7537, 43553, 'UBE2CP4', 'ubiquitin conjugating enzyme E2 C pseudogene 4', 'pseudogene', 'ENSG00000259179'),
(7538, 12474, 'UBE2D1', 'ubiquitin conjugating enzyme E2 D1', 'protein-coding gene', 'ENSG00000072401'),
(7539, 54095, 'UBE2D3-AS1', 'UBE2D3 antisense RNA 1', 'non-coding RNA', 'ENSG00000246560'),
(7540, 28656, 'UBE2DNL', 'ubiquitin conjugating enzyme E2 D N-terminal like (pseudogene)', 'pseudogene', 'ENSG00000229547'),
(7541, 40599, 'UBE2E3-DT', 'UBE2E3 divergent transcript', 'non-coding RNA', 'ENSG00000236153'),
(7542, 44535, 'UBE2FP1', 'UBE2F pseudogene 1', 'pseudogene', 'ENSG00000224080'),
(7543, 44536, 'UBE2FP2', 'UBE2F pseudogene 2', 'pseudogene', 'ENSG00000261199'),
(7544, 31079, 'UBE2HP1', 'ubiquitin conjugating enzyme E2 H pseudogene 1', 'pseudogene', 'ENSG00000253677'),
(7545, 12485, 'UBE2I', 'ubiquitin conjugating enzyme E2 I', 'protein-coding gene', 'ENSG00000103275'),
(7546, 13477, 'UBE2L5', 'ubiquitin conjugating enzyme E2 L5', 'protein-coding gene', 'ENSG00000236444'),
(7547, 32195, 'UBE2MP1', 'ubiquitin conjugating enzyme E2 M pseudogene 1', 'pseudogene', 'ENSG00000261461'),
(7548, 40722, 'UBE2Q1-AS1', 'UBE2Q1 antisense RNA 1', 'non-coding RNA', 'ENSG00000229780'),
(7549, 44656, 'UBE2Q2L', 'ubiquitin conjugating enzyme E2 Q2 like', 'protein-coding gene', 'ENSG00000259511'),
(7550, 37440, 'UBE2Q2P2', 'UBE2Q2 pseudogene 2', 'pseudogene', 'ENSG00000259429'),
(7551, 38429, 'UBE2Q2P4Y', 'UBE2Q2 pseudogene 4, Y-linked', 'pseudogene', 'ENSG00000225491'),
(7552, 49521, 'UBE2Q2P8', 'UBE2Q2 pseudogene 8', 'pseudogene', 'ENSG00000259633'),
(7553, 49518, 'UBE2Q2P10', 'UBE2Q2 pseudogene 10', 'pseudogene', 'ENSG00000233915'),
(7554, 25009, 'UBE2T', 'ubiquitin conjugating enzyme E2 T', 'protein-coding gene', 'ENSG00000077152'),
(7555, 16581, 'UBE2V1P1', 'UBE2V1 pseudogene 1', 'pseudogene', 'ENSG00000226632'),
(7556, 44888, 'UBE2V1P5', 'UBE2V1 pseudogene 5', 'pseudogene', 'ENSG00000226582'),
(7557, 52411, 'UBE2V1P13', 'UBE2V1 pseudogene 13', 'pseudogene', 'ENSG00000224584'),
(7558, 52414, 'UBE2V1P15', 'UBE2V1 pseudogene 15', 'pseudogene', 'ENSG00000217680'),
(7559, 44887, 'UBE2V2P2', 'ubiquitin conjugating enzyme E2 V2 pseudogene 2', 'pseudogene', 'ENSG00000267463'),
(7560, 25616, 'UBE2W', 'ubiquitin conjugating enzyme E2 W', 'protein-coding gene', 'ENSG00000104343'),
(7561, 25847, 'UBE2Z', 'ubiquitin conjugating enzyme E2 Z', 'protein-coding gene', 'ENSG00000159202'),
(7562, 12498, 'UBE3AP2', 'ubiquitin protein ligase E3A pseudogene 2', 'pseudogene', 'ENSG00000228941'),
(7563, 30565, 'UBFD1', 'ubiquitin family domain containing 1', 'protein-coding gene', 'ENSG00000103353'),
(7564, 32309, 'UBL4B', 'ubiquitin like 4B', 'protein-coding gene', 'ENSG00000186150'),
(7565, 44111, 'UBOX5-AS1', 'UBOX5 antisense RNA 1', 'non-coding RNA', 'ENSG00000235958'),
(7566, 55518, 'UBQLN1-AS1', 'UBQLN1 antisense RNA 1', 'non-coding RNA', 'ENSG00000254473'),
(7567, 12510, 'UBQLN3', 'ubiquilin 3', 'protein-coding gene', 'ENSG00000175520'),
(7568, 1237, 'UBQLN4', 'ubiquilin 4', 'protein-coding gene', 'ENSG00000160803'),
(7569, 38662, 'UBQLN4P2', 'ubiquilin 4 pseudogene 2', 'pseudogene', 'ENSG00000226213'),
(7570, 16808, 'UBR1', 'ubiquitin protein ligase E3 component n-recognin 1', 'protein-coding gene', 'ENSG00000159459'),
(7571, 24463, 'UBTD2', 'ubiquitin domain containing 2', 'protein-coding gene', 'ENSG00000168246'),
(7572, 14860, 'UBXN4', 'UBX domain protein 4', 'protein-coding gene', 'ENSG00000144224'),
(7573, 19678, 'UCHL5', 'ubiquitin C-terminal hydrolase L5', 'protein-coding gene', 'ENSG00000116750'),
(7574, 17781, 'UCN3', 'urocortin 3', 'protein-coding gene', 'ENSG00000178473'),
(7575, 12518, 'UCP2', 'uncoupling protein 2', 'protein-coding gene', 'ENSG00000175567'),
(7576, 23039, 'UFL1', 'UFM1 specific ligase 1', 'protein-coding gene', 'ENSG00000014123'),
(7577, 40601, 'UGDH-AS1', 'UGDH antisense RNA 1', 'non-coding RNA', 'ENSG00000249348'),
(7578, 32191, 'UGT1A13P', 'UDP glucuronosyltransferase family 1 member A13, pseudogene', 'pseudogene', 'ENSG00000234143'),
(7579, 12553, 'UGT2B4', 'UDP glucuronosyltransferase family 2 member B4', 'protein-coding gene', 'ENSG00000156096'),
(7580, 12544, 'UGT2B10', 'UDP glucuronosyltransferase family 2 member B10', 'protein-coding gene', 'ENSG00000109181'),
(7581, 12549, 'UGT2B25P', 'UDP glucuronosyltransferase family 2 member B25, pseudogene', 'pseudogene', 'ENSG00000215110'),
(7582, 12550, 'UGT2B26P', 'UDP glucuronosyltransferase family 2 member B26, pseudogene', 'pseudogene', 'ENSG00000250919'),
(7583, 26625, 'UGT3A1', 'UDP glycosyltransferase family 3 member A1', 'protein-coding gene', 'ENSG00000145626'),
(7584, 12556, 'UHRF1', 'ubiquitin like with PHD and ring finger domains 1', 'protein-coding gene', 'ENSG00000276043'),
(7585, 12558, 'ULK1', 'unc-51 like autophagy activating kinase 1', 'protein-coding gene', 'ENSG00000177169'),
(7586, 19703, 'ULK3', 'unc-51 like kinase 3', 'protein-coding gene', 'ENSG00000140474'),
(7587, 15777, 'ULK4P3', 'ULK4 pseudogene 3', 'pseudogene', 'ENSG00000178081'),
(7588, 12560, 'UMODL1', 'uromodulin like 1', 'protein-coding gene', 'ENSG00000177398'),
(7589, 45096, 'UNC5B-AS1', 'UNC5B antisense RNA 1', 'non-coding RNA', 'ENSG00000237512'),
(7590, 55246, 'UNC5C-AS1', 'UNC5C antisense RNA 1', 'non-coding RNA', 'ENSG00000271474'),
(7591, 23147, 'UNC13D', 'unc-13 homolog D', 'protein-coding gene', 'ENSG00000092929'),
(7592, 34053, 'UNC93B6', 'unc-93 homolog B6 (pseudogene)', 'pseudogene', 'ENSG00000255562'),
(7593, 18579, 'UNGP1', 'uracil-DNA glycosylase pseudogene 1', 'pseudogene', 'ENSG00000260818'),
(7594, 12575, 'UOX', 'urate oxidase (pseudogene)', 'pseudogene', 'ENSG00000240520'),
(7595, 9962, 'UPF1', 'UPF1 RNA helicase and ATPase', 'protein-coding gene', 'ENSG00000005007'),
(7596, 12579, 'UPK2', 'uroplakin 2', 'protein-coding gene', 'ENSG00000110375'),
(7597, 53444, 'UPK3BL2', 'uroplakin 3B like 2', 'protein-coding gene', 'ENSG00000284981'),
(7598, 55757, 'UPK3BL3P', 'uroplakin 3B like 3, pseudogene', 'pseudogene', 'ENSG00000239556'),
(7599, 42353, 'UPK3BP1', 'uroplakin 3B pseudogene 1', 'pseudogene', 'ENSG00000242435'),
(7600, 28334, 'UPRT', 'uracil phosphoribosyltransferase homolog', 'protein-coding gene', 'ENSG00000094841'),
(7601, 55521, 'UQCRB-AS1', 'UQCRB antisense RNA 1', 'non-coding RNA', 'ENSG00000254224'),
(7602, 12590, 'UQCRH', 'ubiquinol-cytochrome c reductase hinge protein', 'protein-coding gene', 'ENSG00000173660'),
(7603, 38046, 'UQCRHP3', 'ubiquinol-cytochrome c reductase hinge protein pseudogene 3', 'pseudogene', 'ENSG00000224162'),
(7604, 38047, 'UQCRHP4', 'ubiquinol-cytochrome c reductase hinge protein pseudogene 4', 'pseudogene', 'ENSG00000242728'),
(7605, 29594, 'UQCRQ', 'ubiquinol-cytochrome c reductase complex III subunit VII', 'protein-coding gene', 'ENSG00000164405'),
(7606, 28967, 'URB2', 'URB2 ribosome biogenesis homolog', 'protein-coding gene', 'ENSG00000135763');
INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`, `ensembl_id`) VALUES
(7607, 12593, 'USF1', 'upstream transcription factor 1', 'protein-coding gene', 'ENSG00000158773'),
(7608, 12594, 'USF2', 'upstream transcription factor 2, c-fos interacting', 'protein-coding gene', 'ENSG00000105698'),
(7609, 16356, 'USH1G', 'USH1 protein network component sans', 'protein-coding gene', 'ENSG00000182040'),
(7610, 30904, 'USO1', 'USO1 vesicle transport factor', 'protein-coding gene', 'ENSG00000138768'),
(7611, 12627, 'USP4', 'ubiquitin specific peptidase 4', 'protein-coding gene', 'ENSG00000114316'),
(7612, 54601, 'USP8P2', 'USP8 pseudogene 2', 'pseudogene', 'ENSG00000226340'),
(7613, 38720, 'USP9YP12', 'USP9Y pseudogene 12', 'pseudogene', 'ENSG00000227871'),
(7614, 38748, 'USP9YP14', 'USP9Y pseudogene 14', 'pseudogene', 'ENSG00000227494'),
(7615, 38753, 'USP9YP17', 'USP9Y pseudogene 17', 'pseudogene', 'ENSG00000229553'),
(7616, 38766, 'USP9YP30', 'USP9Y pseudogene 30', 'pseudogene', 'ENSG00000235004'),
(7617, 38776, 'USP9YP32', 'USP9Y pseudogene 32', 'pseudogene', 'ENSG00000237616'),
(7618, 23195, 'USP12PY', 'USP12 pseudogene Y-linked', 'pseudogene', 'ENSG00000232927'),
(7619, 37175, 'USP17L3', 'ubiquitin specific peptidase 17 like family member 3', 'protein-coding gene', 'ENSG00000225327'),
(7620, 37179, 'USP17L6P', 'ubiquitin specific peptidase 17 like family member 6, pseudogene', 'pseudogene', 'ENSG00000205946'),
(7621, 44441, 'USP17L13', 'ubiquitin specific peptidase 17 like family member 13', 'protein-coding gene', 'ENSG00000232399'),
(7622, 44446, 'USP17L18', 'ubiquitin specific peptidase 17 like family member 18', 'protein-coding gene', 'ENSG00000250844'),
(7623, 44451, 'USP17L23', 'ubiquitin specific peptidase 17 like family member 23', 'protein-coding gene', 'ENSG00000250913'),
(7624, 44455, 'USP17L27', 'ubiquitin specific peptidase 17 like family member 27', 'protein-coding gene', 'ENSG00000235780'),
(7625, 12624, 'USP25', 'ubiquitin specific peptidase 25', 'protein-coding gene', 'ENSG00000155313'),
(7626, 27249, 'USP27X-DT', 'USP27X divergent transcript', 'non-coding RNA', 'ENSG00000234390'),
(7627, 20060, 'USP31', 'ubiquitin specific peptidase 31', 'protein-coding gene', 'ENSG00000103404'),
(7628, 43570, 'USP32P1', 'ubiquitin specific peptidase 32 pseudogene 1', 'pseudogene', 'ENSG00000188933'),
(7629, 20064, 'USP44', 'ubiquitin specific peptidase 44', 'protein-coding gene', 'ENSG00000136014'),
(7630, 20076, 'USP47', 'ubiquitin specific peptidase 47', 'protein-coding gene', 'ENSG00000170242'),
(7631, 18533, 'USP48', 'ubiquitin specific peptidase 48', 'protein-coding gene', 'ENSG00000090686'),
(7632, 24477, 'UTP3', 'UTP3 small subunit processome component', 'protein-coding gene', 'ENSG00000132467'),
(7633, 25758, 'UTP15', 'UTP15 small subunit processome component', 'protein-coding gene', 'ENSG00000164338'),
(7634, 12635, 'UTRN', 'utrophin', 'protein-coding gene', 'ENSG00000152818'),
(7635, 12640, 'UVRAG', 'UV radiation resistance associated', 'protein-coding gene', 'ENSG00000198382'),
(7636, 12644, 'VAMP3', 'vesicle associated membrane protein 3', 'protein-coding gene', 'ENSG00000049245'),
(7637, 12649, 'VAPB', 'VAMP associated protein B and C', 'protein-coding gene', 'ENSG00000124164'),
(7638, 53215, 'VASH1-AS1', 'VASH1 antisense RNA 1', 'non-coding RNA', 'ENSG00000258301'),
(7639, 12659, 'VAV3', 'vav guanine nucleotide exchange factor 3', 'protein-coding gene', 'ENSG00000134215'),
(7640, 40163, 'VCAN-AS1', 'VCAN antisense RNA 1', 'non-coding RNA', 'ENSG00000249835'),
(7641, 12668, 'VCY', 'variable charge Y-linked', 'protein-coding gene', 'ENSG00000129864'),
(7642, 12671, 'VDAC1P1', 'voltage dependent anion channel 1 pseudogene 1', 'pseudogene', 'ENSG00000073905'),
(7643, 37479, 'VDAC1P10', 'voltage dependent anion channel 1 pseudogene 10', 'pseudogene', 'ENSG00000232809'),
(7644, 39680, 'VDAC1P12', 'voltage dependent anion channel 1 pseudogene 12', 'pseudogene', 'ENSG00000227254'),
(7645, 32693, 'VDAC2P2', 'VDAC2 pseudogene 2', 'pseudogene', 'ENSG00000255776'),
(7646, 20722, 'VDAC3P1', 'voltage dependent anion channel 3 pseudogene 1', 'pseudogene', 'ENSG00000271198'),
(7647, 12680, 'VEGFA', 'vascular endothelial growth factor A', 'protein-coding gene', 'ENSG00000112715'),
(7648, 54910, 'VENTXP8', 'VENTX pseudogene 8', 'pseudogene', 'ENSG00000230265'),
(7649, 30666, 'VHLL', 'VHL like', 'protein-coding gene', 'ENSG00000189030'),
(7650, 40610, 'VIPR1-AS1', 'VIPR1 antisense RNA 1', 'non-coding RNA', 'ENSG00000232354'),
(7651, 55531, 'VIRMA-DT', 'VIRMA divergent transcript', 'non-coding RNA', 'ENSG00000253704'),
(7652, 23663, 'VKORC1', 'vitamin K epoxide reductase complex subunit 1', 'protein-coding gene', 'ENSG00000167397'),
(7653, 33182, 'VKORC1P1', 'VKORC1 pseudogene 1', 'pseudogene', 'ENSG00000233243'),
(7654, 13548, 'VN1R1', 'vomeronasal 1 receptor 1', 'protein-coding gene', 'ENSG00000178201'),
(7655, 19867, 'VN1R3', 'vomeronasal 1 receptor 3', 'other', 'ENSG00000180663'),
(7656, 20257, 'VN1R9P', 'vomeronasal 1 receptor 9 pseudogene', 'pseudogene', 'ENSG00000276400'),
(7657, 37336, 'VN1R21P', 'vomeronasal 1 receptor 21 pseudogene', 'pseudogene', 'ENSG00000224752'),
(7658, 37352, 'VN1R32P', 'vomeronasal 1 receptor 32 pseudogene', 'pseudogene', 'ENSG00000230361'),
(7659, 37354, 'VN1R34P', 'vomeronasal 1 receptor 34 pseudogene', 'pseudogene', 'ENSG00000233173'),
(7660, 37357, 'VN1R37P', 'vomeronasal 1 receptor 37 pseudogene', 'pseudogene', 'ENSG00000213643'),
(7661, 37362, 'VN1R42P', 'vomeronasal 1 receptor 42 pseudogene', 'pseudogene', 'ENSG00000223476'),
(7662, 37397, 'VN1R76P', 'vomeronasal 1 receptor 76 pseudogene', 'pseudogene', 'ENSG00000273762'),
(7663, 37400, 'VN1R79P', 'vomeronasal 1 receptor 79 pseudogene', 'pseudogene', 'ENSG00000269885'),
(7664, 37329, 'VN1R80P', 'vomeronasal 1 receptor 80 pseudogene', 'pseudogene', 'ENSG00000268598'),
(7665, 37408, 'VN1R88P', 'vomeronasal 1 receptor 88 pseudogene', 'pseudogene', 'ENSG00000268541'),
(7666, 37410, 'VN1R90P', 'vomeronasal 1 receptor 90 pseudogene', 'pseudogene', 'ENSG00000268794'),
(7667, 37428, 'VN1R105P', 'vomeronasal 1 receptor 105 pseudogene', 'pseudogene', 'ENSG00000242856'),
(7668, 33215, 'VN2R9P', 'vomeronasal 2 receptor 9, pseudogene', 'pseudogene', 'ENSG00000236541'),
(7669, 12711, 'VPS26A', 'VPS26, retromer complex component A', 'protein-coding gene', 'ENSG00000122958'),
(7670, 3044, 'VPS26C', 'VPS26 endosomal protein sorting factor C', 'protein-coding gene', 'ENSG00000157538'),
(7671, 18179, 'VPS33A', 'VPS33A core subunit of CORVET and HOPS complexes', 'protein-coding gene', 'ENSG00000139719'),
(7672, 51805, 'VPS35P1', 'VPS35 pseudogene 1', 'pseudogene', 'ENSG00000260809'),
(7673, 20312, 'VPS36', 'vacuolar protein sorting 36 homolog', 'protein-coding gene', 'ENSG00000136100'),
(7674, 25754, 'VPS37B', 'VPS37B subunit of ESCRT-I', 'protein-coding gene', 'ENSG00000139722'),
(7675, 26097, 'VPS37C', 'VPS37C subunit of ESCRT-I', 'protein-coding gene', 'ENSG00000167987'),
(7676, 55378, 'VPS39-DT', 'VPS39 divergent transcript', 'non-coding RNA', 'ENSG00000261002'),
(7677, 14579, 'VPS45', 'vacuolar protein sorting 45 homolog', 'protein-coding gene', 'ENSG00000136631'),
(7678, 11644, 'VPS72', 'vacuolar protein sorting 72 homolog', 'protein-coding gene', 'ENSG00000163159'),
(7679, 28675, 'VSIG1', 'V-set and immunoglobulin domain containing 1', 'protein-coding gene', 'ENSG00000101842'),
(7680, 27111, 'VSIG10L', 'V-set and immunoglobulin domain containing 10 like', 'protein-coding gene', 'ENSG00000186806'),
(7681, 16096, 'VSTM2L', 'V-set and transmembrane domain containing 2 like', 'protein-coding gene', 'ENSG00000132821'),
(7682, 1975, 'VSX2', 'visual system homeobox 2', 'protein-coding gene', 'ENSG00000119614'),
(7683, 20954, 'VTA1', 'vesicle trafficking 1', 'protein-coding gene', 'ENSG00000009844'),
(7684, 50483, 'VTA1P1', 'vesicle trafficking 1 pseudogene 1', 'pseudogene', 'ENSG00000224999'),
(7685, 43729, 'VTI1BP3', 'vesicle transport through interaction with t-SNAREs 1B pseudogene 3', 'pseudogene', 'ENSG00000258074'),
(7686, 43730, 'VTI1BP4', 'vesicle transport through interaction with t-SNAREs 1B pseudogene 4', 'pseudogene', 'ENSG00000227759'),
(7687, 24709, 'VWA2', 'von Willebrand factor A domain containing 2', 'protein-coding gene', 'ENSG00000165816'),
(7688, 29071, 'VWA8', 'von Willebrand factor A domain containing 8', 'protein-coding gene', 'ENSG00000102763'),
(7689, 44270, 'VWA8-AS1', 'VWA8 antisense RNA 1 (head to head)', 'non-coding RNA', 'ENSG00000278338'),
(7690, 28498, 'VXN', 'vexin', 'protein-coding gene', 'ENSG00000169085'),
(7691, 53754, 'WAKMAR2', 'wound and keratinocyte migration associated lncRNA 2', 'non-coding RNA', 'ENSG00000237499'),
(7692, 55805, 'WAPL-DT', 'WAPL divergent transcript', 'non-coding RNA', 'ENSG00000227896'),
(7693, 50482, 'WARS1P1', 'tryptophanyl-tRNA synthetase 1 pseudogene 1', 'pseudogene', 'ENSG00000225802'),
(7694, 12730, 'WARS2', 'tryptophanyl tRNA synthetase 2, mitochondrial', 'protein-coding gene', 'ENSG00000116874'),
(7695, 12731, 'WAS', 'WASP actin nucleation promoting factor', 'protein-coding gene', 'ENSG00000015285'),
(7696, 12732, 'WASF1', 'WASP family member 1', 'protein-coding gene', 'ENSG00000112290'),
(7697, 12734, 'WASF3', 'WASP family member 3', 'protein-coding gene', 'ENSG00000132970'),
(7698, 21665, 'WASF5P', 'WASP family member 5, pseudogene', 'pseudogene', 'ENSG00000231402'),
(7699, 24362, 'WASH3P', 'WASP family homolog 3, pseudogene', 'pseudogene', 'ENSG00000185596'),
(7700, 31685, 'WASH6P', 'WASP family homolog 6, pseudogene', 'pseudogene', 'ENSG00000182484'),
(7701, 24361, 'WASHC1', 'WASH complex subunit 1', 'protein-coding gene', 'ENSG00000181404'),
(7702, 54983, 'WASHC3P1', 'WASHC3 pseudogene 1', 'pseudogene', 'ENSG00000213747'),
(7703, 43958, 'WBP1LP3', 'WBP1L pseudogene 3', 'pseudogene', 'ENSG00000253612'),
(7704, 51470, 'WBP1LP10', 'WBP1L pseudogene 10', 'pseudogene', 'ENSG00000253826'),
(7705, 28389, 'WBP2NL', 'WBP2 N-terminal like', 'protein-coding gene', 'ENSG00000183066'),
(7706, 31695, 'WBP2P1', 'WW domain binding protein 2 pseudogene 1', 'pseudogene', 'ENSG00000229248'),
(7707, 26250, 'WBP11P1', 'WBP11 pseudogene 1', 'pseudogene', 'ENSG00000260389'),
(7708, 40935, 'WDFY3-AS1', 'WDFY3 antisense RNA 1', 'non-coding RNA', 'ENSG00000251260'),
(7709, 12754, 'WDR1', 'WD repeat domain 1', 'protein-coding gene', 'ENSG00000071127'),
(7710, 13490, 'WDR7', 'WD repeat domain 7', 'protein-coding gene', 'ENSG00000091157'),
(7711, 16661, 'WDR17', 'WD repeat domain 17', 'protein-coding gene', 'ENSG00000150627'),
(7712, 19667, 'WDR20', 'WD repeat domain 20', 'protein-coding gene', 'ENSG00000140153'),
(7713, 20852, 'WDR24', 'WD repeat domain 24', 'protein-coding gene', 'ENSG00000127580'),
(7714, 21208, 'WDR26', 'WD repeat domain 26', 'protein-coding gene', 'ENSG00000162923'),
(7715, 21248, 'WDR27', 'WD repeat domain 27', 'protein-coding gene', 'ENSG00000184465'),
(7716, 25651, 'WDR33', 'WD repeat domain 33', 'protein-coding gene', 'ENSG00000136709'),
(7717, 23745, 'WDR38', 'WD repeat domain 38', 'protein-coding gene', 'ENSG00000136918'),
(7718, 52406, 'WDR45P1', 'WD repeat domain 45 pseudogene 1', 'pseudogene', 'ENSG00000248208'),
(7719, 25529, 'WDR74', 'WD repeat domain 74', 'protein-coding gene', 'ENSG00000133316'),
(7720, 25773, 'WDR76', 'WD repeat domain 76', 'protein-coding gene', 'ENSG00000092470'),
(7721, 32672, 'WDR83', 'WD repeat domain 83', 'protein-coding gene', 'ENSG00000123154'),
(7722, 41186, 'WDR86-AS1', 'WDR86 antisense RNA 1', 'non-coding RNA', 'ENSG00000243836'),
(7723, 26959, 'WDR97', 'WD repeat domain 97', 'protein-coding gene', 'ENSG00000179698'),
(7724, 19684, 'WEE2', 'WEE2 oocyte meiosis inhibiting kinase', 'protein-coding gene', 'ENSG00000214102'),
(7725, 20380, 'WFDC9', 'WAP four-disulfide core domain 9', 'protein-coding gene', 'ENSG00000180205'),
(7726, 16131, 'WFDC13', 'WAP four-disulfide core domain 13', 'protein-coding gene', 'ENSG00000168634'),
(7727, 12762, 'WFS1', 'wolframin ER transmembrane glycoprotein', 'protein-coding gene', 'ENSG00000109501'),
(7728, 32361, 'WHAMMP1', 'WHAMM pseudogene 1', 'pseudogene', 'ENSG00000223509'),
(7729, 55700, 'WHAMMP4', 'WHAMM pseudogene 4', 'pseudogene', 'ENSG00000215302'),
(7730, 12736, 'WIPF1', 'WAS/WASL interacting protein family member 1', 'protein-coding gene', 'ENSG00000115935'),
(7731, 22004, 'WIPF3', 'WAS/WASL interacting protein family member 3', 'protein-coding gene', 'ENSG00000122574'),
(7732, 30238, 'WLS', 'Wnt ligand secretion mediator', 'protein-coding gene', 'ENSG00000116729'),
(7733, 14543, 'WNK3', 'WNK lysine deficient protein kinase 3', 'protein-coding gene', 'ENSG00000196632'),
(7734, 12780, 'WNT2', 'Wnt family member 2', 'protein-coding gene', 'ENSG00000105989'),
(7735, 12783, 'WNT4', 'Wnt family member 4', 'protein-coding gene', 'ENSG00000162552'),
(7736, 12785, 'WNT6', 'Wnt family member 6', 'protein-coding gene', 'ENSG00000115596'),
(7737, 12786, 'WNT7A', 'Wnt family member 7A', 'protein-coding gene', 'ENSG00000154764'),
(7738, 12787, 'WNT7B', 'Wnt family member 7B', 'protein-coding gene', 'ENSG00000188064'),
(7739, 12791, 'WRN', 'WRN RecQ like helicase', 'protein-coding gene', 'ENSG00000165392'),
(7740, 19222, 'WSB2', 'WD repeat and SOCS box containing 2', 'protein-coding gene', 'ENSG00000176871'),
(7741, 18135, 'WT1-AS', 'WT1 antisense RNA', 'non-coding RNA', 'ENSG00000183242'),
(7742, 44115, 'WTAPP1', 'Wilms tumor 1 associated protein pseudogene 1', 'pseudogene', 'ENSG00000255282'),
(7743, 24148, 'WWC2', 'WW and C2 domain containing 2', 'protein-coding gene', 'ENSG00000151718'),
(7744, 29237, 'WWC3', 'WWC family member 3', 'protein-coding gene', 'ENSG00000047644'),
(7745, 24042, 'WWTR1', 'WW domain containing transcription regulator 1', 'protein-coding gene', 'ENSG00000018408'),
(7746, 30932, 'XAF1', 'XIAP associated factor 1', 'protein-coding gene', 'ENSG00000132530'),
(7747, 25400, 'XAGE1B', 'X antigen family member 1B', 'protein-coding gene', 'ENSG00000204382'),
(7748, 4112, 'XAGE2', 'X antigen family member 2', 'protein-coding gene', 'ENSG00000155622'),
(7749, 12802, 'XBP1P1', 'X-box binding protein 1 pseudogene 1', 'pseudogene', 'ENSG00000249947'),
(7750, 12807, 'XGY1', 'XG pseudogene, Y-linked 1', 'pseudogene', 'ENSG00000227447'),
(7751, 52376, 'XIAPP2', 'X-linked inhibitor of apoptosis pseudogene 2', 'pseudogene', 'ENSG00000254843'),
(7752, 20782, 'XKR5', 'XK related 5', 'protein-coding gene', 'ENSG00000275591'),
(7753, 20937, 'XKR9', 'XK related 9', 'protein-coding gene', 'ENSG00000221947'),
(7754, 23912, 'XKRYP5', 'XK related, Y-linked pseudogene 5', 'pseudogene', 'ENSG00000223406'),
(7755, 12814, 'XPA', 'XPA, DNA damage recognition and repair factor', 'protein-coding gene', 'ENSG00000136936'),
(7756, 12816, 'XPC', 'XPC complex subunit, DNA damage recognition and repair factor', 'protein-coding gene', 'ENSG00000154767'),
(7757, 17796, 'XPO4', 'exportin 4', 'protein-coding gene', 'ENSG00000132953'),
(7758, 19733, 'XPO6', 'exportin 6', 'protein-coding gene', 'ENSG00000169180'),
(7759, 14108, 'XPO7', 'exportin 7', 'protein-coding gene', 'ENSG00000130227'),
(7760, 12831, 'XRCC4', 'X-ray repair cross complementing 4', 'protein-coding gene', 'ENSG00000152422'),
(7761, 45183, 'XRCC6P1', 'X-ray repair cross complementing 6 pseudogene 1', 'pseudogene', 'ENSG00000237417'),
(7762, 45187, 'XRCC6P5', 'X-ray repair cross complementing 6 pseudogene 5', 'pseudogene', 'ENSG00000215070'),
(7763, 12839, 'XYLB', 'xylulokinase', 'protein-coding gene', 'ENSG00000093217'),
(7764, 42430, 'YBX1P9', 'Y-box binding protein 1 pseudogene 9', 'pseudogene', 'ENSG00000236994'),
(7765, 49498, 'YBX2P1', 'YBX2 pseudogene 1', 'pseudogene', 'ENSG00000213438'),
(7766, 27158, 'YDJC', 'YdjC chitooligosaccharide deacetylase homolog', 'protein-coding gene', 'ENSG00000161179'),
(7767, 12842, 'YES1P1', 'YES1 pseudogene 1', 'pseudogene', 'ENSG00000224003'),
(7768, 16688, 'YIF1A', 'Yip1 interacting factor homolog A, membrane trafficking protein', 'protein-coding gene', 'ENSG00000174851'),
(7769, 28145, 'YIPF4', 'Yip1 domain family member 4', 'protein-coding gene', 'ENSG00000119820'),
(7770, 17798, 'YLPM1', 'YLP motif containing 1', 'protein-coding gene', 'ENSG00000119596'),
(7771, 12844, 'YME1L1P1', 'YME1L1 pseudogene 1', 'pseudogene', 'ENSG00000236831'),
(7772, 18329, 'YPEL5', 'yippee like 5', 'protein-coding gene', 'ENSG00000119801'),
(7773, 50557, 'YPEL5P3', 'YPEL5 pseudogene 3', 'pseudogene', 'ENSG00000258251'),
(7774, 31675, 'YTHDF2', 'YTH N6-methyladenosine RNA binding protein 2', 'protein-coding gene', 'ENSG00000198492'),
(7775, 12849, 'YWHAB', 'tyrosine 3-monooxygenase/tryptophan 5-monooxygenase activation protein beta', 'protein-coding gene', 'ENSG00000166913'),
(7776, 49442, 'YWHAEP1', 'tyrosine 3-monooxygenase/tryptophan 5-monooxygenase activation protein epsilon pseudogene 1', 'pseudogene', 'ENSG00000232727'),
(7777, 49440, 'YWHAEP4', 'tyrosine 3-monooxygenase/tryptophan 5-monooxygenase activation protein epsilon pseudogene 4', 'pseudogene', 'ENSG00000250205'),
(7778, 23051, 'YWHAH-AS1', 'YWHAH antisense RNA 1', 'non-coding RNA', 'ENSG00000128254'),
(7779, 19937, 'YWHAQP1', 'YWHAQ pseudogene 1', 'pseudogene', 'ENSG00000258934'),
(7780, 37684, 'YWHAQP5', 'YWHAQ pseudogene 5', 'pseudogene', 'ENSG00000236564'),
(7781, 37685, 'YWHAQP6', 'YWHAQ pseudogene 6', 'pseudogene', 'ENSG00000249986'),
(7782, 37686, 'YWHAQP7', 'YWHAQ pseudogene 7', 'pseudogene', 'ENSG00000271142'),
(7783, 30935, 'YY1AP1', 'YY1 associated protein 1', 'protein-coding gene', 'ENSG00000163374'),
(7784, 31684, 'YY2', 'YY2 transcription factor', 'protein-coding gene', 'ENSG00000230797'),
(7785, 37116, 'ZAR1L', 'zygote arrest 1 like', 'protein-coding gene', 'ENSG00000189167'),
(7786, 26245, 'ZBBX', 'zinc finger B-box domain containing', 'protein-coding gene', 'ENSG00000169064'),
(7787, 33273, 'ZBED6', 'zinc finger BED-type containing 6', 'protein-coding gene', 'ENSG00000257315'),
(7788, 42037, 'ZBED9P1', 'ZBED9 pseudogene 1', 'pseudogene', 'ENSG00000232795'),
(7789, 21720, 'ZBED10P', 'zinc finger BED-type containing 10, pseudogene', 'pseudogene', 'ENSG00000188707'),
(7790, 22918, 'ZBTB3', 'zinc finger and BTB domain containing 3', 'protein-coding gene', 'ENSG00000185670'),
(7791, 55846, 'ZBTB7C-AS1', 'ZBTB7C antisense RNA 1', 'non-coding RNA', 'ENSG00000286583'),
(7792, 24172, 'ZBTB8A', 'zinc finger and BTB domain containing 8A', 'protein-coding gene', 'ENSG00000160062'),
(7793, 19043, 'ZBTB8OSP1', 'zinc finger and BTB domain containing 8 opposite strand pseudogene 1', 'pseudogene', 'ENSG00000183432'),
(7794, 30953, 'ZBTB10', 'zinc finger and BTB domain containing 10', 'protein-coding gene', 'ENSG00000205189'),
(7795, 37702, 'ZBTB12BP', 'zinc finger and BTB domain containing 12B, pseudogene', 'pseudogene', 'ENSG00000180610'),
(7796, 42422, 'ZBTB20-AS3', 'ZBTB20 antisense RNA 3', 'non-coding RNA', 'ENSG00000239946'),
(7797, 13085, 'ZBTB22', 'zinc finger and BTB domain containing 22', 'protein-coding gene', 'ENSG00000236104'),
(7798, 13112, 'ZBTB25', 'zinc finger and BTB domain containing 25', 'protein-coding gene', 'ENSG00000089775'),
(7799, 29045, 'ZBTB40', 'zinc finger and BTB domain containing 40', 'protein-coding gene', 'ENSG00000184677'),
(7800, 25001, 'ZBTB44', 'zinc finger and BTB domain containing 44', 'protein-coding gene', 'ENSG00000196323'),
(7801, 16094, 'ZBTB46', 'zinc finger and BTB domain containing 46', 'protein-coding gene', 'ENSG00000130584'),
(7802, 26955, 'ZBTB47', 'zinc finger and BTB domain containing 47', 'protein-coding gene', 'ENSG00000114853'),
(7803, 21174, 'ZC2HC1B', 'zinc finger C2HC-type containing 1B', 'protein-coding gene', 'ENSG00000118491'),
(7804, 30959, 'ZC3H7A', 'zinc finger CCCH-type containing 7A', 'protein-coding gene', 'ENSG00000122299'),
(7805, 30941, 'ZC3H8', 'zinc finger CCCH-type containing 8', 'protein-coding gene', 'ENSG00000144161'),
(7806, 23721, 'ZC3HAV1', 'zinc finger CCCH-type containing, antiviral 1', 'protein-coding gene', 'ENSG00000105939'),
(7807, 22916, 'ZCCHC2', 'zinc finger CCHC-type containing 2', 'protein-coding gene', 'ENSG00000141664'),
(7808, 26209, 'ZCCHC7', 'zinc finger CCHC-type containing 7', 'protein-coding gene', 'ENSG00000147905'),
(7809, 24134, 'ZCCHC14', 'zinc finger CCHC-type containing 14', 'protein-coding gene', 'ENSG00000140948'),
(7810, 32459, 'ZCCHC18', 'zinc finger CCHC-type containing 18', 'protein-coding gene', 'ENSG00000166707'),
(7811, 29620, 'ZCRB1', 'zinc finger CCHC-type and RNA binding motif containing 1', 'protein-coding gene', 'ENSG00000139168'),
(7812, 23486, 'ZCWPW1', 'zinc finger CW-type and PWWP domain containing 1', 'protein-coding gene', 'ENSG00000078487'),
(7813, 29313, 'ZDBF2', 'zinc finger DBF-type containing 2', 'protein-coding gene', 'ENSG00000204186'),
(7814, 18471, 'ZDHHC4', 'zinc finger DHHC-type palmitoyltransferase 4', 'protein-coding gene', 'ENSG00000136247'),
(7815, 39443, 'ZDHHC4P1', 'zinc finger DHHC-type containing 4 pseudogene 1', 'pseudogene', 'ENSG00000238025'),
(7816, 26461, 'ZDHHC8P1', 'ZDHHC8 pseudogene 1', 'pseudogene', 'ENSG00000133519'),
(7817, 19158, 'ZDHHC11', 'zinc finger DHHC-type containing 11', 'protein-coding gene', 'ENSG00000188818'),
(7818, 19159, 'ZDHHC12', 'zinc finger DHHC-type palmitoyltransferase 12', 'protein-coding gene', 'ENSG00000160446'),
(7819, 20341, 'ZDHHC14', 'zinc finger DHHC-type palmitoyltransferase 14', 'protein-coding gene', 'ENSG00000175048'),
(7820, 39900, 'ZDHHC20-IT1', 'ZDHHC20 intronic transcript 1', 'non-coding RNA', 'ENSG00000236953'),
(7821, 20106, 'ZDHHC22', 'zinc finger DHHC-type palmitoyltransferase 22', 'protein-coding gene', 'ENSG00000177108'),
(7822, 14881, 'ZEB2', 'zinc finger E-box binding homeobox 2', 'protein-coding gene', 'ENSG00000169554'),
(7823, 41187, 'ZFAND2A-DT', 'ZFAND2A divergent transcript', 'non-coding RNA', 'ENSG00000229043'),
(7824, 30164, 'ZFAND6', 'zinc finger AN1-type containing 6', 'protein-coding gene', 'ENSG00000086666'),
(7825, 33992, 'ZFAT-AS1', 'ZFAT antisense RNA 1', 'non-coding RNA', 'ENSG00000248492'),
(7826, 777, 'ZFHX3', 'zinc finger homeobox 3', 'protein-coding gene', 'ENSG00000140836'),
(7827, 30939, 'ZFHX4', 'zinc finger homeobox 4', 'protein-coding gene', 'ENSG00000091656'),
(7828, 55340, 'ZFP3-DT', 'ZFP3 divergent transcript', 'non-coding RNA', 'ENSG00000262693'),
(7829, 1108, 'ZFP36L2', 'ZFP36 ring finger protein like 2', 'protein-coding gene', 'ENSG00000152518'),
(7830, 24708, 'ZFP69', 'ZFP69 zinc finger protein', 'protein-coding gene', 'ENSG00000187815'),
(7831, 33441, 'ZFP91-CNTF', 'ZFP91-CNTF readthrough (NMD candidate)', 'other', 'ENSG00000255073'),
(7832, 12865, 'ZFP92', 'ZFP92 zinc finger protein', 'protein-coding gene', 'ENSG00000189420'),
(7833, 55351, 'ZFPM1-AS1', 'ZFPM1 antisense RNA 1', 'non-coding RNA', 'ENSG00000261744'),
(7834, 50698, 'ZFPM2-AS1', 'ZFPM2 antisense RNA 1', 'non-coding RNA', 'ENSG00000251003'),
(7835, 28449, 'ZFTA', 'zinc finger translocation associated', 'protein-coding gene', 'ENSG00000188070'),
(7836, 12869, 'ZFX', 'zinc finger protein X-linked', 'protein-coding gene', 'ENSG00000005889'),
(7837, 39046, 'ZFYVE9P2', 'zinc finger FYVE-type containing 9 pseudogene 2', 'pseudogene', 'ENSG00000214843'),
(7838, 20756, 'ZFYVE16', 'zinc finger FYVE-type containing 16', 'protein-coding gene', 'ENSG00000039319'),
(7839, 26559, 'ZFYVE27', 'zinc finger FYVE-type containing 27', 'protein-coding gene', 'ENSG00000155256'),
(7840, 15935, 'ZHX3', 'zinc fingers and homeoboxes 3', 'protein-coding gene', 'ENSG00000174306'),
(7841, 33104, 'ZIK1', 'zinc finger protein interacting with K protein 1', 'protein-coding gene', 'ENSG00000171649'),
(7842, 13854, 'ZKSCAN4', 'zinc finger with KRAB and SCAN domains 4', 'protein-coding gene', 'ENSG00000187626'),
(7843, 12955, 'ZKSCAN7', 'zinc finger with KRAB and SCAN domains 7', 'protein-coding gene', 'ENSG00000196345'),
(7844, 29377, 'ZMAT1', 'zinc finger matrin-type 1', 'protein-coding gene', 'ENSG00000166432'),
(7845, 26433, 'ZMAT2', 'zinc finger matrin-type 2', 'protein-coding gene', 'ENSG00000146007'),
(7846, 12877, 'ZMPSTE24', 'zinc metallopeptidase STE24', 'protein-coding gene', 'ENSG00000084073'),
(7847, 13054, 'ZMYM3', 'zinc finger MYM-type containing 3', 'protein-coding gene', 'ENSG00000147130'),
(7848, 13029, 'ZMYM5', 'zinc finger MYM-type containing 5', 'protein-coding gene', 'ENSG00000132950'),
(7849, 16966, 'ZMYND11', 'zinc finger MYND-type containing 11', 'protein-coding gene', 'ENSG00000015171'),
(7850, 21146, 'ZMYND19', 'zinc finger MYND-type containing 19', 'protein-coding gene', 'ENSG00000165724'),
(7851, 23509, 'ZNF22-AS1', 'ZNF22 antisense RNA 1', 'non-coding RNA', 'ENSG00000165511'),
(7852, 13032, 'ZNF24', 'zinc finger protein 24', 'protein-coding gene', 'ENSG00000172466'),
(7853, 13043, 'ZNF25', 'zinc finger protein 25', 'protein-coding gene', 'ENSG00000175395'),
(7854, 13073, 'ZNF28', 'zinc finger protein 28', 'protein-coding gene', 'ENSG00000198538'),
(7855, 51179, 'ZNF30-AS1', 'ZNF30 antisense RNA 1', 'non-coding RNA', 'ENSG00000270876'),
(7856, 13095, 'ZNF32', 'zinc finger protein 32', 'protein-coding gene', 'ENSG00000169740'),
(7857, 44975, 'ZNF33BP1', 'zinc finger protein 33B pseudogene 1', 'pseudogene', 'ENSG00000225192'),
(7858, 13107, 'ZNF41', 'zinc finger protein 41', 'protein-coding gene', 'ENSG00000147124'),
(7859, 55308, 'ZNF45-AS1', 'ZNF45 antisense RNA 1', 'non-coding RNA', 'ENSG00000267191'),
(7860, 13140, 'ZNF70', 'zinc finger protein 70', 'protein-coding gene', 'ENSG00000187792'),
(7861, 13144, 'ZNF74', 'zinc finger protein 74', 'protein-coding gene', 'ENSG00000185252'),
(7862, 13145, 'ZNF75D', 'zinc finger protein 75D', 'protein-coding gene', 'ENSG00000186376'),
(7863, 13149, 'ZNF76', 'zinc finger protein 76', 'protein-coding gene', 'ENSG00000065029'),
(7864, 13158, 'ZNF83', 'zinc finger protein 83', 'protein-coding gene', 'ENSG00000167766'),
(7865, 39553, 'ZNF92P1Y', 'zinc finger protein 92 pseudogene 1, Y-linked', 'pseudogene', 'ENSG00000215603'),
(7866, 39554, 'ZNF92P2', 'zinc finger protein 92 pseudogene 2', 'pseudogene', 'ENSG00000269505'),
(7867, 12904, 'ZNF121', 'zinc finger protein 121', 'protein-coding gene', 'ENSG00000197961'),
(7868, 12966, 'ZNF177', 'zinc finger protein 177', 'protein-coding gene', 'ENSG00000188629'),
(7869, 40620, 'ZNF197-AS1', 'ZNF197 antisense RNA 1', 'non-coding RNA', 'ENSG00000233509'),
(7870, 13005, 'ZNF213', 'zinc finger protein 213', 'protein-coding gene', 'ENSG00000085644'),
(7871, 13006, 'ZNF214', 'zinc finger protein 214', 'protein-coding gene', 'ENSG00000149050'),
(7872, 13011, 'ZNF219', 'zinc finger protein 219', 'protein-coding gene', 'ENSG00000165804'),
(7873, 55916, 'ZNF225-AS1', 'ZNF225 and ZNF224 antisense RNA 1', 'non-coding RNA', 'ENSG00000186019'),
(7874, 13020, 'ZNF227', 'zinc finger protein 227', 'protein-coding gene', 'ENSG00000131115'),
(7875, 13022, 'ZNF229', 'zinc finger protein 229', 'protein-coding gene', 'ENSG00000278318'),
(7876, 13044, 'ZNF250', 'zinc finger protein 250', 'protein-coding gene', 'ENSG00000196150'),
(7877, 27821, 'ZNF252P-AS1', 'ZNF252P antisense RNA 1', 'non-coding RNA', 'ENSG00000255559'),
(7878, 13056, 'ZNF263', 'zinc finger protein 263', 'protein-coding gene', 'ENSG00000006194'),
(7879, 13061, 'ZNF268', 'zinc finger protein 268', 'protein-coding gene', 'ENSG00000090612'),
(7880, 13075, 'ZNF281', 'zinc finger protein 281', 'protein-coding gene', 'ENSG00000162702'),
(7881, 13077, 'ZNF283', 'zinc finger protein 283', 'protein-coding gene', 'ENSG00000167637'),
(7882, 55384, 'ZNF286A-TBC1D26', 'ZNF286A-TBC1D26 readthrough (NMD candidate)', 'other', 'ENSG00000255104'),
(7883, 33241, 'ZNF286B', 'zinc finger protein 286B (pseudogene)', 'pseudogene', 'ENSG00000249459'),
(7884, 13088, 'ZNF299P', 'zinc finger protein 299, pseudogene', 'pseudogene', 'ENSG00000219368'),
(7885, 13091, 'ZNF300', 'zinc finger protein 300', 'protein-coding gene', 'ENSG00000145908'),
(7886, 14096, 'ZNF324', 'zinc finger protein 324', 'protein-coding gene', 'ENSG00000083812'),
(7887, 15624, 'ZNF333', 'zinc finger protein 333', 'protein-coding gene', 'ENSG00000160961'),
(7888, 40759, 'ZNF337-AS1', 'ZNF337 antisense RNA 1', 'non-coding RNA', 'ENSG00000213742'),
(7889, 15992, 'ZNF341', 'zinc finger protein 341', 'protein-coding gene', 'ENSG00000131061'),
(7890, 16017, 'ZNF343', 'zinc finger protein 343', 'protein-coding gene', 'ENSG00000088876'),
(7891, 16656, 'ZNF350', 'zinc finger protein 350', 'protein-coding gene', 'ENSG00000256683'),
(7892, 16736, 'ZNF354C', 'zinc finger protein 354C', 'protein-coding gene', 'ENSG00000177932'),
(7893, 18079, 'ZNF362', 'zinc finger protein 362', 'protein-coding gene', 'ENSG00000160094'),
(7894, 18737, 'ZNF395', 'zinc finger protein 395', 'protein-coding gene', 'ENSG00000186918'),
(7895, 44331, 'ZNF407-AS1', 'ZNF407 antisense RNA 1', 'non-coding RNA', 'ENSG00000264247'),
(7896, 20804, 'ZNF428', 'zinc finger protein 428', 'protein-coding gene', 'ENSG00000131116'),
(7897, 20874, 'ZNF440', 'zinc finger protein 440', 'protein-coding gene', 'ENSG00000171295'),
(7898, 16052, 'ZNF444', 'zinc finger protein 444', 'protein-coding gene', 'ENSG00000167685'),
(7899, 21039, 'ZNF449', 'zinc finger protein 449', 'protein-coding gene', 'ENSG00000173275'),
(7900, 21200, 'ZNF454', 'zinc finger protein 454', 'protein-coding gene', 'ENSG00000178187'),
(7901, 55272, 'ZNF470-DT', 'ZNF470 divergent transcript', 'non-coding RNA', 'ENSG00000269696'),
(7902, 56021, 'ZNF473CR', 'ZNF473 cis regulating lncRNA', 'non-coding RNA', 'ENSG00000204666'),
(7903, 41019, 'ZNF474-AS1', 'ZNF474 antisense RNA 1', 'non-coding RNA', 'ENSG00000249610'),
(7904, 23488, 'ZNF487', 'zinc finger protein 487', 'protein-coding gene', 'ENSG00000243660'),
(7905, 23717, 'ZNF501', 'zinc finger protein 501', 'protein-coding gene', 'ENSG00000186446'),
(7906, 23525, 'ZNF503-AS2', 'ZNF503 antisense RNA 2', 'non-coding RNA', 'ENSG00000237149'),
(7907, 38088, 'ZNF511-PRAP1', 'ZNF511-PRAP1 readthrough', 'other', 'ENSG00000283496'),
(7908, 25894, 'ZNF514', 'zinc finger protein 514', 'protein-coding gene', 'ENSG00000144026'),
(7909, 29009, 'ZNF518A', 'zinc finger protein 518A', 'protein-coding gene', 'ENSG00000177853'),
(7910, 51275, 'ZNF529-AS1', 'ZNF529 antisense RNA 1', 'non-coding RNA', 'ENSG00000233527'),
(7911, 26337, 'ZNF534', 'zinc finger protein 534', 'protein-coding gene', 'ENSG00000198633'),
(7912, 29025, 'ZNF536', 'zinc finger protein 536', 'protein-coding gene', 'ENSG00000198597'),
(7913, 25331, 'ZNF540', 'zinc finger protein 540', 'protein-coding gene', 'ENSG00000171817'),
(7914, 26432, 'ZNF547', 'zinc finger protein 547', 'protein-coding gene', 'ENSG00000152433'),
(7915, 26629, 'ZNF554', 'zinc finger protein 554', 'protein-coding gene', 'ENSG00000172006'),
(7916, 55301, 'ZNF566-AS1', 'ZNF566 antisense RNA 1', 'non-coding RNA', 'ENSG00000267309'),
(7917, 28696, 'ZNF567', 'zinc finger protein 567', 'protein-coding gene', 'ENSG00000189042'),
(7918, 25392, 'ZNF568', 'zinc finger protein 568', 'protein-coding gene', 'ENSG00000198453'),
(7919, 26646, 'ZNF579', 'zinc finger protein 579', 'protein-coding gene', 'ENSG00000218891'),
(7920, 25213, 'ZNF582-DT', 'ZNF582 divergent transcript', 'non-coding RNA', 'ENSG00000267454'),
(7921, 37142, 'ZNF587B', 'zinc finger protein 587B', 'protein-coding gene', 'ENSG00000269343'),
(7922, 41278, 'ZNF593OS', 'ZNF593 opposite strand', 'protein-coding gene', 'ENSG00000236782'),
(7923, 27268, 'ZNF596', 'zinc finger protein 596', 'protein-coding gene', 'ENSG00000172748'),
(7924, 26408, 'ZNF599', 'zinc finger protein 599', 'protein-coding gene', 'ENSG00000153896'),
(7925, 23313, 'ZNF602P', 'zinc finger protein 602, pseudogene', 'pseudogene', 'ENSG00000219392'),
(7926, 28068, 'ZNF605', 'zinc finger protein 605', 'protein-coding gene', 'ENSG00000196458'),
(7927, 30958, 'ZNF622', 'zinc finger protein 622', 'protein-coding gene', 'ENSG00000173545'),
(7928, 28054, 'ZNF628', 'zinc finger protein 628', 'protein-coding gene', 'ENSG00000197483'),
(7929, 28855, 'ZNF630', 'zinc finger protein 630', 'protein-coding gene', 'ENSG00000221994'),
(7930, 31834, 'ZNF641', 'zinc finger protein 641', 'protein-coding gene', 'ENSG00000167528'),
(7931, 51285, 'ZNF649-AS1', 'ZNF649 antisense RNA 1', 'non-coding RNA', 'ENSG00000268095'),
(7932, 29147, 'ZNF652', 'zinc finger protein 652', 'protein-coding gene', 'ENSG00000198740'),
(7933, 31930, 'ZNF662', 'zinc finger protein 662', 'protein-coding gene', 'ENSG00000182983'),
(7934, 25342, 'ZNF663P', 'zinc finger protein 663, pseudogene', 'pseudogene', 'ENSG00000215452'),
(7935, 25885, 'ZNF665', 'zinc finger protein 665', 'protein-coding gene', 'ENSG00000197497'),
(7936, 25821, 'ZNF668', 'zinc finger protein 668', 'protein-coding gene', 'ENSG00000167394'),
(7937, 28167, 'ZNF670', 'zinc finger protein 670', 'protein-coding gene', 'ENSG00000277462'),
(7938, 26279, 'ZNF671', 'zinc finger protein 671', 'protein-coding gene', 'ENSG00000083814'),
(7939, 17625, 'ZNF674', 'zinc finger protein 674', 'protein-coding gene', 'ENSG00000251192'),
(7940, 30768, 'ZNF675', 'zinc finger protein 675', 'protein-coding gene', 'ENSG00000197372'),
(7941, 20429, 'ZNF676', 'zinc finger protein 676', 'protein-coding gene', 'ENSG00000196109'),
(7942, 28652, 'ZNF678', 'zinc finger protein 678', 'protein-coding gene', 'ENSG00000181450'),
(7943, 28418, 'ZNF684', 'zinc finger protein 684', 'protein-coding gene', 'ENSG00000117010'),
(7944, 55817, 'ZNF692-DT', 'ZNF692 divergent transcript', 'non-coding RNA', 'ENSG00000227237'),
(7945, 25872, 'ZNF696', 'zinc finger protein 696', 'protein-coding gene', 'ENSG00000185730'),
(7946, 32034, 'ZNF697', 'zinc finger protein 697', 'protein-coding gene', 'ENSG00000143067'),
(7947, 24750, 'ZNF699', 'zinc finger protein 699', 'protein-coding gene', 'ENSG00000196110'),
(7948, 25292, 'ZNF700', 'zinc finger protein 700', 'protein-coding gene', 'ENSG00000196757'),
(7949, 32281, 'ZNF705A', 'zinc finger protein 705A', 'protein-coding gene', 'ENSG00000196946'),
(7950, 32284, 'ZNF705B', 'zinc finger protein 705B', 'protein-coding gene', 'ENSG00000215356'),
(7951, 27815, 'ZNF707', 'zinc finger protein 707', 'protein-coding gene', 'ENSG00000181135'),
(7952, 22043, 'ZNF713', 'zinc finger protein 713', 'protein-coding gene', 'ENSG00000178665'),
(7953, 32464, 'ZNF729', 'zinc finger protein 729', 'protein-coding gene', 'ENSG00000196350'),
(7954, 37138, 'ZNF732', 'zinc finger protein 732', 'protein-coding gene', 'ENSG00000186777'),
(7955, 32465, 'ZNF734P', 'zinc finger protein 734, pseudogene', 'pseudogene', 'ENSG00000197990'),
(7956, 37728, 'ZNF736P3Y', 'zinc finger protein 736 pseudogene 3, Y-linked', 'pseudogene', 'ENSG00000233126'),
(7957, 38597, 'ZNF736P5Y', 'zinc finger protein 736 pseudogene 5, Y-linked', 'pseudogene', 'ENSG00000230819'),
(7958, 38408, 'ZNF736P9Y', 'zinc finger protein 736 pseudogene 9, Y-linked', 'pseudogene', 'ENSG00000239893'),
(7959, 38410, 'ZNF736P10Y', 'zinc finger protein 736 pseudogene 10, Y-linked', 'pseudogene', 'ENSG00000216824'),
(7960, 38426, 'ZNF736P11Y', 'zinc finger protein 736 pseudogene 11, Y-linked', 'pseudogene', 'ENSG00000215537'),
(7961, 28350, 'ZNF747', 'zinc finger protein 747', 'protein-coding gene', 'ENSG00000169955'),
(7962, 29653, 'ZNF771', 'zinc finger protein 771', 'protein-coding gene', 'ENSG00000179965'),
(7963, 22213, 'ZNF777', 'zinc finger protein 777', 'protein-coding gene', 'ENSG00000196453'),
(7964, 26479, 'ZNF778', 'zinc finger protein 778', 'protein-coding gene', 'ENSG00000170100'),
(7965, 27603, 'ZNF780A', 'zinc finger protein 780A', 'protein-coding gene', 'ENSG00000197782'),
(7966, 33111, 'ZNF784', 'zinc finger protein 784', 'protein-coding gene', 'ENSG00000179922'),
(7967, 33112, 'ZNF788P', 'zinc finger family member 788, pseudogene', 'pseudogene', 'ENSG00000214189'),
(7968, 33114, 'ZNF790', 'zinc finger protein 790', 'protein-coding gene', 'ENSG00000197863'),
(7969, 26895, 'ZNF791', 'zinc finger protein 791', 'protein-coding gene', 'ENSG00000173875'),
(7970, 51303, 'ZNF793-AS1', 'ZNF793 antisense RNA 1 (head to head)', 'non-coding RNA', 'ENSG00000266916'),
(7971, 23272, 'ZNF805', 'zinc finger protein 805', 'protein-coding gene', 'ENSG00000204524'),
(7972, 33230, 'ZNF808', 'zinc finger protein 808', 'protein-coding gene', 'ENSG00000198482'),
(7973, 33242, 'ZNF812P', 'zinc finger protein 812, pseudogene', 'pseudogene', 'ENSG00000224689'),
(7974, 22029, 'ZNF815P', 'zinc finger protein 815, pseudogene', 'pseudogene', 'ENSG00000235944'),
(7975, 26995, 'ZNF816', 'zinc finger protein 816', 'protein-coding gene', 'ENSG00000180257'),
(7976, 33875, 'ZNF826P', 'zinc finger protein 826, pseudogene', 'pseudogene', 'ENSG00000231205'),
(7977, 28291, 'ZNF830', 'zinc finger protein 830', 'protein-coding gene', 'ENSG00000198783'),
(7978, 28710, 'ZNF843', 'zinc finger protein 843', 'protein-coding gene', 'ENSG00000176723'),
(7979, 34389, 'ZNF849P', 'zinc finger protein 849, pseudogene', 'pseudogene', 'ENSG00000198153'),
(7980, 37246, 'ZNF878', 'zinc finger protein 878', 'protein-coding gene', 'ENSG00000257446'),
(7981, 37249, 'ZNF880', 'zinc finger protein 880', 'protein-coding gene', 'ENSG00000221923'),
(7982, 38691, 'ZNF890P', 'zinc finger protein 890, pseudogene', 'pseudogene', 'ENSG00000159904'),
(7983, 38709, 'ZNF891', 'zinc finger protein 891', 'protein-coding gene', 'ENSG00000214029'),
(7984, 39250, 'ZNF962P', 'zinc finger protein 962, pseudogene', 'pseudogene', 'ENSG00000215604'),
(7985, 44511, 'ZNF970P', 'zinc finger protein 970, pseudogene', 'pseudogene', 'ENSG00000258368'),
(7986, 13924, 'ZNRD1ASP', 'zinc ribbon domain containing 1 antisense, pseudogene', 'pseudogene', 'ENSG00000204623'),
(7987, 42792, 'ZNRF2P1', 'zinc and ring finger 2 pseudogene 1', 'pseudogene', 'ENSG00000237004'),
(7988, 41927, 'ZNRF3-AS1', 'ZNRF3 antisense RNA 1', 'non-coding RNA', 'ENSG00000177993'),
(7989, 13189, 'ZP3', 'zona pellucida glycoprotein 3', 'protein-coding gene', 'ENSG00000188372'),
(7990, 43595, 'ZRANB2-DT', 'ZRANB2 divergent transcript', 'non-coding RNA', 'ENSG00000229956'),
(7991, 25249, 'ZRANB3', 'zinc finger RANBP2-type containing 3', 'protein-coding gene', 'ENSG00000121988'),
(7992, 55294, 'ZSCAN5A-AS1', 'ZSCAN5A antisense RNA 1', 'non-coding RNA', 'ENSG00000267549'),
(7993, 29299, 'ZSWIM5', 'zinc finger SWIM-type containing 5', 'protein-coding gene', 'ENSG00000162415'),
(7994, 43769, 'ZSWIM5P2', 'zinc finger SWIM-type containing 5 pseudogene 2', 'pseudogene', 'ENSG00000231258'),
(7995, 13194, 'ZW10', 'zw10 kinetochore protein', 'protein-coding gene', 'ENSG00000086827'),
(7996, 13199, 'ZXDB', 'zinc finger X-linked duplicated B', 'protein-coding gene', 'ENSG00000198455'),
(7997, 32058, 'ZYG11A', 'zyg-11 family member A, cell cycle regulator', 'protein-coding gene', 'ENSG00000203995');
