
--
-- Daten für Tabelle `gene`
--

INSERT INTO `gene` (`id`, `hgnc_id`, `symbol`, `name`, `type`) VALUES
(171919, 391, 'AKT1', 'AKT serine/threonine kinase 1', 'protein-coding gene'),
(172366, 583, 'APC', 'APC regulator of WNT signaling pathway', 'protein-coding gene'),
(172937, 795, 'ATM', 'ATM serine/threonine kinase', 'protein-coding gene'),
(173133, 882, 'ATR', 'ATR serine/threonine kinase', 'protein-coding gene'),
(173234, 928, 'B4GALT5', 'beta-1,4-galactosyltransferase 5', 'protein-coding gene'),
(173245, 25008, 'BABAM1', 'BRISC and BRCA1 A complex member 1', 'protein-coding gene'),
(173294, 952, 'BARD1', 'BRCA1 associated RING domain 1', 'protein-coding gene'),
(173541, 1076, 'BMPR1A', 'bone morphogenetic protein receptor type 1A', 'protein-coding gene'),
(173683, 1100, 'BRCA1', 'BRCA1 DNA repair associated', 'protein-coding gene'),
(173685, 1101, 'BRCA2', 'BRCA2 DNA repair associated', 'protein-coding gene'),
(173719, 20473, 'BRIP1', 'BRCA1 interacting helicase 1', 'protein-coding gene'),
(173893, 26062, 'C1ORF159', 'chromosome 1 open reading frame 159', 'protein-coding gene'),
(175122, 1748, 'CDH1', 'cadherin 1', 'protein-coding gene'),
(175170, 1773, 'CDK4', 'cyclin dependent kinase 4', 'protein-coding gene'),
(175211, 1787, 'CDKN2A', 'cyclin dependent kinase inhibitor 2A', 'protein-coding gene'),
(175623, 1925, 'CHEK1', 'checkpoint kinase 1', 'protein-coding gene'),
(176124, 23432, 'CNTLN', 'centlein', 'protein-coding gene'),
(176731, 24346, 'CTAGE1', 'cutaneous T cell lymphoma-associated antigen 1', 'protein-coding gene'),
(178969, 11529, 'EPCAM', 'epithelial cell adhesion molecule', 'protein-coding gene'),
(179831, 3582, 'FANCA', 'FA complementation group A', 'protein-coding gene'),
(179834, 3585, 'FANCD2', 'FA complementation group D2', 'protein-coding gene'),
(179838, 3586, 'FANCE', 'FA complementation group E', 'protein-coding gene'),
(181080, 26881, 'GEN1', 'GEN1 Holliday junction 5\' flap endonuclease', 'protein-coding gene'),
(181167, 18177, 'GIPC2', 'GIPC PDZ domain containing family member 2', 'protein-coding gene'),
(182427, 24149, 'HES4', 'hes family bHLH transcription factor 4', 'protein-coding gene'),
(184369, 4053, 'ISG15', 'ISG15 ubiquitin like modifier', 'protein-coding gene'),
(184547, 27263, 'KANK4', 'KN motif and ankyrin repeat domains 4', 'protein-coding gene'),
(184838, 23378, 'KIAA2026', 'KIAA2026', 'protein-coding gene'),
(184932, 6387, 'KLC1', 'kinesin light chain 1', 'protein-coding gene'),
(187005, 52730, 'LINC01911', 'long intergenic non-protein coding RNA 1911', 'non-coding RNA'),
(187519, 53368, 'LINC02436', 'long intergenic non-protein coding RNA 2436', 'non-coding RNA'),
(188542, 16126, 'MACROD2', 'mono-ADP ribosylhydrolase 2', 'protein-coding gene'),
(188704, 6858, 'MAP3K6', 'mitogen-activated protein kinase kinase kinase 6', 'protein-coding gene'),
(189083, 7010, 'MEN1', 'menin 1', 'protein-coding gene'),
(191338, 7127, 'MLH1', 'mutL homolog 1', 'protein-coding gene'),
(191818, 7325, 'MSH2', 'mutS homolog 2', 'protein-coding gene'),
(191820, 7326, 'MSH3', 'mutS homolog 3', 'protein-coding gene'),
(191824, 7329, 'MSH6', 'mutS homolog 6', 'protein-coding gene'),
(192906, 7652, 'NBN', 'nibrin', 'protein-coding gene'),
(193253, 7765, 'NF1', 'neurofibromin 1', 'protein-coding gene'),
(193528, 24517, 'NOC2L', 'NOC2 like nucleolar associated transcriptional repressor', 'protein-coding gene'),
(193585, 7882, 'NOTCH2', 'notch receptor 2', 'protein-coding gene'),
(194096, 29092, 'OBSL1', 'obscurin like cytoskeletal adaptor 1', 'protein-coding gene'),
(195358, 26144, 'PALB2', 'partner and localizer of BRCA2', 'protein-coding gene'),
(196215, 8975, 'PIK3CA', 'phosphatidylinositol-4,5-bisphosphate 3-kinase catalytic subunit alpha', 'protein-coding gene'),
(196573, 25284, 'PLEKHN1', 'pleckstrin homology domain containing N1', 'protein-coding gene'),
(196664, 9121, 'PMS1', 'PMS1 homolog 1, mismatch repair system component', 'protein-coding gene'),
(196665, 9122, 'PMS2', 'PMS1 homolog 2, mismatch repair system component', 'protein-coding gene'),
(196934, 9248, 'PPFIA4', 'PTPRF interacting protein alpha 4', 'protein-coding gene'),
(197557, 9475, 'PRSS1', 'serine protease 1', 'protein-coding gene'),
(197783, 9585, 'PTCH1', 'patched 1', 'protein-coding gene'),
(197798, 9588, 'PTEN', 'phosphatase and tensin homolog', 'protein-coding gene'),
(197886, 9659, 'PTPN7', 'protein tyrosine phosphatase non-receptor type 7', 'protein-coding gene'),
(198208, 9816, 'RAD50', 'RAD50 double strand break repair protein', 'protein-coding gene'),
(198209, 9817, 'RAD51', 'RAD51 recombinase', 'protein-coding gene'),
(198214, 9822, 'RAD51B', 'RAD51 paralog B', 'protein-coding gene'),
(198215, 9820, 'RAD51C', 'RAD51 paralog C', 'protein-coding gene'),
(198216, 9823, 'RAD51D', 'RAD51 paralog D', 'protein-coding gene'),
(198401, 9891, 'RBBP8', 'RB binding protein 8, endonuclease', 'protein-coding gene'),
(198676, 9967, 'RET', 'ret proto-oncogene', 'protein-coding gene'),
(200634, 40020, 'RNF223', 'ring finger protein 223', 'protein-coding gene'),
(206502, 23845, 'SLX4', 'SLX4 structure-specific endonuclease subunit', 'protein-coding gene'),
(206510, 6770, 'SMAD4', 'SMAD family member 4', 'protein-coding gene'),
(206640, 44670, 'SMLR1', 'small leucine rich protein 1', 'protein-coding gene'),
(206644, 11119, 'SMO', 'smoothened, frizzled class receptor', 'protein-coding gene'),
(208329, 16466, 'SUFU', 'SUFU negative regulator of hedgehog signaling', 'protein-coding gene'),
(209295, 23696, 'TIPARP', 'TCDD inducible poly(ADP-ribose) polymerase', 'protein-coding gene'),
(209953, 11998, 'TP53', 'tumor protein p53', 'protein-coding gene'),
(209955, 11999, 'TP53BP1', 'tumor protein p53 binding protein 1', 'protein-coding gene'),
(211953, 30298, 'UIMC1', 'ubiquitin interaction motif containing 1', 'protein-coding gene'),
(213518, 23330, 'ZNF276', 'zinc finger protein 276', 'protein-coding gene');


--
-- Daten für Tabelle `gene_transcript`
--

INSERT INTO `gene_transcript` (`id`, `gene_id`, `name`, `version`, `source`, `chromosome`, `start_coding`, `end_coding`, `strand`) VALUES
(602254, 193528, 'ENST00000327044','1', 'ensembl', '1', 944694, 959240, '-'),
(602258, 196573, 'ENST00000379407','1', 'ensembl', '1', 966532, 974575, '+'),
(602261, 196573, 'ENST00000379410','1', 'ensembl', '1', 966532, 974575, '+'),
(602266, 182427, 'ENST00000304952','1', 'ensembl', '1', 999059, 999973, '-'),
(602268, 182427, 'ENST00000428771','1', 'ensembl', '1', 999059, 999973, '-'),
(602272, 184369, 'ENST00000649529','1', 'ensembl', '1', 1013574, 1014478, '+'),
(602277, 200634, 'ENST00000453464','1', 'ensembl', '1', 1071817, 1072566, '-'),
(602283, 173893, 'ENST00000379339','1', 'ensembl', '1', 1082893, 1091543, '-'),
(604162, 188704, 'ENST00000357582','1', 'ensembl', '1', 27355391, 27366597, '-'),
(606306, 184547, 'ENST00000317477','1', 'ensembl', '1', 62238277, 62253162, '-'),
(606307, 184547, 'ENST00000354381','1', 'ensembl', '1', 62238277, 62281564, '-'),
(606812, 181167, 'ENST00000370759','1', 'ensembl', '1', 78046095, 78135743, '+'),
(608401, 193585, 'ENST00000256646','1', 'ensembl', '1', 119915306, 120069406, '-'),
(611946, 197886, 'ENST00000309017','1', 'ensembl', '1', 202148606, 202159402, '-'),
(612022, 196934, 'ENST00000295706','1', 'ensembl', '1', 203039009, 203076390, '+'),
(615297, 198676, 'ENST00000340058','1', 'ensembl', '10', 43077259, 43126754, '+'),
(616853, 173541, 'ENST00000372037','1', 'ensembl', '10', 86876019, 86923719, '+'),
(616935, 197798, 'ENST00000371953','1', 'ensembl', '10', 87864470, 87965472, '+'),
(617800, 208329, 'ENST00000369899','1', 'ensembl', '10', 102504153, 102619071, '+'),
(617802, 208329, 'ENST00000369902','1', 'ensembl', '10', 102504153, 102630155, '+'),
(622665, 189083, 'ENST00000312049','1', 'ensembl', '11', 64804334, 64810109, '-'),
(624905, 172937, 'ENST00000452508','1', 'ensembl', '11', 108227625, 108365508, '+'),
(625992, 175623, 'ENST00000278916','1', 'ensembl', '11', 125626769, 125655320, '+'),
(629717, 175170, 'ENST00000257904','1', 'ensembl', '12', 57748525, 57751717, '-'),
(632999, 173685, 'ENST00000380152','1', 'ensembl', '13', 32316461, 32398770, '+'),
(637142, 198214, 'ENST00000390683','1', 'ensembl', '14', 67823544, 67887288, '+'),
(637143, 198214, 'ENST00000471583','1', 'ensembl', '14', 67823544, 68477664, '+'),
(638777, 184932, 'ENST00000334553','1', 'ensembl', '14', 103654565, 103700726, '+'),
(638878, 171919, 'ENST00000349310','1', 'ensembl', '14', 104770341, 104792643, '-'),
(640069, 198209, 'ENST00000267868','1', 'ensembl', '15', 40698759, 40731178, '+'),
(640357, 209955, 'ENST00000263801','1', 'ensembl', '15', 43407383, 43492460, '-'),
(643984, 206502, 'ENST00000294008','1', 'ensembl', '16', 3582342, 3608964, '-'),
(644895, 195358, 'ENST00000261584','1', 'ensembl', '16', 23603459, 23641157, '-'),
(646807, 175122, 'ENST00000261769','1', 'ensembl', '16', 68737416, 68833499, '+'),
(647845, 213518, 'ENST00000289816','1', 'ensembl', '16', 89722551, 89738246, '+'),
(647850, 179831, 'ENST00000389301','1', 'ensembl', '16', 89738601, 89816615, '-'),
(648867, 209953, 'ENST00000269305','1', 'ensembl', '17', 7669609, 7676594, '-'),
(650244, 193253, 'ENST00000356175','1', 'ensembl', '17', 31095310, 31374155, '+'),
(650401, 198216, 'ENST00000335858','1', 'ensembl', '17', 35100953, 35119613, '-'),
(651440, 173683, 'ENST00000352993','1', 'ensembl', '17', 43045678, 43124096, '-'),
(652658, 198215, 'ENST00000337432','1', 'ensembl', '17', 58692644, 58734222, '+'),
(652825, 173719, 'ENST00000259008','1', 'ensembl', '17', 61683296, 61861539, '-'),
(655151, 176731, 'ENST00000391403','1', 'ensembl', '18', 22415574, 22417811, '-'),
(655157, 198401, 'ENST00000327155','1', 'ensembl', '18', 22936852, 23026240, '+'),
(655961, 206510, 'ENST00000342988','1', 'ensembl', '18', 51047047, 51078467, '+'),
(658945, 173245, 'ENST00000359435','1', 'ensembl', '19', 17268807, 17279048, '+'),
(664372, 181080, 'ENST00000317402','1', 'ensembl', '2', 17759944, 17781939, '+'),
(665491, 178969, 'ENST00000263735','1', 'ensembl', '2', 47369506, 47386613, '+'),
(665496, 191818, 'ENST00000233146','1', 'ensembl', '2', 47403192, 47482949, '+'),
(665506, 191824, 'ENST00000234420','1', 'ensembl', '2', 47783234, 47806860, '+'),
(668701, 187005, 'ENST00000450667','1', 'ensembl', '2', NULL, NULL, '+'),
(669935, 196664, 'ENST00000374826','1', 'ensembl', '2', 189791810, 189806502, '+'),
(670810, 173294, 'ENST00000260947','1', 'ensembl', '2', 214728676, 214809569, '-'),
(671180, 194096, 'ENST00000289656','1', 'ensembl', '2', 219561884, 219568097, '-'),
(671183, 194096, 'ENST00000373876','1', 'ensembl', '2', 219550835, 219571232, '-'),
(672807, 188542, 'ENST00000217246','1', 'ensembl', '20', 13995764, 16049876, '+'),
(674460, 173234, 'ENST00000371711','1', 'ensembl', '20', 49636312, 49713690, '-'),
(679749, 179834, 'ENST00000287647','1', 'ensembl', '3', 10028658, 10098950, '+'),
(680668, 191338, 'ENST00000231790','1', 'ensembl', '3', 36993548, 37050653, '+'),
(684697, 173133, 'ENST00000350721','1', 'ensembl', '3', 142449429, 142578704, '-'),
(685118, 209295, 'ENST00000295924','1', 'ensembl', '3', 156677698, 156705131, '+'),
(685673, 196215, 'ENST00000263967','1', 'ensembl', '3', 179198826, 179234364, '+'),
(691509, 187519, 'ENST00000509017','1', 'ensembl', '4', NULL, NULL, '+'),
(693673, 191820, 'ENST00000265081','1', 'ensembl', '5', 80654728, 80875862, '+'),
(694293, 172366, 'ENST00000257430','1', 'ensembl', '5', 112754891, 112844126, '+'),
(694774, 198208, 'ENST00000378823','1', 'ensembl', '5', 132557325, 132642364, '+'),
(696738, 211953, 'ENST00000377227','1', 'ensembl', '5', 176905282, 176982615, '-'),
(699340, 179838, 'ENST00000229769','1', 'ensembl', '6', 35452546, 35466345, '+'),
(701961, 206640, 'ENST00000541421','1', 'ensembl', '6', 130827414, 130834955, '+'),
(703503, 196665, 'ENST00000265849','1', 'ensembl', '7', 5973399, 6009019, '-'),
(707558, 206644, 'ENST00000249373','1', 'ensembl', '7', 129189152, 129212451, '+'),
(708144, 197557, 'ENST00000311737','1', 'ensembl', '7', 142749485, 142753020, '+'),
(711492, 192906, 'ENST00000265433','1', 'ensembl', '8', 89935582, 89984561, '-'),
(713501, 184838, 'ENST00000381461','1', 'ensembl', '9', 5919684, 6007787, '-'),
(713688, 176124, 'ENST00000380641','1', 'ensembl', '9', 17135066, 17298382, '+'),
(713690, 176124, 'ENST00000380647','1', 'ensembl', '9', 17135066, 17502652, '+'),
(713823, 175211, 'ENST00000304494','1', 'ensembl', '9', 21968229, 21974827, '-'),
(715510, 197783, 'ENST00000331920','1', 'ensembl', '9', 95446912, 95508361, '-');

--
-- Daten für Tabelle `gene_exon`
--

INSERT INTO `gene_exon` (`transcript_id`, `start`, `end`) VALUES
(602254, 944203, 944800),
(602254, 945057, 945146),
(602254, 945518, 945653),
(602254, 946173, 946286),
(602254, 946402, 946545),
(602254, 948131, 948232),
(602254, 948490, 948603),
(602254, 951127, 951238),
(602254, 952000, 952139),
(602254, 952412, 952600),
(602254, 953175, 953288),
(602254, 953782, 953892),
(602254, 954004, 954082),
(602254, 955923, 956013),
(602254, 956095, 956215),
(602254, 956894, 957025),
(602254, 957099, 957273),
(602254, 958929, 959081),
(602254, 959215, 959256),
(602258, 966502, 966614),
(602258, 966704, 966803),
(602258, 970277, 970423),
(602258, 970521, 970601),
(602258, 970686, 970758),
(602258, 970879, 971006),
(602258, 971077, 971208),
(602258, 971324, 971404),
(602258, 972075, 972150),
(602258, 972288, 972424),
(602258, 972861, 973010),
(602258, 973500, 973640),
(602258, 973833, 974051),
(602258, 974316, 974364),
(602258, 974442, 975008),
(602261, 966482, 966614),
(602261, 966704, 966803),
(602261, 970277, 970423),
(602261, 970521, 970601),
(602261, 970686, 970758),
(602261, 970879, 971006),
(602261, 971113, 971208),
(602261, 971324, 971404),
(602261, 972075, 972150),
(602261, 972288, 972424),
(602261, 972861, 973010),
(602261, 973186, 973326),
(602261, 973500, 973640),
(602261, 973833, 974051),
(602261, 974316, 974364),
(602261, 974442, 975865),
(602266, 998964, 999432),
(602266, 999526, 999613),
(602266, 999692, 999787),
(602266, 999866, 1000097),
(602268, 998962, 999432),
(602268, 999526, 999613),
(602268, 999692, 1000172),
(602272, 1013497, 1013576),
(602272, 1013984, 1014540),
(602277, 1070967, 1072575),
(602277, 1074016, 1074306),
(602283, 1081818, 1082987),
(602283, 1083915, 1084383),
(602283, 1084481, 1084506),
(602283, 1085878, 1086012),
(602283, 1087139, 1087204),
(602283, 1087502, 1087597),
(602283, 1090353, 1090428),
(602283, 1090876, 1090983),
(602283, 1091472, 1091565),
(602283, 1091991, 1092103),
(602283, 1115022, 1115075),
(602283, 1116060, 1116081),
(604162, 27355184, 27355469),
(604162, 27355669, 27355745),
(604162, 27356026, 27356099),
(604162, 27356388, 27356500),
(604162, 27356590, 27356749),
(604162, 27357009, 27357114),
(604162, 27357400, 27357576),
(604162, 27357711, 27357876),
(604162, 27358181, 27358319),
(604162, 27358419, 27358611),
(604162, 27358709, 27358866),
(604162, 27359417, 27359522),
(604162, 27359858, 27359994),
(604162, 27360241, 27360368),
(604162, 27360705, 27360838),
(604162, 27360921, 27361008),
(604162, 27361157, 27361252),
(604162, 27361346, 27361395),
(604162, 27361520, 27361627),
(604162, 27361705, 27361867),
(604162, 27362091, 27362250),
(604162, 27362641, 27362753),
(604162, 27362851, 27363021),
(604162, 27363442, 27363548),
(604162, 27363917, 27364085),
(604162, 27364204, 27364394),
(604162, 27364661, 27364684),
(604162, 27364773, 27364912),
(604162, 27366258, 27366961),
(606306, 62236979, 62238381),
(606306, 62247472, 62247672),
(606306, 62253067, 62253209),
(606306, 62263092, 62263424),
(606307, 62237544, 62238381),
(606307, 62247472, 62247672),
(606307, 62253067, 62253209),
(606307, 62263092, 62263311),
(606307, 62266732, 62266819),
(606307, 62268287, 62268505),
(606307, 62271478, 62271589),
(606307, 62281549, 62281634),
(606307, 62319106, 62319301),
(606812, 78045966, 78046334),
(606812, 78080675, 78080860),
(606812, 78094952, 78095132),
(606812, 78119393, 78119499),
(606812, 78125881, 78125962),
(606812, 78135592, 78138444),
(608401, 119911553, 119916694),
(608401, 119917665, 119917762),
(608401, 119918406, 119918553),
(608401, 119919312, 119919613),
(608401, 119920229, 119920397),
(608401, 119921713, 119921809),
(608401, 119922236, 119922446),
(608401, 119922636, 119922778),
(608401, 119923637, 119923984),
(608401, 119925305, 119925810),
(608401, 119926499, 119926611),
(608401, 119928976, 119929212),
(608401, 119935472, 119935604),
(608401, 119937282, 119937466),
(608401, 119937857, 119938010),
(608401, 119940555, 119940756),
(608401, 119941526, 119941754),
(608401, 119948414, 119948566),
(608401, 119949007, 119949126),
(608401, 119950724, 119950837),
(608401, 119953543, 119953688),
(608401, 119955040, 119955232),
(608401, 119959392, 119959502),
(608401, 119963574, 119963807),
(608401, 119965453, 119965566),
(608401, 119966376, 119966489),
(608401, 119967433, 119967621),
(608401, 119968077, 119968232),
(608401, 119969511, 119969744),
(608401, 119986960, 119987082),
(608401, 119996997, 119997332),
(608401, 120005329, 120005588),
(608401, 120029906, 120029987),
(608401, 120069334, 120069662),
(611946, 202147013, 202148699),
(611946, 202150311, 202150424),
(611946, 202152542, 202152699),
(611946, 202153725, 202153835),
(611946, 202154186, 202154323),
(611946, 202155533, 202155609),
(611946, 202157739, 202157823),
(611946, 202158118, 202158301),
(611946, 202159281, 202159454),
(611946, 202160545, 202161581),
(612022, 203026491, 203026629),
(612022, 203038610, 203039242),
(612022, 203043397, 203043498),
(612022, 203043931, 203044095),
(612022, 203044379, 203044453),
(612022, 203044696, 203044785),
(612022, 203045368, 203045559),
(612022, 203045841, 203045987),
(612022, 203046248, 203046382),
(612022, 203048227, 203048310),
(612022, 203048583, 203048714),
(612022, 203048918, 203048980),
(612022, 203049676, 203049767),
(612022, 203051769, 203051877),
(612022, 203053753, 203053961),
(612022, 203055432, 203055672),
(612022, 203056120, 203056155),
(612022, 203056375, 203056508),
(612022, 203056784, 203056950),
(612022, 203059178, 203059271),
(612022, 203059770, 203059851),
(612022, 203060217, 203060417),
(612022, 203060970, 203061032),
(612022, 203061652, 203061678),
(612022, 203063828, 203064003),
(612022, 203067695, 203067792),
(612022, 203068453, 203068628),
(612022, 203071692, 203071760),
(612022, 203075577, 203075757),
(612022, 203076341, 203078736),
(615297, 43077069, 43077331),
(615297, 43100459, 43100722),
(615297, 43102342, 43102629),
(615297, 43104952, 43105193),
(615297, 43106376, 43106571),
(615297, 43109031, 43109230),
(615297, 43111207, 43111465),
(615297, 43112099, 43112224),
(615297, 43112853, 43112963),
(615297, 43113556, 43113675),
(615297, 43114480, 43114736),
(615297, 43116584, 43116731),
(615297, 43118373, 43118480),
(615297, 43119531, 43119745),
(615297, 43120081, 43120203),
(615297, 43121946, 43122016),
(615297, 43123671, 43123808),
(615297, 43124883, 43124982),
(615297, 43126575, 43127504),
(616853, 86756619, 86756919),
(616853, 86838865, 86838979),
(616853, 86875867, 86876085),
(616853, 86890062, 86890224),
(616853, 86892127, 86892229),
(616853, 86899794, 86899890),
(616853, 86900027, 86900126),
(616853, 86912240, 86912384),
(616853, 86917134, 86917326),
(616853, 86919172, 86919469),
(616853, 86921520, 86921695),
(616853, 86923376, 86923506),
(616853, 86923594, 86927969),
(616935, 87863625, 87864548),
(616935, 87894025, 87894109),
(616935, 87925513, 87925557),
(616935, 87931046, 87931089),
(616935, 87933013, 87933251),
(616935, 87952118, 87952259),
(616935, 87957853, 87958019),
(616935, 87960894, 87961118),
(616935, 87965287, 87971930),
(617800, 102504007, 102504334),
(617800, 102509169, 102509303),
(617800, 102549970, 102550106),
(617800, 102592582, 102592724),
(617800, 102593636, 102593721),
(617800, 102593993, 102594065),
(617800, 102597140, 102597293),
(617800, 102599433, 102599544),
(617800, 102615268, 102615402),
(617800, 102617290, 102617428),
(617800, 102619066, 102619462),
(617802, 102503972, 102504334),
(617802, 102509169, 102509303),
(617802, 102549970, 102550106),
(617802, 102592582, 102592724),
(617802, 102593636, 102593721),
(617802, 102593993, 102594065),
(617802, 102597140, 102597293),
(617802, 102599433, 102599544),
(617802, 102615268, 102615402),
(617802, 102617290, 102617428),
(617802, 102627175, 102627243),
(617802, 102630066, 102633535),
(622665, 64803516, 64804816),
(622665, 64805034, 64805198),
(622665, 64805635, 64805770),
(622665, 64806232, 64806368),
(622665, 64807011, 64807098),
(622665, 64807179, 64807219),
(622665, 64807552, 64807680),
(622665, 64807891, 64808099),
(622665, 64809665, 64810132),
(622665, 64810630, 64810686),
(624905, 108223116, 108223186),
(624905, 108224784, 108224871),
(624905, 108227595, 108227696),
(624905, 108227776, 108227888),
(624905, 108229178, 108229323),
(624905, 108235670, 108235834),
(624905, 108243953, 108244118),
(624905, 108244788, 108245026),
(624905, 108246964, 108247127),
(624905, 108248933, 108249102),
(624905, 108250701, 108251072),
(624905, 108251837, 108252031),
(624905, 108252817, 108252912),
(624905, 108253814, 108254039),
(624905, 108256215, 108256340),
(624905, 108257481, 108257606),
(624905, 108258986, 108259075),
(624905, 108267171, 108267342),
(624905, 108268410, 108268609),
(624905, 108271064, 108271146),
(624905, 108271251, 108271406),
(624905, 108272532, 108272607),
(624905, 108272722, 108272852),
(624905, 108279491, 108279608),
(624905, 108280995, 108281168),
(624905, 108282710, 108282879),
(624905, 108284227, 108284473),
(624905, 108287600, 108287715),
(624905, 108288977, 108289103),
(624905, 108289602, 108289801),
(624905, 108292619, 108292793),
(624905, 108293313, 108293477),
(624905, 108294927, 108295059),
(624905, 108297287, 108297382),
(624905, 108299714, 108299885),
(624905, 108301648, 108301789),
(624905, 108302853, 108303029),
(624905, 108304675, 108304852),
(624905, 108307897, 108307984),
(624905, 108310160, 108310315),
(624905, 108312411, 108312498),
(624905, 108315823, 108315911),
(624905, 108316011, 108316113),
(624905, 108317373, 108317521),
(624905, 108319954, 108320058),
(624905, 108321301, 108321420),
(624905, 108325310, 108325544),
(624905, 108326058, 108326225),
(624905, 108327645, 108327758),
(624905, 108329021, 108329238),
(624905, 108330214, 108330421),
(624905, 108331444, 108331557),
(624905, 108331879, 108332037),
(624905, 108332762, 108332900),
(624905, 108333886, 108333968),
(624905, 108334969, 108335109),
(624905, 108335845, 108335961),
(624905, 108343222, 108343371),
(624905, 108345743, 108345908),
(624905, 108347279, 108347365),
(624905, 108353766, 108353880),
(624905, 108354811, 108354874),
(624905, 108365082, 108365218),
(624905, 108365325, 108369102),
(625992, 125625977, 125626012),
(625992, 125626749, 125626833),
(625992, 125627607, 125627830),
(625992, 125629232, 125629296),
(625992, 125629391, 125629460),
(625992, 125633163, 125633351),
(625992, 125635429, 125635533),
(625992, 125637449, 125637544),
(625992, 125643792, 125643900),
(625992, 125644091, 125644268),
(625992, 125644512, 125644643),
(625992, 125655225, 125655506),
(629717, 57747727, 57748617),
(629717, 57749182, 57749317),
(629717, 57749454, 57749504),
(629717, 57750656, 57750765),
(629717, 57750923, 57751090),
(629717, 57751207, 57751342),
(629717, 57751500, 57751736),
(629717, 57752175, 57752310),
(632999, 32315508, 32315667),
(632999, 32316422, 32316527),
(632999, 32319077, 32319325),
(632999, 32325076, 32325184),
(632999, 32326101, 32326150),
(632999, 32326242, 32326282),
(632999, 32326499, 32326613),
(632999, 32329443, 32329492),
(632999, 32330919, 32331030),
(632999, 32332272, 32333387),
(632999, 32336265, 32341196),
(632999, 32344558, 32344653),
(632999, 32346827, 32346896),
(632999, 32354861, 32355288),
(632999, 32356428, 32356609),
(632999, 32357742, 32357929),
(632999, 32362523, 32362693),
(632999, 32363179, 32363533),
(632999, 32370402, 32370557),
(632999, 32370956, 32371100),
(632999, 32376670, 32376791),
(632999, 32379317, 32379515),
(632999, 32379750, 32379913),
(632999, 32380007, 32380145),
(632999, 32394689, 32394933),
(632999, 32396898, 32397044),
(632999, 32398162, 32400268),
(637142, 67819812, 67819853),
(637142, 67823542, 67823627),
(637142, 67825464, 67825577),
(637142, 67835080, 67835196),
(637142, 67865003, 67865139),
(637142, 67885869, 67885988),
(637142, 67887021, 67887326),
(637143, 67819779, 67819853),
(637143, 67823542, 67823627),
(637143, 67825464, 67825577),
(637143, 67835080, 67835196),
(637143, 67865003, 67865139),
(637143, 67885869, 67885988),
(637143, 67887021, 67887204),
(637143, 68291884, 68291980),
(637143, 68411424, 68411527),
(637143, 68468172, 68468250),
(637143, 68477648, 68478093),
(638777, 103629211, 103629494),
(638777, 103654564, 103654825),
(638777, 103657546, 103657776),
(638777, 103662116, 103662194),
(638777, 103662702, 103662927),
(638777, 103669511, 103669598),
(638777, 103670182, 103670283),
(638777, 103673014, 103673187),
(638777, 103673332, 103673431),
(638777, 103675552, 103675601),
(638777, 103675689, 103675756),
(638777, 103677415, 103677523),
(638777, 103679384, 103679545),
(638777, 103687081, 103687211),
(638777, 103692359, 103692425),
(638777, 103700655, 103700727),
(638777, 103701201, 103701544),
(638878, 104769349, 104770420),
(638878, 104770745, 104770847),
(638878, 104772365, 104772452),
(638878, 104772878, 104773092),
(638878, 104773251, 104773379),
(638878, 104773455, 104773580),
(638878, 104773912, 104773980),
(638878, 104774938, 104775003),
(638878, 104775076, 104775207),
(638878, 104775652, 104775799),
(638878, 104776659, 104776770),
(638878, 104780088, 104780216),
(638878, 104792598, 104792722),
(638878, 104793127, 104793210),
(638878, 104795484, 104795751),
(640069, 40695174, 40695425),
(640069, 40698757, 40698845),
(640069, 40701064, 40701201),
(640069, 40706177, 40706294),
(640069, 40709025, 40709116),
(640069, 40718805, 40718899),
(640069, 40728711, 40728824),
(640069, 40729505, 40729634),
(640069, 40729853, 40729974),
(640069, 40731055, 40732340),
(640357, 43407209, 43407570),
(640357, 43407943, 43408088),
(640357, 43408897, 43409096),
(640357, 43409647, 43409741),
(640357, 43413119, 43413334),
(640357, 43415594, 43415809),
(640357, 43416225, 43416416),
(640357, 43420305, 43420735),
(640357, 43421025, 43421174),
(640357, 43421855, 43422126),
(640357, 43428016, 43428168),
(640357, 43432194, 43432677),
(640357, 43438324, 43438416),
(640357, 43441526, 43441583),
(640357, 43446387, 43446590),
(640357, 43447366, 43447485),
(640357, 43455892, 43457218),
(640357, 43469858, 43470066),
(640357, 43474673, 43474767),
(640357, 43475565, 43475694),
(640357, 43477593, 43477759),
(640357, 43479397, 43479526),
(640357, 43479859, 43480017),
(640357, 43480895, 43481022),
(640357, 43491669, 43491753),
(640357, 43492002, 43492095),
(640357, 43492284, 43492468),
(640357, 43510370, 43510614),
(643984, 3581181, 3582693),
(643984, 3583097, 3583510),
(643984, 3584769, 3584871),
(643984, 3589002, 3591310),
(643984, 3592699, 3592865),
(643984, 3594453, 3594599),
(643984, 3595605, 3595693),
(643984, 3596153, 3596393),
(643984, 3597379, 3597695),
(643984, 3597797, 3597999),
(643984, 3600979, 3601191),
(643984, 3602118, 3602307),
(643984, 3606474, 3606698),
(643984, 3608430, 3609566),
(643984, 3611560, 3611606),
(644895, 23603165, 23603669),
(644895, 23607864, 23608012),
(644895, 23614004, 23614091),
(644895, 23621362, 23621478),
(644895, 23622969, 23623130),
(644895, 23624009, 23624094),
(644895, 23626236, 23626397),
(644895, 23629204, 23629275),
(644895, 23629640, 23630469),
(644895, 23634862, 23636334),
(644895, 23637850, 23637952),
(644895, 23638070, 23638129),
(644895, 23641110, 23641310),
(646807, 68737292, 68737463),
(646807, 68738297, 68738411),
(646807, 68801670, 68801893),
(646807, 68808424, 68808567),
(646807, 68808693, 68808848),
(646807, 68810197, 68810341),
(646807, 68811684, 68811859),
(646807, 68812135, 68812263),
(646807, 68813313, 68813495),
(646807, 68815515, 68815759),
(646807, 68819280, 68819425),
(646807, 68822001, 68822225),
(646807, 68823399, 68823626),
(646807, 68828174, 68828304),
(646807, 68829654, 68829797),
(646807, 68833290, 68835537),
(647845, 89720985, 89721276),
(647845, 89722531, 89722834),
(647845, 89723137, 89723183),
(647845, 89723260, 89723709),
(647845, 89727279, 89727357),
(647845, 89729235, 89729318),
(647845, 89733302, 89733412),
(647845, 89733482, 89733557),
(647845, 89733921, 89734038),
(647845, 89737806, 89737905),
(647845, 89737976, 89740903),
(647850, 89737549, 89738708),
(647850, 89738882, 89738974),
(647850, 89739133, 89739289),
(647850, 89739478, 89739553),
(647850, 89739994, 89740099),
(647850, 89740804, 89740866),
(647850, 89742800, 89742938),
(647850, 89744959, 89745071),
(647850, 89746584, 89746688),
(647850, 89746831, 89746890),
(647850, 89748659, 89748767),
(647850, 89749730, 89749902),
(647850, 89752138, 89752222),
(647850, 89758577, 89758705),
(647850, 89761949, 89762022),
(647850, 89764890, 89765066),
(647850, 89767141, 89767237),
(647850, 89769837, 89770024),
(647850, 89770166, 89770259),
(647850, 89770564, 89770634),
(647850, 89771678, 89771814),
(647850, 89773271, 89773384),
(647850, 89775742, 89775815),
(647850, 89778801, 89778850),
(647850, 89778943, 89779003),
(647850, 89779869, 89779957),
(647850, 89782859, 89782918),
(647850, 89783007, 89783102),
(647850, 89784854, 89784964),
(647850, 89791403, 89791536),
(647850, 89791927, 89792068),
(647850, 89792471, 89792547),
(647850, 89795906, 89796018),
(647850, 89799166, 89799232),
(647850, 89799605, 89799638),
(647850, 89803259, 89803341),
(647850, 89805280, 89805392),
(647850, 89808294, 89808367),
(647850, 89810707, 89810802),
(647850, 89810929, 89811071),
(647850, 89814520, 89814613),
(647850, 89815877, 89815986),
(647850, 89816537, 89816647),
(648867, 7668421, 7669690),
(648867, 7670609, 7670715),
(648867, 7673535, 7673608),
(648867, 7673701, 7673837),
(648867, 7674181, 7674290),
(648867, 7674859, 7674971),
(648867, 7675053, 7675236),
(648867, 7675994, 7676272),
(648867, 7676382, 7676403),
(648867, 7676521, 7676622),
(648867, 7687377, 7687490),
(650244, 31094927, 31095369),
(650244, 31155983, 31156126),
(650244, 31159010, 31159093),
(650244, 31163186, 31163376),
(650244, 31169891, 31169997),
(650244, 31181422, 31181489),
(650244, 31181710, 31181785),
(650244, 31182508, 31182665),
(650244, 31200422, 31200595),
(650244, 31201037, 31201159),
(650244, 31201411, 31201485),
(650244, 31206240, 31206371),
(650244, 31214451, 31214585),
(650244, 31219005, 31219118),
(650244, 31221850, 31221929),
(650244, 31223444, 31223567),
(650244, 31225095, 31225250),
(650244, 31226435, 31226684),
(650244, 31227218, 31227291),
(650244, 31227523, 31227606),
(650244, 31229025, 31229465),
(650244, 31229835, 31229974),
(650244, 31230260, 31230382),
(650244, 31230842, 31230925),
(650244, 31232073, 31232189),
(650244, 31232700, 31232881),
(650244, 31233002, 31233213),
(650244, 31235611, 31235772),
(650244, 31235918, 31236021),
(650244, 31248984, 31249119),
(650244, 31258344, 31258502),
(650244, 31259032, 31259129),
(650244, 31260369, 31260515),
(650244, 31261711, 31261857),
(650244, 31265229, 31265339),
(650244, 31325820, 31326252),
(650244, 31327499, 31327839),
(650244, 31330296, 31330498),
(650244, 31334838, 31335031),
(650244, 31336333, 31336473),
(650244, 31336635, 31336914),
(650244, 31337368, 31337582),
(650244, 31337819, 31337880),
(650244, 31338025, 31338139),
(650244, 31338704, 31338805),
(650244, 31340505, 31340645),
(650244, 31343009, 31343135),
(650244, 31349120, 31349251),
(650244, 31350183, 31350318),
(650244, 31352257, 31352414),
(650244, 31356460, 31356582),
(650244, 31356960, 31357090),
(650244, 31357269, 31357369),
(650244, 31358480, 31358622),
(650244, 31358969, 31359015),
(650244, 31360487, 31360703),
(650244, 31374013, 31377677),
(650401, 35100383, 35101036),
(650401, 35101201, 35101365),
(650401, 35103254, 35103324),
(650401, 35103454, 35103544),
(650401, 35106386, 35106481),
(650401, 35119111, 35119172),
(650401, 35119532, 35119745),
(651440, 43044295, 43045802),
(651440, 43047643, 43047703),
(651440, 43049121, 43049194),
(651440, 43051063, 43051117),
(651440, 43057052, 43057135),
(651440, 43063333, 43063373),
(651440, 43063874, 43063951),
(651440, 43067608, 43067695),
(651440, 43070928, 43071238),
(651440, 43074331, 43074521),
(651440, 43076488, 43076614),
(651440, 43082404, 43082575),
(651440, 43090944, 43091032),
(651440, 43095846, 43095922),
(651440, 43097244, 43097289),
(651440, 43099775, 43099880),
(651440, 43104122, 43104261),
(651440, 43104868, 43104956),
(651440, 43106456, 43106533),
(651440, 43115726, 43115779),
(651440, 43124017, 43124115),
(651440, 43125271, 43125370),
(652658, 58692602, 58692788),
(652658, 58694931, 58695189),
(652658, 58696693, 58696859),
(652658, 58703196, 58703329),
(652658, 58709859, 58709990),
(652658, 58720746, 58720812),
(652658, 58724040, 58724100),
(652658, 58732484, 58732544),
(652658, 58734118, 58735611),
(652825, 61679139, 61684140),
(652825, 61685836, 61686165),
(652825, 61693430, 61693512),
(652825, 61715951, 61716063),
(652825, 61743013, 61743134),
(652825, 61744432, 61744591),
(652825, 61776401, 61776562),
(652825, 61780261, 61780401),
(652825, 61780840, 61781005),
(652825, 61784270, 61784424),
(652825, 61793597, 61793729),
(652825, 61799100, 61799299),
(652825, 61801253, 61801474),
(652825, 61808467, 61808757),
(652825, 61847101, 61847220),
(652825, 61849129, 61849256),
(652825, 61857058, 61857231),
(652825, 61859796, 61859907),
(652825, 61861447, 61861569),
(652825, 61863284, 61863528),
(655151, 22413599, 22417915),
(655157, 22933328, 22933564),
(655157, 22936754, 22936960),
(655157, 22946444, 22946486),
(655157, 22949618, 22949713),
(655157, 22968806, 22968918),
(655157, 22975153, 22975219),
(655157, 22982218, 22982393),
(655157, 22984886, 22984990),
(655157, 22989221, 22989318),
(655157, 22990937, 22991049),
(655157, 22992748, 22993639),
(655157, 22993721, 22993847),
(655157, 22996374, 22996462),
(655157, 22997620, 22997734),
(655157, 23001586, 23001729),
(655157, 23006363, 23006432),
(655157, 23016828, 23016924),
(655157, 23022129, 23022270),
(655157, 23026143, 23026486),
(655961, 51030213, 51030623),
(655961, 51046920, 51047295),
(655961, 51048686, 51048860),
(655961, 51049295, 51049324),
(655961, 51054781, 51054993),
(655961, 51058125, 51058244),
(655961, 51058340, 51058456),
(655961, 51059866, 51059916),
(655961, 51065423, 51065606),
(655961, 51067019, 51067187),
(655961, 51076638, 51076776),
(655961, 51078256, 51085042),
(658945, 17267386, 17267527),
(658945, 17268756, 17269091),
(658945, 17271597, 17271655),
(658945, 17273904, 17274024),
(658945, 17274107, 17274185),
(658945, 17275801, 17275825),
(658945, 17276495, 17276624),
(658945, 17276823, 17276909),
(658945, 17278845, 17279337),
(664372, 17753858, 17753967),
(664372, 17759929, 17760104),
(664372, 17761396, 17761582),
(664372, 17764897, 17765073),
(664372, 17766579, 17766689),
(664372, 17768738, 17768811),
(664372, 17771196, 17771287),
(664372, 17772634, 17772784),
(664372, 17773096, 17773132),
(664372, 17773219, 17773299),
(664372, 17774271, 17774401),
(664372, 17778002, 17778063),
(664372, 17779978, 17780121),
(664372, 17780621, 17788941),
(665491, 47369311, 47369581),
(665491, 47373463, 47373570),
(665491, 47373808, 47374048),
(665491, 47375234, 47375299),
(665491, 47377014, 47377077),
(665491, 47378953, 47379054),
(665491, 47379769, 47379969),
(665491, 47385166, 47385210),
(665491, 47386572, 47387020),
(665496, 47403156, 47403402),
(665496, 47408401, 47408555),
(665496, 47410094, 47410372),
(665496, 47412414, 47412560),
(665496, 47414269, 47414418),
(665496, 47416296, 47416429),
(665496, 47429742, 47429941),
(665496, 47445548, 47445657),
(665496, 47463031, 47463154),
(665496, 47466658, 47466808),
(665496, 47470965, 47471062),
(665496, 47475025, 47475270),
(665496, 47476367, 47476571),
(665496, 47478272, 47478519),
(665496, 47480696, 47480871),
(665496, 47482779, 47483223),
(665506, 47783145, 47783493),
(665506, 47790927, 47791123),
(665506, 47795894, 47796063),
(665506, 47798611, 47801155),
(665506, 47803420, 47803685),
(665506, 47804910, 47805027),
(665506, 47805618, 47805707),
(665506, 47806204, 47806358),
(665506, 47806452, 47806651),
(665506, 47806779, 47806953),
(668701, 146837749, 146837811),
(668701, 146838040, 146838205),
(668701, 146846629, 146846818),
(668701, 146848249, 146848411),
(668701, 146849145, 146849313),
(668701, 146850256, 146850364),
(668701, 146856648, 146856807),
(668701, 146858512, 146858644),
(668701, 146859538, 146859601),
(668701, 146867570, 146867647),
(668701, 146877922, 146878220),
(669935, 189784508, 189784593),
(669935, 189791790, 189791941),
(669935, 189795769, 189795951),
(669935, 189805652, 189805754),
(669935, 189806423, 189806846),
(670810, 214725646, 214729008),
(670810, 214730411, 214730508),
(670810, 214745067, 214745159),
(670810, 214745722, 214745854),
(670810, 214752447, 214752555),
(670810, 214767482, 214767654),
(670810, 214769232, 214769312),
(670810, 214780560, 214781509),
(670810, 214792297, 214792445),
(670810, 214797061, 214797117),
(670810, 214809412, 214809683),
(671180, 219561747, 219562008),
(671180, 219562402, 219562674),
(671180, 219563355, 219563627),
(671180, 219565242, 219565514),
(671180, 219566830, 219567126),
(671180, 219567273, 219567575),
(671180, 219567718, 219567969),
(671180, 219568055, 219568324),
(671180, 219571394, 219571464),
(671183, 219550756, 219550842),
(671183, 219551529, 219551798),
(671183, 219552112, 219552216),
(671183, 219552536, 219552697),
(671183, 219552868, 219553024),
(671183, 219553574, 219553686),
(671183, 219554474, 219554740),
(671183, 219556020, 219556292),
(671183, 219556454, 219556723),
(671183, 219557823, 219558110),
(671183, 219558184, 219558459),
(671183, 219559225, 219559497),
(671183, 219562402, 219562674),
(671183, 219563355, 219563627),
(671183, 219565242, 219565514),
(671183, 219566830, 219567126),
(671183, 219567273, 219567575),
(671183, 219567718, 219567969),
(671183, 219568055, 219568324),
(671183, 219570221, 219571241),
(672807, 13995369, 13995809),
(672807, 14002288, 14002404),
(672807, 14085621, 14085728),
(672807, 14493479, 14493508),
(672807, 14684843, 14684959),
(672807, 15229940, 15230061),
(672807, 15431405, 15431435),
(672807, 15499774, 15499847),
(672807, 15862745, 15862826),
(672807, 15885764, 15885811),
(672807, 15933276, 15933338),
(672807, 15937476, 15937544),
(672807, 15967553, 15967630),
(672807, 15986727, 15986801),
(672807, 15987066, 15987158),
(672807, 16041201, 16041278),
(672807, 16049830, 16053197),
(674460, 49632945, 49636459),
(674460, 49637341, 49637442),
(674460, 49639678, 49639800),
(674460, 49640478, 49640665),
(674460, 49642468, 49642584),
(674460, 49643526, 49643650),
(674460, 49646965, 49647078),
(674460, 49656568, 49656702),
(674460, 49713576, 49713878),
(679749, 10026414, 10026473),
(679749, 10028625, 10028721),
(679749, 10032832, 10032972),
(679749, 10034469, 10034536),
(679749, 10034695, 10034798),
(679749, 10035173, 10035233),
(679749, 10036287, 10036339),
(679749, 10039279, 10039357),
(679749, 10039721, 10039845),
(679749, 10041623, 10041710),
(679749, 10042559, 10042663),
(679749, 10043050, 10043150),
(679749, 10043484, 10043592),
(679749, 10043829, 10043864),
(679749, 10046580, 10046723),
(679749, 10047917, 10048051),
(679749, 10049374, 10049505),
(679749, 10052387, 10052497),
(679749, 10060294, 10060403),
(679749, 10062151, 10062211),
(679749, 10063792, 10063911),
(679749, 10064356, 10064429),
(679749, 10064729, 10064875),
(679749, 10065394, 10065494),
(679749, 10065864, 10065979),
(679749, 10067209, 10067317),
(679749, 10072871, 10072981),
(679749, 10073253, 10073362),
(679749, 10074530, 10074673),
(679749, 10078081, 10078197),
(679749, 10081100, 10081228),
(679749, 10081346, 10081464),
(679749, 10085812, 10085922),
(679749, 10087134, 10087264),
(679749, 10088449, 10088542),
(679749, 10088828, 10088950),
(679749, 10090292, 10090385),
(679749, 10092181, 10092252),
(679749, 10093285, 10093323),
(679749, 10094289, 10094363),
(679749, 10095200, 10095274),
(679749, 10096326, 10096472),
(679749, 10098720, 10099660),
(680668, 36993518, 36993663),
(680668, 36996619, 36996709),
(680668, 37000955, 37001053),
(680668, 37004401, 37004474),
(680668, 37006991, 37007063),
(680668, 37008814, 37008905),
(680668, 37011820, 37011862),
(680668, 37012011, 37012099),
(680668, 37014432, 37014544),
(680668, 37017506, 37017599),
(680668, 37020310, 37020463),
(680668, 37025637, 37026007),
(680668, 37028784, 37028932),
(680668, 37040186, 37040294),
(680668, 37042268, 37042331),
(680668, 37047519, 37047683),
(680668, 37048517, 37048609),
(680668, 37048904, 37049017),
(680668, 37050486, 37050846),
(684697, 142449235, 142449602),
(684697, 142453128, 142453233),
(684697, 142457604, 142457755),
(684697, 142458958, 142459111),
(684697, 142459227, 142459383),
(684697, 142461940, 142462090),
(684697, 142465097, 142465240),
(684697, 142466324, 142466533),
(684697, 142467934, 142468068),
(684697, 142469337, 142469569),
(684697, 142470086, 142470183),
(684697, 142485140, 142485282),
(684697, 142493132, 142493311),
(684697, 142496361, 142496520),
(684697, 142497013, 142497192),
(684697, 142498597, 142498774),
(684697, 142499627, 142499718),
(684697, 142503362, 142503453),
(684697, 142505139, 142505303),
(684697, 142507931, 142508109),
(684697, 142512260, 142512470),
(684697, 142513501, 142513638),
(684697, 142515395, 142515515),
(684697, 142519669, 142519784),
(684697, 142522728, 142522841),
(684697, 142523993, 142524199),
(684697, 142535080, 142535205),
(684697, 142536108, 142536201),
(684697, 142538482, 142538625),
(684697, 142540904, 142541034),
(684697, 142542665, 142542757),
(684697, 142547725, 142547910),
(684697, 142549479, 142549673),
(684697, 142550132, 142550302),
(684697, 142553227, 142553398),
(684697, 142553640, 142553740),
(684697, 142553825, 142554015),
(684697, 142555877, 142556139),
(684697, 142556383, 142556575),
(684697, 142558624, 142558776),
(684697, 142559251, 142559441),
(684697, 142560263, 142560454),
(684697, 142561243, 142561421),
(684697, 142562232, 142563109),
(684697, 142566121, 142566261),
(684697, 142568063, 142568154),
(684697, 142578646, 142578733),
(685118, 156674590, 156674796),
(685118, 156677657, 156678614),
(685118, 156694020, 156694188),
(685118, 156695865, 156696025),
(685118, 156703424, 156703702),
(685118, 156704684, 156706770),
(685673, 179148357, 179148603),
(685673, 179198750, 179199177),
(685673, 179199690, 179199899),
(685673, 179201290, 179201540),
(685673, 179203544, 179203789),
(685673, 179204503, 179204588),
(685673, 179209595, 179209700),
(685673, 179210186, 179210338),
(685673, 179210431, 179210565),
(685673, 179218210, 179218334),
(685673, 179219196, 179219277),
(685673, 179219571, 179219735),
(685673, 179219949, 179220052),
(685673, 179220986, 179221157),
(685673, 179224081, 179224187),
(685673, 179224700, 179224821),
(685673, 179225962, 179226040),
(685673, 179229272, 179229442),
(685673, 179230004, 179230121),
(685673, 179230225, 179230376),
(685673, 179234094, 179240093),
(691509, 185051168, 185051277),
(691509, 185051847, 185051936),
(691509, 185054979, 185055341),
(691509, 185062457, 185062816),
(691509, 185069961, 185070030),
(691509, 185071568, 185072073),
(691509, 185085784, 185085993),
(691509, 185087545, 185087698),
(691509, 185096482, 185096621),
(691509, 185106907, 185107248),
(693673, 80654652, 80654964),
(693673, 80656411, 80656531),
(693673, 80665143, 80665363),
(693673, 80670097, 80670309),
(693673, 80672244, 80672360),
(693673, 80672741, 80672858),
(693673, 80674983, 80675128),
(693673, 80678927, 80679093),
(693673, 80725453, 80725565),
(693673, 80728851, 80728965),
(693673, 80741464, 80741548),
(693673, 80744506, 80744615),
(693673, 80761546, 80761678),
(693673, 80767933, 80768120),
(693673, 80768835, 80769003),
(693673, 80775694, 80775758),
(693673, 80778720, 80778836),
(693673, 80787565, 80787672),
(693673, 80792733, 80792844),
(693673, 80813584, 80813741),
(693673, 80854130, 80854316),
(693673, 80864813, 80864942),
(693673, 80873116, 80873287),
(693673, 80875751, 80876815),
(694293, 112737885, 112737925),
(694293, 112754873, 112755025),
(694293, 112766326, 112766410),
(694293, 112767189, 112767390),
(694293, 112775629, 112775737),
(694293, 112780790, 112780903),
(694293, 112792446, 112792529),
(694293, 112801279, 112801383),
(694293, 112815495, 112815593),
(694293, 112818966, 112819344),
(694293, 112821896, 112821991),
(694293, 112827108, 112827247),
(694293, 112827929, 112828006),
(694293, 112828856, 112828972),
(694293, 112834951, 112835165),
(694293, 112837553, 112846239),
(694774, 132556977, 132557453),
(694774, 132559284, 132559367),
(694774, 132575777, 132575928),
(694774, 132579317, 132579502),
(694774, 132579862, 132580066),
(694774, 132587562, 132587690),
(694774, 132587924, 132588089),
(694774, 132588687, 132588880),
(694774, 132589631, 132589837),
(694774, 132591224, 132591406),
(694774, 132591877, 132592034),
(694774, 132594869, 132595044),
(694774, 132595573, 132595810),
(694774, 132603300, 132603489),
(694774, 132603920, 132604046),
(694774, 132604806, 132604999),
(694774, 132608615, 132608725),
(694774, 132609117, 132609209),
(694774, 132609283, 132609396),
(694774, 132616003, 132616130),
(694774, 132618070, 132618294),
(694774, 132637115, 132637200),
(694774, 132638081, 132638223),
(694774, 132640672, 132640805),
(694774, 132642178, 132646349),
(696738, 176905005, 176905492),
(696738, 176906011, 176906047),
(696738, 176907114, 176907177),
(696738, 176908523, 176908694),
(696738, 176911311, 176911389),
(696738, 176943335, 176943488),
(696738, 176951474, 176951577),
(696738, 176955959, 176956035),
(696738, 176958093, 176958154),
(696738, 176968555, 176969291),
(696738, 176969601, 176969706),
(696738, 176970742, 176970866),
(696738, 176975396, 176975480),
(696738, 176982469, 176982623),
(696738, 177006284, 177006408),
(699340, 35452338, 35452793),
(699340, 35455747, 35456353),
(699340, 35457556, 35457600),
(699340, 35457916, 35457984),
(699340, 35458297, 35458440),
(699340, 35459331, 35459454),
(699340, 35459682, 35459760),
(699340, 35460552, 35460618),
(699340, 35462789, 35462914),
(699340, 35466244, 35467102),
(701961, 130827406, 130827651),
(701961, 130834870, 130837135),
(703503, 5970925, 5973542),
(703503, 5977588, 5977757),
(703503, 5978596, 5978696),
(703503, 5982824, 5982991),
(703503, 5986759, 5987620),
(703503, 5989800, 5989955),
(703503, 5991973, 5992057),
(703503, 5995534, 5995633),
(703503, 5997326, 5997423),
(703503, 5999108, 5999275),
(703503, 6002453, 6002636),
(703503, 6003690, 6003792),
(703503, 6003972, 6004058),
(703503, 6005892, 6006031),
(703503, 6008997, 6009049),
(707558, 129188633, 129189482),
(707558, 129203384, 129203589),
(707558, 129205203, 129205412),
(707558, 129205610, 129205782),
(707558, 129206150, 129206369),
(707558, 129206464, 129206587),
(707558, 129208759, 129208851),
(707558, 129209289, 129209397),
(707558, 129210363, 129210548),
(707558, 129210965, 129211113),
(707558, 129211636, 129211770),
(707558, 129212024, 129213545),
(708144, 142749472, 142749524),
(708144, 142750555, 142750714),
(708144, 142751774, 142752027),
(708144, 142752431, 142752567),
(708144, 142752868, 142753072),
(711492, 89933331, 89935612),
(711492, 89937026, 89937075),
(711492, 89943253, 89943366),
(711492, 89946140, 89946295),
(711492, 89947824, 89947892),
(711492, 89953244, 89953691),
(711492, 89955283, 89955555),
(711492, 89958725, 89958854),
(711492, 89964410, 89964507),
(711492, 89970364, 89970557),
(711492, 89971173, 89971290),
(711492, 89978220, 89978323),
(711492, 89980734, 89980893),
(711492, 89981375, 89981523),
(711492, 89982722, 89982855),
(711492, 89984525, 89984667),
(713501, 5919022, 5923309),
(713501, 5924658, 5924845),
(713501, 5929044, 5929159),
(713501, 5954016, 5954095),
(713501, 5968019, 5969436),
(713501, 5988345, 5988545),
(713501, 6007195, 6007787),
(713688, 17135040, 17135425),
(713688, 17143288, 17143376),
(713688, 17226203, 17226287),
(713688, 17235658, 17235792),
(713688, 17236409, 17236588),
(713688, 17273733, 17273866),
(713688, 17298190, 17302051),
(713690, 17135040, 17135425),
(713690, 17143288, 17143376),
(713690, 17226203, 17226287),
(713690, 17235658, 17235792),
(713690, 17236409, 17236588),
(713690, 17273733, 17273866),
(713690, 17298190, 17298352),
(713690, 17309058, 17309252),
(713690, 17330632, 17330808),
(713690, 17332605, 17332730),
(713690, 17340827, 17340948),
(713690, 17342325, 17342444),
(713690, 17366617, 17366717),
(713690, 17388162, 17388253),
(713690, 17394534, 17395069),
(713690, 17409293, 17409473),
(713690, 17415788, 17415881),
(713690, 17415966, 17416189),
(713690, 17457524, 17457715),
(713690, 17462916, 17463013),
(713690, 17464497, 17464623),
(713690, 17465981, 17466118),
(713690, 17466706, 17466891),
(713690, 17484295, 17484480),
(713690, 17486989, 17487066),
(713690, 17502551, 17503923),
(713823, 21967752, 21968242),
(713823, 21970902, 21971208),
(713823, 21974678, 21974857),
(715510, 95442980, 95446391),
(715510, 95446911, 95447451),
(715510, 95449069, 95449323),
(715510, 95449841, 95449940),
(715510, 95453478, 95453620),
(715510, 95456276, 95456413),
(715510, 95458013, 95458293),
(715510, 95459600, 95459783),
(715510, 95461856, 95461998),
(715510, 95467116, 95467425),
(715510, 95468751, 95469153),
(715510, 95469813, 95469931),
(715510, 95476034, 95476159),
(715510, 95476759, 95476857),
(715510, 95477547, 95477702),
(715510, 95478055, 95478186),
(715510, 95479000, 95479147),
(715510, 95479969, 95480090),
(715510, 95480390, 95480588),
(715510, 95481949, 95482040),
(715510, 95482134, 95482203),
(715510, 95485685, 95485874),
(715510, 95506407, 95506599),
(715510, 95508161, 95509266);
