#include "TestFramework.h"
#include "VcfToBedpe.h"
#include "VcfToBedpe.cpp"


TEST_CLASS(VcfToBedpe_Test)
{
Q_OBJECT
private slots:

	void simple_line()
	{
		VcfToBedpe test(TESTDATA("data_in/VcfToBedpe_in1_manta.vcf.gz"));

		//Delly
		VcfToBedpe::VcfLineInternal delly_vcf_line("chr2\t10485\tBND00000821\tG\tG[CHR1:10223[\t.\tLowQual\tCIEND=-572,572;CIPOS=-572,572;CHR2=chr1;END=10223;PE=2;MAPQ=20;CT=3to5;IMPRECISE;SVTYPE=BND;SVMETHOD=EMBL.DELLYv0.8.1\tGT:GL:GQ:FT:RC:RCL:RCR:CN:DR:DV:RR:RV\t0/0:0,-5.23326,-59.0137:52:PASS:134:0:534:1:19:0:0:0");
		QByteArray delly_expected = "chr2\t9913\t11057\tchr1\t9651\t10795\tBND00000821\t.\t.\t.\tBND\tLowQual\tBND00000821\tG\tG[CHR1:10223[\t.\t.\t.\tCIEND=-572,572;CIPOS=-572,572;CHR2=chr1;END=10223;PE=2;MAPQ=20;CT=3to5;IMPRECISE;SVTYPE=BND;POS=10485;SVMETHOD=EMBL.DELLYv0.8.1\t.\tGT:GL:GQ:FT:RC:RCL:RCR:CN:DR:DV:RR:RV\t0/0:0,-5.23326,-59.0137:52:PASS:134:0:534:1:19:0:0:0";
		S_EQUAL(test.convertSingleLine(delly_vcf_line).toText(),delly_expected);

		delly_vcf_line = VcfToBedpe::VcfLineInternal("chr1\t48058280\tINS00000292\tC\t<INS>\t.\tPASS\tCIEND=-5,5;CIPOS=-5,5;CHR2=chr1;END=48058281;PE=0;MAPQ=0;SRMAPQ=60;SR=11;SRQ=0.99;CONSENSUS=GCAAAGAGGCTAGGAAAACCTTGCCAGGTGAGCAGTTTTTGGAGCTAGCAGCAGCCCTGGCTGTCAGCTGGGGCAGGGACTCAAATCCCAATTTGGGTCTTTCAGTGGAAACAGACAGTGCTCAAAATAAAATGAAACAAAACCTGGACTGGAACTCAGGAGTCG;CE=1.97308;CT=NtoN;PRECISE;SVTYPE=INS;SVMETHOD=EMBL.DELLYv0.8.1;INSLEN=65;HOMLEN=4\tGT:GL:GQ:FT:RC:RCL:RCR:CN:DR:DV:RR:RV\t1/1:-329.787,-27.9827,0:10000:PASS:73963:35932:38057:2:0:0:0:93");
		delly_expected = "chr1\t48058275\t48058285\tchr1\t48058276\t48058286\tINS00000292\t.\t.\t.\tINS\tPASS\tINS00000292\tC\t<INS>\t.\t.\t.\tCIEND=-5,5;CIPOS=-5,5;CHR2=chr1;END=48058281;PE=0;MAPQ=0;SRMAPQ=60;SR=11;SRQ=0.99;CONSENSUS=GCAAAGAGGCTAGGAAAACCTTGCCAGGTGAGCAGTTTTTGGAGCTAGCAGCAGCCCTGGCTGTCAGCTGGGGCAGGGACTCAAATCCCAATTTGGGTCTTTCAGTGGAAACAGACAGTGCTCAAAATAAAATGAAACAAAACCTGGACTGGAACTCAGGAGTCG;CE=1.97308;CT=NtoN;PRECISE;SVTYPE=INS;POS=48058280;SVMETHOD=EMBL.DELLYv0.8.1;INSLEN=65;HOMLEN=4\t.\tGT:GL:GQ:FT:RC:RCL:RCR:CN:DR:DV:RR:RV\t1/1:-329.787,-27.9827,0:10000:PASS:73963:35932:38057:2:0:0:0:93";
		S_EQUAL(test.convertSingleLine(delly_vcf_line).toText(),delly_expected);

		//Manta
		VcfToBedpe::VcfLineInternal manta_vcf_line("chr1\t1925144\tMantaINS:0:3835:3835:0:0:0\tG\tGGGCACAGTGGCTCATGCCTGTAATCCCAGCAACATGGGAGCCTGAGGTGGGAGGCTCTCTTGAGGCCAGGAGTTTGAGACCAGCCTGGGCAACATAGTGAGACCCCCCACCCCCCGCCATTTCTAGGAAAAAAAAAAAAAGTGGCCA\t999\tPASS\tSVTYPE=INS;SVLEN=147;END=1925144;CIPOS=0,14;CIGAR=1M147I;HOMLEN=14;HOMSEQ=GGCACAGTGGCTCA;CONTIG=CCCGGCCGGTGGCTGTTTTCTATTAGACCTTAAATATGTGATTGGTTTTAACGCCTATTAATCACATTGTGCTTGTACCATGATTAATATACAAAACAGCTGATGTCAAATGCTTATAAATCAGCAGGGCACAGTGGCTCATGCCTGTAATCCCAGCAACATGGGAGCCTGAGGTGGGAGGCTCTCTTGAGGCCAGGAGTTTGAGACCAGCCTGGGCAACATAGTGAGACCCCCCACCCCCCGCCATTTCTAGGAAAAAAAAAAAAAGTGGCCAGGCACAGTGGCTCACGCCTGCAATCCCAGCACTTTGGGAGGCCGAGGCAGGTGGATCACGAGGTCAGGAGATCGAGACCATCCTGGCTAACACAATGAAACCCCACCTCTACTAAAAATACAAAAAATTAGCCGGGCGTGGTGGCGGGCGCCTATAGTCCCAGCTACTCGGGAGGCTGAGGAAGGA\tGT:FT:GQ:PL:PR:SR\t1/1:PASS:222:999,225,0:0,23:0,75");
		QByteArray manta_expected = "chr1\t1925144\t1925158\tchr1\t1925144\t1925144\tMantaINS:0:3835:3835:0:0:0\t999\t.\t.\tINS\tPASS\tMantaINS:0:3835:3835:0:0:0\tG\tGGGCACAGTGGCTCATGCCTGTAATCCCAGCAACATGGGAGCCTGAGGTGGGAGGCTCTCTTGAGGCCAGGAGTTTGAGACCAGCCTGGGCAACATAGTGAGACCCCCCACCCCCCGCCATTTCTAGGAAAAAAAAAAAAAGTGGCCA\t.\t.\t.\tSVTYPE=INS;POS=1925144;SVLEN=147;END=1925144;CIPOS=0,14;CIGAR=1M147I;HOMLEN=14;HOMSEQ=GGCACAGTGGCTCA;CONTIG=CCCGGCCGGTGGCTGTTTTCTATTAGACCTTAAATATGTGATTGGTTTTAACGCCTATTAATCACATTGTGCTTGTACCATGATTAATATACAAAACAGCTGATGTCAAATGCTTATAAATCAGCAGGGCACAGTGGCTCATGCCTGTAATCCCAGCAACATGGGAGCCTGAGGTGGGAGGCTCTCTTGAGGCCAGGAGTTTGAGACCAGCCTGGGCAACATAGTGAGACCCCCCACCCCCCGCCATTTCTAGGAAAAAAAAAAAAAGTGGCCAGGCACAGTGGCTCACGCCTGCAATCCCAGCACTTTGGGAGGCCGAGGCAGGTGGATCACGAGGTCAGGAGATCGAGACCATCCTGGCTAACACAATGAAACCCCACCTCTACTAAAAATACAAAAAATTAGCCGGGCGTGGTGGCGGGCGCCTATAGTCCCAGCTACTCGGGAGGCTGAGGAAGGA\t.\tGT:FT:GQ:PL:PR:SR\t1/1:PASS:222:999,225,0:0,23:0,75";
		S_EQUAL(test.convertSingleLine(manta_vcf_line).toText(),manta_expected);

		//MANTA single breakpoint (no MateID)
		manta_vcf_line = VcfToBedpe::VcfLineInternal("chr9\t2326293\tMantaBND:3701:0:1:0:0:0:0\tC\t[CHR13:28060971[C\t109\tNoPairSupport;off-target\tSVTYPE=BND;CIPOS=0,13;HOMLEN=13;HOMSEQ=TTGAGGTTTCTTG;CONTIG=TGGCTAGAAAAATATGGAGCTAGAATTTGAAACCATTCCGTTTGTGCTTTTCTGTCATTATCATCATCACCATCTCATGCTTTCAAGAAACCTCAAGGCCGGGCGCGGTGGCTCACGCCTGTAATCCCAGCACTT;BND_DEPTH=12\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:109:159,0,139:5,0:8,4");
		manta_expected = "chr9\t2326293\t2326306\t.\t.\t.\tMantaBND:3701:0:1:0:0:0:0\t109\t.\t.\tBND\tNoPairSupport;off-target\tMantaBND:3701:0:1:0:0:0:0\tC\t[CHR13:28060971[C\tMISSING\tMISSING\tMISSING\tSVTYPE=BND;POS=2326293;CIPOS=0,13;HOMLEN=13;HOMSEQ=TTGAGGTTTCTTG;CONTIG=TGGCTAGAAAAATATGGAGCTAGAATTTGAAACCATTCCGTTTGTGCTTTTCTGTCATTATCATCATCACCATCTCATGCTTTCAAGAAACCTCAAGGCCGGGCGCGGTGGCTCACGCCTGTAATCCCAGCACTT;BND_DEPTH=12\tMISSING\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:109:159,0,139:5,0:8,4";
		S_EQUAL(test.convertSingleLine(manta_vcf_line,true).toText(),manta_expected);
	}

	void complex_line()
	{
		VcfToBedpe test(TESTDATA("data_in/VcfToBedpe_in1_manta.vcf.gz"));

		//Manta breakpoints (two lines in original file)
		VcfToBedpe::VcfLineInternal manta_vcf_line_bnd1("chr1\t741771\tMantaBND:39:0:1:0:0:0:0\tC\tC]CHR2:243060667]\t635\tPASS\tSVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:1;HOMLEN=12;HOMSEQ=CATGCACTGCCC;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=85;MATE_BND_DEPTH=74\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:635:685,0,999:72,1:76,22");
		VcfToBedpe::VcfLineInternal manta_vcf_line_bnd2("chr2\t243060655\tMantaBND:39:0:1:0:0:0:1\tC\tC]CHR1:741783]\t635\tPASS\tSVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:0;HOMLEN=12;HOMSEQ=GGGCAGTGCATG;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=74;MATE_BND_DEPTH=85\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:635:685,0,999:72,1:76,22");
		QByteArray expected = "chr1\t741771\t741783\tchr2\t243060655\t243060667\tMantaBND:39:0:1:0:0:0:0\t635\t.\t.\tBND\tPASS\tMantaBND:39:0:1:0:0:0:0\tC\tC]CHR2:243060667]\tMantaBND:39:0:1:0:0:0:1\tC\tC]CHR1:741783]\tSVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:1;HOMLEN=12;HOMSEQ=CATGCACTGCCC;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=85;MATE_BND_DEPTH=74	SVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:0;HOMLEN=12;HOMSEQ=GGGCAGTGCATG;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=74;MATE_BND_DEPTH=85\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:635:685,0,999:72,1:76,22";
		S_EQUAL(test.convertComplexLine(manta_vcf_line_bnd1,manta_vcf_line_bnd2).toText(),expected);

		//Manta breakpoints, conflicting sample annotation info
		manta_vcf_line_bnd1 = VcfToBedpe::VcfLineInternal("chr1\t741771\tMantaBND:39:0:1:0:0:0:0\tC\tC]CHR2:243060667]\t635\tPASS\tSVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:1;HOMLEN=12;HOMSEQ=CATGCACTGCCC;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=85;MATE_BND_DEPTH=74\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:635:685,0,230:72,1:76,22");
		manta_vcf_line_bnd2 = VcfToBedpe::VcfLineInternal("chr2\t243060655\tMantaBND:39:0:1:0:0:0:1\tC\tC]CHR1:741783]\t635\tPASS\tSVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:0;HOMLEN=12;HOMSEQ=GGGCAGTGCATG;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=74;MATE_BND_DEPTH=85\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:635:685,0,999:72,1:76,22");
		expected = "chr1\t741771\t741783\tchr2\t243060655\t243060667\tMantaBND:39:0:1:0:0:0:0\t635\t.\t.\tBND\tPASS\tMantaBND:39:0:1:0:0:0:0\tC\tC]CHR2:243060667]\tMantaBND:39:0:1:0:0:0:1\tC\tC]CHR1:741783]\tSVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:1;HOMLEN=12;HOMSEQ=CATGCACTGCCC;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=85;MATE_BND_DEPTH=74\tSVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:0;HOMLEN=12;HOMSEQ=GGGCAGTGCATG;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=74;MATE_BND_DEPTH=85\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:635:AMBIGUOUS:72,1:76,22";
		S_EQUAL(test.convertComplexLine(manta_vcf_line_bnd1,manta_vcf_line_bnd2).toText(),expected);

		//Manta breakpoints, empty second part (MateID given but not found)
		manta_vcf_line_bnd1 = VcfToBedpe::VcfLineInternal("chr1\t741771\tMantaBND:39:0:1:0:0:0:0\tC\tC]CHR2:243060667]\t635\tPASS\tSVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:1;HOMLEN=12;HOMSEQ=CATGCACTGCCC;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=85;MATE_BND_DEPTH=74\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:635:685,0,230:72,1:76,22");
		manta_vcf_line_bnd2 = VcfToBedpe::VcfLineInternal();
		expected = "chr1\t741771\t741783\t.\t.\t.\tMantaBND:39:0:1:0:0:0:0\t635\t.\t.\tBND\tPASS\tMantaBND:39:0:1:0:0:0:0\tC\tC]CHR2:243060667]\tNOT_FOUND\tNOT_FOUND\tNOT_FOUND\tSVTYPE=BND;CIPOS=0,12;MATEID=MantaBND:39:0:1:0:0:0:1;HOMLEN=12;HOMSEQ=CATGCACTGCCC;CONTIG=TTTGATGGGGACAAAGTGGGGTGTGGACGACGTTAAAGCTAAGATCATAAAAAAACTGTATTCATTCTAGGCTACGCAACTAAAAATACATAAATCATCTGATTAACTGCATTGTAAGGATGTAGGTGTTACAAATATCTAGTTGAAACACAGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCGAGTTTGAAGTGTAACATGGGATTTCTCTGCAGGGGAGGCATGCACTGCCCGAGTTTGAAGTATAACATGGGATTTCTCTCCAGAGCAGCCATGCACTGCCCAGGCTGGAAGCATGCTCAACCACAAGG;BND_DEPTH=85;MATE_BND_DEPTH=74\tNOT_FOUND\tGT:FT:GQ:PL:PR:SR\t0/1:PASS:635:685,0,230:72,1:76,22";
		S_EQUAL(test.convertComplexLine(manta_vcf_line_bnd1,manta_vcf_line_bnd2,true).toText(),expected);
	}

	void convert_manta_file()
	{
		//unsorted output
		EXECUTE("VcfToBedpe","-in " + TESTDATA("data_in/VcfToBedpe_in1_manta.vcf.gz") + " -out out/VcfToBedpe_out1_manta.bedpe -no_sort");
        REMOVE_LINES("out/VcfToBedpe_out1_manta.bedpe",QRegularExpression("##fileDate="));
		COMPARE_FILES("out/VcfToBedpe_out1_manta.bedpe", TESTDATA("data_out/VcfToBedpe_out1_manta.bedpe"));

		//sorted output
		EXECUTE("VcfToBedpe","-in " + TESTDATA("data_in/VcfToBedpe_in1_manta.vcf.gz") + " -out out/VcfToBedpe_out2_manta.bedpe");
        REMOVE_LINES("out/VcfToBedpe_out2_manta.bedpe",QRegularExpression("##fileDate="));
		COMPARE_FILES("out/VcfToBedpe_out2_manta.bedpe", TESTDATA("data_out/VcfToBedpe_out2_manta.bedpe"));

		//empty input file
		EXECUTE("VcfToBedpe","-in " + TESTDATA("data_in/VcfToBedpe_in2_manta.vcf.gz") + " -out out/VcfToBedpe_out3_manta.bedpe");
        REMOVE_LINES("out/VcfToBedpe_out3_manta.bedpe",QRegularExpression("##fileDate="));
		COMPARE_FILES("out/VcfToBedpe_out3_manta.bedpe", TESTDATA("data_out/VcfToBedpe_out3_manta.bedpe"));
	}

	void convert_delly_file()
	{
		//Unsorted output
		EXECUTE("VcfToBedpe","-in " + TESTDATA("data_in/VcfToBedpe_in1_delly.vcf.gz") + " -out out/VcfToBedpe_out1_delly.bedpe -no_sort");
        REMOVE_LINES("out/VcfToBedpe_out1_delly.bedpe",QRegularExpression("##fileDate="));
		COMPARE_FILES("out/VcfToBedpe_out1_delly.bedpe", TESTDATA("data_out/VcfToBedpe_out1_delly.bedpe"));

		//sorted output
		EXECUTE("VcfToBedpe","-in " + TESTDATA("data_in/VcfToBedpe_in1_delly.vcf.gz") + " -out out/VcfToBedpe_out2_delly.bedpe");
        REMOVE_LINES("out/VcfToBedpe_out2_delly.bedpe",QRegularExpression("##fileDate="));
		COMPARE_FILES("out/VcfToBedpe_out2_delly.bedpe", TESTDATA("data_out/VcfToBedpe_out2_delly.bedpe"));
	}

	void convert_sniffles_file()
	{
		//Unsorted output
		EXECUTE("VcfToBedpe","-in " + TESTDATA("data_in/VcfToBedpe_in3_sniffles.vcf.gz") + " -out out/VcfToBedpe_out1_sniffles.bedpe -no_sort");
        REMOVE_LINES("out/VcfToBedpe_out1_sniffles.bedpe",QRegularExpression("##fileDate="));
		COMPARE_FILES("out/VcfToBedpe_out1_sniffles.bedpe", TESTDATA("data_out/VcfToBedpe_out1_sniffles.bedpe"));
	}

	void convert_cutesv_file()
	{
		//Unsorted output
		EXECUTE("VcfToBedpe","-in " + TESTDATA("data_in/VcfToBedpe_in4_cutesv.vcf.gz") + " -out out/VcfToBedpe_out1_cutesv.bedpe -no_sort");
        REMOVE_LINES("out/VcfToBedpe_out1_cutesv.bedpe",QRegularExpression("##fileDate="));
		COMPARE_FILES("out/VcfToBedpe_out1_cutesv.bedpe", TESTDATA("data_out/VcfToBedpe_out1_cutesv.bedpe"));
	}

	void convert_dipdiff_file()
	{
		//Unsorted output
		EXECUTE("VcfToBedpe","-in " + TESTDATA("data_in/VcfToBedpe_in5_dipdiff.vcf.gz") + " -out out/VcfToBedpe_out1_dipdiff.bedpe -no_sort");
        REMOVE_LINES("out/VcfToBedpe_out1_dipdiff.bedpe",QRegularExpression("##fileDate="));
		COMPARE_FILES("out/VcfToBedpe_out1_dipdiff.bedpe", TESTDATA("data_out/VcfToBedpe_out1_dipdiff.bedpe"));
	}

	void bug_dragen_ambigous_format_entries()
	{
		EXECUTE("VcfToBedpe","-in " + TESTDATA("data_in/VcfToBedpe_in6_dragen_ambigous_bug.vcf") + " -out out/VcfToBedpe_out_bug_dragen_ambigous_format_entries.bedpe -no_sort");
		REMOVE_LINES("out/VcfToBedpe_out_bug_dragen_ambigous_format_entries.bedpe",QRegularExpression("##fileDate="));
		COMPARE_FILES("out/VcfToBedpe_out_bug_dragen_ambigous_format_entries.bedpe", TESTDATA("data_out/VcfToBedpe_out_bug_dragen_ambigous_format_entries.bedpe"));
	}
};
