#ifndef HTTPPARTS_H
#define HTTPPARTS_H

#include "cppREST_global.h"
#include <QMap>

typedef enum
{
	APPLICATION_OCTET_STREAM,
	APPLICATION_JSON,
	APPLICATION_JAVASCRIPT,
	IMAGE_JPEG,
	IMAGE_PNG,
	IMAGE_SVG_XML,
	TEXT_PLAIN,
	TEXT_CSV,
	TEXT_HTML,
	TEXT_XML,
	TEXT_CSS,
	MULTIPART_FORM_DATA,
	APPLICATION_X_WWW_FORM_URLENCODED
} ContentType;

typedef enum
{
	CONTINUE,
	SWITCHING_PROTOCOLS,
	OK,
	CREATED,
	ACCEPTED,
	NON_AUTHORITATIVE_INFORMATION,
	NO_CONTENT,
	RESET_CONTENT,
	PARTIAL_CONTENT,
	MULTIPLE_CHOICES,
	MOVED_PERMANENTLY,
	FOUND,
	SEE_OTHER,
	NOT_MODIFIED,
	USE_PROXY,
	TEMPORARY_REDIRECT,
	BAD_REQUEST,
	UNAUTHORIZED,
	PAYMENT_REQUIRED,
	FORBIDDEN,
	NOT_FOUND,
	METHOD_NOT_ALLOWED,
	NOT_ACCEPTABLE,
	PROXY_AUTH_REQUIRED,
	REQUEST_TIMEOUT,
	CONFLICT,
	GONE,
	LENGTH_REQUIRED,
	PRECONDITION_FAILED,
	ENTITY_TOO_LARGE,
	URI_TOO_LONG,
	UNSUPPORTED_MEDIA_TYPE,
	RANGE_NOT_SATISFIABLE,
	EXPECTATION_FAILED,
	INTERNAL_SERVER_ERROR,
	NOT_IMPLEMENTED,
	BAD_GATEWAY,
	SERVICE_UNAVAILABLE,
	GATEWAY_TIMEOUT,
	HTTP_VERSION_NOT_SUPPORTED,
	UNKNOWN_STATUS_CODE
} ResponseStatus;

typedef enum
{
	GET,
	POST,
	DELETE,
	PUT,
	PATCH,
	HEAD,
} RequestMethod;

struct CPPRESTSHARED_EXPORT ByteRange
{
	quint64 start = 0;
	quint64 end = 0;
	quint64 length = 0;
};

struct CPPRESTSHARED_EXPORT BasicResponseData
{
	ResponseStatus status = OK;
	qint64 length;
	ContentType content_type;
	QString filename;
	QString boundary;
	QList<ByteRange> byte_ranges;
	qint64 file_size;
	bool is_stream = false;
	bool is_downloadable = false;
};

#endif // HTTPPARTS_H
