#include "TestFramework.h"
#include "BasicStatistics.h"

TEST_CLASS(BasicStatistics_Test)
{
Q_OBJECT
private slots:

	void median()
	{
		QVector<double> data;
		data << 0.5 << 1.0 << 1.5;
		F_EQUAL(BasicStatistics::median(data), 1.0);

		data.clear();
		data << 0.5 << 0.8 << 1.0 << 1.5;
		F_EQUAL(BasicStatistics::median(data), 0.9);
	}

	void q1()
	{
		QVector<double> data;
		data << 0.1 << 0.2 << 0.3;
		F_EQUAL(BasicStatistics::q1(data), 0.1);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4;
		F_EQUAL(BasicStatistics::q1(data), 0.2);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4 << 0.5;
		F_EQUAL(BasicStatistics::q1(data), 0.2);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4 << 0.5 << 0.6;
		F_EQUAL(BasicStatistics::q1(data), 0.2);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4 << 0.5 << 0.6 << 0.7;
		F_EQUAL(BasicStatistics::q1(data), 0.2);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4 << 0.5 << 0.6 << 0.7 << 0.8;
		F_EQUAL(BasicStatistics::q1(data), 0.3);
	}

	void q3()
	{
		QVector<double> data;
		data << 0.1 << 0.2 << 0.3;
		F_EQUAL(BasicStatistics::q3(data), 0.3);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4;
		F_EQUAL(BasicStatistics::q3(data), 0.4);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4 << 0.5;
		F_EQUAL(BasicStatistics::q3(data), 0.4);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4 << 0.5 << 0.6;
		F_EQUAL(BasicStatistics::q3(data), 0.5);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4 << 0.5 << 0.6 << 0.7;
		F_EQUAL(BasicStatistics::q3(data), 0.6);

		data.clear();
		data << 0.1 << 0.2 << 0.3 << 0.4 << 0.5 << 0.6 << 0.7 << 0.8;
		F_EQUAL(BasicStatistics::q3(data), 0.7);
	}

	void isSorted()
	{
		QVector<double> data;
		data << 0.5 << 1.0;
		IS_TRUE(BasicStatistics::isSorted(data));

		data << 1.5;
		IS_TRUE(BasicStatistics::isSorted(data));

		data << 1.5;
		IS_TRUE(BasicStatistics::isSorted(data));

		data << 1.4;
		IS_TRUE(!BasicStatistics::isSorted(data));
	}

	void getMinMax()
	{
		QVector<double> data;
		data << 0.5 << 1.0 << 1.5;

		QPair<double, double> output = BasicStatistics::getMinMax(data);
		F_EQUAL(output.first, 0.5);
		F_EQUAL(output.second, 1.5);

		data << 0.1;
		output = BasicStatistics::getMinMax(data);
		F_EQUAL(output.first, 0.1);
		F_EQUAL(output.second, 1.5);

		data << 1.6;
		output = BasicStatistics::getMinMax(data);
		F_EQUAL(output.first, 0.1);
		F_EQUAL(output.second, 1.6);
	}

	void range()
	{
		QVector<double> range = BasicStatistics::range(-1, 5.0, 1.0);
		I_EQUAL(range.count(), 0);

		range = BasicStatistics::range(0, 5.0, 1.0);
		I_EQUAL(range.count(), 0);

		range = BasicStatistics::range(1, 5.0, 1.0);
		I_EQUAL(range.count(), 1);
		F_EQUAL(range[0], 5.0);

		range = BasicStatistics::range(3, 5.0, 1.0);
		I_EQUAL(range.count(), 3);
		F_EQUAL(range[0], 5.0);
		F_EQUAL(range[1], 6.0);
		F_EQUAL(range[2], 7.0);

		range = BasicStatistics::range(3, 5.0, -1.0);
		I_EQUAL(range.count(), 3);
		F_EQUAL(range[0], 5.0);
		F_EQUAL(range[1], 4.0);
		F_EQUAL(range[2], 3.0);
	}

	void isValidFloat()
	{
		IS_FALSE(BasicStatistics::isValidFloat("bla"))
		IS_FALSE(BasicStatistics::isValidFloat("nan"))
		IS_FALSE(BasicStatistics::isValidFloat("inf"))
		IS_TRUE(BasicStatistics::isValidFloat("1"))
		IS_TRUE(BasicStatistics::isValidFloat("1.1"))
		IS_TRUE(BasicStatistics::isValidFloat("1e-4"))
	}

	void factorial()
	{
		BasicStatistics::precalculateFactorials();
		F_EQUAL(BasicStatistics::factorial(0), 1.0);
		F_EQUAL(BasicStatistics::factorial(1), 1.0);
		F_EQUAL(BasicStatistics::factorial(2), 2.0);
		F_EQUAL(BasicStatistics::factorial(3), 6.0);
		F_EQUAL(BasicStatistics::factorial(4), 24.0);
	}

	void matchProbability()
	{
		BasicStatistics::precalculateFactorials();
		F_EQUAL(BasicStatistics::matchProbability(0.1, 1, 1), 0.100);
		F_EQUAL(BasicStatistics::matchProbability(0.1, 1, 2), 0.190);
		F_EQUAL(BasicStatistics::matchProbability(0.1, 1, 3), 0.271);
		F_EQUAL(BasicStatistics::matchProbability(0.1, 1, 5), 0.40951);
		F_EQUAL(BasicStatistics::matchProbability(0.1, 5, 5), 0.00001);
	}

	void rangeOverlaps()
	{
		//no overlap
		IS_FALSE(BasicStatistics::rangeOverlaps(1, 4, 5, 9));
		IS_FALSE(BasicStatistics::rangeOverlaps(5, 9, 1, 4));

		//partial overlap
		IS_TRUE(BasicStatistics::rangeOverlaps(1, 4, 4, 9));
		IS_TRUE(BasicStatistics::rangeOverlaps(4, 9, 1, 4));

		//full overlap
		IS_TRUE(BasicStatistics::rangeOverlaps(1, 10, 4, 4));
		IS_TRUE(BasicStatistics::rangeOverlaps(4, 4, 1, 10));
	}

	void fishersExactTest_twosided()
	{
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 2, 3, 0, "two-sided"), 0.4, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 7, 8, 2, "two-sided"), 0.023014, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 9, 11, 3, "two-sided"), 0.00276, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 0, 19, 25, "two-sided"), 0.00021, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 21, 15, 8, "two-sided"), 0.11752, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 21, 6, 12, "two-sided"), 0.26430, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 12, 25, 24, "two-sided"), 0.49074, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 1, 17, 24, "two-sided"), 0.30870, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 2, 25, 10, "two-sided"), 0.30439, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 8, 5, 22, "two-sided"), 0.00002, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 7, 23, 21, "two-sided"), 0.29288, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 23, 17, 12, "two-sided"), 0.08461, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 4, 12, 14, "two-sided"), 0.36787, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 25, 5, 7, "two-sided"), 0.46702, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 8, 12, 12, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 8, 7, 14, "two-sided"), 0.32426, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 2, 21, 25, "two-sided"), 0.00384, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 4, 17, 11, "two-sided"), 0.33644, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 17, 4, 9, "two-sided"), 0.19935, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 14, 5, 10, "two-sided"), 0.12254, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 6, 6, 22, "two-sided"), 0.00021, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 15, 25, 17, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 23, 5, 19, "two-sided"), 0.45612, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 7, 3, 18, "two-sided"), 0.00011, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 4, 15, 21, "two-sided"), 0.70952, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 22, 17, 9, "two-sided"), 0.32212, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 19, 17, 4, "two-sided"), 0.02891, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 3, 3, 25, "two-sided"), 0.05306, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 20, 5, 0, "two-sided"), 0.01707, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 8, 20, 15, "two-sided"), 0.12876, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 11, 12, 12, "two-sided"), 0.57960, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 13, 20, 21, "two-sided"), 0.17303, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 19, 16, 11, "two-sided"), 0.18752, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 15, 22, 0, "two-sided"), 0.00003, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 10, 10, 0, "two-sided"), 0.00305, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 7, 14, 21, "two-sided"), 0.75023, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 24, 25, 16, "two-sided"), 0.00172, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 8, 7, 9, "two-sided"), 0.18219, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 13, 24, 16, "two-sided"), 0.01953, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 21, 7, 21, "two-sided"), 0.57381, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 0, 15, 18, "two-sided"), 0.00559, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 22, 12, 8, "two-sided"), 0.42253, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 15, 20, 14, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 13, 14, 19, "two-sided"), 0.44634, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 11, 15, 2, "two-sided"), 0.10513, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 9, 5, 25, "two-sided"), 0.01166, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 17, 1, 10, "two-sided"), 0.39286, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 25, 25, 1, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 11, 14, 9, "two-sided"), 0.77785, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 24, 4, 13, "two-sided"), 0.53249, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 8, 12, 4, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 3, 14, 16, "two-sided"), 0.00083, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 12, 16, 10, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 9, 0, 7, "two-sided"), 0.12065, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 21, 1, 9, "two-sided"), 0.53427, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 1, 4, 25, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 3, 11, 25, "two-sided"), 0.00752, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 7, 24, 11, "two-sided"), 0.16754, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 24, 10, 10, "two-sided"), 0.02599, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 9, 6, 23, "two-sided"), 0.01737, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 5, 18, 2, "two-sided"), 0.06650, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 7, 9, 3, "two-sided"), 0.01977, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 17, 13, 15, "two-sided"), 0.39985, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 5, 4, 1, "two-sided"), 0.60003, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 22, 25, 8, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 15, 24, 22, "two-sided"), 0.51096, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 12, 3, 8, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 19, 22, 21, "two-sided"), 0.22719, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 13, 23, 8, "two-sided"), 0.18393, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 1, 23, 18, "two-sided"), 0.12844, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 13, 18, 3, "two-sided"), 0.07748, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 18, 20, 13, "two-sided"), 0.12608, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 4, 14, 19, "two-sided"), 0.03551, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 22, 3, 5, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 0, 4, 20, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 0, 13, 9, "two-sided"), 0.13579, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 2, 24, 25, "two-sided"), 0.09077, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 8, 20, 15, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 21, 11, 7, "two-sided"), 0.41219, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 6, 23, 13, "two-sided"), 0.77521, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 9, 10, 11, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 15, 9, 12, "two-sided"), 0.17959, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 6, 19, 10, "two-sided"), 0.05538, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 3, 5, 1, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 4, 14, 23, "two-sided"), 0.00901, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 19, 7, 11, "two-sided"), 0.30236, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 5, 12, 15, "two-sided"), 0.12441, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 21, 8, 15, "two-sided"), 0.59395, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 16, 24, 12, "two-sided"), 0.03919, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 4, 20, 8, "two-sided"), 0.69387, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 21, 0, 15, "two-sided"), 0.01953, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 20, 7, 2, "two-sided"), 0.02107, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 1, 8, 24, "two-sided"), 0.03021, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 3, 10, 0, "two-sided"), 0.54482, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 9, 24, 5, "two-sided"), 0.01929, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 7, 25, 16, "two-sided"), 0.42944, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 0, 12, 25, "two-sided"), 0.00305, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 23, 0, 0, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 23, 21, 18, "two-sided"), 0.37109, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 0, 0, 0, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 13, 9, 10, "two-sided"), 0.39688, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 17, 8, 6, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 8, 15, 15, "two-sided"), 0.04039, 0.00001);

		//up to 30:
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 30, 15, 26, "two-sided"), 0.30506, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 26, 12, 9, "two-sided"), 0.02478, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 13, 11, 19, "two-sided"), 0.04709, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 27, 2, 26, "two-sided"), 0.09460, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 20, 20, 10, "two-sided"), 0.02143, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 13, 26, 13, "two-sided"), 0.81330, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 2, 19, 30, "two-sided"), 0.06394, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 12, 25, 12, "two-sided"), 0.80064, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 2, 3, 10, "two-sided"), 0.00004, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 29, 4, 8, "two-sided"), 0.71476, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 5, 30, 24, "two-sided"), 0.00528, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 28, 21, 7, "two-sided"), 0.01947, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 19, 15, 10, "two-sided"), 0.45360, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 13, 17, 11, "two-sided"), 0.58430, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 24, 2, 18, "two-sided"), 0.01892, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 11, 14, 20, "two-sided"), 0.76724, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 19, 12, 25, "two-sided"), 0.57398, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 17, 17, 25, "two-sided"), 0.05394, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 14, 22, 13, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 29, 27, 23, "two-sided"), 0.05884, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 30, 18, 1, "two-sided"), 0.00002, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 10, 11, 5, "two-sided"), 0.30636, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 5, 2, 0, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 10, 30, 6, "two-sided"), 0.00238, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 14, 0, 18, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 5, 21, 14, "two-sided"), 0.16060, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 20, 0, 4, "two-sided"), 0.55687, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(30, 14, 4, 8, "two-sided"), 0.04484, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(30, 11, 26, 26, "two-sided"), 0.03272, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 28, 8, 20, "two-sided"), 0.10043, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 14, 4, 7, "two-sided"), 0.29888, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 26, 27, 22, "two-sided"), 0.84370, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 16, 19, 28, "two-sided"), 0.03794, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 7, 16, 27, "two-sided"), 0.00171, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 0, 10, 21, "two-sided"), 0.00016, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 14, 0, 0, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 24, 3, 30, "two-sided"), 0.00010, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 15, 27, 24, "two-sided"), 0.81664, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 15, 2, 11, "two-sided"), 0.08355, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 25, 19, 12, "two-sided"), 0.05340, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 26, 15, 2, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 10, 10, 7, "two-sided"), 0.07112, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 20, 16, 17, "two-sided"), 0.32217, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 24, 6, 16, "two-sided"), 0.28137, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 1, 1, 27, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 30, 21, 3, "two-sided"), 0.00003, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 0, 29, 22, "two-sided"), 0.00003, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 24, 7, 27, "two-sided"), 0.05117, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 26, 9, 14, "two-sided"), 0.79017, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 16, 27, 9, "two-sided"), 0.08497, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 19, 13, 25, "two-sided"), 0.02144, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 0, 19, 22, "two-sided"), 0.00296, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 22, 25, 24, "two-sided"), 0.00101, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 16, 23, 16, "two-sided"), 0.33971, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 21, 19, 27, "two-sided"), 0.63819, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 1, 23, 7, "two-sided"), 0.40235, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 27, 29, 19, "two-sided"), 0.05975, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 24, 14, 10, "two-sided"), 0.00126, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 15, 14, 17, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 13, 4, 18, "two-sided"), 0.00042, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 20, 16, 13, "two-sided"), 0.01186, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 16, 28, 30, "two-sided"), 0.12878, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 8, 15, 19, "two-sided"), 0.06925, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 12, 8, 29, "two-sided"), 0.00058, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 10, 7, 14, "two-sided"), 0.00525, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 20, 2, 0, "two-sided"), 0.50680, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 11, 19, 29, "two-sided"), 0.44571, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 2, 5, 28, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 23, 13, 10, "two-sided"), 0.61402, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 13, 7, 19, "two-sided"), 0.00466, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 19, 22, 27, "two-sided"), 0.22698, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 7, 28, 13, "two-sided"), 0.30728, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 19, 20, 13, "two-sided"), 0.07874, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 27, 28, 28, "two-sided"), 0.69614, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 6, 7, 13, "two-sided"), 0.00245, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 30, 12, 29, "two-sided"), 0.06485, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 5, 28, 4, "two-sided"), 0.73228, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 14, 22, 13, "two-sided"), 0.80469, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 15, 0, 28, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 3, 1, 5, "two-sided"), 0.00305, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 1, 12, 23, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 7, 0, 12, "two-sided"), 0.17143, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 27, 3, 28, "two-sided"), 0.00401, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 27, 11, 3, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(30, 0, 26, 9, "two-sided"), 0.00266, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 6, 26, 6, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 23, 13, 25, "two-sided"), 0.05513, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 21, 3, 13, "two-sided"), 0.01072, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 4, 21, 0, "two-sided"), 0.00085, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 2, 30, 1, "two-sided"), 0.18362, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 10, 10, 10, "two-sided"), 0.74329, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 24, 26, 16, "two-sided"), 0.01389, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 24, 28, 18, "two-sided"), 0.13957, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 27, 13, 5, "two-sided"), 0.00023, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 20, 21, 15, "two-sided"), 0.23162, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 12, 6, 27, "two-sided"), 0.00002, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 5, 8, 28, "two-sided"), 0.11733, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 9, 21, 21, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 25, 14, 7, "two-sided"), 0.00007, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 7, 4, 30, "two-sided"), 0.03878, 0.00001);

		//up to 40:
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 5, 17, 10, "two-sided"), 0.19935, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 10, 7, 14, "two-sided"), 0.34989, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 5, 38, 9, "two-sided"), 0.29574, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 20, 29, 33, "two-sided"), 0.26467, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 8, 25, 22, "two-sided"), 0.31595, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 2, 20, 32, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 22, 25, 7, "two-sided"), 0.15699, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(38, 0, 26, 28, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 9, 3, 1, "two-sided"), 0.11813, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(38, 25, 9, 15, "two-sided"), 0.09096, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 39, 16, 18, "two-sided"), 0.00022, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 38, 21, 17, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 9, 7, 15, "two-sided"), 0.04541, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(31, 10, 6, 7, "two-sided"), 0.08359, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 22, 23, 29, "two-sided"), 0.32205, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 33, 2, 33, "two-sided"), 0.00005, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 38, 12, 25, "two-sided"), 0.46886, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 6, 27, 18, "two-sided"), 0.00795, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(33, 21, 18, 10, "two-sided"), 0.81482, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(37, 19, 29, 28, "two-sided"), 0.12758, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 12, 31, 22, "two-sided"), 0.82231, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 8, 11, 37, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 11, 19, 16, "two-sided"), 0.61495, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 7, 20, 8, "two-sided"), 0.55662, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 39, 40, 15, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 19, 2, 19, "two-sided"), 0.01383, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(36, 21, 0, 28, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 39, 17, 7, "two-sided"), 0.00050, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(34, 20, 3, 7, "two-sided"), 0.08099, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 10, 35, 26, "two-sided"), 0.13591, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 35, 24, 14, "two-sided"), 0.01008, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 35, 37, 38, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 40, 27, 22, "two-sided"), 0.03219, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 27, 18, 17, "two-sided"), 0.05926, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 24, 23, 16, "two-sided"), 0.02120, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 3, 31, 33, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 35, 9, 19, "two-sided"), 0.07740, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 21, 0, 24, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 25, 14, 0, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 34, 28, 6, "two-sided"), 0.00006, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 5, 35, 38, "two-sided"), 0.00558, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 9, 1, 7, "two-sided"), 0.47059, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 34, 19, 17, "two-sided"), 0.00039, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(38, 23, 37, 40, "two-sided"), 0.12168, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 34, 35, 12, "two-sided"), 0.00161, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 8, 3, 38, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(32, 12, 34, 40, "two-sided"), 0.00696, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 7, 22, 4, "two-sided"), 0.16011, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 6, 23, 31, "two-sided"), 0.22858, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 19, 5, 35, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 40, 18, 22, "two-sided"), 0.29451, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(40, 14, 11, 0, "two-sided"), 0.10240, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(38, 38, 6, 9, "two-sided"), 0.57697, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 30, 1, 29, "two-sided"), 0.00071, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 25, 0, 4, "two-sided"), 0.11510, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 8, 28, 3, "two-sided"), 0.34004, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 13, 33, 7, "two-sided"), 0.31825, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 0, 25, 12, "two-sided"), 0.01067, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 12, 24, 22, "two-sided"), 0.36168, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 5, 36, 24, "two-sided"), 0.00335, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 1, 27, 18, "two-sided"), 0.00005, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 25, 11, 15, "two-sided"), 0.63015, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 36, 36, 6, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 33, 0, 7, "two-sided"), 0.08380, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 17, 20, 4, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 11, 32, 9, "two-sided"), 0.00880, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 39, 35, 11, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 40, 8, 5, "two-sided"), 0.00167, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 20, 3, 16, "two-sided"), 0.06919, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 3, 39, 4, "two-sided"), 0.41088, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 38, 30, 38, "two-sided"), 0.47912, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 12, 37, 23, "two-sided"), 0.12009, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 7, 19, 33, "two-sided"), 0.54053, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 24, 25, 27, "two-sided"), 0.00794, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(31, 7, 31, 19, "two-sided"), 0.06007, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 17, 20, 19, "two-sided"), 0.11727, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 37, 18, 9, "two-sided"), 0.00960, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(33, 13, 2, 25, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 2, 18, 20, "two-sided"), 0.00157, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 2, 9, 2, "two-sided"), 0.57993, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 2, 17, 37, "two-sided"), 0.00470, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 8, 10, 39, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 20, 37, 34, "two-sided"), 0.00908, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(30, 30, 15, 16, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 4, 33, 17, "two-sided"), 0.04029, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 18, 31, 0, "two-sided"), 0.00002, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(33, 6, 26, 8, "two-sided"), 0.55241, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 7, 29, 8, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 40, 21, 2, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 25, 30, 5, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 38, 2, 20, "two-sided"), 0.00757, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(32, 15, 34, 7, "two-sided"), 0.14088, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(40, 38, 20, 16, "two-sided"), 0.69182, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 7, 16, 17, "two-sided"), 0.26336, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 16, 26, 34, "two-sided"), 0.07343, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 34, 31, 10, "two-sided"), 0.00002, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 2, 11, 9, "two-sided"), 0.00357, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 29, 39, 29, "two-sided"), 0.47449, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 25, 31, 4, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 7, 34, 9, "two-sided"), 1.00000, 0.00001);

		//up to 50:
		F_EQUAL2(BasicStatistics::fishersExactTest(48, 39, 18, 21, "two-sided"), 0.44067, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 24, 42, 31, "two-sided"), 0.58305, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(41, 30, 11, 50, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(47, 43, 1, 38, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(38, 37, 2, 27, "two-sided"), 0.00003, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 8, 19, 30, "two-sided"), 0.00161, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 4, 38, 14, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(48, 2, 13, 30, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 13, 27, 42, "two-sided"), 0.00379, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(49, 23, 21, 8, "two-sided"), 0.81254, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 38, 10, 35, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 9, 25, 21, "two-sided"), 0.04239, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(49, 32, 44, 11, "two-sided"), 0.02358, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(31, 23, 42, 43, "two-sided"), 0.38755, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 38, 24, 19, "two-sided"), 0.11124, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 30, 31, 12, "two-sided"), 0.00007, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(41, 8, 41, 31, "two-sided"), 0.00273, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 5, 43, 33, "two-sided"), 0.20066, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 47, 19, 14, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 47, 34, 2, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(43, 33, 12, 50, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 9, 10, 0, "two-sided"), 0.08303, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 35, 46, 17, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(43, 18, 18, 17, "two-sided"), 0.07910, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(32, 13, 41, 42, "two-sided"), 0.02451, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 38, 19, 1, "two-sided"), 0.00002, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(42, 1, 42, 3, "two-sided"), 0.61663, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(42, 37, 25, 46, "two-sided"), 0.03291, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 41, 35, 23, "two-sided"), 0.00139, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(31, 46, 32, 16, "two-sided"), 0.00566, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(42, 8, 15, 29, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 31, 29, 11, "two-sided"), 0.10356, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 7, 39, 11, "two-sided"), 0.05072, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 7, 34, 50, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 16, 49, 22, "two-sided"), 0.00339, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(44, 19, 24, 40, "two-sided"), 0.00035, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 35, 12, 3, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(48, 11, 45, 12, "two-sided"), 0.81795, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(30, 23, 3, 33, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 5, 45, 11, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 24, 1, 1, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(36, 50, 30, 22, "two-sided"), 0.08076, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 47, 43, 3, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 7, 15, 2, "two-sided"), 0.00054, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 2, 30, 26, "two-sided"), 0.00011, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(50, 35, 47, 2, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(43, 13, 35, 12, "two-sided"), 0.82067, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 32, 17, 39, "two-sided"), 0.00197, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 48, 32, 42, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 16, 24, 35, "two-sided"), 0.38365, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 10, 23, 29, "two-sided"), 0.02667, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(40, 14, 11, 41, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 21, 39, 28, "two-sided"), 0.46915, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 44, 19, 11, "two-sided"), 0.03007, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 6, 19, 15, "two-sided"), 0.76348, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 30, 9, 30, "two-sided"), 0.00228, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 39, 12, 34, "two-sided"), 0.07748, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(50, 10, 37, 50, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(44, 36, 29, 9, "two-sided"), 0.02776, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 21, 50, 38, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 31, 4, 36, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(30, 37, 12, 44, "two-sided"), 0.00771, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(34, 45, 32, 42, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(36, 12, 31, 25, "two-sided"), 0.04221, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 22, 45, 4, "two-sided"), 0.00026, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(42, 22, 43, 25, "two-sided"), 0.85626, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 2, 31, 14, "two-sided"), 0.31016, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 37, 17, 20, "two-sided"), 0.67541, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 6, 36, 22, "two-sided"), 0.14929, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 43, 34, 34, "two-sided"), 0.23505, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 7, 28, 15, "two-sided"), 0.21393, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 0, 11, 19, "two-sided"), 0.00025, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 8, 30, 49, "two-sided"), 0.08350, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 6, 44, 2, "two-sided"), 0.06618, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 32, 26, 26, "two-sided"), 0.71483, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 31, 19, 41, "two-sided"), 0.83364, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 19, 21, 22, "two-sided"), 0.33190, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 47, 8, 7, "two-sided"), 0.25558, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(27, 16, 10, 32, "two-sided"), 0.00042, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(32, 27, 31, 37, "two-sided"), 0.37591, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 15, 18, 10, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 19, 9, 12, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(30, 18, 21, 7, "two-sided"), 0.31769, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 39, 28, 39, "two-sided"), 0.07962, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 20, 27, 5, "two-sided"), 0.00714, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 26, 33, 14, "two-sided"), 0.03867, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(44, 42, 46, 15, "two-sided"), 0.00349, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(30, 36, 13, 17, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 38, 8, 41, "two-sided"), 0.02990, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(48, 44, 46, 16, "two-sided"), 0.00708, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 42, 27, 35, "two-sided"), 0.36128, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 18, 39, 7, "two-sided"), 0.00045, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(36, 2, 41, 21, "two-sided"), 0.00110, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(42, 26, 43, 23, "two-sided"), 0.72228, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 6, 23, 44, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(47, 43, 4, 26, "two-sided"), 0.00021, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 42, 5, 49, "two-sided"), 0.00055, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 1, 30, 31, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 34, 23, 34, "two-sided"), 1.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 40, 4, 32, "two-sided"), 1.00000, 0.00001);

		//up to 500
		F_EQUAL2(BasicStatistics::fishersExactTest(75, 96, 382, 176, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(247, 32, 64, 296, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(312, 162, 274, 469, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(265, 386, 228, 40, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(148, 42, 347, 207, "two-sided"), 0.00012, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(74, 325, 137, 165, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(297, 94, 142, 363, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(412, 417, 453, 352, "two-sided"), 0.00860, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(363, 123, 415, 448, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(449, 248, 414, 321, "two-sided"), 0.00206, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(470, 350, 323, 159, "two-sided"), 0.00052, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(218, 405, 360, 340, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(433, 368, 170, 295, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(326, 339, 85, 436, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(451, 346, 294, 441, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(500, 439, 118, 176, "two-sided"), 0.00010, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(326, 184, 234, 28, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(248, 247, 394, 191, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(259, 10, 120, 199, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(380, 187, 54, 113, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(353, 252, 422, 93, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(104, 306, 69, 275, "two-sided"), 0.09840, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(193, 198, 300, 482, "two-sided"), 0.00035, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(439, 474, 368, 277, "two-sided"), 0.00056, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(189, 470, 21, 40, "two-sided"), 0.37728, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 239, 372, 382, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(28, 360, 326, 78, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(198, 125, 14, 158, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(76, 378, 124, 483, "two-sided"), 0.13253, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(107, 313, 404, 358, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(191, 383, 214, 356, "two-sided"), 0.13807, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(368, 442, 180, 352, "two-sided"), 0.00003, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(315, 188, 325, 410, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(217, 286, 125, 263, "two-sided"), 0.00108, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(410, 229, 438, 428, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(242, 79, 196, 299, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(471, 42, 223, 163, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(233, 303, 213, 236, "two-sided"), 0.22242, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(337, 412, 333, 77, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(476, 446, 64, 102, "two-sided"), 0.00233, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(361, 386, 128, 378, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(166, 158, 168, 317, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(379, 70, 78, 448, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(181, 106, 3, 458, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(473, 282, 272, 63, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(239, 17, 139, 459, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(444, 186, 476, 493, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(357, 16, 366, 115, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(122, 360, 397, 192, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(263, 415, 189, 218, "two-sided"), 0.01561, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(201, 318, 135, 233, "two-sided"), 0.57424, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(464, 464, 375, 51, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(205, 71, 170, 196, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(493, 284, 294, 15, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(477, 237, 344, 229, "two-sided"), 0.01220, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(175, 384, 211, 181, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(174, 1, 123, 490, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(452, 500, 57, 456, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(419, 150, 274, 135, "two-sided"), 0.02699, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(321, 3, 20, 360, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(299, 382, 8, 219, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 405, 435, 489, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(290, 376, 142, 432, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(365, 71, 250, 77, "two-sided"), 0.01266, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(148, 294, 171, 12, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(234, 251, 466, 131, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(169, 6, 421, 136, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(238, 94, 234, 288, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(188, 441, 267, 217, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(41, 406, 140, 102, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(484, 375, 126, 421, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(57, 280, 376, 163, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(58, 197, 124, 349, "two-sided"), 0.32442, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(420, 320, 180, 432, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(194, 249, 438, 91, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(76, 407, 447, 174, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(299, 75, 129, 282, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(150, 66, 358, 480, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(421, 321, 475, 87, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(241, 468, 5, 157, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(345, 56, 418, 313, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(347, 231, 362, 217, "two-sided"), 0.39847, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(79, 100, 179, 415, "two-sided"), 0.00079, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(416, 310, 449, 174, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(59, 134, 403, 344, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 374, 64, 466, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(426, 67, 140, 319, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(463, 387, 267, 497, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(75, 295, 399, 296, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(283, 199, 253, 99, "two-sided"), 0.00010, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(35, 320, 452, 147, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(194, 75, 496, 377, "two-sided"), 0.00001, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(82, 324, 202, 24, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(456, 240, 479, 260, "two-sided"), 0.78201, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(428, 365, 442, 297, "two-sided"), 0.02315, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(224, 325, 458, 287, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(428, 34, 494, 475, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(406, 66, 182, 59, "two-sided"), 0.00081, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(123, 87, 196, 490, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(361, 75, 377, 106, "two-sided"), 0.08102, 0.00001);

		//up to 5000
		F_EQUAL2(BasicStatistics::fishersExactTest(347, 3862, 1716, 4507, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2114, 4370, 3419, 3310, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4126, 14, 2753, 2288, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(597, 714, 790, 381, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(57, 244, 2139, 1300, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4250, 353, 1653, 4938, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4098, 470, 1928, 992, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(636, 2945, 4779, 4323, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(529, 599, 1405, 1100, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2800, 2460, 3497, 4180, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(176, 2244, 2914, 284, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4105, 2165, 3857, 3355, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3327, 3015, 1490, 3451, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1225, 4358, 400, 3459, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2502, 4166, 678, 4800, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2320, 4414, 970, 4600, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3950, 549, 34, 3269, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3835, 918, 4312, 566, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2587, 2875, 2266, 4508, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2116, 2501, 3516, 2332, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1423, 4158, 4116, 1763, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4855, 3832, 2673, 1402, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(966, 4110, 1231, 1547, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3878, 834, 1350, 302, "two-sided"), 0.60127, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2301, 2526, 2333, 372, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(608, 3034, 116, 1744, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2704, 3049, 781, 3461, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4200, 364, 2209, 211, "two-sided"), 0.29279, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4093, 4200, 4750, 3885, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3197, 4818, 4382, 4807, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2021, 2743, 4717, 3439, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1840, 3773, 4888, 4412, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(986, 3746, 3695, 241, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(587, 2654, 184, 2720, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3919, 3234, 1108, 2012, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3507, 4430, 4282, 2023, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1131, 308, 564, 4927, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4458, 1616, 1980, 2154, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4138, 4229, 2954, 1382, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1046, 3611, 1261, 2841, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2277, 331, 1019, 1695, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3524, 2335, 4313, 4584, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(892, 3427, 1321, 3489, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1027, 1619, 3939, 3225, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2367, 1515, 4644, 4841, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(774, 3739, 2194, 681, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2489, 1832, 686, 4203, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4838, 3971, 1330, 4535, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3866, 3904, 4922, 888, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3203, 3416, 689, 2018, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3760, 2798, 2588, 952, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3806, 3531, 48, 3285, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2046, 1670, 773, 3761, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4114, 4782, 173, 2599, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3833, 597, 3163, 3669, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1980, 2278, 2374, 4669, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(743, 1948, 3698, 2889, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1575, 1607, 2726, 748, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1252, 4067, 243, 801, "two-sided"), 0.87319, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3737, 1942, 3145, 2265, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2438, 1295, 622, 2125, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(975, 3314, 3640, 3459, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(217, 1255, 1044, 573, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3897, 4181, 3648, 2071, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2281, 2170, 4578, 2780, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1043, 3938, 763, 1407, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(652, 3827, 4048, 4536, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(40, 383, 1331, 4397, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4756, 3818, 4423, 4323, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1361, 3217, 2073, 696, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3658, 1755, 3755, 3297, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3588, 4226, 1010, 2903, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1919, 3524, 1305, 4148, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3901, 1394, 3701, 436, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2649, 2983, 4489, 4245, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1068, 937, 2899, 203, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3162, 1226, 4777, 3283, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(224, 294, 4298, 3105, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3315, 4637, 4145, 836, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1600, 2630, 2612, 2989, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3347, 3654, 3, 3766, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3446, 296, 4813, 4630, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4366, 3247, 3650, 1073, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(915, 1382, 2417, 2089, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3415, 2060, 687, 2677, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1541, 57, 887, 1398, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1457, 3640, 3453, 4554, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4343, 3676, 3093, 3568, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2848, 2798, 3176, 2509, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(1213, 4769, 145, 3245, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(370, 4099, 1849, 4890, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3970, 2575, 381, 262, "two-sided"), 0.49886, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3517, 4216, 1831, 1413, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3425, 3175, 4628, 2314, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(153, 3486, 2474, 1759, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4747, 384, 1726, 3831, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3019, 1472, 4460, 1764, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3821, 2294, 276, 1222, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2354, 4099, 4546, 2867, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(662, 2519, 4575, 1179, "two-sided"), 0.00000, 0.00001);

		//up to 25000
		F_EQUAL2(BasicStatistics::fishersExactTest(16324, 19998, 1701, 6661, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5277, 20165, 15056, 16452, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7724, 22225, 2987, 4434, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16621, 7885, 8986, 9708, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23541, 13479, 20091, 18140, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21834, 22642, 10960, 5072, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9203, 2823, 19448, 2245, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18597, 24193, 20560, 7284, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5013, 23656, 455, 16489, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23799, 3780, 4197, 7106, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21810, 22604, 20144, 10547, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21148, 22696, 11898, 23943, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6140, 4287, 16059, 16328, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17977, 11853, 14023, 11467, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23342, 19268, 6340, 11690, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3559, 17137, 22446, 15849, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(10162, 20999, 11246, 5394, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9865, 13150, 12632, 10261, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5685, 14905, 2535, 16486, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3763, 14416, 15240, 2588, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16500, 9390, 17983, 1780, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(14387, 22865, 4213, 13807, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2924, 6612, 23929, 15168, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11261, 12928, 5461, 6498, "two-sided"), 0.11143, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12369, 22767, 11478, 24345, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(376, 19084, 6444, 5851, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4613, 4175, 14430, 8912, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8786, 20896, 23435, 10641, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9298, 989, 23297, 7583, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19694, 17033, 5172, 2276, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3544, 6908, 2231, 18626, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8416, 24237, 19203, 22429, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13041, 17785, 228, 16449, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19680, 749, 9096, 393, "two-sided"), 0.04796, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(105, 11182, 13628, 4157, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21797, 24733, 4712, 13537, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21913, 4332, 17603, 23409, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19022, 19500, 24454, 1768, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21224, 13434, 7251, 7233, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15335, 19032, 18319, 15353, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3029, 12069, 5053, 23503, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3692, 4559, 925, 13436, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20542, 14542, 7084, 7508, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5687, 1587, 23284, 12373, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11280, 9259, 8217, 1030, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4623, 19841, 6539, 17854, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19529, 2842, 9269, 1364, "two-sided"), 0.75058, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15072, 150, 9162, 469, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(23019, 13172, 10644, 799, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22769, 20121, 1321, 6239, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13776, 15339, 8822, 15172, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24562, 11546, 7807, 5299, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6194, 8164, 18315, 11737, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18924, 7235, 9845, 8779, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19454, 3632, 13927, 7128, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(2097, 4267, 18237, 15211, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8428, 20162, 8470, 12924, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8271, 15884, 9056, 20132, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16717, 6152, 19784, 17782, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11601, 16472, 21013, 4239, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21733, 7351, 16762, 3690, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15951, 16394, 24094, 5675, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16847, 14412, 24782, 17855, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15670, 15986, 8488, 11305, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22246, 12726, 7787, 10214, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24692, 13672, 5393, 19059, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7758, 3613, 2806, 6756, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7472, 6848, 9719, 20648, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16944, 14171, 18087, 10636, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9734, 19078, 12937, 281, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12883, 6321, 23726, 12464, "two-sided"), 0.00030, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5271, 4990, 24679, 11299, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(5914, 19901, 7697, 7009, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16943, 18550, 19031, 15574, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(4702, 15376, 14539, 14469, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3144, 22774, 2431, 3582, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(11074, 5882, 24858, 13574, "two-sided"), 0.15297, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(413, 22483, 8056, 7096, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3595, 21296, 21232, 8161, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(13998, 9006, 5987, 18114, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(588, 1130, 10797, 24475, "two-sided"), 0.00173, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(76, 10594, 18436, 15025, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(20803, 6506, 5491, 1847, "two-sided"), 0.01720, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19326, 9627, 1799, 5001, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(24561, 13874, 8384, 11106, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(601, 10182, 4031, 14328, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(19422, 2519, 8923, 16144, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17661, 4239, 14611, 13835, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(15233, 7487, 1722, 4570, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(17046, 14375, 8988, 8612, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(3956, 12409, 24451, 15838, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(21327, 7500, 16955, 22482, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(9898, 9276, 18930, 12202, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(7752, 15823, 16899, 4814, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(6787, 11596, 16915, 19444, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(18387, 5141, 113, 21326, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(12953, 6509, 17322, 14539, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(22868, 7730, 8253, 21311, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(8642, 9167, 2359, 9293, "two-sided"), 0.00000, 0.00001);
		F_EQUAL2(BasicStatistics::fishersExactTest(16644, 10197, 24920, 21279, "two-sided"), 0.00000, 0.00001);
	}

	void fishersExactTest_less()
	{
		//up to size 10:
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 10, 6, 2, "less"), 0.006271334, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 1, 6, 8, "less"), 0.999020057, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 9, 6, 3, "less"), 0.343096873, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 5, 10, 3, "less"), 0.384863124, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 9, 0, 2, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 0, 3, 8, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 5, 5, 8, "less"), 0.918821991, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 5, 6, 6, "less"), 0.464991665, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 9, 6, 3, "less"), 0.109907121, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 8, 8, 7, "less"), 0.258944676, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 6, 2, 6, "less"), 0.973684211, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 9, 8, 0, "less"), 0.006124647, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 5, 9, 6, "less"), 0.093653251, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 4, 0, 3, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 9, 8, 1, "less"), 0.057055683, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 1, 4, 8, "less"), 0.990950226, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 10, 1, 2, "less"), 0.730392157, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 10, 9, 5, "less"), 0.224562273, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 1, 7, 6, "less"), 0.850000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 8, 10, 3, "less"), 0.135317304, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 1, 2, 3, "less"), 0.997252747, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 7, 5, 7, "less"), 0.901328283, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 4, 3, 7, "less"), 0.911764706, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 10, 9, 5, "less"), 0.224562273, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 9, 5, 4, "less"), 0.375067304, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 7, 5, 4, "less"), 0.675461031, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 1, 3, 2, "less"), 0.982142857, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 0, 6, 4, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 9, 7, 4, "less"), 0.017027864, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 1, 2, 5, "less"), 0.999125874, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 6, 1, 6, "less"), 0.989783282, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 7, 2, 0, "less"), 0.300000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 2, 3, 1, "less"), 0.666666667, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 9, 10, 10, "less"), 0.233276910, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 4, 3, 7, "less"), 0.758241758, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 10, 4, 6, "less"), 0.125902993, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 4, 7, 4, "less"), 0.051282051, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 8, 4, 1, "less"), 0.327231121, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 2, 7, 5, "less"), 0.721719457, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 10, 10, 5, "less"), 0.102811739, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 5, 1, 8, "less"), 0.999453157, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 4, 7, 10, "less"), 0.972123880, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 0, 7, 1, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 3, 3, 7, "less"), 0.992668322, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 1, 10, 0, "less"), 0.230769231, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 1, 3, 1, "less"), 0.890909091, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 3, 5, 6, "less"), 0.885091688, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 5, 3, 3, "less"), 0.622377622, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 7, 3, 5, "less"), 0.284615385, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 5, 0, 8, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 0, 4, 6, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 1, 1, 8, "less"), 0.999958865, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 8, 8, 8, "less"), 0.218225872, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 2, 0, 0, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 3, 2, 8, "less"), 0.982466063, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 0, 5, 9, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 9, 2, 10, "less"), 0.739130435, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 4, 8, 1, "less"), 0.184210526, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 8, 4, 7, "less"), 0.500000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 3, 0, 0, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 5, 4, 10, "less"), 0.818369453, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 5, 1, 7, "less"), 0.979638009, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 4, 1, 5, "less"), 0.995475113, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 9, 8, 9, "less"), 0.394162511, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 10, 0, 7, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 8, 2, 3, "less"), 0.733230134, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 5, 7, 2, "less"), 0.117030029, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 5, 2, 5, "less"), 0.879370629, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 5, 2, 2, "less"), 0.720279720, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 4, 8, 4, "less"), 0.038461538, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 7, 3, 8, "less"), 0.959918899, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 4, 7, 0, "less"), 0.167251462, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 3, 6, 5, "less"), 0.338461538, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 9, 9, 0, "less"), 0.000748478, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 3, 9, 2, "less"), 0.544949330, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 3, 7, 4, "less"), 0.877574371, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 2, 8, 10, "less"), 0.868584505, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 8, 8, 4, "less"), 0.412114244, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 10, 2, 10, "less"), 0.534161491, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 10, 10, 10, "less"), 0.340831914, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 4, 10, 4, "less"), 0.137254902, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 4, 8, 3, "less"), 0.555525643, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 10, 5, 10, "less"), 0.880604859, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 9, 1, 1, "less"), 0.423076923, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 2, 1, 2, "less"), 0.989010989, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 8, 3, 5, "less"), 0.754489164, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 9, 5, 5, "less"), 0.306165029, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 8, 9, 0, "less"), 0.015560641, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 1, 8, 6, "less"), 0.992860412, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 8, 10, 1, "less"), 0.000595380, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 1, 4, 0, "less"), 0.333333333, 1e-8);

		//up to size 25:
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 6, 25, 12, "less"), 0.863019696, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 10, 6, 12, "less"), 0.998116462, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 11, 6, 10, "less"), 0.964334459, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 24, 13, 14, "less"), 0.108706848, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 16, 19, 6, "less"), 0.025634211, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 22, 10, 11, "less"), 0.032562510, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 10, 15, 15, "less"), 0.811696779, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 5, 3, 3, "less"), 0.412587413, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 18, 18, 1, "less"), 0.000012443, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 24, 14, 21, "less"), 0.001151386, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 17, 19, 3, "less"), 0.010370619, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 4, 22, 22, "less"), 0.214816423, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 10, 12, 4, "less"), 0.487833775, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 8, 5, 16, "less"), 0.999604080, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 21, 8, 2, "less"), 0.042121514, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 0, 21, 9, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 16, 13, 8, "less"), 0.095748950, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 13, 7, 8, "less"), 0.829048726, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 21, 10, 4, "less"), 0.154617895, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 19, 16, 10, "less"), 0.000008215, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 7, 18, 16, "less"), 0.990497284, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 15, 7, 15, "less"), 0.990454743, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 24, 2, 0, "less"), 0.104761905, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 24, 13, 3, "less"), 0.013322008, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 16, 6, 2, "less"), 0.334112707, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 0, 12, 21, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 4, 4, 5, "less"), 0.545454545, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 3, 21, 14, "less"), 0.993955230, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 25, 25, 1, "less"), 0.000016826, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 21, 22, 14, "less"), 0.286000064, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 0, 25, 23, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 15, 18, 5, "less"), 0.000034303, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 22, 16, 25, "less"), 0.330366550, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 22, 11, 23, "less"), 0.929437109, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 25, 7, 2, "less"), 0.003675578, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 13, 22, 2, "less"), 0.005343897, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 21, 8, 3, "less"), 0.031426776, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 20, 0, 5, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 16, 1, 15, "less"), 0.863636364, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 21, 5, 8, "less"), 0.018500949, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 24, 15, 25, "less"), 0.015187497, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 17, 10, 22, "less"), 0.993415905, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 24, 8, 7, "less"), 0.214758745, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 20, 7, 7, "less"), 0.116824778, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 6, 0, 25, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 20, 15, 14, "less"), 0.540842298, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 9, 2, 18, "less"), 0.999998898, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 20, 1, 9, "less"), 0.996937643, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 18, 1, 11, "less"), 0.632258065, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 8, 15, 22, "less"), 0.998935724, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 3, 3, 19, "less"), 0.999999997, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 24, 23, 1, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 7, 24, 23, "less"), 0.046607665, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 3, 1, 3, "less"), 0.985014985, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 17, 5, 24, "less"), 0.997347114, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 20, 13, 22, "less"), 0.186277721, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 18, 2, 20, "less"), 0.993182429, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 12, 7, 14, "less"), 0.778288408, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 1, 15, 20, "less"), 0.999999709, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 21, 15, 23, "less"), 0.424887983, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 19, 1, 5, "less"), 0.980932850, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 20, 13, 10, "less"), 0.103535736, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 10, 7, 25, "less"), 0.999968289, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 12, 6, 8, "less"), 0.177111444, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 11, 13, 10, "less"), 0.210374793, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 23, 14, 14, "less"), 0.399888570, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 19, 16, 3, "less"), 0.000292611, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 19, 4, 15, "less"), 0.948978051, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 9, 6, 23, "less"), 0.999984595, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 5, 21, 1, "less"), 0.136689758, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 1, 15, 4, "less"), 0.969155844, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 10, 22, 22, "less"), 0.671331516, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 2, 20, 18, "less"), 0.999599144, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 22, 17, 4, "less"), 0.012892137, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 24, 19, 5, "less"), 0.005251575, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 11, 21, 11, "less"), 0.530328363, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 18, 7, 1, "less"), 0.107753680, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 13, 7, 15, "less"), 0.995030783, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 13, 10, 14, "less"), 0.767897681, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 10, 10, 9, "less"), 0.842439719, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 19, 13, 9, "less"), 0.506480242, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 0, 8, 15, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 4, 4, 2, "less"), 0.917152962, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 7, 15, 19, "less"), 0.029259041, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 22, 9, 2, "less"), 0.002275289, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 11, 16, 3, "less"), 0.177900523, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 8, 17, 24, "less"), 0.659450434, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 25, 3, 24, "less"), 0.647563313, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 14, 19, 9, "less"), 0.448159004, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 14, 14, 19, "less"), 0.930446179, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 12, 3, 8, "less"), 0.991844368, 1e-8);

		//up to size 250:
		F_EQUAL2(BasicStatistics::fishersExactTest(214, 125, 16, 14, "less"), 0.894699197, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(57, 239, 183, 52, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(85, 94, 127, 109, "less"), 0.119394967, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(107, 26, 145, 66, "less"), 0.994639129, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(118, 25, 229, 188, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(244, 74, 111, 28, "less"), 0.270739765, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(150, 136, 120, 62, "less"), 0.002595527, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(173, 166, 75, 71, "less"), 0.512411926, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(34, 71, 135, 59, "less"), 0.000000001, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(119, 231, 32, 196, "less"), 0.999999989, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(95, 99, 153, 203, "less"), 0.924839943, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(58, 10, 235, 101, "less"), 0.997963039, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 46, 4, 8, "less"), 0.688339921, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 139, 6, 178, "less"), 0.999999997, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(57, 131, 180, 89, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(109, 41, 171, 17, "less"), 0.000008568, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(225, 175, 127, 207, "less"), 0.999999732, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(77, 27, 103, 201, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(76, 189, 188, 40, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(70, 94, 182, 48, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(194, 70, 96, 87, "less"), 0.999998487, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(58, 80, 42, 200, "less"), 0.999999944, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(131, 22, 168, 43, "less"), 0.947839409, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(195, 64, 92, 72, "less"), 0.999986702, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(29, 213, 211, 144, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(198, 229, 140, 236, "less"), 0.996445293, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 133, 221, 10, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(245, 10, 179, 37, "less"), 0.999999741, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(99, 190, 45, 204, "less"), 0.999993866, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(75, 64, 121, 190, "less"), 0.998936508, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(232, 13, 206, 111, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(112, 197, 1, 145, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(122, 154, 235, 147, "less"), 0.000007632, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(211, 234, 204, 241, "less"), 0.704541369, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(54, 77, 175, 172, "less"), 0.044776942, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(164, 225, 65, 189, "less"), 0.999995119, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(201, 216, 125, 78, "less"), 0.001130014, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(116, 15, 77, 15, "less"), 0.892876934, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(59, 99, 34, 224, "less"), 0.999999997, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(54, 58, 54, 105, "less"), 0.993487549, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(155, 230, 30, 136, "less"), 0.999999952, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(201, 38, 242, 105, "less"), 0.999983512, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(71, 97, 150, 227, "less"), 0.738567805, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(192, 65, 126, 59, "less"), 0.948215185, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(225, 60, 223, 100, "less"), 0.997970832, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(157, 103, 208, 141, "less"), 0.609696074, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(126, 189, 224, 132, "less"), 0.000000002, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(104, 95, 167, 44, "less"), 0.000000006, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(211, 99, 51, 55, "less"), 0.999911059, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 92, 204, 198, "less"), 0.000017671, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(85, 141, 222, 146, "less"), 0.000000054, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(153, 43, 148, 28, "less"), 0.088918305, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(69, 90, 125, 205, "less"), 0.897193316, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 7, 155, 14, "less"), 0.025994248, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(98, 172, 69, 198, "less"), 0.996683206, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(76, 229, 13, 103, "less"), 0.999619509, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(63, 10, 150, 135, "less"), 0.999999993, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(50, 156, 111, 107, "less"), 0.000000011, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(224, 211, 134, 116, "less"), 0.325840873, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(208, 154, 162, 219, "less"), 0.999983499, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(164, 130, 191, 154, "less"), 0.573817274, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(62, 135, 182, 247, "less"), 0.005579296, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(240, 180, 123, 202, "less"), 0.999999948, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(121, 3, 142, 31, "less"), 0.999998927, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(236, 221, 12, 40, "less"), 0.999984099, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(99, 37, 92, 73, "less"), 0.999302889, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(92, 49, 74, 103, "less"), 0.999991247, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(55, 62, 141, 221, "less"), 0.949995113, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(52, 6, 235, 166, "less"), 0.999999855, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 90, 13, 160, "less"), 0.019966848, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(150, 56, 138, 49, "less"), 0.458377713, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 135, 31, 103, "less"), 0.005467647, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(171, 221, 101, 79, "less"), 0.003594959, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(75, 83, 213, 189, "less"), 0.139718722, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 143, 43, 208, "less"), 0.000107843, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(137, 174, 178, 228, "less"), 0.552589071, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 76, 38, 38, "less"), 0.000019855, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(110, 224, 48, 211, "less"), 0.999977238, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 3, 164, 89, "less"), 0.132436154, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(57, 177, 47, 27, "less"), 0.000000001, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(74, 120, 73, 246, "less"), 0.999921033, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 37, 197, 186, "less"), 0.000001165, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(203, 163, 209, 91, "less"), 0.000112279, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(120, 5, 53, 20, "less"), 0.999999671, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(174, 62, 132, 137, "less"), 0.999999997, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(134, 196, 12, 79, "less"), 0.999999943, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(124, 88, 210, 149, "less"), 0.534016075, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(57, 1, 88, 17, "less"), 0.999794002, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(201, 62, 235, 159, "less"), 0.999997914, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(132, 51, 23, 6, "less"), 0.285592390, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(248, 146, 223, 169, "less"), 0.964515407, 1e-8);

		//up to size 2500:
		F_EQUAL2(BasicStatistics::fishersExactTest(1445, 341, 1710, 1596, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(397, 613, 1330, 998, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2275, 454, 1095, 1742, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2246, 1125, 902, 1668, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1391, 643, 2134, 670, "less"), 0.000000002, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(559, 1982, 805, 727, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1168, 41, 469, 2082, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(827, 1406, 2349, 2162, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1160, 1659, 1011, 1444, "less"), 0.501770516, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1945, 936, 745, 1145, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1578, 462, 673, 538, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1639, 1639, 304, 1190, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1295, 2362, 668, 2000, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1581, 740, 1655, 928, "less"), 0.998723867, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(438, 1603, 779, 2199, "less"), 0.000072886, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1525, 1134, 2113, 2006, "less"), 0.999999544, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(176, 501, 1146, 2075, "less"), 0.000000706, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1608, 349, 1785, 364, "less"), 0.237197401, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(214, 180, 1350, 2044, "less"), 0.999999986, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(888, 887, 472, 382, "less"), 0.006599103, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(482, 211, 2362, 1309, "less"), 0.996581962, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1257, 825, 2420, 1628, "less"), 0.682650777, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(836, 1528, 1206, 1786, "less"), 0.000119021, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1685, 1769, 58, 74, "less"), 0.881446520, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(694, 2349, 223, 661, "less"), 0.073919079, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2332, 2232, 2486, 1993, "less"), 0.000014562, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(815, 753, 2490, 2046, "less"), 0.024530342, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(781, 1559, 583, 1303, "less"), 0.958825967, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1176, 746, 2109, 1612, "less"), 0.999495472, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(568, 1853, 672, 2327, "less"), 0.829170131, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1126, 182, 1417, 161, "less"), 0.001336643, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(360, 341, 1708, 1431, "less"), 0.077010850, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1449, 1928, 1317, 1326, "less"), 0.000000051, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1563, 2060, 1431, 2483, "less"), 0.999999998, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(452, 423, 759, 725, "less"), 0.611287331, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1131, 1905, 1804, 2283, "less"), 0.000000003, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1561, 2222, 1139, 1298, "less"), 0.000012054, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1550, 1063, 679, 592, "less"), 0.999780883, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1378, 923, 2272, 1175, "less"), 0.000001984, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(366, 368, 1907, 1499, "less"), 0.001444354, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1970, 2419, 1044, 954, "less"), 0.000000027, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(157, 463, 754, 1537, "less"), 0.000151012, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1535, 1592, 350, 244, "less"), 0.000006498, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(444, 880, 748, 1508, "less"), 0.606353693, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(32, 67, 2403, 2361, "less"), 0.000233819, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2156, 2420, 1154, 1132, "less"), 0.004607129, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2499, 819, 1641, 661, "less"), 0.999658611, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(65, 195, 1130, 1441, "less"), 0.000000001, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1963, 1482, 2410, 2158, "less"), 0.999922542, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2080, 169, 715, 108, "less"), 0.999998798, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1353, 1719, 1324, 2003, "less"), 0.999736288, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1111, 913, 983, 912, "less"), 0.972874412, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1577, 1327, 1780, 1205, "less"), 0.000020416, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1902, 2165, 1296, 1534, "less"), 0.794012997, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2209, 2013, 2062, 2169, "less"), 0.999548167, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2249, 918, 701, 184, "less"), 0.000000490, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1239, 1891, 906, 1269, "less"), 0.069096827, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1097, 2203, 328, 954, "less"), 0.999999846, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1629, 1245, 1556, 1061, "less"), 0.019929418, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(473, 705, 885, 1681, "less"), 0.999627213, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2007, 2255, 1177, 1306, "less"), 0.412079891, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2432, 2332, 1180, 1418, "less"), 0.999998295, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1792, 1737, 1286, 1482, "less"), 0.999697927, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1998, 1811, 2411, 1821, "less"), 0.000026656, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(907, 457, 1376, 896, "less"), 0.999857825, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1159, 2180, 332, 958, "less"), 0.999999999, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(972, 630, 1589, 1479, "less"), 0.999999997, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2485, 338, 543, 67, "less"), 0.270717324, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(687, 1167, 549, 1311, "less"), 0.999999553, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1933, 1251, 1265, 955, "less"), 0.997192781, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(851, 1828, 829, 2266, "less"), 0.999985509, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2258, 2427, 1759, 1983, "less"), 0.866103363, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(606, 1290, 1460, 2182, "less"), 0.000000001, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1372, 1567, 2063, 1887, "less"), 0.000002954, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1239, 922, 2282, 1995, "less"), 0.998886751, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1805, 1168, 2070, 1353, "less"), 0.587562980, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1520, 1899, 2067, 2042, "less"), 0.000000237, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(841, 450, 2222, 1309, "less"), 0.926495486, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1083, 755, 2416, 2203, "less"), 0.999999394, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(785, 2358, 375, 982, "less"), 0.033731864, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(873, 243, 1796, 626, "less"), 0.996256167, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(735, 605, 2033, 2042, "less"), 0.999277014, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1168, 713, 2447, 1773, "less"), 0.998858251, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1236, 1045, 1330, 1201, "less"), 0.878282600, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(227, 819, 89, 182, "less"), 0.000126025, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(31, 237, 158, 1407, "less"), 0.801426673, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2097, 1710, 2284, 2018, "less"), 0.965466181, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2049, 2094, 712, 744, "less"), 0.653693352, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1340, 360, 2101, 798, "less"), 0.999999426, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1812, 1246, 2396, 1680, "less"), 0.664457635, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1693, 1023, 1897, 1186, "less"), 0.743966420, 1e-8);

		//up to size 25000:
		F_EQUAL2(BasicStatistics::fishersExactTest(22102, 19601, 17306, 6027, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14746, 6169, 18750, 6561, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18018, 12600, 4382, 4503, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11557, 278, 17606, 2316, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2561, 23776, 16840, 23763, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10596, 12532, 3880, 23127, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10597, 24316, 19684, 10881, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24846, 6870, 9670, 7937, "less"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23268, 18544, 17908, 428, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2921, 19481, 22357, 19128, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5399, 7538, 10632, 12015, "less"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9378, 11868, 8563, 9649, "less"), 0.000000006, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4713, 14135, 4766, 12406, "less"), 0.000000002, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5954, 1795, 18407, 4927, "less"), 0.000084572, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16042, 16240, 23403, 22021, "less"), 0.000000265, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16278, 10754, 19277, 14013, "less"), 0.999999996, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21335, 15535, 24756, 18045, "less"), 0.532050060, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4258, 14588, 5033, 18040, "less"), 0.972859266, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17922, 2713, 9255, 1246, "less"), 0.000671946, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16033, 20272, 17902, 23888, "less"), 0.999904181, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22018, 676, 21444, 761, "less"), 0.996794839, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14956, 15116, 19736, 19075, "less"), 0.001854625, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(13334, 10835, 2209, 1673, "less"), 0.022675939, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11352, 23028, 8400, 18319, "less"), 0.999983757, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22428, 17988, 5907, 4829, "less"), 0.812250246, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8770, 4118, 13246, 6281, "less"), 0.660910378, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19613, 8610, 9273, 3578, "less"), 0.000000020, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(13412, 18408, 10410, 15279, "less"), 0.999960231, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1632, 14598, 1146, 9420, "less"), 0.020137166, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23891, 22098, 12555, 11762, "less"), 0.791809400, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14308, 19285, 3642, 4583, "less"), 0.002921224, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17476, 9018, 24140, 12962, "less"), 0.990796029, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15174, 19213, 1660, 2457, "less"), 0.999998585, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15778, 20701, 12014, 16806, "less"), 0.999971808, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17030, 5648, 13386, 3950, "less"), 0.000000439, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18996, 5953, 23075, 7430, "less"), 0.914354862, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18031, 11376, 15333, 9958, "less"), 0.951132669, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10944, 11242, 21064, 20376, "less"), 0.000157824, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14577, 6978, 23355, 12181, "less"), 0.999998616, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15536, 8948, 21274, 12931, "less"), 0.999088907, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21977, 19373, 24434, 22981, "less"), 0.999999271, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23922, 21034, 20882, 17502, "less"), 0.000301722, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21296, 16495, 19186, 15810, "less"), 0.999983714, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18364, 21849, 6964, 7506, "less"), 0.000000191, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9449, 13549, 4804, 7411, "less"), 0.999340108, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15169, 3906, 9279, 2349, "less"), 0.285361951, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16681, 6577, 2833, 1328, "less"), 0.999998989, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23948, 13008, 17387, 9848, "less"), 0.994134280, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8852, 7554, 4728, 3873, "less"), 0.064683206, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17735, 14982, 22524, 19973, "less"), 0.999507812, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15820, 9238, 18981, 11163, "less"), 0.659295037, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23271, 9543, 15028, 5904, "less"), 0.014597161, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17256, 23650, 9215, 12881, "less"), 0.879732758, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16689, 13539, 24832, 18854, "less"), 0.000005749, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7307, 15111, 3276, 6472, "less"), 0.039020312, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10037, 7695, 17165, 12920, "less"), 0.170388873, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3171, 6807, 10778, 23092, "less"), 0.473818560, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16469, 9248, 8810, 5237, "less"), 0.995684680, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6808, 9217, 16850, 23983, "less"), 0.996080540, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18742, 2757, 8482, 1143, "less"), 0.010019535, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17471, 8314, 568, 340, "less"), 0.999501602, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14211, 18275, 14326, 19376, "less"), 0.999360559, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7547, 15198, 11239, 22762, "less"), 0.626225979, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19940, 15335, 19732, 16497, "less"), 0.999999986, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(12062, 13007, 12824, 13979, "less"), 0.733509910, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(983, 15310, 1602, 22151, "less"), 0.002307657, 1e-8);

	}

	void fishersExactTest_greater()
	{
		//up to size 10:
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 6, 6, 6, "greater"), 0.984281972, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 0, 1, 7, "greater"), 0.066666667, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 6, 4, 1, "greater"), 0.946078431, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 7, 9, 4, "greater"), 0.999189149, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 10, 4, 8, "greater"), 0.976462896, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 3, 6, 3, "greater"), 0.690045249, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 9, 10, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 5, 4, 10, "greater"), 0.367411495, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 4, 9, 8, "greater"), 0.248952943, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 6, 1, 9, "greater"), 0.669117647, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 0, 5, 6, "greater"), 0.008513932, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 4, 9, 10, "greater"), 0.248952943, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 2, 8, 10, "greater"), 0.223112128, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 9, 9, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 2, 4, 3, "greater"), 0.426573427, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 6, 7, 2, "greater"), 0.930878988, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 1, 4, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 2, 6, 2, "greater"), 0.715384615, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 4, 5, 2, "greater"), 0.840497738, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 7, 10, 2, "greater"), 0.998894295, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 8, 6, 10, "greater"), 0.833104500, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 10, 5, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 2, 8, 8, "greater"), 0.708978328, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 6, 1, 6, "greater"), 0.105572755, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 7, 2, 1, "greater"), 0.876470588, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 10, 3, 3, "greater"), 0.845201238, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 8, 9, 3, "greater"), 0.981296271, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 9, 5, 7, "greater"), 0.609126397, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 5, 6, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 8, 3, 3, "greater"), 0.927925016, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 3, 5, 8, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 6, 5, 9, "greater"), 0.944659443, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 10, 1, 6, "greater"), 0.275317450, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 3, 8, 7, "greater"), 0.418225872, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 5, 1, 7, "greater"), 0.183257919, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 7, 10, 7, "greater"), 0.748110834, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 4, 10, 9, "greater"), 0.285133787, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 2, 8, 6, "greater"), 0.664086687, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 10, 0, 10, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 9, 9, 1, "greater"), 0.999968813, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 10, 0, 6, "greater"), 0.206604747, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 5, 1, 9, "greater"), 0.010718132, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 7, 7, 10, "greater"), 0.839206712, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 10, 10, 10, "greater"), 0.947035891, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 10, 6, 1, "greater"), 0.999535604, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 5, 1, 3, "greater"), 0.866666667, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 0, 8, 9, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 4, 3, 4, "greater"), 0.595182595, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 8, 0, 5, "greater"), 0.083010836, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 10, 0, 6, "greater"), 0.147574819, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 4, 1, 6, "greater"), 0.020897833, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 3, 6, 6, "greater"), 0.464991665, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 10, 5, 1, "greater"), 0.998968008, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 7, 0, 8, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 2, 8, 1, "greater"), 0.995454545, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 9, 9, 9, "greater"), 0.985167567, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 0, 4, 4, "greater"), 0.051282051, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 10, 3, 6, "greater"), 0.448817696, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 8, 1, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 6, 10, 3, "greater"), 0.987818010, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 0, 7, 6, "greater"), 0.214285714, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 9, 10, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 4, 7, 1, "greater"), 0.993006993, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 1, 5, 4, "greater"), 0.097523220, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 8, 4, 7, "greater"), 0.452358999, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 4, 6, 2, "greater"), 0.880090498, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 10, 9, 6, "greater"), 0.947198261, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 9, 6, 4, "greater"), 0.982972136, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 0, 5, 7, "greater"), 0.015718028, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 10, 6, 10, "greater"), 0.951690821, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 0, 6, 5, "greater"), 0.053921569, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 4, 8, 5, "greater"), 0.898219814, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 4, 7, 9, "greater"), 0.123496147, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 3, 4, 4, "greater"), 0.352187029, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 9, 1, 2, "greater"), 0.674019608, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 10, 8, 9, "greater"), 0.560192335, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 1, 6, 9, "greater"), 0.016230314, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 7, 2, 6, "greater"), 0.245510836, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 5, 5, 8, "greater"), 0.690092879, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 8, 1, 6, "greater"), 0.485294118, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 7, 2, 4, "greater"), 0.275253351, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 2, 6, 5, "greater"), 0.903846154, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 4, 8, 3, "greater"), 0.898219814, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 5, 2, 8, "greater"), 0.382352941, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 8, 1, 1, "greater"), 0.981818182, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 10, 1, 6, "greater"), 0.112077295, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 3, 8, 4, "greater"), 0.883484163, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 10, 2, 2, "greater"), 0.846852425, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 7, 1, 4, "greater"), 0.394634777, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 1, 10, 8, "greater"), 0.173729977, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 0, 5, 1, "greater"), 0.461538462, 1e-8);

		//up to size 25:
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 1, 24, 10, "greater"), 0.043811936, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 5, 11, 20, "greater"), 0.000215458, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 17, 4, 18, "greater"), 0.020969169, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 3, 17, 23, "greater"), 0.173137630, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 4, 21, 2, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 11, 17, 16, "greater"), 0.244829919, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 20, 9, 13, "greater"), 0.504995541, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 15, 24, 13, "greater"), 0.869524631, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 9, 7, 25, "greater"), 0.000042178, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6, 22, 25, 8, "greater"), 0.999998095, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 0, 12, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 22, 3, 6, "greater"), 0.252954793, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 3, 1, 5, "greater"), 0.424242424, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 20, 2, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 19, 21, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 0, 20, 21, "greater"), 0.255813953, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 11, 9, 4, "greater"), 0.999508682, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 17, 14, 13, "greater"), 0.992080527, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 4, 11, 21, "greater"), 0.000409645, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 15, 12, 3, "greater"), 0.999984249, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 8, 23, 10, "greater"), 0.519020587, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 4, 17, 19, "greater"), 0.079802352, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 13, 21, 22, "greater"), 0.251497790, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 2, 12, 19, "greater"), 0.006038157, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 11, 14, 3, "greater"), 0.999987725, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 23, 14, 9, "greater"), 0.999775453, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 24, 8, 6, "greater"), 0.982863327, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 10, 16, 3, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 17, 19, 9, "greater"), 0.999995201, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 23, 23, 9, "greater"), 0.999966936, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 10, 4, 13, "greater"), 0.002984075, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 4, 11, 10, "greater"), 0.010440455, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 9, 13, 24, "greater"), 0.046234158, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 22, 15, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 21, 10, 21, "greater"), 0.679204025, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 1, 13, 1, "greater"), 0.991666667, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 2, 25, 7, "greater"), 0.696129001, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22, 12, 6, 25, "greater"), 0.000232381, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 13, 18, 10, "greater"), 0.743704596, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 12, 15, 25, "greater"), 0.887460836, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 3, 11, 20, "greater"), 0.000044275, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 9, 16, 15, "greater"), 0.398613481, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 0, 19, 11, "greater"), 0.645161290, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 21, 1, 6, "greater"), 0.136982416, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 25, 23, 12, "greater"), 0.997570821, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20, 23, 12, 15, "greater"), 0.531471125, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 22, 14, 5, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 17, 18, 25, "greater"), 0.802374977, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 23, 7, 22, "greater"), 0.888213897, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 10, 2, 6, "greater"), 0.079532814, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 24, 12, 19, "greater"), 0.199068788, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 10, 21, 17, "greater"), 0.851482330, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 7, 0, 8, "greater"), 0.000083675, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 24, 8, 3, "greater"), 0.980298402, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 15, 16, 22, "greater"), 0.988123883, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 15, 17, 22, "greater"), 0.769661760, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 17, 2, 16, "greater"), 0.019296399, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 11, 3, 20, "greater"), 0.000029978, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 5, 18, 23, "greater"), 0.005305939, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 4, 11, 12, "greater"), 0.186688914, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3, 3, 1, 20, "greater"), 0.024786325, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(25, 5, 8, 8, "greater"), 0.021441623, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 8, 8, 21, "greater"), 0.054151124, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 5, 1, 9, "greater"), 0.002212052, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 25, 8, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 2, 10, 25, "greater"), 0.090830240, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1, 21, 3, 24, "greater"), 0.917168533, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 23, 20, 16, "greater"), 0.871998178, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 17, 0, 10, "greater"), 0.000660234, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 11, 4, 8, "greater"), 0.392836531, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 1, 0, 13, "greater"), 0.000000068, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 25, 4, 8, "greater"), 0.839488441, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10, 21, 4, 13, "greater"), 0.385841273, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8, 1, 6, 5, "greater"), 0.119195046, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 8, 19, 13, "greater"), 0.995565410, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9, 0, 20, 10, "greater"), 0.047259509, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24, 3, 7, 8, "greater"), 0.004826838, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21, 11, 22, 6, "greater"), 0.919738334, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 14, 20, 14, "greater"), 0.998014907, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 0, 12, 14, "greater"), 0.000084012, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15, 1, 1, 25, "greater"), 0.000000003, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11, 8, 4, 5, "greater"), 0.396376812, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 17, 2, 9, "greater"), 0.075807515, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4, 13, 3, 2, "greater"), 0.979266348, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 12, 14, 17, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(0, 10, 12, 18, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 3, 18, 0, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23, 9, 20, 25, "greater"), 0.014924138, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(12, 9, 23, 5, "greater"), 0.987420524, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16, 21, 7, 4, "greater"), 0.937914561, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7, 23, 8, 5, "greater"), 0.996914879, 1e-8);

		//up to size 250:
		F_EQUAL2(BasicStatistics::fishersExactTest(160, 249, 235, 152, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(207, 132, 30, 161, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(56, 96, 3, 98, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17, 113, 183, 101, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(219, 106, 148, 22, "greater"), 0.999999785, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(63, 164, 50, 109, "greater"), 0.815665307, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(165, 35, 139, 100, "greater"), 0.000000020, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(223, 137, 224, 62, "greater"), 0.999998002, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(168, 240, 120, 230, "greater"), 0.030371916, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(39, 136, 1, 59, "greater"), 0.000037916, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(136, 70, 97, 87, "greater"), 0.005054707, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(193, 20, 219, 129, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 25, 109, 161, "greater"), 0.423331743, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(214, 230, 97, 197, "greater"), 0.000026637, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(177, 31, 119, 31, "greater"), 0.100657808, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(55, 100, 27, 200, "greater"), 0.000000042, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(189, 77, 234, 38, "greater"), 0.999993917, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(105, 160, 192, 107, "greater"), 0.999999999, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(33, 199, 156, 8, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(13, 160, 217, 169, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19, 156, 114, 7, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(107, 107, 10, 135, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18, 147, 58, 98, "greater"), 0.999999996, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(87, 134, 81, 62, "greater"), 0.999581420, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(186, 27, 214, 158, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(241, 217, 228, 12, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(171, 93, 228, 39, "greater"), 0.999999992, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(41, 97, 72, 232, "greater"), 0.110292471, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(229, 35, 142, 6, "greater"), 0.999628909, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(103, 126, 238, 250, "greater"), 0.848086276, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(153, 183, 102, 147, "greater"), 0.154268923, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(219, 77, 241, 63, "greater"), 0.948317772, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(140, 211, 74, 117, "greater"), 0.434040798, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(245, 68, 164, 98, "greater"), 0.000026854, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(186, 112, 146, 41, "greater"), 0.999917315, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(150, 118, 172, 107, "greater"), 0.924539449, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(206, 217, 219, 242, "greater"), 0.386800912, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(132, 83, 185, 32, "greater"), 0.999999997, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(186, 155, 62, 136, "greater"), 0.000000116, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(183, 120, 59, 113, "greater"), 0.000000033, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(134, 162, 142, 221, "greater"), 0.065199973, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(155, 229, 61, 50, "greater"), 0.997673620, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2, 90, 11, 52, "greater"), 0.999910295, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(101, 151, 221, 125, "greater"), 0.999999998, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(199, 200, 124, 242, "greater"), 0.000005074, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(99, 4, 44, 27, "greater"), 0.000000007, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(65, 51, 151, 66, "greater"), 0.994978044, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(126, 60, 68, 73, "greater"), 0.000285499, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(79, 22, 119, 66, "greater"), 0.009949193, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(152, 28, 215, 73, "greater"), 0.007732381, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(99, 58, 191, 172, "greater"), 0.017355301, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(167, 216, 71, 181, "greater"), 0.000052942, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(236, 170, 97, 22, "greater"), 0.999999641, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(76, 109, 71, 222, "greater"), 0.000083776, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(144, 147, 99, 70, "greater"), 0.976348099, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(40, 235, 84, 194, "greater"), 0.999997441, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(172, 42, 154, 48, "greater"), 0.182760527, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(104, 27, 158, 137, "greater"), 0.000000188, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(88, 179, 197, 223, "greater"), 0.999899037, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(72, 10, 124, 31, "greater"), 0.089752663, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(194, 159, 101, 44, "greater"), 0.999227486, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(53, 20, 100, 140, "greater"), 0.000002688, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(146, 241, 48, 108, "greater"), 0.075404858, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(134, 36, 147, 142, "greater"), 0.000000001, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(198, 233, 13, 19, "greater"), 0.346916083, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(156, 29, 90, 1, "greater"), 0.999997382, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(183, 188, 78, 115, "greater"), 0.026936241, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(73, 161, 41, 33, "greater"), 0.999940920, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(49, 19, 156, 99, "greater"), 0.063517435, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(126, 207, 92, 163, "greater"), 0.362916753, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(92, 194, 105, 163, "greater"), 0.964992428, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(205, 89, 217, 34, "greater"), 0.999999351, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(224, 164, 215, 64, "greater"), 0.999999955, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(26, 18, 238, 32, "greater"), 0.999997859, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(96, 229, 95, 171, "greater"), 0.953933640, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5, 79, 109, 230, "greater"), 0.999999988, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(141, 246, 113, 155, "greater"), 0.940641490, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(32, 56, 81, 213, "greater"), 0.073996723, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(86, 134, 178, 219, "greater"), 0.928976365, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(208, 66, 237, 116, "greater"), 0.010125820, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(44, 19, 227, 153, "greater"), 0.081801069, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(63, 232, 110, 233, "greater"), 0.999158882, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(210, 130, 154, 68, "greater"), 0.973914325, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(80, 207, 124, 221, "greater"), 0.987805893, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(226, 103, 151, 44, "greater"), 0.988493081, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(74, 117, 233, 237, "greater"), 0.995676266, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14, 17, 76, 55, "greater"), 0.932371956, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(67, 103, 10, 82, "greater"), 0.000000403, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(214, 125, 90, 67, "greater"), 0.128368200, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(198, 230, 118, 149, "greater"), 0.325105332, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(155, 110, 36, 49, "greater"), 0.006713214, 1e-8);

		//up to size 2500:
		F_EQUAL2(BasicStatistics::fishersExactTest(2200, 1815, 2178, 738, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(872, 1143, 1211, 44, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2496, 313, 1140, 2051, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1557, 1901, 1356, 2434, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2183, 446, 742, 1225, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1884, 810, 1831, 736, "greater"), 0.873017949, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1317, 1090, 1419, 91, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2138, 603, 721, 1648, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(34, 1605, 391, 463, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(461, 1856, 2099, 1334, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(445, 889, 2013, 1825, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(751, 251, 1039, 2183, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(857, 2433, 514, 1686, "greater"), 0.013041054, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(409, 157, 1887, 1208, "greater"), 0.000000132, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1025, 582, 2467, 1757, "greater"), 0.000096662, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2172, 690, 527, 226, "greater"), 0.000623119, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1075, 1486, 544, 520, "greater"), 0.999999807, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1434, 1338, 2060, 2157, "greater"), 0.009830519, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(732, 2434, 340, 1561, "greater"), 0.000004968, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1207, 611, 1469, 601, "greater"), 0.999051069, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1044, 2308, 808, 2332, "greater"), 0.000000774, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1102, 1400, 1346, 1695, "greater"), 0.574941448, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1197, 943, 2060, 1197, "greater"), 0.999999965, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2189, 686, 1427, 445, "greater"), 0.541542435, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2296, 1014, 531, 277, "greater"), 0.025407650, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2274, 2041, 1966, 2054, "greater"), 0.000289880, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1749, 1631, 449, 297, "greater"), 0.999988751, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(782, 177, 1385, 531, "greater"), 0.000000022, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1093, 2190, 1012, 1461, "greater"), 0.999999999, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2086, 1924, 2462, 1990, "greater"), 0.998834381, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(891, 744, 1358, 1535, "greater"), 0.000000603, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2161, 1079, 2138, 1032, "greater"), 0.746341648, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1696, 2209, 861, 1100, "greater"), 0.645835218, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1311, 2435, 1696, 2463, "greater"), 0.999999947, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2274, 1485, 2420, 1776, "greater"), 0.005676397, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(91, 441, 216, 1893, "greater"), 0.000015163, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(839, 1214, 1785, 2481, "greater"), 0.777562388, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1157, 2005, 1395, 2197, "greater"), 0.972874657, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1519, 1192, 1778, 1546, "greater"), 0.025783238, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(927, 1343, 985, 1819, "greater"), 0.000017320, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(168, 16, 1432, 28, "greater"), 0.999998507, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(955, 1410, 445, 606, "greater"), 0.867054218, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(365, 1201, 345, 1410, "greater"), 0.005917427, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1119, 313, 1196, 218, "greater"), 0.999996049, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(996, 2282, 385, 995, "greater"), 0.047988879, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(372, 879, 817, 2008, "greater"), 0.311127795, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2127, 1326, 542, 220, "greater"), 0.999999780, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1155, 1604, 744, 1315, "greater"), 0.000031438, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(571, 1249, 1328, 2286, "greater"), 0.999963567, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1013, 1672, 284, 690, "greater"), 0.000000809, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(512, 294, 921, 450, "greater"), 0.962446999, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1406, 1194, 2012, 1414, "greater"), 0.999860298, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2107, 1615, 2393, 2380, "greater"), 0.000000002, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(831, 2083, 1029, 2479, "greater"), 0.771778464, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1676, 2334, 781, 1313, "greater"), 0.000360632, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(233, 1384, 195, 1392, "greater"), 0.043257098, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1014, 191, 1939, 603, "greater"), 0.000000013, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(561, 1513, 509, 1382, "greater"), 0.477033612, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(361, 2138, 436, 2074, "greater"), 0.997946428, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1328, 1692, 1759, 2146, "greater"), 0.819587479, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(633, 493, 911, 441, "greater"), 0.999999996, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2146, 1589, 2457, 1848, "greater"), 0.373031417, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(787, 1331, 210, 568, "greater"), 0.000000150, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1366, 874, 1836, 1150, "greater"), 0.655299820, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1425, 32, 2095, 42, "greater"), 0.726583352, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(741, 2310, 678, 1740, "greater"), 0.999240576, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1794, 1391, 1050, 915, "greater"), 0.022881213, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1669, 1645, 800, 891, "greater"), 0.022024886, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1154, 1874, 1588, 2384, "greater"), 0.946534921, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1017, 509, 1011, 694, "greater"), 0.000009232, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(190, 298, 906, 1121, "greater"), 0.990931797, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1613, 1367, 650, 589, "greater"), 0.169949235, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1698, 1196, 1171, 1045, "greater"), 0.000017931, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1216, 1031, 85, 80, "greater"), 0.285275059, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1961, 822, 1190, 358, "greater"), 0.999998007, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(743, 1986, 475, 1203, "greater"), 0.792344507, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(576, 526, 1016, 764, "greater"), 0.994780941, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(467, 964, 698, 2136, "greater"), 0.000000024, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(696, 493, 510, 314, "greater"), 0.940403514, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1012, 1941, 972, 1713, "greater"), 0.938708218, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(160, 8, 2069, 99, "greater"), 0.637991444, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2451, 1727, 1973, 1357, "greater"), 0.703744395, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(685, 1481, 452, 682, "greater"), 0.999998949, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(876, 1179, 1437, 1520, "greater"), 0.999986737, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(361, 411, 591, 467, "greater"), 0.999951151, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1337, 1478, 628, 638, "greater"), 0.899973316, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(240, 392, 1148, 2393, "greater"), 0.003856681, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1995, 505, 2013, 437, "greater"), 0.984408023, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2417, 1488, 1751, 1042, "greater"), 0.754619944, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1168, 961, 2229, 2363, "greater"), 0.000000801, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2073, 553, 1239, 325, "greater"), 0.599376912, 1e-8);

		//up to size 25000:
		F_EQUAL2(BasicStatistics::fishersExactTest(8178, 5621, 2860, 1305, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(12867, 7927, 1082, 8826, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(7175, 4822, 16112, 22748, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3365, 7025, 20992, 24611, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24932, 11517, 10105, 22940, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3024, 5626, 11967, 18770, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(230, 249, 23097, 18005, "greater"), 0.999851087, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9160, 12227, 5745, 16463, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3051, 8267, 18216, 10909, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3431, 15782, 20494, 2590, "greater"), 1.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22410, 23160, 18757, 19873, "greater"), 0.036646202, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2514, 12238, 2270, 17889, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20455, 14465, 1415, 16125, "greater"), 0.000000000, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(13838, 1007, 7140, 424, "greater"), 0.999741335, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6073, 12491, 7797, 15325, "greater"), 0.985378581, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1384, 17786, 1950, 20314, "greater"), 0.999999996, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15162, 18010, 19695, 24829, "greater"), 0.000023043, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19330, 16406, 19129, 15075, "greater"), 0.999999481, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2107, 2521, 22401, 24073, "greater"), 0.999758743, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(15376, 16733, 22166, 22515, "greater"), 0.999998808, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3586, 3820, 19829, 22001, "greater"), 0.054622184, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6173, 6147, 19377, 20861, "greater"), 0.000079221, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24793, 23585, 17798, 17604, "greater"), 0.002717759, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3952, 5195, 17251, 21251, "greater"), 0.997295129, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(12388, 7560, 5498, 3580, "greater"), 0.006527793, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22335, 16271, 14938, 11006, "greater"), 0.245879273, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9469, 3192, 22619, 8352, "greater"), 0.000080839, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(1556, 3104, 681, 959, "greater"), 0.999999998, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23977, 21192, 13484, 11400, "greater"), 0.997548610, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(12602, 2132, 2920, 480, "greater"), 0.709396264, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9280, 18836, 8561, 17377, "greater"), 0.503187078, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2189, 6246, 8143, 21995, "greater"), 0.975848636, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6073, 13884, 7804, 20039, "greater"), 0.000000006, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20358, 10271, 22975, 10783, "greater"), 0.999991724, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3823, 21362, 645, 4472, "greater"), 0.000000830, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18057, 23853, 17161, 22699, "greater"), 0.466017357, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(3234, 10504, 1318, 3971, "greater"), 0.977903487, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20997, 23880, 13859, 14401, "greater"), 0.999999999, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(22425, 21185, 23353, 23520, "greater"), 0.000000781, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6931, 14516, 6367, 14054, "greater"), 0.006383413, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(10479, 15576, 1866, 3085, "greater"), 0.000442335, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(18504, 13955, 14711, 11594, "greater"), 0.004347837, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5058, 14598, 7766, 22043, "greater"), 0.789571624, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2015, 1670, 14979, 11269, "greater"), 0.997038908, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16036, 18498, 22944, 24695, "greater"), 0.999999523, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(4076, 1011, 21372, 5707, "greater"), 0.027313579, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16431, 24563, 2123, 3475, "greater"), 0.001018342, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20051, 12538, 9968, 5538, "greater"), 0.999999998, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(5713, 21694, 5876, 20643, "greater"), 0.999900510, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6049, 9814, 15087, 23187, "greater"), 0.997465363, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6437, 9914, 8063, 11731, "greater"), 0.995979001, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(19191, 8698, 10751, 4894, "greater"), 0.423918288, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14123, 24730, 4398, 8292, "greater"), 0.000285206, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8856, 12101, 18911, 24592, "greater"), 0.998260233, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9781, 13390, 13143, 19584, "greater"), 0.000000616, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24508, 23655, 24321, 23628, "greater"), 0.309027905, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21560, 23865, 19393, 22939, "greater"), 0.000000497, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11200, 11466, 21359, 22272, "greater"), 0.132557612, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17234, 6740, 4638, 1597, "greater"), 0.999964345, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8012, 4681, 8004, 4165, "greater"), 0.999994086, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20167, 8653, 13878, 5925, "greater"), 0.601459984, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(24220, 22222, 13735, 13360, "greater"), 0.000069099, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(23366, 7889, 22777, 7630, "greater"), 0.667212821, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(20244, 11358, 7313, 4329, "greater"), 0.008839173, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2525, 6321, 5190, 14108, "greater"), 0.002112861, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2694, 4007, 11670, 16145, "greater"), 0.995729027, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(17370, 23449, 17926, 23103, "greater"), 0.999502816, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6720, 7261, 24354, 23945, "greater"), 0.999999570, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14434, 14093, 19595, 19545, "greater"), 0.086340507, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8990, 20495, 466, 1129, "greater"), 0.147006042, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(9156, 2122, 14906, 3279, "greater"), 0.955875295, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21256, 24545, 7222, 7744, "greater"), 0.999958975, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(13330, 19800, 6134, 8171, "greater"), 0.999999962, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(16873, 21475, 13712, 17660, "greater"), 0.222109582, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(14488, 15824, 18423, 18905, "greater"), 0.999973255, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11319, 6411, 6201, 3751, "greater"), 0.005823874, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(21306, 22670, 22139, 24878, "greater"), 0.000020345, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(12712, 6446, 12618, 6957, "greater"), 0.000046777, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(12686, 8798, 14165, 8936, "greater"), 0.999999523, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(11963, 8909, 22031, 17239, "greater"), 0.002167409, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(8085, 7537, 3363, 3204, "greater"), 0.234353320, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(2455, 14688, 2643, 17796, "greater"), 0.000048228, 1e-8);
		F_EQUAL2(BasicStatistics::fishersExactTest(6427, 12691, 10527, 20567, "greater"), 0.711182123, 1e-8);

	}
};
