#include "ToolBase.h"
#include "VcfToBedpe.h"

class ConcreteTool
		: public ToolBase
{
	Q_OBJECT

public:
	ConcreteTool(int& argc, char *argv[])
		: ToolBase(argc, argv)
	{
	}

	virtual void setup()
	{
		setDescription("Converts a VCF file containing structural variants to BEDPE format.");
		setExtendedDescription({"Input can be MANTA oder DELLY VCF files."});
		addInfile("in", "Input structural variant list in VCF or VCF.GZ format.", false, true);
		addOutfile("out", "Output structural variant list in BEDPE format.", false, true);
		addFlag("no_sort","Do not sort results");

		changeLog(2025, 4,  2, "Improved error handling for input generated by DRAGEN 4.2.");
		changeLog(2023, 3, 23, "Added support for Sniffles, cuteSV and dipdiff.");
		changeLog(2019, 7, 23, "First implementation.");
	}

	virtual void main()
	{
		VcfToBedpe in_file(getInfile("in").toUtf8());
		QString out = getOutfile("out");
		in_file.convert(out);

		if(!getFlag("no_sort"))
		{
			BedpeFile file;
			file.load(out);
			file.sort();
			file.store(out);
		}
	}
};

#include "main.moc"

int main(int argc, char *argv[])
{
	ConcreteTool tool(argc, argv);
	return tool.execute();
}
