### CnvFilterAnnotations tool help
	CnvFilterAnnotations (2025_05-79-g6c060cfd)
	
	Filter a copy-number variant list in TSV format based on variant annotations.
	
	The filter definition file lists one filter per line using the following syntax:
	name[tab]param1=value[tab]param2=value...
	
	The order in the filter definition file defines the order in which the filters are applied.
	
	Several of the filters offer more than one action:
	  FILTER - Remove variants if they do not match the filter.
	  REMOVE - Remove variants if they match the filter.
	  KEEP - Force variants to be kept, even if filtered out by previous filter steps.
	
	The following filters are supported:
	CNV OMIM genes             Filter for OMIM genes i.e. the 'OMIM' column is not empty.
	                           Parameters:
	                             action - Action to perform [default=FILTER] [valid=REMOVE,FILTER]
	CNV allele frequency       Filter for CNV allele frequency in the analyzed cohort.
	                           Parameters:
	                             max_af - Maximum allele frequency [default=0.05] [min=0.0] [max=1.0]
	CNV clonality              Filter based on CNV clonality.
	                           Parameters:
	                             min_clonality - Minimum Clonality of the CNV  [default=0]
	                             max_clonality - Maximum Clonality of the CNV  [default=1]
	CNV compound-heterozygous  Filter for compound-heterozygous CNVs.
	                           Mode 'CNV-CNV' detects genes with two or more CNV hits.
	                           Mode 'CNV-SNV/INDEL' detectes genes with exactly one CNV and at least one herozygous small variant hit (after other filters are applied).
	                           Mode 'CNV-SNV/INDEL multi-hit' detectes genes with exactly one or more CNVs and at least one herozygous small variant hit (after other filters are applied).
	                           Parameters:
	                             mode - Compound-heterozygotes detection mode. [default=n/a] [valid=n/a,CNV-CNV,CNV-SNV/INDEL,CNV-SNV/INDEL multi-hit]
	CNV copy-number            Filter for CNV copy number.
	                           Parameters:
	                             cn - Copy number [valid=0,1,2,3,4,5+] [non-empty]
	CNV gene constraint        Filter based on gene constraint (gnomAD o/e score for LOF variants).
	                           Note that gene constraint is most helpful for early-onset severe diseases.
	                           For details on gnomAD o/e, see https://macarthurlab.org/2018/10/17/gnomad-v2-1/
	                           Parameters:
	                             max_oe_lof - Maximum gnomAD o/e score for LoF variants [default=0.35] [min=0.0] [max=1.0]
	CNV gene overlap           Filter based on gene overlap.
	                           Parameters:
	                             complete - Overlaps the complete gene. [default=true]
	                             exonic/splicing - Overlaps the coding or splicing region of the gene. [default=true]
	                             intronic/intergenic - Overlaps the intronic/intergenic region of the gene only. [default=false]
	CNV log-likelihood         Filter for CNV log-likelihood.
	                           The log-likelihood is the logarithm of the ratio between likelihoods of the no CN change model vs the CN equal to the reported state model (bigger is better). If scale by region is checked the total log-likelihood value is normalized by the number of regions.
	                           Note: when applied to multi-sample CNV lists, each log-likelihood entry must exceed the cutuff!
	                           Note: this filter works for CNV lists generated by ClinCNV only!
	                           Note: log-likelihood scaling can only be applied to CNV lists with regions count
	                           Parameters:
	                             min_ll - Minimum log-likelihood [default=20] [min=0.0]
	                             scale_by_regions - Scale log-likelihood by number of regions. [default=false]
	CNV maximum log-likelihood Filter for maximum log-likelihood
	                           Can be used to display artefact CNVs only
	                           Works only for tumor-normal pairs
	                           Parameters:
	                             max_ll - Maixmum log-likelihood [default=200] [min=0.0]
	                             scale_by_regions - Scale log-likelihood by number of regions. [default=false]
	CNV pathogenic CNV overlap Filter for overlap with pathogenic CNVs from the NGSD i.e. the 'ngsd_pathogenic_cnvs' column is not empty.
	CNV polymorphism region    Filter for overlap with CNP regions.
	                           Parameters:
	                             column - CNP column name [default=overlap af_genomes_imgag]
	                             max_ol - Maximum overlap [default=0.95] [min=0.0] [max=1.0]
	CNV q-value                Filter for CNV q-value.
	                           The q-value is the p-value corrected for the number of CNVs detected (smaller is better)
	                           Note: when applied to multi-sample CNV lists, each q-value must be below the cutuff!
	                           Note: this filter works for CNV lists generated by ClinCNV only!
	                           Parameters:
	                             max_q - Maximum q-value [default=1] [min=0.0] [max=1.0]
	CNV regions                Filter for number of regions/exons.
	                           Parameters:
	                             regions - Minimum number of regions [default=3] [min=1]
	CNV size                   Filter for CNV size (kilobases).
	                           Parameters:
	                             size - Minimum CNV size in kilobases [default=0] [min=0]
	CNV tumor CN change        Filter based on CNV tumor copy number.
	                           Parameters:
	                             min_tumor_cn - Minimum tumor copy number of the CNV [default=0]
	                             max_tumor_cn - Maximum tumor copy number of the CNV. [default=10]
	
	Mandatory parameters:
	  -in <file>        Input CNV list in TSV format.
	  -out <file>       Output CNV list in TSV format.
	  -filters <file>   Filter definition file.
	
	Special parameters:
	  --help            Shows this help and exits.
	  --version         Prints version and exits.
	  --changelog       Prints changeloge and exits.
	  --tdx             Writes a Tool Definition Xml file. The file name is the application name with the suffix '.tdx'.
	  --settings [file] Settings override file (no other settings files are used).
	
### CnvFilterAnnotations changelog
	CnvFilterAnnotations 2025_05-79-g6c060cfd
	
	2020-05-25 Initial version of the tool. Based on VariantFilterAnnotations.
[back to ngs-bits](https://github.com/imgag/ngs-bits)