from convert_spectra_to_spec1dfits import *
from astropy.io import ascii
import astropy.units as u
import requests
from datetime import date

table='/Users/jolie/gitlocation/SIMPLE-db/scripts/spectra_convert/not_working_txt_table_2022-12-16.dat'
data = ascii.read(table)

date = date.today()

filename = []
source = []
spectrum = []


def text_spectrum_loader(spectrum_path):
        spectrum_table = ascii.read(spectrum_path)
        spectrum_table['flux_density'].name = 'flux'
        spectrum_table['error'].name = 'flux_uncertainty'
        spectrum_table['wavelength'].unit = u.um
        return spectrum_table

for row in data:
    spectrum_path = (row['spectrum']) #use column names to index
    try:
        requests.get(spectrum_path)
        dat = ascii.read(spectrum_path)
        original_header_dict = dat.meta['keywords']
        if original_header_dict['AOT_TYPE']['value'] == 'IrsStare' :
            insturment = "IRS"
        else:
            insturment = None
        dataset_dict = {
            'loader_function': text_spectrum_loader,
            'file_path': spectrum_path,
            'fits_data_dir': '/Users/jolie/gitlocation/SIMPLE-db/scripts/spectra_convert/data/',  # Path of FITS output
            # Information about new spectra
            'vopub': 'SIMPLE Archive',  # SIMPLE Archive, if going to be served via SIMPLE
            'generated_history': 'This file generated by convert_ipac_txt.py',
            'object_name' : row['source'],
            'telescope': original_header_dict['TELESCOP']['value'],
            'instrument': insturment,
            'generated_filename':f"{row['source'].replace(' ','')}_{row['reference'].replace(' ','')} "    #row['source'].replace(' ',''), #Add reference as a suffix from table
             #

        }

        filename.append(dataset_dict['generated_filename'])
        source.append(dataset_dict['object_name'])
        spectrum.append(dataset_dict['file_path'])

        new_dict = {**original_header_dict, **dataset_dict} #header dictionary shoudl go first bc new info goes at bottom

        convert_to_fits(new_dict)
    except :
        pass




data_not_working_txt = Table([filename, source, spectrum],
                       names=('file','source','spectrum'))
ascii.write(data_not_working_txt, f'converted_ipac_txt_files_{date}.dat', overwrite=False)

