# SIMPLE
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.13937301.svg)](https://doi.org/10.5281/zenodo.13937301)

The vision of the SIMPLE project is to create a *collaborative* database of low-mass stars, brown dwarfs, and directly 
imaged exoplanets: a simple archive of complex objects. The tables and fields currently included in the 
database are described in the [Documentation](documentation/README.md) 
and currently include names, coordinates, photometry and reference and data provenance information and is visualized 
in the [schema](#simple-database-schema) below. 
The archive includes kinematics, spectra, modeled and retrieved parameters. 

There are several different methods to interact with the database, including: 
- Python
- a website and API at https://simple-bd-archive.org/
- database browsers such as [DB Browser for SQLite](https://sqlitebrowser.org/)

To report missing data, data bugs or make feature requests, please use the [SIMPLE-db issue tracker](https://github.com/SIMPLE-AstroDB/SIMPLE-db/issues).

For day-to-day discussions, please join us in the #simple-db-dev channel in the [Astropy Slack workspace](https://astropy.slack.com/).
If you are not already in the Astropy Slack, [request an account](http://joinslack.astropy.org/).

To see more details about how this project got started and our initial discussions, check out the [archived running notes in the Wiki](https://github.com/SIMPLE-AstroDB/SIMPLE-db/wiki/Original-Notes).

## Getting Started

If you'd like to set up your own copy of the SIMPLE database, here's what we recommend:

1. Clone or download a copy of this repo locally onto your computer.
 
2. Set up an environment for the Python code and install dependencies. 
We recommend using a conda environment to handle python dependencies. The following commands will use that file to create and activate an 
   environment called `simple-db`. Run these commands at the terminal command prompt
    ```bash
    conda  create -n "simple-db" python=3.10
    conda activate simple-db
    pip install -e .
    ```
   
3. In Python, connect a database file `SIMPLE.sqlite` as a Database object called `db` and recreate the database using the JSON files in the `data/` directory. Run these commands from within Python. 
   ```python
   from astrodb_utils import load_astrodb
   from simple import REFERENCE_TABLES

   SCHEMA_PATH = "simple/schema.yaml"   
   db = load_astrodb(
        "SIMPLE.sqlite", 
        recreatedb=True,  
        reference_tables=REFERENCE_TABLES, 
        felis_schema=SCHEMA_PATH
        )
    ```

    This step generates a "SIMPLE.sqlite" file which can be opened, explored, and modified using a variety of tools.

4. Use `astrodbkit` to [explore](https://astrodbkit.readthedocs.io/en/latest/#exploring-the-schema), [query](https://astrodbkit.readthedocs.io/en/latest/#querying-the-database), and/or [modify](https://astrodbkit.readthedocs.io/en/latest/#modifying-data) the database.
For example:
    - Find all objects in the database with "0141" in the name
        ```python
        db.search_object('0141', fmt='astropy')
        ```
    
    - See all the data in the database for 2MASS J01415823-4633574

        ```python
        db.inventory('2MASS J01415823-4633574', pretty_print=True)
        ```
        
5. The database can also be modified using helper scripts found in [`simple/utils`](simple/utils) and in the [`astrodb_utils`](https://github.com/astrodbtoolkit/astrodb_utils) package. Previously used scripts to modify and/or update the database are stored in the [`scripts/`](scripts) directory and can be used for inspiration.

## Contributor Instructions
If you've made changes to the SIMPLE Archive that you would like to contribute to the public version, here's how to make a contribution.

1. If you've made changes to the database contents, write out the new/modified JSON files:
    ```python
    db.save_database(directory="data/")
    ```

2. (Optional, but highly recommended) Run and modify tests as necessary
    ```bash
    pytest
    ```

3. Open a pull request with the modified JSON files and optionally, your ingest script.


## SIMPLE Database Schema

The schema for the SIMPLE database is described
in the [Documentation](documentation) and can be found in [`simple/schema.yaml`](simple/schema.yaml).

A graphical representation of the SIMPLE schema:
<img src="https://github.com/SIMPLE-AstroDB/SIMPLE-db/blob/main/documentation/figures/auto_schema.png?raw=true" width=75%>
