# Analyses

The following are analyses on EMU performance in the field associated with our paper.

## List of Analyses
* **[Calibration](Analyses/Calibration/Calibration.md)** - Calibration of soil moisture and light sensors.
* **[Sensor Comparisons](Analyses/Fenton%20Hypotheses/Sensor-Comparison.md)** - Comparisons of EMU temperature and humidity readings with those from iButtons and Hobos.
* **[Hypotheses](Analyses/Fenton%20Hypotheses/Fenton_Hypotheses.md)** - A qualitative analysis of how our microenvironmental data matched *a priori* hypotheses for differences between and within transects.
* **[Transect Comparison Models](Analyses/Fenton%20Hypotheses/Transect_Comparison_Models.md)** - A quantitative analysis of the microenvironmental differences between the woods and meadow transects.
* **[Within-Transect Models](Analyses/Fenton%20Hypotheses/Within-Transect_Models.md)** - A quantitative analysis of the microenvironmental differences within transects.
* **[Paired T-Tests](Analyses/Fenton%20Hypotheses/Paired-T-tests.md)** - An alternative analysis of between-transect differences

# Datasets

The following is a list of datasets we collected and use in our analyses.

## List of Datasets
* **[Fenton_soil_calibration.csv](Data/Fenton-soil/Fenton_soil_calibration.csv)** - Data used for soil moisture sensor calibration (from weighing soil every 5 minutes to measure water content).
* **[licor-calibration.csv](Data/licor-calibration/licor-calibration.csv)** - Data used for light sensor calibration (from comparing with LiCor LI-190)
* **[Field Data](Data/EMU-6-21)** - Data collected from EMUs, 
  * [fentondata-all.csv](Data/EMU-6-21/fentondata-all.csv) - Data from all sensor types and transects combined
  * [ibuttons-combined.csv](Data/EMU-6-21/ibuttons-combined.csv) - Data from the two iButtons
  * Data files prefixed with FM are Hobo Pendant data from the meadow transect
  * Data files prefixed with FW are Hobo Pendant data from the woods transect
  * Data files prefixed by a name are EMU data
