---
title: Reference
---

## Glossary
Please check our [jargon busting](episodes/00-introduction.html#jargon-busting) section for the glossary of terms we use in this course.


## Reference and further reading {#litref}
The content of this course borrows from or references the following work, which we also recommend for further reading.

- [Reproducible research through reusable code][nesc-ttw-guide-reproducible-research] is a one day course by the [Netherlands eScience Center][nesc] which discusses similar themes to this course, but in a shorter format.

- [A Beginner's Guide to Conducting Reproducible Research][beginner-guide-reproducible-research], 
Jesse M. Alston, Jessica A. Rick, Bulletin of The Ecological Society of America 102 (2) (2021), https://doi.org/10.1002/bes2.1801

- The Turing Way Community. (2022). [The Turing Way: A handbook for reproducible, ethical and collaborative research][ttw-handbook]. Zenodo. https://doi.org/10.5281/zenodo.3233853

- [The Turing Way's "Guide for Reproducible Research"][ttw-guide-reproducible-research], online book - 
part of the [The Turing Way: A handbook for reproducible, ethical and collaborative research][ttw-handbook]

- ["Ten reproducible research things" tutorial][10-reproducible-research-things]

- [Reproducibility for Everyone's (R4E) resources][repro4everyone], community-led education initiative to increase
    adoption of open research practices at scale

- [FORCE11's FAIR 4 Research Software (FAIR4RS) Working Group][fair4rs-working-group]

- Gallagher K, Creswell R, Lambert B, Robinson M, Lok Lei C, Mirams GR, et al. (2024) Ten simple rules for training scientists to make better software. PLoS Comput Biol 20(9): e1012410. [https://doi.org/10.1371/journal.pcbi.1012410][10-rules-better-software] 

- [Training materials on different aspects of research software engineering][intersect-rse-training] 
(including open source, reproducibility, research software testing, engineering, design, continuous integration, 
collaboration, version control, packaging,  etc.), compiled 
by the [INTERSECT project](https://intersect-training.org/)

- [Automating assessment of the FAIR Principles for Research Software (FAIR4RS)][automated-assessment-fairrs]

- ["Good Enough Practices in Scientific Computing" course][good-enough-practices]

- [CodeRefinery][coderefinery] - training and e-Infrastructure for research software development

- [Curated resources][forrt-resources] by the 
[Framework for Open and Reproducible Research Training](https://forrt.org/) (FORRT)

- Simon Hettrick. (2018). softwaresaved/software_in_research_survey_2014: Software in research survey (1.0). 
Zenodo. https://doi.org/10.5281/zenodo.1183562 - also see the [related blogpost][ssi-survey-2014]

- Barker, M., Chue Hong, N.P., Katz, D.S. et al. 
[Introducing the FAIR Principles for research software][fair-principles-research-software]. 
Sci Data 9, 622 (2022). https://doi.org/10.1038/s41597-022-01710-x

- Wilkinson, M., Dumontier, M., Aalbersberg, I. et al. 
[The FAIR Guiding Principles for scientific data management and stewardship][fair-data-principles]. 
Sci Data 3, 160018 (2016). https://doi.org/10.1038/sdata.2016.18.

- [CodeRefinery: Reproducible research - preparing code to be usable by you and others in the future][coderefinery-tools]
  
- [The FAIR Cookbook][fair-cookbook], online recipes for life scientists that help make and keep data FAIR

- [Top 10 FAIR Data & Software Things][top-10-fair-things-per-domain] - brief guides for different disciplines that 
can be used by the research community to understand how they can make their research (data and software) more FAIR

- [10 easy things to make your research software FAIR][10-easy-fair-things], poster, part of 
[Top 10 FAIR Data & Software Things][top-10-fair-things-per-domain]

- [Five recommendations for FAIR software][5-fair-software-recommendations], by the Netherlands eScience Center and DANS

- [Short online courses on various aspects of research software (including FAIR)][nesc-rs-support-courses], by the NeSC 
Research Software Support 

- [Awesome Research Software Registries][awesome-rs-registries], a list of research software registries 
(by country, organisation, domain and programming language) where research software can be registered to help promote 
its discovery

- [Software Carpentry's Git Novice lesson][swc-git-lesson]
 
- ["How Git Works" course on Pluralsight][how-git-works]

- A [cookiecutter software project template][fair-python-cookiecutter] to kickstart a modern best-practice Python project with FAIR metadata

- A [self-assessment checklist for FAIR research software][fair-rs-checklist], by the Netherlands eScience Center 
and Australian Research Data Commons

- [Open source definition][osd-definition], by the [Open Source Initiative][osd]

- [CODECHECK][codecheck], an approach for independent execution of computations underlying 
research articles

- Carpentries Github Skill ups for [instructors][git-skillup-instructors] and [maintainers][git-skillup-maintainers]

- [RSG Southampton Git lesson][git-soton] - [collaboration section][git-soton-collaboration]

