---
site: sandpaper::sandpaper_site
---

This short course teaches tools and practices for producing and sharing quality, sustainable and [FAIR (Findable, Accessible, Interoperable and Reusable) research software][fair-principles-research-software] to support **open and reproducible research**. 
The course can be delivered over 2 full or 4 half days.

## Target audience

- Post-graduate students, early career researchers or junior Research Software Engineers (RSEs) who are starting their research or software projects, have foundational knowledge of Python, version control and using software tools from command line shell, and want to develop software to support their research using established best practices
- Researchers or scientists who had foundational software training before but wish to refresh, reinforce or improve their skills and practices in the wider context of FAIR research and sharing and writing software for open and reproducible research 

Check out a few example [learner profiles](./profiles/learner-profiles.md), to see if this course is a right fit for you.

::::::::::::::::::::::::::::::::::::::::::  prereq

## Prerequisites

Foundational knowledge of the following is **required** to be able to understand code examples used in the course:

* Python used to write scientific code
* Version control with Git 
* Working in a command line interface (shell)

Attending a [Software Carpentry][swc-lessons] workshop or a similar course will help you gain the skills and experience needed.

Please also make sure you have [all the required software](./index.md#setup) installed before attending this course.

::::::::::::::::::::::::::::::::::::::::::::::::::

## Learning objectives

After attending this training, you **will be able** to:

- List challenges typically faced by researchers developing software and managing data for modern computational, reproducible research, including those commensurate with the FAIR (Findable, Accessible, Interoperable, Reusable) principles.
- Build on top of your existing knowledge of Python, Git and command line computing to enhance your research software development workflow with some good open and reproducible research software practices around structuring, writing, documenting, testing, sharing and reusing code (including software licencing and citation).

## Acknowledgements

This course was originally developed by the [UK's Software Sustainability Institute][ssi] and funded by the [UK Reproducibility Network (UKRN)][ukrn].
See [CITATION.cff][citation] for the full list of authors. 

[ssi]: https:/www.software.ac.uk
[ukrn]: https://www.ukrn.org/
[citation]: https://github.com/carpentries-incubator/better-research-software/blob/main/CITATION.cff

