[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.12666088.svg)](https://zenodo.org/doi/10.5281/zenodo.12666088)


# Building Better Research Software

This short course is teaching tools and practices for producing and sharing quality, 
sustainable and [FAIR (Findable, Accessible, Interoperable and Reusable) research software](https://www.nature.com/articles/s41597-022-01710-x)
to support open and reproducible research. 

The lesson uses the [the example software project that **does not** follow good research software practices](https://github.com/carpentries-incubator/bbrs-software-project)
which gradually gets improved over the course of this lesson following the good software practices we teach. 
The better code the lesson finishes with can be found at [the "final" branch of the software project repository](https://github.com/carpentries-incubator/bbrs-software-project/tree/final).

The course can be delivered over 2 full or 4 half days.

The accompanying [slides](https://docs.google.com/presentation/d/1KahaD7EGxJWXaCDKWAG6Wva4a9zo9Lp-qFyyofgM0vw/edit?usp=sharing) to aid with course delivery are also available.

Launch this lesson on myBinder! 👉 [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/carpentries-incubator/better-research-software/HEAD?urlpath=rstudio)

## Contributing

Please see the [CONTRIBUTING.md](CONTRIBUTING.md) for contributing guidelines and details on how to get involved with this project.

Also see the current list of [issues](https://github.com/carpentries-incubator/better-research-software/issues) for ideas for contributing to this training curriculum. 
Look for the tag ![good_first_issue](https://img.shields.io/badge/-good%20first%20issue-gold.svg).
This indicates that the issue does not require in-depth knowledge of the project and lesson infrastructure, and is a good opportunity for a new contributor to get involved.

To learn more about how this lesson site is built and how you can edit the pages, see [the Introduction to The Carpentries Workbench](https://carpentries.github.io/sandpaper-docs/).

## Author(s)

The list of authors of the course is available in [CITATION.cff](CITATION.cff).

## Maintainer(s)

Current maintainers of this lesson are:

* [Aleksandra Nenadic](https://github.com/anenadic)
* [Aman Goel](https://github.com/amangoel185)
* [Toby Hodges](https://github.com/tobyhodges)

## Citation
Gibson, S., Goel, A., Jaffa, S., Kopec-Harding, K., Nenadic, A., & Sauze, C. (2025). Software practices for open and reproducible research (beta-May-2025). Zenodo. https://doi.org/10.5281/zenodo.15490720

Information on how to cite this work is also available in [CITATION.cff](CITATION.cff).

## Contact

Please get in touch with [Aleksandra Nenadic](a.nenadic@software.ac.uk) with any questions about this lesson.

## Acknowledgements

This work has been supported by the [UK's Software Sustainability Institute][ssi] via the [EPSRC, BBSRC, ESRC, NERC, AHRC, STFC and MRC grant EP/S021779/1](https://gow.epsrc.ukri.org/NGBOViewGrant.aspx?GrantRef=EP/S021779/1)
and [UK Reproducibility Network (UKRN)](https://www.ukrn.org/).


[sandpaper-documentation]: https://carpentries.github.io/sandpaper-docs/
[workbench-markdown-template]: https://github.com/carpentries/workbench-template-md/
[ssi]: https:/www.software.ac.uk
[ukrn]: https://www.ukrn.org/
