| Supported Targets | ESP32-C6 |
| ----------------- | -------- |

# Wifi TWT scheduling latency tester

If you use the content of this repository, please reference the following paper: 
> C. Puligheddu, F. Busacca, R. Rusca, F. Raviglione, C. Casetti, C. F. Chiasserini, S. Palazzo, "Target Wake Time Scheduling for Time-Sensitive Networking in the Industrial IoT," 2024 IEEE 35th International Symposium on Personal, Indoor and Mobile Radio Communications (PIMRC), Valencia, Spain, 2024, pp. 1-7, doi: 10.1109/PIMRC59610.2024.10817339. [URL](https://ieeexplore.ieee.org/document/10817339) [BibTeX](/cite.bib)


## Introduction
This application aims at testing the latency performance of the ESP32-C6 SoC when exchanging traffic scheduled by means of the Target Wake Time (TWT) mechanism.

## Setup

First, setup the software development environment for the hardware based on the ESP32 chip by Espressif. Detailed instructions can be found 
[here](https://docs.espressif.com/projects/esp-idf/en/stable/esp32/get-started/index.html).

Now, clone this folder in the _~/esp_ directory. Then, navigate in the folder _twt-scheduling_, set the ESP32 target, and run the project configuration utility _menuconfig_.

```
cd ~/esp/twt-scheduling
idf.py set-target esp32c6
idf.py menuconfig
```

A graphical interface will appear to set the configuration of the application.
After the configuration is set, build and flash the project.

```
idf.py build
idf.py -p PORT flash
```

