import numpy as np
from ase.build import fcc100
from hiphive import ClusterSpace


def test_translational_constraint_vectors():
    np.random.seed(42)

    # make dummy model
    prim = fcc100('Al', (1, 1, 3), vacuum=10, a=4.0)
    prim.pbc = True
    cs = ClusterSpace(prim, [5.0])
    # get constraint matrix
    cvs = cs._cvs.toarray()

    if False:
        np.set_printoptions(precision=25, threshold=1000000)
        print(repr(cvs))

    cvs_target = np.array(
        [[0.,  0.,  0.,
            -0.7071067811865475,  0., -0.8944271909999159,
            -0.8944271909999159,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            -0.8944271909999159, -0.8944271909999159,  0.,
            0.,  0., -0.9701425001453318,
            0.,  0.,  0.4444444444444445,
            0.,  0.6963106238227913,  0.6963106238227913,
            0.,  0.,  0.8728715609439694,
            0.],
         [0.,  0.,  0.,
            0., -0.7071067811865475,  0.,
            0.,  0., -0.9701425001453318,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            -0.9701425001453318,  0.,  0.,
            0., -0.9701425001453318,  0.,
            0.4444444444444445,  0.,  0.,
            0.8728715609439694,  0.,  0.,
            0.8728715609439694],
         [1.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            -0.7071067811865475,  0.,  0.,
            0., -0.7071067811865475,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0., -0.11111111111111112,
            0., -0.17407765595569782, -0.17407765595569782,
            0.,  0., -0.21821789023599236,
            0.],
         [0.,  1.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  1.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0., -0.8944271909999159,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            -0.11111111111111112,  0.,  0.,
            -0.21821789023599236,  0.,  0.,
            -0.21821789023599236],
         [0.,  0.,  0.,
            0.7071067811865475,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.7071067811865475,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.4472135954999579,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.4472135954999579,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  1.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.24253562503633294,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.7071067811865475,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  1.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  1.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            1.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.7071067811865475,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  1.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            1.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  1.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.4472135954999579,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.4472135954999579,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.4472135954999579,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  1.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.24253562503633294,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  1.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.24253562503633294,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            1.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.24253562503633294,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.888888888888889,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.888888888888889,  0.,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.6963106238227913,  0.,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.6963106238227913,
            0.,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.4364357804719847,  0.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  1.,  0.,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.4364357804719847,
            0.],
         [0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.,  0.,  0.,
            0.4364357804719847]])

    assert np.allclose(cvs, cvs_target)
