import numpy as np
from ase.build import fcc100
from hiphive import ClusterSpace
from hiphive.core.translational_constraints import get_translational_constraint_matrix


def test_translational_constraint_matrix():

    np.random.seed(42)

    # make dummy model
    prim = fcc100('Al', (1, 1, 3), vacuum=10, a=4.0)
    prim.pbc = True
    cs = ClusterSpace(prim, [5.0])
    # get constraint matrix
    M = get_translational_constraint_matrix(cs)
    M = M.to_array()
    if False:
        np.set_printoptions(precision=25, threshold=1000000)
        print(repr(M))

    M_target = np.array(
        [[0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.,   0.,
          0.,   0.],
         [12.5,   0.,   0.,
            50.,   0.,   0.,
            0.,  12.5,   0.,
            25.,  25.,   0.,
            0.,  50.,   0.,
            0.,   0.,  50.,
            0.,   0.,   0.,
            0.,  25.,  25.,
            0.,   0.,   0.,
            50.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [12.5,   0.,   0.,
            50.,   0.,   0.,
            0.,  12.5,   0.,
            25.,  25.,   0.,
            0.,  50.,   0.,
            0.,   0.,  50.,
            0.,   0.,   0.,
            0.,  25.,  25.,
            0.,   0.,   0.,
            50.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.1736111111111111,   0.,
            0.,   0.,   0.,
            0.6944444444444444,   0.,   0.1736111111111111,
            0.,   0.,   0.,
            0.6944444444444444,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            1.3888888888888888,   0.,   0.,
            0.,   0.6944444444444444,   0.,
            0.,   0.,   0.6944444444444444,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            100.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0., 100.,   0.,
            0.,   0., 100.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            12.5,   0.,  25.,
            25.,   0.,   0.,
            50.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            100.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0., 100.,   0.,
            0.,   0., 100.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            12.5,   0.,  25.,
            25.,   0.,   0.,
            50.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.],
         [0.,   0.,   0.,
            0.,   0.,   0.,
            1.3888888888888888,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            2.7777777777777777,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.,   0.,
            0.,   0.1736111111111111,   0.,
            0.,   0.6944444444444444,   0.,
            0.,   0.6944444444444444]])

    assert np.allclose(M, M_target)
